/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Function;
import com.sun.xacml.ctx.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class FunctionBase
implements Function {
    public static final String FUNCTION_NS = "urn:oasis:names:tc:xacml:1.0:function:";
    private static List processingErrList = null;
    private String functionName;
    private int functionId;
    private String returnType;
    private boolean returnsBag;
    private boolean singleType;
    private String paramType;
    private boolean paramIsBag;
    private int numParams;
    private int minParams;
    private String[] paramTypes;
    private boolean[] paramsAreBags;

    public FunctionBase(String string, int n, String string2, boolean bl, int n2, String string3, boolean bl2) {
        this(string, n, string3, bl2);
        this.singleType = true;
        this.paramType = string2;
        this.paramIsBag = bl;
        this.numParams = n2;
        this.minParams = 0;
    }

    public FunctionBase(String string, int n, String string2, boolean bl, int n2, int n3, String string3, boolean bl2) {
        this(string, n, string3, bl2);
        this.singleType = true;
        this.paramType = string2;
        this.paramIsBag = bl;
        this.numParams = n2;
        this.minParams = n3;
    }

    public FunctionBase(String string, int n, String[] stringArray, boolean[] blArray, String string2, boolean bl) {
        this(string, n, string2, bl);
        this.singleType = false;
        this.paramTypes = stringArray;
        this.paramsAreBags = blArray;
    }

    public FunctionBase(String string, int n, String string2, boolean bl) {
        this.functionName = string;
        this.functionId = n;
        this.returnType = string2;
        this.returnsBag = bl;
    }

    public URI getIdentifier() {
        try {
            return new URI(this.functionName);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("invalid URI");
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getFunctionId() {
        return this.functionId;
    }

    public URI getReturnType() {
        try {
            return new URI(this.returnType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean returnsBag() {
        return this.returnsBag;
    }

    public String getReturnTypeAsString() {
        return this.returnType;
    }

    protected static EvaluationResult makeProcessingError(String string) {
        String[] stringArray;
        if (processingErrList == null) {
            stringArray = new String[]{"urn:oasis:names:tc:xacml:1.0:status:processing-error"};
            processingErrList = Arrays.asList(stringArray);
        }
        stringArray = new Status(processingErrList, string);
        EvaluationResult evaluationResult = new EvaluationResult((Status)stringArray);
        return evaluationResult;
    }

    protected EvaluationResult evalArgs(List list, EvaluationCtx evaluationCtx, AttributeValue[] attributeValueArray) {
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Evaluatable evaluatable = (Evaluatable)iterator.next();
            EvaluationResult evaluationResult = evaluatable.evaluate(evaluationCtx);
            if (evaluationResult.indeterminate()) {
                return evaluationResult;
            }
            attributeValueArray[n++] = evaluationResult.getAttributeValue();
        }
        return null;
    }

    public void checkInputs(List list) throws IllegalArgumentException {
        if (this.singleType) {
            if (this.numParams != -1) {
                if (list.size() != this.numParams) {
                    throw new IllegalArgumentException("wrong number of args to " + this.functionName);
                }
            } else if (list.size() < this.minParams) {
                throw new IllegalArgumentException("not enough args to " + this.functionName);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Evaluatable evaluatable = (Evaluatable)iterator.next();
                if (evaluatable.getType().toString().equals(this.paramType) && evaluatable.evaluatesToBag() == this.paramIsBag) continue;
                throw new IllegalArgumentException("illegal parameter");
            }
        } else {
            if (this.paramTypes.length != list.size()) {
                throw new IllegalArgumentException("wrong number of args to " + this.functionName);
            }
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Evaluatable evaluatable = (Evaluatable)iterator.next();
                if (!evaluatable.getType().toString().equals(this.paramTypes[n]) || evaluatable.evaluatesToBag() != this.paramsAreBags[n]) {
                    throw new IllegalArgumentException("illegal parameter");
                }
                ++n;
            }
        }
    }

    public void checkInputsNoBag(List list) throws IllegalArgumentException {
        if (this.singleType) {
            if (this.paramIsBag) {
                throw new IllegalArgumentException(this.functionName + "needs" + "bags on input");
            }
            if (this.numParams != -1) {
                if (list.size() != this.numParams) {
                    throw new IllegalArgumentException("wrong number of args to " + this.functionName);
                }
            } else if (list.size() < this.minParams) {
                throw new IllegalArgumentException("not enough args to " + this.functionName);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Evaluatable evaluatable = (Evaluatable)iterator.next();
                if (evaluatable.getType().toString().equals(this.paramType)) continue;
                throw new IllegalArgumentException("illegal parameter");
            }
        } else {
            if (this.paramTypes.length != list.size()) {
                throw new IllegalArgumentException("wrong number of args to " + this.functionName);
            }
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Evaluatable evaluatable = (Evaluatable)iterator.next();
                if (!evaluatable.getType().toString().equals(this.paramTypes[n]) || this.paramsAreBags[n]) {
                    throw new IllegalArgumentException("illegal parameter");
                }
                ++n;
            }
        }
    }
}

