/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.DateAttribute;
import java.math.BigInteger;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Node;

public class DayTimeDurationAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/TR/2002/WD-xquery-operators-20020816#dayTimeDuration";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private static final String patternString = "(\\-)?P((\\d+)?D)?(T((\\d+)?H)?((\\d+)?M)?((\\d+)?(.(\\d+)?)?S)?)?";
    private static final int GROUP_SIGN = 1;
    private static final int GROUP_DAYS = 3;
    private static final int GROUP_HOURS = 6;
    private static final int GROUP_MINUTES = 8;
    private static final int GROUP_SECONDS = 10;
    private static final int GROUP_NANOSECONDS = 12;
    private static BigInteger big24;
    private static BigInteger big60;
    private static BigInteger big1000;
    private static BigInteger bigMaxLong;
    private static Pattern pattern;
    private boolean negative;
    private long days;
    private long hours;
    private long minutes;
    private long seconds;
    private int nanoseconds;
    private long totalMillis;
    private String encodedValue = null;

    public DayTimeDurationAttribute(boolean bl, long l, long l2, long l3, long l4, int n) throws IllegalArgumentException {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.negative = bl;
        this.days = l;
        this.hours = l2;
        this.minutes = l3;
        this.seconds = l4;
        this.nanoseconds = n;
        if (l > Integer.MAX_VALUE || l2 > Integer.MAX_VALUE || l3 > Integer.MAX_VALUE || l4 > Integer.MAX_VALUE) {
            if (big24 == null) {
                big24 = BigInteger.valueOf(24L);
                big60 = BigInteger.valueOf(60L);
                big1000 = BigInteger.valueOf(1000L);
                bigMaxLong = BigInteger.valueOf(Long.MAX_VALUE);
            }
            BigInteger bigInteger = BigInteger.valueOf(l);
            BigInteger bigInteger2 = BigInteger.valueOf(l2);
            BigInteger bigInteger3 = BigInteger.valueOf(l3);
            BigInteger bigInteger4 = BigInteger.valueOf(l4);
            BigInteger bigInteger5 = bigInteger.multiply(big24).add(bigInteger2).multiply(big60).add(bigInteger3).multiply(big60).add(bigInteger4).multiply(big1000);
            if (bigInteger5.compareTo(bigMaxLong) == 1) {
                throw new IllegalArgumentException("total number of milliseconds exceeds Long.MAX_VALUE");
            }
            this.totalMillis = bigInteger5.longValue();
        } else {
            this.totalMillis = (((l * 24L + l2) * 60L + l3) * 60L + l4) * 1000L;
        }
    }

    public static DayTimeDurationAttribute getInstance(Node node) throws ParsingException, NumberFormatException {
        return DayTimeDurationAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    private static long parseGroup(Matcher matcher, int n) throws NumberFormatException {
        long l = 0L;
        if (matcher.start(n) != -1) {
            String string = matcher.group(n);
            l = Long.parseLong(string);
        }
        return l;
    }

    public static DayTimeDurationAttribute getInstance(String string) throws ParsingException, NumberFormatException {
        Matcher matcher;
        boolean bl;
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n = 0;
        if (pattern == null) {
            try {
                pattern = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new ParsingException("unexpected pattern match error");
            }
        }
        if (!(bl = (matcher = pattern.matcher(string)).matches())) {
            throw new ParsingException("Syntax error in dayTimeDuration");
        }
        if (matcher.start(1) != -1) {
            bl2 = true;
        }
        l = DayTimeDurationAttribute.parseGroup(matcher, 3);
        l2 = DayTimeDurationAttribute.parseGroup(matcher, 6);
        l3 = DayTimeDurationAttribute.parseGroup(matcher, 8);
        l4 = DayTimeDurationAttribute.parseGroup(matcher, 10);
        if (matcher.start(12) != -1) {
            String string2 = matcher.group(12);
            while (string2.length() < 9) {
                string2 = string2 + "0";
            }
            if (string2.length() > 9) {
                string2 = string2.substring(0, 9);
            }
            n = Integer.parseInt(string2);
        }
        if (string.charAt(string.length() - 1) == 'T') {
            throw new ParsingException("'T' must be absent if alltime items are absent");
        }
        return new DayTimeDurationAttribute(bl2, l, l2, l3, l4, n);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getDays() {
        return this.days;
    }

    public long getHours() {
        return this.hours;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public long getTotalSeconds() {
        return this.totalMillis;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DayTimeDurationAttribute)) {
            return false;
        }
        DayTimeDurationAttribute dayTimeDurationAttribute = (DayTimeDurationAttribute)object;
        return this.totalMillis == dayTimeDurationAttribute.totalMillis && this.nanoseconds == dayTimeDurationAttribute.nanoseconds && this.negative == dayTimeDurationAttribute.negative;
    }

    public int hashCode() {
        int n = (int)this.totalMillis ^ (int)(this.totalMillis >> 32);
        n = 31 * n + this.nanoseconds;
        if (this.negative) {
            n = -n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DayTimeDurationAttribute: [\n");
        stringBuffer.append("  Negative: " + this.negative);
        stringBuffer.append("  Days: " + this.days);
        stringBuffer.append("  Hours: " + this.hours);
        stringBuffer.append("  Minutes: " + this.minutes);
        stringBuffer.append("  Seconds: " + this.seconds);
        stringBuffer.append("  Nanoseconds: " + this.nanoseconds);
        stringBuffer.append("  TotalSeconds: " + this.totalMillis);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.negative) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (this.days != 0L) {
            stringBuffer.append(Long.toString(this.days));
            stringBuffer.append('D');
        }
        if (this.hours != 0L || this.minutes != 0L || this.seconds != 0L || this.nanoseconds != 0) {
            stringBuffer.append('T');
        } else if (this.days == 0L) {
            stringBuffer.append("0D");
        }
        if (this.hours != 0L) {
            stringBuffer.append(Long.toString(this.hours));
            stringBuffer.append('H');
        }
        if (this.minutes != 0L) {
            stringBuffer.append(Long.toString(this.minutes));
            stringBuffer.append('M');
        }
        if (this.seconds != 0L || this.nanoseconds != 0) {
            stringBuffer.append(Long.toString(this.seconds));
            if (this.nanoseconds != 0) {
                stringBuffer.append('.');
                stringBuffer.append(DateAttribute.zeroPadInt(this.nanoseconds, 9));
            }
            stringBuffer.append('S');
        }
        this.encodedValue = stringBuffer.toString();
        return this.encodedValue;
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

