/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

class Base64 {
    private static final char SPACE = ' ';
    private static final char ETX = '\u0004';
    private static final char VTAB = '\u000b';
    private static final char FF = '\f';
    private static final char HTAB = '\t';
    private static final char LF = '\n';
    private static final char ALTLF = '\u0013';
    private static final char CR = '\r';
    private static char PAD = (char)61;
    private static final String BASE64EncodingString = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/= \u0004\u000b\f\t\n\u0013\r";
    private static final int PAD_INDEX = 64;
    private static final int MAX_BASE64_CHAR = 122;
    private static int[] Base64DecodeArray = null;
    private static final int NO_CHARS_DECODED = 0;
    private static final int ONE_CHAR_DECODED = 1;
    private static final int TWO_CHARS_DECODED = 2;
    private static final int THREE_CHARS_DECODED = 3;
    private static final int PAD_THREE_READ = 5;
    private static final int PAD_FOUR_READ = 6;
    private static final int MAX_GROUPS_PER_LINE = 19;

    Base64() {
    }

    public static String encode(byte[] byArray) {
        int n = byArray.length;
        int n2 = n * 7 / 5;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 19;
        for (int i = 0; i < n; i += 3) {
            int n4;
            int n5 = byArray[i] >> 2 & 0x3F;
            stringBuffer.append(BASE64EncodingString.charAt(n5));
            int n6 = byArray[i] << 4 & 0x30;
            if (i + 1 < n) {
                n6 |= byArray[i + 1] >> 4 & 0xF;
            }
            stringBuffer.append(BASE64EncodingString.charAt(n6));
            if (i + 1 < n) {
                n4 = byArray[i + 1] << 2 & 0x3C;
                if (i + 2 < n) {
                    n4 |= byArray[i + 2] >> 6 & 3;
                }
            } else {
                n4 = 64;
            }
            stringBuffer.append(BASE64EncodingString.charAt(n4));
            int n7 = i + 2 < n ? byArray[i + 2] & 0x3F : 64;
            stringBuffer.append(BASE64EncodingString.charAt(n7));
            if (--n3 != 0) continue;
            n3 = 19;
            if (i + 3 > n) continue;
            stringBuffer.append('\r');
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private static void initDecodeArray() {
        if (Base64DecodeArray != null) {
            return;
        }
        int[] nArray = new int[123];
        for (int i = 0; i <= 122; ++i) {
            nArray[i] = BASE64EncodingString.indexOf(i);
        }
        Base64DecodeArray = nArray;
    }

    public static byte[] decode(String string, boolean bl) throws IOException {
        int n = string.length();
        int n2 = n / 4 * 3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
        byte[] byArray = new byte[3];
        Base64.initDecodeArray();
        int n3 = 0;
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n4 = c > 'z' ? -1 : Base64DecodeArray[c];
            if (n4 == -1) {
                if (bl) continue;
                throw new IOException("Invalid character");
            }
            if (n4 > 64) continue;
            switch (n3) {
                case 0: {
                    if (n4 == 64) {
                        throw new IOException("Pad character in invalid position");
                    }
                    byArray[0] = (byte)(n4 << 2 & 0xFC);
                    n3 = 1;
                    continue block8;
                }
                case 1: {
                    if (n4 == 64) {
                        throw new IOException("Pad character in invalid position");
                    }
                    byArray[0] = (byte)(byArray[0] | n4 >> 4 & 3);
                    byArray[1] = (byte)(n4 << 4 & 0xF0);
                    n3 = 2;
                    continue block8;
                }
                case 2: {
                    if (n4 == 64) {
                        byteArrayOutputStream.write(byArray, 0, 1);
                        n3 = 5;
                        continue block8;
                    }
                    byArray[1] = (byte)(byArray[1] | n4 >> 2 & 0xF);
                    byArray[2] = (byte)(n4 << 6 & 0xC0);
                    n3 = 3;
                    continue block8;
                }
                case 3: {
                    if (n4 == 64) {
                        byteArrayOutputStream.write(byArray, 0, 2);
                        n3 = 6;
                        continue block8;
                    }
                    byArray[2] = (byte)(byArray[2] | n4);
                    byteArrayOutputStream.write(byArray, 0, 3);
                    n3 = 0;
                    continue block8;
                }
                case 5: {
                    if (n4 != 64) {
                        throw new IOException("Missing pad character");
                    }
                    n3 = 6;
                    continue block8;
                }
                case 6: {
                    throw new IOException("Invalid input follows pad character");
                }
            }
        }
        if (n3 != 0 && n3 != 6) {
            throw new IOException("Invalid sequence of input characters");
        }
        return byteArrayOutputStream.toByteArray();
    }
}

