/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ProcessingException;
import com.sun.xacml.Target;
import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderResult;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class PolicyReference
extends AbstractPolicy {
    public static final int POLICY_REFERENCE = 0;
    public static final int POLICYSET_REFERENCE = 1;
    private URI reference;
    private int policyType;
    private PolicyFinder finder;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$PolicyReference == null ? (class$com$sun$xacml$PolicyReference = PolicyReference.class$("com.sun.xacml.PolicyReference")) : class$com$sun$xacml$PolicyReference).getName());
    static /* synthetic */ Class class$com$sun$xacml$PolicyReference;

    public PolicyReference(URI uRI, int n, PolicyFinder policyFinder) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Input policyType is not avalid value");
        }
        this.reference = uRI;
        this.policyType = n;
        this.finder = policyFinder;
    }

    public static PolicyReference getInstance(Node node, PolicyFinder policyFinder) throws ParsingException {
        int n;
        URI uRI = null;
        String string = node.getNodeName();
        if (string.equals("PolicyIdReference")) {
            n = 0;
        } else if (string.equals("PolicySetIdReference")) {
            n = 1;
        } else {
            throw new ParsingException("Unknown reference type: " + string);
        }
        try {
            uRI = new URI(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            throw new ParsingException("Invalid URI in Reference", exception);
        }
        return new PolicyReference(uRI, n, policyFinder);
    }

    public URI getId() {
        return this.resolvePolicy().getId();
    }

    public CombiningAlgorithm getCombiningAlg() {
        return this.resolvePolicy().getCombiningAlg();
    }

    public String getDescription() {
        return this.resolvePolicy().getDescription();
    }

    public Target getTarget() {
        return this.resolvePolicy().getTarget();
    }

    public String getDefaultVersion() {
        return this.resolvePolicy().getDefaultVersion();
    }

    public List getChildren() {
        return this.resolvePolicy().getChildren();
    }

    public Set getObligations() {
        return this.resolvePolicy().getObligations();
    }

    public MatchResult match(EvaluationCtx evaluationCtx) {
        try {
            return this.getTarget().match(evaluationCtx);
        }
        catch (ProcessingException processingException) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(arrayList, "couldn't resolve policy ref");
            return new MatchResult(2, status);
        }
    }

    private AbstractPolicy resolvePolicy() {
        if (this.finder == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("PolicyReference with id " + this.reference.toString() + " was queried but was " + "not configured with a PolicyFinder");
            }
            throw new ProcessingException("couldn't find the policy with a null finder");
        }
        PolicyFinderResult policyFinderResult = this.finder.findPolicy(this.reference, this.policyType);
        if (policyFinderResult.notApplicable()) {
            throw new ProcessingException("couldn't resolve the policy");
        }
        if (policyFinderResult.indeterminate()) {
            throw new ProcessingException("error resolving the policy");
        }
        return policyFinderResult.getPolicy();
    }

    public Result evaluate(EvaluationCtx evaluationCtx) {
        if (this.finder == null) {
            return new Result(3, evaluationCtx.getResourceId().encode());
        }
        PolicyFinderResult policyFinderResult = this.finder.findPolicy(this.reference, this.policyType);
        if (policyFinderResult.notApplicable()) {
            return new Result(3, evaluationCtx.getResourceId().encode());
        }
        if (policyFinderResult.indeterminate()) {
            return new Result(2, policyFinderResult.getStatus(), evaluationCtx.getResourceId().encode());
        }
        return policyFinderResult.getPolicy().evaluate(evaluationCtx);
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        if (this.policyType == 0) {
            printStream.println(string + "<PolicyIdReference>" + this.reference.toString() + "</PolicyIdReference>");
        } else {
            printStream.println(string + "<PolicySetIdReference>" + this.reference.toString() + "</PolicySetIdReference>");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

