/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.PDPConfig;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeFactoryProxy;
import com.sun.xacml.attr.AttributeProxy;
import com.sun.xacml.attr.BaseAttributeFactory;
import com.sun.xacml.attr.StandardAttributeFactory;
import com.sun.xacml.combine.BaseCombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgFactory;
import com.sun.xacml.combine.CombiningAlgFactoryProxy;
import com.sun.xacml.combine.CombiningAlgorithm;
import com.sun.xacml.combine.StandardCombiningAlgFactory;
import com.sun.xacml.cond.BaseFunctionFactory;
import com.sun.xacml.cond.BasicFunctionFactoryProxy;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionFactoryProxy;
import com.sun.xacml.cond.FunctionProxy;
import com.sun.xacml.cond.StandardFunctionFactory;
import com.sun.xacml.cond.cluster.FunctionCluster;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.ResourceFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationStore {
    public static final String PDP_CONFIG_PROPERTY = "com.sun.xacml.PDPConfigFile";
    private PDPConfig defaultPDPConfig;
    private HashMap pdpConfigMap;
    private AttributeFactory defaultAttributeFactory;
    private HashMap attributeMap;
    private CombiningAlgFactory defaultCombiningFactory;
    private HashMap combiningMap;
    private FunctionFactoryProxy defaultFunctionFactoryProxy;
    private HashMap functionMap;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$ConfigurationStore == null ? (class$com$sun$xacml$ConfigurationStore = ConfigurationStore.class$("com.sun.xacml.ConfigurationStore")) : class$com$sun$xacml$ConfigurationStore).getName());
    static /* synthetic */ Class class$com$sun$xacml$ConfigurationStore;

    public ConfigurationStore() throws ParsingException {
        String string = System.getProperty(PDP_CONFIG_PROPERTY);
        if (string == null) {
            logger.severe("A property defining a config file was expected, but none was provided");
            throw new ParsingException("Config property com.sun.xacml.PDPConfigFile needs to be set");
        }
        try {
            this.setupConfig(new File(string));
        }
        catch (ParsingException parsingException) {
            logger.log(Level.SEVERE, "Runtime config file couldn't be loaded so no configurations will be available", parsingException);
            throw parsingException;
        }
    }

    public ConfigurationStore(File file) throws ParsingException {
        try {
            this.setupConfig(file);
        }
        catch (ParsingException parsingException) {
            logger.log(Level.SEVERE, "Runtime config file couldn't be loaded so no configurations will be available", parsingException);
            throw parsingException;
        }
    }

    private void setupConfig(File file) throws ParsingException {
        logger.config("Loading runtime configuration");
        Node node = this.getRootNode(file);
        this.pdpConfigMap = new HashMap();
        this.attributeMap = new HashMap();
        this.combiningMap = new HashMap();
        this.functionMap = new HashMap();
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("defaultPDP").getNodeValue();
        String string2 = namedNodeMap.getNamedItem("defaultAttributeFactory").getNodeValue();
        String string3 = namedNodeMap.getNamedItem("defaultCombiningAlgFactory").getNodeValue();
        String string4 = namedNodeMap.getNamedItem("defaultFunctionFactory").getNodeValue();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string5 = node2.getNodeName();
            String string6 = null;
            if (node2.getNodeType() == 1) {
                string6 = node2.getAttributes().getNamedItem("name").getNodeValue();
            }
            if (string5.equals("pdp")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading PDP: " + string6);
                }
                if (this.pdpConfigMap.containsKey(string6)) {
                    throw new ParsingException("more that one pdp with name \"" + string6 + "\"");
                }
                this.pdpConfigMap.put(string6, this.parsePDPConfig(node2));
                continue;
            }
            if (string5.equals("attributeFactory")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading AttributeFactory: " + string6);
                }
                if (this.attributeMap.containsKey(string6)) {
                    throw new ParsingException("more that one attributeFactory with name " + string6 + "\"");
                }
                this.attributeMap.put(string6, this.parseAttributeFactory(node2));
                continue;
            }
            if (string5.equals("combiningAlgFactory")) {
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.config("Loading CombiningAlgFactory: " + string6);
                }
                if (this.combiningMap.containsKey(string6)) {
                    throw new ParsingException("more that one combiningAlgFactory with name \"" + string6 + "\"");
                }
                this.combiningMap.put(string6, this.parseCombiningAlgFactory(node2));
                continue;
            }
            if (!string5.equals("functionFactory")) continue;
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("Loading FunctionFactory: " + string6);
            }
            if (this.functionMap.containsKey(string6)) {
                throw new ParsingException("more that one functionFactory with name \"" + string6 + "\"");
            }
            this.functionMap.put(string6, this.parseFunctionFactory(node2));
        }
        this.defaultPDPConfig = (PDPConfig)this.pdpConfigMap.get(string);
        this.defaultAttributeFactory = (AttributeFactory)this.attributeMap.get(string2);
        this.defaultCombiningFactory = (CombiningAlgFactory)this.combiningMap.get(string3);
        this.defaultFunctionFactoryProxy = (FunctionFactoryProxy)this.functionMap.get(string4);
    }

    private Node getRootNode(File file) throws ParsingException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParsingException("couldn't get a document builder", parserConfigurationException);
        }
        Document document = null;
        try {
            document = documentBuilder.parse(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new ParsingException("failed to load the file ", iOException);
        }
        catch (SAXException sAXException) {
            throw new ParsingException("error parsing the XML tree", sAXException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParsingException("no data to parse", illegalArgumentException);
        }
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("config")) {
            throw new ParsingException("unknown document type: " + element.getTagName());
        }
        return element;
    }

    private PDPConfig parsePDPConfig(Node node) throws ParsingException {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = nodeList.item(i);
            object = object2.getNodeName();
            if (((String)object).equals("policyFinderModule")) {
                hashSet.add(this.loadClass("module", (Node)object2));
                continue;
            }
            if (((String)object).equals("attributeFinderModule")) {
                arrayList.add(this.loadClass("module", (Node)object2));
                continue;
            }
            if (!((String)object).equals("resourceFinderModule")) continue;
            arrayList2.add(this.loadClass("module", (Node)object2));
        }
        AttributeFinder attributeFinder = new AttributeFinder();
        attributeFinder.setModules(arrayList);
        object2 = new PolicyFinder();
        ((PolicyFinder)object2).setModules(hashSet);
        object = new ResourceFinder();
        ((ResourceFinder)object).setModules(arrayList2);
        return new PDPConfig(attributeFinder, (PolicyFinder)object2, (ResourceFinder)object);
    }

    private AttributeFactory parseAttributeFactory(Node node) throws ParsingException {
        Object object;
        BaseAttributeFactory baseAttributeFactory = null;
        if (this.useStandard(node, "useStandardDatatypes")) {
            logger.config("Starting with standard Datatypes");
            object = StandardAttributeFactory.getFactory();
            baseAttributeFactory = new BaseAttributeFactory(((StandardAttributeFactory)object).getStandardDatatypes());
        } else {
            baseAttributeFactory = new BaseAttributeFactory();
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            if (!node2.getNodeName().equals("datatype")) continue;
            String string = node2.getAttributes().getNamedItem("identifier").getNodeValue();
            AttributeProxy attributeProxy = (AttributeProxy)this.loadClass("datatype", node2);
            try {
                ((AttributeFactory)baseAttributeFactory).addDatatype(string, attributeProxy);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParsingException("duplicate datatype: " + string, illegalArgumentException);
            }
        }
        return baseAttributeFactory;
    }

    private CombiningAlgFactory parseCombiningAlgFactory(Node node) throws ParsingException {
        Object object;
        BaseCombiningAlgFactory baseCombiningAlgFactory = null;
        if (this.useStandard(node, "useStandardAlgorithms")) {
            logger.config("Starting with standard Combining Algorithms");
            object = StandardCombiningAlgFactory.getFactory();
            baseCombiningAlgFactory = new BaseCombiningAlgFactory(((StandardCombiningAlgFactory)object).getStandardAlgorithms());
        } else {
            baseCombiningAlgFactory = new BaseCombiningAlgFactory();
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = object.item(i);
            if (!node2.getNodeName().equals("algorithm")) continue;
            CombiningAlgorithm combiningAlgorithm = (CombiningAlgorithm)this.loadClass("algorithm", node2);
            try {
                ((CombiningAlgFactory)baseCombiningAlgFactory).addAlgorithm(combiningAlgorithm);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParsingException("duplicate combining algorithm: " + combiningAlgorithm.getIdentifier().toString(), illegalArgumentException);
            }
        }
        return baseCombiningAlgFactory;
    }

    private FunctionFactoryProxy parseFunctionFactory(Node node) throws ParsingException {
        FunctionFactoryProxy functionFactoryProxy = null;
        FunctionFactory functionFactory = null;
        FunctionFactory functionFactory2 = null;
        FunctionFactory functionFactory3 = null;
        if (this.useStandard(node, "useStandardFunctions")) {
            logger.config("Starting with standard Functions");
            functionFactoryProxy = StandardFunctionFactory.getNewFactoryProxy();
            functionFactory3 = functionFactoryProxy.getTargetFactory();
            functionFactory2 = functionFactoryProxy.getConditionFactory();
            functionFactory = functionFactoryProxy.getGeneralFactory();
        } else {
            functionFactory = new BaseFunctionFactory();
            functionFactory2 = new BaseFunctionFactory(functionFactory);
            functionFactory3 = new BaseFunctionFactory(functionFactory2);
            functionFactoryProxy = new BasicFunctionFactoryProxy(functionFactory3, functionFactory2, functionFactory);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("target")) {
                logger.config("Loading [TARGET] functions");
                this.functionParserHelper(node2, functionFactory3);
                continue;
            }
            if (string.equals("condition")) {
                logger.config("Loading [CONDITION] functions");
                this.functionParserHelper(node2, functionFactory2);
                continue;
            }
            if (!string.equals("general")) continue;
            logger.config("Loading [GENERAL] functions");
            this.functionParserHelper(node2, functionFactory);
        }
        return functionFactoryProxy;
    }

    private void functionParserHelper(Node node, FunctionFactory functionFactory) throws ParsingException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Object object2;
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("function")) {
                object2 = (Function)this.loadClass("function", node2);
                try {
                    functionFactory.addFunction((Function)object2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParsingException("duplicate function", illegalArgumentException);
                }
            }
            if (string.equals("abstractFunction")) {
                object2 = null;
                try {
                    object2 = new URI(node2.getAttributes().getNamedItem("identifier").getNodeValue());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ParsingException("invalid function identifier", uRISyntaxException);
                }
                object = (FunctionProxy)this.loadClass("abstract function", node2);
                try {
                    functionFactory.addAbstractFunction((FunctionProxy)object, (URI)object2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParsingException("duplicate abstract function", illegalArgumentException);
                }
            }
            if (!string.equals("functionCluster")) continue;
            object2 = (FunctionCluster)this.loadClass("function cluster", node2);
            object = object2.getSupportedFunctions().iterator();
            while (object.hasNext()) {
                try {
                    functionFactory.addFunction((Function)object.next());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParsingException("duplicate function", illegalArgumentException);
                }
            }
        }
    }

    private Object loadClass(String string, Node node) throws ParsingException {
        String string2 = node.getAttributes().getNamedItem("class").getNodeValue();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Loading [ " + string + ": " + string2 + " ]");
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ParsingException("couldn't load class " + string2, classNotFoundException);
        }
        Object var6_7 = null;
        if (!node.hasChildNodes()) {
            try {
                var6_7 = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ParsingException("couldn't instantiate " + string2 + " with empty constructor", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ParsingException("couldn't get access to instance of " + string2, illegalAccessException);
            }
        }
        List list = null;
        try {
            list = this.getArgs(node);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParsingException("illegal class arguments", illegalArgumentException);
        }
        int n = list.size();
        Constructor<?>[] constructorArray = clazz.getConstructors();
        Constructor<?> constructor = null;
        for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length == n) {
                Iterator iterator = list.iterator();
                int n2 = 0;
                while (iterator.hasNext() && classArray[n2].isAssignableFrom(iterator.next().getClass())) {
                    ++n2;
                }
                if (n2 == n) {
                    constructor = constructorArray[i];
                }
            }
            if (constructor != null) break;
        }
        if (constructor == null) {
            throw new ParsingException("couldn't find a matching constructor");
        }
        try {
            var6_7 = constructor.newInstance(list.toArray());
        }
        catch (InstantiationException instantiationException) {
            throw new ParsingException("couldn't instantiate " + string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ParsingException("couldn't get access to instance of " + string2, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ParsingException("couldn't create " + string2, invocationTargetException);
        }
        return var6_7;
    }

    private List getArgs(Node node) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (node2.getNodeType() != 1) continue;
            if (string.equals("string")) {
                arrayList.add(node2.getFirstChild().getNodeValue());
                continue;
            }
            if (string.equals("list")) {
                arrayList.add(this.getArgs(node2));
                continue;
            }
            throw new IllegalArgumentException("unkown arg type: " + string);
        }
        return arrayList;
    }

    private boolean useStandard(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return true;
        }
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 == null) {
            return true;
        }
        return node2.getNodeValue().equals("true");
    }

    public PDPConfig getDefaultPDPConfig() throws UnknownIdentifierException {
        if (this.defaultPDPConfig == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultPDPConfig;
    }

    public PDPConfig getPDPConfig(String string) throws UnknownIdentifierException {
        Object v = this.pdpConfigMap.get(string);
        if (v == null) {
            throw new UnknownIdentifierException("unknown pdp: " + string);
        }
        return (PDPConfig)v;
    }

    public Set getSupportedPDPConfigurations() {
        return Collections.unmodifiableSet(this.pdpConfigMap.keySet());
    }

    public AttributeFactory getDefaultAttributeFactory() throws UnknownIdentifierException {
        if (this.defaultAttributeFactory == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultAttributeFactory;
    }

    public AttributeFactory getAttributeFactory(String string) throws UnknownIdentifierException {
        Object v = this.attributeMap.get(string);
        if (v == null) {
            throw new UnknownIdentifierException("unknown factory: " + string);
        }
        return (AttributeFactory)v;
    }

    public Set getSupportedAttributeFactories() {
        return Collections.unmodifiableSet(this.attributeMap.keySet());
    }

    public CombiningAlgFactory getDefaultCombiningAlgFactory() throws UnknownIdentifierException {
        if (this.defaultCombiningFactory == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultCombiningFactory;
    }

    public CombiningAlgFactory getCombiningAlgFactory(String string) throws UnknownIdentifierException {
        Object v = this.combiningMap.get(string);
        if (v == null) {
            throw new UnknownIdentifierException("unknown factory: " + string);
        }
        return (CombiningAlgFactory)v;
    }

    public Set getSupportedCombiningAlgFactories() {
        return Collections.unmodifiableSet(this.combiningMap.keySet());
    }

    public FunctionFactoryProxy getDefaultFunctionFactoryProxy() throws UnknownIdentifierException {
        if (this.defaultFunctionFactoryProxy == null) {
            throw new UnknownIdentifierException("no default available");
        }
        return this.defaultFunctionFactoryProxy;
    }

    public FunctionFactoryProxy getFunctionFactoryProxy(String string) throws UnknownIdentifierException {
        Object v = this.functionMap.get(string);
        if (v == null) {
            throw new UnknownIdentifierException("unknown factory: " + string);
        }
        return (FunctionFactoryProxy)v;
    }

    public Set getSupportedFunctionFactories() {
        return Collections.unmodifiableSet(this.functionMap.keySet());
    }

    public void useDefaultFactories() {
        logger.fine("Switching to default factories from configuration");
        if (this.defaultAttributeFactory != null) {
            AttributeFactory.setDefaultFactory(new AttributeFactoryProxy(){

                public AttributeFactory getFactory() {
                    return ConfigurationStore.this.defaultAttributeFactory;
                }
            });
        }
        if (this.defaultCombiningFactory != null) {
            CombiningAlgFactory.setDefaultFactory(new CombiningAlgFactoryProxy(){

                public CombiningAlgFactory getFactory() {
                    return ConfigurationStore.this.defaultCombiningFactory;
                }
            });
        }
        if (this.defaultFunctionFactoryProxy != null) {
            FunctionFactory.setDefaultFactory(this.defaultFunctionFactoryProxy);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

