/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.Utils;
import org.antlr.runtime.BitSet;
import org.antlr.tool.Grammar;

public class IntervalSet
implements IntSet {
    protected List intervals = new ArrayList(2);

    public static IntervalSet of(int n) {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(n);
        return intervalSet;
    }

    public static IntervalSet of(int n, int n2) {
        IntervalSet intervalSet = new IntervalSet();
        intervalSet.add(n, n2);
        return intervalSet;
    }

    public void add(int n) {
        this.add(n, n);
    }

    public void add(int n, int n2) {
        this.add(Interval.create(n, n2));
    }

    protected void add(Interval interval) {
        if (interval.b < interval.a) {
            return;
        }
        ListIterator<Interval> listIterator = this.intervals.listIterator();
        while (listIterator.hasNext()) {
            Interval interval2 = (Interval)listIterator.next();
            if (interval.equals(interval2)) {
                return;
            }
            if (interval.adjacent(interval2) || !interval.disjoint(interval2)) {
                Interval interval3;
                Interval interval4 = interval.union(interval2);
                listIterator.set(interval4);
                if (listIterator.hasNext() && (interval4.adjacent(interval3 = (Interval)listIterator.next()) || !interval4.disjoint(interval3))) {
                    listIterator.remove();
                    listIterator.previous();
                    listIterator.set(interval4.union(interval3));
                }
                return;
            }
            if (!interval.startsBeforeDisjoint(interval2)) continue;
            listIterator.previous();
            listIterator.add(interval);
            return;
        }
        this.intervals.add(interval);
    }

    public void addAll(IntSet intSet) {
        if (intSet == null) {
            return;
        }
        if (!(intSet instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't add non IntSet (" + intSet.getClass().getName() + ") to IntervalSet");
        }
        IntervalSet intervalSet = (IntervalSet)intSet;
        for (Interval interval : intervalSet.intervals) {
            this.add(interval.a, interval.b);
        }
    }

    public IntSet complement(int n, int n2) {
        return this.complement(IntervalSet.of(n, n2));
    }

    public IntSet complement(IntSet intSet) {
        Object object;
        Object object2;
        if (intSet == null) {
            return null;
        }
        if (!(intSet instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't complement with non IntervalSet (" + intSet.getClass().getName() + ")");
        }
        IntervalSet intervalSet = (IntervalSet)intSet;
        int n = intervalSet.getMaxElement();
        IntervalSet intervalSet2 = new IntervalSet();
        if (this.intervals.size() == 0) {
            return intervalSet2;
        }
        Interval interval = (Interval)this.intervals.get(0);
        if (interval.a > 0) {
            IntervalSet intervalSet3 = IntervalSet.of(0, interval.a - 1);
            object2 = (IntervalSet)intervalSet3.and(intervalSet);
            intervalSet2.addAll((IntSet)object2);
        }
        for (int i = 1; i < this.intervals.size(); ++i) {
            object2 = (Interval)this.intervals.get(i - 1);
            object = (Interval)this.intervals.get(i);
            IntervalSet intervalSet4 = IntervalSet.of(((Interval)object2).b + 1, ((Interval)object).a - 1);
            IntervalSet intervalSet5 = (IntervalSet)intervalSet4.and(intervalSet);
            intervalSet2.addAll(intervalSet5);
        }
        Interval interval2 = (Interval)this.intervals.get(this.intervals.size() - 1);
        if (interval2.b < n) {
            object2 = IntervalSet.of(interval2.b + 1, n);
            object = (IntervalSet)((IntervalSet)object2).and(intervalSet);
            intervalSet2.addAll((IntSet)object);
        }
        return intervalSet2;
    }

    public IntSet subtract(IntSet intSet) {
        return this.and(((IntervalSet)intSet).complement(0, 65534));
    }

    public IntSet or(IntSet intSet) {
        return null;
    }

    public IntSet and(IntSet intSet) {
        if (intSet == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.intervals;
        ArrayList arrayList2 = (ArrayList)((IntervalSet)intSet).intervals;
        IntervalSet intervalSet = null;
        int n = arrayList.size();
        int n2 = arrayList2.size();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            Interval interval;
            Interval interval2 = (Interval)arrayList.get(n3);
            if (interval2.startsBeforeDisjoint(interval = (Interval)arrayList2.get(n4))) {
                ++n3;
                continue;
            }
            if (interval.startsBeforeDisjoint(interval2)) {
                ++n4;
                continue;
            }
            if (interval2.properlyContains(interval)) {
                if (intervalSet == null) {
                    intervalSet = new IntervalSet();
                }
                intervalSet.add(interval2.intersection(interval));
                ++n4;
                continue;
            }
            if (interval.properlyContains(interval2)) {
                if (intervalSet == null) {
                    intervalSet = new IntervalSet();
                }
                intervalSet.add(interval2.intersection(interval));
                ++n3;
                continue;
            }
            if (interval2.disjoint(interval)) continue;
            if (intervalSet == null) {
                intervalSet = new IntervalSet();
            }
            intervalSet.add(interval2.intersection(interval));
            if (interval2.startsAfterNonDisjoint(interval)) {
                ++n4;
                continue;
            }
            if (!interval.startsAfterNonDisjoint(interval2)) continue;
            ++n3;
        }
        if (intervalSet == null) {
            return new IntervalSet();
        }
        return intervalSet;
    }

    public boolean member(int n) {
        ListIterator listIterator = this.intervals.listIterator();
        while (listIterator.hasNext()) {
            Interval interval = (Interval)listIterator.next();
            if (n < interval.a) break;
            if (n < interval.a || n > interval.b) continue;
            return true;
        }
        return false;
    }

    public boolean isNil() {
        return this.intervals == null || this.intervals.size() == 0;
    }

    public int getSingleElement() {
        if (this.intervals != null && this.intervals.size() == 1) {
            Interval interval = (Interval)this.intervals.get(0);
            if (interval.a == interval.b) {
                return interval.a;
            }
        }
        return -6;
    }

    public int getMaxElement() {
        if (this.isNil()) {
            return -6;
        }
        Interval interval = (Interval)this.intervals.get(this.intervals.size() - 1);
        return interval.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            return -6;
        }
        for (Interval interval : this.intervals) {
            int n = interval.a;
            int n2 = interval.b;
            for (int i = n; i <= n2; ++i) {
                if (i < 0) continue;
                return i;
            }
        }
        return -6;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IntervalSet)) {
            return false;
        }
        IntervalSet intervalSet = (IntervalSet)object;
        return ((Object)this.intervals).equals(intervalSet.intervals);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Grammar grammar) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.intervals == null || this.intervals.size() == 0) {
            return "{}";
        }
        if (this.intervals.size() > 1) {
            stringBuffer.append("{");
        }
        Iterator iterator = this.intervals.iterator();
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            int n = interval.a;
            int n2 = interval.b;
            if (n == n2) {
                if (grammar != null) {
                    stringBuffer.append(grammar.getTokenDisplayName(n));
                } else {
                    stringBuffer.append(n);
                }
            } else if (grammar != null) {
                stringBuffer.append(grammar.getTokenDisplayName(n) + ".." + grammar.getTokenDisplayName(n2));
            } else {
                stringBuffer.append(n + ".." + n2);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        if (this.intervals.size() > 1) {
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    public int size() {
        int n = 0;
        for (Interval interval : this.intervals) {
            int n2 = interval.a;
            int n3 = interval.b;
            n += n3 - n2 + 1;
        }
        return n;
    }

    public List toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Interval interval : this.intervals) {
            int n = interval.a;
            int n2 = interval.b;
            for (int i = n; i <= n2; ++i) {
                arrayList.add(Utils.integer(i));
            }
        }
        return arrayList;
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        Iterator iterator = this.intervals.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            int n2 = interval.a;
            int n3 = interval.b;
            int n4 = n2;
            while (n4 <= n3) {
                nArray[n] = n4++;
                ++n;
            }
        }
        return nArray;
    }

    public BitSet toRuntimeBitSet() {
        BitSet bitSet = new BitSet(this.getMaxElement() + 1);
        Iterator iterator = this.intervals.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Interval interval = (Interval)iterator.next();
            int n2 = interval.a;
            int n3 = interval.b;
            for (int i = n2; i <= n3; ++i) {
                bitSet.add(i);
                ++n;
            }
        }
        return bitSet;
    }

    public void remove(int n) {
        throw new NoSuchMethodError("IntervalSet.remove() unimplemented");
    }
}

