/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tstringlist;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.library.adt.bytecode.types.TStringList;
import tom.library.adt.bytecode.types.tstringlist.ConsStringList;
import tom.library.adt.bytecode.types.tstringlist.EmptyStringList;

public abstract class StringList
extends TStringList {
    public int length() {
        if (this instanceof ConsStringList) {
            TStringList tl = ((ConsStringList)this).getTailStringList();
            if (tl instanceof StringList) {
                return 1 + ((StringList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public String[] toArray() {
        String[] array;
        if (this instanceof ConsStringList) {
            String h = ((ConsStringList)this).getHeadStringList();
            TStringList tl = ((ConsStringList)this).getTailStringList();
            if (tl instanceof StringList) {
                String[] tailArray = ((StringList)tl).toArray();
                array = new String[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new String[]{h};
            }
        } else {
            array = new String[]{};
        }
        return array;
    }

    public static TStringList fromArray(String[] array) {
        StringList res = EmptyStringList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsStringList.make(array[--i], res);
        }
        return res;
    }

    public TStringList reverse() {
        if (this instanceof ConsStringList) {
            TStringList cur = this;
            StringList rev = EmptyStringList.make();
            while (cur instanceof ConsStringList) {
                rev = ConsStringList.make(((ConsStringList)cur).getHeadStringList(), rev);
                cur = ((ConsStringList)cur).getTailStringList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("StringList(");
        if (this instanceof ConsStringList) {
            TStringList cur = this;
            while (cur instanceof ConsStringList) {
                String elem = ((ConsStringList)cur).getHeadStringList();
                cur = ((ConsStringList)cur).getTailStringList();
                buffer.append('\"');
                block12: for (int i = 0; i < elem.length(); ++i) {
                    char c = elem.charAt(i);
                    switch (c) {
                        case '\n': {
                            buffer.append('\\');
                            buffer.append('n');
                            continue block12;
                        }
                        case '\t': {
                            buffer.append('\\');
                            buffer.append('t');
                            continue block12;
                        }
                        case '\b': {
                            buffer.append('\\');
                            buffer.append('b');
                            continue block12;
                        }
                        case '\r': {
                            buffer.append('\\');
                            buffer.append('r');
                            continue block12;
                        }
                        case '\f': {
                            buffer.append('\\');
                            buffer.append('f');
                            continue block12;
                        }
                        case '\\': {
                            buffer.append('\\');
                            buffer.append('\\');
                            continue block12;
                        }
                        case '\'': {
                            buffer.append('\\');
                            buffer.append('\'');
                            continue block12;
                        }
                        case '\"': {
                            buffer.append('\\');
                            buffer.append('\"');
                            continue block12;
                        }
                        case ' ': 
                        case '!': 
                        case '#': 
                        case '$': 
                        case '%': 
                        case '&': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case ';': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '?': 
                        case '@': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '_': 
                        case '{': 
                        case '|': 
                        case '}': 
                        case '~': {
                            buffer.append(c);
                            continue block12;
                        }
                        default: {
                            if (Character.isLetterOrDigit(c)) {
                                buffer.append(c);
                                continue block12;
                            }
                            buffer.append('\\');
                            buffer.append((char)(48 + c / 64));
                            c = (char)(c % 64);
                            buffer.append((char)(48 + c / 8));
                            c = (char)(c % 8);
                            buffer.append((char)(48 + c));
                        }
                    }
                }
                buffer.append('\"');
                if (!(cur instanceof ConsStringList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyStringList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TStringList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "StringList".equals((appl = (ATermAppl)trm).getName())) {
            StringList res = EmptyStringList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                String elem = ((ATermAppl)array[i]).getAFun().getName();
                res = ConsStringList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

