/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tmethod;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.SharedObject;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.types.TMethod;
import tom.library.adt.bytecode.types.TMethodCode;
import tom.library.adt.bytecode.types.TMethodInfo;
import tom.library.sl.Visitable;

public final class Method
extends TMethod
implements Visitable {
    private int hashCode;
    private static Method proto = new Method();
    private TMethodInfo _info;
    private TMethodCode _code;

    private Method() {
    }

    public static Method make(TMethodInfo _info, TMethodCode _code) {
        proto.initHashCode(_info, _code);
        return (Method)factory.build((SharedObject)proto);
    }

    private void init(TMethodInfo _info, TMethodCode _code, int hashCode) {
        this._info = _info;
        this._code = _code;
        this.hashCode = hashCode;
    }

    private void initHashCode(TMethodInfo _info, TMethodCode _code) {
        this._info = _info;
        this._code = _code;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "Method";
    }

    private int getArity() {
        return 2;
    }

    public SharedObject duplicate() {
        Method clone = new Method();
        clone.init(this._info, this._code, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("Method(");
        this._info.toStringBuffer(buffer);
        buffer.append(",");
        this._code.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        Method tco = (Method)ao;
        int _infoCmp = this._info.compareToLPO(tco._info);
        if (_infoCmp != 0) {
            return _infoCmp;
        }
        int _codeCmp = this._code.compareToLPO(tco._code);
        if (_codeCmp != 0) {
            return _codeCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        Method tco = (Method)ao;
        int _infoCmp = this._info.compareTo(tco._info);
        if (_infoCmp != 0) {
            return _infoCmp;
        }
        int _codeCmp = this._code.compareTo(tco._code);
        if (_codeCmp != 0) {
            return _codeCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof Method) {
            Method peer = (Method)obj;
            return this._info == peer._info && this._code == peer._code;
        }
        return false;
    }

    public boolean isMethod() {
        return true;
    }

    public TMethodInfo getinfo() {
        return this._info;
    }

    public TMethod setinfo(TMethodInfo set_arg) {
        return Method.make(set_arg, this._code);
    }

    public TMethodCode getcode() {
        return this._code;
    }

    public TMethod setcode(TMethodCode set_arg) {
        return Method.make(this._info, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{this.getinfo().toATerm(), this.getcode().toATerm()});
    }

    public static TMethod fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return Method.make(TMethodInfo.fromTerm(appl.getArgument(0)), TMethodCode.fromTerm(appl.getArgument(1)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 2;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._info;
            }
            case 1: {
                return this._code;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return Method.make((TMethodInfo)v, this._code);
            }
            case 1: {
                return Method.make(this._info, (TMethodCode)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 2) {
            return Method.make((TMethodInfo)childs[0], (TMethodCode)childs[1]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._info, this._code};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = 609895168;
        int c = this.getArity();
        a += this._info.hashCode() << 8;
        a += this._code.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

