/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tlocalvariablelist;

import aterm.ATerm;
import aterm.ATermAppl;
import tom.library.adt.bytecode.types.TLocalVariable;
import tom.library.adt.bytecode.types.TLocalVariableList;
import tom.library.adt.bytecode.types.tlocalvariablelist.ConsLocalVariableList;
import tom.library.adt.bytecode.types.tlocalvariablelist.EmptyLocalVariableList;

public abstract class LocalVariableList
extends TLocalVariableList {
    public int length() {
        if (this instanceof ConsLocalVariableList) {
            TLocalVariableList tl = ((ConsLocalVariableList)this).getTailLocalVariableList();
            if (tl instanceof LocalVariableList) {
                return 1 + ((LocalVariableList)tl).length();
            }
            return 2;
        }
        return 0;
    }

    public TLocalVariable[] toArray() {
        TLocalVariable[] array;
        if (this instanceof ConsLocalVariableList) {
            TLocalVariable h = ((ConsLocalVariableList)this).getHeadLocalVariableList();
            TLocalVariableList tl = ((ConsLocalVariableList)this).getTailLocalVariableList();
            if (tl instanceof LocalVariableList) {
                TLocalVariable[] tailArray = ((LocalVariableList)tl).toArray();
                array = new TLocalVariable[1 + tailArray.length];
                array[0] = h;
                for (int i = 0; i < tailArray.length; ++i) {
                    array[i + 1] = tailArray[i];
                }
            } else {
                array = new TLocalVariable[]{h};
            }
        } else {
            array = new TLocalVariable[]{};
        }
        return array;
    }

    public static TLocalVariableList fromArray(TLocalVariable[] array) {
        LocalVariableList res = EmptyLocalVariableList.make();
        int i = array.length;
        while (i > 0) {
            res = ConsLocalVariableList.make(array[--i], res);
        }
        return res;
    }

    public TLocalVariableList reverse() {
        if (this instanceof ConsLocalVariableList) {
            TLocalVariableList cur = this;
            LocalVariableList rev = EmptyLocalVariableList.make();
            while (cur instanceof ConsLocalVariableList) {
                rev = ConsLocalVariableList.make(((ConsLocalVariableList)cur).getHeadLocalVariableList(), rev);
                cur = ((ConsLocalVariableList)cur).getTailLocalVariableList();
            }
            return rev;
        }
        return this;
    }

    public void toStringBuffer(StringBuffer buffer) {
        buffer.append("LocalVariableList(");
        if (this instanceof ConsLocalVariableList) {
            TLocalVariableList cur = this;
            while (cur instanceof ConsLocalVariableList) {
                TLocalVariable elem = ((ConsLocalVariableList)cur).getHeadLocalVariableList();
                cur = ((ConsLocalVariableList)cur).getTailLocalVariableList();
                elem.toStringBuffer(buffer);
                if (!(cur instanceof ConsLocalVariableList)) continue;
                buffer.append(",");
            }
            if (!(cur instanceof EmptyLocalVariableList)) {
                buffer.append(",");
                cur.toStringBuffer(buffer);
            }
        }
        buffer.append(")");
    }

    public static TLocalVariableList fromTerm(ATerm trm) {
        ATermAppl appl;
        if (trm instanceof ATermAppl && "LocalVariableList".equals((appl = (ATermAppl)trm).getName())) {
            LocalVariableList res = EmptyLocalVariableList.make();
            ATerm[] array = appl.getArgumentArray();
            for (int i = array.length - 1; i >= 0; --i) {
                TLocalVariable elem = TLocalVariable.fromTerm(array[i]);
                res = ConsLocalVariableList.make(elem, res);
            }
            return res;
        }
        return null;
    }
}

