/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tlocalvariable;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import shared.HashFunctions;
import shared.SharedObject;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.types.TLabel;
import tom.library.adt.bytecode.types.TLocalVariable;
import tom.library.adt.bytecode.types.TSignature;
import tom.library.sl.Visitable;

public final class LocalVariable
extends TLocalVariable
implements Visitable {
    private int hashCode;
    private static LocalVariable proto = new LocalVariable();
    private String _name;
    private String _typeDesc;
    private TSignature _signature;
    private TLabel _start;
    private TLabel _end;
    private int _index;

    private LocalVariable() {
    }

    public static LocalVariable make(String _name, String _typeDesc, TSignature _signature, TLabel _start, TLabel _end, int _index) {
        proto.initHashCode(_name, _typeDesc, _signature, _start, _end, _index);
        return (LocalVariable)factory.build((SharedObject)proto);
    }

    private void init(String _name, String _typeDesc, TSignature _signature, TLabel _start, TLabel _end, int _index, int hashCode) {
        this._name = _name.intern();
        this._typeDesc = _typeDesc.intern();
        this._signature = _signature;
        this._start = _start;
        this._end = _end;
        this._index = _index;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _name, String _typeDesc, TSignature _signature, TLabel _start, TLabel _end, int _index) {
        this._name = _name.intern();
        this._typeDesc = _typeDesc.intern();
        this._signature = _signature;
        this._start = _start;
        this._end = _end;
        this._index = _index;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "LocalVariable";
    }

    private int getArity() {
        return 6;
    }

    public SharedObject duplicate() {
        LocalVariable clone = new LocalVariable();
        clone.init(this._name, this._typeDesc, this._signature, this._start, this._end, this._index, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        char c;
        int i;
        buffer.append("LocalVariable(");
        buffer.append('\"');
        block22: for (i = 0; i < this._name.length(); ++i) {
            c = this._name.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block22;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block22;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block22;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block22;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block22;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block22;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block22;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block22;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block22;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block22;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        buffer.append('\"');
        block23: for (i = 0; i < this._typeDesc.length(); ++i) {
            c = this._typeDesc.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block23;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block23;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block23;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block23;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block23;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block23;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block23;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block23;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block23;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block23;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._signature.toStringBuffer(buffer);
        buffer.append(",");
        this._start.toStringBuffer(buffer);
        buffer.append(",");
        this._end.toStringBuffer(buffer);
        buffer.append(",");
        buffer.append(this._index);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        LocalVariable tco = (LocalVariable)ao;
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _typeDescCmp = this._typeDesc.compareTo(tco._typeDesc);
        if (_typeDescCmp != 0) {
            return _typeDescCmp;
        }
        int _signatureCmp = this._signature.compareToLPO(tco._signature);
        if (_signatureCmp != 0) {
            return _signatureCmp;
        }
        int _startCmp = this._start.compareToLPO(tco._start);
        if (_startCmp != 0) {
            return _startCmp;
        }
        int _endCmp = this._end.compareToLPO(tco._end);
        if (_endCmp != 0) {
            return _endCmp;
        }
        if (this._index != tco._index) {
            return this._index < tco._index ? -1 : 1;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        LocalVariable tco = (LocalVariable)ao;
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _typeDescCmp = this._typeDesc.compareTo(tco._typeDesc);
        if (_typeDescCmp != 0) {
            return _typeDescCmp;
        }
        int _signatureCmp = this._signature.compareTo(tco._signature);
        if (_signatureCmp != 0) {
            return _signatureCmp;
        }
        int _startCmp = this._start.compareTo(tco._start);
        if (_startCmp != 0) {
            return _startCmp;
        }
        int _endCmp = this._end.compareTo(tco._end);
        if (_endCmp != 0) {
            return _endCmp;
        }
        if (this._index != tco._index) {
            return this._index < tco._index ? -1 : 1;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof LocalVariable) {
            LocalVariable peer = (LocalVariable)obj;
            return this._name == peer._name && this._typeDesc == peer._typeDesc && this._signature == peer._signature && this._start == peer._start && this._end == peer._end && this._index == peer._index;
        }
        return false;
    }

    public boolean isLocalVariable() {
        return true;
    }

    public String getname() {
        return this._name;
    }

    public TLocalVariable setname(String set_arg) {
        return LocalVariable.make(set_arg, this._typeDesc, this._signature, this._start, this._end, this._index);
    }

    public String gettypeDesc() {
        return this._typeDesc;
    }

    public TLocalVariable settypeDesc(String set_arg) {
        return LocalVariable.make(this._name, set_arg, this._signature, this._start, this._end, this._index);
    }

    public TSignature getsignature() {
        return this._signature;
    }

    public TLocalVariable setsignature(TSignature set_arg) {
        return LocalVariable.make(this._name, this._typeDesc, set_arg, this._start, this._end, this._index);
    }

    public TLabel getstart() {
        return this._start;
    }

    public TLocalVariable setstart(TLabel set_arg) {
        return LocalVariable.make(this._name, this._typeDesc, this._signature, set_arg, this._end, this._index);
    }

    public TLabel getend() {
        return this._end;
    }

    public TLocalVariable setend(TLabel set_arg) {
        return LocalVariable.make(this._name, this._typeDesc, this._signature, this._start, set_arg, this._index);
    }

    public int getindex() {
        return this._index;
    }

    public TLocalVariable setindex(int set_arg) {
        return LocalVariable.make(this._name, this._typeDesc, this._signature, this._start, this._end, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getname(), 0, true)), atermFactory.makeAppl(atermFactory.makeAFun(this.gettypeDesc(), 0, true)), this.getsignature().toATerm(), this.getstart().toATerm(), this.getend().toATerm(), atermFactory.makeInt(this.getindex())});
    }

    public static TLocalVariable fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return LocalVariable.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), ((ATermAppl)appl.getArgument(1)).getAFun().getName(), TSignature.fromTerm(appl.getArgument(2)), TLabel.fromTerm(appl.getArgument(3)), TLabel.fromTerm(appl.getArgument(4)), ((ATermInt)appl.getArgument(5)).getInt());
            }
        }
        return null;
    }

    public int getChildCount() {
        return 3;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._signature;
            }
            case 1: {
                return this._start;
            }
            case 2: {
                return this._end;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return LocalVariable.make(this.getname(), this.gettypeDesc(), (TSignature)v, this._start, this._end, this.getindex());
            }
            case 1: {
                return LocalVariable.make(this.getname(), this.gettypeDesc(), this._signature, (TLabel)v, this._end, this.getindex());
            }
            case 2: {
                return LocalVariable.make(this.getname(), this.gettypeDesc(), this._signature, this._start, (TLabel)v, this.getindex());
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 3) {
            return LocalVariable.make(this.getname(), this.gettypeDesc(), (TSignature)childs[0], (TLabel)childs[1], (TLabel)childs[2], this.getindex());
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._signature, this._start, this._end};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = 1321053440;
        int c = this.getArity();
        b += HashFunctions.stringHashFunction((String)this._name, (int)5) << 8;
        a += this._signature.hashCode() << 24;
        a += this._start.hashCode() << 16;
        a += this._end.hashCode() << 8;
        a += this._index;
        a -= (b += HashFunctions.stringHashFunction((String)this._typeDesc, (int)4));
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

