/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types.tinnerclassinfo;

import aterm.ATerm;
import aterm.ATermAppl;
import shared.HashFunctions;
import shared.SharedObject;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.types.TAccessList;
import tom.library.adt.bytecode.types.TInnerClassInfo;
import tom.library.sl.Visitable;

public final class InnerClassInfo
extends TInnerClassInfo
implements Visitable {
    private int hashCode;
    private static InnerClassInfo proto = new InnerClassInfo();
    private String _name;
    private String _outerName;
    private String _innerName;
    private TAccessList _access;

    private InnerClassInfo() {
    }

    public static InnerClassInfo make(String _name, String _outerName, String _innerName, TAccessList _access) {
        proto.initHashCode(_name, _outerName, _innerName, _access);
        return (InnerClassInfo)factory.build((SharedObject)proto);
    }

    private void init(String _name, String _outerName, String _innerName, TAccessList _access, int hashCode) {
        this._name = _name.intern();
        this._outerName = _outerName.intern();
        this._innerName = _innerName.intern();
        this._access = _access;
        this.hashCode = hashCode;
    }

    private void initHashCode(String _name, String _outerName, String _innerName, TAccessList _access) {
        this._name = _name.intern();
        this._outerName = _outerName.intern();
        this._innerName = _innerName.intern();
        this._access = _access;
        this.hashCode = this.hashFunction();
    }

    public String symbolName() {
        return "InnerClassInfo";
    }

    private int getArity() {
        return 4;
    }

    public SharedObject duplicate() {
        InnerClassInfo clone = new InnerClassInfo();
        clone.init(this._name, this._outerName, this._innerName, this._access, this.hashCode);
        return clone;
    }

    public void toStringBuffer(StringBuffer buffer) {
        char c;
        int i;
        buffer.append("InnerClassInfo(");
        buffer.append('\"');
        block33: for (i = 0; i < this._name.length(); ++i) {
            c = this._name.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block33;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block33;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block33;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block33;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block33;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block33;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block33;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block33;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block33;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block33;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        buffer.append('\"');
        block34: for (i = 0; i < this._outerName.length(); ++i) {
            c = this._outerName.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block34;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block34;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block34;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block34;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block34;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block34;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block34;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block34;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block34;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block34;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        buffer.append('\"');
        block35: for (i = 0; i < this._innerName.length(); ++i) {
            c = this._innerName.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block35;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block35;
                }
                case '\b': {
                    buffer.append('\\');
                    buffer.append('b');
                    continue block35;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block35;
                }
                case '\f': {
                    buffer.append('\\');
                    buffer.append('f');
                    continue block35;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block35;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block35;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block35;
                }
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '_': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    buffer.append(c);
                    continue block35;
                }
                default: {
                    if (Character.isLetterOrDigit(c)) {
                        buffer.append(c);
                        continue block35;
                    }
                    buffer.append('\\');
                    buffer.append((char)(48 + c / 64));
                    c = (char)(c % 64);
                    buffer.append((char)(48 + c / 8));
                    c = (char)(c % 8);
                    buffer.append((char)(48 + c));
                }
            }
        }
        buffer.append('\"');
        buffer.append(",");
        this._access.toStringBuffer(buffer);
        buffer.append(")");
    }

    public int compareToLPO(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        InnerClassInfo tco = (InnerClassInfo)ao;
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _outerNameCmp = this._outerName.compareTo(tco._outerName);
        if (_outerNameCmp != 0) {
            return _outerNameCmp;
        }
        int _innerNameCmp = this._innerName.compareTo(tco._innerName);
        if (_innerNameCmp != 0) {
            return _innerNameCmp;
        }
        int _accessCmp = this._access.compareToLPO(tco._access);
        if (_accessCmp != 0) {
            return _accessCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public int compareTo(Object o) {
        BytecodeAbstractType ao = (BytecodeAbstractType)o;
        if (ao == this) {
            return 0;
        }
        if (this.hashCode != ao.hashCode()) {
            return this.hashCode < ao.hashCode() ? -1 : 1;
        }
        int symbCmp = this.symbolName().compareTo(ao.symbolName());
        if (symbCmp != 0) {
            return symbCmp;
        }
        InnerClassInfo tco = (InnerClassInfo)ao;
        int _nameCmp = this._name.compareTo(tco._name);
        if (_nameCmp != 0) {
            return _nameCmp;
        }
        int _outerNameCmp = this._outerName.compareTo(tco._outerName);
        if (_outerNameCmp != 0) {
            return _outerNameCmp;
        }
        int _innerNameCmp = this._innerName.compareTo(tco._innerName);
        if (_innerNameCmp != 0) {
            return _innerNameCmp;
        }
        int _accessCmp = this._access.compareTo(tco._access);
        if (_accessCmp != 0) {
            return _accessCmp;
        }
        throw new RuntimeException("Unable to compare");
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equivalent(SharedObject obj) {
        if (obj instanceof InnerClassInfo) {
            InnerClassInfo peer = (InnerClassInfo)obj;
            return this._name == peer._name && this._outerName == peer._outerName && this._innerName == peer._innerName && this._access == peer._access;
        }
        return false;
    }

    public boolean isInnerClassInfo() {
        return true;
    }

    public String getname() {
        return this._name;
    }

    public TInnerClassInfo setname(String set_arg) {
        return InnerClassInfo.make(set_arg, this._outerName, this._innerName, this._access);
    }

    public String getouterName() {
        return this._outerName;
    }

    public TInnerClassInfo setouterName(String set_arg) {
        return InnerClassInfo.make(this._name, set_arg, this._innerName, this._access);
    }

    public String getinnerName() {
        return this._innerName;
    }

    public TInnerClassInfo setinnerName(String set_arg) {
        return InnerClassInfo.make(this._name, this._outerName, set_arg, this._access);
    }

    public TAccessList getaccess() {
        return this._access;
    }

    public TInnerClassInfo setaccess(TAccessList set_arg) {
        return InnerClassInfo.make(this._name, this._outerName, this._innerName, set_arg);
    }

    public ATerm toATerm() {
        return atermFactory.makeAppl(atermFactory.makeAFun(this.symbolName(), this.getArity(), false), new ATerm[]{atermFactory.makeAppl(atermFactory.makeAFun(this.getname(), 0, true)), atermFactory.makeAppl(atermFactory.makeAFun(this.getouterName(), 0, true)), atermFactory.makeAppl(atermFactory.makeAFun(this.getinnerName(), 0, true)), this.getaccess().toATerm()});
    }

    public static TInnerClassInfo fromTerm(ATerm trm) {
        if (trm instanceof ATermAppl) {
            ATermAppl appl = (ATermAppl)trm;
            if (proto.symbolName().equals(appl.getName())) {
                return InnerClassInfo.make(((ATermAppl)appl.getArgument(0)).getAFun().getName(), ((ATermAppl)appl.getArgument(1)).getAFun().getName(), ((ATermAppl)appl.getArgument(2)).getAFun().getName(), TAccessList.fromTerm(appl.getArgument(3)));
            }
        }
        return null;
    }

    public int getChildCount() {
        return 1;
    }

    public Visitable getChildAt(int index) {
        switch (index) {
            case 0: {
                return this._access;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildAt(int index, Visitable v) {
        switch (index) {
            case 0: {
                return InnerClassInfo.make(this.getname(), this.getouterName(), this.getinnerName(), (TAccessList)v);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable setChildren(Visitable[] childs) {
        if (childs.length == 1) {
            return InnerClassInfo.make(this.getname(), this.getouterName(), this.getinnerName(), (TAccessList)childs[0]);
        }
        throw new IndexOutOfBoundsException();
    }

    public Visitable[] getChildren() {
        return new Visitable[]{this._access};
    }

    protected int hashFunction() {
        int a = -1640531527;
        int b = -757465856;
        int c = this.getArity();
        a += HashFunctions.stringHashFunction((String)this._name, (int)3) << 24;
        a += HashFunctions.stringHashFunction((String)this._outerName, (int)2) << 16;
        a += HashFunctions.stringHashFunction((String)this._innerName, (int)1) << 8;
        a += this._access.hashCode();
        a -= b;
        a -= c;
        b -= c;
        b -= (a ^= c >> 13);
        c -= a;
        c -= (b ^= a << 8);
        a -= b;
        a -= (c ^= b >> 13);
        b -= c;
        b -= (a ^= c >> 12);
        c -= a;
        c -= (b ^= a << 16);
        a -= b;
        a -= (c ^= b >> 5);
        b -= c;
        b -= (a ^= c >> 3);
        c -= a;
        c -= (b ^= a << 10);
        return c ^= b >> 15;
    }
}

