/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types;

import aterm.ATerm;
import java.io.IOException;
import java.io.InputStream;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.BytecodeVisitor;
import tom.library.adt.bytecode.types.tvalue.DoubleValue;
import tom.library.adt.bytecode.types.tvalue.EmptyValue;
import tom.library.adt.bytecode.types.tvalue.FloatValue;
import tom.library.adt.bytecode.types.tvalue.IntValue;
import tom.library.adt.bytecode.types.tvalue.LongValue;
import tom.library.adt.bytecode.types.tvalue.StringValue;
import tom.library.sl.VisitFailure;

public abstract class TValue
extends BytecodeAbstractType {
    public BytecodeAbstractType accept(BytecodeVisitor v) throws VisitFailure {
        return v.visit_TValue(this);
    }

    public boolean isStringValue() {
        return false;
    }

    public boolean isIntValue() {
        return false;
    }

    public boolean isLongValue() {
        return false;
    }

    public boolean isFloatValue() {
        return false;
    }

    public boolean isDoubleValue() {
        return false;
    }

    public boolean isEmptyValue() {
        return false;
    }

    public String gets() {
        throw new UnsupportedOperationException("This TValue has no s");
    }

    public TValue sets(String _arg) {
        throw new UnsupportedOperationException("This TValue has no s");
    }

    public double getd() {
        throw new UnsupportedOperationException("This TValue has no d");
    }

    public TValue setd(double _arg) {
        throw new UnsupportedOperationException("This TValue has no d");
    }

    public int geti() {
        throw new UnsupportedOperationException("This TValue has no i");
    }

    public TValue seti(int _arg) {
        throw new UnsupportedOperationException("This TValue has no i");
    }

    public float getf() {
        throw new UnsupportedOperationException("This TValue has no f");
    }

    public TValue setf(float _arg) {
        throw new UnsupportedOperationException("This TValue has no f");
    }

    public long getl() {
        throw new UnsupportedOperationException("This TValue has no l");
    }

    public TValue setl(long _arg) {
        throw new UnsupportedOperationException("This TValue has no l");
    }

    public static TValue fromTerm(ATerm trm) {
        TValue tmp = StringValue.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = IntValue.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = LongValue.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = FloatValue.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = DoubleValue.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = EmptyValue.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        throw new IllegalArgumentException("This is not a TValue " + trm);
    }

    public static TValue fromString(String s) {
        return TValue.fromTerm(atermFactory.parse(s));
    }

    public static TValue fromStream(InputStream stream) throws IOException {
        return TValue.fromTerm(atermFactory.readFromFile(stream));
    }

    public int length() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }

    public TValue reverse() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }
}

