/*
 * Decompiled with CFR 0.152.
 */
package tom.library.adt.bytecode.types;

import aterm.ATerm;
import java.io.IOException;
import java.io.InputStream;
import tom.library.adt.bytecode.BytecodeAbstractType;
import tom.library.adt.bytecode.BytecodeVisitor;
import tom.library.adt.bytecode.types.TAccess;
import tom.library.adt.bytecode.types.taccesslist.AccessList;
import tom.library.adt.bytecode.types.taccesslist.ConsAccessList;
import tom.library.adt.bytecode.types.taccesslist.EmptyAccessList;
import tom.library.sl.VisitFailure;

public abstract class TAccessList
extends BytecodeAbstractType {
    public BytecodeAbstractType accept(BytecodeVisitor v) throws VisitFailure {
        return v.visit_TAccessList(this);
    }

    public boolean isConsAccessList() {
        return false;
    }

    public boolean isEmptyAccessList() {
        return false;
    }

    public TAccess getHeadAccessList() {
        throw new UnsupportedOperationException("This TAccessList has no HeadAccessList");
    }

    public TAccessList setHeadAccessList(TAccess _arg) {
        throw new UnsupportedOperationException("This TAccessList has no HeadAccessList");
    }

    public TAccessList getTailAccessList() {
        throw new UnsupportedOperationException("This TAccessList has no TailAccessList");
    }

    public TAccessList setTailAccessList(TAccessList _arg) {
        throw new UnsupportedOperationException("This TAccessList has no TailAccessList");
    }

    public static TAccessList fromTerm(ATerm trm) {
        TAccessList tmp = ConsAccessList.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = EmptyAccessList.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        tmp = AccessList.fromTerm(trm);
        if (tmp != null) {
            return tmp;
        }
        throw new IllegalArgumentException("This is not a TAccessList " + trm);
    }

    public static TAccessList fromString(String s) {
        return TAccessList.fromTerm(atermFactory.parse(s));
    }

    public static TAccessList fromStream(InputStream stream) throws IOException {
        return TAccessList.fromTerm(atermFactory.readFromFile(stream));
    }

    public int length() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }

    public TAccessList reverse() {
        throw new IllegalArgumentException("This " + this.getClass().getName() + " is not a list");
    }
}

