# mv

> 移动或重命名文件或目录。
> 更多信息：<https://www.gnu.org/software/coreutils/manual/html_node/mv-invocation.html>.

- 重命名文件或目录，当目标不是一个已存在的目录时：

`mv {{路径/到/源}} {{路径/到/目标}}`

- 将文件或目录移动到已存在的目录中：

`mv {{路径/到/源}} {{路径/到/已存在的目录}}`

- 将多个文件移动到已存在的目录中，并保持文件名不变：

`mv {{路径/到/源1 路径/到/源2 ...}} {{路径/到/已存在的目录}}`

- 覆盖现有文件前无需确认：

`mv {{[-f|--force]}} {{路径/到/源}} {{路径/到/目标}}`

- 无论是否有文件权限，覆盖现有文件前均需要确认：

`mv {{[-i|--interactive]}} {{路径/到/源}} {{路径/到/目标}}`

- 不覆盖现有的目标文件：

`mv {{[-n|--no-clobber]}} {{路径/到/源}} {{路径/到/目标}}`

- 在详细模式下移动文件，移动后显示文件的信息：

`mv {{[-v|--verbose]}} {{路径/到/源}} {{路径/到/目标}}`

- 指定目标目录，以便使用外部工具来收集可移动的文件：

`{{find /var/log -type f -name '*.log' -print0}} | {{xargs -0}} mv --target-directory {{路径/到/目标目录}}`
