# gcc

> 预处理和编译 C 和 C++ 源文件，然后汇编并将他们链接起来。
> GCC (GNU Compiler Collection) 项目的组件之一。
> 更多信息：<https://gcc.gnu.org/onlinedocs/gcc/>.

- 将一组源文件编译为二进制文件：

`gcc {{源/文件/的路径1.cpp 源/文件/的路径2.cpp ...}} {{[-o|--output]}} {{可执行/文件/的路径}}`

- 打印所有错误和警告：

`gcc {{源/文件/的路径.cpp}} -Wall {{[-o|--output]}} {{output_executable}}`

- 打印普通警告和调试信息, 并在不影响调试的情况下优化：

`gcc {{源/文件/的路径.cpp}} -Wall {{[-g|--debug]}} -Og {{[-o|--output]}} {{可执行/文件/的路径}}`

- 包含与源文件不在同一路径下的库：

`gcc {{源/文件/的路径.c}} {{[-o|--output]}} {{可执行/文件/的路径}} -I{{头/文件/的目录}} -L{{库/的目录}} -l{{库的名字}}`

- 将源文件编译为汇编指令：

`gcc {{[-S|--assemble]}} {{源/文件/的路径}}`

- 将源文件编译成目标文件（.o）而不链接：

`gcc {{[-c|--compile]}} {{源/文件/的路径1.c 源/文件/的路径2.c...}}`

- 优化编译后程序的性能：

`gcc {{源/文件/的路径.cpp}} -O{{1|2|3|fast}} {{[-o|--output]}} {{可执行/文件/的路径}}`

- 打印版本信息：

`gcc --version`
