# egrep

> 확장 정규식을 사용하여 파일에서 패턴을 찾음 (`?`, `+`, `{}`, `()`, 및 `|` 지원).
> 더 많은 정보: <https://manned.org/egrep>.

- 파일 내에서 패턴 검색:

`egrep "{{검색_패턴}}" {{경로/대상/파일}}`

- 여러 파일 내에서 패턴 검색:

`egrep "{{검색_패턴}}" {{경로/대상/파일1 경로/대상/파일2 ...}}`

- 패턴에 대한 `stdin` 검색:

`cat {{경로/대상/파일}} | egrep {{검색_패턴}}`

- 각 일치 항목의 파일 이름과 줄 번호를 출력:

`egrep --with-filename --line-number "{{검색_패턴}}" {{경로/대상/파일}}`

- 바이너리 파일을 무시하고 디렉터리에서 반복적으로 모든 파일의 패턴을 검색:

`egrep --recursive --binary-files={{without-match}} "{{검색_패턴}}" {{경로/대상/디렉터리}}`

- 패턴과 일치하지 않는 라인 검색:

`egrep --invert-match "{{검색_패턴}}" {{경로/대상/파일}}`
