#!/usr/bin/env python
#
# Time Drive - based on duplicity - Encrypted bandwidth efficient 
# backup. Requires Duplicity Version 0.6.04 released August 01, 2009
#
# Copyright 2009 Rob Oakes	<LyX-Devel@oak-tree>


import timedrive.utils as utils

# Import GrowlPython for Notification on Mac OS X
try:
	import Growl
except:
	pass

# Import PyNotify for Notifications on Ubuntu
try:
	import pynotify
except:
	pass


class UserNotifications:
	"""A class that abstracts the process of registering and posting 
	notifications to the proper daemon.  Uses pynotify on Ubuntu and 
	Growl on Mac OS X."""
	
	def __init__(self):
		try:
			imageTimeDrive = Growl.Image.imageFromPath(utils.find_file("Time-Drive-Matte.png"))
			self.notifier = Growl.GrowlNotifier("Time Drive", ["status"], None, imageTimeDrive)
			self.notifier.register()
		except:
		 	pass
	
	def Notify(self, messageTitle, messageBody):
		"""
		Notifies the user of the current operation.  Accepts two 
		strings, a message title (usually set to the program title), 
		and the body of the message.
		
		@type messageTitle: String
		@param messageTitle:
		@type messageBody: String
		@param messageBody:
		"""
		
		try:
			self.notifier.notify("status", messageTitle, messageBody)
		except:
			pass
		
		try:
			if pynotify.init("Time Drive"):
				pathImageTimeDrive = utils.find_file("Time-Drive-Matte.png")
				userNotification = pynotify.Notification(messageTitle, messageBody, pathImageTimeDrive)
				userNotification.show()
		except:
			pass
