#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
import logging
import logging.handlers
from timedrive.backupsettings import globals
import os

_logger = None

def setup():
	"""Initialize logging"""
	global _logger
	if _logger:
		return

	"""
	Value     Type of interval
	'S'     Seconds
	'M'     Minutes
	'H'     Hours
	'D'     Days
	'W'     Week day (0=Monday)
	'midnight'     Roll over at midnight
	"""
	backupcount = 10
	interval = 1
	when = "D"

	if not os.path.exists(globals.cache_dir):
		try:
			os.makedirs(globals.cache_dir)
		except:
			pass

	#h = logging.handlers.TimedRotatingFileHandler(globals.cache_dir+"/"+globals.LOG_FILENAME, when, interval, backupcount)
	h = logging.FileHandler(globals.cache_dir+"/"+globals.LOG_FILENAME)
	fmt = logging.Formatter("%(asctime)s %(levelname)-5s %(message)s", "%x %X")
	h.setFormatter(fmt)
	_logger = logging.getLogger("time-drive")    
	_logger.setLevel(logging.INFO)
	_logger.addHandler(h)

def Info(msg):
	"""Shortcut used for info messages"""
	Log(msg, logging.INFO)

def Error(msg):
	"""Shortcut used for error messages"""
	Log(msg, logging.ERROR)

def Log(msg, verb_level):
	#incase somebody forgot to setup the log
	if _logger is None:
	    setup()

	_logger.log(verb_level, msg.decode("utf8", "ignore"))
