#!/usr/bin/env python
#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup
# Requires Duplicity Version 0.6.02 released July 08, 2009
#
# Copyright 2009 Rob Oakes	<LyX-Devel@oak-tree>

from PyQt4 import QtCore, QtGui

class TreeSortFilter(QtGui.QSortFilterProxyModel):
	def __init__(self, parent = None): 
		QtGui.QSortFilterProxyModel.__init__(self)
	
	def filterAcceptsRow(self, sourceRow, sourceParent):
		
		if self.filterRegExp().isEmpty():
			return True
		
		current = QtCore.QModelIndex(self.sourceModel().index(sourceRow, self.filterKeyColumn(), sourceParent))
		
		if self.sourceModel().hasChildren(current):
			atLeastOneValidChild = False
			i = 0
			while not atLeastOneValidChild:
				child = QtCore.QModelIndex(current.child(i, current.column()))
				
				if not child.isValid(): # No Valid Child
					break
				
				atLeastOneValidChild = self.filterAcceptsRow(i, current)
				i = i+1
			
			return atLeastOneValidChild
		
		return self.sourceModel().data(current).toString().contains(self.filterRegExp())