# -*- coding: utf-8 -*-
#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup
# Requires Duplicity Version 0.6.02 released July 08, 2009
#
# Copyright 2009 Rob Oakes	<LyX-Devel@oak-tree>

from PyQt4 import QtCore
from PyQt4 import QtGui
from timedrive.utils import gui_utils
import timedrive.utils as utils
from timedrive.backupsettings import includeremoteitem
from timedrive.utils import validate
import timedrive.settingsdialog as settingsdialog

class RemoteConnectionSettingsDialog(settingsdialog.SettingsDialog):
        """Remote Settings Dialog Class: manange the remote settings it self"""

        def __init__(self, parent):
		"""
		Initialization function for RemoteSettingsDialog

        	@type parent: SettingsDialog Object
        	@param parent:
        	"""
		super(RemoteConnectionSettingsDialog, self).__init__(parent)
		gui_utils.loadUi(self, "uiRemoteConnectionSettings.ui")
		self.ui = self
		
		self._includeRemoteItem = None
		self._Validate = validate.Validate()
		
		QtCore.QObject.connect(self.ui.buttonRemoteConnection_Test, QtCore.SIGNAL("clicked()"),
			self.buttonTestConnection_Pressed)
		QtCore.QObject.connect(self.ui.comboRemoteProtocol, 
			QtCore.SIGNAL("activated(const QString &)"),
			self.comboRemoteProtocol_currentIndexChanged)
		QtCore.QObject.connect(self.ui.btnOk, 
			QtCore.SIGNAL("clicked()"), self.btnOk_Pressed)
		QtCore.QObject.connect(self.ui.btnCancel, 
			QtCore.SIGNAL("clicked()"), self.btnCancel_Pressed)
	
	def buttonTestConnection_Pressed(self):
		"""Test the connection to see if it is valid"""
		connectionType = self.ui.comboRemoteProtocol.currentText()
		connectionPath = self.ui.txtRemoteConnection_Host.text()
		connectionPort = self.ui.txtRemoteConnection_Port.text()
		connectionHost = self.ui.txtRemoteConnection_Host.text()
		connectionUsername = self.ui.txtRemoteConnection_Username.text()
		connectionPassword = self.ui.txtRemoteConnection_Password.text()
		self.ui.buttonRemoteConnection_Test.setEnabled(False)
		self.doTestConnection(connectionType, connectionUsername, connectionPassword, connectionHost, connectionPort, connectionPath)
		
	def ShowRemoteResults(self, tstResult):
		"""
		Updates the settings view based on the results of the connection test.
		
		@type tstResult: Boolean
		@param tstResult: result from the test connection url check
		"""
		self.ui.lblTstResult.setVisible(True)
		
		if tstResult == True:
			imageSuccess = QtGui.QPixmap(':/PNG/Resources/Dialog-Ok.png')
			self.ui.lblTstResult.setPixmap(imageSuccess)
		elif tstResult == False:
			imageFailure = QtGui.QPixmap(':/PNG/Resources/Dialog-Cancel.png')
			self.ui.lblTstResult.setPixmap(imageFailure)
		
		self.ui.buttonRemoteConnection_Test.setEnabled(True)
		
	def _get_IncludeRemoteItem(self):
		"""
		Returns a the fields of the ui, as an object
		
		@rtype: IncludeRemoteItem Object
		"""
		if self._includeRemoteItem is None:
			self._includeRemoteItem = includeremoteitem.IncludeRemoteItem()
			self._includeRemoteItem.set_default_values()
			
		self._includeRemoteItem.RemoteName = self.ui.txtRemoteName.text()
		self._includeRemoteItem.LocationRemoteUsername = self.ui.txtRemoteConnection_Username.text()
		self._includeRemoteItem.LocationRemotePassword = self.ui.txtRemoteConnection_Password.text()
		self._includeRemoteItem.LocationRemoteProtocolInt = self.ui.comboRemoteProtocol.currentIndex()
		self._includeRemoteItem.LocationRemoteProtocol = self.ui.comboRemoteProtocol.currentText()
		self._includeRemoteItem.LocationRemotePath = self.ui.txtRemoteConnection_Path.text()
		self._includeRemoteItem.LocationRemotePort = self.ui.txtRemoteConnection_Port.text()
		self._includeRemoteItem.LocationRemoteHost = self.ui.txtRemoteConnection_Host.text()
		
		return self._includeRemoteItem
	
	def _set_IncludeRemoteItem(self, i):
		"""
		sets all the fields based on the object
		
		@type i: IncludeRemoteItem Object
		@param i:
		"""
		if i is None:
			self._includeRemoteItem = includeremoteitem.IncludeRemoteItem()
			self._includeRemoteItem.set_default_values()
		else:
			self._includeRemoteItem = i
			
		self.ui.txtRemoteName.setText(self._includeRemoteItem.RemoteName)
		self.ui.txtRemoteConnection_Username.setText(self._includeRemoteItem.LocationRemoteUsername)
		self.ui.txtRemoteConnection_Password.setText(self._includeRemoteItem.LocationRemotePassword)
		self.ui.comboRemoteProtocol.setCurrentIndex(self._includeRemoteItem.LocationRemoteProtocolInt)
		self.ui.txtRemoteConnection_Path.setText(self._includeRemoteItem.LocationRemotePath)
		self.ui.txtRemoteConnection_Port.setText(str(self._includeRemoteItem.LocationRemotePort))
		self.ui.txtRemoteConnection_Host.setText(self._includeRemoteItem.LocationRemoteHost)
		
		if self.ui.txtRemoteConnection_Port.text() == "" or int(self.ui.txtRemoteConnection_Port.text()) == 0:
			self.ui.txtRemoteConnection_Port.setText(str(utils.getPortProtocol(self.ui.comboRemoteProtocol.currentText())))
		
	IncludeRemoteItem = property(_get_IncludeRemoteItem, _set_IncludeRemoteItem)
	
	def btnOk_Pressed(self):
		"""
		On press ok button, data checks
		results ok: data updates or makes new object
		results not ok: messages returned to the user
		"""
		errorlist = self._validate_fields()
		
		if len(errorlist) <= 0:
			settings = self.parent().backupsettings
			folderName = utils.determine_folderName(self.IncludeRemoteItem)
			folder = utils.findFolder(settings.IncludeList, folderName, utils.textToBackupType(self.IncludeRemoteItem.BackupType))
			if folder is None:
				settings.IncludeList.append(self.IncludeRemoteItem)
		
			self.parent().loadIncludeList()
			self.close()
		else:
			problem_fields = ""
			for msg in errorlist:
				problem_fields = problem_fields + msg + "\n"
				
			QtGui.QMessageBox.warning(self, _("Some fields have invalid input"), problem_fields)

	def _validate_fields(self):
		"""
		Validates the fields for correct input
		
		@rtype: string []
		"""
		errorlist = []
		if not self._Validate.check(self._Validate.STRING, str(self.ui.txtRemoteName.text())):
			errorlist.append(_("Remote name is not valid"))
		if not self._Validate.check(self._Validate.STRING, str(self.ui.txtRemoteConnection_Username.text())):
			errorlist.append(_("username is not valid"))
		if not self._Validate.check(self._Validate.STRING, str(self.ui.txtRemoteConnection_Password.text())):
			errorlist.append(_("password is not valid"))
		if not self._Validate.check(self._Validate.STRING, str(self.ui.txtRemoteConnection_Path.text())):
			errorlist.append(_("path is not valid"))
		if not self._Validate.check(self._Validate.INT, str(self.ui.txtRemoteConnection_Port.text())):
			errorlist.append(_("port is not valid"))
		if not self._Validate.check(self._Validate.HOSTNAME, str(self.ui.txtRemoteConnection_Host.text())):
			errorlist.append(_("host is not valid"))
		
		return	errorlist

	def btnCancel_Pressed(self):
		"""
		On cancel the dialog closses no datachanges are done to the object
		"""
		self.close()

	def comboRemoteProtocol_currentIndexChanged(self, index):
		"""
		When the protocol changes the port changes
		
		@type index: int
		@param index: the selected index of the list
		"""
		self.ui.txtRemoteConnection_Port.setText(str(utils.getPortProtocol(self.ui.comboRemoteProtocol.currentText())))
