#!/usr/bin/env python
#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup
# Requires Duplicity Version 0.6.04 released August 01, 2009.
#
# Copyright 2009 Rob Oakes	<LyX-Devel@oak-tree>


from PyQt4 import QtCore, QtGui, uic

from timedrive.utils import log
from os.path import isfile
import codecs
from timedrive.backupsettings import globals
import os
from timedrive.utils import gui_utils

class LoggingDialog(QtGui.QDialog):
	"""
	Local and Remote Duplicity Log Archive Browser
	"""

	def __init__(self, parent):
		"""
		Initialization function for LoggingDialog
		"""
		QtGui.QDialog.__init__(self, parent)
		uic.properties.Properties._string = gui_utils.translate
		gui_utils.loadUi(self, "uiLogging.ui")
		log.setup()
		
		#read file
		self.filename = globals.cache_dir+"/"+globals.LOG_FILENAME
		self.file_read()

		# add file to watcher
		self.watcher = QtCore.QFileSystemWatcher(self)
		self.watcher.addPath(self.filename)


		# Create Background Threads and Connect Events
		QtCore.QObject.connect(self.buttonCloseWindow, QtCore.SIGNAL("clicked()"), self.close)
		QtCore.QObject.connect(self.buttonSave, QtCore.SIGNAL("clicked()"), self.file_save)
		QtCore.QObject.connect(self.buttonClear, QtCore.SIGNAL("clicked()"), self.file_clear)
		QtCore.QObject.connect(self.watcher, QtCore.SIGNAL("fileChanged(const QString&)"), self.file_changed)

				
	def file_read(self):
		"""
		reads a file
		"""
		if os.path.exists(self.filename):
			s = codecs.open(self.filename, 'r', 'utf-8').read()
			self.textLog.setPlainText(s)
			#go to the last position in the file
			cursor = self.textLog.textCursor()
			cursor.movePosition(QtGui.QTextCursor.End, QtGui.QTextCursor.MoveAnchor)
			self.textLog.setTextCursor(cursor)


	def file_changed(self):
		"""
		when the file changes it re-reads the file
		"""
		self.file_read()
		
	def file_clear(self):
		"""
		wipes the log file
		"""
		open(self.filename, 'w').write(" ")
		self.file_read()

	
	def file_save(self):
		"""
		saves the log file to a given location
		"""
		fd = QtGui.QFileDialog(self)
		self.filename = fd.getSaveFileName()
		if isfile(self.filename):
			open(self.filename, 'w').write(self.textLog.toPlainText())


