#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
from PyQt4 import QtCore
import timedrive.backupsettings
from timedrive.backupsettings import remotesettings
from timedrive.backupsettings import amazons3settings
from timedrive.backupsettings import localsettings

class Settings(remotesettings.RemoteSettings, amazons3settings.AmazonS3Settings, localsettings.LocalSettings):
	"""
	contines all the settings for time-drive
	Only initialized one time.
	implementation of Borg design pattern
	"""
	_shared_state = {}
	_Settings = None

	#stored settings
	_LocalBackup = None
	_RemoteBackup = None
	_AmazonS3Backup = None
	_AutoRemove_OlderThan = None
	_AutoRemove_OlderThan_Duration = None
	_AutoRemove_OlderThan_Units = None
	_AutoRemove_FreeSpace = None
	_AutoRemove_FreeSpace_Size = None
	_AutoRemove_FreeSpace_Units = None	
	_AutoRemove_SmartRemove = None
	_AutoRemove_NamedSnapshots = None	
	_Schedule = None
	_Options_CompressFiles = None
	_Options_EncryptFilesEnabled = None
	_Options_EncryptionKey = None
	_Options_EnableNotifications = None
	_Options_ExcludeHidden = None
	_Options_FullBackupFrequencyEnabled = None
	_Options_FullBackupFrequency = None
	_Advanced_DefaultRestoreEnabled = None
	_Advanced_DefaultRestoreLocation = None
	_Error_Occurred = None

	#temp settings
	_Mode = None

	_IncludeList = list()
	_ExcludeList = list()

	def __init__(self):
		"""
		Initialization function for Settings
		"""
		self.__dict__ = self._shared_state
		if self._Settings is None:
			remotesettings.RemoteSettings.__init__(self)
			amazons3settings.AmazonS3Settings.__init__(self)
			localsettings.LocalSettings.__init__(self)
			timedrive.backupsettings.readSettings(self)
			timedrive.backupsettings.convertOldToNewStyle(self)
			for f in self._IncludeList:
				timedrive.backupsettings.convertOldToNewStyleFolder(f)
	
	def getQSettings(self):
		"""
		QSettings control for the settings storage
		
		@rtype: QSettings Object
		"""
		if self._Settings is None:
			self._Settings = QtCore.QSettings()
		return self._Settings

	def _get_localBackup(self):
		"""
		local backup active indicator
		
		@rtype: Boolean
		"""
		return self._LocalBackup

	def _set_localBackup(self, value):
		"""
		local backup active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._LocalBackup = value

	def _get_remoteBackup(self):
		"""
		remote backup active indicator
		
		@rtype: Boolean
		"""
		return self._RemoteBackup

	def _set_remoteBackup(self, value):
		"""
		remote backup active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._RemoteBackup = value

	def _get_amazonS3Backup(self):
		"""
		amazonS3 backup active indicator
		
		@rtype: Boolean
		"""
		return self._AmazonS3Backup

	def _set_amazonS3Backup(self, value):
		"""
		amazonS3 backup active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._AmazonS3Backup = value

	def _get_autoRemove_OlderThan(self):
		"""
		autoremove olderthan active indicator
		
		@rtype: Boolean
		"""
		return self._AutoRemove_OlderThan

	def _set_autoRemove_OlderThan(self, value):
		"""
		autoremove olderthan active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._AutoRemove_OlderThan = value

	def _get_autoRemove_OlderThan_Duration(self):
		"""
		autoremove olderthan duration
		
		@rtype: int
		"""
		return self._AutoRemove_OlderThan_Duration

	def _set_autoRemove_OlderThan_Duration(self, value):
		"""
		autoremove olderthan duration 
		
		@type value: int
		@param value:
		"""
		self._AutoRemove_OlderThan_Duration = value

	def _get_autoRemove_OlderThan_Units(self):
		"""
		autoremove olderthan units
		
		@rtype: String
		"""
		return self._AutoRemove_OlderThan_Units

	def _set_autoRemove_OlderThan_Units(self, value):
		"""
		autoremove olderthan units
		
		@type value: String
		@param value:
		"""
		self._AutoRemove_OlderThan_Units = value

	def _get_autoRemove_FreeSpace(self):
		"""
		autoremove freespace active indicator
		
		@rtype: Boolean
		"""
		return self._AutoRemove_FreeSpace

	def _set_autoRemove_FreeSpace(self, value):
		"""
		autoremove freespace active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._AutoRemove_FreeSpace = value

	def _get_autoRemove_FreeSpace_Size(self):
		"""
		autoremove freespace size
		
		@rtype: int
		"""
		return self._AutoRemove_FreeSpace_Size

	def _set_autoRemove_FreeSpace_Size(self, value):
		"""
		autoremove freespace size
		
		@type value: int
		@param value:
		"""
		self._AutoRemove_FreeSpace_Size = value

	def _get_autoRemove_FreeSpace_Units(self):
		"""
		autoremove freespace units
		
		@rtype: String
		"""
		return self._AutoRemove_FreeSpace_Units

	def _set_autoRemove_FreeSpace_Units(self, value):
		"""
		autoremove free space units
		
		@type value: int
		@param value:
		"""
		self._AutoRemove_FreeSpace_Units = value

	def _get_autoRemove_SmartRemove(self):
		"""
		autoremove smartremove active indicator
		
		@rtype: Boolean
		"""
		return self._AutoRemove_SmartRemove

	def _set_autoRemove_SmartRemove(self, value):
		"""
		autoremove smart remove active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._AutoRemove_SmartRemove = value

	def _get_autoRemove_NamedSnapshots(self):
		"""
		autoremove names snapshots active indicator
		
		@rtype: Boolean
		"""
		return self._AutoRemove_NamedSnapshots

	def _set_autoRemove_NamedSnapshots(self, value):
		"""
		autoremove named snaphsots active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._AutoRemove_NamedSnapshots = value

	def _get_schedule(self):
		"""
		schedule for the cronjob
		
		@rtype: int
		"""
		return self._Schedule
	
	def _set_schedule(self, value):
		"""
		schedule for cronjob
		
		@type value: Boolean
		@param value:
		"""
		self._Schedule = value

	def _get_options_CompressFiles(self):
		"""
		compress files active indicator
		
		@rtype: Boolean
		"""
		return self._Options_CompressFiles
	
	def _set_options_CompressFiles(self, value):
		"""
		options compress files active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._Options_CompressFiles = value

	def _get_options_EncryptFilesEnabled(self):
		"""
		encrypt files active indicator
		
		@rtype: Boolean
		"""
		return self._Options_EncryptFilesEnabled

	def _set_options_EncryptFilesEnabled(self, value):
		"""
		encrypt files active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._Options_EncryptFilesEnabled = value

	def _get_options_EncryptionKey(self):
		"""
		encryption key
		
		@rtype: String
		"""
		return self._Options_EncryptionKey
	
	def _set_options_EncryptionKey(self, value):
		"""
		encryption key
		
		@type value: String
		@param value:
		"""
		self._Options_EncryptionKey = value

	def _get_options_EnableNotifications(self):
		"""
		notifications active indicator
		
		@rtype: Boolean
		"""
		return self._Options_EnableNotifications

	def _set_options_EnableNotifications(self, value):
		"""
		notifications active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._Options_EnableNotifications = value

	def _get_options_ExcludeHidden(self):
		"""
		exclude hidden active indicator
		
		@rtype: Boolean
		"""
		return self._Options_ExcludeHidden

	def _set_options_ExcludeHidden(self, value):
		"""
		exclude hidden active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._Options_ExcludeHidden = value

	def _get_options_FullBackupFrequencyEnabled(self):
		"""
		full backup active indicator
		
		@rtype: Boolean
		"""
		return self._Options_FullBackupFrequencyEnabled

	def _set_options_FullBackupFrequencyEnabled(self, value):
		"""
		full backup active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._Options_FullBackupFrequencyEnabled = value

	def _get_options_FullBackupFrequency(self):
		"""
		full backup frequency
		
		@rtype: int
		"""
		return self._Options_FullBackupFrequency

	def _set_options_FullBackupFrequency(self, value):
		"""
		full backup frequency
		
		@type value: int
		@param value:
		"""
		self._Options_FullBackupFrequency = value

	def _get_advanced_DefaultRestoreEnabled(self):
		"""
		default restore active indicator
		
		@rtype: Boolean
		"""
		return self._Advanced_DefaultRestoreEnabled

	def _set_advanced_DefaultRestoreEnabled(self, value):
		"""
		default restore active indicator
		
		@type value: Boolean
		@param value:
		"""
		self._Advanced_DefaultRestoreEnabled = value

	def _get_advanced_DefaultRestoreLocation(self):
		"""
		default restore location
		
		@rtype: String
		"""
		return self._Advanced_DefaultRestoreLocation

	def _set_advanced_DefaultRestoreLocation(self, value):
		"""
		default restore location
		
		@type value: String
		@param value:
		"""
		self._Advanced_DefaultRestoreLocation = value

	def _get_error_Occurred(self):
		"""
		error occured set when an error occurs during cronjob
		
		@rtype: Boolean
		"""
		return self._Error_Occurred

	def _set_error_Occurred(self, value):
		"""
		error occured set when an error occurs during cronjob
		
		@type value: Boolean
		@param value:
		"""
		self._Error_Occurred = value
	
	def _get_mode(self):
		"""
		mode if time drive operates in ui or cmd
		
		@rtype: Boolean
		"""
		return self._Mode

	def _set_mode(self, value):
		"""
		mode if time drive operates in ui or cmd
		
		@type value: Boolean
		@param value:
		"""
		self._Mode = value

	def _get_includeList(self):
		"""
		the include list 
		
		@rtype: List
		"""
		return self._IncludeList

	def _get_excludeList(self):
		"""
		the exclude list
		
		@rtype: List
		"""
		return self._ExcludeList

	Settings = property(getQSettings)
	LocalBackup = property(_get_localBackup, _set_localBackup)
	RemoteBackup = property(_get_remoteBackup, _set_remoteBackup)
	AmazonS3Backup = property(_get_amazonS3Backup, _set_amazonS3Backup)
	AutoRemove_OlderThan = property(_get_autoRemove_OlderThan, _set_autoRemove_OlderThan)
	AutoRemove_OlderThan_Duration = property(_get_autoRemove_OlderThan_Duration, _set_autoRemove_OlderThan_Duration)
	AutoRemove_OlderThan_Units = property(_get_autoRemove_OlderThan_Units, _set_autoRemove_OlderThan_Units)
	AutoRemove_FreeSpace = property(_get_autoRemove_FreeSpace, _set_autoRemove_FreeSpace)
	AutoRemove_FreeSpace_Size = property(_get_autoRemove_FreeSpace_Size, _set_autoRemove_FreeSpace_Size)
	AutoRemove_FreeSpace_Units = property(_get_autoRemove_FreeSpace_Units, _set_autoRemove_FreeSpace_Units)
	AutoRemove_SmartRemove = property(_get_autoRemove_SmartRemove, _set_autoRemove_SmartRemove)
	AutoRemove_NamedSnapshots = property(_get_autoRemove_NamedSnapshots, _set_autoRemove_NamedSnapshots)
	Schedule = property(_get_schedule, _set_schedule)
	Options_CompressFiles = property(_get_options_CompressFiles, _set_options_CompressFiles)
	Options_EncryptFilesEnabled = property(_get_options_EncryptFilesEnabled, _set_options_EncryptFilesEnabled)
	Options_EncryptionKey = property(_get_options_EncryptionKey, _set_options_EncryptionKey)
	Options_EnableNotifications = property(_get_options_EnableNotifications, _set_options_EnableNotifications)
	Options_ExcludeHidden = property(_get_options_ExcludeHidden, _set_options_ExcludeHidden)
	Options_FullBackupFrequencyEnabled = property(_get_options_FullBackupFrequencyEnabled, _set_options_FullBackupFrequencyEnabled)
	Options_FullBackupFrequency = property(_get_options_FullBackupFrequency, _set_options_FullBackupFrequency)
	Advanced_DefaultRestoreEnabled = property(_get_advanced_DefaultRestoreEnabled, _set_advanced_DefaultRestoreEnabled)
	Advanced_DefaultRestoreLocation = property(_get_advanced_DefaultRestoreLocation, _set_advanced_DefaultRestoreLocation)
	ErrorOccurred = property(_get_error_Occurred, _set_error_Occurred)
	Mode = property(_get_mode, _set_mode)
	IncludeList = property(_get_includeList)
	ExcludeList = property(_get_excludeList)
