#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
class RemoteSettings(object):
	"""
	RemoteSettings class: holds the remote settings
	"""

	def __init__(self):
                """
		Initialization function for RemoteSettings
		"""
		self._RemoteProtocolInt = 0
		self._RemoteProtocol = None
		self._RemotePath = None
		self._RemotePort = None
		self._RemoteHost = None
		self._RemoteUsername = None
		self._RemotePassword = None

	def set_default_values(self):
		"""
		set all the fields to default values
		"""
		self._RemoteProtocolInt = 0
		self._RemoteProtocol = ""
		self._RemotePath = ""
		self._RemotePort = 0
		self._RemoteHost = ""
		self._RemoteUsername = ""
		self._RemotePassword = ""
		self._RemotePath = ""

	def _get_remoteProtocolInt(self):
                """
		remote protocol int
		
		@rtype: int
		"""
		return self._RemoteProtocolInt

	def _set_remoteProtocolInt(self, value):
                """
		remote prtocol int
		
		@type value: int
		@param value:
		"""
		self._RemoteProtocolInt = value

	def _get_remoteProtocol(self):
                """
		remote protocol
		
		@rtype: String
		"""
                return self._RemoteProtocol

        def _set_remoteProtocol(self, value):
                """
		remote protocol
		
		@type value: String
		@param value:
		"""
                self._RemoteProtocol = value

        def _get_remotePort(self):
                """
		remote port
		
		@rtype: int
		"""
                return self._RemotePort

        def _set_remotePort(self, value):
                """
		remote port
		
		@type value: int
		@param value:
		"""
                self._RemotePort = value
                
        def _get_remotePath(self):
                """
		remote path
		
		@rtype: String
		"""
        	return self._RemotePath

        def _set_remotePath(self, value):
                """
		remote path
		
		@type value: String
		@param value:
		"""
                self._RemotePath = value

        def _get_remoteHost(self):
                """
		remote host
		
		@rtype: String
		"""
                return self._RemoteHost

        def _set_remoteHost(self, value):
                """
		remote host
		
		@type value: String
		@param value:
		"""
                self._RemoteHost = value

        def _get_remoteUsername(self):
                """
		remote username
		
		@rtype: String
		"""
                return self._RemoteUsername

        def _set_remoteUsername(self, value):
                """
		remote username
		
		@type value: String
		@param value:
		"""
                self._RemoteUsername = value

        def _get_remotePassword(self):
                """
		remote password
		
		@rtype: String
		"""
                return self._RemotePassword

        def _set_remotePassword(self, value):
                """
		remote password
		
		@type value: String
		@param value:
		"""
                self._RemotePassword = value

        RemoteUsername = property(_get_remoteUsername, _set_remoteUsername)
        RemotePassword = property(_get_remotePassword, _set_remotePassword)
        RemoteProtocolInt = property(_get_remoteProtocolInt, _set_remoteProtocolInt)
        RemoteProtocol = property(_get_remoteProtocol, _set_remoteProtocol)
        RemotePath = property(_get_remotePath, _set_remotePath)
        RemotePort = property(_get_remotePort, _set_remotePort)
        RemoteHost = property(_get_remoteHost, _set_remoteHost)


