#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
from timedrive.backupsettings import includeitem

class IncludeRemoteItem(includeitem.IncludeItem):
	""" IncludeLocalItem class: definition of an include local item"""
	

	def __init__(self):
		"""
		Initialization function for IncludeItem
		"""
		includeitem.IncludeItem.__init__(self, includeitem.IncludeItem.LOCATION_REMOTE)
		self._RemoteName = None
		self._LocationRemoteProtocolInt = 0
		self._LocationRemoteProtocol = None
		self._LocationRemotePath = None
		self._LocationRemotePort = None
		self._LocationRemoteHost = None
		self._LocationRemoteUsername = None
		self._LocationRemotePassword = None

	def set_default_values(self):
		includeitem.IncludeItem.set_default_values(self)
		self._RemoteName = ""
		self._LocationRemoteProtocolInt = 0
		self._LocationRemoteProtocol = ""
		self._LocationRemotePath = ""
		self._LocationRemotePort = 0
		self._LocationRemoteHost = ""
		self._LocationRemoteUsername = ""
		self._LocationRemotePassword = ""
		self._LocationRemotePath = ""

	def _get_locationRemoteProtocolInt(self):
                """
		Location remote protocol int
		
		@rtype: int
		"""
		return self._LocationRemoteProtocolInt

	def _set_locationRemoteProtocolInt(self, value):
                """
		Location remote protocol int
		
		@type value: int
		@param value:
		"""
		self._LocationRemoteProtocolInt = value

	def _get_locationRemoteProtocol(self):
                """
		Location remote protocol
		
		@rtype: String
		"""
                return self._LocationRemoteProtocol

        def _set_locationRemoteProtocol(self, value):
                """
		Location remote protocol
		
		@type value: String
		@param value:
		"""
                self._LocationRemoteProtocol = value

        def _get_locationRemotePort(self):
                """
		Location remote port
		
		@rtype: int
		"""
                return self._LocationRemotePort

        def _set_locationRemotePort(self, value):
                """
		Location remote port
		
		@type value: int
		@param value:
		"""
                self._LocationRemotePort = value
                
        def _get_locationRemotePath(self):
                """
		Location remote path
		
		@rtype: String
		"""
        	return self._LocationRemotePath

        def _set_locationRemotePath(self, value):
                """
		Location remote path
		
		@type value: String
		@param value:
		"""
                self._LocationRemotePath = value

        def _get_locationRemoteHost(self):
                """
		Location remote host
		
		@rtype: String
		"""
                return self._LocationRemoteHost

        def _set_locationRemoteHost(self, value):
                """
		Location remote host
		
		@type value: String
		@param value:
		"""
                self._LocationRemoteHost = value

        def _get_locationRemoteUsername(self):
                """
		Location remote username
		
		@rtype: String
		"""
                return self._LocationRemoteUsername

        def _set_locationRemoteUsername(self, value):
                """
		Location remote username
		
		@type value: String
		@param value:
		"""
                self._LocationRemoteUsername = value

        def _get_locationRemotePassword(self):
                """
		Location remote password
		
		@rtype: String
		"""
                return self._LocationRemotePassword

        def _set_locationRemotePassword(self, value):
                """
		Location remote password
		
		@type value: String
		@param value:
		"""
                self._LocationRemotePassword = value
	
	def _get_remoteName(self):
		"""
		remote name
		
		@rtype: String
		"""
		return self._RemoteName

	def _set_remoteName(self, value):
		"""
		remote name
		
		@type value: String
		@param value:
		"""
		self._RemoteName = value
		
	RemoteName = property(_get_remoteName, _set_remoteName)
        LocationRemoteUsername = property(_get_locationRemoteUsername, _set_locationRemoteUsername)
        LocationRemotePassword = property(_get_locationRemotePassword, _set_locationRemotePassword)
        LocationRemoteProtocolInt = property(_get_locationRemoteProtocolInt, _set_locationRemoteProtocolInt)
        LocationRemoteProtocol = property(_get_locationRemoteProtocol, _set_locationRemoteProtocol)
        LocationRemotePath = property(_get_locationRemotePath, _set_locationRemotePath)
        LocationRemotePort = property(_get_locationRemotePort, _set_locationRemotePort)
        LocationRemoteHost = property(_get_locationRemoteHost, _set_locationRemoteHost)


