#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
from timedrive.backupsettings import includeitem

class IncludeLocalItem(includeitem.IncludeItem):
	""" IncludeLocalItem class: definition of an include local item"""
	

	def __init__(self):
		"""
		Initialization function for IncludeItem
		"""
		includeitem.IncludeItem.__init__(self, includeitem.IncludeItem.LOCATION_LOCAL)
		self._FolderName = None
	
	def set_default_values(self):
		includeitem.IncludeItem.set_default_values(self)
		self._FolderName = ""
		
	def _get_folderName(self):
		"""
		folder name
		
		@rtype: String
		"""
		return self._FolderName

	def _set_folderName(self, value):
		"""
		folder name
		
		@type value: String
		@param value:
		"""
		self._FolderName = value
		
	FolderName = property(_get_folderName, _set_folderName)