#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
class ExcludeItem(object):
	""" ExcludeItem class: definition of an exclude item"""

	#exclude types
	REGEXP = 1
	FOLDER = 2
	FILE = 3
	
	def __init__(self, item = None, excludeType = 0):
		"""
		Initialization function for ExcludeItem
		
		@type item: String
		@param item: default=None
		@type excludeType: Int (constant)
		@param excludeType: default=0, uses exclude types defined
		"""
		self._Item = item
		self._Type = excludeType
		
	def _get_item(self):
		"""
		exclude item
		
		@rtype: String
		"""
		return self._Item

	def _set_item(self, value):
		"""
		exclude item
		
		@type value: String
		@param value:
		"""
		self._Item = value

	def _get_type(self):
		"""
		exclude type
		
		@rtype: int
		"""
		return self._Type

	def _set_type(self, value):
		"""
		exclude type
		
		@type value: int
		@param value: uses exclude types defined
		"""
		self._Type = value

	Item = property(_get_item, _set_item)
	Type = property(_get_type, _set_type)

