#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
from PyQt4 import QtCore
import includelocalitem
import includeremoteitem
import excludeitem
import settingskeys
import settings
import timedrive.backupsettings

def readSettings(backupSettings):
	"""
	Reads settings from Qsettings stores it into Settings Object
	
	@type backupSettings: Settings Object
	@param backupSettings: 
	"""
	Qsettings = backupSettings.getQSettings()
	backupSettings.LocalBackup = Qsettings.value(settingskeys.keyLocalBackup).toBool()
	backupSettings.LocalBackupDirectory = Qsettings.value(settingskeys.keyLocalBackupDirectory).toString()
	
	# Remote Backup Settings
	backupSettings.RemoteBackup = Qsettings.value(settingskeys.keyRemoteBackup).toBool()
	backupSettings.RemoteProtocolInt = Qsettings.value(settingskeys.keyRemoteProtocolInt).toInt()[0]
	backupSettings.RemoteProtocol = Qsettings.value(settingskeys.keyRemoteProtocol).toString()
	backupSettings.RemotePath = Qsettings.value(settingskeys.keyRemotePath).toString()
	backupSettings.RemotePort = Qsettings.value(settingskeys.keyRemotePort).toString()
	backupSettings.RemoteHost = Qsettings.value(settingskeys.keyRemoteHost).toString()
	backupSettings.RemoteUsername = Qsettings.value(settingskeys.keyUsername).toString()
	backupSettings.RemotePassword = decode(Qsettings.value(settingskeys.keyPassword).toString())

	#Amazon S3 Backup Settings
	backupSettings.AmazonS3Backup = Qsettings.value(settingskeys.keyAmazonS3Backup).toBool()
	backupSettings.AmazonS3_Bucket = Qsettings.value(settingskeys.keyAmazonS3Bucket).toString()
	backupSettings.AmazonS3_AccessId = Qsettings.value(settingskeys.keyAmazonS3AccessId).toString()
	backupSettings.AmazonS3_SecretKey = decode(Qsettings.value(settingskeys.keyAmazonS3SecretKey).toString())
	backupSettings.AmazonS3_LocationInt = Qsettings.value(settingskeys.keyAmazonS3LocationInt).toInt()[0]
	backupSettings.AmazonS3_Location = Qsettings.value(settingskeys.keyAmazonS3Location).toString()

	# Folder Include Settings
	numFolders = Qsettings.beginReadArray(settingskeys.keyIncludeFolders)
	for i in range(numFolders):
		Qsettings.setArrayIndex(i)
		locationtype = Qsettings.value(settingskeys.keyArrayLocationType).toInt()[0]
		#locationtype 0 is that there isn't a different type defined
		if locationtype == includelocalitem.IncludeLocalItem.LOCATION_LOCAL or locationtype == 0:
			f = includelocalitem.IncludeLocalItem()
			f.FolderName = Qsettings.value(settingskeys.keyArrayFolderName).toString()
		elif locationtype == includelocalitem.IncludeLocalItem.LOCATION_REMOTE:
			f = includeremoteitem.IncludeRemoteItem()
			f.RemoteName = Qsettings.value(settingskeys.keyArrayRemoteName).toString()
			f.LocationRemoteProtocolInt = Qsettings.value(settingskeys.keyArrayLocationRemoteProtocolInt).toInt()[0]
			f.LocationRemoteProtocol = Qsettings.value(settingskeys.keyArrayLocationRemoteProtocol).toString()
			f.LocationRemoteUsername = Qsettings.value(settingskeys.keyArrayLocationUsername).toString()
			f.LocationRemotePassword = decode(Qsettings.value(settingskeys.keyArrayLocationPassword).toString())
			f.LocationRemotePath = Qsettings.value(settingskeys.keyArrayLocationRemotePath).toString()
			f.LocationRemotePort = Qsettings.value(settingskeys.keyArrayLocationRemotePort).toInt()[0]
			f.LocationRemoteHost = Qsettings.value(settingskeys.keyArrayLocationRemoteHost).toString()
		
		f.BackupType = Qsettings.value(settingskeys.keyArrayBackupType).toInt()[0]
		f.LocalBackupDirectory = Qsettings.value(settingskeys.keyArrayLocalBackupDir).toString()
		f.RemoteProtocolInt = Qsettings.value(settingskeys.keyArrayRemoteProtocolInt).toInt()[0]
		f.RemoteProtocol = Qsettings.value(settingskeys.keyArrayRemoteProtocol).toString()
		f.RemoteUsername = Qsettings.value(settingskeys.keyArrayUsername).toString()
		f.RemotePassword = decode(Qsettings.value(settingskeys.keyArrayPassword).toString())
		f.RemotePath = Qsettings.value(settingskeys.keyArrayRemotePath).toString()
		f.RemotePort = Qsettings.value(settingskeys.keyArrayRemotePort).toInt()[0]
		f.RemoteHost = Qsettings.value(settingskeys.keyArrayRemoteHost).toString()
		f.EncryptionKeyEnabled = Qsettings.value(settingskeys.keyArrayEncryptionKeyEnabled).toBool()
		f.EncryptionKey = Qsettings.value(settingskeys.keyArrayEncryptionKey).toString()
		
		# Read the Exclude Patterns, Files and Folders
		numExcludeItems = Qsettings.beginReadArray(settingskeys.keyFolderExclusions)
		for k in range(numExcludeItems):
			Qsettings.setArrayIndex(k)
			e = excludeitem.ExcludeItem(Qsettings.value(settingskeys.keyArrayExclusion).toString())
			e.Type = Qsettings.value(settingskeys.keyArrayExclusionType).toInt()[0]
			f.ExcludeList.append(e)

		Qsettings.endArray()
		backupSettings.IncludeList.append(f)			
	
	Qsettings.endArray()

	# Exclude Settings
	numGlobalExclusions = Qsettings.beginReadArray(settingskeys.keyGlobalExclusions)
	for  i in range(numGlobalExclusions):
		Qsettings.setArrayIndex(i)
		e = excludeitem.ExcludeItem(Qsettings.value(settingskeys.keyArrayExclusion).toString())
		e.Type = Qsettings.value(settingskeys.keyArrayExclusionType).toInt()[0]
		backupSettings.ExcludeList.append(e)
	Qsettings.endArray()
	
	# Autoremove Settings - Older Than
	backupSettings.AutoRemove_OlderThan = Qsettings.value(settingskeys.keyAutoRemoveOlderThan).toBool()
	backupSettings.AutoRemove_OlderThan_Duration = Qsettings.value(settingskeys.keyAutoRemoveOlderThanDuration).toInt()[0]
	backupSettings.AutoRemove_OlderThan_Units = Qsettings.value(settingskeys.keyAutoRemoveOlderThanUnits).toInt()[0]
	
	# Autoremove Settings - Free Space
	backupSettings.AutoRemove_FreeSpace = Qsettings.value(settingskeys.keyAutoRemoveFreeSpace).toBool()
	backupSettings.AutoRemove_FreeSpace_Size = Qsettings.value(settingskeys.keyAutoRemoveFreeSpaceSize).toInt()[0]
	backupSettings.AutoRemove_FreeSpace_Units = Qsettings.value(settingskeys.keyAutoRemoveFreeSpaceUnits).toInt()[0]
	
	# Autoremove Settings - Smart Remove
	backupSettings.AutoRemove_SmartRemove = Qsettings.value(settingskeys.keyAutoRemoveSmartRemove).toBool()
	backupSettings.AutoRemove_NamedSnapshots = Qsettings.value(settingskeys.keyAutoRemoveNamedSnapshots).toBool()
	
	# Backup Schedule
	backupSettings.Schedule = Qsettings.value(settingskeys.keySchedule).toInt()[0]
	
	# Archive Options
	backupSettings.Options_CompressFiles = Qsettings.value(settingskeys.keyCompressFiles).toBool()
	backupSettings.Options_EncryptFilesEnabled = Qsettings.value(settingskeys.keyEncryptFiles).toBool()
	backupSettings.Options_EncryptionKey = Qsettings.value(settingskeys.keyEncryptionKey).toString()
	backupSettings.Options_EnableNotifications = Qsettings.value(settingskeys.keyEnableNotifications).toBool()
	backupSettings.Options_ExcludeHidden = Qsettings.value(settingskeys.keyExcludeHidden).toBool()
	backupSettings.Options_FullBackupFrequencyEnabled = Qsettings.value(settingskeys.keyFullBackupFrequencyEnabled).toBool()
	backupSettings.Options_FullBackupFrequency = Qsettings.value(settingskeys.keyFullBackupFrequency).toInt()[0]
	
	#advanced Options
	backupSettings.Advanced_DefaultRestoreEnabled = Qsettings.value(settingskeys.keyAdvancedDefaultRestore).toBool()
	backupSettings.Advanced_DefaultRestoreLocation = Qsettings.value(settingskeys.keyAdvancedDefaultRestoreLocation).toString()

	#error
	backupSettings.Error_Occurred = Qsettings.value(settingskeys.keyErrorOccurred).toBool()

def writeSettings(backupSettings):
	"""
	Stores backup settings using QSettings
	
	@type backupSettings: Settings Object
	@param backupSettings:
	"""
	Qsettings = backupSettings.getQSettings()
	Qsettings.setValue(settingskeys.keyLocalBackup, QtCore.QVariant(backupSettings.LocalBackup))
	Qsettings.setValue(settingskeys.keyLocalBackupDirectory, QtCore.QVariant(str(backupSettings.LocalBackupDirectory)))

	# Remote Backup Settings
	Qsettings.setValue(settingskeys.keyRemoteBackup, QtCore.QVariant(backupSettings.RemoteBackup))
	Qsettings.setValue(settingskeys.keyRemoteProtocolInt, QtCore.QVariant(str(backupSettings.RemoteProtocolInt)))
	Qsettings.setValue(settingskeys.keyRemoteProtocol, QtCore.QVariant(str(backupSettings.RemoteProtocol)))
	Qsettings.setValue(settingskeys.keyRemotePath, QtCore.QVariant(str(backupSettings.RemotePath)))
	Qsettings.setValue(settingskeys.keyRemotePort, QtCore.QVariant(str(backupSettings.RemotePort)))
	Qsettings.setValue(settingskeys.keyRemoteHost, QtCore.QVariant(str(backupSettings.RemoteHost)))
	Qsettings.setValue(settingskeys.keyUsername, QtCore.QVariant(str(backupSettings.RemoteUsername)))
	Qsettings.setValue(settingskeys.keyPassword, QtCore.QVariant(encode(backupSettings.RemotePassword)))
	
	#Amazon S3 Backup Settings
	Qsettings.setValue(settingskeys.keyAmazonS3Backup, QtCore.QVariant(backupSettings.AmazonS3Backup))
	Qsettings.setValue(settingskeys.keyAmazonS3Bucket, QtCore.QVariant(str(backupSettings.AmazonS3_Bucket)))
	Qsettings.setValue(settingskeys.keyAmazonS3AccessId, QtCore.QVariant(str(backupSettings.AmazonS3_AccessId)))
	Qsettings.setValue(settingskeys.keyAmazonS3SecretKey, QtCore.QVariant(encode(backupSettings.AmazonS3_SecretKey)))
	Qsettings.setValue(settingskeys.keyAmazonS3LocationInt, QtCore.QVariant(str(backupSettings.AmazonS3_LocationInt)))
	Qsettings.setValue(settingskeys.keyAmazonS3Location, QtCore.QVariant(str(backupSettings.AmazonS3_Location)))

	# Folders Included in Backup
	Qsettings.remove(settingskeys.keyIncludeFolders)
	Qsettings.beginWriteArray(settingskeys.keyIncludeFolders)
	for f in backupSettings.IncludeList:
		Qsettings.setArrayIndex(backupSettings.IncludeList.index(f))
		if f.LocationType == f.LOCATION_LOCAL:
			Qsettings.setValue(settingskeys.keyArrayFolderName, QtCore.QVariant(str(f.FolderName)))
		elif f.LocationType == f.LOCATION_REMOTE:
			Qsettings.setValue(settingskeys.keyArrayRemoteName, QtCore.QVariant(str(f.RemoteName)))
			Qsettings.setValue(settingskeys.keyArrayLocationRemoteProtocolInt, QtCore.QVariant(str(f.LocationRemoteProtocolInt)))
			Qsettings.setValue(settingskeys.keyArrayLocationRemoteProtocol, QtCore.QVariant(str(f.LocationRemoteProtocol)))
			Qsettings.setValue(settingskeys.keyArrayLocationUsername, QtCore.QVariant(str(f.LocationRemoteUsername)))
			Qsettings.setValue(settingskeys.keyArrayLocationPassword, QtCore.QVariant(encode(f.LocationRemotePassword)))
			Qsettings.setValue(settingskeys.keyArrayLocationRemotePath, QtCore.QVariant(str(f.LocationRemotePath)))
			Qsettings.setValue(settingskeys.keyArrayLocationRemotePort, QtCore.QVariant(str(f.LocationRemotePort)))
			Qsettings.setValue(settingskeys.keyArrayLocationRemoteHost, QtCore.QVariant(str(f.LocationRemoteHost)))
				
		Qsettings.setValue(settingskeys.keyArrayLocationType, QtCore.QVariant(str(f.LocationType)))
		Qsettings.setValue(settingskeys.keyArrayBackupType, QtCore.QVariant(str(f.BackupType)))
		Qsettings.setValue(settingskeys.keyArrayLocalBackupDir, QtCore.QVariant(str(f.LocalBackupDirectory)))
		Qsettings.setValue(settingskeys.keyArrayRemoteProtocolInt, QtCore.QVariant(str(f.RemoteProtocolInt)))
		Qsettings.setValue(settingskeys.keyArrayRemoteProtocol, QtCore.QVariant(str(f.RemoteProtocol)))
		Qsettings.setValue(settingskeys.keyArrayUsername, QtCore.QVariant(str(f.RemoteUsername)))
		Qsettings.setValue(settingskeys.keyArrayPassword, QtCore.QVariant(encode(f.RemotePassword)))
		Qsettings.setValue(settingskeys.keyArrayRemotePath, QtCore.QVariant(str(f.RemotePath)))
		Qsettings.setValue(settingskeys.keyArrayRemotePort, QtCore.QVariant(str(f.RemotePort)))
		Qsettings.setValue(settingskeys.keyArrayRemoteHost, QtCore.QVariant(str(f.RemoteHost)))
		Qsettings.setValue(settingskeys.keyArrayEncryptionKeyEnabled, QtCore.QVariant(f.EncryptionKeyEnabled))
		Qsettings.setValue(settingskeys.keyArrayEncryptionKey, QtCore.QVariant(str(f.EncryptionKey)))

		# Folder Specific Exclusions
		Qsettings.beginWriteArray(settingskeys.keyFolderExclusions)
		for e in f.ExcludeList:
			Qsettings.setArrayIndex(f.ExcludeList.index(e))
			Qsettings.setValue(settingskeys.keyArrayExclusion, QtCore.QVariant(str(e.Item)))
			Qsettings.setValue(settingskeys.keyArrayExclusionType, QtCore.QVariant(str(e.Type)))
		Qsettings.endArray()
		
	Qsettings.endArray()

	# Global Exclude Patterns
	Qsettings.remove(settingskeys.keyGlobalExclusions)
	Qsettings.beginWriteArray(settingskeys.keyGlobalExclusions)
	for e in backupSettings.ExcludeList:
		Qsettings.setArrayIndex(backupSettings.ExcludeList.index(e))
		Qsettings.setValue(settingskeys.keyArrayExclusion, QtCore.QVariant(str(e.Item)))
		Qsettings.setValue(settingskeys.keyArrayExclusionType, QtCore.QVariant(str(e.Type)))
	Qsettings.endArray()
	
	# Autoremove Settings - Older Than
	Qsettings.setValue(settingskeys.keyAutoRemoveOlderThan, QtCore.QVariant(backupSettings.AutoRemove_OlderThan))
	Qsettings.setValue(settingskeys.keyAutoRemoveOlderThanDuration, QtCore.QVariant(str(backupSettings.AutoRemove_OlderThan_Duration)))
	Qsettings.setValue(settingskeys.keyAutoRemoveOlderThanUnits, QtCore.QVariant(str(backupSettings.AutoRemove_OlderThan_Units)))
	
	# Autoremove Settings - Free Space
	Qsettings.setValue(settingskeys.keyAutoRemoveFreeSpace, QtCore.QVariant(backupSettings.AutoRemove_FreeSpace))
	Qsettings.setValue(settingskeys.keyAutoRemoveFreeSpaceSize, QtCore.QVariant(str(backupSettings.AutoRemove_FreeSpace_Size)))
	Qsettings.setValue(settingskeys.keyAutoRemoveFreeSpaceUnits, QtCore.QVariant(str(backupSettings.AutoRemove_FreeSpace_Units)))

	# Autoremove Settings - Smart Remove
	Qsettings.setValue(settingskeys.keyAutoRemoveSmartRemove, QtCore.QVariant(backupSettings.AutoRemove_SmartRemove))
	Qsettings.setValue(settingskeys.keyAutoRemoveNamedSnapshots, QtCore.QVariant(backupSettings.AutoRemove_NamedSnapshots))
	
	# Backup Schedule
	Qsettings.setValue(settingskeys.keySchedule, QtCore.QVariant(backupSettings.Schedule))
	
	# Archive Options
	Qsettings.setValue(settingskeys.keyCompressFiles, QtCore.QVariant(backupSettings.Options_CompressFiles))
	Qsettings.setValue(settingskeys.keyEncryptFiles, QtCore.QVariant(backupSettings.Options_EncryptFilesEnabled))
	Qsettings.setValue(settingskeys.keyEncryptionKey, QtCore.QVariant(str(backupSettings.Options_EncryptionKey)))
	Qsettings.setValue(settingskeys.keyEnableNotifications, QtCore.QVariant(backupSettings.Options_EnableNotifications))
	Qsettings.setValue(settingskeys.keyExcludeHidden, QtCore.QVariant(backupSettings.Options_ExcludeHidden))
	Qsettings.setValue(settingskeys.keyFullBackupFrequencyEnabled, QtCore.QVariant(backupSettings.Options_FullBackupFrequencyEnabled))
	Qsettings.setValue(settingskeys.keyFullBackupFrequency, QtCore.QVariant(str(backupSettings.Options_FullBackupFrequency)))

	# advanced
	Qsettings.setValue(settingskeys.keyAdvancedDefaultRestore, QtCore.QVariant(backupSettings.Advanced_DefaultRestoreEnabled))
	Qsettings.setValue(settingskeys.keyAdvancedDefaultRestoreLocation, QtCore.QVariant(str(backupSettings.Advanced_DefaultRestoreLocation)))

	#error
	Qsettings.value(settingskeys.keyErrorOccurred, QtCore.QVariant(backupSettings.Error_Occurred))

def encode(password):
	"""
	encodes the a given value in base64
	
	@type password: String
	@param password:
	
	@rtype: String
	"""
	return (str(password).encode("utf8")).encode("base64")

def decode(password):
	"""
	decodes the a given value from base64
	
	@type password: String
	@param password:
	
	@rtype: String
	"""
	return str(password).decode("base64")

def convertOldToNewStyle(settings):
	"""
	Changes has been made in the config file, this is for backwords compatiblity
	
	@type settings: Settings Object
	@param settings:
	"""
	if settings.RemotePort == "" and settings.RemoteHost == "" and (not settings.RemotePath == ""):
		settings.RemotePort = timedrive.utils.getPortProtocol(settings.RemoteProtocol)
		settings.RemoteHost = str(settings.RemotePath).split("//")[0]
		settings.RemotePath = "/"+str(settings.RemotePath).split("//")[1]

def convertOldToNewStyleFolder(folder):
	"""
	Changes has been made in the config file, this is for backwords compatiblity
	
	@type folder: IncludeLocalItem Object
	@param folder:
	"""
	if folder.RemotePort == "" and folder.RemoteHost == "" and (not folder.RemotePath == ""):
		folder.RemotePort = timedrive.utils.getPortProtocol(settings.RemoteProtocol)
		folder.RemoteHost = str(folder.RemotePath).split("//")[0]
		folder.RemotePath = "/"+str(folder.RemotePath).split("//")[1]
	
