#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
from PyQt4 import QtCore
from timedrive.background import backgroundtask
import timedrive.utils as utils
import os
from timedrive.utils import duplicity_interface
from timedrive.utils import gui_utils
from timedrive.utils import archiveurl

class TestConnectionControl(object):
	"""
	TestConnectionControl class: Control over the TestConnection from the different used classes
	"""
	
	_TestConnectionUrl = None
	
	def doTestConnection(self, protocol, username, password, host, port, path, includeName = None):
		"""
		does a test if the connection data is valid and if the server is online
		
		@type protocol: String
		@param protocol:
		@type username: String
		@param username:
		@type password: String
		@param password:
		@type host: String
		@param host:
		@type port: String
		@param port:
		@type path: String
		@param path:
		@type includeName: String
		@param includeName: default=None
		"""
		#create class on use because it's not always used
		if self.TestConnectionUrl is None:
			self.setupTestConnection()
			
		#connect each time it's called, so the result is send to the correct method
		QtCore.QObject.connect(self.TestConnectionUrl, QtCore.SIGNAL("output(bool)"), 
			self.ShowRemoteResults)
		
		if protocol == "file":
			fullUrl = archiveurl.buildLocalUrl(path, includeName)
			self.TestConnectionUrl.TestUrl(fullUrl)
			
		elif protocol == "AmazonS3":
			fullUrl = archiveurl.buildAmazonS3Url(os.path.normpath(str(host)), includeName)
			S3_LoginInfo = username + " " + password
			self.TestConnectionUrl.TestUrl(fullUrl, S3_LoginInfo)
			
		else:
			#Additional testing for remote servers
			if gui_utils.checkRemoteSettings(self, str(host)):
				if utils.server_available(host, port):
					fullUrl = archiveurl.buildRemoteUrl(protocol, username, password, host, port, path, includeName)
					self.TestConnectionUrl.TestUrl(fullUrl)
				else:					
					self.ShowRemoteResults(False)
			else:
				self.ShowRemoteResults(False)
				
	def ShowRemoteResults(self, tstResult):
		"""
		used as a abstract class need to be defined in each class that inherits this class
		
		@type tstResult: Boolean
		@param tstResult: result from the test connection url check
		"""
		pass
	
	def setupTestConnection(self):
		"""
		setup test connection check used in doTestConnection
		"""
		self.TestConnectionUrl = TestConnectionUrl(self)
		
	def _get_testConnectionUrl(self):
		"""
		test connection url
		
		@rtype: TestConnectionUrl Object
		"""
		return self._TestConnectionUrl
	
	def _set_testConnectionUrl(self, value):
		"""
		test connection url
		
		@type value: TestConnectionUrl object
		@param value:
		"""
		self._TestConnectionUrl = value
		
	TestConnectionUrl = property(_get_testConnectionUrl, _set_testConnectionUrl)

class TestConnectionUrl(backgroundtask.BackgroundTask):
	"""Class to check a connection url.  Provides feedback to the user whether
	the connection is valid or not."""
	
	def __init__(self, parent = None):
		"""
		Initialization function for TestConnectionUrl
		
		@type parent: BackgroundTask Object
		@param parent:
		"""
		super(TestConnectionUrl, self).__init__("TestConnectionUrl", parent)
		self.exiting = False
		self.archive_url = None
		self.S3_LoginInfo = None
	
	def __del__(self):
		self.exiting = True
		self.wait()
	
	def TestUrl(self, archiveUrl, S3_LoginInfo = None):
		"""
		test a giving archive url in normal mode
		
		@type archiveUrl: String
		@param archiveUrl: the url of the selected archive
		
		@type S3_LoginInfo: tulp as string
		@param S3_LoginInfo: default = None:
		"""
		self.archive_url = archiveUrl
		self.S3_LoginInfo = S3_LoginInfo
		self.start()
	
	def run(self):
		"""Tests the archive_url to see if it is valid."""
		S3_AccessId = None
		S3_SecretKey = None
		S3_BucketType = None
		
		if self.S3_LoginInfo != None:
			S3_AccessId, S3_SecretKey = self.S3_LoginInfo.split(" ")
		
		tstResult = duplicity_interface.test_connection_url(self.archive_url,
			S3_AccessId, S3_SecretKey, S3_BucketType)
		
		self.emit(QtCore.SIGNAL("output(bool)"), tstResult)