#
# Time Drive - based on duplicity - Encrypted bandwidth efficient backup.
#
from timedrive.utils import duplicity_interface
from timedrive.background import backgroundtask

class RestoreFiles(backgroundtask.BackgroundTask):
	"""Background class that restores files from the remote backup."""
	
	def __init__(self, parent = None):
		"""
		Initialization function for Restore Files
		
		@type parent: BackgroundTask Object
		@param parent:
		"""
		super(RestoreFiles, self).__init__(_("Restore Files"), parent)
		self.exiting = False
		self.destination = None
		self.RestoreList = None
	
	def StartRestore(self, RestoreList, settings, destination = None):
		"""
		Restore a given list of files to a given location
		
		@type RestoreList: { } custom array 
		@param RestoreList: list of files to restore
		@type settings: Settings Object
		@param settings: valid settings object
		@type destination: String
		@param destination: default : None , a path to where to save the files
		"""
		self.settings = settings
		self.RestoreList = RestoreList

		if destination is not None or self.settings.Advanced_DefaultRestoreEnabled == True:
			if destination is None:
				self.destination = self.settings.Advanced_DefaultRestoreLocation
			else:
				self.destination = destination
			self.start()
		else:
			self.destination = None
			self.RestoreList = None
		
	
	def run(self):
		"""Main thread method.  Toggles restore options on/off and then 
		restores the files."""
		
		S3_AccessId_Settings = None
		S3_SecretKey_Settings = None
		S3_BucketType_Settings = None
		
		self.default_message = _("Restoring Files ... ")
		
		#Setup ProgressBar
		numItems = len(self.RestoreList)
		self.setupTaskProgress(numItems)
		progress = 0		
		
		# Set Amazon S3 Secret Key and Access Id
		if self.settings.AmazonS3Backup == True:
			S3_AccessId_Settings = self.settings.AmazonS3_AccessId
			S3_SecretKey_Settings = self.settings.AmazonS3_SecretKey
		
		if self.settings.AmazonS3_Location == "European":
			S3_BucketType_Settings = self.settings.AmazonS3_Location

		# Main Restore Operation
		for restoreFile in self.RestoreList:
			if self.stop:
				continue
			
			relativePath, archiveUrl, gnuPassphrase, restoreTime, S3_LoginInfo_Folder = self.RestoreList[restoreFile]
			
			self.updateTaskProgress(progress, _("Restoring %s") % relativePath)
			
			# Restore from the most recent snapshot
			if (restoreTime == 'Most Current')|(restoreTime == 'Most Recent'):
				
				# Use global settings for Amazon S3
				if S3_LoginInfo_Folder == '':
					duplicity_interface.restore_file(relativePath, archiveUrl, 
						gnuPassphrase, self.destination, None, 
						S3_AccessId_Settings, S3_SecretKey_Settings, 
						S3_BucketType_Settings)
				
				# Use either remote or folder specific settings for Amazon S3
				else:
					S3_AccessId_Folder, S3_SecretKey_Folder = S3_LoginInfo_Folder.split()
					duplicity_interface.restore_file(relativePath, archiveUrl,
						gnuPassphrase, self.destination, None,
						S3_AccessId_Folder, S3_SecretKey_Folder, 
						S3_BucketType_Settings)
			
			# Restore from a previous snapshot
			else:
				duplicity_interface.restore_file(relativePath, archiveUrl, 
					gnuPassphrase, self.destination, restoreTime, 
					S3_AccessId_Settings, S3_SecretKey_Settings, 
					S3_BucketType_Settings)
			
			progress = progress + 1
		
		self.updateTaskProgress(numItems)
		self.taskComplete(self.task_name, _("Files Restored Successfully"))

