import sys, os, getopt, glob
from distutils.core import setup, Extension

data_files = [('share/pixmaps', 
				['ui/Resources/Time-Drive-Matte.png',
				'ui/Resources/Time-Drive-Icon-Small.png',]),
		('share/applications', ['time-drive.desktop',]),
		('share/time-drive', ['ui/uiLogging.ui',
					'ui/uiRestoreFiles.ui',
					'ui/uiAdvancedFolderSettings.ui',
					'ui/uiRemoteConnectionSettings.ui',
					'ui/uiMainWindow.ui',
					'ui/uiSettings.ui']),]

for filepath in glob.glob("locale/*/LC_MESSAGES/*.mo"):
	targetpath = os.path.dirname(os.path.join("share/", filepath))
	data_files.append((targetpath, [filepath]))

setup(name="time-drive",
      version="0.4.0",
      description="Linux Backup, Done Right",
      author="Rob Oakes	<LyX-Devel@oak-tree>",
      author_email="LyX-Devel@oak-tree",
      maintainer="Philippe Delodder <lodder@delodder.be>",
      maintainer_email="lodder@delodder.be",
      url="http://www.oak-tree.us/blog/index.php/science-and-technology/time-drive",
      packages = ['timedrive',
			'timedrive.utils',
		   	'timedrive.background',
			'timedrive.backupsettings'],
      package_dir = {"timedrive" : "timedrive",
			"time-drive.utils" : "timedrive/utils",
			"timedrive.background" : "timedrive/background",
			"timedrive.backupsettings" : "timedrive/backupsettings"},
	  scripts = ['time-drive', 'timedrive-backup'],
	  data_files = data_files,
      )
