[CmdletBinding()]
param(
    [Parameter(Mandatory=$true)][string]$ExtractedSources,
    [Parameter(Mandatory=$true)][string]$ControlFileIn,
    [Parameter(Mandatory=$true)][string]$ControlFile,
    [Parameter(Mandatory=$true)][string]$CMakeFragmentFile
)

$subfolders = Get-Item $ExtractedSources\aws-cpp-sdk-*

$controltext = gc $ControlFileIn
$controltext += @("# Automatically generated by generateFeatures.ps1")

$cmakefragmenttext = @("# Automatically generated by generateFeatures.ps1")

function GetDescription($dir, $modulename)
{
    if (Test-Path "$dir\CMakeLists.txt")
    {
        $descs = @(Select-String -Path "$dir\CMakeLists.txt" -Pattern "`"C\+\+ SDK for the AWS [^`"]*`"")
        if ($descs.count -eq 1) {
            $desc = $descs[0].Matches.Value -replace "`"",""
            "Description: $desc"
        }
        else { "Description: C++ SDK for the AWS $modulename service" }
    }
    else { "Description: C++ SDK for the AWS $modulename service" }
}

$subfolders | % {
    $modulename = $_.name -replace "^aws-cpp-sdk-",""
    if ($modulename -match "-tests`$") { return }
    if ($modulename -match "-sample`$") { return }
    if ($modulename -eq "core") { return }

    $controltext += @("")
    $controltext += @("Feature: $modulename")
    $controltext += @(GetDescription $_ $modulename)

    $cmakefragmenttext += @(
        "if(`"$modulename`" IN_LIST FEATURES)",
        "  list(APPEND BUILD_ONLY $modulename)",
        "endif()"
    )
}

Write-Verbose ($controltext -join "`n")
[IO.File]::WriteAllText($ControlFile, ($controltext -join "`n")+"`n")

Write-Verbose ($cmakefragmenttext -join "`n")
[IO.File]::WriteAllText($CMakeFragmentFile, ($cmakefragmenttext -join "`n") +"`n")
