<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only translates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release


// ### Note for translators about translation of text ending with punctuation
// ###
// ### The current list of concerned punctuation can be found in 'lib/init/tra.php'
// ### On 2009-03-02, it is: (':', '!', ';', '.', ',', '?')
// ### For clarity, we explain here only for colons: ':' but it is the same for the rest
// ###
// ### Short version: it is not a problem that string "Login:" has no translation. Only "Login" needs to be translated.
// ###
// ### Technical justification:
// ### If a string ending with colon needs translating (like "{tr}Login:{/tr}")
// ### then TikiWiki tries to translate 'Login' and ':' separately.
// ### This allows to have only one translation for "{tr}Login{/tr}" and "{tr}Login:{/tr}"
// ### and it still allows to translate ":" as "&nbsp;:" for languages that
// ### need it (like french)

$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"num is optional and is the order number of the attachment in the list. If not provided, a list of all attachments is displayed.  Inline makes the comment be the text of the link." => "num is facultatief en stelt de rangorde voor van de bijlage in de lijst. Indien niet opgegeven; zal een lijst van alle beschikbare bijlagen worden getoond. Het commentaar kan als tekst voor de koppeling gebruikt worden.",
"requested a reset of the password for the" => "heeft een reset van het wachtwoord gevraagd voor de",
"The old password remains active until you activate the new one by following this link:" => "Het oude wachtwoord blijft actief totdat u het nieuwe wachtwoord activeert door deze koppeling te volgen:",
"This is only a temporary password. After you logged in with it, you will get to the 'change password' dialog." => "Dit is slechts een tijdelijk wachtwoord. Nadat u zich heeft aangemeld, zal u een 'Verander wachtwoord' venster te zien krijgen.",
"If you people want to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "Als je wil dat gebruikers je kunnen antwoorden, zorg er dan voor dat de optie <a href='tiki-user_preferences.php'>Laat berichten toe van andere gebruikers</a> aanstaat",
"reply to" => "antwoord op",
"List Courses" => "Lijst Klassen",
"Site Calendar" => "Site Kalender",
"Use Quote plugin for quoting" => "Gebruik Quote plugin om tekst aan te halen",
"Hide disabled sections" => "Verberg uitgeschakelde secties",
"Show disabled sections" => "Toon uitgeschakelde secties",
"Users choose project categories" => "Gebruikers kiezen projectcategorie&euml;n",
"Prefix for Project Admin groups" => "Prefix voor Project Admin groepen",
"Prefix for Project groups" => "Prefix for Project groepen",
"Prefix for Wiki project home page" => "Prefix voor Wiki project thuispagina",
"Prefix for File Galleries" => "Prefix voor Bestandgalerijen",
"Project Admins group template" => "Project Beheerders groep sjabloon",
"Create New Group" => "Maak Nieuwe Groep aan",
"Project Members group template" => "Project Leden groep sjabloon",
"Batch upload (CSV file<a {popup text='login,password,email'}><img src=\"pics/icons/help.png\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}help" => "Bulk aanlevering (CSV bestand<a {popup text='login,password,email'}><img src=\"pics/icons/help.png\" border=\"0\" height=\"16\" width=\"16\" alt='{tr}hulp",
"slideshow_p" => "slideshow_p",
"slideshow backward" => "slideshow achterwaarts",
"slideshow_n" => "slideshow_n",
"For more information, please see <a href=\"{\$helpurl}WikiSyntax\">WikiSyntax</a>" => "Voor meer informatie, zie ook <a href=\"{\$helpurl}WikiSyntax\">Wiki Schrijfwijze</a>",
"{literal}{MODULE(module=>some_module)}text{MODULE}{/literal}  can be used to insert the output of module \"some_module\" into your Wiki page. See <a href=\"{\$helpurl}PluginModule\">PluginModule</a> for more information. " => "{literal}{MODULE(module=>some_module)}text{MODULE}{/literal} kan worden gebruikt om de uitvoer van de module \"some_module\" op te nemen in uw Wiki pagina. Zie <a href=\"{\$helpurl}PluginModule\">PluginModule</a> voor meet informatie. ",
"{literal}{CODE()}some code{CODE} {/literal} will render \"some code\" as program code. This plugin has other options; see <a href=\"{\$helpurl}PluginCode\">PluginCode</a>." => "{literal}{CODE()}some code{CODE} {/literal} zal \"some code\" herwerken als programma code. Deze plugin heeft andere opties; zie <a href=\"{\$helpurl}PluginCode\">PluginCode</a>.",
"Project Object Created Successfully" => "Projectobject met succes aangemaakt",
"Project Name:" => "Projectnaam:",
"Project Description:" => "Projectbeschrijving:",
"Project Active" => "Actief Project",
"Current Objects:" => "Huidige Objecten:",
"Add a File Gallery" => "Voeg een Bestandgalerij toe",
"Project Admin" => "Project Beheerder",
"Project Members" => "Project Leden",
"Not Set" => "Niet gezet",
"Number Members" => "Aantal leden",
"Number Admins" => "Aantal beheerder",
"No projects found" => "Geen projecten gevonden",
"Edit Project" => "Bewerk Project",
"Add Blog" => "Voeg Blog toe",
"Add Articles" => "Voeg Artikelen toe",
"Add Calendar" => "Voeg Kalender toe",
"Add FAQ" => "Voeg FAQ toe",
"Add File Gallery" => "Voeg Bestandgalerij toe",
"Add Forum" => "Voeg Forum toe",
"Add Image Gallery" => "Voeg Afbeeldinggalerij",
"Add Newsletter" => "Voeg Nieuwsbrief toe",
"Add URL" => "Voeg URL toe",
"Not rated yet" => "Nog niet beoordeeld",
"Jukebox preference" => "Jukebox voorkeuren",
"Removed %s from group %s" => "Verwijderd %s uit groep %s",
"Invalid username or activation code" => "Ongeldige gebruikersnaam of activatie code",
"Jukebox" => "Jukebox",
"TikiTabs" => "TikiTabs",
"Tracks" => "Tracks",
"Genre" => "Genre",
"You do not have permission to use this feature." => "U heeft geen permissie om dit onderdeel te gebruiken.",
"no description" => "geen beschrijving",
"Updated" => "Bijgewerkt",
"Textarea options: options,width,height,max with option is 1 or 0, rest is size indicated in chars and lines, max is the maximum number of characters that can be saved." => "Textarea opties: opties,breedte,hoogte,max met optie is 1 of 0, de rest is de grootte aangegeven in karakters en lijnen, max is het maximum aantal karakters kan worden opgeslagen.",
"Image options: xSize,ySize indicated in pixels." => "Afbeelding opties: xSize,ySize opgegeven in pixels.",
"Category options: parentId" => "Categorie opties: ouderId",
"Item Link options: trackerId,fieldId links to item from trackerId which fieldId matches the content of that field." => "Item Koppeling opties: trackerId,fieldId verwijst naar trackerId wiens fieldId overeenkomt met de inhoud van dat veld.",
"Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere." => "Items lijst opties: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere toont de lijst van displayFieldIdThere van items in tracker trackerId wiens fieldIdThere overeenkomt met fieldIdHere.",
"~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insert articles into a wikipage" => "~np~{~/np~ARTICLES(max=>3,topic=>topicName)}{ARTICLES} Insluiten artikelen in een wikipagina",
"You need to supply information for : " => "U moet informatie ingeven voor : ",
"missing tracker ID for plugin TRACKER" => "tracker ID voor plugin tracker ontbreekt",
"Tip: hold down CTRL to select multiple categories" => "Tip: hou de CTRL toets ingedrukt om meerdere categorie&euml;n te selecteren",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Tip: wis het bovenstaande selectieveld leeg om deze pagina/object uit de categorie&euml;n te verwijderen",
"someone coming from IP Address" => "iemand komende van IP Adres",
"requested a reminder of the password for the" => "heeft een herinnering aangevraagd voor het password voor de",
"Information:" => "Informatie:",
"New blog post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Nieuw blog bericht: {\$mail_title} door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"Please" => "Aub",
"log in" => "meld u aan",
"to access full functionalities" => "om toegang te krijgen tot de volledige functionaliteit",
"Jukebox settings" => "Jukebox instellingen",
"Jukebox tracks location" => "Jukebox tracks locatie",
"Jukebox features" => "Jukebox onderdelen",
"Default ordering for album listing" => "Standaardvolgorde van albumlijst",
"Album title (asc)" => "Albumtitel (stijgend)",
"Number of tracks (desc)" => "Aantal tracks (dalend)",
"In album listing show user as" => "In de albumlijst toon de gebruiker als",
"Jukebox listing configuration (when listing available albums)" => "Jukeboxlijst configuratie (bij het opsommen van beschikbare albums)",
"Create a group for each user <br />(with the same\nname as the user)" => "Maak een groep aan voor elke gebruiker <br />(met dezelfde\nnaam als de gebruiker)",
"Remind passwords by email" => "Wachtwoorden in herinnering brengen via e-mail",
"Like pages" => "Gelijkaardige pagina's",
"Use {literal}{{/literal}ed id=name} or {literal}{{/literal}ted id=name} to insert dynamic zones" => "Gebruik {literal}{{/literal}ed id=naam} or {literal}{{/literal}ted id=naam} om een dynamische zone in te voegen",
"Category: wiki, tracker, etc." => "Categorie: wiki, tracker, etc.",
"Field is public? (for use thru trackerlist plugin)" => "Veld is publiek? (voor gebruik in de trackerlijst plugin)",
"Field is hidden? (visible by admin only)" => "Veld is verborgen? (enkel zichtbaar voor beheerders)",
"Added users" => "Toegevoegde gebruikers",
"Note: if you want to use images please save the post first and you\nwill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\nor use the image URL to include images using the WYSIWYG editor" => "Noot: indien u afbeeldingen wilt gebruiken, bewaar het bericht dan eerst en\nbewerk of voeg dan de afbeelding toe. Gebruik het &lt;img&gt; teken om afbeeldingen in de tekstbewerker in te sluiten\nof gebruik het URL om de afbeelding toe te voegen via de WYSIWYG bewerker.",
"search category" => "categorie doorzoeken",
"deep" => "diep",
"Textheight" => "Teksthoogte",
"Height of top Heading" => "Hoogte van de bovenste Hoofding",
"Height of mid Heading" => "Hoogte van de middelste Hoofding",
"Height of inner Heading" => "Hoogte van de binnenste Hoofding",
"tbheight" => "tbhoogte",
"Automatic Page Breaks" => "Automatische Pagina-onderbrekingen ",
"Emphasis" => "Nadruk",
"italics" => "cursief",
"both" => "beide",
"use ...page... to separate pages" => "gebruik ...page... om te pagineren",
"make_headings" => "maak_titels",
"underlines text" => "onderstreept tekst",
"creates an editable drawing named foo" => "maak een bewerkbare tekening aan genaamd foo",
"Simple box" => "Eenvoudig tekstkader",
"Will display using the indicated HTML color" => "Zal getoond worden met de aangegeven HTML-kleur",
"Will display the text centered" => "Zal de tekst gecentreerd tonen",
"Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done)." => "Toont voorgeformatteerde tekst/code; geen wiki vertaling zal worden toegepast binnen deze secties (zie ook np) en de spati&euml;ring is vast (er wordt geen woordomslag toegepast)",
"Insert Module Output" => "Voeg Module Uitvoer in",
"Rendering Program Code" => "Vertaling programmacode",
"Activs" => "Activn",
"Ins" => "Inc",
"time" => "tijd",
"topics in this forum" => "onderwerpen in dit forum",
"The passwords dont match" => "De wachtwoorden komen niet overeen",
"The passwords didn't match" => "De wachtwoorden komen niet overeen",
"You do not have permission to write the template" => "U heeft geen toestemming om de sjabloon te schrijven",
"Go to your <a href=\"tiki-friends.php\">friendship network</a> to accept or refuse this request" => "Ga naar uw <a href=\"tiki-friends.php\">vriendschapsnetwerk</a> om dit verzoek te aanvaarden of te weigeren",
"A new password and your IP address has been sent " => "Een nieuw wachtwoord en IP adres werden verzonden ",
"Invalid variable value : " => "Ongeldige waarde voor variabele : ",
"%H:%M:%S %Z" => "%H:%M:%S %Z",
"score" => "score",
"wiki help" => "wiki help",
"ok" => "ok",
"HTTPS Server" => "HTTPS Server",
"Site logo" => "Site logo",
"Site Menu" => "Site Menu",
"loc" => "loc",
"cat" => "cat",
"prio" => "prio",
"perso" => "perso",
"dsn" => "dsn",
"extwiki" => "extwiki",
"online" => "online",
"ppd" => "ppd",
"label" => "label",
"items" => "items",
"hit" => "hit",
"stop" => "stop",
"save_to" => "save_to",
"monitor" => "monitor",
"adm" => "adm",
"site" => "site",
"item" => "item",
"uploaded by" => "aangeleverd door",
"not specified" => "niet gespecifieerd",
"There was a problem with your upload." => "Er is een probleem met uw aanlevering.",
"The file you are trying to upload is too big." => "Het bestand dat u wenst aan te leveren is te groot.",
"The file you are trying to upload was only partially uploaded." => "Het bestand dat u wenst aan te leveren, werd slechts gedeeltelijk getransfereerd.",
"You must select a file for upload." => "U moet een bestand opgeven voor de aanlevering.",
"%s is an empty archive file" => "%s is een leeg archiefbestand",
"Invalid remote file on url %s" => "Ongeldig ver bestand op url %s",
"Project Group for " => "Project Groep voor ",
"Project Admin Group for " => "Projectbeheer Groep voor ",
"%A %d of %B, %Y" => "%A %d van %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d van %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d van %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d van %b, %Y[%H:%M %Z]",
"User Selector: use options for automatic field feeding : you can use 1 for author login or 2 for modificator login." => "Gebruikerskiezer: gebruik opties voor automische veldinvoer : gebruik 1 voor auteur login of 2 voor login van editor.",
"~np~{~/np~RSS(id=>feedId,max=>3,date=>1,body=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId,max=>3,datum=>1,tekst=>1)}{RSS} Voeg rss stroom toe aan wiki pagina",
"delete" => "verwijderen",
"post" => "voeg toe",
"stop monitoring this blog" => "stop monitoring van dit blog",
"posts" => "bijdragen",
"visits" => "aantal bezoekers",
"show categories" => "categorie&euml;n tonen",
"author" => "auteur",
"user level" => "gebruikerniveau",
"send email to user" => "verstuur e-mail naar gebruiker",
"delete selected" => "verwijder geselecteerde",
"move" => "verplaatsen",
"Posted messages" => "Aangeleverde berichten",
"set" => "Inloggen",
"replies" => "antwoorden",
"new reply" => "nieuw antwoord",
"cancel" => "annuleren",
"up" => "omhoog",
"down" => "omlaag",
"add" => "toevoegen",
"stop monitoring this map" => "stop de monitoring van deze landkaart",
"create" => "maken",
"save" => "opslaan",
"send" => "zenden",
"Hide module contents" => "Verberd moduleinhoud",
"Last visitors" => "Laaste bezoekers",
"register" => "registreren",
"standard" => "standaard",
"secure" => "veilig",
"stay in ssl mode" => "in ssl-modus blijven",
"new messages" => "nieuwe berichten",
"new message" => "nieuw bericht",
"go" => "vooruit",
"cache" => "buffer",
"use" => "gebruiken",
"cached" => "gebufferd",
"refresh" => "verversen",
"print" => "afdrukken",
"create pdf" => "maak pdf aan",
"monitor this page" => "monitor deze pagina",
"stop monitoring this page" => "stop deze pagina te monitoren",
"backlinks" => "terugkoppelingen",
"click here" => "klik hier",
"rename" => "hernoemen",
"unlock" => "ontgrendelen",
"lock" => "vergrendelen",
"perms" => "perm.",
"history" => "geschiedenis",
"similar" => "vergelijkbaar",
"undo" => "terugzetten",
"slides" => "dia's",
"export" => "exporteren",
"discuss" => "discussieer",
"add comment" => "commentaar",
"attach file" => "voeg bijlage toe",
"translation" => "vertaling",
"last modification" => "laatste wijziging",
"attachments" => "bijlagen",
"stats" => "statistieken",
"last changes" => "laatste wijzigingen",
"list pages" => "paginalijst",
"back to homepage" => "terug naar de thuispagina",
"cancel edit" => "bewerking annuleren",
"No attachments for this page" => "Geen bijlagen voor deze pagina",
"Skip to navigation" => "Sla over en ga naar navigatie",
"switch" => "draai om",
"view blog" => "toon blog",
"list blogs" => "opsommen blogs",
"save and exit" => "bewaar en verlaat",
"reads" => "gelezen",
"view comments" => "opmerkingen bekijken",
"Click here to create it" => "Klik hier om aan te maken",
"General preferences" => "Algemene voorkeuren",
"Other preferences" => "Andere voorkeueren",
"flag" => "vlag",
"HomePage" => "StartPagina",
"Edit information" => "Bewerk informatie",
"Change information" => "Wijzig informatie",
"Best language" => "Beste taal",
"Enable cache images to all galleries" => "Schakel afbeeldingenbuffer in voor alle galerijen",
"Images cache directory" => "Afbeeldingenbuffer folder",
"images" => "afbeeldingen",
"PHP error reporting level for non-admin:" => "PHP foutrapportage niveua voor niet-beheerders:",
"Report PHP errors only for admin" => "Laat PHP-fouten enkel voor beheerders zien",
"Server name (for absolute URIs)" => "Servernaam (voor absolute URIs)",
"Automatic (uses HTTPS variable)" => "Automatisch (gebruikt HTTPS variabele)",
"Wiki_Tiki_Title" => "Wiki_Tiki_Titel",
"path" => "pad",
"groups" => "groepen",
"Admin->Features" => "Beheer->Kenmerken",
"Validate email address (may not work)" => "Valideer e-mail adres (werkt mogelijk niet)",
"Require HTTP Basic authentication" => "HTTP basic authentication vereisen",
"HTTP server name" => "HTTP-servernaam",
"HTTP URL prefix" => "HTTP-URL-prefix",
"HTTPS server name" => "HTTPS-servernaam",
"HTTPS URL prefix" => "HTTPS-URL-prefix",
"Only for users" => "Enkel voor gebruikers",
"Users and admins" => "Gebruikers en beheerders",
"Full Text Search" => "Volledige Tekst Zoekfunctie",
"Don't forget: to use feature you will need to enable it on" => "Vergeet niet: om het kenmerk te gebruiken dient u het eerst in te schakelen",
"Custom Code" => "Aangepaste Code",
"Site breadcrumbs" => "Site broodkruimels",
"Site search bar" => "Site Zoekbalk",
"Site logo source" => "Site logo bron",
"Site ads and banners" => "Site advertenties en banners",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Opmerking: Dit kenmerk vereist ook dat de phplayers functionaliteit ingeschakeld is in Admin->Kenmerken",
"change" => "wijzigen",
"Manage attachment preferences" => "Bijlagevoorkeuren beheren",
"HTML in Wiki Pages" => "HTML in Wiki Pagina\\'s",
"Wiki syntax used when a page contains HTML" => "Wiki syntax gebruiken wanneer een pagina HTML bevat",
"full" => "volledig",
"partial" => "gedeeltelijk",
"Enable Feature" => "Maak optie beschikbaar",
"Wiki attachments preferences" => "Voorkeuren Wiki bijlagen",
"admin banning tpl" => "banning beheren sjabloon",
"participants" => "deelnemers",
"lang" => "taal",
"subscription" => "abonnement",
"permissions" => "permissies",
"admin categories" => "categorie&euml;n beheren",
"admin categories tpl" => "beheer categorie&euml;n sjabloon",
"create new" => "maak nieuwe aan",
"edit chart" => "bewerk rangschikking",
"update" => "bijwerken",
"admin charts template" => "rangschikkingen sjabloon beheren",
"admin content templates" => "inhoudsjablonen beheren",
"admin content templates template" => "inhoudsjablonen sjabloon beheren",
"use in cms" => "in CMS gebruiken",
"use in wiki" => "in wiki gebruiken",
"use in newsletters" => "in nieuwsbrieven gebruiken",
"use in events" => "gebruik in gebeurtenissen",
"use in HTML pages" => "in HTML-pagina's gebruiken",
"last modif" => "laatst gewijzigd",
"sections" => "secties",
"admin FortuneCookie" => "Gelukkoekje beheren",
"admin FortuneCookie tpl" => "Gelukkoekje beheren sjabloon",
"upload" => "aanleveren",
"admin Drawings tpl" => "Tekeningen beheren sjabloon",
"admin External Wikis" => "beheer Externe Wiki\\'s",
"admin forums template" => "forums sjabloon beheren",
"Edit existing forums" => "Bewerk bestaande forums",
"topics" => "onderwerpen",
"coms" => "opm.",
"age" => "ouderdom",
"last post" => "laatste bijdrage",
"Assign Permissions (Active)" => "Wijs Permissies toe (Actieve)",
"Click here to delete this forum" => "Klik hier om het forum te verwijderen",
"admin hotwords" => "hotwords beheren",
"admin hotwords template" => "hotwords sjabloon beheren",
"admin HTML page dynamic zones" => "HTML pagina dynamische zones beheren",
"admin Html Pages" => "beheer Html Pagina\\'s",
"admin Html Pages template" => "beheer Html Pagina\\s sjabloon",
"list repositories" => "Opsommen bewaarplaatsen",
"new repository" => "nieuwe bewaarplaats",
"view repository" => "bekijk bewaarplaats",
"view this repository" => "bekijk deze bewaarplaats",
"new rule" => "nieuwe regel",
"admin featured links" => "aanbevolen koppelingen beheren",
"admin featured links template" => "aanbevolen koppelingen sjabloon beheren",
"url" => "URL",
"position" => "positie",
"admin Webmail" => "Webmail beheren",
"admin mailin template" => "mailin beheren sjabloon",
"section" => "sectie",
"sorted section" => "gesorteerde sectie",
"admin menu builder" => "menubouwer beheren",
"admin menus template" => "menu's sjabloon beheren",
"options" => "opties",
"admin modules" => "modules beheren",
"admin modules template" => "modules sjabloon beheren",
"assign module" => "module toekennen",
"left modules" => "modules koppelingen",
"right modules" => "modules rechts",
"edit/create" => "bewerken/aanmaken",
"clear cache" => "buffer leegmaken",
"\n<b>Note 1</b>: if you allow your users to configure modules then assigned\nmodules won't be reflected in the screen until you configure them\nfrom MyTiki->modules.<br />\n<b>Note 2</b>: If you assign modules to groups make sure that you\nhave turned off the option 'display modules to all groups always'\nfrom Admin->General\n" => "\n<b>Noot 1</b>: als u uw gebruikers toestaat om modules te configureren\ndan zullen toegekende modules niet weergegeven worden op het scherm\ntot u hen configureert vanuit MijnTiki->modules.<br />\n<b>Noot 2</b>: Als u modules toekent aan groepen zorg er dan voor dat\nu de optie 'Modules altijd aan alle groepen tonen' uitgeschakeld heeft ",
"assign" => "toekennen",
"left" => "links",
"right" => "rechts",
"order" => "volgorde",
"create/edit" => "maken/bewerken",
"use poll" => "opiniepeiling gebruiken",
"use gallery" => "galerij gebruiken",
"use dynamic  content" => "dynamische inhoud gebruiken",
"use rss module" => "RSS-module gebruiken",
"use menu" => "menu gebruiken",
"use phplayermenu" => "gebruik phplayermenu",
"use banner zone" => "advertentiezone gebruiken",
"list newsletters" => "nieuwsbrieven opsommen",
"admin newsletters" => "nieuwsbrieven beheren",
"send newsletters" => "nieuwsbrieven verzenden",
"admin newsletters template" => "nieuwsbrieven sjabloon beheren",
"editions" => "uitgaven",
"last sent" => "laatst verzonden",
"send newsletter" => "stuur nieuwsbrief",
"admin Email Notifications" => "E-mail Meldingen beheren",
"admin notifications template" => "meldingen sjabloon beheren",
"use admin email" => "beheerders-e-mail gebruiken",
"event" => "gebeurtenis",
"admin polls" => "opiniepeilingen beheren",
"admin polls template" => "opiniepeiligen sjabloon beheren",
"admin QuickTags" => "SnelLabels beheren",
"admin RSS Modules" => "RSS Modules beheren",
"admin RSSmodules template" => "RSS-modules sjabloon beheren",
"admin shoutbox words" => "spreekbuiswoorden beheren",
"admin shoutbox words template" => "spreekbuiswoorden sjabloon beheren",
"admin structures template" => "structuren sjabloon beheren",
"export pages" => "export pagina's",
"dump tree" => "dump boomstructuur",
"create webhelp" => "maak webhelp aan",
"view webhelp" => "bekijk webhelp",
"tree" => "boom",
"create new structure" => "maak nieuwe structuur aan",
"survey stats" => "statistieken voor opinieonderzoek",
"edit this survey" => "dit opinieonderzoek bewerken",
"admin surveys" => "opinieonderzoeken beheren",
"list surveys" => "opinieonderzoeken opsommen",
"questions" => "vragen",
"files" => "bestanden",
"admin topics template" => "onderwerpen sjabloon beheren",
"admin Trackers tpl" => "Trackers beheren sjabloon",
"Edit fields for tracker" => "Bewerk velden voor tracker",
"The tracker needs a text field named Subject" => "De tracker vereist een tekstveld met naam Subject",
"version" => "versie",
"admin groups" => "groepen beheren",
"admin groups template" => "Groepen sjabloon beheren",
"assign permissions" => "wijs permissies toe",
"admin" => "beheerder",
"admin users" => "gebruikers beheren",
"admin users template" => "gebruikers sjabloon beheren",
"edit account settings" => "Bewerk account instellingen",
"assign to groups" => "wijs toe aan groepen",
"edit article tpl" => "bewerk artikel sjabloon",
"all" => "alle",
"Assign user" => "Gebruiker toekennen",
"Available groups" => "Beschikbare groepen",
"assign perms to this group" => "wijs permissies toe aan deze groep",
"admin backups" => "reservekopie&eacute;n beheren",
"admin admin tpl" => "beheer beheren sjabloon",
"List of available backups" => "Lijst met beschikbare reservekopie&eacute;n",
"Restoring a backup" => "Back-up terugplaatsen",
"Warning!" => "Waarschuwing!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Het herstellen van een back-up vernietigt al de data in uw Tiki-databank. Al uw tabellen zullen vervangen worden door de informatie in de back-up.",
"Click here to confirm restoring" => "Hier klikken om het herstel te bevestigen",
"Create new backup" => "Nieuwe back-up maken",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Het maken van back-ups kan veel tijd in beslag nemen. Als het proces niet be&euml;indigd is zal u een blanco scherm zien. Als dat zo is moet u de maximale tijd voor uitvoering van een script verhogen in uw php.ini bestand",
"Your image gallery storage is set to \"{\$gal_use_dir}\", you will need to backup this using FTP or SCP." => "De opslag van uw beeldgalerijen is momenteel in \"{\$gal_use_dir}\", u zal van deze een reservekopie via FTP of SCP dienen te maken.",
"Your file gallery storage is set to \"{\$fgal_use_dir}\", you will need to backup this using FTP or SCP." => "De opslag van uw bestandgalerijen is momenteel in \"{\$fgal_use_dir}\", u zal van deze een reservekopie via FTP of SCP dienen te maken.",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Indien er berichten in uw forums met bijlagen aanwezig zijn, zal u van deze een aparte reserverkopie moeten maken via FTP of SCP.",
"Upload a backup" => "Een reserverkopie aanleveren",
"Upload backup" => "Reservekopie aanleveren",
"remove file extension from image name" => "verwijder bestandsextensie van naam van afbeelding",
"convert sub directories to sub galleries" => "converteer subfolders naar subgalerijen",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "eg. van \"misc/screenshots/digicam0001.jpg\" zal een galerij genaamd screenshots worden aangemaakt",
"use sub directory names as description" => "gebruik subfolder namen als beschrijving",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "eg. van \"misc/screenshots/digicam0001.jpg\" zal een beschrijving misc/screenshots worden aangemaakt",
"admin the category system" => "beheer het categoriesysteem",
"admin category" => "Categorie&euml;n beheren",
"list galleries" => "lijst galerijen",
"edit gallery" => "galerij bewerken",
"rebuild thumbnails" => "voorbeeldplaatjes vernieuwen",
"upload image" => "afbeelding aanleveren",
"list gallery" => "galerij opsommen",
"original size" => "oorspronkelijk formaat",
"return to gallery" => "terug naar galerij",
"edit image" => "afbeelding bewerken",
"smaller" => "kleiner",
"bigger" => "groter",
"prev image" => "vor. afbeelding",
"popup window" => "popup venster",
"next image" => "volg. afbeelding",
"slideshow forward" => "slideshow voorwaarts",
"imagescale" => "schaal afbeelding",
"add item" => "voeg item toe",
"Subscription List" => "Abonnementenlijst",
"or create a new category" => "of maak een nieuwe categorie aan",
"or create a new location" => "of maak een nieuwe locatie aan",
"comma separated usernames" => "komma-gescheiden gebruikernamen",
"comma separated username:role" => "komma-gescheiden naam:functie",
"with roles" => "met functies",
"Chair" => "Woordvoerder",
"Optional" => "Optioneel",
"Format: mm/dd/yyyy hh:mm<br />..." => "Formaat: mm/dd/yyyy hh:mm<br />...",
"See strtotime php function" => "Zie strtotime php functie",
"Format: mm/dd/yyy hh:mm<br />..." => "Formaat: mm/dd/yyy hh:mm<br />...",
"permission" => "permissie",
"remove from this category &amp; all its children" => "verwijder alle kinderen voor deze categorie",
"remove from this category only" => "verwijder enkel van deze categorie",
"remove page" => "pagina verwijderen",
"admin directory tpl" => "Koppelingenlijst beheren sjabloon",
"edit tpl" => "bewerk sjabloon",
"browse" => "bladeren",
"related" => "verwante",
"validate" => "valideren",
"admin directory categories tpl" => "Koppelingenlijst categorie&eacute;n beheren sjabloon",
"add a site" => "voeg een site toe",
"add a category" => "voeg een categorie toe",
"search" => "zoeken",
"edit template" => "bewerk sjabloon",
"list articles" => "artikelen opsommen",
"view articles" => "artikelen tonen",
"create zone" => "zone maken",
"save the banner" => "de advertentie opslaan",
"edit blog tpl" => "Bewerk blog sjabloon",
"try" => "probeer",
"display" => "tonen",
"admin quicktags" => "Snellabels beheren",
"create new block" => "nieuw blok maken",
"list quizzes" => "quizzen opsommen",
"quiz stats" => "statistieken voor quiz",
"edit this quiz" => "deze quiz bewerken",
"admin quizzes" => "quizzen beheren",
"admin quizzes tpl" => "quizzen beheren sjabloon",
"results" => "resultaten",
"edit quiz questions" => "bewerk quiz vragen",
"edit quiz questions tpl" => "bewerk quiz vragen sjabloon",
"create page" => "pagina aanmaken",
"edit submissions tpl" => "bewerk bijdragen sjabloon",
"list submissions" => "bijdragen opsommen",
"edit translations" => "bewerk vertalingen",
"edit translations template" => "bewerk vertalingensjabloon",
"add to the set" => "voeg toe aan de vertalingen",
"Admin ephemerides" => "Spreuken beheren",
"admin Ephemerides tpl" => "Spreuken beheren sjabloon",
"All ephemerides" => "Alle spreuken",
"new question" => "nieuwe vraag",
"approve" => "aanvaarden",
"configure listing" => "configureer lijst",
"topic" => "onderwerp",
"save and approve" => "bewaar en goedgekeurd",
"new topic" => "nieuw bericht",
"reject" => "verwerp",
"accept" => "aanvaarden",
"refuse" => "weiger",
"add new" => "voeg nieuwe toe",
"add role" => "voeg functie toe",
"new minor" => "nieuwe sub",
"new major" => "nieuwe hoofd",
"admin processes" => "processen beheren",
"admin activities" => "activiteiten beheren",
"admin roles" => "functies beheren",
"edit this process" => "bewerk dit proces",
"send instance" => "verstuur incarnatie",
"create new gallery" => "maak een nieuwe galerij aan",
"rebuild cache" => "hermaak buffer",
"result" => "resultaat",
"reload" => "herlaad",
"edit repository" => "bewerk bewaarplaats",
"source" => "bron",
"list articles tpl" => "opsommen artikelen sjabloon",
"edit new article" => "nieuw artikel bewerken",
"admin Banners" => "Advertenties beheren",
"admin Banners tpl" => "Advertenties beheren sjabloon",
"create new blog" => "Maak nieuw blog aan",
"admin cache" => "buffer beheren",
"admin cache tpl" => "buffer beheren sjabloon",
"admin DynamicContent tpl" => "Dynamische Inhoud beheren sjabloon",
"list faqs tpl" => "opsommen faqs sjabloon",
"upload file" => "bestand aanleveren",
"Edit a file using this form" => "Bewerk een bestand via dit formulier",
"monitor this gallery" => "monitor deze galerij",
"stop monitoring this gallery" => "stop monitoring van deze galerij",
"delete selected files" => "verwijder geselecteerde bestanden",
"browse gallery" => "galerij bekijken",
"Flash binary (.sqf or .dcr)" => "Flash binair bestand (.sqf of .dcr)",
"list posts tpl" => "opsommen berichten sjabloon",
"edit blog" => "bewerk blog",
"list quizzes tpl" => "quizzen lijst sjabloon",
"edit new submission" => "nieuwe bijdrage bewerken",
"edit quiz stats tpl" => "bewerken quiz stats sjabloon",
"actions" => "acties",
"take survey" => "neem deel aan opinieonderzoek",
"list trackers tpl" => "trackers lijst sjabloon",
"admin live support tpl" => "live ondersteuning beheren sjabloon",
"set as operator" => "definieer als operator",
"add topic" => "onderwerp toevoegen",
"install" => "installeer",
"wiki create" => "wiki aanmaak",
"wiki overwrite" => "wiki overschrijf",
"back" => "terug",
"Assign permissions to page" => "Permissies toekennen aan pagina",
"Current permissions for this page" => "Huidige permissies voor deze pagina",
"remove from this page" => "verwijder van deze pagina",
"remove from this structure" => "verwijder uit deze structuur",
"No individual permissions; category or global permissions apply" => "Geen individuele permissies: categorie of globale permissies zijn van kracht",
"this page" => "deze pagina",
"this structure" => "deze structuur",
"Current permissions for categories that this page belongs to" => "Huidige permissies voor categorie&uml;n waartoe deze pagina behoort",
"Send email notifications when this page changes to" => "E-mail berichtgevingen verzenden wanneer deze pagina verandert naar",
"add email" => "e-mail toevoegen",
"Notifications" => "Meldingen",
"clear stats" => "statistieken verwijderen",
"Edit received page" => "Ontvangen pagina bewerken",
"admin Referer stats" => "Verwijzer stats beheren",
"admin Referer stats tpl" => "Verwijzer stats beheren sjabloon",
"last" => "laatste",
"send me my password" => "gelieve mijn wachtwoord op te sturen",
"searched" => "gezocht",
"galleries" => "galerijen",
"blog posts" => "blogbijdragen",
"articles" => "artikelen",
"wiki pages" => "wiki pagina\\'s",
"admin send objects tpl" => "verzend objecten beheren sjabloon",
"clear" => "opruimen",
"add article" => "artikel toevoegen",
"create new sheet" => "Aanmaken rekenblad",
"admin Tiki Shoutbox" => "Tiki Spreekbuis beheren",
"admin Tiki Shoutbox tpl" => "Tiki Spreekbuis beheren sjabloon",
"list view" => "bekijk lijst",
"first" => "eerste",
"send answers" => "antwoorden verzenden",
"move to right column" => "verplaats naar rechterkolom",
"unassign" => "toekenning ongedaan maken",
"move to left column" => "verplaats naar linkerkolom",
"remove folder" => "verwijder folder",
"refresh cache" => "ververs buffer",
"admin mode" => "beheermodus",
"trash" => "prullendmand",
"empty trash" => "maak prullendmand leeg",
"remove from trash" => "verwijder uit prullenmand",
"use start date and time" => "gebruik startdatum en -tijd",
"use end date and time" => "gebruik einddatum en -tijd",
"edit user files" => "bewerk gebruikerbestanden",
"no comments" => "geen commentaar",
"edit items" => "werk items bij",
"list charts" => "opsommen rangschikkingen",
"last chart" => "laatste rangschikking",
"view faq" => "bekijk faq",
"view faq tpl" => "bekijk faq sjabloon",
"admin menus tpl" => "menus beheren sjabloon",
"add suggestion" => "voeg suggestie toe",
"monitor this forum" => "monitor dit forum",
"stop monitoring this forum" => "stop monitoring van dit forum",
"delete selected topics" => "verwijder geselecteerde onderwerpen",
"stop monitoring this topic" => "stop monitoring van dit onderwerp",
"Comments below your current threshold" => "Opmerkingen onder uw huidige drempelwaarde",
"list attachments" => "Bijlagenlijst",
"add contacts" => "contacten toevoegen",
"DATE-of" => "van",
"You cannot edit this page because it is a user personal page" => "U kan deze pagina niet bewerken omdat het een persoonlijke gebruikerpagina is",
"Permission denied you cannot assign permissions for this page" => "Geen toestemming om permissies toe te kennen aan deze pagina",
"You do not have permission to edit messages" => "U heeft geen toestemming om berichten te bewerken",
"Cannot read file" => "Kan bestand niet lezen",
"Permission denied you cannot upload files" => "Geen permissie op bestanden aan te leveren",
"cannot process upload" => "kan aanleveringsproces niet afhandelen",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Uw e-mail adres is verwijderd van de lijst van adressen die een monitor op deze tracker actief hadden",
"Your email address has been added to the list of addresses monitoring this tracker" => "Uw e-mail adres is toegevoegd aan de lijst van adressen die een monitor op deze tracker actief hebben",
"Cancel monitoring" => "Annuleer monitoring",
"Your email address has been removed from the list of addresses monitoring this item" => "Uw e-mail adres is verwijderd van de lijst van adressen die een monitor op dit item actief hadden",
"Your email address has been added to the list of addresses monitoring this item" => "Uw e-mail adres is toegevoegd aan de lijst van adressen die een monitor op dit item actief hebben",
"tikiwiki logo" => "tikiwiki logo",
"filter" => "filter",
"Zoom in x3" => "Zoom in x3",
"Zoom in x4" => "Zoom in x4",
"pdf" => "pdf",
"tikiwiki.org help" => "tikiwiki.org help",
"UTC" => "UTC",
"<b>Item</b>" => "<b>Item</b>",
"details" => "details",
"zoom" => "zoom",
"semester" => "semester",
"Ratio" => "Ratio",
"sites" => "sites",
"start" => "start",
"proc" => "proc",
"P" => "P",
"F" => "F",
"pos" => "pos",
"pre" => "pre",
"emot" => "emot",
"account" => "account",
"new image uploaded by" => "nieuwe afbeeldingen aangeleverd door",
"new subscriptions" => "nieuwe abonnementen",
"new item in tracker" => "nieuw item in tracker",
"show" => "toon",
"hide" => "verberg",
"message" => "bericht",
"Include all post in a blog" => "Neem alle berichten van een blog op",
"Include an article" => "Sluit een artikel in",
"no such attachment on this page" => "bijlage niet aanwezig op deze pagina",
"select all" => "selecteer alles",
"missing fields list" => "lijst van ontbrekende velden",
"move %s in %s" => "verplaats %s naar %s",
"no such file" => "geen zulk bestand",
"downloads" => "afhalingen",
"download" => "Afhaling",
"attach" => "bijlage toevoegen",
"monitor this blog" => "monitor dit blog",
"hide categories" => "categorie&euml;n verbergen",
"Admin categories" => "Categorie&euml;n beheren",
"browse category" => "bekijk categorie",
"reply" => "beantwoorden",
"monitor this topic" => "monitor dit onderwerp",
"active perms" => "actieve perms",
"with checked" => "met gecheckt",
"Dls" => "Afhlgn",
"move selected files" => "verplaats geselecteerde bestanden",
"Thank you for you registration. You may log in now." => "Dank voor uw registratie. U kan zich nu aanmelden.",
"Zoom out x4" => "Zoom uit x4",
"Zoom out x3" => "Zoom uit x3",
"from\nthe mapfile:" => "van\nhet landkaartbestand:",
"compare" => "vergelijken",
"diff" => "verschillen",
"older version" => "oudere versie",
"Click the :: options in the Menu for more options." => "Klik de :: in het Menu voor meer opties.",
"Please, also see" => "Zie ook",
"for more setup details." => "voor meer setup details.",
"Note 1:" => "Opmerking 1:",
"You can remove this module in" => "U kan deze module verwijderen in",
"as well as assign or edit many others." => "wijs toe of bewerk meerdere andere.",
"Note 2:" => "Opmerking 2:",
"The menu module installed by default is named" => "De menu module geinstalleerd door default heet",
"it is a \"custom module\" which includes menu ID " => "het is een \"maatwerkmodule\" die het menu ID bevat",
"That menu is stored in database and it can be edited from " => "Dit menu is opgeslagen in de databank en kan bewerkt worden via ",
"Do not mix this with the original <em>application_menu</em> module" => "Mix deze niet met de originele <em>application_menu</em> module",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Deze kan manueel aangepast worden om aan de gangbare stijl te voldoen maar dit kan momenteel slechts enkel door het \"handmatig\" wijzigen van het mod-application_menu.tpl bestand",
"del" => "verw",
"Create pdf" => "Maak pdf aan",
"1 file attached" => "1 bestand aangehangen",
"categories" => "categorie&euml;n",
"List pages where I am a creator" => "Som pagina's op waarvan ik de auteur ben",
"by creator" => "op auteur",
"List pages where I am a modificator" => "Som pagina's waarvan ik een bijdrage heb geleverd (editor)",
"by modificator" => "op editor",
"at tracker" => "bij tracker",
"calendar view" => "bekijk kalender",
"check / uncheck all" => "vink aan/ vink uit allen",
"Tiki sections and features" => "Tikisecties en -onderdelen",
"Site Logo and Identity" => "Site Logo en Identiteit",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Gebruik Quote plugin eerder dan &ldquo;>&rdquo; om tekst aan te halen",
"Storing files in a directory" => "Sla bestanden op in een folder",
"please read" => "aub lees",
"yes" => "ja",
"Click here for more details." => "Klik hier voor meer details.",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Tiki instellingen waardeveld in de databank is momenteel max. 250 karakters lang. Dat geldt eveneens voor alle aangepaste inhoud. Controleer deze databank tabel indien u deze databank tabel wenst aan te passen zodat deze meer dan 250 karakters per veld ondersteunt (ook al werden aanpassingen voorheen uitgevoerd en getest met mysql zonder problemen, dient u toch eerst een reservekopie van uw databank te maken)",
"Users &amp; groups" => "Gebruikers &amp; groepen",
"Local" => "Lokaal",
"private" => "privaat",
"<b>Value</b>" => "<b>Waarde</b>",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS Modules\" on the application menu, or" => "Deze pagina dient voor de configuratie van de RSS-invoerstromen aangemaakt door Tiki. Om RSS-invoerstromen te kunnen lezen/importeren, ga naar \"RSS-modules\" in het applicatie menu, of",
"<b>Feed</b>" => "<strong>Invoer</strong>",
"<b>enable/disable</b>" => "<strong>aanzetten/uitzetten</strong>",
"<b>Max number of items</b>" => "<strong>Max aantal items</strong>",
"Feed for Articles" => "Invoer voor Artikelen",
"Feed for Weblogs" => "Invoer voor Blogs",
"Feed for Image Galleries" => "Invoer voor Beeldgalerijen",
"Feed for File Galleries" => "Invoer voor Bestandgalerijen",
"Feed for the Wiki" => "Invoer voor de Wiki",
"Feed for individual Image Galleries" => "Invoer voor individuele Beeldgalerijen",
"Feed for individual File Galleries" => "Invoer voor individuele Bestandgalerijen",
"Feed for individual weblogs" => "Invoer voor individuele blogs",
"Feed for individual forums" => "Invoer voor individuele forums",
"Feed for mapfiles" => "Invoer voor landkaartbestanden",
"Feed for directories" => "Invoer voor directories",
"Feed for tracker items" => "Invoerstroom voor tracker items",
"Prefix breadcrumbs with 'Location:' label?" => "Prefix broodkruimels met 'Locatie:' label?",
"Site Search" => "Site Zoekfunctie",
"Change style only" => "Verander enkel de stijl",
"PDF generation" => "PDF creatie",
"Use in CMS" => "In CMS gebruiken",
"Use in Wiki" => "In wiki gebruiken",
"Use in newsletters" => "In nieuwsbrieven gebruiken",
"Use in events" => "Gebruik in gebeurtenissen",
"Use in HTML pages" => "In HTML-pagina's gebruiken",
"Edit Existing Forums" => "Werk bestaande forums bij",
"Refresh rate (if dynamic) [secs]" => "Frequentie waarmee geactualiseerd wordt (indien dynamisch) [sec.]",
"configure repositories" => "Configureer bewaarplaatsen",
"configure this repository" => "Configureer deze bewaarplaats",
"copy rules" => "kopieer regels",
"Create/edit newsletters" => "Nieuwsbrieven maken/bewerken",
"subscriptions" => "abonnementen",
"archives" => "archieven",
"Use Admin Email" => "Beheerders-e-mail gebruiken",
"Edit or add poll options" => "Opties voor opiniepeilingen bewerken of toevoegen",
"configure polls" => "configureer opiniepeilingen",
"Create/edit Polls" => "Opiniepeilingen Maken/Bewerken",
"Rss channels" => "Rss-kanalen",
"show pubdate" => "toon pubdatum",
"activate" => "activeer",
"Admin tracker" => "Tracker beheren",
"Edit this tracker" => "Deze tracker bewerken",
"View this tracker items" => "Items in deze tracker bekijken",
"Edit tracker fields" => "Trackervelden bewerken",
"Import/export trackers fields" => "Importeer/exporteer trackerveld",
"Edit tracker" => "Werk tracker bij",
"Create trackers" => "Maak trackers aan",
"Import/export" => "Importeer/exporteer",
"fields" => "velden",
"active permissions" => "actieve permissies",
"Create/edit trackers" => "Trackers maken/bewerken",
"filename" => "bestandnaam",
"filesize" => "bestandgrootte",
"filetype" => "bestandstype",
"longdesc" => "langbeschr",
"Add a new group" => "Voeg nieuwe groep toe",
"Edit item" => "Item bewerken",
"List all members" => "Lijst alle leden",
"Add a new user" => "Nieuwe gebruiker toevoegen",
"manage group assignments" => "beheer groeptoewijzigingen",
"set default groups" => "Zet standaardgroepen",
"Popup Window" => "Popup venster",
"change focus" => "verander focus",
"quater" => "kwartaal",
"quarter" => "kwartaal",
"No individual permissions global permissions apply" => "Er zijn geen individuele permissies gezet, globale permissies gelden",
"Welcome to the Tiki Chat Rooms" => "Welkom in de Tiki Praatkamers",
"Please select a chat channel" => "Gelieve een praatkamer te kiezen",
"enter chat room" => "Praatkamer binnengaan",
"There are no channels setup, please contact a site admin" => "Er zijn geen kanalen opgezet, contacteer aub een beheerder",
"Chatroom" => "Praatkamer",
"Active Channels" => "Actieve Kanalen",
"Users in this channel" => "Gebruikers in deze kamer",
"Channel Information" => "Kanaalinformatie",
"Channel" => "Kanaal",
"Use :nickname:message for private messages" => "Gelieve :bijnaam:bericht te gebruiken voor priv&eacute;berichten",
"Use [URL|description] or [URL] for links" => "Gelieve [URL|omschrijving] of [URL] te gebruiken voor koppelingen",
"Use (:smileyname:) for smileys" => "Gebruik (:smileynaam:) voor smileys",
"Create PDF" => "Maak PDF aan",
"PDF Settings" => "PDF Instellingen",
"Select Wiki Pages" => "Kies Wiki Pagina's",
"Remove Page" => "Pagina verwijderen",
"click here to send us an email" => "klik hier om ons een e-mail te sturen",
"Add or edit a site" => "Een site toevoegen of bewerken",
"cool sites" => "leuke sites",
"Use ...page... to separate pages in a multi-page article" => "Gebruik ...page... om te pagineren in een multi-pagina artikel",
"Create Zone" => "Zone maken",
"use square brackets for an external link: [URL] or [URL|link_description] or [URL|description|nocache]  (that last form prevents the local Wiki from caching the page; please use that form for large pages!)." => "gebruik vierkante haken voor een externe koppeling: [URL] of [URL|beschrijving_koppeling] of [URL|bewschrijving|nocache]  (deze laatste vorm voorkomt dat de pagina lokaal wordt gebufferd door het Wiki. Gebruik deze vorm aub voor omvangrijke pagina's).",
"browse image" => "bekijk afbeelding image",
"translate" => "vertaal",
"Create or edit content" => "Inhoud maken of bewerken",
"this quiz stats" => "statistieken voor deze quiz",
"answer" => "antwoord",
"Edit Translation:" => "Bewerk Vertaling:",
"Use this section to set the language of the version you are currently working on." => "Gebruik deze sectie om aan te duiden in welke taal de versie is geschreven waaraan momenteel wordt gewerkt.",
"Set of Translations" => "Vertalingen",
"Select the article for which the current article is the translation." => "Selecteer het artikel waarvan het huidig artikel de vertaling is.",
"Translation of:" => "Vertaling van:",
"Enter the name of the page for which the current page is the translation." => "Voer de naam van de pagina in waarvan de huidige pagina de vertaling is.",
"Add to the Set" => "Voeg toe aan de vertalingen",
"graph" => "grafiek",
"Edit FAQ questions" => "FAQ-vragen bewerken",
"Edit this file gallery:" => "Bewerk deze bestandgalerij:",
"icon" => "ikoon",
"Other users can upload files to this gallery" => "Andere gebruikers kunnen bestanden aan deze galerij aanleveren",
"Available File Galleries" => "Beschikbare bestandgalerijen",
"configure forum" => "Instellen forum",
"end" => "einde",
"roles" => "functies",
"Add role" => "Voeg functie toe",
"active process" => "actieve processen",
"invalid" => "ongeldig",
"invalid process" => "ongeldige processen",
"valid process" => "geldige processen",
"activities" => "activiteiten",
"aborted" => "afgebroken",
"value" => "waarde",
"exceptions" => "uitzondering",
"rollback" => "terugplaatsen",
"Create or edit content block" => "Inhoudsblok aanmaken of beheren",
"Listing Gallery" => "Opsomming van galerij",
"Gallery Files" => "Galerijbestanden",
"Last ver" => "Laatste ver.",
"Com" => "Opm.",
"Vers" => "Versie",
"subscribe" => "abonneer",
"Sent edition" => "Verzend editie",
"Subscribe to newsletter" => "Zich op nieuwsbrief abonneren",
"Add or edit a news server" => "Bewerken/toevoegen nieuwsserver",
"rollback to this version" => "draai terug naar deze versie",
"Print Wiki Pages" => "Wikipagina's afdrukken",
"add page" => "pagina toevoegen",
"entire site" => "volledige site",
"click to navigate" => "Klik om te navigeren",
"Total threads" => "Threads samen",
"Average threads per topic" => "Gemiddeld aantal threads per onderwerp",
"You can include the file in an HTML/Tiki page using" => "U kan het bestand invoegen in een HTML/Tiki pagina met",
"Now enter the file URL" => "Gelieve nu de bestand-URL in te geven",
" or upload a local file from your disk" => " of een bestand van uw lokale harde schijf aan te leveren",
"Add or edit folder" => "Folder toevoegen of bewerken",
"Add or edit a URL" => "Een URL toevoegen of bewerken",
"received" => "ontvangen",
"submitted" => "ingeleverd",
"shared" => "gedeeld",
"accepted by task user and creator" => "aanvaard door de taakgebruiker en auteur",
"accepted user and creator" => "aanvaard door de gebruiker en auteur",
"not accepted by one user" => "niet aanvaard door 1 gebruiker",
"not accepted user" => "niet-aanvaarde gebruiker",
"waiting for me" => "wachtend voor mij",
"waiting for other user" => "wachtend op een andere gebruikers",
"red" => "rood",
"move into trash" => "verplaats naar prullenmand",
"waiting / not started" => "in wachtrij / niet gestart",
"waiting" => "in wachtrij",
"shared for group" => "gedeeld voor groep",
"accepted by user" => "aanvaard door gebruiker",
"no / rejected" => "neen / verworpen",
"accepted by creator" => "aanvaard door auteur",
"priority" => "prioriteit",
"select one" => "selecteer 1",
"undo trash" => "haal terug uit prullenmand",
"show:" => "toon:",
"all shared tasks" => "alle gedeelde taken",
"previous chart" => "vorige rangschikking",
"next chart" => "volgende rangschikking",
"permanency" => "permanentie",
"avg" => "gem",
"post new comment" => "nieuwe opmerking toevoegen",
"Post New Comment" => "Nieuwe opmerking toevoegen",
"HTML tags are not allowed inside comments" => "HTML-labels zijn niet toegestaan in opmerkingen",
"moderator actions" => "moderator acties",
"move selected topics" => "verplaats geselecteerde onderwerpen",
"unlock selected topics" => "ontgrendel geselecteerde onderwerpen",
"lock selected topics" => "vergrendel geselecteerde onderwerpen",
"merge" => "voeg samen",
"merge selected topics" => "voeg geselecteerde onderwerpen samen",
"reported messages:" => "gemelde berichten:",
"queued messages:" => "berichten in de wachtrij geplaatst:",
"Edit fields" => "Bewerk velden",
"View item" => "Item bekijken",
"Add a comment" => "Een opmerking toevoegen",
"pop" => "POP",
"Projects" => "Projecten",
"Projects configuration" => "Projecten configuratie",
"Site Identity features" => "Kenmerken Site Identiteit",
"Click here to delete this category" => "Klik hier om deze categorie te verwijderen",
"Group doesnt exist" => "Groep bestaat niet",
"User doesnt exist" => "Gebruiker bestaat niet",
"Event without Name" => "Gebeurtenis zonder naam",
"Invalid old password" => "Ongeldig oud wachtwoord",
"No channel indicated" => "Geen kanaal opgegeven",
"No nickname indicated" => "Geen bijnaam opgegeven",
"No permission to view the page" => "Geen permissie om de pagina te bekijken",
"I have refused your friendship request!" => "Ik heb uw verzoek tot vriendschap geweigerd!",
"Please create a directory named \$map_path to hold your map files." => "Aub maak een folder aan met naam \$map_path om uw landkaartbestaden in op te slaan.",
"Permision denied" => "Toestemming geweigerd",
"Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/tiki-index.php?page=Features'>evaluation of each feature</a> on Tiki's developer site." => "Gelieve de <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/tiki-index.php?page=Features'>beoordeling van elke mogelijkheid</a> op Tiki's ontwikkelsite te bekijken.",
"Propose a Fullscreen mode" => "Stel een Fullscreen mode voor",
"Lightbox (Javascript modern visual effects on images)" => "Lightbox (moderne visuele effecten met Javascript op afbeeldingen)",
"To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>." => "Kom meer te weten van <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods</a>.",
"Webmail Doc" => "Webmail Doc",
"clip" => "clip",
"cc" => "cc",
"Phillippines" => "Fillipijnen",
"sender" => "afzender",
"subject" => "betreft",
"date" => "datum",
"flagged" => "gevlagd",
"mark" => "markeer",
"find replied message" => "vind beantwoord bericht",
"replied" => "beantwoorden",
"Click" => "Klik",
"posted by" => "toegevoegd door",
"email this post" => "e-mail deze bijdrage",
"Tag name" => "Labelnaam",
"Enable wiki 3D browser" => "Inschakelen wiki 3D browser",
"Existing page node color" => "Kleur aanwezige paginanode",
"Missing page node color" => "Kleur ontbrekende paginanode",
"Anonymous editors must input anti-bot code" => "Anonieme auteurs moeten anti-bot code invoeren",
"Edit idle timeout" => "Verloop ongebruikte tijd ivm bijwerken",
"Use page description" => "Paginaomschrijving gebruiken",
"Show page title" => "Paginatitel tonen",
"Show page ID" => "Toon pagina ID",
"Cache wiki pages (global)" => "Buffer wiki pagina's (globaal)",
"Users can lock pages (if perm)" => "Gebruikers kunnen pagina's vergrendelen (indien toestemming)",
"Use WikiWords" => "gebruik WikiWoorden",
"Use Wiki paragraph formatting" => "Gebruik Wiki paragraafformattering",
"Use external link icons" => "Gebruik ikonen voor externe koppelingen",
"User's Page" => "Gebruikerpagina",
"UserPage prefix" => "GebruikerPagina prefix",
"List authors" => "Lijst auteurs",
"Maximum number of versions for history" => "Maximaal aantal versies in geschiedenis",
"Never delete versions younger than days" => "Nooit versies verwijderen jonger dan aantal dagen",
"Diff style" => "Verschillen stijl",
"Old vers" => "Oude versie",
"Add or edit event" => "Toevoegen/bewerken evenement",
"merge selected notes into" => "voeg geselecteerde notities in",
"Faq Stats" => "Statistieken voor FAQ",
"Edit User Files" => "Bewerk gebruikerbestanden",
"Your message has been queued for approval, the message will be posted after\na moderator approves it." => "Uw bericht werd in de wachtrij geplaatst. Het bericht zal worden geplaatst\nna goedkeuring door een moderator.",
"Webmail Doc template" => "Webmail Doc sjabloon",
"settings" => "instellingen",
"mailbox" => "postbus",
"compose" => "schrijven",
"contacts" => "contacten",
"back to mailbox" => "terug naar postvak",
"full headers" => "volledige hoofdingen",
"normal headers" => "normale hoofdingen",
"reply all" => "allen beantwoorden",
"forward" => "doorsturen",
"select from address book" => "uit adresboek selecteren",
"Share Page" => "Pagina Delen",
"Site Logo" => "Site Logo",
"IRC log" => "IRC log",
"Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Tekst opties: 1,grootte,prefix,suffix,max met grootte in karakters, prefix zal worden getoond voor de veldpositie suffix zal worden getoond na de veldpositie, max is het maximum aantal karakters kan worden opgeslagen, initiele 1 betekent dat het volgende tekstveld of selectieveld in dezelfde rij moet worden opgenomen.",
"Checkbox options: put 1 if you need that next field is on the same row." => "Selectieveld opties: vul 1 in indien u wenst dat het volgende veld op dezelfde rij komt.",
"Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numerieke opties: 1, grootte, prefix, suffix met grootte in karakter, prefix zal worden getoond voor de veldpositie suffix zal worden getoond na de veldpositie, 1 om aan te duiden dat het volgende tekstveld of selectieveld in dezelfde rij moet worden opgenomen",
"Dropdown options: list of items separated with commas." => "Neerklaplijst opties: lijst van items gescheide door comma's",
"Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Groepkiezer: gebruik opties voor automische veldinvoer : gebruik 1 voor groep van aanmaak of 2 voor groep van wijziging. De standaard dient te worden gezet, of de eerste groep die voorkomt wordt gekozen voor de gebruiker, of de standaard groep is Geregistreerde gebruikers.",
"Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Actie opties: Label,post,tiki-index.php,page:fieldname,highlight=test",
"Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email adres opties: 0|1|2 waar 0 het adres invoegt als gewone tekst, 1 een hex encoded mailto koppeling invoegt (moeilijker op te pikken voor web spiders en spam bots) and 2 een normal href mailto koppeling invoegt.",
"new sites" => "nieuwe sites",
"Message Broadcast" => "Bericht aan alle gebruikers",
"Are you sure you want to remove this module?" => "Bent u zeker dat u deze module wenst te verwijderen?",
"database queries used" => "database vragen gebruikt",
"{\$atts_cnt} files attached" => "{\$atts_cnt} bestanden aangehangen",
"pass" => "wachtwoord",
"Page generated in" => "Pagina aangemaakt in",
"sent" => "verzonden",
"Homework" => "Huiswerk",
"Assignments" => "Taken",
"Favorites" => "Favorieten",
"Member list" => "Ledenlijst",
"Back to Homepage" => "Terug naar de thuispagina",
"Minor" => "minder belangrijk",
"Last update from CVS" => "Laatste bijwerking uit CVS",
"Translate in" => "Vertaal naar",
"babelfish it" => "babelfish het",
"Welcome to" => "Welkom bij",
"Content Features" => "Inhoud Onderdelen",
"Contact Us (Anonymous)" => "Contacteer Ons (Anoniem)",
"Prevent automatic/robot registration" => "Voorkom automatische/robot registraties",
"Admin Groups Template" => "Groepen sjabloon beheren",
"Help on Banning System" => "Hulp voor verbanningssysteem",
"Admin banning tpl" => "Banning beheren sjabloon",
"Create/edit Calendars" => "Maak aan/Bewerk Kalenders",
"Admin Categories tpl" => "Beheer categorie&euml;n sjabloon",
"charts" => "rangschikkingen",
"Admin Charts Template" => "Rangschikkingen sjabloon beheren",
"Chat Administration" => "Praatkamer beheren",
"Chat Admin" => "Praat Beheer",
"Chat Admin tpl" => "Praat Beheer sjabloon",
"Create/edit channel" => "Kanaal maken/bewerken",
"Half a second" => "Halve seconde",
"second" => "seconde",
"Chat channels" => "Praatkanalen",
"Admin Content Templates Template" => "Inhoudsjablonen sjabloon beheren",
"Help on Drawings" => "Hulp voor Tekeningen",
"Admin DSN" => "Beheer DSN",
"tiki-admin_dsn tpl" => "tiki-admin_dsn sjabloon",
"Admin Forums Template" => "Forums sjabloon beheren",
"Admin Hotwords Template" => "Hotwords sjabloon beheren",
"Admin Featured Links" => "Aanbevolen koppelingen beheren",
"Admin Featured Links Template" => "Aanbevolen koppelingen sjabloon beheren",
"Admin Webmail" => "Webmail beheren",
"Admin Mailing Template" => "Mailin beheren sjabloon",
"Admin Menu Builder" => "Menubouwer beheren",
"Admin Menus Template" => "Menu's sjabloon beheren",
"Admin Modules Template" => "Modules sjabloon beheren",
"Assign Module" => "Module toekennen",
"Edit/Create" => "Bewerken/Aanmaken",
"subscribed" => "geabonneerd",
"Admin Newsletters Template" => "Nieuwsbrieven sjabloon beheren",
"Admin Notifications Template" => "Meldingen sjabloon beheren",
"Admin Polls Template" => "Opiniepeiligen sjabloon beheren",
"Configure Polls" => "Configureer opiniepeilingen",
"tiki admin quicktags template" => "tiki snellabels sjabloon beheren",
"Score System" => "Scoresysteem",
"security admin" => "Veiligheidsbeheer",
"security admin tpl" => "Veiligheidsbeheer sjabloon",
"Admin Shoutbox Words Template" => "Spreekbuiswoorden sjabloon beheren",
"Edit survey questions" => "Vragen voor opinieonderzoek beheren",
"administer surveys template" => "opinieonderzoeken sjabloon beheren",
"system admin" => "systeembeheer",
"system admin tpl" => "systeembeheer sjabloon",
"Admin Topics Template" => "Onderwerpen sjabloon beheren",
"Admin Tracker" => "Tracker beheren",
"Admin Users Template" => "Gebruikers sjabloon beheren",
"Again" => "Opnieuw",
"Article Types tpl" => "Artikeltypes sjabloon",
"Assign permissions to group" => "Permissies toekennen aan groep",
"Edit Article Tpl" => "Bewerk artikel sjabloon",
"Browsing Gallery" => "Galerij bekijken",
"Admin Directory tpl" => "Koppelingenlijst beheren sjabloon",
"Admin Directory Categories tpl" => "Koppelingenlijst categorie&eacute;n beheren sjabloon",
"Admin Directory Related" => "Koppelingenlijst Gerelateerd beheren",
"directory admin related tpl" => "Koppelingenlijst gerelateerd beheren sjabloon",
"Admin Directory Sites" => "Koppelingenlijst Sites beheren",
"Admin Directory Sites tpl" => "Koppelingenlijst Sites beheren sjabloon",
"Validate Sites" => "Valideer Sites",
"directory validate sites tpl" => "koppelingenlijst validatatie sites sjabloon",
"Edit Article" => "Bewerk Artikel",
"Edit Blog Tpl" => "Bewerk Blog sjabloon",
"Show Plugins Help" => "Toon Hulp bij Plugins",
"Show Text Formatting Rules" => "Toon Tekstopmaak Regels",
"Program dynamic content for block" => "Dynamische inhoud voor een blok programmeren",
"Admin quizzes" => "Quizzen beheren",
"Admin Quizzes tpl" => "Quizzen beheren sjabloon",
"Edit Quiz Questions" => "Bewerk quiz vragen",
"Edit Quiz Questions Tpl" => "Bewerk quiz vragen sjabloon",
"Help on Articles" => "Hulp voor Artikelen",
"Edit Submissions Tpl" => "Bewerk bijdragen sjabloon",
"EditTemplates" => "BewerkSjablonen",
"EditTemplates tpl" => "BewerkSjablonen sjabloon",
"Edit Translations" => "Bewerk vertalingen",
"Edit Translations Template" => "Bewerk vertalingensjabloon",
"Message queue for" => "Berichtenwachtrij voor",
"back to forum" => "terug naar het forum",
"Reported messages for" => "Gemelde berichten voor",
"friends tpl" => "vrienden sjabloon",
"galleries tpl" => "galerijen sjabloon",
"ImportingPagesPhpWikiPageAdmin" => "ImporteerPaginasPhpWikiPageAdmin",
"tiki-import_phpwiki tpl" => "tiki-import_phpwiki sjabloon",
"hist" => "gesch.",
"List Articles Tpl" => "Opsommen artikelen sjabloon",
"Admin Cache" => "Buffer beheren",
"Admin Cache tpl" => "Buffer beheren sjabloon",
"Help on Dynamic Content" => "Hulp voor Dynamische Inhoud",
"List FAQs Tpl" => "Opsommen faqs sjabloon",
"games tpl" => "spellen sjabloon",
"List Posts Tpl" => "Opsommen berichten sjabloon",
"List Quizzes Tpl" => "Quizzen lijst sjabloon",
"Edit Quiz Stats Tpl" => "Bewerken quiz stats sjabloon",
"List Trackers Tpl" => "Trackers lijst sjabloon",
"Admin Live Support tpl" => "Live ondersteuning beheren sjabloon",
"back to admin" => "terug naar beheer",
"User Calendar" => "Gebruikerskalender",
"User Calendar Doc tpl" => "Gebruikerkalender Doc sjabloon",
"User Calendar Doc" => "Gebruikerkalender Doc",
"User Calendar Preferences Doc tpl" => "Gebruikerkalender Voorkeuren Doc sjabloon",
"my tiki tpl" => "mijn tiki sjabloon",
"Subscribe to This Newsletter" => "Abonneren",
"Stats for quiz" => "Statistieken voor quiz",
"Received Articles" => "Ontvangen artikelen",
"received articles tpl" => "ontvangen artikelen sjabloon",
"Help on Communication Center" => "Hulp voor Communicatiecentrum",
"received pages tpl" => "ontvangen pagina's sjabloon",
"Rename page" => "Hernoemen pagina",
"to_version" => "naar_versie",
"search stats tpl" => "zoek stats sjabloon",
"Admin Send Objects tpl" => "Verzend objecten beheren sjabloon",
"sheets tpl" => "rekenbladen sjabloon",
"Stats for survey" => "Statistieken voor opinieonderzoek",
"system logs" => "systeem logs",
"system logs tpl" => "systeem logs sjabloon",
"Theme Control Center: categories" => "Thema Controlepaneel: categorie&euml;n",
"ThemeControl" => "Thema Controle",
"ThemeControl tpl" => "Thema Controle sjabloon ",
"ThemeControl Objects" => "Thema-Controle Objecten",
"theme control objects tpl" => "thema-controle objecten sjabloon",
"Theme Control Center: sections" => "Theme Controlepaneel: secties",
"theme control sections tpl" => "thema-controle secties sjabloon",
"File Title" => "Bestandtitel",
"Image Gallery tpl" => "Beeldgalerij sjabloon",
"User Assigned Modules" => "Toegewezen Modules aan Gebruikers",
"User Assigned Modules tpl" => "Toegewezen Modules aan Gebruikers sjabloon",
"User Bookmarks tpl" => "Gebruikerfavorieten sjabloon",
"UserPreferences tpl" => "GebruikerVoorkeuren sjabloon",
"User Tasks tpl" => "Gebruikertaken sjabloon",
"User Watches tpl" => "Gebruikers waak sjabloon",
"View FAQ Tpl" => "Bekijk faq sjabloon",
"Admin Menus tpl" => "Menus beheren sjabloon",
"Edit mail account" => "Bewerk e-mail account",
"Add new mail account" => "Nieuw e-mail account toevoegen",
"User accounts" => "Gebruikeraccounts",
"View All" => "Alle Bekijken",
"Msg" => "Berichten",
"Can't parse remote HTML page" => "Kan verre HTML pagina niet lezen",
"Permission denied you cannot remove pages" => "Geen permissie om pagina's te verwijderen",
"Log SQL:" => "Log SQL:",
"LDAP Host" => "LDAP Host",
"Geourl" => "Geourl",
"meta robots" => "meta robots",
"Directory batch" => "Directory batch",
"Zoom" => "Zoom",
"SysLog" => "SysLog",
"Cannot write to this file" => "Kan niet naar dit bestand schrijven",
"Missing title or body when trying to post a comment" => "Ontbrekende titel of tekstlichaam bij poging om een bijdrage toe te voegen",
"\\n for rows" => "\\n voor rijen",
"Use this thread to discuss the %s page." => "Gebruik deze thread om over deze pagina te discussieren.",
"Newsletter subscription information at " => "Nieuwsbrief abonnementsinformatie op ",
"Changes" => "Wijzigingen",
"categorize this object" => "dit object categoriseren",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Uw account verzoek werd opgeslagen en zal zo snel mogelijk door een beheerder behandelde worden.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Plaatsing nieuw artikel: {\$mail_title} door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"New article post at %s" => "Plaatsing nieuw artikel op %s",
"Syntax highlighting" => "Schrijfwijzebelichting",
"MyTiki Home" => "MijnTiki start",
"My Files" => "Mijn bestanden",
"Mini calendar" => "Minikalender",
"FriendsMenu" => "VriendenMenu",
"User list" => "Gebruikerlist",
"Send Pages" => "Verzend pagina's",
"Received pages" => "Ontvangen pagina's",
"Admin Posts" => "Bijdragen beheren",
"Submit a New Link" => "Lever een nieuwe koppeling in",
"Browse directory" => "Blader in koppelingenlijst",
"Admin Directory" => "Koppelingenlijst beheren",
"Layer Management" => "Laagbeheer",
"List quizzes" => "Opsommen quizzen",
"ShtMenu" => "RknbldMenu",
"List trackers" => "Trackers opsommen",
"Ephemerides Admin" => "Spreuken beheren",
"Charts Admin" => "Rangschikkingen beheren",
"Debugger console" => "Foutcontrole",
"I forgot my pass" => "Ik ben mijn wachtwoord vergeten",
"Click to see the ratings" => "Klik om de beoordelingen te zien",
"Send trackback pings to:" => "Stuur trackback pings naar:",
"(comma separated list of URIs)" => "(komma-gescheiden lijst van URIs)",
"This is" => "Dit is",
"by the" => "door de",
"Tiki community" => "Tiki gemeenschap",
"User identity features" => "Kenmerken Gebruikersidentiteit",
"Use URI as Home Page" => "URI als startpagina gebruiken",
"OS" => "Besturingssysteem",
"Default charset for sending mail:" => "Standaard karakterset voor het sturen van mail:",
"Mail end of line:" => "Mail regeleinde:",
"Disallow access to the site (except for those with permission)" => "Verbied toegang tot de site (behalve voor diegenen met toestemming)",
"Message to display when site is closed" => "Dit bericht wordt getoond als de site gesloten is",
"Disallow access when load is above the threshold (except for those with permission)" => "Verbied toegang tot de site wanneer de belasting boven de toegestane limiet is (behalve voor diegenen met toestemming)",
"Max average server load threshold in the last minute" => "Max gemiddelde belastingslimiet in de laatste minuut",
"Message to display when server is too busy" => "Bericht dat wordt getoond wanneer de belasting te hoog is",
"Use cache for external images" => "Buffer gebruiken voor externe afbeeldingen",
"Use gzipped output" => "Gecomprimeerde uitvoer (gzip) gebruiken",
"output compression is active." => "Uitvoercompressie is actief.",
"compression is handled by" => "compressie wordt gedaan door",
"Sender Email" => "Verzender E-mail",
"Allow anonymous users to \"Contact Us\"" => "Geen anonieme gebruikers toestemming om \"Contacteer Ons\" te gebruiken",
"contact feature disabled" => "contact-onderdeel uitgeschakeld",
"Session lifetime in minutes" => "Levensduur van sessie in minuten",
"Proxy Host" => "Proxy Server",
"Proxy port" => "Proxy Poort",
"Please expect not found help-pages with the default-URL." => "Verwacht de \"Niet gevonden\" help-pagina's met de standaard URL.",
"Any help with the documentation is welcome." => "Alle hulp aan de documentatie is welkom.",
"When possible, show the real user name instead of login:" => "Toon, indien mogelijk, de echte gebruikersnaam in plaats van de login:",
"Locations separator" => "Scheidingsteken Locaties",
"Choices separator" => "Scheidingsteken keuzes",
"User registration and login" => "Gebruikerregistratie en -aanmelding",
"Use WebServer authentication for Tiki" => "Alleen WebServer authenticatie voor Tiki",
"... but need admin validation" => "... maar heeft een validatie door beheerder nodig",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "Je moet de <a href=\"tiki-admin.php?page=general\">Afzender van de e-mails</a> instellen",
"Use tracker for more user information" => "Gebruik tracker voor meer gebruikerinformatie",
"Use tracker for more group information" => "Gebruik tracker voor meer groupinformatie",
"Request passcode to register" => "Pascode voor registratie vragen",
"Php GD library required" => "Php GD bibliotheek vereist",
"Validate users by email" => "Gebruikers via e-mail valideren",
"Store plaintext passwords" => "Plaintext wachtwoorden opslaan",
"Reg users can change password" => "Geregistreerde gebruikers kunnen hun wachtwoord veranderen",
"Reg users can change language" => "Gereg. gebruikers kunnen taal wijzigen",
"Restrict available languages" => "Beperk beschikbare taken",
"Available languages:" => "Beschikbare taken:",
"Force to use chars and nums in passwords" => "Afdwingen om karakters en cijfers te gebruiken in wachtwoorden",
"Minimum password length" => "Minimale wachtwoordlengte",
"Password invalid after days" => "Wachtwoord ongeldig na aantal dagen",
"Remember me feature" => "Herinner-mij onderdeel",
"Duration:" => "Duur:",
"Remember me name" => "Onthou mijn naam",
"Remember me domain" => "Herinner mij domein",
"Remember me path" => "Herinner mij pad",
"Protect against CSRF with a confirmation step" => "Bescherm tegen CSRF met confirmatie stap",
"Highlight Group" => "Breng Groep naar voren",
"Create user if not in Tiki?" => "Maak gebruiker aan indien niet in Tiki?",
"Create user if not in Auth?" => "Maak gebruiker aan indien niet in Auth?",
"Just use Tiki auth for admin?" => "Gebruik Tiki auth voor beheerder?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(indien gebruikt zal deze waarde de benedenstaanden Host en Port instelling overschrijven)",
"LDAP Port" => "LDAP Poort",
"LDAP Scope" => "LDAP Gebied",
"LDAP Base DN" => "LDAP Basis DN",
"LDAP User DN" => "LDAP Gebruiker DN",
"LDAP User Attribute" => "LDAP Gebruikerattributen",
"LDAP User OC" => "LDAP Gebruiker OC",
"LDAP Group DN" => "LDAP Groep DN",
"LDAP Group Attribute" => "LDAP Groep Attribuut",
"LDAP Group OC" => "LDAP Groep OC",
"LDAP Member Attribute" => "LDAP Ledenattributen",
"LDAP Member Is DN" => "LDAP Lid Is DN",
"LDAP Admin User" => "LDAP Beheerder",
"LDAP Admin Pwd" => "LDAP Beheer Pwd",
"CAS server hostname" => "CAS server hostnaam",
"CAS server port" => "CAS server poort",
"CAS server path" => "CAS server pad",
"Change CAS preferences" => "Wijzig CAS voorkeuren",
"Meta Keywords" => "Meta Kernwoorden",
"Meta Description" => "Meta Beschrijving",
"Meta Author" => "Meta Auteur",
"revisit after" => "bezoek opnieuw na",
"Allow Smileys" => "Laat Smileys toe",
"Hotwords in New Windows" => "Hotwords in Nieuwe Vensters",
"Trackers attachments preferences" => "Instellingen Trackers bijlagen",
"Trackers attachments" => "Trackers bijlagen",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Om wiki pagina's toe te voegen of te bewerken, ga naar de module quick_edit via \"Modules\" in het applicatiemenu, of",
"Create a Tag for the Current Wiki" => "Maak een label aan voor het huidig Wiki",
"Restore the Wiki" => "Zet het Wiki terug",
"restore" => "herstellen",
"Remove a Tag" => "Verwijder een Label",
"Wiki Comments Settings" => "Instellingen Wiki Commentaar",
"Wiki Administration" => "Wiki Beheer",
"Wiki Home Page" => "Wiki-startpagina",
"Wiki Discussion" => "Wiki Discussie",
"Wiki Link Format" => "Formaat Wikikoppeling",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Bepaalt herkenning van wikikoppelingen gebruik makend van de dubbele haken schrijfwijze <i>((paginanaam))</i>.",
"Wiki Page List Configuration" => "Wiki Paginalijst Configuratie",
"Wiki 3D Browser Configuration" => "Wiki 3D Browser Configuratie",
"Wiki Features" => "Wiki Onderdelen",
"Wiki History" => "Wikigeschiedenis",
"Wiki Watch" => "Wiki Monitor",
"More Links" => "Meer Links",
"browse the category system" => "bekijk het categorie&euml;nsysteem",
"Admin Charts" => "Rangschikkingen beheren",
"Add new rule" => "voeg nieuwe regel toe",
"EMail notifications" => "E-mail meldingen",
"Edit this RSS module:" => "Bewerk deze RSS-module:",
"Create new RSS module" => "Maak nieuwe RSS-module aan",
"Tikiwiki settings" => "Tikiwiki instellingen",
"Create/edit questions for survey" => "Vragen voor opinieonderzoek aanmaken/beheren",
"Active?" => "Actief?",
"Create Trackers" => "Maak trackers aan",
"Create/Edit Trackers" => "Trackers maken/bewerken",
"Create item" => "Maak item aan",
"Assign to Groups" => "Wijs toe aan groepen",
"Delete this type" => "Verwijder dit type",
"Browse gallery" => "Galerij bekijken",
"Upload from disk" => "Aanleveren van harde schijf",
"Browsing Image" => "Afbeelding Bekijken",
"Again please" => "Nogmaals a.u.b.",
"Admin category relationships" => "Categorie-relaties beheren",
"Validate links" => "Links valideren",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Bestanden met namen gevolgd door -{\$user} zijn wijzigbaar, andere kunnen enkel gekopieerd worden en als model dienen.",
"Im- Export Languages" => "Im-/Export Talen",
"disable" => "schakel uit",
"Create a file gallery" => "Maak een bestandgalerij aan",
"Support tickets" => "Ondersteuningtickets",
"Return to HomePage" => "Terug naar startpagina",
"Stats for this survey Questions " => "Statistieken voor de vragen in dit opinieonderzoek ",
"Batch upload" => "Massa-aanlevering",
"1 suggestion" => "1 suggestie",
"suggestions" => "suggesties",
"Minor Edit" => "minder belangrijk",
"You can not download files" => "U kan geen bestanden afhalen",
"cannot be found" => "kan niet gevonden worden",
"Invalid password.  Your current password is required to change administrative information" => "Ongeldige wachtwoord.  Uw huidig wachtwoord is vereist om administratieve informatie bij te werken",
"Please wait 2 minutes between posts" => "Gelieve 2 minuten te wachten tussen elke bijdrage",
"hr" => "hr",
"The text in RED is" => "De tekst in ROOD is",
"Show Categories" => "Categorie&euml;n tonen",
"Hide Categories" => "Categorie&euml;n verbergen",
"Wiki page %s changed" => "Wiki pagina %s bijgewerkt",
"Blog features" => "Blog-onderdelen",
"Blog level comments" => "Opmerkingen blogniveau",
"Post level comments" => "Opmerkingen bijdrageniveau",
"Spellchecking" => "Spellingcontrole",
"Default ordering for blog listing" => "Standaardvolgorde van bloglijst",
"Blog listing configuration (when listing available blogs)" => "Bloglijst configuratie (bij het opsommen van beschikbare blogs)",
"Last modification time" => "Tijdstip laatste wijziging",
"Blog comments settings" => "Instellingen voor opmerkingen bij blogs",
"Group calendar sticky popup" => "Groepkalender plakpopup",
"Group calendar item view tab" => "Groepkalender bekijk item tab",
"Show Category Path" => "Toon Categorie Pad",
"Show Category Objects" => "Toon Categorie Objecten",
"Search may show forbidden results. Much better performance though." => "Zoekopdracht toont mogelijk verboden resultaten. Performatie is echter veel beter.",
"CMS features" => "CMS-onderdelen",
"Use templates" => "Sjablonen gebruiken",
"Settings for page articles home" => "Instellingen voor de Artikelen thuispagina",
"Maximum number of articles in home" => "Maximaal aantal artikelen in startpagina",
"Article comments settings" => "Instellingen voor opmerkingen bij artikelen",
"Fields to display on page" => "Velden om te tonen op pagina",
"Expire Date" => "Verloopdatum",
"Copyright Management" => "Auteursrechten beheren",
"License Page" => "Licentiepagina",
"Submit Notice" => "Lever bericht in",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Om bestandgalerijen aan te maken of te verwijderen, ga naar \"Bestadgalerijen\" n het applicatiemenu, of",
"Uploaded filenames must match regex" => "Namen van aangeleverde bestanden moeten overeenkomen met reguliere uitdrukking",
"Uploaded filenames cannot match regex" => "Namen van aangeleverde bestanden mogen niet overeenkomen met reguliere uitdrukking",
"File galleries comments settings" => "Instellingen voor opmerkingen bij bestandgalerijen",
"File galleries search indexing" => "Bestandgalerijen zoekindexering",
"Leave command blank to delete handler" => "Laat commando blanco om \\'handler\\' te verwijderen",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Gebruik %1 om aan te geven waar de interne bestandsnaam moet worden vervangen (voorbeeld: \"strings %1\" om het document te converteren naar tekst via het UNIX \\'strings\\' commando)",
"Enable auto indexing on file upload or change" => "Schakel auto-indexering in bij aanlevering of wijziging bestand",
"System command" => "Systeemcommando",
"Home Forum" => "Thuisforum",
"Forums features" => "Forumkenmerken",
"Forum quick jumps" => "Forum snelkoppelingen",
"Ordering for forums in the forum listing" => "Sortering van forums in forumlijsten",
"Forum listing configuration" => "Forumlijst configuratie",
"Show Babelfish Translation URLs" => "Toon Babelfish Vertaal URLs",
"Show Babelfish Translation Logo" => "Toon Babelfish Vertaal Logo",
"Show Module Controls" => "Toon Module Controles",
"Users can Configure Modules" => "Gebruikers kunnen Modules configureren",
"Users can Shade Modules" => "Gebruikers kunnen Modules in Schaduw plaatsen",
"module decides" => "module beslist",
"Allow Anonymous Poll Voting" => "Geef anonieme gebruikers toestemming om te Stemmen in Opiniepeilingen",
"Performance issues" => "Performatie problemen",
"Search features" => "Zoek onderdelen",
"SearchStats" => "ZoekStats",
"Settings for searching content" => "Instellingen voor zoeken op inhoud",
"Search refresh rate" => "Ververs tempo voor zoeken",
"this survey stats" => "statistieken voor dit opinieonderzoek",
"bold" => "vet",
"italic" => "schuinschrift",
"underline" => "onderstrepen",
"Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./setup.sh\" for example)." => "Apache heeft de rechten om in uw bestandssysteem te schrijven waardoor u kan installaties, de-installaties of upgrades van pakketten kan uitvoeren. Wanneer u klaar bent met deze werkzaamheden, denk er dan aan om deze permissies terug te zetten naar een veiligere installing (gebruik \"./setup.sh\" bijv).",
"To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./setup.sh open\" to set it up). After installation you need to remove that permission (using \"./setup.sh\")." => "Om installatie, de-installaties en upgrades van pakketten te kunnen doen, dient u de apache gebruiker de nodige rechten te geven om bestande aan te maken in het bestandssysteem van uw webruimte (gebruik hiervoor bijv. \"./setup.sh open\"). Na de installatie dient u deze rechten terug te verwijderen (gebruik dan \"./setup.sh\").",
"theme" => "thema",
"You have {\$unread} unread private messages" => "U heeft {\$unread} ongelezen priv&eacute; berichten",
"unread private messages" => "ongelezen priv-berichten",
"WfMenu" => "WfMenu",
"WikiMenu" => "WikiMenu",
"dump" => "dump",
"GalMenu" => "GalMenu",
"ForMenu" => "ForMenu",
"DirMenu" => "DirMenu",
"QuizMenu" => "QuizMenu",
"TrkMenu" => "TrkMenu",
"AdmMenu" => "AdmMenu",
"Pass" => "Pass",
"This module requires parameters trackerId and name set" => "Deze module vereist de parameters trackerId en name set",
"you or someone registered this email address at" => "uzelf of iemand anders registreerde dit e-mail adres bij",
"Your Tiki information registration" => "Uw Tiki informatie registratie",
"left/right" => "links/rechts",
"Unassign module" => "Maak toewijzing module ongedaan",
"home" => "startpagina",
"chat" => "Praatje",
"contact us" => "contacteer ons",
"debugger console" => "foutcontrole",
"MyMenu" => "MijnMenu",
"User menu" => "Gebruikermenu",
"rankings" => "rangordes",
"orphan pages" => "verweesde pagina's",
"sandbox" => "zandbak",
"received pages" => "ontvangen pagina's",
"structures" => "structuren",
"Articles Home" => "Artikel-startpagina",
"Send articles" => "Artikelen verzenden",
"Create/Edit Blog" => "Blog Maken/Bewerken",
"Browse Directory" => "Blader in Koppelingenlijst",
"FileGalMenu" => "BestandGalMenu",
"Admin FAQs" => "FAQs Beheren",
"Edit mapfiles" => "Bewerk landkaartbestanden",
"Admin quiz" => "Quiz beheren",
"Admin trackers" => "Trackers beheren",
"SrvMenu" => "EnqMenu",
"Send newsletters" => "Nieuwsbrieven verzenden",
"Send events" => "Verzend gebeurtenissen",
"Admin events" => "Beheer gebeurtenissen",
"EphMenu" => "SprkMenu",
"Ephemerides" => "Spreuken",
"ChartMenu" => "RankschkMenu",
"Admin home" => "Beheer start",
"Backups" => "Reservekopie&euml;n",
"Edit languages" => "Wijzigen talen",
"External wikis" => "Externe wiki's",
"Mods Admin" => "Mods Beheer",
"UsrMenu" => "GebrMenu",
"Click here to manage your personal menu" => "Klik hier om uw persoonlijk menu te beheren",
"Quick edit a Wiki page" => "Een wikipagina snel bewerken",
"Language: " => "Taal: ",
"Sort posts by:" => "Bijdragen sorteren volgens:",
"read more" => "lees meer",
"System Admin" => "Systeembeheer",
"Displays an miniquiz" => "Toont een miniquiz",
"some text" => "wat tekst",
"Creates a box with the data" => "Maakt een tekstkader met de gegevens",
"creates a title bar" => "maakt een titelbalk",
"creates a table" => "maakt een tabel",
"makes a horizontal rule" => "maakt een horizontale regel",
"page|desc" => "pagina|omschr.",
"displays an image" => "toont een afbeelding",
"Non cacheable images" => "Afbeeldingen die niet in buffer kunnen gebracht worden",
"height width desc link and align are optional" => "hoogte breedte omschr. koppeling en uitlijning zijn optioneel",
"Wiki File Attachments" => "Wiki Bijlagen",
"Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Maakt een koppeling aan naar genoemd bestand. Indien de pagina niet is opgegeven, zal het bestand aan de huidige pagina worden gehangen. Indien desc niet is opgegeven, zal de bestandsnaam worden gebruikt voor de koppelingstekst, tenzij showdesc wordt gebruikt waardoor de beschrijving het bestand dan als koppelingstekst wordt gebruikt. Als image=1 zal het opgegeven bestand als afbeelding worden beschouwd en rechtstreeks in de pagina worden getoond, zonder een koppeling aan te maken.",
"displays rss feed with id=n maximum=m items" => "toont RSS-invoer met id=n maximum=m items",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Zal vervangen worden door de actuele inhoud van het dynamische inhoudsblok met id=n",
"\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" toont een inhoudstabel voor de huidige pagina gebaseerd op de structuur (toc) of ! hoofdingen (maketoc)",
"Misc" => "Misc.",
"Focus:" => "Focus:",
"Click to Navigate" => "Klik om te navigeren",
"Tiki User Registration Request" => "Tiki Gebruikersregistratie Verzoek",
"Tiki email notification" => "Tiki e-mail melding",
"Your Tiki account information for %s" => "Uw Tiki account informatie voor %s",
"Reg users can change theme" => "Gereg. gebruikers kunnen thema wijzigen",
"Create/Edit Newsletters" => "Nieuwsbrieven maken/bewerken",
"Tiki Shoutbox" => "Tiki Spreekbuis",
"Allow sites in this category" => "Sites in deze categorie toestaan",
"Show number of sites in this category" => "Aantal sites in deze categorie tonen",
"Subcategories" => "Sub-categorie&euml;n",
"Admin related categories" => "Verwante categorie&euml;n beheren",
"Add a Category" => "Voeg een categorie toe",
"in current category" => "in huidige categorie",
"Total categories" => "Totaal categorie&euml;n",
"Days online" => "Dagen on-line",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "Copyright management" => "Copyright management",
// "Tiki is unable to connect to the database " => "Tiki is unable to connect to the database ",
// "Tiki was unable to retrieve login data from the database " => "Tiki was unable to retrieve login data from the database ",
// "The following error message was returned" => "The following error message was returned",
// "Things to check" => "Things to check",
// "Is your database up and running" => "Is your database up and running",
// "Are your database login credentials correct" => "Are your database login credentials correct",
// "Did you complete the <a href='tiki-install.php' >Tiki Installer" => "Did you complete the <a href='tiki-install.php' >Tiki Installer",
// "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information" => "Please see <a href=\"http://doc.tikiwiki.org/\">the documentation</a> for more information",
// "Uploaded" => "Uploaded",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Slideshow" => "Slideshow",
// "Default View" => "Default View",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Aland_Islands" => "Aland_Islands",
// "Albania" => "Albania",
// "American_Samoa" => "American_Samoa",
// "Andorra" => "Andorra",
// "Anguilla" => "Anguilla",
// "Aruba" => "Aruba",
// "Azerbaijan" => "Azerbaijan",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bhutan" => "Bhutan",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Bosnia_and_Herzegovina" => "Bosnia_and_Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Bouvet_Island" => "Bouvet_Island",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "British_Indian_Ocean_Territory" => "British_Indian_Ocean_Territory",
// "British_Virgin_Islands" => "British_Virgin_Islands",
// "Burkina Faso" => "Burkina Faso",
// "Burkina_Faso" => "Burkina_Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Cape Verde" => "Cape Verde",
// "Cape_Verde" => "Cape_Verde",
// "Catalan Countries" => "Catalan Countries",
// "Catalan_Countries" => "Catalan_Countries",
// "Cayman_Islands" => "Cayman_Islands",
// "Central African Republic" => "Central African Republic",
// "Central_African_Republic" => "Central_African_Republic",
// "Chad" => "Chad",
// "Christmas Island" => "Christmas Island",
// "Christmas_Island" => "Christmas_Island",
// "Cocos Islands" => "Cocos Islands",
// "Cocos_Islands" => "Cocos_Islands",
// "Comoros" => "Comoros",
// "Congo Democratic" => "Congo Democratic",
// "Congo" => "Congo",
// "Congo_Democratic" => "Congo_Democratic",
// "Cook_Islands" => "Cook_Islands",
// "Costa_Rica" => "Costa_Rica",
// "Czech_Republic" => "Czech_Republic",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican_Republic" => "Dominican_Republic",
// "El_Salvador" => "El_Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Equatorial_Guinea" => "Equatorial_Guinea",
// "Eritrea" => "Eritrea",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Falkland_Islands" => "Falkland_Islands",
// "Faroe Islands" => "Faroe Islands",
// "Faroe_Islands" => "Faroe_Islands",
// "Federated_States_of_Micronesia" => "Federated_States_of_Micronesia",
// "French Guiana" => "French Guiana",
// "French Southern Territories" => "French Southern Territories",
// "French_Guiana" => "French_Guiana",
// "French_Polynesia" => "French_Polynesia",
// "French_Southern_Territories" => "French_Southern_Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guernsey" => "Guernsey",
// "Guinea Bissau" => "Guinea Bissau",
// "Guinea" => "Guinea",
// "Guinea_Bissau" => "Guinea_Bissau",
// "Guyana" => "Guyana",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Heard_Island_and_McDonald_Islands" => "Heard_Island_and_McDonald_Islands",
// "Hong Kong" => "Hong Kong",
// "Hong_Kong" => "Hong_Kong",
// "Isle of Man" => "Isle of Man",
// "Ivory_Coast" => "Ivory_Coast",
// "Jersey" => "Jersey",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Marshall_Islands" => "Marshall_Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mayotte" => "Mayotte",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Netherlands Antilles" => "Netherlands Antilles",
// "Netherlands_Antilles" => "Netherlands_Antilles",
// "New_Caledonia" => "New_Caledonia",
// "New_Zealand" => "New_Zealand",
// "Niger" => "Niger",
// "Norfolk Island" => "Norfolk Island",
// "Norfolk_Island" => "Norfolk_Island",
// "North Korea" => "North Korea",
// "North_Korea" => "North_Korea",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "Northern_Mariana_Islands" => "Northern_Mariana_Islands",
// "Oman" => "Oman",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Papua_New_Guinea" => "Papua_New_Guinea",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Puerto_Rico" => "Puerto_Rico",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Republic_of_Macedonia" => "Republic_of_Macedonia",
// "Reunion" => "Reunion",
// "Russian_Federation" => "Russian_Federation",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Saint_Helena" => "Saint_Helena",
// "Saint_Kitts_and_Nevis" => "Saint_Kitts_and_Nevis",
// "Saint_Lucia" => "Saint_Lucia",
// "Saint_Pierre_and_Miquelon" => "Saint_Pierre_and_Miquelon",
// "San Marino" => "San Marino",
// "San_Marino" => "San_Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Sao_Tome_and_Principe" => "Sao_Tome_and_Principe",
// "Saudi_Arabia" => "Saudi_Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Sierra_Leone" => "Sierra_Leone",
// "Solomon_Islands" => "Solomon_Islands",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South_Africa" => "South_Africa",
// "South_Georgia_and_South_Sandwich_Islands" => "South_Georgia_and_South_Sandwich_Islands",
// "South_Korea" => "South_Korea",
// "Sri_Lanka" => "Sri_Lanka",
// "St_Vincent_Grenadines" => "St_Vincent_Grenadines",
// "Sudan" => "Sudan",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Svalbard_and_Jan_Mayen" => "Svalbard_and_Jan_Mayen",
// "Swaziland" => "Swaziland",
// "Syria" => "Syria",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Trinidad_Tobago" => "Trinidad_Tobago",
// "Tunisia" => "Tunisia",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Turks_and_Caicos_Islands" => "Turks_and_Caicos_Islands",
// "US Virgin Islands" => "US Virgin Islands",
// "US_Virgin_Islands" => "US_Virgin_Islands",
// "Uganda" => "Uganda",
// "United Nations Organization" => "United Nations Organization",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "United_Arab_Emirates" => "United_Arab_Emirates",
// "United_Kingdom" => "United_Kingdom",
// "United_Kingdom_-_England_and_Wales" => "United_Kingdom_-_England_and_Wales",
// "United_Kingdom_-_Northern_Ireland" => "United_Kingdom_-_Northern_Ireland",
// "United_Kingdom_-_Scotland" => "United_Kingdom_-_Scotland",
// "United_Nations_Organization" => "United_Nations_Organization",
// "United_States" => "United_States",
// "United_States_Minor_Outlying_Islands" => "United_States_Minor_Outlying_Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vatican" => "Vatican",
// "Viet Nam" => "Viet Nam",
// "Viet_Nam" => "Viet_Nam",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Wallis_and_Futuna" => "Wallis_and_Futuna",
// "Western Sahara" => "Western Sahara",
// "Western_Sahara" => "Western_Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "the former Yugoslav Republic of Macedonia" => "the former Yugoslav Republic of Macedonia",
// "the_former_Yugoslav_Republic_of_Macedonia" => "the_former_Yugoslav_Republic_of_Macedonia",
// "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter" => "Text_Wiki libraries need to be installed. Please see http://dev.tikiwiki.org/MediaWiki+to+TikiWiki+converter",
// "MySQL Improved (mysqli). Requires MySQL 4.1+" => "MySQL Improved (mysqli). Requires MySQL 4.1+",
// "MySQL classic (mysql)" => "MySQL classic (mysql)",
// "PostgeSQL 7.2+" => "PostgeSQL 7.2+",
// "Oracle" => "Oracle",
// "Sybase" => "Sybase",
// "SQLLite" => "SQLLite",
// "MSSQL" => "MSSQL",
// "Email address not valid, test mail not sent" => "Email address not valid, test mail not sent",
// "Email address empty and \"copy\" checkbox not set, test mail not sent" => "Email address empty and \"copy\" checkbox not set, test mail not sent",
// "Test mail from Tiki installer " => "Test mail from Tiki installer ",
// "Tiki version" => "Tiki version",
// "PHP version" => "PHP version",
// "Server" => "Server",
// "Congratulations!\n\nYour server can send emails.\n\n" => "Congratulations!\n\nYour server can send emails.\n\n",
// "Slovene" => "Slovene",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "Galician" => "Galician",
// "newest" => "newest",
// "oldest" => "oldest",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "Week" => "Week",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "Depends user language" => "Depends user language",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
// "Each day" => "Each day",
// "Each week" => "Each week",
// "Each month" => "Each month",
// "utf-8" => "utf-8",
// "iso-8859-1" => "iso-8859-1",
// "CRLF (standard)" => "CRLF (standard)",
// "LF (some Unix MTA)" => "LF (some Unix MTA)",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "1 hour" => "1 hour",
// "2 hours" => "2 hours",
// "10 hours" => "10 hours",
// "20 hours" => "20 hours",
// "1 year" => "1 year",
// "Encourage secure (https) login" => "Encourage secure (https) login",
// "Consider we are always in HTTPS, but do not check" => "Consider we are always in HTTPS, but do not check",
// "crypt-md5" => "crypt-md5",
// "crypt-des" => "crypt-des",
// "tikihash (old)" => "tikihash (old)",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
// "Admins" => "Admins",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Use @version:x.x specified in theme css or 2.0 if not specified" => "Use @version:x.x specified in theme css or 2.0 if not specified",
// "LastModif" => "LastModif",
// "Ascending" => "Ascending",
// "Descending" => "Descending",
// "No forums" => "No forums",
// "\$feature is turned on" => "\$feature is turned on",
// "\$feature is turned off" => "\$feature is turned off",
// "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing" => "\$feature set to \" . \$featureStr));\n\t\t\t\t} else {\n\t\t\t\t\t\$tikilib->set_preference(\$feature, \$_POST[\$feature]);\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to \" . \$featureStr));\n\t\t\t\t}\n\t\t\t} else if( \$isMultiple ) {\n\n\n\t\t\t\tif ( \$pref != '' ) {\n\t\t\t\t\t\$tikilib->set_preference(\$pref, array());\n\t\t\t\t\t\$prefs[\$feature] = \$_POST[\$feature];\n\t\t\t\t\t\$logslib->add_log('Configuration', tra(\"\$feature set to nothing",
// "\$feature set to nothing" => "\$feature set to nothing",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "All Day" => "All Day",
// "(not registered)" => "(not registered)",
// "Please wait %d secondes between posts" => "Please wait %d secondes between posts",
// "A contribution is mandatory" => "A contribution is mandatory",
// "Invalid Email" => "Invalid Email",
// "Your message has been queued for approval, the message will be posted after a moderator approves it" => "Your message has been queued for approval, the message will be posted after a moderator approves it",
// "This forum is locked" => "This forum is locked",
// "This thread is locked" => "This thread is locked",
// "Those comments are locked" => "Those comments are locked",
// "Foo" => "Foo",
// "Sample plugin" => "Sample plugin",
// "Face" => "Face",
// "Font family to use" => "Font family to use",
// "As defined by CSS" => "As defined by CSS",
// "Newsletter subscription information at" => "Newsletter subscription information at",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to" => "Select a Wiki page to link to",
// "Cannot open this file" => "Cannot open this file",
// "This is an approximation based on your server memory limit" => "This is an approximation based on your server memory limit",
// "This is the value of your server's PHP '%s' setting" => "This is the value of your server's PHP '%s' setting",
// "You are alerted by the server " => "You are alerted by the server ",
// "You can check the modifications at : " => "You can check the modifications at : ",
// "You are alerted of a change on " => "You are alerted of a change on ",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point" => "Query point",
// "layer" => "layer",
// "Record" => "Record",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it" => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it",
// "menu" => "menu",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed" => "This poll is closed",
// "Created by profile installer" => "Created by profile installer",
// "Page updated by profile installer" => "Page updated by profile installer",
// "The passwords do not match" => "The passwords do not match",
// "Feed provided by %s. Click to visit" => "Feed provided by %s. Click to visit",
// "Wiki Comment" => "Wiki Comment",
// "Calendar item" => "Calendar item",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "_HOMEPAGE_CONTENT_" => "_HOMEPAGE_CONTENT_",
// "<!-- jq smarty plugin inactive: feature_jquery off -->" => "<!-- jq smarty plugin inactive: feature_jquery off -->",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "You need either JQuery or MooTools enabled for this feature" => "You need either JQuery or MooTools enabled for this feature",
// "Help page" => "Help page",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "Gender" => "Gender",
// "No pageviews yet" => "No pageviews yet",
// "n/a" => "n/a",
// "You have to make %d choice(s) for the question" => "You have to make %d choice(s) for the question",
// "You have to make at least %d choice(s) for the question" => "You have to make at least %d choice(s) for the question",
// "You have to make less than %d choice(s) for the question" => "You have to make less than %d choice(s) for the question",
// "You have to choose at least %d choice(s) for the question" => "You have to choose at least %d choice(s) for the question",
// "Page '%0' cannot be found" => "Page '%0' cannot be found",
// "For the security of your password direct access to the feed is only available via https" => "For the security of your password direct access to the feed is only available via https",
// "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors" => "Your database requires an update to match the current TikiWiki version. Please proceed to <a href=\"tiki-install.php\">the installer</a>. Using Tiki with an incorrect database version usually provoke errors",
// "Help link" => "Help link",
// "Edit Plugin" => "Edit Plugin",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "You are not allowed to upload this type of file" => "You are not allowed to upload this type of file",
// "The file you are trying upload was only partially uploaded" => "The file you are trying upload was only partially uploaded",
// "You must select a file" => "You must select a file",
// "Flash player not available" => "Flash player not available",
// "__WARNING__: Plugin disabled \$plugin" => "__WARNING__: Plugin disabled \$plugin",
// "Upload was not successful. Duplicate file content " => "Upload was not successful. Duplicate file content ",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a one-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append,max</strong>\n\t\t\t\t<dt>Example: 0,80,\$,,80\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible length of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows alphanumeric text input in a multi-line field of arbitrary size.\n\t\t\t\t<dt>Usage: <strong>quicktags,width,height,max,listmax,wordmax</strong>\n\t\t\t\t<dt>Example: 0,80,5,30,200\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[quicktags]</strong> enables quicktags if a 1 is specified;\n\t\t\t\t<dd><strong>[width]</strong> is the width of the box, in chars;\n\t\t\t\t<dd><strong>[height]</strong> is the number of visible lines in the box;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that can be saved;\n\t\t\t\t<dd><strong>[listmax]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd><strong>[wordmax]</strong> will alert if word count exceeded with a positive number (1+) or display a word count with a negative number (-1);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a checkbox field for yes/no, on/off input.\n\t\t\t\t<dt>Usage: <strong>samerow</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field on the same row if a 1 is specified.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a one-line field for numeric input only.  Prepend or append values may be alphanumeric.\n\t\t\t\t<dt>Usage: <strong>samerow,size,prepend,append</strong>\n\t\t\t\t<dt>Example: 0,60,,hours\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[samerow]</strong> will display the next field or checkbox in the same row if a 1 is specified;\n\t\t\t\t<dd><strong>[size]</strong> is the visible size of the field in characters;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed just after the field;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select only from a specified set of options in a drop-down bar.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "drop down with other textfield" => "drop down with other textfield",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to select from a specified set of options in a drop-down bar, or provide an alternate selection in a one-line text field.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list_of_items]</strong> is the list of all values you want in the drop-down, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear once in the list as the default selection.\n\t\t\t\t</dl>",
// "radio buttons" => "radio buttons",
// "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a multiple-choice-style set of options from which a user may only choose one.\n\t\t\t\t<dt>Usage: <strong>list_of_items</strong>\n\t\t\t\t<dt>Example: yes,no\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[list of items]</strong> is the list of all values you want in the set, separated by commas;\n\t\t\t\t<dd>if you wish to specify a default value other than the first item, enter the value twice, consecutively, and it will appear as the one selected.\n\t\t\t\t<dd>If first option is &lt;br&gt;, options will be separated with a carriaage return\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usernames.\n\t\t\t\t<dt>Usage: <strong>auto-assign,email_notify</strong>\n\t\t\t\t<dt>Example: 1,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1, or will set the selection to the user who last modified the item if set to 2, or will give the choice between all the users for other values;\n\t\t\t\t<dd><strong>[email_notify]</strong> will send an email to the assigned user when the item is saved;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of usergroups.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the field to the usergroup of the creator if set to 1, or will set the selection to the group of the user who last modified the item if set to 2, or will give the choice between all the groups for other values;\n\t\t\t\t<dd>if the user does not have a default group set, the first group the user belongs to will be chosen, otherwise Registered group will be used.\n\t\t\t\t</dl>",
// "ip selector" => "ip selector",
// "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a field for entering an IP address.\n\t\t\t\t<dt>Usage: <strong>auto-assign</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-populate the field with the IP address of the user who created the item if set to 1, or will set the field to the IP of the user who last modified the item if set to 2, or will be a free IP for other values.\n\t\t\t\t</dl>",
// "page selector" => "page selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from the list of pages.\n\t\t\t\t<dt>Usage: <strong>auto-assign, size, create</strong>\n\t\t\t\t<dt>Example: 1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[auto-assign]</strong> will auto-assign the creator of the item if set to 1\n\t\t\t\t<dd><strong>[size]</strong> is the visible input length of the field in characters (<=0 not limited);\n\t\t\t\t<dd><strong>[create]</strong>: will create the page if not exits copy of the page with name value of this param.which pagename is the value of this param\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "country selector" => "country selector",
// "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a selection from a specified list of countries.\n\t\t\t\t<dt>Usage: <strong>name_flag,sort</strong>\n\t\t\t\t<dt>Example: 1,0\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[name_flag]</strong> default is 0 and will display both the country name and its flag, 1 will display only the country name, while 2 will show only the country flag;\n\t\t\t\t<dd><strong>[sortorder]</strong> specifies the order the country list should be displayed in, where 0 is the default and sorts according to the translated name, and 1 sorts according to the english name;\n\t\t\t\t<dd>if the country names are translated and option 1 is selected for the sort order, the countries will still appear translated, but will merely be in english order.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides drop-down options to accurately select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime,startyear,endyear,blankdate</strong>\n\t\t\t\t<dt>Example: d,2000,,blank\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\";\n\t\t\t\t<dd><strong>[startyear]</strong> allows you to specify a custom first year in the date range (eg. 1987), default is current year;\n\t\t\t\t<dd><strong>[endyear]</strong> allows you to specify a custom end year in the date range (eg. 2020), default is 4 years from now;\n\t\t\t\t<dd><strong>[blankdate]</strong> when set to \"blank\" will default the initial date field to an empty date, and allow selection of empty dates;\n\t\t\t\t<dd>blankdate is overridden if the field isMandatory;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dt>Example: \"d,2000,2009,blank\"\n\t\t\t\t<dd>sets a date only field from 2000 through 2009, allowing blank dates.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a javascript graphical date selector to select a date and/or time.\n\t\t\t\t<dt>Usage: <strong>datetime</strong>\n\t\t\t\t<dt>Example: dt\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[datetime]</strong> will only allow a date to be selected if set to \"d\", and allows a full date and time selection if set to \"dt\", defaulting to \"dt\".\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user to upload an image into the tracker item.\n\t\t\t\t<dt>Usage: <strong>xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale,shadowBox</strong>\n\t\t\t\t<dt>Example: 30,30,100,100,1000,item\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[xListSize]</strong> sets the pixel width of the image in the list view;\n\t\t\t\t<dd><strong>[yListSize]</strong> sets the pixel height of the image in the list view;\n\t\t\t\t<dd><strong>[xDetailSize]</strong> sets the pixel width of the image in the item view;\n\t\t\t\t<dd><strong>[yDetailSize]</strong> sets the pixel height of the image in the item view;\n\t\t\t\t<dd><strong>[uploadLimitScale]</strong> sets the maximum total size of the image, in pixels (width or height);\n\t\t\t\t<dd><strong>[shadowbox]</strong> actives a shadowbox(if feature on) = \\'item\\': to use the same shadowbox for an item, =\\'individual\\': to use a shadowbox only for this image, other value= to set the group of images of the shadowbox ;\n\t\t\t\t<dd>images are stored in img/trackers;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: ?\n\t\t\t\t<dt>Usage: <strong>label,post,tiki-index.php,page:fieldname,highlight=test</strong>\n\t\t\t\t<dt>Example: \n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[label]</strong> needs explanation;\n\t\t\t\t<dd><strong>[post]</strong> needs explanation;\n\t\t\t\t<dd><strong>[tiki-index.php]</strong> needs explanation;\n\t\t\t\t<dd><strong>[page:fieldname]</strong> needs explanation;\n\t\t\t\t<dd><strong>[highlight=test]</strong> needs explanation;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: will display trhe field name as a html header h2;\n\t\t\t\t</dl>",
// "static text" => "static text",
// "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows insertion of a static block of text into a tracker to augment input fields. (non-editable)\n\t\t\t\t<dt>Usage: <strong>wikiparse,max</strong>\n\t\t\t\t<dt>Example: 1,20\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[wikiparse]</strong> will allow wiki syntax to be parsed if set to 1, otherwise default is 0 to only support line-breaks;\n\t\t\t\t<dd><strong>[max]</strong> is the maximum number of characters that are displayed in list mode;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows one or more categories under a main category to be assigned to the tracker item.\n\t\t\t\t<dt>Usage: <strong>parentId,inputtype,selectall</strong>\n\t\t\t\t<dt>Example: 12,radio,1\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[parentId]</strong> is the ID of the main category, categories in the list will be children of this;\n\t\t\t\t<dd><strong>[inputtype]</strong> is one of [d|m|radio|checkbox], where d is a drop-down list, m is a multiple-selection drop-down list, radio and checkbox are self-explanatory;\n\t\t\t\t<dd><strong>[selectall]</strong> will provide a checkbox to automatically select all categories in the list if set to 1, default is 0;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a way to choose a value from another tracker (eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldId,linkToItem,displayedFieldsList</strong>\n\t\t\t\t<dt>Example: 3,5,1,6|8\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldId]</strong> is the field in [trackerId] from which you can select a value among all the field values of the items of [trackerId];\n\t\t\t\t<dd><strong>[linkToItem]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to the item in the other tracker;\n\t\t\t\t<dd><strong>[displayedFieldsList]</strong> is a list of fields in [trackerId] to display instead of [fieldId], multiple fields can be separated with a |;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Displays a list of field values from another tracker that has a relation with this tracker(eventually with a link).\n\t\t\t\t<dt>Usage: <strong>trackerId,fieldIdThere,fieldIdHere,displayFieldIdThere,linkToItems</strong>\n\t\t\t\t<dt>Example: 5,3,4,10|11\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the tracker ID of the fields you want to display;\n\t\t\t\t<dd><strong>[fieldIdThere]</strong> is the field (multiple fields can be separated with a \":\") you want to link with;\n\t\t\t\t<dd><strong>[fieldIdHere]</strong> is the field in this tracker you want to link with;\n\t\t\t\t<dd><strong>[displayFieldIdThere]</strong> the field(s) in [trackerId] you want to display, multiple fields can be separated by \"|\";\n\t\t\t\t<dd><strong>[linkToItems]</strong> if set to 0 will simply display the value, but if set to 1 will provide a link directly to that values item in the other tracker;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "dynamic items list" => "dynamic items list",
// "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Dynamically updates a selection list based on linked data from another tracker.\n\t\t\t\t<dt>Usage: <strong>trackerId,filterFieldIdThere,filterFieldIdHere,listFieldIdThere,statusThere</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[trackerId]</strong> is the ID of the tracker to link with;\n\t\t\t\t<dd><strong>[filterFieldIdThere]</strong> is the field you want to link with in that tracker;\n\t\t\t\t<dd><strong>[filterFieldIdHere]</strong> is the field you want to link with in the current tracker;\n\t\t\t\t<dd><strong>[listFieldIdThere]</strong> is the field ID you wish to pull the selection list from, based on the value selected in fiterFieldIdHere matching field(s) in filterFieldIdThere;\n\t\t\t\t<dd><strong>[statusThere]</strong> restricts values appearing in the list to those coming from records in the other tracker that meet specified statuses of [o|p|c] or in combination (op, opc);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows users to enter an email address with option of making it active.\n\t\t\t\t<dt>Usage: <strong>link,watchopen,watchpending,watchclosed</strong>\n\t\t\t\t<dt>Example: 0,o\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[link]</strong> may be one of [0|1|2] and specifies how to display the email address, defaulting to 0 as plain text, 1 as an encoded hex mailto link, or 2 as a standard mailto link;\n\t\t\t\t<dd><strong>[watchopen]</strong> if set to \"o\" will email the address every time the status of the item changes to open;\n\t\t\t\t<dd><strong>[watchpending]</strong> if set to \"p\" will email the address every time the status of the item changes to pending;\n\t\t\t\t<dd><strong>[watchclosed]</strong> if set to \"c\" will email the address every time the status of the item changes to closed;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "multimedia" => "multimedia",
// "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Will play MP3 or FLV files, as specified, in a player.\n\t\t\t\t<dt>Usage: <strong>source,xSize,ySize</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[source]</strong> is one of [0|1|2|3|4|5] where 0 is default and will support a URL in the file gallery for MP3, 1 for URL in file gallery for FLV, 2 for URL in file gallery of either MP3 or FLV, 3 to upload an MP3 file to be played, 4 to upload an FLV file to be played, 5 to upload either an MP3 or FLV file;\n\t\t\t\t<dd><strong>[xSize]</strong> is the width in pixels of the player applet (default 200);\n\t\t\t\t<dd><strong>[ySize]</strong> is the height in pixels of the player applet (default 100);\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t<dd>this is best-used as a tracker item that is not generally editable and you want a specific file played;\n\t\t\t\t\tedit the tracker item and provide the URL for the file you wish to play.\n\t\t\t\t</dl>",
// "auto-increment" => "auto-increment",
// "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows an incrementing value field, or itemId field. (non-editable)\n\t\t\t\t<dt>Usage: <strong>start,prepend,append,itemId</strong>\n\t\t\t\t<dt>Example: 1,,,itemId\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[start]</strong> is the starting value for the field, defaults to 1;\n\t\t\t\t<dd><strong>[prepend]</strong> is text that will be displayed before the field;\n\t\t\t\t<dd><strong>[append]</strong> is text that will be displayed after the field;\n\t\t\t\t<dd><strong>[itemId]</strong> if set to \"itemId\" will set this field to match the value of the actual database itemId field value;\n\t\t\t\t<dd>multiple options must appear in the order specified, separated by commas.\n\t\t\t\t</dl>",
// "user subscription" => "user subscription",
// "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allow registered users to subscribe themselves to a tracker item (think Evite.com).\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Use this field as you would to have people sign up for an event. It is best if the tracker is only editable by its creator or the admin.  To set the max number of subscribers, edit the tracker item and put the number at the beginning of the field.\n\t\t\t\t<dt>Example:\n\t\t\t\t<dd>Old field may have \"#\" or \"#2[0]\" in it.  Making it \"20#2[0]\" will set the max number to 20.\n\t\t\t\t</dl>",
// "Google Maps" => "Google Maps",
// "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Use Google Maps.\n\t\t\t\t<dt>Will display a Google Maps around a point.\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: System only.\n\t\t\t\t<dt>Usage: None\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd>Needs a description.\n\t\t\t\t</dl>",
// "computed field" => "computed field",
// "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Provides a computed value based on numeric field values.\n\t\t\t\t<dt>Usage: <strong>formula</strong>\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[formula]</strong> is the formula you wish to compute, using numeric values, operators \"+ - * / ( )\", and tracker fields identified with a leading #;\n\t\t\t\t<dt>Example: \"#3*(#4+5)\"\n\t\t\t\t<dd>adds the numeric value in item 4 by 5, and multiplies it by the numeric value in item 3.\n\t\t\t\t</dl>",
// "user preference" => "user preference",
// "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows user preference changes from a tracker.\n\t\t\t\t<dt>Usage: <strong>type</strong>\n\t\t\t\t<dt>Example: password\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[type]</strong> if value is password, will allow to change the user password, if value is email, will display/allow to change the user email;\n\t\t\t\t</dl>",
// "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>" => "<dl>\n\t\t\t\t<dt>Function: Allows a file to be attached to the tracker item.\n\t\t\t\t<dt>Usage: <strong>listview</strong>\n\t\t\t\t<dt>Example: nu\n\t\t\t\t<dt>Description:\n\t\t\t\t<dd><strong>[listview]</strong> may be one of [n|t|s|u] on their own or in any combination (n, t, ns, nts), allowing you to see the attachment in the item list view as its name (n), its type (t), its name (n), or display the username of the uploader (u);\n\t\t\t\tnote that this option will cost an extra query to the database for each attachment and can severely impact performance with several attachments.\n\t\t\t\t<dd>\n\t\t\t\t</dl>",
// "The administrator has not yet validated your account. Please wait" => "The administrator has not yet validated your account. Please wait",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "User-Agent Info" => "User-Agent Info",
// "Displays various information about the client" => "Displays various information about the client",
// "Info required - IP|SVRSW|BROWSER" => "Info required - IP|SVRSW|BROWSER",
// "Anchor Link" => "Anchor Link",
// "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin" => "Creates a link to an anchor within a page. Anchors can be created using the ANAME plugin",
// "Anchor link label" => "Anchor link label",
// "The anchor name as defined in the ANAME plugin" => "The anchor name as defined in the ANAME plugin",
// "The name of the wiki page containing the anchor" => "The name of the wiki page containing the anchor",
// "Anchor Name" => "Anchor Name",
// "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin" => "Inserts an anchor in the wiki page. Anchors can be linked to using the ALINK plugin",
// "The name of the anchor" => "The name of the anchor",
// "Image Annotation" => "Image Annotation",
// "Autogenerated content. Leave blank initially" => "Autogenerated content. Leave blank initially",
// "Absolute URL to the image or relative path from tikiwiki root" => "Absolute URL to the image or relative path from tikiwiki root",
// "Width" => "Width",
// "Image width" => "Image width",
// "Height" => "Height",
// "Image height" => "Image height",
// "Alignment" => "Alignment",
// "Image alignment. Possible values: left, right, center" => "Image alignment. Possible values: left, right, center",
// "Save changes to annotations" => "Save changes to annotations",
// "Image annotations changed" => "Image annotations changed",
// "Creates an annotation block for an image" => "Creates an annotation block for an image",
// "Displays an image and allow the users to define zones to highlight information on the image" => "Displays an image and allow the users to define zones to highlight information on the image",
// "Includes an article\\'s content within the page" => "Includes an article\\'s content within the page",
// "The article field to display. Default field is Heading" => "The article field to display. Default field is Heading",
// "Article ID" => "Article ID",
// "The article to display. If no value is provided, most recent article will be used" => "The article to display. If no value is provided, most recent article will be used",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading" => "Id is optional. If not given, last article is used. Default field is heading",
// "Article List" => "Article List",
// "Includes a list of articles within the page" => "Includes a list of articles within the page",
// "Articles displayed" => "Articles displayed",
// "The amount of articles to display in the list" => "The amount of articles to display in the list",
// "Topics expression" => "Topics expression",
// "Topic ID expression" => "Topic ID expression",
// "Type expression" => "Type expression",
// "Category ID" => "Category ID",
// "The ID of the category to list from" => "The ID of the category to list from",
// "The article language to list" => "The article language to list",
// "Sort order" => "Sort order",
// "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")" => "The column and order of the sort in columnName_asc or columnName_desc format. Defaults to \"publishDate_desc\" (other column examples are \"title\", \"lang\", \"authorName\" & \"topicName\")",
// "Quiet" => "Quiet",
// "Whether to not report when there are no articles" => "Whether to not report when there are no articles",
// "Title only" => "Title only",
// "Whether to only show the title of the articles" => "Whether to only show the title of the articles",
// "Show body" => "Show body",
// "Whether to only show the body of the articles or just the heading" => "Whether to only show the body of the articles or just the heading",
// "Starting article" => "Starting article",
// "The article number that the list should start with" => "The article number that the list should start with",
// "Start date" => "Start date",
// "Earliest date to select articles from" => "Earliest date to select articles from",
// "End date" => "End date",
// "Latest date to select articles from" => "Latest date to select articles from",
// "Override Dates" => "Override Dates",
// "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings" => "Whether obey article type\\'s \"show before publish\" and \"show after expiry\" settings",
// "Container class" => "Container class",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_articles\")",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc), quiet=>y|n, titleonly=>y|n}{ARTICLES}~/np~",
// "Bullets" => "Bullets",
// "Inline" => "Inline",
// "Number" => "Number",
// "Show icon" => "Show icon",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "The wiki page the avatar will link to" => "The wiki page the avatar will link to",
// "Float" => "Float",
// "left|right" => "left|right",
// "Displays a link that allows to go back in the browser history" => "Displays a link that allows to go back in the browser history",
// "Insert back link on wiki page" => "Insert back link on wiki page",
// "List all pages linking to the specified page" => "List all pages linking to the specified page",
// "The page links will point to. Default value is the current page" => "The page links will point to. Default value is the current page",
// "Displayed information" => "Displayed information",
// "Pipe separated list of fields to display. ex: hits|user" => "Pipe separated list of fields to display. ex: hits|user",
// "Excluded pages" => "Excluded pages",
// "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox" => "Pipe separated list of pages to be excluded from the listing. ex: HomePage|Sandbox",
// "Include Self" => "Include Self",
// "1|0" => "1|0",
// "No Header" => "No Header",
// "Banner" => "Banner",
// "Insert a banner" => "Insert a banner",
// "Target" => "Target",
// "missing parameter" => "missing parameter",
// "Blog List" => "Blog List",
// "Use BLOGLIST to include posts from a blog" => "Use BLOGLIST to include posts from a blog",
// "Blog ID" => "Blog ID",
// "Numeric value" => "Numeric value",
// "Maximum number of entries to list" => "Maximum number of entries to list",
// "Simple list" => "Simple list",
// "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)" => "Show simple list of date, title and author (default=y) or formatted list of blog posts (n)",
// "Earliest date to select posts from" => "Earliest date to select posts from",
// "Latest date to select posts from" => "Latest date to select posts from",
// "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")" => "CSS Class to add to the container DIV.article. (Default=\"wikiplugin_bloglist\")",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// "where Id is the blog Id and Items is the max number of posts to display" => "where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Box" => "Box",
// "Box title" => "Box title",
// "Displayed above the content" => "Displayed above the content",
// "Background color" => "Background color",
// "As defined by CSS, name or Hex code" => "As defined by CSS, name or Hex code",
// "Box width" => "Box width",
// "In pixels or percentage. Default value is 100%" => "In pixels or percentage. Default value is 100%",
// "Text Alignment" => "Text Alignment",
// "Float Position" => "Float Position",
// "for box with width lesser than 100%, make text wrap around the box" => "for box with width lesser than 100%, make text wrap around the box",
// "CSS Class" => "CSS Class",
// "Apply custom CSS class to the box" => "Apply custom CSS class to the box",
// "Category IDs" => "Category IDs",
// "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page" => "List of category IDs separated by + signs. ex: 1+2+3. Default will use category of the current page",
// "Types" => "Types",
// "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img" => "List of object types to include in the list separated by plus signs. ex: article+blog+faq+fgal+forum+igal+newsletter+event+poll+quiz+survey+tracker+wiki+img",
// "Sort Order" => "Sort Order",
// "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle" => "fieldName_asc|fieldName_desc, valid fields: type, created, name, hits, shuffle",
// "Split" => "Split",
// "And" => "And",
// "Category Orphans" => "Category Orphans",
// "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker" => "wiki|article|blog|faq|fgal|forum|igal|newsletter|poll|quizz|survey|tracker",
// "Category Path" => "Category Path",
// "Separator" => "Separator",
// "String used to separate the categories in the path. Default character is >" => "String used to separate the categories in the path. Default character is >",
// "Display top category" => "Display top category",
// "yes|no, default to no" => "yes|no, default to no",
// "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool" => "Displays a chart from TikiSheet. This plugin can be generated by the TikiSheet chart tool",
// "Chart caption" => "Chart caption",
// "Sheet ID" => "Sheet ID",
// "Data sheet ID" => "Data sheet ID",
// "Chart Type" => "Chart Type",
// "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic" => "BarStackGraphic|MultibarGraphic|MultilineGraphic|PieChartGraphic",
// "Chart Width" => "Chart Width",
// "Width in pixels" => "Width in pixels",
// "Chart Height" => "Chart Height",
// "Height in pixels" => "Height in pixels",
// "Value series" => "Value series",
// "Required for pie charts" => "Required for pie charts",
// "Independant series" => "Independant series",
// "Required for types other than pie chart" => "Required for types other than pie chart",
// "Dependant series" => "Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y2' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y3' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series" => "'),\n\t\t\t),\n\t\t\t'y4' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Dependant series",
// "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors" => "'),\n\t\t\t),\n\t\t\t'color' => array(\n\t\t\t\t'required' => false,\n\t\t\t\t'name' => tra('Colors",
// "List of colors to use" => "List of colors to use",
// "Styles" => "Styles",
// "List of styles to use" => "List of styles to use",
// "Labels" => "Labels",
// "Labels for the series or values in the legend" => "Labels for the series or values in the legend",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "Caption" => "Caption",
// "Code snippet label" => "Code snippet label",
// "Word Wrap" => "Word Wrap",
// "0|1, Enable word wrapping on the code to avoid breaking the layout" => "0|1, Enable word wrapping on the code to avoid breaking the layout",
// "Colors" => "Colors",
// "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, .." => "Syntax highlighting to use. May not be used with line numbers. Available: php, html, sql, javascript, css, java, c, doxygen, delphi, ..",
// "Line numbers" => "Line numbers",
// "0|1, may not be used with colors" => "0|1, may not be used with colors",
// "Wiki syntax" => "Wiki syntax",
// "0|1, parse wiki syntax within the code snippet" => "0|1, parse wiki syntax within the code snippet",
// "Right to left" => "Right to left",
// "0|1, switch the text display from left to right to right to left" => "0|1, switch the text display from left to right to right to left",
// "Content is HTML" => "Content is HTML",
// "0|1, display the content as is instead of escaping HTML special chars" => "0|1, display the content as is instead of escaping HTML special chars",
// "Includes content from the dynamic content system" => "Includes content from the dynamic content system",
// "Content ID" => "Content ID",
// "Also known as Fortune cookies or Taglines" => "Also known as Fortune cookies or Taglines",
// "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~" => "Pattern to display the copyright in. May contain ~title~, ~year~ and ~authors~",
// "Countdown" => "Countdown",
// "Displays a countdown from now until the specified date" => "Displays a countdown from now until the specified date",
// "Text to append to the countdown" => "Text to append to the countdown",
// "Target date. Multiple formats accepted" => "Target date. Multiple formats accepted",
// "Locate Time" => "Locate Time",
// "on|off" => "on|off",
// "DBReport" => "DBReport",
// "Run a database report" => "Run a database report",
// "report definition" => "report definition",
// "Full DSN" => "Full DSN",
// "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database" => "A full DSN (Data Source Name) connection string. eg: mysql://user:pass@server/database",
// "Wiki DSN name" => "Wiki DSN name",
// "The name of a DSN connection defined by the Wiki administrator" => "The name of a DSN connection defined by the Wiki administrator",
// "0|1, parse wiki syntax within the report" => "0|1, parse wiki syntax within the report",
// "Debug" => "Debug",
// "0|1, display the parsed report definition" => "0|1, display the parsed report definition",
// "Missing db or dsn parameter" => "Missing db or dsn parameter",
// "You do not have permission to use this DSN" => "You do not have permission to use this DSN",
// "No DSN connection string found" => "No DSN connection string found",
// "Div" => "Div",
// "div|span|pre|b|i|tt|p|blockquote" => "div|span|pre|b|i|tt|p|blockquote",
// "left|right|center|justify" => "left|right|center|justify",
// "left|right, for box with width lesser than 100%, make text wrap around the box" => "left|right, for box with width lesser than 100%, make text wrap around the box",
// "Apply custom CSS class to the div" => "Apply custom CSS class to the div",
// "HTML id" => "HTML id",
// "Sets the div\\'s id attribute, as defined by HTML" => "Sets the div\\'s id attribute, as defined by HTML",
// "Definition List" => "Definition List",
// "One entry per line. Each line is in \"Term: Definition\" format" => "One entry per line. Each line is in \"Term: Definition\" format",
// "Draw" => "Draw",
// "Displays drawings in the wiki page" => "Displays drawings in the wiki page",
// "Name of the drawing to display" => "Name of the drawing to display",
// "Name parameter missing" => "Name parameter missing",
// "Equation" => "Equation",
// "Renders an equation written in LaTeX syntax as an image" => "Renders an equation written in LaTeX syntax as an image",
// "equation" => "equation",
// "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large" => "Percentage of increase from normal size. 100 produces the default size. 200 produces an image twice as large",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "Includes the list of events from a calendar in the page" => "Includes the list of events from a calendar in the page",
// "Calendar ID" => "Calendar ID",
// "Numeric" => "Numeric",
// "Maximum days" => "Maximum days",
// "Maximum Rows" => "Maximum Rows",
// "Datetime" => "Datetime",
// "0|1" => "0|1",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Fade" => "Fade",
// "Displays a label. On click, the block of content will fade in and fade out" => "Displays a label. On click, the block of content will fade in and fade out",
// "Wiki syntax containing the text to display" => "Wiki syntax containing the text to display",
// "Label to display on first display" => "Label to display on first display",
// "Unspecified label" => "Unspecified label",
// "Fancy List" => "Fancy List",
// "One item per line starting with anything followed by \")\"" => "One item per line starting with anything followed by \")\"",
// "Use div" => "Use div",
// "Use div instead of ol" => "Use div instead of ol",
// "Class" => "Class",
// "CSS class of the fancylist" => "CSS class of the fancylist",
// "Creates a fancy looking list" => "Creates a fancy looking list",
// "num" => "num",
// "item text" => "item text",
// "one item per line" => "one item per line",
// "Fancy Table" => "Fancy Table",
// "One row per line, cells separated by ~|~" => "One row per line, cells separated by ~|~",
// "Heading row" => "Heading row",
// "Heading row of the table, same format as the body section" => "Heading row of the table, same format as the body section",
// "Heading CSS Class" => "Heading CSS Class",
// "CSS Class to apply on the heading row" => "CSS Class to apply on the heading row",
// "Displays a link to an attachment to a wiki page and can display an image attachment. " => "Displays a link to an attachment to a wiki page and can display an image attachment. ",
// "Gallery ID" => "Gallery ID",
// "name_asc" => "name_asc",
// "Shows ID" => "Shows ID",
// "Shows Icon" => "Shows Icon",
// "Shows Name" => "Shows Name",
// "Shows Filename" => "Shows Filename",
// "Shows Size" => "Shows Size",
// "Shows Description" => "Shows Description",
// "Shows Creation Date" => "Shows Creation Date",
// "Shows Hits" => "Shows Hits",
// "Shows Locked by" => "Shows Locked by",
// "Shows Modification Date" => "Shows Modification Date",
// "Shows Author" => "Shows Author",
// "Shows Creator" => "Shows Creator",
// "Shows Parent Gallery Name" => "Shows Parent Gallery Name",
// "Shows Number of Files" => "Shows Number of Files",
// "Shows the slideshow of a gallery" => "Shows the slideshow of a gallery",
// "List files in a file gallery (with a category) or in a category or a file gallery od this category" => "List files in a file gallery (with a category) or in a category or a file gallery od this category",
// "Displays a list of files from the File Gallery" => "Displays a list of files from the File Gallery",
// "Flash video" => "Flash video",
// "Movie URL" => "Movie URL",
// "Complete URL to the movie to include" => "Complete URL to the movie to include",
// "Default width: 425" => "Default width: 425",
// "Default height: 350" => "Default height: 350",
// "Quality" => "Quality",
// "Flash video quality. Default value: high" => "Flash video quality. Default value: high",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Footnote" => "Footnote",
// "Inserts a superscripted footnote number next to text and takes in footnote as parameter" => "Inserts a superscripted footnote number next to text and takes in footnote as parameter",
// "The footnote" => "The footnote",
// "Sameas" => "Sameas",
// "Tag to existing footnote" => "Tag to existing footnote",
// "CheckDuplicate" => "CheckDuplicate",
// "check for duplcate footnotes" => "check for duplcate footnotes",
// "Footnotearea" => "Footnotearea",
// "Inserts a section for collected footnotes within the wiki page" => "Inserts a section for collected footnotes within the wiki page",
// "Download box for a file on ftp server" => "Download box for a file on ftp server",
// "ftp" => "ftp",
// "file name" => "file name",
// "Ftp Server Name" => "Ftp Server Name",
// "Ftp User name" => "Ftp User name",
// "Ftp password" => "Ftp password",
// "Download button label" => "Download button label",
// "missing parameters" => "missing parameters",
// "Connection failed" => "Connection failed",
// "Incorrect param" => "Incorrect param",
// "Gauge" => "Gauge",
// "Displays a graphical gauge" => "Displays a graphical gauge",
// "current value (REQUIRED)" => "current value (REQUIRED)",
// "Maximum Value" => "Maximum Value",
// "Maximum possible value. Default: 100" => "Maximum possible value. Default: 100",
// "Label displayed on the left side of the gauge" => "Label displayed on the left side of the gauge",
// "Color" => "Color",
// "Background Color" => "Background Color",
// "Bar width in pixels" => "Bar width in pixels",
// "Label Width" => "Label Width",
// "Width in pixels allocated to the label" => "Width in pixels allocated to the label",
// "Display Percentage" => "Display Percentage",
// "true|false, if true then a percentage of the maximum is displayed" => "true|false, if true then a percentage of the maximum is displayed",
// "Display Value" => "Display Value",
// "true|false, if the numeric value is displayed" => "true|false, if the numeric value is displayed",
// "Bar height in pixels" => "Bar height in pixels",
// "Google Analytics" => "Google Analytics",
// "Add the tracking code for Google Analytics" => "Add the tracking code for Google Analytics",
// "Account number" => "Account number",
// "The account number for the site" => "The account number for the site",
// "Missing parameter" => "Missing parameter",
// "googledoc" => "googledoc",
// "Leave this empty" => "Leave this empty",
// "Type of Google document" => "Type of Google document",
// "key" => "key",
// "Google doc key - for example pXsHENf1bGGY92X1iEeJJI" => "Google doc key - for example pXsHENf1bGGY92X1iEeJJI",
// "Name of iframe" => "Name of iframe",
// "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large" => "Size of frame, use instead of width and height, they will fit the Google presentations sizes exactly. It can be small|medium|large",
// "Pixels or %" => "Pixels or %",
// "Margin Height" => "Margin Height",
// "Pixels" => "Pixels",
// "Margin Width" => "Margin Width",
// "Scrolling" => "Scrolling",
// "editLink" => "editLink",
// "Required parameter \"type\" missing" => "Required parameter \"type\" missing",
// "Required parameter \"key\" missing" => "Required parameter \"key\" missing",
// "Displays a Google document" => "Displays a Google document",
// "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition" => "Wiki text to display if conditions are met. The body may contain {ELSE}. Text after the marker will be displayed to users not matching the condition",
// "Allowed Groups" => "Allowed Groups",
// "Pipe separated list of groups allowed to view the block. ex: Admins|Developers" => "Pipe separated list of groups allowed to view the block. ex: Admins|Developers",
// "Denied Groups" => "Denied Groups",
// "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers" => "Pipe separated list of groups denied from viewing the block. ex: Anonymous|Managers",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "HTML" => "HTML",
// "Include literal HTML in a Wiki page" => "Include literal HTML in a Wiki page",
// "0|1, parse wiki syntax within the html code" => "0|1, parse wiki syntax within the html code",
// "Include literal HTML" => "Include literal HTML",
// "Iframe" => "Iframe",
// "Frame title" => "Frame title",
// "iframe" => "iframe",
// "Displays an iframe" => "Displays an iframe",
// " (experimental - possible successor to img in 4.0)" => " (experimental - possible successor to img in 4.0)",
// "File ID" => "File ID",
// "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in a File Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required" => "Numeric ID of an image in an Image Gallery (or comma-separated list). \"fileId\", \"id\" or \"src\" required",
// "Image Source" => "Image Source",
// "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required" => "Full URL to the image to display. \"fileId\", \"id\" or \"src\" required",
// "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded" => "Maximum height or width in pixels (largest dimension is scaled).\tIf no scalesize is given one will be attempted from default or given height or width.  If scale does not match a defined scale for the gallery the full sized image is downloaded",
// "Alias: lnk. Location the image should point to" => "Alias: lnk. Location the image should point to",
// "Link Relation" => "Link Relation",
// "\"rel\" attribute to add to the link" => "\"rel\" attribute to add to the link",
// "Link title" => "Link title",
// "Title text" => "Title text",
// "Image alt text" => "Image alt text",
// "Alternate text to display if impossible to load the image" => "Alternate text to display if impossible to load the image",
// "Alias:imalign. Image alignment in the page. (left, right)" => "Alias:imalign. Image alignment in the page. (left, right)",
// "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)" => "Whether to block items from flowing next to image from the top or bottom. (top,bottom,both,none)",
// "Image description to display on the page" => "Image description to display on the page",
// "Image Map" => "Image Map",
// "Name of the image map to use for the image" => "Name of the image map to use for the image",
// "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)" => "CSS class to apply to the image'.\"'\".'s img tag. (Usually used in configuration rather than on individual images.)",
// "CSS Style" => "CSS Style",
// "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)" => "CSS styling to apply to the plugin. (Usually used in configuration rather than on individual images.)",
// "Border options" => "Border options",
// "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options" => "Border configuration.  Values \"on\" and \"off\" control visibility, or else specify CSS styling options",
// "Description options" => "Description options",
// "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)" => "Description configuration.\tValues \"on\" and \"off\" control visibility, or else specify CSS styling options. (Usually used in configuration rather than on individual images.)",
// "Default configuration" => "Default configuration",
// "Default configuration definitions. (Usually used in configuration rather than on individual images.)" => "Default configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Mandatory configuration" => "Mandatory configuration",
// "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)" => "Mandatory configuration definitions. (Usually used in configuration rather than on individual images.)",
// "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content" => "Display an image using configured format. Allows presentation of all images to be changed without having to alter existing content",
// "Display an image" => "Display an image",
// "Displays an image" => "Displays an image",
// "Full URL to the image to display" => "Full URL to the image to display",
// "Alternate Text" => "Alternate Text",
// "Height of the image to display" => "Height of the image to display",
// "Width of the image to display" => "Width of the image to display",
// "Link Title" => "Link Title",
// "Image alignment in the page. (left, right, center) Uses HTML IMG tag" => "Image alignment in the page. (left, right, center) Uses HTML IMG tag",
// "Float Alignment" => "Float Alignment",
// "Image alignment in the flow of the document. (left, right, none) Uses CSS float property" => "Image alignment in the flow of the document. (left, right, none) Uses CSS float property",
// "Style to apply to the image" => "Style to apply to the image",
// "Include a page\\'s content" => "Include a page\\'s content",
// "Page Name" => "Page Name",
// "Wiki page name to include" => "Wiki page name to include",
// "When only a portion of the page should be included, specify the marker from which inclusion should start" => "When only a portion of the page should be included, specify the marker from which inclusion should start",
// "When only a portion of the page should be included, specify the marker at which inclusion should end" => "When only a portion of the page should be included, specify the marker at which inclusion should end",
// "Jabber" => "Jabber",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Applet height in pixels" => "Applet height in pixels",
// "'),\n\t\t\t\t'description' => tra('Applet width in pixels" => "'),\n\t\t\t\t'description' => tra('Applet width in pixels",
// "'),\n\t\t\t\t'description' => tra('jabber.org" => "'),\n\t\t\t\t'description' => tra('jabber.org",
// "Default Color" => "Default Color",
// "255,255,255" => "255,255,255",
// "JQuery" => "JQuery",
// "Insert JQuery javascript code. Requires feature_jquery" => "Insert JQuery javascript code. Requires feature_jquery",
// " (experimental - may change in future versions)" => " (experimental - may change in future versions)",
// "JQuery Code" => "JQuery Code",
// "NotOnReady" => "NotOnReady",
// "NoJQuery" => "NoJQuery",
// "Optional markup for when feature_jquery is off" => "Optional markup for when feature_jquery is off",
// "Insert JQuery javascript code" => "Insert JQuery javascript code",
// "jquery code e.g. \$jq(\"img\\" => "jquery code e.g. \$jq(\"img\\",
// "Do not execute on document ready (execute inline)" => "Do not execute on document ready (execute inline)",
// "Javascript" => "Javascript",
// "Insert a javascript file or/and some javascript code" => "Insert a javascript file or/and some javascript code",
// "javascript code" => "javascript code",
// "Javascript filename" => "Javascript filename",
// "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Not Language" => "Not Language",
// "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs" => "List of languages for which the block is not displayed. Languages use the two letter language codes (ex: en, fr, es, ...). Multiple languages can be specified by separating codes by + signs",
// "Page name to display information of. Default value is current page" => "Page name to display information of. Default value is current page",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "Result Offset" => "Result Offset",
// "Result number at which the listing should start" => "Result number at which the listing should start",
// "Result Count" => "Result Count",
// "Amount of results displayed in the list" => "Amount of results displayed in the list",
// "Initial" => "Initial",
// "txt" => "txt",
// "Show Name Only" => "Show Name Only",
// "Structure Head" => "Structure Head",
// "Show Page Alias" => "Show Page Alias",
// "Two letter language code to filter pages listed" => "Two letter language code to filter pages listed",
// "Orphan Language" => "Orphan Language",
// "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed" => "Two letter language code to filter pages listed. Only pages not available in the provided language will be listed",
// "Load Translations" => "Load Translations",
// "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter" => "user or pipe separated list of two letter language codes for additional languages to display. If the language parameter is not defined, the first element of this list will be used as the primary filter",
// "Exact Match" => "Exact Match",
// "Related to Find" => "Related to Find",
// "Only Orphan Pages" => "Only Orphan Pages",
// "For List Pages" => "For List Pages",
// "List Directory" => "List Directory",
// "Full path to the server-local directory" => "Full path to the server-local directory",
// "URL Prefix" => "URL Prefix",
// ".ext" => ".ext",
// "Limit" => "Limit",
// "Maximum amount of files to display" => "Maximum amount of files to display",
// "Displays a map" => "Displays a map",
// "Map File" => "Map File",
// "Extents" => "Extents",
// "Inline Flash mp3 and flv Player" => "Inline Flash mp3 and flv Player",
// "Mediaplayer" => "Mediaplayer",
// "MP3 URL" => "MP3 URL",
// "Complete URL to the mp3 to include" => "Complete URL to the mp3 to include",
// "FLV URL" => "FLV URL",
// "Complete URL to the flv to include" => "Complete URL to the flv to include",
// "One of" => "One of",
// "Mini Quiz" => "Mini Quiz",
// "Displays a miniquiz" => "Displays a miniquiz",
// "Instructions::Feedback" => "Instructions::Feedback",
// "Tracker ID" => "Tracker ID",
// "Insert Module" => "Insert Module",
// "Module name as known in Tikiwiki" => "Module name as known in Tikiwiki",
// "Decoration" => "Decoration",
// "Flip" => "Flip",
// "Max" => "Max",
// "np" => "np",
// "notitle" => "notitle",
// "Displays a module inlined in page. More parameters can be added, not supported by UI" => "Displays a module inlined in page. More parameters can be added, not supported by UI",
// "Monospace" => "Monospace",
// "Font name as known in browsers" => "Font name as known in browsers",
// "Mouse Over" => "Mouse Over",
// "Create a mouseover feature on some text" => "Create a mouseover feature on some text",
// "Mouseover text if param label exists. Page text if text param exists" => "Mouseover text if param label exists. Page text if text param exists",
// "Text displayed on the page. The body is the mouseover content" => "Text displayed on the page. The body is the mouseover content",
// "Destination link when moused-over text is clicked. Use http:// for external links" => "Destination link when moused-over text is clicked. Use http:// for external links",
// "DEPRECATED" => "DEPRECATED",
// "Text displayed on the mouseover. The body contains the text of the page" => "Text displayed on the mouseover. The body contains the text of the page",
// "Mouse over box width. Default: 400px" => "Mouse over box width. Default: 400px",
// "Mouse over box height. Default: 200px" => "Mouse over box height. Default: 200px",
// "Offset X" => "Offset X",
// "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px" => "Shifts the overlay to the right by the specified amount of pixels in relation to the cursor. Default: 5px",
// "Offset Y" => "Offset Y",
// "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px" => "Shifts the overlay to the bottom by the specified amount of pixels in relation to the cursor. Default: 0px",
// "Parse Body" => "Parse Body",
// "y|n, parse the body of the plugin as wiki content. (Default to y)" => "y|n, parse the body of the plugin as wiki content. (Default to y)",
// "Color of the inside popup" => "Color of the inside popup",
// "Default: #F5F5F5" => "Default: #F5F5F5",
// "Text popup color" => "Text popup color",
// "#FFFFFF" => "#FFFFFF",
// "Padding" => "Padding",
// "No label specified" => "No label specified",
// "MWTable" => "MWTable",
// "fancy" => "fancy",
// "true|false" => "true|false",
// "wiki_classes" => "wiki_classes",
// "Displays the data using (sort of) MediaWiki syntax" => "Displays the data using (sort of) MediaWiki syntax",
// "Displays a table using MediaWiki syntax" => "Displays a table using MediaWiki syntax",
// "MySpace" => "MySpace",
// "MySpace Page" => "MySpace Page",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Object Hits" => "Object Hits",
// "Object ID" => "Object ID",
// "Object Type" => "Object Type",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Search for images uploaded by users" => "Search for images uploaded by users",
// " (deprecated - scheduled to be removed or changed significantly)" => " (deprecated - scheduled to be removed or changed significantly)",
// "Filename or full path to file" => "Filename or full path to file",
// "Plugin Manager" => "Plugin Manager",
// "Multiple values separated with | can be used" => "Multiple values separated with | can be used",
// "Poll ID" => "Poll ID",
// "Profile Installer" => "Profile Installer",
// "Adds controls required to install a profile" => "Adds controls required to install a profile",
// "Domain" => "Domain",
// "Profile repository domain. Default value is profiles.tikiwiki.org" => "Profile repository domain. Default value is profiles.tikiwiki.org",
// "Profile Name" => "Profile Name",
// "Name of the profile" => "Name of the profile",
// "Profile plugin only available to administrators" => "Profile plugin only available to administrators",
// "Profile %0/%1 not found" => "Profile %0/%1 not found",
// "Proposal" => "Proposal",
// "Provides a widget for users to vote on a proposal and view the current decision" => "Provides a widget for users to vote on a proposal and view the current decision",
// "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username" => "The list of votes casted. One vote per line. Either 0, +1 or -1 followed by a username",
// "Accept proposal" => "Accept proposal",
// "Still undecided" => "Still undecided",
// "Reject proposal" => "Reject proposal",
// "Displays a proposal acceptance widget" => "Displays a proposal acceptance widget",
// "Short description of the proposal to vote on. Will be displayed above the result table" => "Short description of the proposal to vote on. Will be displayed above the result table",
// "Quote" => "Quote",
// "Quoted text" => "Quoted text",
// "Reply to" => "Reply to",
// "Name of the quoted person" => "Name of the quoted person",
// "Random Dynamic Content" => "Random Dynamic Content",
// "Includes random content from the dynamic content system" => "Includes random content from the dynamic content system",
// "Redirect" => "Redirect",
// "Redirect the user to a wiki page or generic URL" => "Redirect the user to a wiki page or generic URL",
// "Wiki page name to redirect to" => "Wiki page name to redirect to",
// "Complete URL, internal or external" => "Complete URL, internal or external",
// "Redirects you to another wiki page" => "Redirects you to another wiki page",
// "Regular Expression" => "Regular Expression",
// "Takes regex expressions and parses the content between REGEX tags and replaces the text" => "Takes regex expressions and parses the content between REGEX tags and replaces the text",
// "Page name containing the regular expression" => "Page name containing the regular expression",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "Remarks Box" => "Remarks Box",
// "Label displayed above the remark" => "Label displayed above the remark",
// "Highlight" => "Highlight",
// "Icon ID" => "Icon ID",
// "RSS Feed" => "RSS Feed",
// "Inserts an RSS feed output" => "Inserts an RSS feed output",
// "IDs" => "IDs",
// "List of feed IDs separated by colons. ex: feedId:feedId2" => "List of feed IDs separated by colons. ex: feedId:feedId2",
// "Amount of results displayed" => "Amount of results displayed",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect" => "RSS Id incorrect",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "SourceForge" => "SourceForge",
// "aid?" => "aid?",
// "adit?" => "adit?",
// "groupid?" => "groupid?",
// "Insert a ShareThis button from www.sharethis.com" => "Insert a ShareThis button from www.sharethis.com",
// "sharethis" => "sharethis",
// "Display a social networking tool" => "Display a social networking tool",
// "Send services" => "Send services",
// "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services" => "By default, email, aim and sms are available. Input one or two of the services separated by a | to limit the choice of send services",
// "First post services shown" => "First post services shown",
// "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget" => "Input a list of post services (like facebook, myspace, digg, etc.) separated by a | to customize the services that are shown in the opening panel of the widget",
// "Rotate image" => "Rotate image",
// "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping" => "A value of y will cause the button icon to rotate every 3 seconds between a few icons, cycling through twice before stopping",
// "Button text" => "Button text",
// "Custom link text for the button" => "Custom link text for the button",
// "Header title" => "Header title",
// "Optional header title text for the widget" => "Optional header title text for the widget",
// "Header background" => "Header background",
// "HTML color code (not color name) for the background color for the header if an optional header title is used" => "HTML color code (not color name) for the background color for the header if an optional header title is used",
// "Header text color" => "Header text color",
// "HTML color code (not color name) for the header text if an optional header title is used" => "HTML color code (not color name) for the header text if an optional header title is used",
// "Link text color for services" => "Link text color for services",
// "HTML color code (not color name) for the link text for all send and post services shown in the widget" => "HTML color code (not color name) for the link text for all send and post services shown in the widget",
// "A value of true will cause the widget to show in a pop-up window" => "A value of true will cause the widget to show in a pop-up window",
// "Embedded elements" => "Embedded elements",
// "A value of true will allow embedded elements (like flash) to be seen while iframe is loading" => "A value of true will allow embedded elements (like flash) to be seen while iframe is loading",
// "Sheet" => "Sheet",
// "Displays the content of a spreadsheet in the page" => "Displays the content of a spreadsheet in the page",
// "Internal ID of the TikiSheet" => "Internal ID of the TikiSheet",
// "New sheet in page: " => "New sheet in page: ",
// "Incomplete call to plugin: No target sheet" => "Incomplete call to plugin: No target sheet",
// "Create new sheet" => "Create new sheet",
// "Show Pages" => "Show Pages",
// "Search criteria" => "Search criteria",
// "Maximum amount of results displayed" => "Maximum amount of results displayed",
// "name|desc" => "name|desc",
// "Skype" => "Skype",
// "Clickable Skype link" => "Clickable Skype link",
// "Name or number to call or chat with" => "Name or number to call or chat with",
// "Snarf" => "Snarf",
// "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified" => "Include the content of a remote HTTP page. Regular expression selecting the content portion to include must be specified",
// "Full URL to the page to include" => "Full URL to the page to include",
// "PCRE compliant regular expression" => "PCRE compliant regular expression",
// "Regular Expression Part" => "Regular Expression Part",
// "ex: \$1" => "ex: \$1",
// "Data to sort, one entry per line" => "Data to sort, one entry per line",
// "asc|desc|shuffle" => "asc|desc|shuffle",
// "Join Columns" => "Join Columns",
// "Generate the colspan attribute if columns are missing" => "Generate the colspan attribute if columns are missing",
// "Fixed Size" => "Fixed Size",
// "Generate the width attribute on the columns" => "Generate the width attribute on the columns",
// "Column Size" => "Column Size",
// "Editable" => "Editable",
// "Display edit icon for each section" => "Display edit icon for each section",
// "Custom class" => "Custom class",
// "add a class to customize the design" => "add a class to customize the design",
// "SQL" => "SQL",
// "DNS Name" => "DNS Name",
// "ADODB DNS" => "ADODB DNS",
// "Subscript" => "Subscript",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Subscribe Group" => "Subscribe Group",
// "Group Name" => "Group Name",
// "As known in Tikiwiki" => "As known in Tikiwiki",
// "Subscribe Text" => "Subscribe Text",
// "Subscribe text, containing %s as the placeholder for the group name" => "Subscribe text, containing %s as the placeholder for the group name",
// "Unsubscribe Text" => "Unsubscribe Text",
// "Unsubscribe text, containing %s as the placeholder for the group name" => "Unsubscribe text, containing %s as the placeholder for the group name",
// "Subscribe Action" => "Subscribe Action",
// "Subscribe button label, containing %s as the placeholder for the group name" => "Subscribe button label, containing %s as the placeholder for the group name",
// "Unsubscribe Action" => "Unsubscribe Action",
// "Unsubscribe button label, containing %s as the placeholder for the group name" => "Unsubscribe button label, containing %s as the placeholder for the group name",
// "Subscribe Groups" => "Subscribe Groups",
// "Colon separated list of groups" => "Colon separated list of groups",
// "Superscript" => "Superscript",
// "Displays text in superscript (exponent)" => "Displays text in superscript (exponent)",
// "Displays text in superscript" => "Displays text in superscript",
// "Wiki Page to redirect the user after his vote" => "Wiki Page to redirect the user after his vote",
// "Displays a survey" => "Displays a survey",
// "Tag" => "Tag",
// "Displays the text between an html tag" => "Displays the text between an html tag",
// "Tag Name" => "Tag Name",
// "Any valid HTML tag, span by default" => "Any valid HTML tag, span by default",
// "Equivalent of the style attribute on the HTML tag" => "Equivalent of the style attribute on the HTML tag",
// "Displays text between an html tag" => "Displays text between an html tag",
// "File ID from the file gallery" => "File ID from the file gallery",
// "Image ID from the image gallery" => "Image ID from the image gallery",
// "URL to the image" => "URL to the image",
// "Maximum Size" => "Maximum Size",
// "Maximum width or height for the image" => "Maximum width or height for the image",
// "Floating" => "Floating",
// "Link target of the image" => "Link target of the image",
// "File is not an image" => "File is not an image",
// "Server does not support image manipulation" => "Server does not support image manipulation",
// "No image specified" => "No image specified",
// "Title Search" => "Title Search",
// "Search wiki page titles" => "Search wiki page titles",
// "Search Criteria" => "Search Criteria",
// "Portion of a page name" => "Portion of a page name",
// "hits|user" => "hits|user",
// "Exclude" => "Exclude",
// "Pipe separated list of page names to exclude from results" => "Pipe separated list of page names to exclude from results",
// "Table of Contents (Structure)" => "Table of Contents (Structure)",
// "Displays the table of contents for the current structure\\'s subtree as part of the page content" => "Displays the table of contents for the current structure\\'s subtree as part of the page content",
// "Maximum Depth" => "Maximum Depth",
// "Maximum amount of levels to display. On very large structures, this should be limited" => "Maximum amount of levels to display. On very large structures, this should be limited",
// "By default, structure for the current page will be displayed. Alternate structure may be provided" => "By default, structure for the current page will be displayed. Alternate structure may be provided",
// "asc|desc" => "asc|desc",
// "Show Description" => "Show Description",
// "0|1, show the page description instead of the page name" => "0|1, show the page description instead of the page name",
// "Show Numbering" => "Show Numbering",
// "0|1, display the section numbers or not" => "0|1, display the section numbers or not",
// "plain|fancy" => "plain|fancy",
// "Top Friends" => "Top Friends",
// "List top scoring users" => "List top scoring users",
// "Maximum result count" => "Maximum result count",
// "Translate a string using Tikiwiki translation table" => "Translate a string using Tikiwiki translation table",
// "string" => "string",
// "Translate a string" => "Translate a string",
// "Confirmation message after posting form" => "Confirmation message after posting form",
// "Colon-separated list of field IDs to be displayed. Example: 2:4:5" => "Colon-separated list of field IDs to be displayed. Example: 2:4:5",
// "Label on the submit button" => "Label on the submit button",
// "Show Title" => "Show Title",
// "Show Mandatory" => "Show Mandatory",
// "Embedded" => "Embedded",
// "Url used for the field links" => "Url used for the field links",
// "Values" => "Values",
// "Colon-separated list of values" => "Colon-separated list of values",
// "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or " => "Note that plugin arguments can be enclosed with double quotes \"; this allows them to contain , or ",
// "user|page" => "user|page",
// "itemId" => "itemId",
// "itemId if you want to edit an item" => "itemId if you want to edit an item",
// "Template File" => "Template File",
// "Name of the template used to display the tracker items" => "Name of the template used to display the tracker items",
// "Name of the wiki page containing the template to display the tracker items" => "Name of the wiki page containing the template to display the tracker items",
// "New Status" => "New Status",
// "Default status applied to newly created items" => "Default status applied to newly created items",
// "Width of first column " => "Width of first column ",
// "Specify the width in pixels or percentage of the first column in the tracker form" => "Specify the width in pixels or percentage of the first column in the tracker form",
// "Incorrect fieldId" => "Incorrect fieldId",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Filters" => "Filters",
// "Display List" => "Display List",
// "Line" => "Line",
// "Tracker Filter" => "Tracker Filter",
// "notice" => "notice",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Filters the items of a tracker, fields are indicated with numeric ids" => "Filters the items of a tracker, fields are indicated with numeric ids",
// "Wiki text" => "Wiki text",
// "Tracker Item Field" => "Tracker Item Field",
// "Wiki text containing an {ELSE} marker" => "Wiki text containing an {ELSE} marker",
// "Item ID" => "Item ID",
// "Field ID" => "Field ID",
// "Colon separated list of field IDs" => "Colon separated list of field IDs",
// "o|p|c|op|oc|pc|opc" => "o|p|c|op|oc|pc|opc",
// "Test" => "Test",
// "Value to compare against" => "Value to compare against",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)" => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)",
// "Tracker List" => "Tracker List",
// "Notice" => "Notice",
// "Popup" => "Popup",
// "Colon-separated list of fields to display on click. Example: 6:7" => "Colon-separated list of fields to display on click. Example: 6:7",
// "Sticky Popup" => "Sticky Popup",
// "Show Links" => "Show Links",
// "shownbitems" => "shownbitems",
// "Show Initials" => "Show Initials",
// "Show Status" => "Show Status",
// "Show Creation Date" => "Show Creation Date",
// "Show Last Modification" => "Show Last Modification",
// "Show Field Name" => "Show Field Name",
// "Status Filter" => "Status Filter",
// "Which item status to list. o = open, p = pending, c = closed" => "Which item status to list. o = open, p = pending, c = closed",
// "Sort Mode" => "Sort Mode",
// "Filter Field" => "Filter Field",
// "Colon separated list of fields to allow filtering on" => "Colon separated list of fields to allow filtering on",
// "Filter Value" => "Filter Value",
// "Exact Value" => "Exact Value",
// "Checkbox" => "Checkbox",
// "goIfOne" => "goIfOne",
// "More" => "More",
// "More URL" => "More URL",
// "Select automatically the item of the current user or the page" => "Select automatically the item of the current user or the page",
// "View User" => "View User",
// "Item ID separated with " => "Item ID separated with ",
// "List of items Ids" => "List of items Ids",
// "link url" => "link url",
// "Left Deliminator" => "Left Deliminator",
// "Right Deliminator" => "Right Deliminator",
// "If y, value will be truncated" => "If y, value will be truncated",
// "Export Button" => "Export Button",
// "Compute" => "Compute",
// "Sum or average all the values of a field  and displays it at the bottom of the table" => "Sum or average all the values of a field  and displays it at the bottom of the table",
// "fieldId" => "fieldId",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields" => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields",
// "Tracker Prefill" => "Tracker Prefill",
// "Tracker page name" => "Tracker page name",
// "Button label" => "Button label",
// "Field 1" => "Field 1",
// "Value 1" => "Value 1",
// "Content of the field" => "Content of the field",
// "Field 2" => "Field 2",
// "Value 2" => "Value 2",
// "Field 3" => "Field 3",
// "Value 3" => "Value 3",
// "Field 4" => "Field 4",
// "Value 4" => "Value 4",
// "Field 5" => "Field 5",
// "Value 5" => "Value 5",
// "Tracker Stats" => "Tracker Stats",
// "Show Percentage" => "Show Percentage",
// "Show Bar" => "Show Bar",
// "Show link to tiki-view_tracker" => "Show link to tiki-view_tracker",
// "Displays some stat of a tracker content, fields are indicated with numeric ids" => "Displays some stat of a tracker content, fields are indicated with numeric ids",
// "incorrect fieldId" => "incorrect fieldId",
// "Tracker Timeline" => "Tracker Timeline",
// "Timeline view of a tracker, can be used to display event schedules or gantt charts" => "Timeline view of a tracker, can be used to display event schedules or gantt charts",
// "Title Field" => "Title Field",
// "Tracker Field ID containing the item title" => "Tracker Field ID containing the item title",
// "Summary Field" => "Summary Field",
// "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused" => "Tracker Field ID containing the summary of the item. The summary will be displayed on the timeline when the item is focused",
// "Start Date" => "Start Date",
// "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element start date. The field must be a datetime/jscalendar field",
// "End Date" => "End Date",
// "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field" => "Tracker Field ID containing the element end date. The field must be a datetime/jscalendar field",
// "Element Group" => "Element Group",
// "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row" => "Tracker Field ID containing the element\\'s group. Elements of a same group are displayed on the same row",
// "Lower Bound" => "Lower Bound",
// "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date from which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Upper Bound" => "Upper Bound",
// "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format" => "Date until which element should be displayed. Date must be provided in YYYY-MM-DD HH:mm:ss format",
// "Primary Scale Unit" => "Primary Scale Unit",
// "hour, day, week, month or year (default to hour)" => "hour, day, week, month or year (default to hour)",
// "Secondary Scale Unit" => "Secondary Scale Unit",
// "hour, day, week, month, year or empty (default to empty)" => "hour, day, week, month, year or empty (default to empty)",
// "Link Group Name" => "Link Group Name",
// "Convert the group name to a link. (y|n)" => "Convert the group name to a link. (y|n)",
// "Page Link Field" => "Page Link Field",
// "Tracker Field ID containing the page name for item details" => "Tracker Field ID containing the page name for item details",
// "Missing parameter: %0" => "Missing parameter: %0",
// "Start date after end date" => "Start date after end date",
// "Translated" => "Translated",
// "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)" => "[url] or ((wikiname)) or ((inter:interwiki)) (use wiki syntax)",
// "Two letter language code of the language, ex: fr" => "Two letter language code of the language, ex: fr",
// "Country name, ex: France" => "Country name, ex: France",
// "User Count" => "User Count",
// "Group name" => "Group name",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Login Filter" => "Login Filter",
// "String to use between elements of the list" => "String to use between elements of the list",
// "Maximum" => "Maximum",
// "Result limit" => "Result limit",
// "Layout" => "Layout",
// "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default" => "Block of text separated by ---(version x)--- markers. Text before the first marker is used by default",
// "Navigation" => "Navigation",
// "Displays a navigation box that allows users to select a specific version to display" => "Displays a navigation box that allows users to select a specific version to display",
// "Display the current version name as the title. Note: Do not work when nav=>y" => "Display the current version name as the title. Note: Do not work when nav=>y",
// "Default" => "Default",
// "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'" => "Specifies version label to show when displaying the page for the first time. e.g. \\'Default\\'",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Show Stats" => "Show Stats",
// "Show Stats After" => "Show Stats After",
// "Show Creator" => "Show Creator",
// "Wanted Pages" => "Wanted Pages",
// "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)" => "Custom level regex. A custom filter for wanted pages to be listed (only used when level=>custom).\n\t\tpossible values: a valid regex-expression (PCRE)",
// "Ignore" => "Ignore",
// "Split By" => "Split By",
// "Skip Extension" => "Skip Extension",
// "Collect" => "Collect",
// "Level" => "Level",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored" => "A wildcard pattern of originating pages to be ignored",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated" => "The character, by which ignored patterns are separated",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list" => "Whether to include external wikis in the list",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column" => "Collect either originating or wanted pages in a cell and display them in the second column",
// "Switch-on debug output with details about the items" => "Switch-on debug output with details about the items",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex" => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex",
// "A custom filter for wanted pages to be listed (only used when level=>custom)" => "A custom filter for wanted pages to be listed (only used when level=>custom)",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "Lists ''wanted'' wiki pages" => "Lists ''wanted'' wiki pages",
// "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)" => "A wildcard pattern of originating pages to be ignored. (refer to PHP fuction fnmatch() for details)",
// "The character, by which ignored patterns are separated. possible values: characters" => "The character, by which ignored patterns are separated. possible values: characters",
// "Whether to include external wikis in the list. possible values" => "Whether to include external wikis in the list. possible values",
// "Collect either originating or wanted pages in a cell and display them in the second column. possible values" => "Collect either originating or wanted pages in a cell and display them in the second column. possible values",
// "Switch-on debug output with details about the items. possible values" => "Switch-on debug output with details about the items. possible values",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values" => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell. possible values",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output" => "End of debug output",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Web Service" => "Web Service",
// "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface" => "Obtains and display remote information exposed in JSON or YAML. The plugin can be used to display registered or unregistered services. Registered services may use more parameters not defined in this interface",
// "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter" => "Template to apply to the data provided. Template format uses smarty templating engine using double brackets as delimiter. Output must provide wiki syntax. Body can be sent to a parameter instead by using the bodyname parameter",
// "Complete service URL" => "Complete service URL",
// "Service Name" => "Service Name",
// "Registered service name" => "Registered service name",
// "Template Name" => "Template Name",
// "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided" => "For use with registered services, name of the template to be used to display the service output. This parameter will be ignored if a body is provided",
// "Body as Parameter" => "Body as Parameter",
// "Name of the argument to send the body as for services with complex input. Named service required for this to be useful" => "Name of the argument to send the body as for services with complex input. Named service required for this to be useful",
// "Unknown Template" => "Unknown Template",
// "Unknown Service" => "Unknown Service",
// "Missing parameters" => "Missing parameters",
// "Youtube" => "Youtube",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "URL to the Youtube video" => "URL to the Youtube video",
// "quality" => "quality",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Plugin " => "Plugin ",
// "Semantic token already exists" => "Semantic token already exists",
// "Invalid semantic token name" => "Invalid semantic token name",
// "Semantic token not found" => "Semantic token not found",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "Removed last version" => "Removed last version",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "List by month" => "List by month",
// "Please wait.." => "Please wait..",
// "Since your last visit.." => "Since your last visit..",
// "new posts" => "new posts",
// "new tracker items" => "new tracker items",
// "updated tracker items" => "updated tracker items",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can browse the calendar" => "Can browse the calendar",
// "Can view events details" => "Can view events details",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can admin categories" => "Can admin categories",
// "Can edit items in categories" => "Can edit items in categories",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can search on objects of this category" => "Can search on objects of this category",
// "Can admin charts" => "Can admin charts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can suggest items" => "Can suggest items",
// "Can view charts" => "Can view charts",
// "Can vote" => "Can vote",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Can use the chat system" => "Can use the chat system",
// "Can admin the cms" => "Can admin the cms",
// "Can approve submissions" => "Can approve submissions",
// "Can admin article topics" => "Can admin article topics",
// "Can admin article types" => "Can admin article types",
// "Can read article headings" => "Can read article headings",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Can edit articles" => "Can edit articles",
// "Can edit submissions" => "Can edit submissions",
// "Can read articles" => "Can read articles",
// "Can remove articles" => "Can remove articles",
// "Can remove submissions" => "Can remove submissions",
// "Can submit articles" => "Can submit articles",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can admin contributions" => "Can admin contributions",
// "Can admin the directory" => "Can admin the directory",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Submited links are valid" => "Submited links are valid",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can validate submited links" => "Can validate submited links",
// "Can use the directory" => "Can use the directory",
// "Can admin drawings" => "Can admin drawings",
// "Can edit drawings" => "Can edit drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can view faqs" => "Can view faqs",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Can admin users" => "Can admin users",
// "Can access site when closed" => "Can access site when closed",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Can ban users or ips" => "Can ban users or ips",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can edit object permissions" => "Can edit object permissions",
// "Can admin rss modules" => "Can admin rss modules",
// "Can clean cache" => "Can clean cache",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can admin cookies" => "Can admin cookies",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit site templates" => "Can edit site templates",
// "Can search" => "Can search",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view referer stats" => "Can view referer stats",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can admin blogs" => "Can admin blogs",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can post to a blog" => "Can post to a blog",
// "Can create a blog" => "Can create a blog",
// "Can read blogs" => "Can read blogs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can create file galleries" => "Can create file galleries",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can list file galleries" => "Can list file galleries",
// "Can upload files" => "Can upload files",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view file galleries" => "Can view file galleries",
// "Can admin forums" => "Can admin forums",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can post in forums" => "Can post in forums",
// "Can start threads in forums" => "Can start threads in forums",
// "Can read forums" => "Can read forums",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can create image galleries" => "Can create image galleries",
// "Can tag objects" => "Can tag objects",
// "Can list image galleries" => "Can list image galleries",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload images" => "Can upload images",
// "Can browse freetags" => "Can browse freetags",
// "Can view image galleries" => "Can view image galleries",
// "Can admin games" => "Can admin games",
// "Can play games" => "Can play games",
// "Can admin newsletters" => "Can admin newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can send newsletters" => "Can send newsletters",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can admin polls" => "Can admin polls",
// "Can view poll results" => "Can view poll results",
// "Can vote polls" => "Can vote polls",
// "Can view poll voters" => "Can view poll voters",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can take quizzes" => "Can take quizzes",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view user quiz results" => "Can view user quiz results",
// "Can admin sheet" => "Can admin sheet",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can view shoutbox" => "Can view shoutbox",
// "Can admin surveys" => "Can admin surveys",
// "Can take surveys" => "Can take surveys",
// "Can view survey stats" => "Can view survey stats",
// "Can admin trackers" => "Can admin trackers",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can view tracker items comments" => "Can view tracker items comments",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can list trackers" => "Can list trackers",
// "Can change tracker items" => "Can change tracker items",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can watch tracker" => "Can watch tracker",
// "Can export tracker items" => "Can export tracker items",
// "Can admin the wiki" => "Can admin the wiki",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can edit pages" => "Can edit pages",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can create and edit structures" => "Can create and edit structures",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can lock pages" => "Can lock pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can remove" => "Can remove",
// "Can rename pages" => "Can rename pages",
// "Can rollback pages" => "Can rollback pages",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can view page/pages" => "Can view page/pages",
// "Can watch structure" => "Can watch structure",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can view similar wiki pages" => "Can view similar wiki pages",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can abort a process instance" => "Can abort a process instance",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can send instances after completion" => "Can send instances after completion",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can configure modules" => "Can configure modules",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can admin public tasks" => "Can admin public tasks",
// "Can use tasks" => "Can use tasks",
// "Can receive tasks from other users" => "Can receive tasks from other users",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can upload personal files" => "Can upload personal files",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can use the messaging system" => "Can use the messaging system",
// "Can admin comments" => "Can admin comments",
// "Can edit all comments" => "Can edit all comments",
// "Can post new comments" => "Can post new comments",
// "Can read comments" => "Can read comments",
// "Can delete comments" => "Can delete comments",
// "Can vote comments" => "Can vote comments",
// "Can admin content templates" => "Can admin content templates",
// "Can edit content templates" => "Can edit content templates",
// "Can use content templates" => "Can use content templates",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can view HTML pages" => "Can view HTML pages",
// "Can list registered users" => "Can list registered users",
// "Admin live support system" => "Admin live support system",
// "Can use live support system" => "Can use live support system",
// "Can create new mapfile" => "Can create new mapfile",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can use webmail" => "Can use webmail",
// "Can use group webmail" => "Can use group webmail",
// "Can administrate group webmail accounts" => "Can administrate group webmail accounts",
// "Can use personal webmail accounts" => "Can use personal webmail accounts",
// "Can administrate personal webmail accounts" => "Can administrate personal webmail accounts",
// "Can view unapproved plugin details" => "Can view unapproved plugin details",
// "Can execute unapproved plugin" => "Can execute unapproved plugin",
// "Can approve plugin execution" => "Can approve plugin execution",
// "Trust all user inputs (no security checks)" => "Trust all user inputs (no security checks)",
// "View page backlinks" => "View page backlinks",
// "Can admin mail notifications" => "Can admin mail notifications",
// "tiki release" => "tiki release",
// "feature version checks" => "feature version checks",
// "tiki needs upgrade" => "tiki needs upgrade",
// "tiki version last check" => "tiki version last check",
// "tiki version check frequency" => "tiki version check frequency",
// "lastUpdatePrefs" => "lastUpdatePrefs",
// "feature print indexed" => "feature print indexed",
// "feature wiki" => "feature wiki",
// "default wiki diff style" => "default wiki diff style",
// "feature backlinks" => "feature backlinks",
// "feature dump" => "feature dump",
// "feature history" => "feature history",
// "feature lastChanges" => "feature lastChanges",
// "feature likePages" => "feature likePages",
// "feature listPages" => "feature listPages",
// "feature listorphanPages" => "feature listorphanPages",
// "feature page title" => "feature page title",
// "feature sandbox" => "feature sandbox",
// "feature warn on edit" => "feature warn on edit",
// "feature wiki 1like redirection" => "feature wiki 1like redirection",
// "feature wiki allowhtml" => "feature wiki allowhtml",
// "feature wiki argvariable" => "feature wiki argvariable",
// "feature wiki attachments" => "feature wiki attachments",
// "feature wiki comments" => "feature wiki comments",
// "feature wiki description" => "feature wiki description",
// "feature wiki discuss" => "feature wiki discuss",
// "feature wiki export" => "feature wiki export",
// "feature wiki structure" => "feature wiki structure",
// "feature wiki import page" => "feature wiki import page",
// "feature wiki footnotes" => "feature wiki footnotes",
// "feature wiki icache" => "feature wiki icache",
// "feature wiki import html" => "feature wiki import html",
// "feature wiki mindmap" => "feature wiki mindmap",
// "feature wiki monosp" => "feature wiki monosp",
// "feature wiki multiprint" => "feature wiki multiprint",
// "feature wiki notepad" => "feature wiki notepad",
// "feature wiki make structure" => "feature wiki make structure",
// "feature wiki open as structure" => "feature wiki open as structure",
// "feature wiki pageid" => "feature wiki pageid",
// "feature wiki paragraph formatting" => "feature wiki paragraph formatting",
// "feature wiki paragraph formatting add br" => "feature wiki paragraph formatting add br",
// "feature wiki pictures" => "feature wiki pictures",
// "feature wiki plurals" => "feature wiki plurals",
// "feature wiki print" => "feature wiki print",
// "feature wiki protect email" => "feature wiki protect email",
// "feature wiki rankings" => "feature wiki rankings",
// "feature wiki ratings" => "feature wiki ratings",
// "feature wiki replace" => "feature wiki replace",
// "feature wiki show hide before" => "feature wiki show hide before",
// "feature wiki tables" => "feature wiki tables",
// "feature wiki templates" => "feature wiki templates",
// "feature wiki undo" => "feature wiki undo",
// "feature wiki userpage" => "feature wiki userpage",
// "feature wiki userpage prefix" => "feature wiki userpage prefix",
// "feature wiki usrlock" => "feature wiki usrlock",
// "feature wiki feedback polls" => "feature wiki feedback polls",
// "feature wiki save draft" => "feature wiki save draft",
// "feature wikiwords" => "feature wikiwords",
// "feature wikiwords usedash" => "feature wikiwords usedash",
// "feature wiki pagealias" => "feature wiki pagealias",
// "mailin autocheck" => "mailin autocheck",
// "mailin autocheckFreq" => "mailin autocheckFreq",
// "mailin autocheckLast" => "mailin autocheckLast",
// "page bar position" => "page bar position",
// "warn on edit time" => "warn on edit time",
// "wikiHomePage" => "wikiHomePage",
// "wikiLicensePage" => "wikiLicensePage",
// "wikiSubmitNotice" => "wikiSubmitNotice",
// "wiki authors style" => "wiki authors style",
// "wiki authors style by page" => "wiki authors style by page",
// "wiki show version" => "wiki show version",
// "wiki bot bar" => "wiki bot bar",
// "wiki cache" => "wiki cache",
// "wiki comments default ordering" => "wiki comments default ordering",
// "wiki comments displayed default" => "wiki comments displayed default",
// "wiki comments per page" => "wiki comments per page",
// "wiki creator admin" => "wiki creator admin",
// "wiki feature copyrights" => "wiki feature copyrights",
// "wiki forum id" => "wiki forum id",
// "wiki left column" => "wiki left column",
// "wiki list backlinks" => "wiki list backlinks",
// "wiki list comment" => "wiki list comment",
// "wiki list comment len" => "wiki list comment len",
// "wiki list description" => "wiki list description",
// "wiki list description len" => "wiki list description len",
// "wiki list creator" => "wiki list creator",
// "wiki list hits" => "wiki list hits",
// "wiki list lastmodif" => "wiki list lastmodif",
// "wiki list lastver" => "wiki list lastver",
// "wiki list links" => "wiki list links",
// "wiki list name" => "wiki list name",
// "wiki list name len" => "wiki list name len",
// "wiki list size" => "wiki list size",
// "wiki list status" => "wiki list status",
// "wiki list user" => "wiki list user",
// "wiki list versions" => "wiki list versions",
// "wiki list language" => "wiki list language",
// "wiki list categories" => "wiki list categories",
// "wiki list categories path" => "wiki list categories path",
// "wiki list id" => "wiki list id",
// "wiki list sortorder" => "wiki list sortorder",
// "wiki list sortdirection" => "wiki list sortdirection",
// "wiki pagealias tokens" => "wiki pagealias tokens",
// "wiki page regex" => "wiki page regex",
// "wiki page separator" => "wiki page separator",
// "wiki page navigation bar" => "wiki page navigation bar",
// "wiki actions bar" => "wiki actions bar",
// "wiki pagename strip" => "wiki pagename strip",
// "wiki right column" => "wiki right column",
// "wiki top bar" => "wiki top bar",
// "wiki topline position" => "wiki topline position",
// "wiki uses slides" => "wiki uses slides",
// "wiki watch author" => "wiki watch author",
// "wiki watch comments" => "wiki watch comments",
// "wiki watch editor" => "wiki watch editor",
// "wiki watch minor" => "wiki watch minor",
// "feature wiki history full" => "feature wiki history full",
// "feature wiki categorize structure" => "feature wiki categorize structure",
// "feature wiki watch structure" => "feature wiki watch structure",
// "feature wikiapproval" => "feature wikiapproval",
// "wikiapproval prefix" => "wikiapproval prefix",
// "wikiapproval hideprefix" => "wikiapproval hideprefix",
// "wikiapproval delete staging" => "wikiapproval delete staging",
// "wikiapproval master group" => "wikiapproval master group",
// "wikiapproval staging category" => "wikiapproval staging category",
// "wikiapproval approved category" => "wikiapproval approved category",
// "wikiapproval outofsync category" => "wikiapproval outofsync category",
// "wikiapproval block editapproved" => "wikiapproval block editapproved",
// "wikiapproval sync categories" => "wikiapproval sync categories",
// "wikiapproval update freetags" => "wikiapproval update freetags",
// "wikiapproval combine freetags" => "wikiapproval combine freetags",
// "wiki edit section" => "wiki edit section",
// "wiki edit section level" => "wiki edit section level",
// "wiki edit plugin" => "wiki edit plugin",
// "wiki validate plugin" => "wiki validate plugin",
// "wiki edit minor" => "wiki edit minor",
// "wikiplugin agentinfo" => "wikiplugin agentinfo",
// "wikiplugin alink" => "wikiplugin alink",
// "wikiplugin aname" => "wikiplugin aname",
// "wikiplugin annotation" => "wikiplugin annotation",
// "wikiplugin article" => "wikiplugin article",
// "wikiplugin articles" => "wikiplugin articles",
// "wikiplugin attach" => "wikiplugin attach",
// "wikiplugin avatar" => "wikiplugin avatar",
// "wikiplugin back" => "wikiplugin back",
// "wikiplugin backlinks" => "wikiplugin backlinks",
// "wikiplugin banner" => "wikiplugin banner",
// "wikiplugin bloglist" => "wikiplugin bloglist",
// "wikiplugin box" => "wikiplugin box",
// "wikiplugin category" => "wikiplugin category",
// "wikiplugin catorphans" => "wikiplugin catorphans",
// "wikiplugin catpath" => "wikiplugin catpath",
// "wikiplugin center" => "wikiplugin center",
// "wikiplugin chart" => "wikiplugin chart",
// "wikiplugin code" => "wikiplugin code",
// "wikiplugin content" => "wikiplugin content",
// "wikiplugin cookie" => "wikiplugin cookie",
// "wikiplugin copyright" => "wikiplugin copyright",
// "wikiplugin countdown" => "wikiplugin countdown",
// "wikiplugin dbreport" => "wikiplugin dbreport",
// "wikiplugin div" => "wikiplugin div",
// "wikiplugin dl" => "wikiplugin dl",
// "wikiplugin draw" => "wikiplugin draw",
// "wikiplugin equation" => "wikiplugin equation",
// "wikiplugin events" => "wikiplugin events",
// "wikiplugin fade" => "wikiplugin fade",
// "wikiplugin fancylist" => "wikiplugin fancylist",
// "wikiplugin fancytable" => "wikiplugin fancytable",
// "wikiplugin file" => "wikiplugin file",
// "wikiplugin files" => "wikiplugin files",
// "wikiplugin flash" => "wikiplugin flash",
// "wikiplugin footnote" => "wikiplugin footnote",
// "wikiplugin footnotearea" => "wikiplugin footnotearea",
// "wikiplugin ftp" => "wikiplugin ftp",
// "wikiplugin gauge" => "wikiplugin gauge",
// "wikiplugin googleanalytics" => "wikiplugin googleanalytics",
// "wikiplugin googledoc" => "wikiplugin googledoc",
// "wikiplugin group" => "wikiplugin group",
// "wikiplugin html" => "wikiplugin html",
// "wikiplugin iframe" => "wikiplugin iframe",
// "wikiplugin img" => "wikiplugin img",
// "wikiplugin image" => "wikiplugin image",
// "wikiplugin include" => "wikiplugin include",
// "wikiplugin jabber" => "wikiplugin jabber",
// "wikiplugin js" => "wikiplugin js",
// "wikiplugin jq" => "wikiplugin jq",
// "wikiplugin lang" => "wikiplugin lang",
// "wikiplugin lastmod" => "wikiplugin lastmod",
// "wikiplugin listpages" => "wikiplugin listpages",
// "wikiplugin lsdir" => "wikiplugin lsdir",
// "wikiplugin map" => "wikiplugin map",
// "wikiplugin mediaplayer" => "wikiplugin mediaplayer",
// "wikiplugin miniquiz" => "wikiplugin miniquiz",
// "wikiplugin module" => "wikiplugin module",
// "wikiplugin mono" => "wikiplugin mono",
// "wikiplugin mouseover" => "wikiplugin mouseover",
// "wikiplugin mwtable" => "wikiplugin mwtable",
// "wikiplugin myspace" => "wikiplugin myspace",
// "wikiplugin objecthits" => "wikiplugin objecthits",
// "wikiplugin picture" => "wikiplugin picture",
// "wikiplugin pluginmanager" => "wikiplugin pluginmanager",
// "wikiplugin poll" => "wikiplugin poll",
// "wikiplugin profile" => "wikiplugin profile",
// "wikiplugin proposal" => "wikiplugin proposal",
// "wikiplugin quote" => "wikiplugin quote",
// "wikiplugin rcontent" => "wikiplugin rcontent",
// "wikiplugin redirect" => "wikiplugin redirect",
// "wikiplugin regex" => "wikiplugin regex",
// "wikiplugin remarksbox" => "wikiplugin remarksbox",
// "wikiplugin rss" => "wikiplugin rss",
// "wikiplugin sf" => "wikiplugin sf",
// "wikiplugin share" => "wikiplugin share",
// "wikiplugin sharethis" => "wikiplugin sharethis",
// "wikiplugin sheet" => "wikiplugin sheet",
// "wikiplugin showpages" => "wikiplugin showpages",
// "wikiplugin skype" => "wikiplugin skype",
// "wikiplugin snarf" => "wikiplugin snarf",
// "wikiplugin sort" => "wikiplugin sort",
// "wikiplugin split" => "wikiplugin split",
// "wikiplugin sql" => "wikiplugin sql",
// "wikiplugin sub" => "wikiplugin sub",
// "wikiplugin subscribegroup" => "wikiplugin subscribegroup",
// "wikiplugin subscribegroups" => "wikiplugin subscribegroups",
// "wikiplugin sup" => "wikiplugin sup",
// "wikiplugin survey" => "wikiplugin survey",
// "wikiplugin tag" => "wikiplugin tag",
// "wikiplugin thumb" => "wikiplugin thumb",
// "wikiplugin titlesearch" => "wikiplugin titlesearch",
// "wikiplugin toc" => "wikiplugin toc",
// "wikiplugin topfriends" => "wikiplugin topfriends",
// "wikiplugin trackerfilter" => "wikiplugin trackerfilter",
// "wikiplugin trackeritemfield" => "wikiplugin trackeritemfield",
// "wikiplugin trackerlist" => "wikiplugin trackerlist",
// "wikiplugin trackertimeline" => "wikiplugin trackertimeline",
// "wikiplugin tracker" => "wikiplugin tracker",
// "wikiplugin trackerprefill" => "wikiplugin trackerprefill",
// "wikiplugin trackerstat" => "wikiplugin trackerstat",
// "wikiplugin translated" => "wikiplugin translated",
// "wikiplugin tr" => "wikiplugin tr",
// "wikiplugin usercount" => "wikiplugin usercount",
// "wikiplugin userlist" => "wikiplugin userlist",
// "wikiplugin versions" => "wikiplugin versions",
// "wikiplugin vote" => "wikiplugin vote",
// "wikiplugin wantedpages" => "wikiplugin wantedpages",
// "wikiplugin webservice" => "wikiplugin webservice",
// "wikiplugin youtube" => "wikiplugin youtube",
// "wikiplugininline agentinfo" => "wikiplugininline agentinfo",
// "wikiplugininline alink" => "wikiplugininline alink",
// "wikiplugininline aname" => "wikiplugininline aname",
// "wikiplugininline annotation" => "wikiplugininline annotation",
// "wikiplugininline article" => "wikiplugininline article",
// "wikiplugininline articles" => "wikiplugininline articles",
// "wikiplugininline attach" => "wikiplugininline attach",
// "wikiplugininline avatar" => "wikiplugininline avatar",
// "wikiplugininline back" => "wikiplugininline back",
// "wikiplugininline backlinks" => "wikiplugininline backlinks",
// "wikiplugininline banner" => "wikiplugininline banner",
// "wikiplugininline bloglist" => "wikiplugininline bloglist",
// "wikiplugininline box" => "wikiplugininline box",
// "wikiplugininline category" => "wikiplugininline category",
// "wikiplugininline catorphans" => "wikiplugininline catorphans",
// "wikiplugininline catpath" => "wikiplugininline catpath",
// "wikiplugininline center" => "wikiplugininline center",
// "wikiplugininline chart" => "wikiplugininline chart",
// "wikiplugininline code" => "wikiplugininline code",
// "wikiplugininline content" => "wikiplugininline content",
// "wikiplugininline cookie" => "wikiplugininline cookie",
// "wikiplugininline copyright" => "wikiplugininline copyright",
// "wikiplugininline countdown" => "wikiplugininline countdown",
// "wikiplugininline dbreport" => "wikiplugininline dbreport",
// "wikiplugininline div" => "wikiplugininline div",
// "wikiplugininline dl" => "wikiplugininline dl",
// "wikiplugininline draw" => "wikiplugininline draw",
// "wikiplugininline equation" => "wikiplugininline equation",
// "wikiplugininline events" => "wikiplugininline events",
// "wikiplugininline fade" => "wikiplugininline fade",
// "wikiplugininline fancylist" => "wikiplugininline fancylist",
// "wikiplugininline fancytable" => "wikiplugininline fancytable",
// "wikiplugininline file" => "wikiplugininline file",
// "wikiplugininline files" => "wikiplugininline files",
// "wikiplugininline flash" => "wikiplugininline flash",
// "wikiplugininline footnote" => "wikiplugininline footnote",
// "wikiplugininline footnotearea" => "wikiplugininline footnotearea",
// "wikiplugininline ftp" => "wikiplugininline ftp",
// "wikiplugininline gauge" => "wikiplugininline gauge",
// "wikiplugininline googleanalytics" => "wikiplugininline googleanalytics",
// "wikiplugininline googledoc" => "wikiplugininline googledoc",
// "wikiplugininline group" => "wikiplugininline group",
// "wikiplugininline html" => "wikiplugininline html",
// "wikiplugininline iframe" => "wikiplugininline iframe",
// "wikiplugininline img" => "wikiplugininline img",
// "wikiplugininline image" => "wikiplugininline image",
// "wikiplugininline include" => "wikiplugininline include",
// "wikiplugininline jabber" => "wikiplugininline jabber",
// "wikiplugininline js" => "wikiplugininline js",
// "wikiplugininline jq" => "wikiplugininline jq",
// "wikiplugininline lang" => "wikiplugininline lang",
// "wikiplugininline lastmod" => "wikiplugininline lastmod",
// "wikiplugininline listpages" => "wikiplugininline listpages",
// "wikiplugininline lsdir" => "wikiplugininline lsdir",
// "wikiplugininline map" => "wikiplugininline map",
// "wikiplugininline mediaplayer" => "wikiplugininline mediaplayer",
// "wikiplugininline miniquiz" => "wikiplugininline miniquiz",
// "wikiplugininline module" => "wikiplugininline module",
// "wikiplugininline mono" => "wikiplugininline mono",
// "wikiplugininline mouseover" => "wikiplugininline mouseover",
// "wikiplugininline mwtable" => "wikiplugininline mwtable",
// "wikiplugininline myspace" => "wikiplugininline myspace",
// "wikiplugininline objecthits" => "wikiplugininline objecthits",
// "wikiplugininline picture" => "wikiplugininline picture",
// "wikiplugininline pluginmanager" => "wikiplugininline pluginmanager",
// "wikiplugininline poll" => "wikiplugininline poll",
// "wikiplugininline profile" => "wikiplugininline profile",
// "wikiplugininline proposal" => "wikiplugininline proposal",
// "wikiplugininline quote" => "wikiplugininline quote",
// "wikiplugininline rcontent" => "wikiplugininline rcontent",
// "wikiplugininline redirect" => "wikiplugininline redirect",
// "wikiplugininline regex" => "wikiplugininline regex",
// "wikiplugininline remarksbox" => "wikiplugininline remarksbox",
// "wikiplugininline rss" => "wikiplugininline rss",
// "wikiplugininline sf" => "wikiplugininline sf",
// "wikiplugininline share" => "wikiplugininline share",
// "wikiplugininline sharethis" => "wikiplugininline sharethis",
// "wikiplugininline sheet" => "wikiplugininline sheet",
// "wikiplugininline showpages" => "wikiplugininline showpages",
// "wikiplugininline skype" => "wikiplugininline skype",
// "wikiplugininline snarf" => "wikiplugininline snarf",
// "wikiplugininline sort" => "wikiplugininline sort",
// "wikiplugininline split" => "wikiplugininline split",
// "wikiplugininline sql" => "wikiplugininline sql",
// "wikiplugininline sub" => "wikiplugininline sub",
// "wikiplugininline subscribegroup" => "wikiplugininline subscribegroup",
// "wikiplugininline subscribegroups" => "wikiplugininline subscribegroups",
// "wikiplugininline sup" => "wikiplugininline sup",
// "wikiplugininline survey" => "wikiplugininline survey",
// "wikiplugininline tag" => "wikiplugininline tag",
// "wikiplugininline thumb" => "wikiplugininline thumb",
// "wikiplugininline titlesearch" => "wikiplugininline titlesearch",
// "wikiplugininline toc" => "wikiplugininline toc",
// "wikiplugininline topfriends" => "wikiplugininline topfriends",
// "wikiplugininline trackerfilter" => "wikiplugininline trackerfilter",
// "wikiplugininline trackeritemfield" => "wikiplugininline trackeritemfield",
// "wikiplugininline trackerlist" => "wikiplugininline trackerlist",
// "wikiplugininline trackertimeline" => "wikiplugininline trackertimeline",
// "wikiplugininline tracker" => "wikiplugininline tracker",
// "wikiplugininline trackerprefill" => "wikiplugininline trackerprefill",
// "wikiplugininline trackerstat" => "wikiplugininline trackerstat",
// "wikiplugininline translated" => "wikiplugininline translated",
// "wikiplugininline tr" => "wikiplugininline tr",
// "wikiplugininline usercount" => "wikiplugininline usercount",
// "wikiplugininline userlist" => "wikiplugininline userlist",
// "wikiplugininline versions" => "wikiplugininline versions",
// "wikiplugininline vote" => "wikiplugininline vote",
// "wikiplugininline wantedpages" => "wikiplugininline wantedpages",
// "wikiplugininline webservice" => "wikiplugininline webservice",
// "wikiplugininline youtube" => "wikiplugininline youtube",
// "webservice consume defaultcache" => "webservice consume defaultcache",
// "feature wysiwyg" => "feature wysiwyg",
// "wysiwyg optional" => "wysiwyg optional",
// "wysiwyg default" => "wysiwyg default",
// "wysiwyg memo" => "wysiwyg memo",
// "wysiwyg wiki parsed" => "wysiwyg wiki parsed",
// "wysiwyg wiki semi parsed" => "wysiwyg wiki semi parsed",
// "wysiwyg toolbar skin" => "wysiwyg toolbar skin",
// "wysiwyg toolbar" => "wysiwyg toolbar",
// "wiki feature 3d" => "wiki feature 3d",
// "wiki 3d width" => "wiki 3d width",
// "wiki 3d height" => "wiki 3d height",
// "wiki 3d navigation depth" => "wiki 3d navigation depth",
// "wiki 3d feed animation interval" => "wiki 3d feed animation interval",
// "wiki 3d existing page color" => "wiki 3d existing page color",
// "wiki 3d missing page color" => "wiki 3d missing page color",
// "feature blogs" => "feature blogs",
// "blog list order" => "blog list order",
// "home blog" => "home blog",
// "feature blog rankings" => "feature blog rankings",
// "feature blog comments" => "feature blog comments",
// "blog comments default ordering" => "blog comments default ordering",
// "blog comments per page" => "blog comments per page",
// "feature blogposts comments" => "feature blogposts comments",
// "blog list user" => "blog list user",
// "blog list title" => "blog list title",
// "blog list title len" => "blog list title len",
// "blog list description" => "blog list description",
// "blog list created" => "blog list created",
// "blog list lastmodif" => "blog list lastmodif",
// "blog list posts" => "blog list posts",
// "blog list visits" => "blog list visits",
// "blog list activity" => "blog list activity",
// "feature blog mandatory category" => "feature blog mandatory category",
// "feature blog heading" => "feature blog heading",
// "feature file galleries" => "feature file galleries",
// "home file gallery" => "home file gallery",
// "fgal use db" => "fgal use db",
// "fgal batch dir" => "fgal batch dir",
// "fgal match regex" => "fgal match regex",
// "fgal nmatch regex" => "fgal nmatch regex",
// "fgal use dir" => "fgal use dir",
// "fgal podcast dir" => "fgal podcast dir",
// "feature file galleries comments" => "feature file galleries comments",
// "file galleries comments default ordering" => "file galleries comments default ordering",
// "file galleries comments per page" => "file galleries comments per page",
// "feature file galleries batch" => "feature file galleries batch",
// "feature file galleries rankings" => "feature file galleries rankings",
// "fgal enable auto indexing" => "fgal enable auto indexing",
// "fgal asynchronous indexing" => "fgal asynchronous indexing",
// "fgal allow duplicates" => "fgal allow duplicates",
// "fgal sort mode" => "fgal sort mode",
// "feature file galleries author" => "feature file galleries author",
// "fgal list id" => "fgal list id",
// "fgal list type" => "fgal list type",
// "fgal list name" => "fgal list name",
// "fgal list description" => "fgal list description",
// "fgal list size" => "fgal list size",
// "fgal list created" => "fgal list created",
// "fgal list lastmodif" => "fgal list lastmodif",
// "fgal list creator" => "fgal list creator",
// "fgal list author" => "fgal list author",
// "fgal list last user" => "fgal list last user",
// "fgal list comment" => "fgal list comment",
// "fgal list files" => "fgal list files",
// "fgal list hits" => "fgal list hits",
// "fgal list lockedby" => "fgal list lockedby",
// "fgal show path" => "fgal show path",
// "fgal show explorer" => "fgal show explorer",
// "fgal show slideshow" => "fgal show slideshow",
// "fgal default view" => "fgal default view",
// "fgal limit hits per file" => "fgal limit hits per file",
// "fgal prevent negative score" => "fgal prevent negative score",
// "feature galleries" => "feature galleries",
// "feature gal batch" => "feature gal batch",
// "feature gal slideshow" => "feature gal slideshow",
// "home gallery" => "home gallery",
// "gal use db" => "gal use db",
// "gal use lib" => "gal use lib",
// "gal match regex" => "gal match regex",
// "gal nmatch regex" => "gal nmatch regex",
// "gal use dir" => "gal use dir",
// "gal batch dir" => "gal batch dir",
// "feature gal rankings" => "feature gal rankings",
// "feature image galleries comments" => "feature image galleries comments",
// "image galleries comments default order" => "image galleries comments default order",
// "image galleries comments per page" => "image galleries comments per page",
// "gal list name" => "gal list name",
// "gal list parent" => "gal list parent",
// "gal list description" => "gal list description",
// "gal list created" => "gal list created",
// "gal list lastmodif" => "gal list lastmodif",
// "gal list user" => "gal list user",
// "gal list imgs" => "gal list imgs",
// "gal list visits" => "gal list visits",
// "feature image gallery mandatory category" => "feature image gallery mandatory category",
// "preset galleries info" => "preset galleries info",
// "gal image mouseover" => "gal image mouseover",
// "ProgressBarPlay" => "ProgressBarPlay",
// "ProgressBarLoad" => "ProgressBarLoad",
// "ProgressBarButton" => "ProgressBarButton",
// "ProgressBar" => "ProgressBar",
// "VolumeOn" => "VolumeOn",
// "VolumeOff" => "VolumeOff",
// "VolumeButton" => "VolumeButton",
// "Button" => "Button",
// "ButtonPressed" => "ButtonPressed",
// "ButtonOver" => "ButtonOver",
// "ButtonInfo" => "ButtonInfo",
// "ButtonInfoPressed" => "ButtonInfoPressed",
// "ButtonInfoOver" => "ButtonInfoOver",
// "ButtonInfoText" => "ButtonInfoText",
// "ID3" => "ID3",
// "PlayTime" => "PlayTime",
// "TotalTime" => "TotalTime",
// "PanelDisplay" => "PanelDisplay",
// "AlertMesg" => "AlertMesg",
// "PreloadDelay" => "PreloadDelay",
// "VideoHeight" => "VideoHeight",
// "VideoLength" => "VideoLength",
// "URLAppend" => "URLAppend",
// "LimitedMsg" => "LimitedMsg",
// "MaxPlay" => "MaxPlay",
// "MultimediaGalerie" => "MultimediaGalerie",
// "MultimediaDefaultLength" => "MultimediaDefaultLength",
// "MultimediaDefaultHeight" => "MultimediaDefaultHeight",
// "feature forums" => "feature forums",
// "home forum" => "home forum",
// "feature forum rankings" => "feature forum rankings",
// "feature forum parse" => "feature forum parse",
// "feature forum topics archiving" => "feature forum topics archiving",
// "feature forum replyempty" => "feature forum replyempty",
// "feature forum quickjump" => "feature forum quickjump",
// "feature forums allow thread titles" => "feature forums allow thread titles",
// "feature forum content search" => "feature forum content search",
// "feature forums name search" => "feature forums name search",
// "forums ordering" => "forums ordering",
// "forum list topics" => "forum list topics",
// "forum list posts" => "forum list posts",
// "forum list ppd" => "forum list ppd",
// "forum list lastpost" => "forum list lastpost",
// "forum list visits" => "forum list visits",
// "forum list desc" => "forum list desc",
// "forum list description len" => "forum list description len",
// "feature forum local search" => "feature forum local search",
// "feature forum local tiki search" => "feature forum local tiki search",
// "forum thread defaults by forum" => "forum thread defaults by forum",
// "forum thread user settings" => "forum thread user settings",
// "forum thread user settings keep" => "forum thread user settings keep",
// "forum comments per page" => "forum comments per page",
// "forum comments no title prefix" => "forum comments no title prefix",
// "forum thread style" => "forum thread style",
// "forum thread sort mode" => "forum thread sort mode",
// "forum match regex" => "forum match regex",
// "feature articles" => "feature articles",
// "feature submissions" => "feature submissions",
// "feature cms rankings" => "feature cms rankings",
// "feature cms print" => "feature cms print",
// "feature cms emails" => "feature cms emails",
// "art list title" => "art list title",
// "art list title len" => "art list title len",
// "art list topic" => "art list topic",
// "art list date" => "art list date",
// "art list author" => "art list author",
// "art list reads" => "art list reads",
// "art list size" => "art list size",
// "art list expire" => "art list expire",
// "art list img" => "art list img",
// "art list type" => "art list type",
// "art list visible" => "art list visible",
// "art view type" => "art view type",
// "art view title" => "art view title",
// "art view topic" => "art view topic",
// "art view date" => "art view date",
// "art view author" => "art view author",
// "art view reads" => "art view reads",
// "art view size" => "art view size",
// "art view img" => "art view img",
// "art list lang" => "art list lang",
// "feature article comments" => "feature article comments",
// "article comments default ordering" => "article comments default ordering",
// "article comments per page" => "article comments per page",
// "article image size x" => "article image size x",
// "article image size y" => "article image size y",
// "feature cms templates" => "feature cms templates",
// "cms bot bar" => "cms bot bar",
// "cms left column" => "cms left column",
// "cms right column" => "cms right column",
// "cms top bar" => "cms top bar",
// "cms spellcheck" => "cms spellcheck",
// "art home title" => "art home title",
// "feature trackers" => "feature trackers",
// "t use db" => "t use db",
// "t use dir" => "t use dir",
// "groupTracker" => "groupTracker",
// "userTracker" => "userTracker",
// "trk with mirror tables" => "trk with mirror tables",
// "feature userlevels" => "feature userlevels",
// "userlevels" => "userlevels",
// "userbreadCrumb" => "userbreadCrumb",
// "user assigned modules" => "user assigned modules",
// "user flip modules" => "user flip modules",
// "user show realnames" => "user show realnames",
// "feature mytiki" => "feature mytiki",
// "feature userPreferences" => "feature userPreferences",
// "feature user bookmarks" => "feature user bookmarks",
// "feature tasks" => "feature tasks",
// "w use db" => "w use db",
// "w use dir" => "w use dir",
// "w displayed default" => "w displayed default",
// "uf use db" => "uf use db",
// "uf use dir" => "uf use dir",
// "userfiles quota" => "userfiles quota",
// "feature usermenu" => "feature usermenu",
// "feature minical" => "feature minical",
// "feature notepad" => "feature notepad",
// "feature userfiles" => "feature userfiles",
// "feature community gender" => "feature community gender",
// "feature community mouseover" => "feature community mouseover",
// "feature community mouseover name" => "feature community mouseover name",
// "feature community mouseover gender" => "feature community mouseover gender",
// "feature community mouseover picture" => "feature community mouseover picture",
// "feature community mouseover friends" => "feature community mouseover friends",
// "feature community mouseover score" => "feature community mouseover score",
// "feature community mouseover country" => "feature community mouseover country",
// "feature community mouseover email" => "feature community mouseover email",
// "feature community mouseover lastlogin" => "feature community mouseover lastlogin",
// "feature community mouseover distance" => "feature community mouseover distance",
// "feature community list name" => "feature community list name",
// "feature community list score" => "feature community list score",
// "feature community list country" => "feature community list country",
// "feature community list distance" => "feature community list distance",
// "feature community friends permission" => "feature community friends permission",
// "feature community friends permission dep" => "feature community friends permission dep",
// "change language" => "change language",
// "change theme" => "change theme",
// "login is email" => "login is email",
// "validateUsers" => "validateUsers",
// "validateEmail" => "validateEmail",
// "forgotPass" => "forgotPass",
// "change password" => "change password",
// "available languages" => "available languages",
// "available styles" => "available styles",
// "lowercase username" => "lowercase username",
// "username pattern" => "username pattern",
// "max username length" => "max username length",
// "min username length" => "min username length",
// "users prefs allowMsgs" => "users prefs allowMsgs",
// "users prefs country" => "users prefs country",
// "users prefs diff versions" => "users prefs diff versions",
// "users prefs display timezone" => "users prefs display timezone",
// "users prefs email is public" => "users prefs email is public",
// "users prefs homePage" => "users prefs homePage",
// "users prefs lat" => "users prefs lat",
// "users prefs lon" => "users prefs lon",
// "users prefs mess archiveAfter" => "users prefs mess archiveAfter",
// "users prefs mess maxRecords" => "users prefs mess maxRecords",
// "users prefs mess sendReadStatus" => "users prefs mess sendReadStatus",
// "users prefs minPrio" => "users prefs minPrio",
// "users prefs mytiki blogs" => "users prefs mytiki blogs",
// "users prefs mytiki articles" => "users prefs mytiki articles",
// "users prefs mytiki gals" => "users prefs mytiki gals",
// "users prefs mytiki items" => "users prefs mytiki items",
// "users prefs mytiki msgs" => "users prefs mytiki msgs",
// "users prefs mytiki pages" => "users prefs mytiki pages",
// "users prefs mytiki tasks" => "users prefs mytiki tasks",
// "users prefs mytiki workflow" => "users prefs mytiki workflow",
// "users prefs mytiki forum topics" => "users prefs mytiki forum topics",
// "users prefs mytiki forum replies" => "users prefs mytiki forum replies",
// "users prefs realName" => "users prefs realName",
// "users prefs gender" => "users prefs gender",
// "users prefs show mouseover user info" => "users prefs show mouseover user info",
// "users prefs tasks maxRecords" => "users prefs tasks maxRecords",
// "users prefs user dbl" => "users prefs user dbl",
// "users prefs user information" => "users prefs user information",
// "users prefs userbreadCrumb" => "users prefs userbreadCrumb",
// "users prefs mailCharset" => "users prefs mailCharset",
// "validateRegistration" => "validateRegistration",
// "feature messages" => "feature messages",
// "messu mailbox size" => "messu mailbox size",
// "messu archive size" => "messu archive size",
// "messu sent size" => "messu sent size",
// "allowmsg by default" => "allowmsg by default",
// "allowmsg is optional" => "allowmsg is optional",
// "feature newsreader" => "feature newsreader",
// "feature freetags" => "feature freetags",
// "freetags browse show cloud" => "freetags browse show cloud",
// "freetags cloud colors" => "freetags cloud colors",
// "freetags preload random search" => "freetags preload random search",
// "freetags browse amount tags in cloud" => "freetags browse amount tags in cloud",
// "freetags browse amount tags suggestion" => "freetags browse amount tags suggestion",
// "freetags normalized valid chars" => "freetags normalized valid chars",
// "freetags lowercase only" => "freetags lowercase only",
// "freetags feature 3d" => "freetags feature 3d",
// "freetags 3d width" => "freetags 3d width",
// "freetags 3d height" => "freetags 3d height",
// "freetags 3d navigation depth" => "freetags 3d navigation depth",
// "freetags 3d feed animation interval" => "freetags 3d feed animation interval",
// "freetags 3d existing page color" => "freetags 3d existing page color",
// "freetags 3d missing page color" => "freetags 3d missing page color",
// "freetags 3d autoload" => "freetags 3d autoload",
// "freetags 3d camera distance" => "freetags 3d camera distance",
// "freetags 3d elastic constant" => "freetags 3d elastic constant",
// "freetags 3d eletrostatic constant" => "freetags 3d eletrostatic constant",
// "freetags 3d fov" => "freetags 3d fov",
// "freetags 3d friction constant" => "freetags 3d friction constant",
// "freetags 3d node charge" => "freetags 3d node charge",
// "freetags 3d node mass" => "freetags 3d node mass",
// "freetags 3d node size" => "freetags 3d node size",
// "freetags 3d spring size" => "freetags 3d spring size",
// "freetags 3d text size" => "freetags 3d text size",
// "freetags 3d adjust camera" => "freetags 3d adjust camera",
// "freetags multilingual" => "freetags multilingual",
// "morelikethis algorithm" => "morelikethis algorithm",
// "morelikethis basic mincommon" => "morelikethis basic mincommon",
// "freetags show middle" => "freetags show middle",
// "feature search stats" => "feature search stats",
// "feature search" => "feature search",
// "feature search fulltext" => "feature search fulltext",
// "feature search show forbidden obj" => "feature search show forbidden obj",
// "feature search show forbidden cat" => "feature search show forbidden cat",
// "feature search show object filter" => "feature search show object filter",
// "feature search show search box" => "feature search show search box",
// "feature search show visit count" => "feature search show visit count",
// "feature search show pertinence" => "feature search show pertinence",
// "feature search show object type" => "feature search show object type",
// "feature search show last modification" => "feature search show last modification",
// "search refresh index mode" => "search refresh index mode",
// "search parsed snippet" => "search parsed snippet",
// "feature webmail" => "feature webmail",
// "webmail max attachment" => "webmail max attachment",
// "webmail view html" => "webmail view html",
// "feature contacts" => "feature contacts",
// "feature faqs" => "feature faqs",
// "feature faq comments" => "feature faq comments",
// "faq comments per page" => "faq comments per page",
// "faq comments default ordering" => "faq comments default ordering",
// "faq prefix" => "faq prefix",
// "feature quizzes" => "feature quizzes",
// "feature polls" => "feature polls",
// "feature poll comments" => "feature poll comments",
// "feature poll anonymous" => "feature poll anonymous",
// "poll comments default ordering" => "poll comments default ordering",
// "poll comments per page" => "poll comments per page",
// "poll list categories" => "poll list categories",
// "poll list objects" => "poll list objects",
// "feature poll revote" => "feature poll revote",
// "feature surveys" => "feature surveys",
// "feature featuredLinks" => "feature featuredLinks",
// "feature directory" => "feature directory",
// "directory columns" => "directory columns",
// "directory links per page" => "directory links per page",
// "directory open links" => "directory open links",
// "directory validate urls" => "directory validate urls",
// "directory cool sites" => "directory cool sites",
// "directory country flag" => "directory country flag",
// "feature calendar" => "feature calendar",
// "feature default calendars" => "feature default calendars",
// "calendar sticky popup" => "calendar sticky popup",
// "default calendars" => "default calendars",
// "calendar view mode" => "calendar view mode",
// "calendar view tab" => "calendar view tab",
// "calendar firstDayofWeek" => "calendar firstDayofWeek",
// "calendar timespan" => "calendar timespan",
// "feature jscalendar" => "feature jscalendar",
// "feature action calendar" => "feature action calendar",
// "calendar start year" => "calendar start year",
// "calendar end year" => "calendar end year",
// "calendar list begins focus" => "calendar list begins focus",
// "server timezone" => "server timezone",
// "long date format" => "long date format",
// "long time format" => "long time format",
// "short date format" => "short date format",
// "short time format" => "short time format",
// "display field order" => "display field order",
// "feature charts" => "feature charts",
// "rss forums" => "rss forums",
// "rss forum" => "rss forum",
// "rss directories" => "rss directories",
// "rss articles" => "rss articles",
// "rss blogs" => "rss blogs",
// "rss image galleries" => "rss image galleries",
// "rss file galleries" => "rss file galleries",
// "rss wiki" => "rss wiki",
// "rss image gallery" => "rss image gallery",
// "rss file gallery" => "rss file gallery",
// "rss blog" => "rss blog",
// "rss tracker" => "rss tracker",
// "rss trackers" => "rss trackers",
// "rss calendar" => "rss calendar",
// "rss mapfiles" => "rss mapfiles",
// "rss cache time" => "rss cache time",
// "max rss forums" => "max rss forums",
// "max rss forum" => "max rss forum",
// "max rss directories" => "max rss directories",
// "max rss articles" => "max rss articles",
// "max rss blogs" => "max rss blogs",
// "max rss image galleries" => "max rss image galleries",
// "max rss file galleries" => "max rss file galleries",
// "max rss wiki" => "max rss wiki",
// "max rss image gallery" => "max rss image gallery",
// "max rss file gallery" => "max rss file gallery",
// "max rss blog" => "max rss blog",
// "max rss mapfiles" => "max rss mapfiles",
// "max rss tracker" => "max rss tracker",
// "max rss trackers" => "max rss trackers",
// "max rss calendar" => "max rss calendar",
// "summary rss blogs" => "summary rss blogs",
// "rssfeed default version" => "rssfeed default version",
// "rssfeed language" => "rssfeed language",
// "rssfeed editor" => "rssfeed editor",
// "rssfeed webmaster" => "rssfeed webmaster",
// "rssfeed creator" => "rssfeed creator",
// "rssfeed css" => "rssfeed css",
// "rssfeed publisher" => "rssfeed publisher",
// "rssfeed img" => "rssfeed img",
// "rss basic auth" => "rss basic auth",
// "feature maps" => "feature maps",
// "map path" => "map path",
// "default map" => "default map",
// "map help" => "map help",
// "map comments" => "map comments",
// "gdaltindex" => "gdaltindex",
// "ogr2ogr" => "ogr2ogr",
// "mapzone" => "mapzone",
// "feature gmap" => "feature gmap",
// "gmap defaultx" => "gmap defaultx",
// "gmap defaulty" => "gmap defaulty",
// "gmap defaultz" => "gmap defaultz",
// "gmap key" => "gmap key",
// "allowRegister" => "allowRegister",
// "eponymousGroups" => "eponymousGroups",
// "useRegisterPasscode" => "useRegisterPasscode",
// "registerPasscode" => "registerPasscode",
// "rememberme" => "rememberme",
// "remembertime" => "remembertime",
// "feature clear passwords" => "feature clear passwords",
// "feature crypt passwords" => "feature crypt passwords",
// "feature challenge" => "feature challenge",
// "min user length" => "min user length",
// "min pass length" => "min pass length",
// "pass chr num" => "pass chr num",
// "pass due" => "pass due",
// "email due" => "email due",
// "unsuccessful logins" => "unsuccessful logins",
// "rnd num reg" => "rnd num reg",
// "generate password" => "generate password",
// "auth method" => "auth method",
// "auth pear" => "auth pear",
// "auth create user tiki" => "auth create user tiki",
// "auth create user auth" => "auth create user auth",
// "auth skip admin" => "auth skip admin",
// "auth ldap url" => "auth ldap url",
// "auth pear host" => "auth pear host",
// "auth pear port" => "auth pear port",
// "auth ldap scope" => "auth ldap scope",
// "auth ldap basedn" => "auth ldap basedn",
// "auth ldap userdn" => "auth ldap userdn",
// "auth ldap userattr" => "auth ldap userattr",
// "auth ldap useroc" => "auth ldap useroc",
// "auth ldap groupdn" => "auth ldap groupdn",
// "auth ldap groupattr" => "auth ldap groupattr",
// "auth ldap groupoc" => "auth ldap groupoc",
// "auth ldap memberattr" => "auth ldap memberattr",
// "auth ldap memberisdn" => "auth ldap memberisdn",
// "auth ldap adminuser" => "auth ldap adminuser",
// "auth ldap adminpass" => "auth ldap adminpass",
// "auth ldap version" => "auth ldap version",
// "auth ldap nameattr" => "auth ldap nameattr",
// "auth ldap countryattr" => "auth ldap countryattr",
// "auth ldap emailattr" => "auth ldap emailattr",
// "https login" => "https login",
// "feature show stay in ssl mode" => "feature show stay in ssl mode",
// "feature switch ssl mode" => "feature switch ssl mode",
// "https port" => "https port",
// "http port" => "http port",
// "login url" => "login url",
// "login scr" => "login scr",
// "register url" => "register url",
// "error url" => "error url",
// "highlight group" => "highlight group",
// "cookie path" => "cookie path",
// "cookie domain" => "cookie domain",
// "cookie name" => "cookie name",
// "user tracker infos" => "user tracker infos",
// "desactive login autocomplete" => "desactive login autocomplete",
// "permission denied login box" => "permission denied login box",
// "permission denied url" => "permission denied url",
// "feature intertiki" => "feature intertiki",
// "feature intertiki server" => "feature intertiki server",
// "feature intertiki slavemode" => "feature intertiki slavemode",
// "interlist" => "interlist",
// "feature intertiki mymaster" => "feature intertiki mymaster",
// "feature intertiki import preferences" => "feature intertiki import preferences",
// "feature intertiki import groups" => "feature intertiki import groups",
// "known hosts" => "known hosts",
// "tiki key" => "tiki key",
// "intertiki logfile" => "intertiki logfile",
// "intertiki errfile" => "intertiki errfile",
// "feature intertiki sharedcookie" => "feature intertiki sharedcookie",
// "search lru length" => "search lru length",
// "search lru purge rate" => "search lru purge rate",
// "search max syllwords" => "search max syllwords",
// "search min wordlength" => "search min wordlength",
// "search refresh rate" => "search refresh rate",
// "search syll age" => "search syll age",
// "feature categories" => "feature categories",
// "feature categoryobjects" => "feature categoryobjects",
// "feature categorypath" => "feature categorypath",
// "feature category reinforce" => "feature category reinforce",
// "feature category use phplayers" => "feature category use phplayers",
// "categorypath excluded" => "categorypath excluded",
// "categories used in tpl" => "categories used in tpl",
// "feature games" => "feature games",
// "feature html pages" => "feature html pages",
// "feature filegals manager" => "feature filegals manager",
// "feature contact" => "feature contact",
// "contact user" => "contact user",
// "contact anon" => "contact anon",
// "mail crlf" => "mail crlf",
// "feature detect language" => "feature detect language",
// "feature homePage if bl missing" => "feature homePage if bl missing",
// "record untranslated" => "record untranslated",
// "feature best language" => "feature best language",
// "feature translation" => "feature translation",
// "feature urgent translation" => "feature urgent translation",
// "lang use db" => "lang use db",
// "language" => "language",
// "feature babelfish" => "feature babelfish",
// "feature babelfish logo" => "feature babelfish logo",
// "quantify changes" => "quantify changes",
// "feature sync language" => "feature sync language",
// "show available translations" => "show available translations",
// "metatag keywords" => "metatag keywords",
// "metatag threadtitle" => "metatag threadtitle",
// "metatag imagetitle" => "metatag imagetitle",
// "metatag freetags" => "metatag freetags",
// "metatag description" => "metatag description",
// "metatag author" => "metatag author",
// "metatag geoposition" => "metatag geoposition",
// "metatag georegion" => "metatag georegion",
// "metatag geoplacename" => "metatag geoplacename",
// "metatag robots" => "metatag robots",
// "metatag revisitafter" => "metatag revisitafter",
// "head extra js" => "head extra js",
// "keep versions" => "keep versions",
// "feature custom home" => "feature custom home",
// "site crumb seper" => "site crumb seper",
// "site nav seper" => "site nav seper",
// "feature sitemycode" => "feature sitemycode",
// "sitemycode" => "sitemycode",
// "sitemycode publish" => "sitemycode publish",
// "feature sitelogo" => "feature sitelogo",
// "sitelogo bgcolor" => "sitelogo bgcolor",
// "sitelogo bgstyle" => "sitelogo bgstyle",
// "sitelogo align" => "sitelogo align",
// "sitelogo title" => "sitelogo title",
// "sitelogo src" => "sitelogo src",
// "sitelogo alt" => "sitelogo alt",
// "feature siteloc" => "feature siteloc",
// "feature sitenav" => "feature sitenav",
// "sitenav" => "sitenav",
// "feature sitead" => "feature sitead",
// "sitead" => "sitead",
// "sitead publish" => "sitead publish",
// "feature breadcrumbs" => "feature breadcrumbs",
// "feature siteloclabel" => "feature siteloclabel",
// "feature sitesearch" => "feature sitesearch",
// "feature site login" => "feature site login",
// "feature sitemenu" => "feature sitemenu",
// "feature topbar version" => "feature topbar version",
// "feature topbar debug" => "feature topbar debug",
// "feature topbar id menu" => "feature topbar id menu",
// "feature topbar custom code" => "feature topbar custom code",
// "feature sitetitle" => "feature sitetitle",
// "feature sitedesc" => "feature sitedesc",
// "feature bot logo" => "feature bot logo",
// "feature endbody code" => "feature endbody code",
// "feature left column" => "feature left column",
// "feature right column" => "feature right column",
// "feature top bar" => "feature top bar",
// "feature bot bar" => "feature bot bar",
// "feature bot bar icons" => "feature bot bar icons",
// "feature bot bar debug" => "feature bot bar debug",
// "feature bot bar rss" => "feature bot bar rss",
// "feature bot bar power by tw" => "feature bot bar power by tw",
// "maxRecords" => "maxRecords",
// "maxArticles" => "maxArticles",
// "maxVersions" => "maxVersions",
// "feature view tpl" => "feature view tpl",
// "slide style" => "slide style",
// "site favicon" => "site favicon",
// "site favicon type" => "site favicon type",
// "style" => "style",
// "style option" => "style option",
// "site style" => "site style",
// "site style option" => "site style option",
// "use context menu icon" => "use context menu icon",
// "use context menu text" => "use context menu text",
// "feature site report" => "feature site report",
// "feature site send link" => "feature site send link",
// "feature layoutshadows" => "feature layoutshadows",
// "main shadow start" => "main shadow start",
// "main shadow end" => "main shadow end",
// "header shadow start" => "header shadow start",
// "header shadow end" => "header shadow end",
// "middle shadow start" => "middle shadow start",
// "middle shadow end" => "middle shadow end",
// "center shadow start" => "center shadow start",
// "center shadow end" => "center shadow end",
// "footer shadow start" => "footer shadow start",
// "footer shadow end" => "footer shadow end",
// "feature mods provider" => "feature mods provider",
// "mods dir" => "mods dir",
// "mods server" => "mods server",
// "feature experimental" => "feature experimental",
// "feature actionlog" => "feature actionlog",
// "feature actionlog bytes" => "feature actionlog bytes",
// "browsertitle" => "browsertitle",
// "tmpDir" => "tmpDir",
// "feature tell a friend" => "feature tell a friend",
// "feature copyright" => "feature copyright",
// "feature multimedia" => "feature multimedia",
// "feature swfobj" => "feature swfobj",
// "feature smileys" => "feature smileys",
// "popupLinks" => "popupLinks",
// "feature autolinks" => "feature autolinks",
// "quicktags over textarea" => "quicktags over textarea",
// "default rows textarea wiki" => "default rows textarea wiki",
// "default rows textarea comment" => "default rows textarea comment",
// "default rows textarea forum" => "default rows textarea forum",
// "default rows textarea forumthread" => "default rows textarea forumthread",
// "feature floating help" => "feature floating help",
// "direct pagination" => "direct pagination",
// "nextprev pagination" => "nextprev pagination",
// "pagination firstlast" => "pagination firstlast",
// "pagination hide if one page" => "pagination hide if one page",
// "pagination icons" => "pagination icons",
// "pagination fastmove links" => "pagination fastmove links",
// "direct pagination max middle links" => "direct pagination max middle links",
// "direct pagination max ending links" => "direct pagination max ending links",
// "anonCanEdit" => "anonCanEdit",
// "cacheimages" => "cacheimages",
// "cachepages" => "cachepages",
// "count admin pvs" => "count admin pvs",
// "default mail charset" => "default mail charset",
// "error reporting adminonly" => "error reporting adminonly",
// "error reporting level" => "error reporting level",
// "smarty notice reporting" => "smarty notice reporting",
// "smarty security" => "smarty security",
// "feature ajax" => "feature ajax",
// "feature ajax autosave" => "feature ajax autosave",
// "feature antibot" => "feature antibot",
// "feature banners" => "feature banners",
// "feature banning" => "feature banning",
// "feature comm" => "feature comm",
// "feature contribution" => "feature contribution",
// "feature contribution display in comment" => "feature contribution display in comment",
// "feature contribution mandatory" => "feature contribution mandatory",
// "feature contribution mandatory blog" => "feature contribution mandatory blog",
// "feature contribution mandatory comment" => "feature contribution mandatory comment",
// "feature contribution mandatory forum" => "feature contribution mandatory forum",
// "feature debug console" => "feature debug console",
// "feature debugger console" => "feature debugger console",
// "feature display my to others" => "feature display my to others",
// "feature drawings" => "feature drawings",
// "feature dynamic content" => "feature dynamic content",
// "feature edit templates" => "feature edit templates",
// "feature editcss" => "feature editcss",
// "feature events" => "feature events",
// "feature friends" => "feature friends",
// "feature fullscreen" => "feature fullscreen",
// "feature help" => "feature help",
// "feature hotwords" => "feature hotwords",
// "feature hotwords nw" => "feature hotwords nw",
// "feature integrator" => "feature integrator",
// "feature live support" => "feature live support",
// "feature mailin" => "feature mailin",
// "feature menusfolderstyle" => "feature menusfolderstyle",
// "feature mobile" => "feature mobile",
// "feature modulecontrols" => "feature modulecontrols",
// "feature morcego" => "feature morcego",
// "feature multilingual" => "feature multilingual",
// "feature multilingual one page" => "feature multilingual one page",
// "feature multilingual structures" => "feature multilingual structures",
// "feature newsletters" => "feature newsletters",
// "feature obzip" => "feature obzip",
// "feature phplayers" => "feature phplayers",
// "feature cssmenus" => "feature cssmenus",
// "feature projects" => "feature projects",
// "feature ranking" => "feature ranking",
// "feature redirect on error" => "feature redirect on error",
// "feature referer highlight" => "feature referer highlight",
// "feature referer stats" => "feature referer stats",
// "feature score" => "feature score",
// "feature sheet" => "feature sheet",
// "feature shoutbox" => "feature shoutbox",
// "feature source" => "feature source",
// "feature stats" => "feature stats",
// "feature tabs" => "feature tabs",
// "feature theme control" => "feature theme control",
// "feature ticketlib" => "feature ticketlib",
// "feature ticketlib2" => "feature ticketlib2",
// "feature top banner" => "feature top banner",
// "feature usability" => "feature usability",
// "feature use quoteplugin" => "feature use quoteplugin",
// "feature user watches" => "feature user watches",
// "feature group watches" => "feature group watches",
// "feature user watches translations" => "feature user watches translations",
// "feature workflow" => "feature workflow",
// "feature xmlrpc" => "feature xmlrpc",
// "helpurl" => "helpurl",
// "layout section" => "layout section",
// "limitedGoGroupHome" => "limitedGoGroupHome",
// "minical reminders" => "minical reminders",
// "modallgroups" => "modallgroups",
// "modseparateanon" => "modseparateanon",
// "php docroot" => "php docroot",
// "proxy host" => "proxy host",
// "proxy port" => "proxy port",
// "ip can be checked" => "ip can be checked",
// "sender email" => "sender email",
// "feature site report email" => "feature site report email",
// "session db" => "session db",
// "session lifetime" => "session lifetime",
// "shoutbox autolink" => "shoutbox autolink",
// "show comzone" => "show comzone",
// "system os" => "system os",
// "tikiIndex" => "tikiIndex",
// "urlIndex" => "urlIndex",
// "useGroupHome" => "useGroupHome",
// "useGroupTheme" => "useGroupTheme",
// "useUrlIndex" => "useUrlIndex",
// "use proxy" => "use proxy",
// "user list order" => "user list order",
// "webserverauth" => "webserverauth",
// "feature purifier" => "feature purifier",
// "feature shadowbox" => "feature shadowbox",
// "log sql" => "log sql",
// "log sql perf min" => "log sql perf min",
// "log mail" => "log mail",
// "log tpl" => "log tpl",
// "case patched" => "case patched",
// "site closed" => "site closed",
// "site closed msg" => "site closed msg",
// "use load threshold" => "use load threshold",
// "load threshold" => "load threshold",
// "site busy msg" => "site busy msg",
// "bot logo code" => "bot logo code",
// "feature blogposts pings" => "feature blogposts pings",
// "feature create webhelp" => "feature create webhelp",
// "feature forums search" => "feature forums search",
// "feature trackbackpings" => "feature trackbackpings",
// "feature wiki ext icon" => "feature wiki ext icon",
// "feature wiki mandatory category" => "feature wiki mandatory category",
// "feature intertiki imported groups" => "feature intertiki imported groups",
// "feature wiki history ip" => "feature wiki history ip",
// "pam create user tiki" => "pam create user tiki",
// "pam service" => "pam service",
// "pam skip admin" => "pam skip admin",
// "shib affiliation" => "shib affiliation",
// "shib create user tiki" => "shib create user tiki",
// "shib group" => "shib group",
// "shib skip admin" => "shib skip admin",
// "shib usegroup" => "shib usegroup",
// "wiki 3d camera distance" => "wiki 3d camera distance",
// "wiki 3d elastic constant" => "wiki 3d elastic constant",
// "wiki 3d eletrostatic constant" => "wiki 3d eletrostatic constant",
// "wiki 3d fov" => "wiki 3d fov",
// "wiki 3d friction constant" => "wiki 3d friction constant",
// "wiki 3d node charge" => "wiki 3d node charge",
// "wiki 3d node mass" => "wiki 3d node mass",
// "wiki 3d node size" => "wiki 3d node size",
// "wiki 3d spring size" => "wiki 3d spring size",
// "wiki 3d text size" => "wiki 3d text size",
// "articles feature copyrights" => "articles feature copyrights",
// "blogues feature copyrights" => "blogues feature copyrights",
// "faqs feature copyrights" => "faqs feature copyrights",
// "feature contributor wiki" => "feature contributor wiki",
// "https login required" => "https login required",
// "maxRowsGalleries" => "maxRowsGalleries",
// "replimaster" => "replimaster",
// "rowImagesGalleries" => "rowImagesGalleries",
// "scaleSizeGalleries" => "scaleSizeGalleries",
// "thumbSizeXGalleries" => "thumbSizeXGalleries",
// "thumbSizeYGalleries" => "thumbSizeYGalleries",
// "wiki 3d adjust camera" => "wiki 3d adjust camera",
// "wiki 3d autoload" => "wiki 3d autoload",
// "feature mootools" => "feature mootools",
// "javascript enabled" => "javascript enabled",
// "feature comments post as anonymous" => "feature comments post as anonymous",
// "feature comments moderation" => "feature comments moderation",
// "feature comments locking" => "feature comments locking",
// "feature template zoom" => "feature template zoom",
// "feature iepngfix" => "feature iepngfix",
// "iepngfix selectors" => "iepngfix selectors",
// "iepngfix elements" => "iepngfix elements",
// "use minified scripts" => "use minified scripts",
// "valid email regex" => "valid email regex",
// "feature jquery" => "feature jquery",
// "jquery effect" => "jquery effect",
// "jquery effect direction" => "jquery effect direction",
// "jquery effect speed" => "jquery effect speed",
// "jquery effect tabs" => "jquery effect tabs",
// "jquery effect tabs direction" => "jquery effect tabs direction",
// "jquery effect tabs speed" => "jquery effect tabs speed",
// "feature jquery ui" => "feature jquery ui",
// "feature jquery tooltips" => "feature jquery tooltips",
// "feature jquery autocomplete" => "feature jquery autocomplete",
// "feature jquery superfish" => "feature jquery superfish",
// "feature jquery reflection" => "feature jquery reflection",
// "feature jquery sheet" => "feature jquery sheet",
// "feature jquery tablesorter" => "feature jquery tablesorter",
// "feature jquery cycle" => "feature jquery cycle",
// "feature sefurl" => "feature sefurl",
// "feature sefurl filter" => "feature sefurl filter",
// "feature sefurl paths" => "feature sefurl paths",
// "feature sefurl title article" => "feature sefurl title article",
// "feature sefurl title blog" => "feature sefurl title blog",
// "feature tikitests" => "feature tikitests",
// "feature magic" => "feature magic",
// "profile sources" => "profile sources",
// "profile channels" => "profile channels",
// "feature minichat" => "feature minichat",
// "feature pear date" => "feature pear date",
// "feature bidi" => "feature bidi",
// "feature lastup" => "feature lastup",
// "transition style ver" => "transition style ver",
// "magic last load" => "magic last load",
// "feature groupalert" => "feature groupalert",
// "lib spellcheck" => "lib spellcheck",
// "wiki spellcheck" => "wiki spellcheck",
// "blog spellcheck" => "blog spellcheck",
// "allowMsgs" => "allowMsgs",
// "diff versions" => "diff versions",
// "display timezone" => "display timezone",
// "email is public" => "email is public",
// "homePage" => "homePage",
// "lat" => "lat",
// "lon" => "lon",
// "mess archiveAfter" => "mess archiveAfter",
// "mess maxRecords" => "mess maxRecords",
// "mess sendReadStatus" => "mess sendReadStatus",
// "minPrio" => "minPrio",
// "mytiki blogs" => "mytiki blogs",
// "mytiki articles" => "mytiki articles",
// "mytiki gals" => "mytiki gals",
// "mytiki items" => "mytiki items",
// "mytiki msgs" => "mytiki msgs",
// "mytiki pages" => "mytiki pages",
// "mytiki tasks" => "mytiki tasks",
// "mytiki workflow" => "mytiki workflow",
// "mytiki forum topics" => "mytiki forum topics",
// "mytiki forum replies" => "mytiki forum replies",
// "realName" => "realName",
// "gender" => "gender",
// "show mouseover user info" => "show mouseover user info",
// "tasks maxRecords" => "tasks maxRecords",
// "user dbl" => "user dbl",
// "user information" => "user information",
// "mailCharset" => "mailCharset",
// "Group Monitor" => "Group Monitor",
// "Watched by categories" => "Watched by categories",
// "Select Categories" => "Select Categories",
// "Select/deselect all categories" => "Select/deselect all categories",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Errors" => "Errors",
// "Comments Locked" => "Comments Locked",
// "Set" => "Set",
// "Comments are locked" => "Comments are locked",
// "Note" => "Note",
// "Post new message" => "Post new message",
// "required" => "required",
// "Maximum size" => "Maximum size",
// "Enter your name" => "Enter your name",
// "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address" => "If you would like to be notified when someone replies to this topic<br />please tell us your e-mail address",
// "Please note that the preview does not keep the attached file which you will have to choose before posting" => "Please note that the preview does not keep the attached file which you will have to choose before posting",
// "Post as Anonymous" => "Post as Anonymous",
// "Your comment will have to be approved by the moderator before it is displayed" => "Your comment will have to be approved by the moderator before it is displayed",
// "Type of contribution" => "Type of contribution",
// "Contributors" => "Contributors",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "required field for podcasts" => "required field for podcasts",
// "any file" => "any file",
// "podcast (audio)" => "podcast (audio)",
// "podcast (video)" => "podcast (video)",
// "This Gallery is Public" => "This Gallery is Public",
// "Users with perms and not only the owner of the gallery can upload in it" => "Users with perms and not only the owner of the gallery can upload in it",
// "The files can be locked at download" => "The files can be locked at download",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "Owner of the gallery" => "Owner of the gallery",
// "Group of users alerted when file gallery is modified" => "Group of users alerted when file gallery is modified",
// "Allows to select each user for small groups" => "Allows to select each user for small groups",
// "Perhaps you were looking for" => "Perhaps you were looking for",
// "Go to Login Page" => "Go to Login Page",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "not in" => "not in",
// "any category" => "any category",
// "Clear Filter" => "Clear Filter",
// "Show php error messages" => "Show php error messages",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together" => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "RSS Calendars" => "RSS Calendars",
// "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page" => "You are about to leave this page. If you have made any changes without Saving, your changes will be lost.  Are you sure you want to exit this page",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Are you sure you want to delete the selected files" => "Are you sure you want to delete the selected files",
// "Download the zip" => "Download the zip",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link" => "To validate your account and login to the site, please click on the following link",
// "The administrator approved your account" => "The administrator approved your account",
// "Confirm your email at %s" => "Confirm your email at %s",
// "Contribution" => "Contribution",
// "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now" => "Your account registration request for {\$mail_site} was validated by the site admin and your account is active now",
// "To login with your username and password, please follow this link" => "To login with your username and password, please follow this link",
// "User Account Activated" => "User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "User Tracker" => "User Tracker",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else" => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above" => "Important: The old password remains active if you don't click the link above",
// "Look at this link" => "Look at this link",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}" => "New status ItemID {\$mail_itemId} for the tracker {\$mail_trackerName}",
// "Download the file at" => "Download the file at",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again" => "Please visit this link before login again",
// "Last attempt" => "Last attempt",
// "Confirm your account at %s" => "Confirm your account at %s",
// "An administrator of the site below has added you as a new user" => "An administrator of the site below has added you as a new user",
// "If you want to confirm your membership in this site, click on the following link to login for the first time" => "If you want to confirm your membership in this site, click on the following link to login for the first time",
// "Your authentication credentials are" => "Your authentication credentials are",
// "Welcome on the site" => "Welcome on the site",
// "Your personal access to" => "Your personal access to",
// "You'll receive email notification once your account is activated" => "You'll receive email notification once your account is activated",
// "Please do not attempt to login until you receive the email notification" => "Please do not attempt to login until you receive the email notification",
// "{\$mail_action} article post" => "{\$mail_action} article post",
// "{\$mail_title} by {\$mail_user} at" => "{\$mail_title} by {\$mail_user} at",
// "New article post" => "New article post",
// "Edited article post" => "Edited article post",
// "Deleted article post" => "Deleted article post",
// "{\$mail_action} article post at" => "{\$mail_action} article post at",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user|username} at {\$mail_date|tiki_short_datetime}",
// "View item calendar at" => "View item calendar at",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "A new category was created in" => "A new category was created in",
// "A category was removed in" => "A category was removed in",
// "removed" => "removed",
// "A category was updated" => "A category was updated",
// "Updated by" => "Updated by",
// "Old" => "Old",
// "New" => "New",
// "updated" => "updated",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "An object was added to category" => "An object was added to category",
// "Added by" => "Added by",
// "Object type" => "Object type",
// "An object was removed from category" => "An object was removed from category",
// "A page has been added to your watched sub-structure" => "A page has been added to your watched sub-structure",
// "A page has been removed from your watched sub-structure" => "A page has been removed from your watched sub-structure",
// "A page has been promoted out your watched sub-structure" => "A page has been promoted out your watched sub-structure",
// "A page has been demoted to your watched structure" => "A page has been demoted to your watched structure",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was deleted by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was deleted but used to be here" => "The page {\$mail_page} was deleted but used to be here",
// "The old page content follows below" => "The old page content follows below",
// "Wiki page %s created by {\$mail_user}" => "Wiki page %s created by {\$mail_user}",
// "Wiki page %s deleted by {\$mail_user}" => "Wiki page %s deleted by {\$mail_user}",
// "Wiki page %s changed by {\$mail_user}" => "Wiki page %s changed by {\$mail_user}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now" => "Thank you for your registration. You may log in now",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Zoom in" => "Zoom in",
// "from the mapfile" => "from the mapfile",
// "hits last 7 days" => "hits last 7 days",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences" => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences",
// "ERROR" => "ERROR",
// "is reply to" => "is reply to",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Admin Drawings" => "Admin Drawings",
// "Content Templates" => "Content Templates",
// "External Wikis" => "External Wikis",
// "Tiki Cache/Sys Admin" => "Tiki Cache/Sys Admin",
// "Syntax Highlighting" => "Syntax Highlighting",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "You forgot your Google ad_client number " => "You forgot your Google ad_client number ",
// "\$module_title" => "\$module_title",
// "More.." => "More..",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// "on blogpost" => "on blogpost",
// "Add event" => "Add event",
// "\$modcattitle" => "\$modcattitle",
// "Current events" => "Current events",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "More Like This" => "More Like This",
// "Most popular tags" => "Most popular tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "\$type" => "\$type",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "more" => "more",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "No avatar" => "No avatar",
// "You" => "You",
// "Switch user" => "Switch user",
// "Login through Shibboleth" => "Login through Shibboleth",
// "Login as" => "Login as",
// "CapsLock is on" => "CapsLock is on",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID" => "What is OpenID",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "RSS Feeds" => "RSS Feeds",
// "Calendars" => "Calendars",
// "A leading plus sign indicates that this word must be present in every object returned" => "A leading plus sign indicates that this word must be present in every object returned",
// "A leading minus sign indicates that this word must not be present in any row returned" => "A leading minus sign indicates that this word must not be present in any row returned",
// "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher" => "By default (when neither plus nor minus is specified) the word is optional, but the object that contain it will be rated higher",
// "These two operators are used to change a word's contribution to the relevance value that is assigned to a row" => "These two operators are used to change a word's contribution to the relevance value that is assigned to a row",
// "Parentheses are used to group words into subexpressions" => "Parentheses are used to group words into subexpressions",
// "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator" => "A leading tilde acts as a negation operator, causing the word's contribution to the object relevance to be negative. It's useful for marking noise words. An object that contains such a word will be rated lower than others, but will not be excluded altogether, as it would be with the - operator",
// "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended" => "An asterisk is the truncation operator. Unlike the other operators, it should be appended to the word, not prepended",
// "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed" => "The phrase, that is enclosed in double quotes &quot;, matches only objects that contain this phrase literally, as it was typed",
// "Advanced search" => "Advanced search",
// "Advanced Search Help" => "Advanced Search Help",
// "Page Relations" => "Page Relations",
// "Are you sure you want to delete this shout" => "Are you sure you want to delete this shout",
// "Delete this shout" => "Delete this shout",
// "Edit this shout" => "Edit this shout",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "`\$module_params.prefix`" => "`\$module_params.prefix`",
// "Site Language" => "Site Language",
// "Site default" => "Site default",
// "TikiTests Menu" => "TikiTests Menu",
// "List Tests" => "List Tests",
// "Create Test" => "Create Test",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Page translation" => "Page translation",
// "There are no translations of this page" => "There are no translations of this page",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
// "Set your preferred languages" => "Set your preferred languages",
// "preferred languages" => "preferred languages",
// "Equivalent translations" => "Equivalent translations",
// "Translations that need improvement" => "Translations that need improvement",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "on host" => "on host",
// "Videos on YouTube" => "Videos on YouTube",
// "More Videos" => "More Videos",
// "Changes that need to be reproduced are highlighted below" => "Changes that need to be reproduced are highlighted below",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "By" => "By",
// "Read more" => "Read more",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones" => "Select <a href=\"tiki-list_banners.php\" title=\"Banners\">Admin &gt; Banners</a> from the menu to create and edit banner zones",
// "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users" => "<strong>Activate</strong> will display content for Admin only. Select <strong>Publish</strong> to display for all users",
// "Profiles" => "Profiles",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "i18n" => "i18n",
// "Editing and Plugins" => "Editing and Plugins",
// "Text area" => "Text area",
// "Freetags" => "Freetags",
// "Multimedia" => "Multimedia",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Semantic wiki links" => "Semantic wiki links",
// "Semantic links" => "Semantic links",
// "Webservices" => "Webservices",
// "Sef URL" => "Sef URL",
// "Blogs Listing" => "Blogs Listing",
// "Create a blog" => "Create a blog",
// "Spell checking" => "Spell checking",
// "Requires a separate download" => "Requires a separate download",
// "Custom blog headings" => "Custom blog headings",
// "Blog-level" => "Blog-level",
// "Post-level" => "Post-level",
// "Default number per page" => "Default number per page",
// "Default ordering" => "Default ordering",
// "Blogs Listings" => "Blogs Listings",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Select which items to display when listing blogs" => "Select which items to display when listing blogs",
// "Title length" => "Title length",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "General settings" => "General settings",
// "Default calendars to display" => "Default calendars to display",
// "All calendars" => "All calendars",
// "A subset of available calendars" => "A subset of available calendars",
// "Create calendar" => "Create calendar",
// "Default view mode" => "Default view mode",
// "View list begins" => "View list begins",
// "Focus Date" => "Focus Date",
// "Period beginning" => "Period beginning",
// "First day of the week" => "First day of the week",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "Manual selection of time/date" => "Manual selection of time/date",
// "JS calendar" => "JS calendar",
// "Year selection is valid when the JS Calendar <strong>is not</strong> enabled" => "Year selection is valid when the JS Calendar <strong>is not</strong> enabled",
// "First year in the dropdown" => "First year in the dropdown",
// "Enter a year or use +/- N to specify a year relative to the current\n\tyear" => "Enter a year or use +/- N to specify a year relative to the current\n\tyear",
// "Last year in the dropdown" => "Last year in the dropdown",
// "Group calendars" => "Group calendars",
// "Sticky popup" => "Sticky popup",
// "Item view tab" => "Item view tab",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Category path" => "Category path",
// "Exclude these categories" => "Exclude these categories",
// "Separate category IDs with a comma (,)" => "Separate category IDs with a comma (,)",
// "Show category objects" => "Show category objects",
// "Use PHPLayers for category browser" => "Use PHPLayers for category browser",
// "PHPLayers is disabled" => "PHPLayers is disabled",
// "Enable now" => "Enable now",
// "Categories used in templates (TPL)" => "Categories used in templates (TPL)",
// "Will improve performance, but may show forbidden results" => "Will improve performance, but may show forbidden results",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Admin topics" => "Admin topics",
// "Admin types" => "Admin types",
// "Articles Listing" => "Articles Listing",
// "Title of articles home page" => "Title of articles home page",
// "Maximum number of articles on articles home page" => "Maximum number of articles on articles home page",
// "Article properties" => "Article properties",
// "Give only one value (width or height) to keep the image proportions" => "Give only one value (width or height) to keep the image proportions",
// "Specify notification emails when creating articles" => "Specify notification emails when creating articles",
// "Default article image width" => "Default article image width",
// "Default article image height" => "Default article image height",
// "Batch upload (CSV file)" => "Batch upload (CSV file)",
// "File format: title,authorName,heading,body,lang,user" => "File format: title,authorName,heading,body,lang,user",
// "Select which items to display when listing articles" => "Select which items to display when listing articles",
// "Publication date" => "Publication date",
// "Expiration date" => "Expiration date",
// "Users Listing" => "Users Listing",
// "Users can choose to show their gender" => "Users can choose to show their gender",
// "Requires User Preferences feature" => "Requires User Preferences feature",
// "Show user's information on mouseover" => "Show user's information on mouseover",
// "Requires user's information to be public" => "Requires user's information to be public",
// "Real name" => "Real name",
// "Feature is disabled" => "Feature is disabled",
// "Default user preferences" => "Default user preferences",
// "Users Default Preferences" => "Users Default Preferences",
// "Character set for mail" => "Character set for mail",
// "Detect user timezone if browser allows, otherwise site default" => "Detect user timezone if browser allows, otherwise site default",
// "User messages" => "User messages",
// "Notify sender when reading mail" => "Notify sender when reading mail",
// "My forum topics" => "My forum topics",
// "My forum replies" => "My forum replies",
// "Select which items to display when listing users" => "Select which items to display when listing users",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "License page" => "License page",
// "Submit notice" => "Submit notice",
// "Enable copyright management for" => "Enable copyright management for",
// "Show Country Flag" => "Show Country Flag",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site" => "Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site",
// "No tabs" => "No tabs",
// "Apply" => "Apply",
// "Reset" => "Reset",
// "Main" => "Main",
// "Global Features" => "Global Features",
// "More Functionality" => "More Functionality",
// "UI Enhancements" => "UI Enhancements",
// "Experimental" => "Experimental",
// "Programmer" => "Programmer",
// "Main Features" => "Main Features",
// "Site Global Features" => "Site Global Features",
// "Action Log" => "Action Log",
// "Action log setting" => "Action log setting",
// "Internationalization" => "Internationalization",
// "Additional Features" => "Additional Features",
// "HTML pages" => "HTML pages",
// "Minichat" => "Minichat",
// "Comments Moderation" => "Comments Moderation",
// "Comments Locking" => "Comments Locking",
// "User interface enhancement features" => "User interface enhancement features",
// "JavaScript popup date selector" => "JavaScript popup date selector",
// "Fullscreen" => "Fullscreen",
// "Allow users to activate fullscreen mode" => "Allow users to activate fullscreen mode",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
// "Mootools or JQuery" => "Mootools or JQuery",
// "Mootools" => "Mootools",
// "Floating help aka the Big Blue Help Icon" => "Floating help aka the Big Blue Help Icon",
// "Experimental Features" => "Experimental Features",
// "Seem ok" => "Seem ok",
// "Features that may change or might be re-worked in the future" => "Features that may change or might be re-worked in the future",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
// "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)",
// "JQuery: JavaScript UI effects" => "JQuery: JavaScript UI effects",
// "Morcego 3D browser" => "Morcego 3D browser",
// "Need polish" => "Need polish",
// "Features that need admin help and user patience to work well" => "Features that need admin help and user patience to work well",
// "Mindmap" => "Mindmap",
// "Print Indexed" => "Print Indexed",
// "SEFURL" => "SEFURL",
// "Search engine friendly url" => "Search engine friendly url",
// "Spreadsheet" => "Spreadsheet",
// "Ajax auto-save" => "Ajax auto-save",
// "Malfunctioning" => "Malfunctioning",
// "These features have critical faults - not recommended" => "These features have critical faults - not recommended",
// "Magic Admin Panel" => "Magic Admin Panel",
// "Neglected" => "Neglected",
// "Old features no longer maintained" => "Old features no longer maintained",
// "Friendship" => "Friendship",
// "SWFObject" => "SWFObject",
// "SwfObject" => "SwfObject",
// "Used to embed Flash content in wiki pages, banners etc" => "Used to embed Flash content in wiki pages, banners etc",
// "Action Calendar" => "Action Calendar",
// "Tiki action calendar" => "Tiki action calendar",
// "Redirect On Error" => "Redirect On Error",
// "Group Watches" => "Group Watches",
// "Group Alert" => "Group Alert",
// "Programmer Features" => "Programmer Features",
// "TikiTests" => "TikiTests",
// "requires PHP5 or more" => "requires PHP5 or more",
// "Use Minified Scripts" => "Use Minified Scripts",
// "To create or remove file galleries, select" => "To create or remove file galleries, select",
// "from the application menu" => "from the application menu",
// "Gallery Listing" => "Gallery Listing",
// "Search Indexing" => "Search Indexing",
// "Create a Gallery" => "Create a Gallery",
// "Store in database" => "Store in database",
// "Store in directory" => "Store in directory",
// "The server must be able to read/write the directory" => "The server must be able to read/write the directory",
// "The directory can be outside the web space" => "The directory can be outside the web space",
// "Podcast directory" => "Podcast directory",
// "Required for podcasts" => "Required for podcasts",
// "Default Ordering" => "Default Ordering",
// "Allow download limit per file" => "Allow download limit per file",
// "Prevent download if score becomes negative" => "Prevent download if score becomes negative",
// "Score is disabled" => "Score is disabled",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "Batch uploading" => "Batch uploading",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory" => "The server must be able to read the directory",
// "Require file author's name for anonymous uploads" => "Require file author's name for anonymous uploads",
// "Upload Regex" => "Upload Regex",
// "Must match" => "Must match",
// "Cannot match" => "Cannot match",
// "Gallery Listings" => "Gallery Listings",
// "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries" => "Changing these settings will <em>not</em> affect existing file galleries. These changes will apply <em>only</em> to new file galleries",
// "Select which items to display when listing galleries: " => "Select which items to display when listing galleries: ",
// "Automatically index files on upload or change" => "Automatically index files on upload or change",
// "Handlers" => "Handlers",
// "Add custom handlers to make your files &quot;searchable&quot; content" => "Add custom handlers to make your files &quot;searchable&quot; content",
// "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command" => "Use <strong>%1</strong> as the internal file name. For example, use <strong>strings %1</strong> to convert the document to text, using the Unix <strong>strings</strong> command",
// "To delete a handler, leave the <strong>System Command</strong> field blank" => "To delete a handler, leave the <strong>System Command</strong> field blank",
// "System Command" => "System Command",
// "Forums Listing" => "Forums Listing",
// "Create a forum" => "Create a forum",
// "Topic archiving" => "Topic archiving",
// "Quick jumps" => "Quick jumps",
// "Replies are empty" => "Replies are empty",
// "If disabled, replies will quote the original post" => "If disabled, replies will quote the original post",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "First post of a thread can have an empty body" => "First post of a thread can have an empty body",
// "Will be a thread title" => "Will be a thread title",
// "Threads" => "Threads",
// "Manage thread defaults per-forum" => "Manage thread defaults per-forum",
// "Display thread configuration bar" => "Display thread configuration bar",
// "Allows users to override the defaults" => "Allows users to override the defaults",
// "Keep settings for all forums during the user session" => "Keep settings for all forums during the user session",
// "Default style" => "Default style",
// "Default sort mode" => "Default sort mode",
// "Forum name search" => "Forum name search",
// "When listing forums" => "When listing forums",
// "Forum content search" => "Forum content search",
// "Topic content search" => "Topic content search",
// "Search is disabled" => "Search is disabled",
// "Use Tiki (database-independent) search" => "Use Tiki (database-independent) search",
// "Use database (full-text) search" => "Use database (full-text) search",
// "Select which items to display when listing forums" => "Select which items to display when listing forums",
// "Description length" => "Description length",
// "3D Tag Browser" => "3D Tag Browser",
// "Show tag cloud" => "Show tag cloud",
// "Maximum number of tags in cloud" => "Maximum number of tags in cloud",
// "Show freetags in middle column" => "Show freetags in middle column",
// "Preload freetag random tag" => "Preload freetag random tag",
// "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>" => "When arriving on <a href=\"tiki-browse_freetags.php\">freetag search page</a>",
// "Random tag cloud colors" => "Random tag cloud colors",
// "Separate colors with a comma (,)" => "Separate colors with a comma (,)",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Alphanumeric ASCII characters only" => "Alphanumeric ASCII characters only",
// "No accents or special characters" => "No accents or special characters",
// "Accept all charactrs" => "Accept all charactrs",
// "Lowercase tags only" => "Lowercase tags only",
// "Multilingual freetags" => "Multilingual freetags",
// "Multiligual disabled" => "Multiligual disabled",
// "&quot;More Like This&quot; algorithm" => "&quot;More Like This&quot; algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Minimum amount of tags in common" => "Minimum amount of tags in common",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "Morcego 3D browser disabled" => "Morcego 3D browser disabled",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node size" => "Node size",
// "Text size" => "Text size",
// "Spring (connection) size" => "Spring (connection) size",
// "Node color" => "Node color",
// "Camera settinsg" => "Camera settinsg",
// "Camera distance adjusted relative to nearest node" => "Camera distance adjusted relative to nearest node",
// "Camera distance" => "Camera distance",
// "Field of view" => "Field of view",
// "Physics engine" => "Physics engine",
// "Friction constant" => "Friction constant",
// "Elastic constant" => "Elastic constant",
// "Eletrostatic constant" => "Eletrostatic constant",
// "Node mass" => "Node mass",
// "Node charge" => "Node charge",
// "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below" => "Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Pixels Default" => "Pixels Default",
// "Default scale size" => "Default scale size",
// "Mover" => "Mover",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from filesystem storage to database storage" => "Move images from filesystem storage to database storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
// "Admin Password" => "Admin Password",
// "Release Check" => "Release Check",
// "Reset or upgrade your database" => "Reset or upgrade your database",
// "Check for updates automatically" => "Check for updates automatically",
// "Check frequency" => "Check frequency",
// "TikiWiki will check for updates when you access the main Administration page" => "TikiWiki will check for updates when you access the main Administration page",
// "Check for updates now" => "Check for updates now",
// "Sender email" => "Sender email",
// "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences" => "Go to <a href=\"tiki-admin.php?page=look\" title=\"\"><strong>Look &amp; Feel</strong></a> section for additional site related customization preferences",
// "Use TikiWiki feature as homepage" => "Use TikiWiki feature as homepage",
// "Use different URL as home page" => "Use different URL as home page",
// "Miscellaneous" => "Miscellaneous",
// "Server OS" => "Server OS",
// "Smarty Security" => "Smarty Security",
// "Do not allow php code in smarty templates" => "Do not allow php code in smarty templates",
// "Use PEAR::Date library" => "Use PEAR::Date library",
// "Default charset for sending mail" => "Default charset for sending mail",
// "Mail end of line" => "Mail end of line",
// "Logging and Reporting" => "Logging and Reporting",
// "Report all PHP errors except strict" => "Report all PHP errors except strict",
// "Visible to Admin only" => "Visible to Admin only",
// "Include Smarty notices" => "Include Smarty notices",
// "Log mail in Tiki logs" => "Log mail in Tiki logs",
// "Log SQL" => "Log SQL",
// "Log queries using more than" => "Log queries using more than",
// "This may impact performance" => "This may impact performance",
// "Add HTML comment at start and end of each Smarty template (TPL)" => "Add HTML comment at start and end of each Smarty template (TPL)",
// "CSRF Security" => "CSRF Security",
// "Use these options to protect against cross-site request forgeries (CSRF)" => "Use these options to protect against cross-site request forgeries (CSRF)",
// "Require confirmation if possible CSRF detected" => "Require confirmation if possible CSRF detected",
// "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings" => "See <a href=\"tiki-admin_security.php\" title=\"Security\"><strong>Admin &gt; Security Admin</strong></a> for additional security settings",
// "Site Access" => "Site Access",
// "Close site (except for those with permission)" => "Close site (except for those with permission)",
// "Message to display" => "Message to display",
// "Close site when server load is above the threshold  (except for those with permission)" => "Close site when server load is above the threshold  (except for those with permission)",
// "Maximum average server load threshold in the last minute" => "Maximum average server load threshold in the last minute",
// "Host" => "Host",
// "On permission denied, display login module (for Anonymous)" => "On permission denied, display login module (for Anonymous)",
// "Send to URL" => "Send to URL",
// "Performance" => "Performance",
// "Cache external pages" => "Cache external pages",
// "Cache external images" => "Cache external images",
// "GZip output" => "GZip output",
// "Output compression is active" => "Output compression is active",
// "Compression is handled by" => "Compression is handled by",
// "Session" => "Session",
// "Advanced configuration warning" => "Advanced configuration warning",
// "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects" => "Note that storing session data in the database is an advanced systems administration option, and is for admins who have comprehensive access and understanding of the database, in order to deal with any unexpected effects",
// "Enabling this feature will immediately log you out when you save this preference" => "Enabling this feature will immediately log you out when you save this preference",
// "Session lifetime" => "Session lifetime",
// "Contact" => "Contact",
// "The \"Contact Us\" feature is disabled" => "The \"Contact Us\" feature is disabled",
// "Allow anonymous visitors to use the \"Contact Us\"" => "Allow anonymous visitors to use the \"Contact Us\"",
// "The default help system may not be complete" => "The default help system may not be complete",
// "You can help with the TikiWiki documentation" => "You can help with the TikiWiki documentation",
// "Show user's real name instead of login (when possible)" => "Show user's real name instead of login (when possible)",
// "Highlight group" => "Highlight group",
// "Show user's contribution on the user information page" => "Show user's contribution on the user information page",
// "Display UserTracker information on the user information page" => "Display UserTracker information on the user information page",
// "Use the format: trackerId, fieldId1, fieldId2, .." => "Use the format: trackerId, fieldId1, fieldId2, ..",
// "Separators" => "Separators",
// "Locations (breadcrumbs)" => "Locations (breadcrumbs)",
// "Choices" => "Choices",
// "Use site default to show times" => "Use site default to show times",
// "Detect user timezone (if browser allows). Otherwise use site default" => "Detect user timezone (if browser allows). Otherwise use site default",
// "Sample" => "Sample",
// "Change the <strong>Admin</strong> password" => "Change the <strong>Admin</strong> password",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at " => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at ",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Babelfish links" => "Babelfish links",
// "Customized String Translation" => "Customized String Translation",
// "Default language" => "Default language",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "User preferences are disabled" => "User preferences are disabled",
// "Users can change site language" => "Users can change site language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages" => "Available languages",
// "Use Ctrl+Click to select multiple languages" => "Use Ctrl+Click to select multiple languages",
// "Display available translations" => "Display available translations",
// "Changing page language will also change the site language" => "Changing page language will also change the site language",
// "Translation assistant" => "Translation assistant",
// "Urgent translation notifications" => "Urgent translation notifications",
// "Quantify change size" => "Quantify change size",
// "Multilingual structures" => "Multilingual structures",
// "Structures are disabled" => "Structures are disabled",
// "Multilingual One Page feature" => "Multilingual One Page feature",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Intertiki client" => "Intertiki client",
// "Tiki Unique key" => "Tiki Unique key",
// "InterTiki Slave mode" => "InterTiki Slave mode",
// "Warning: overrides manually registered local users" => "Warning: overrides manually registered local users",
// "as master" => "as master",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Add new server" => "Add new server",
// "Intertiki server" => "Intertiki server",
// "Intertiki Server enabled" => "Intertiki Server enabled",
// "Access Log file" => "Access Log file",
// "Errors Log file" => "Errors Log file",
// "Known hosts" => "Known hosts",
// "Key" => "Key",
// "Look and Feel" => "Look and Feel",
// "Text Area" => "Text Area",
// "Wysiwyg" => "Wysiwyg",
// "Semantic" => "Semantic",
// "Webservices management" => "Webservices management",
// "CAS" => "CAS",
// "Tiki" => "Tiki",
// "Tiki and OpenID" => "Tiki and OpenID",
// "Validate by email" => "Validate by email",
// "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>" => "You need to set <a href=\"tiki-admin.php?page=general&amp;cookietab=2\">Sender Email</a>",
// "Validate user's email server" => "Validate user's email server",
// "Require validation by Admin" => "Require validation by Admin",
// "Require passcode to register" => "Require passcode to register",
// "Passcode" => "Passcode",
// "Users must enter this code to register" => "Users must enter this code to register",
// "Use CAPTCHA to prevent automatic/robot registrations" => "Use CAPTCHA to prevent automatic/robot registrations",
// "Requires PHP GD library" => "Requires PHP GD library",
// "Include &quot;Generate Password&quot; option on registration form" => "Include &quot;Generate Password&quot; option on registration form",
// "Use tracker to collect more user information" => "Use tracker to collect more user information",
// "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display" => "Use the <strong><a href=\"tiki-admingroups.php\" title=\"Admin Groups\">Admin: Groups</a></strong> page to select which tracker and fields to display",
// "Use tracker to collect more group information" => "Use tracker to collect more group information",
// "Users can select a group to join at registration" => "Users can select a group to join at registration",
// "By default, new users automatically join the Registered group" => "By default, new users automatically join the Registered group",
// "Re-validate user by email after" => "Re-validate user by email after",
// "Use <strong>-1</strong> for never" => "Use <strong>-1</strong> for never",
// "unsuccessful login attempts" => "unsuccessful login attempts",
// "Create a new group for each user" => "Create a new group for each user",
// "The group will be named identical to the user's username" => "The group will be named identical to the user's username",
// "Disable browser's autocomplete feature for username and password fields" => "Disable browser's autocomplete feature for username and password fields",
// "Confirm that the Admin account has a valid email address or you will not be permitted to login" => "Confirm that the Admin account has a valid email address or you will not be permitted to login",
// "Use HTTPS login" => "Use HTTPS login",
// "Users can choose to stay in SSL mode after an HTTPS login" => "Users can choose to stay in SSL mode after an HTTPS login",
// "Users can switch between secured or standard mode at login" => "Users can switch between secured or standard mode at login",
// "User's choice" => "User's choice",
// "Always" => "Always",
// "Cookie name" => "Cookie name",
// "Use email as username" => "Use email as username",
// "Minimum length" => "Minimum length",
// "Maximum length" => "Maximum length",
// "Force lowercase" => "Force lowercase",
// "Username pattern" => "Username pattern",
// "Store password as plain text" => "Store password as plain text",
// "Store passwords in plain text is activated. You should never set this unless you know what you are doing" => "Store passwords in plain text is activated. You should never set this unless you know what you are doing",
// "Remind/forgot password" => "Remind/forgot password",
// "If passwords </em>are stored<em> as plain text, the password will be emailed to the user" => "If passwords </em>are stored<em> as plain text, the password will be emailed to the user",
// "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user" => "If passwords </em>are not<em> plain text, reset instructions will be emailed to the user",
// "Encryption method" => "Encryption method",
// "Users can change their password" => "Users can change their password",
// "Require characters and numerals" => "Require characters and numerals",
// "Password expires after" => "Password expires after",
// "You must change the Authentication Method to PEAR::Auth for these changes to take effect" => "You must change the Authentication Method to PEAR::Auth for these changes to take effect",
// "Create user if not in Tiki" => "Create user if not in Tiki",
// "Create user if not in Auth" => "Create user if not in Auth",
// "Use Tiki authentication for Admin login" => "Use Tiki authentication for Admin login",
// "Will override the Host and Port settings" => "Will override the Host and Port settings",
// "Search scope" => "Search scope",
// "Subtree" => "Subtree",
// "One level" => "One level",
// "Base object" => "Base object",
// "LDAP version" => "LDAP version",
// "Realname attribute" => "Realname attribute",
// "Country attribute" => "Country attribute",
// "E-mail attribute" => "E-mail attribute",
// "Base DN" => "Base DN",
// "LDAP User" => "LDAP User",
// "User DN" => "User DN",
// "User attribute" => "User attribute",
// "User OC" => "User OC",
// "LDAP Group" => "LDAP Group",
// "Group DN" => "Group DN",
// "Group attribute" => "Group attribute",
// "Group OC" => "Group OC",
// "LDAP Member" => "LDAP Member",
// "Member attribute" => "Member attribute",
// "Member is DN" => "Member is DN",
// "LDAP Admin" => "LDAP Admin",
// "Admin user" => "Admin user",
// "Admin password" => "Admin password",
// "You must change the Authentication Method to PAM for these changes to take effect" => "You must change the Authentication Method to PAM for these changes to take effect",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
// "You must change the Authentication Method to Shibboleth for these changes to take effect" => "You must change the Authentication Method to Shibboleth for these changes to take effect",
// "Valid affiliations" => "Valid affiliations",
// "Separate multiple affiliations with commas" => "Separate multiple affiliations with commas",
// "Create with default group" => "Create with default group",
// "Default group" => "Default group",
// "You must change the Authentication Method to CAS for these changes to take effect" => "You must change the Authentication Method to CAS for these changes to take effect",
// "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/" => "You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/",
// "CAS Server" => "CAS Server",
// "Hostname" => "Hostname",
// "You must enable PHP CAS first" => "You must enable PHP CAS first",
// "General Layout" => "General Layout",
// "UI Effects" => "UI Effects",
// "The \"users can change theme\" feature will override the theme displayed" => "The \"users can change theme\" feature will override the theme displayed",
// "Theme not saved yet - click \"Apply\"" => "Theme not saved yet - click \"Apply\"",
// "Theme options" => "Theme options",
// "Each group can have its theme" => "Each group can have its theme",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "View Templates" => "View Templates",
// "Shadow layer" => "Shadow layer",
// "Enable additional general layout layers for shadows, rounded corners or other decorative styling" => "Enable additional general layout layers for shadows, rounded corners or other decorative styling",
// "Main shadow start" => "Main shadow start",
// "Main shadow end" => "Main shadow end",
// "Header shadow start" => "Header shadow start",
// "Header shadow end" => "Header shadow end",
// "Middle shadow start" => "Middle shadow start",
// "Middle shadow end" => "Middle shadow end",
// "Center shadow start" => "Center shadow start",
// "Center shadow end" => "Center shadow end",
// "Footer shadow start" => "Footer shadow start",
// "Footer shadow end" => "Footer shadow end",
// "Custom Site Header" => "Custom Site Header",
// "Activate will only show content for admin. Check Publish to use content for all users" => "Activate will only show content for admin. Check Publish to use content for all users",
// "Site Logo and Title" => "Site Logo and Title",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "Site title" => "Site title",
// "Site subtitle" => "Site subtitle",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  " => "Note: Needs feature PHPLayers on(default), or feature CSS Menu on  ",
// "Menu ID" => "Menu ID",
// "Prefix breadcrumbs with 'Location : '" => "Prefix breadcrumbs with 'Location : '",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Email this page" => "Email this page",
// "Custom Site Footer" => "Custom Site Footer",
// "Custom End of <body> Code" => "Custom End of <body> Code",
// "Bottom bar icons" => "Bottom bar icons",
// "Bottom bar debug" => "Bottom bar debug",
// "Bottom bar (RSS)" => "Bottom bar (RSS)",
// "Power by" => "Power by",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item" => "Max. number of links around the current item",
// "Max. number of links after the first or before the last item" => "Max. number of links after the first or before the last item",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Hide pagination when there is only one page" => "Hide pagination when there is only one page",
// "Use Icons" => "Use Icons",
// "JQuery plugins and add-ons" => "JQuery plugins and add-ons",
// "Requires jquery feature" => "Requires jquery feature",
// "JQuery Tooltips" => "JQuery Tooltips",
// "JQuery Tooltips: Customisable help tips" => "JQuery Tooltips: Customisable help tips",
// "JQuery Autocomplete" => "JQuery Autocomplete",
// "JQuery Superfish" => "JQuery Superfish",
// "JQuery Superfish (effects on CSS menus)" => "JQuery Superfish (effects on CSS menus)",
// "JQuery Reflection" => "JQuery Reflection",
// "JQuery Reflection (reflection effect on images)" => "JQuery Reflection (reflection effect on images)",
// "JQuery Cycle (slideshow)" => "JQuery Cycle (slideshow)",
// "For future use" => "For future use",
// "JQuery UI" => "JQuery UI",
// "JQuery UI: More JQuery functionality" => "JQuery UI: More JQuery functionality",
// "JQuery Sheet" => "JQuery Sheet",
// "JQuery Spreadsheet" => "JQuery Spreadsheet",
// "JQuery Sortable Tables" => "JQuery Sortable Tables",
// "Standard UI effects" => "Standard UI effects",
// "Effect for modules etc" => "Effect for modules etc",
// "Main JQuery effect" => "Main JQuery effect",
// "Slide" => "Slide",
// "Blind (UI)" => "Blind (UI)",
// "Clip (UI)" => "Clip (UI)",
// "Drop (UI)" => "Drop (UI)",
// "Explode (UI)" => "Explode (UI)",
// "Fold (UI)" => "Fold (UI)",
// "Puff (UI)" => "Puff (UI)",
// "Slide (UI)" => "Slide (UI)",
// "Effect speed" => "Effect speed",
// "Fast" => "Fast",
// "Slow" => "Slow",
// "Effect direction" => "Effect direction",
// "Tab UI effects" => "Tab UI effects",
// "Effect for tabs" => "Effect for tabs",
// "JQuery effect for tabs" => "JQuery effect for tabs",
// "Effect speed for tabs" => "Effect speed for tabs",
// "Effect direction for tabs" => "Effect direction for tabs",
// "Other options" => "Other options",
// "Correct PNG images alpha transparency in IE6 (experimental)" => "Correct PNG images alpha transparency in IE6 (experimental)",
// "List of CSS selectors to be fixed, each selector separated by comma" => "List of CSS selectors to be fixed, each selector separated by comma",
// "List of HTMLDomElements to be fixed, each element separated by comma" => "List of HTMLDomElements to be fixed, each element separated by comma",
// "Context Menus (only in file galleries so far)" => "Context Menus (only in file galleries so far)",
// "Use context menus for actions (icons)" => "Use context menus for actions (icons)",
// "Use context menus for actions (text)" => "Use context menus for actions (text)",
// "Users can opt-out internal messages" => "Users can opt-out internal messages",
// "Users accept internal messages by default" => "Users accept internal messages by default",
// "Change Preferences" => "Change Preferences",
// "Meta tags" => "Meta tags",
// "Keywords" => "Keywords",
// "Include freetags" => "Include freetags",
// "Use thread title instead" => "Use thread title instead",
// "Use image title instead" => "Use image title instead",
// "Geo URL" => "Geo URL",
// "Meta robots" => "Meta robots",
// "Revisit after" => "Revisit after",
// "&quot;Modules&quot; are the boxes of content in the right &amp; left columns" => "&quot;Modules&quot; are the boxes of content in the right &amp; left columns",
// "Admin &gt; Modules" => "Admin &gt; Modules",
// "from the menu to create and edit modules" => "from the menu to create and edit modules",
// "Show module controls" => "Show module controls",
// "Users can configure modules" => "Users can configure modules",
// "Users can shade modules" => "Users can shade modules",
// "Module decides" => "Module decides",
// "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item" => "It works with the File Gallery, wiki pages (via a plugin), and a new multimedia tracker item",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Length" => "Flash Length",
// "Flash Heigth" => "Flash Heigth",
// "Video Length" => "Video Length",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Anonymous voting" => "Anonymous voting",
// "Allow re-voting" => "Allow re-voting",
// "Show categories" => "Show categories",
// "Categories disabled" => "Categories disabled",
// "Show objects" => "Show objects",
// "Are you sure you want to install the profile" => "Are you sure you want to install the profile",
// "TikiWiki Profiles" => "TikiWiki Profiles",
// "Profile repository" => "Profile repository",
// "Filter the list of profiles" => "Filter the list of profiles",
// "Profile" => "Profile",
// "Repository" => "Repository",
// "installed" => "installed",
// "Repositories" => "Repositories",
// "Repository URLs" => "Repository URLs",
// "Enter multiple repository URLs, one per line" => "Enter multiple repository URLs, one per line",
// "Data Channels" => "Data Channels",
// "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. " => "Data channels create a named pipe to run profiles from user space. One channel per line. Each line is comma delimited and contain <strong>channel name, domain, profile, allowed groups</strong>. ",
// "More information" => "More information",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS Modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Show Author" => "Show Author",
// "Homepage URL" => "Homepage URL",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Map files" => "Map files",
// "Feed for maps" => "Feed for maps",
// "Defaults" => "Defaults",
// "Image Path" => "Image Path",
// "Caching time" => "Caching time",
// "Use <strong>0</strong> for no caching" => "Use <strong>0</strong> for no caching",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public" => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Search Results" => "Search Results",
// "Search type" => "Search type",
// "Database search" => "Database search",
// "This search uses the MySQL Full-Text feature" => "This search uses the MySQL Full-Text feature",
// "Tiki search" => "Tiki search",
// "This database-independent search is always enabled" => "This database-independent search is always enabled",
// "Specify the Tiki search settings" => "Specify the Tiki search settings",
// "Refresh mode" => "Refresh mode",
// "Use <strong>0</strong> for no refresh" => "Use <strong>0</strong> for no refresh",
// "When the Database search is enabled, you must manually refresh the Tiki search indexes" => "When the Database search is enabled, you must manually refresh the Tiki search indexes",
// "Refresh all search index now" => "Refresh all search index now",
// "Refresh wiki search index now" => "Refresh wiki search index now",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Parse the results" => "Parse the results",
// "May impact performance" => "May impact performance",
// "Enabling these options will improve performance, but may show forbidden results" => "Enabling these options will improve performance, but may show forbidden results",
// "Select the items to display on the search results page" => "Select the items to display on the search results page",
// "Object filter" => "Object filter",
// "Search box" => "Search box",
// "Select the information to display for each result" => "Select the information to display for each result",
// "Pertinence" => "Pertinence",
// "Last modified date" => "Last modified date",
// "Search engine friendly url Postfilter" => "Search engine friendly url Postfilter",
// "List of Url Parameters that should go in the path" => "List of Url Parameters that should go in the path",
// "Display article title in the sefurl" => "Display article title in the sefurl",
// "Display blog title in the sefurl" => "Display blog title in the sefurl",
// "Known Types" => "Known Types",
// "Token" => "Token",
// "Invert" => "Invert",
// "Show Usage" => "Show Usage",
// "Delete &amp; Unreference" => "Delete &amp; Unreference",
// "Invert Relation" => "Invert Relation",
// "Self" => "Self",
// "New Types" => "New Types",
// "Fix" => "Fix",
// "No occurences found" => "No occurences found",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Plugins" => "Plugins",
// "Plugin Aliases" => "Plugin Aliases",
// "Anonymous editors must enter anti-bot code (CAPTCHA)" => "Anonymous editors must enter anti-bot code (CAPTCHA)",
// "Protect email against spam" => "Protect email against spam",
// "External link icon" => "External link icon",
// "External links will be identified with" => "External links will be identified with",
// "Use File Galleries to store pictures " => "Use File Galleries to store pictures ",
// "Allow to post comments as Anonymous" => "Allow to post comments as Anonymous",
// "Wiki paragraph formatting" => "Wiki paragraph formatting",
// "...but still create line breaks within paragraphs" => "...but still create line breaks within paragraphs",
// "&lt;return&gt; for rows" => "&lt;return&gt; for rows",
// "Show quicktags above textareas" => "Show quicktags above textareas",
// "If disabled, quicktags will be shown to the left of textareas" => "If disabled, quicktags will be shown to the left of textareas",
// "Open Hotwords in new window" => "Open Hotwords in new window",
// "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting",
// "Plugin disabled" => "Plugin disabled",
// "Default size" => "Default size",
// "Comments " => "Comments ",
// "Forum reply" => "Forum reply",
// "About plugins" => "About plugins",
// "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below" => "Tiki plugins add functionality to wiki pages, articles and blogs etc. You can enable and disable them below",
// "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>" => "You can approve plugin use at <a href=\"tiki-plugins.php\">tiki-plugins.php</a>",
// "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below" => "The edit plugin icon is an easy way for users to edit the parameters of each plugin in wiki pages. It can be disabled for individual plugins below",
// "Edit plugin icons" => "Edit plugin icons",
// "Enable edit plugin icons" => "Enable edit plugin icons",
// "(experimental - not comprehensively tested and requires new JQuery feature)" => "(experimental - not comprehensively tested and requires new JQuery feature)",
// "Enable" => "Enable",
// "Disable edit plugin icon (make plugin inline)" => "Disable edit plugin icon (make plugin inline)",
// "About plugin aliases" => "About plugin aliases",
// "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}" => "Tiki plugin aliases allow you to define your own custom configurations of existing plugins.<br />Find out more here: {help url=\"Plugin+Alias\"}",
// "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}" => "This page is designed to work with JQuery {icon _id=\"arrow_right\" href=\"tiki-admin.php?page=features\"}",
// "Available Alias" => "Available Alias",
// "Enable Plugins" => "Enable Plugins",
// "General Information" => "General Information",
// "Plugin Name" => "Plugin Name",
// "Base Plugin" => "Base Plugin",
// "Body Label" => "Body Label",
// "Dependencies" => "Dependencies",
// "Validation" => "Validation",
// "Inline (No Plugin Edit UI)" => "Inline (No Plugin Edit UI)",
// "Simple Plugin Arguments" => "Simple Plugin Arguments",
// "Argument" => "Argument",
// "New Argument" => "New Argument",
// "Plugin Parameter Documentation" => "Plugin Parameter Documentation",
// "Safe" => "Safe",
// "Plugin Body" => "Plugin Body",
// "Ignore User Input" => "Ignore User Input",
// "Default Content" => "Default Content",
// "Encoding" => "Encoding",
// "Argument Source (if different)" => "Argument Source (if different)",
// "Default Value" => "Default Value",
// "Composed Plugin Arguments" => "Composed Plugin Arguments",
// "Pattern" => "Pattern",
// "Tracker attachment preferences" => "Tracker attachment preferences",
// "Trackers with mirror tables" => "Trackers with mirror tables",
// "Use trackers with mirror tables" => "Use trackers with mirror tables",
// "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Validate choice" => "Validate choice",
// "Tracker attachments" => "Tracker attachments",
// "No records" => "No records",
// "Include a flag by each e-mail to quickly flag/un-flag them" => "Include a flag by each e-mail to quickly flag/un-flag them",
// "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used" => "Enter the URL of a web services returning either JSON or YAML. Parameters can be specified by enclosing a name between percentage signs. For example: %name%. %service% and %template% are reserved keywords and cannot be used",
// "Lookup" => "Lookup",
// "Test Input" => "Test Input",
// "Response Information" => "Response Information",
// "OIntegrate Version" => "OIntegrate Version",
// "Not supported" => "Not supported",
// "Schema Version" => "Schema Version",
// "Schema Documentation" => "Schema Documentation",
// "Available" => "Available",
// "Not specified, default used" => "Not specified, default used",
// "Content Type" => "Content Type",
// "Not specified" => "Not specified",
// "Returned Data" => "Returned Data",
// "Proposed Templates" => "Proposed Templates",
// "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters" => "Register this web service. It will be possible to register the templates afterwards. Service name must only contain letters",
// "Register Service" => "Register Service",
// "Registered Templates" => "Registered Templates",
// "Engine" => "Engine",
// "Output" => "Output",
// "Register Template" => "Register Template",
// "Use the 'Quick Edit' module to easily create or edit wiki pages" => "Use the 'Quick Edit' module to easily create or edit wiki pages",
// "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules" => "Select <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">Admin &gt; Modules</a> to add this (or other) modules",
// "Staging &amp; Approval" => "Staging &amp; Approval",
// "Page Listings" => "Page Listings",
// "If the page does not exist, it will be created" => "If the page does not exist, it will be created",
// "Wiki link format" => "Wiki link format",
// "Latin" => "Latin",
// "Select the characters that can be used with Wiki link syntax: ((page name))" => "Select the characters that can be used with Wiki link syntax: ((page name))",
// "Page display" => "Page display",
// "Page ID" => "Page ID",
// "Page version" => "Page version",
// "Page name display stripper" => "Page name display stripper",
// "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>" => "Enter a character to use as the delimiter when displaying page names. All characters after the delimiter will be stripped when displaying the page name.</em>",
// "Allow override per page" => "Allow override per page",
// "Display show/hide icon displayed before headings" => "Display show/hide icon displayed before headings",
// "Wiki action bar" => "Wiki action bar",
// "Buttons: Save, Preview, Cancel, .." => "Buttons: Save, Preview, Cancel, ..",
// "Page navigation bar location" => "Page navigation bar location",
// "When using the ...page... page break wiki syntax" => "When using the ...page... page break wiki syntax",
// "Wiki top line" => "Wiki top line",
// "Neither" => "Neither",
// "Page description, icons, backlinks, .." => "Page description, icons, backlinks, ..",
// "Wiki buttons" => "Wiki buttons",
// "Buttons: Edit, Source, Remove, .." => "Buttons: Edit, Source, Remove, ..",
// "Save draft" => "Save draft",
// "Requires AJAX" => "Requires AJAX",
// "experimental" => "experimental",
// "Edit section" => "Edit section",
// "Edit section level" => "Edit section level",
// "Allow minor edits" => "Allow minor edits",
// "Minor edits do not flag new content for translation and do not send watch notifications" => "Minor edits do not flag new content for translation and do not send watch notifications",
// "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled" => "Only user groups granted the tiki_p_minor permission (and admins) will be able to save minor edits when this is enabled",
// "Regex search and replace" => "Regex search and replace",
// "Log bytes changes (+/-) in action logs" => "Log bytes changes (+/-) in action logs",
// "Display by default" => "Display by default",
// "Manage attachments" => "Manage attachments",
// "Tag for current wiki" => "Tag for current wiki",
// "Restore wiki to tag" => "Restore wiki to tag",
// "Restore" => "Restore",
// "Remove a tag" => "Remove a tag",
// "WikiWords" => "WikiWords",
// "Maximum number of versions" => "Maximum number of versions",
// "Never delete versions younger than" => "Never delete versions younger than",
// "Display IP address" => "Display IP address",
// "Default diff style" => "Default diff style",
// "HTML diff" => "HTML diff",
// "Side-by-side diff by characters" => "Side-by-side diff by characters",
// "Inline diff" => "Inline diff",
// "Inline diff by characters" => "Inline diff by characters",
// "Full side-by-side diff by characters" => "Full side-by-side diff by characters",
// "Full inline diff" => "Full inline diff",
// "Full inline diff by characters" => "Full inline diff by characters",
// "History includes only page data, description, and change comment" => "History includes only page data, description, and change comment",
// "Forums are disabled" => "Forums are disabled",
// "Forum for discussion" => "Forum for discussion",
// "View source" => "View source",
// "Polls are disabled" => "Polls are disabled",
// "Similar" => "Similar",
// "like pages" => "like pages",
// "Make structure from page" => "Make structure from page",
// "Categorize structure pages together" => "Categorize structure pages together",
// "Create webhelp from structure" => "Create webhelp from structure",
// "Import pages" => "Import pages",
// "Slideshows" => "Slideshows",
// "User's page" => "User's page",
// "Users can lock pages" => "Users can lock pages",
// "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page" => "When viewing a page, if it doesn't exist automatically redirect to a similarly  named page",
// "Wiki watch" => "Wiki watch",
// "Watch minor edits" => "Watch minor edits",
// "Use wiki page staging and approval" => "Use wiki page staging and approval",
// "Force bounce of editing of approved pages to staging" => "Force bounce of editing of approved pages to staging",
// "Delete staging pages at approval" => "Delete staging pages at approval",
// "If not in the group, edit is always redirected to the staging page edit" => "If not in the group, edit is always redirected to the staging page edit",
// "Unique page name prefix to indicate staging copy" => "Unique page name prefix to indicate staging copy",
// "Hide page name prefix" => "Hide page name prefix",
// "Staging" => "Staging",
// "Approved" => "Approved",
// "(mandatory for feature to work)" => "(mandatory for feature to work)",
// "Out-of-sync" => "Out-of-sync",
// "Categorize approved pages with categories of staging copy on approval" => "Categorize approved pages with categories of staging copy on approval",
// "Freetags are disabled" => "Freetags are disabled",
// "Replace freetags with that of staging pages, on approval" => "Replace freetags with that of staging pages, on approval",
// "Add new freetags of approved copy (into tags field) when editing staging pages" => "Add new freetags of approved copy (into tags field) when editing staging pages",
// "Orphan page" => "Orphan page",
// "Configuration" => "Configuration",
// "Select which items to display when listing pages" => "Select which items to display when listing pages",
// "Name length" => "Name length",
// "Edit comments" => "Edit comments",
// "Edit Comments length" => "Edit Comments length",
// "Categories path" => "Categories path",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "Database Version Problem" => "Database Version Problem",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>" => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>",
// "The following list of changes has been applied" => "The following list of changes has been applied",
// "disabled" => "disabled",
// "enabled" => "enabled",
// "information" => "information",
// "preference" => "preference",
// "preference name" => "preference name",
// "Crosslinks to other features and settings" => "Crosslinks to other features and settings",
// "Other sections" => "Other sections",
// "Administration features" => "Administration features",
// "Security" => "Security",
// "TikiCache/System" => "TikiCache/System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "Edit Languages" => "Edit Languages",
// "Transversal features" => "Transversal features",
// "which apply to more than one section" => "which apply to more than one section",
// "Navigation features" => "Navigation features",
// "themes" => "themes",
// "Text area features" => "Text area features",
// "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "features you can use in all text areas, like wiki pages, blogs, articles, forums, etc",
// "Stats &amp; banners" => "Stats &amp; banners",
// "Report" => "Report",
// "Please select some actions to view" => "Please select some actions to view",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot" => "Group Bar Plot",
// "Accumulated Bar Plot" => "Accumulated Bar Plot",
// "Legend background color" => "Legend background color",
// "Save graphs to image gallery" => "Save graphs to image gallery",
// "contribution" => "contribution",
// "contributor" => "contributor",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "recorded" => "recorded",
// "Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki page actions except viewed will always be recorded but can be not reported",
// "Configure" => "Configure",
// "Create Calendar" => "Create Calendar",
// "View Calendars" => "View Calendars",
// "Edit Calendar" => "Edit Calendar",
// "View Calendar" => "View Calendar",
// "Add Event" => "Add Event",
// "Create/Edit Calendars" => "Create/Edit Calendars",
// "Custom URL" => "Custom URL",
// "Start of day" => "Start of day",
// "End of day" => "End of day",
// "Standard Colors" => "Standard Colors",
// "Green" => "Green",
// "Blue" => "Blue",
// "Purple" => "Purple",
// "Orange" => "Orange",
// "Yellow" => "Yellow",
// "Let me select my own colors" => "Let me select my own colors",
// "Custom foreground color" => "Custom foreground color",
// "Ex" => "Ex",
// "Custom background color" => "Custom background color",
// "Default event status" => "Default event status",
// "Show in calendar view" => "Show in calendar view",
// "Group of users alerted when calendar event is modified" => "Group of users alerted when calendar event is modified",
// "Delete events older than" => "Delete events older than",
// "Browse the category system" => "Browse the category system",
// "Current Category ID" => "Current Category ID",
// "Remove from this Category" => "Remove from this Category",
// "Admin charts" => "Admin charts",
// "Use in" => "Use in",
// "No features are configured to use templates" => "No features are configured to use templates",
// "Visible in no sections" => "Visible in no sections",
// "Remove section" => "Remove section",
// "Admin Contributions" => "Admin Contributions",
// "Edit the contribution" => "Edit the contribution",
// "Contributions are mandatory in wiki pages" => "Contributions are mandatory in wiki pages",
// "Contributions are mandatory in forums" => "Contributions are mandatory in forums",
// "Contributions are mandatory in comments" => "Contributions are mandatory in comments",
// "Contributions are mandatory in blogs" => "Contributions are mandatory in blogs",
// "Contributions are displayed in the comment/post" => "Contributions are displayed in the comment/post",
// "Create a new contribution" => "Create a new contribution",
// "List of contributions" => "List of contributions",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link" => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link",
// "Use Admin DSN to define the database to be used by the SQL plugin" => "Use Admin DSN to define the database to be used by the SQL plugin",
// "Admin External Wikis" => "Admin External Wikis",
// "Enable Features" => "Enable Features",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "Show threads preferences" => "Show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// ".." => "..",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature" => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>" => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a>",
// "mn" => "mn",
// "For wiki page, use ((PageName))" => "For wiki page, use ((PageName))",
// "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple sections with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR" => "Separate multiple permissions with a comma ( , ) for an AND or a vertical bar ( | ) for an OR",
// "Use Ctrl+Click to select multiple groups" => "Use Ctrl+Click to select multiple groups",
// "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each" => "Selecting 2 groups means that the option will be seen if the user belongs to the 2 groups. If you want the 2 groups to see the option, create 2 options with one group each",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'" => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu" => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format" => "To use a menu in a tiki format",
// "To use menu in a css/suckerfish format" => "To use menu in a css/suckerfish format",
// "To customize the menu's CSS id (#)" => "To customize the menu's CSS id (#)",
// "Folder Icon" => "Folder Icon",
// "Path and filename of closed folder icon" => "Path and filename of closed folder icon",
// "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder" => "To use custom folder icons in menus, enter the path to the icon for the <strong>closed</strong> folder",
// "In the same directory, include an icon for the opened folder" => "In the same directory, include an icon for the opened folder",
// "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>" => "The \"opened folder\" icon name must be identical to the \"closed folder\" icon name, prefixed with the letter <strong>o</strong>",
// "For example, the default icon is: pics/icons/folder.png" => "For example, the default icon is: pics/icons/folder.png",
// "The name of the \"open folder\" icon is: pics/icons/ofolder.png" => "The name of the \"open folder\" icon is: pics/icons/ofolder.png",
// "Assign/Edit modules" => "Assign/Edit modules",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y" => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme', 'notitle', 'nopage'). Separator between params:'&amp;'. E.g. maxlen=15&amp;nonums=y",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups" => "setting will override your selection of specific groups",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// "to make sure users will notice any newly assigned modules" => "to make sure users will notice any newly assigned modules",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site" => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site",
// "Use Wiki Structure" => "Use Wiki Structure",
// "Edit Newsletter" => "Edit Newsletter",
// "You can add several email addresses by separating them with commas" => "You can add several email addresses by separating them with commas",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Create Newsletter" => "Create Newsletter",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Drafts" => "Drafts",
// "Mail notifications" => "Mail notifications",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications" => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications",
// "Alert" => "Alert",
// "A user edits an article" => "A user edits an article",
// "A user deletes an article" => "A user deletes an article",
// "Preload Admin Account" => "Preload Admin Account",
// "User / Group" => "User / Group",
// "Multiple" => "Multiple",
// "Trackers Outbound Emails" => "Trackers Outbound Emails",
// "Forums Outbound Emails" => "Forums Outbound Emails",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Toggle Quick Options" => "Toggle Quick Options",
// "Add Option" => "Add Option",
// "Leave box empty for deleting an option" => "Leave box empty for deleting an option",
// "Votes older than these days are no more considered" => "Votes older than these days are no more considered",
// "0 for no limit" => "0 for no limit",
// "Span" => "Span",
// "Add poll to pages" => "Add poll to pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Lock the pages" => "Lock the pages",
// "Quicktags category filter" => "Quicktags category filter",
// "Tips" => "Tips",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed" => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed",
// "Edit this RSS Module" => "Edit this RSS Module",
// "Create new RSS Module" => "Create new RSS Module",
// "RSS channels" => "RSS channels",
// "Show Date" => "Show Date",
// "View feed" => "View feed",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>" => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>",
// "TikiWiki settings" => "TikiWiki settings",
// "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors" => "About WikiPlugins and security: Make sure to only grant the \"tiki_p_plugin_approve\" permission to trusted editors",
// "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)" => "You can deactivate risky plugins at (<a href=\"tiki-admin.php?page=textarea\">tiki-admin.php?page=textarea</a>)",
// "Security checks" => "Security checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments" => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments",
// "See end of table for detailed explanations" => "See end of table for detailed explanations",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results" => "What to do with these check results",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"" => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content" => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information" => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes" => "Inodes that are not files or directories are not part of tiki. Review these Inodes",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod" => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod",
// "The structure" => "The structure",
// "has just been created" => "has just been created",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict",
// "The following pages have automatically been categorized with the same categories as the structure" => "The following pages have automatically been categorized with the same categories as the structure",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent",
// "Edit structure" => "Edit structure",
// "View structure" => "View structure",
// "PDF" => "PDF",
// "Xml Zip" => "Xml Zip",
// "Add a New Question" => "Add a New Question",
// "This survey stats" => "This survey stats",
// "Edit Survey Question" => "Edit Survey Question",
// "Add a New Question to this survey" => "Add a New Question to this survey",
// "Multiple choices of thumbnails from a file gallery" => "Multiple choices of thumbnails from a file gallery",
// "Wiki textarea" => "Wiki textarea",
// "Answer is mandatory" => "Answer is mandatory",
// "Number of required answers (for multiple choices)" => "Number of required answers (for multiple choices)",
// "Min" => "Min",
// "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots",
// "For a rate, you can give the maximum value" => "For a rate, you can give the maximum value",
// "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4" => "For the 'multiple choices of thumbnail from a file gallery' type, options are: Gallery ID. Example: 4",
// "Tiki Cache/System Admin" => "Tiki Cache/System Admin",
// "Exterminator of cached content" => "Exterminator of cached content",
// "Directory to exterminate" => "Directory to exterminate",
// "Clear all Tiki caches" => "Clear all Tiki caches",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save" => "Directories to save",
// "Full Path to the Zip File" => "Full Path to the Zip File",
// "Generate a zip of those directories" => "Generate a zip of those directories",
// "A zip has been written to {\$zipPath}" => "A zip has been written to {\$zipPath}",
// "Directory is not writeable" => "Directory is not writeable",
// "Advanced feature" => "Advanced feature",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed" => "Select list items that will be displayed",
// "Multilingual content" => "Multilingual content",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden" => "Field is hidden",
// "not hidden" => "not hidden",
// "visible to admin only" => "visible to admin only",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by" => "Visible by",
// "Editable by" => "Editable by",
// "Description text is wiki-parsed" => "Description text is wiki-parsed",
// "Error message" => "Error message",
// "Export fieldId also" => "Export fieldId also",
// "Check the box to re-import in this tracker and change the fields" => "Check the box to re-import in this tracker and change the fields",
// "Uncheck the box to import in another database" => "Uncheck the box to import in another database",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Create Tracker" => "Create Tracker",
// "Duplicate Tracker" => "Duplicate Tracker",
// "trackers" => "trackers",
// "with" => "with",
// "Create/Edit Tracker" => "Create/Edit Tracker",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Create a group for each item" => "Create a group for each item",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique\nfor a tracker and they must be valid in SQL",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Format if not the default short one" => "Format if not the default short one",
// "Show creation date when viewing tracker item" => "Show creation date when viewing tracker item",
// "Show lastModif date when viewing tracker item" => "Show lastModif date when viewing tracker item",
// "ItemId" => "ItemId",
// "and display last comment user/date" => "and display last comment user/date",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "Do not show empty fields in item view" => "Do not show empty fields in item view",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items",
// "Group of users alerted when tracker is modified" => "Group of users alerted when tracker is modified",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)" => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Create Item" => "Create Item",
// "Choose a field .." => "Choose a field ..",
// "Remove from Group" => "Remove from Group",
// "Add to group" => "Add to group",
// "Download CSV export" => "Download CSV export",
// "Assign users to group" => "Assign users to group",
// "Each user in the file must already exist" => "Each user in the file must already exist",
// "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>" => "To create users or/and assign them to groups, got to <a href=\"tiki-adminusers.php\">admin->users</a>",
// "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login" => "Since this tiki site is in slave mode and import groups, the master groups will be automatically reimported at each login",
// "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login" => "Since this tiki site is in slave mode and import preferences, the master user preferences will be automatically reimported at each login",
// "Updated users" => "Updated users",
// "Group (direct)" => "Group (direct)",
// "ago" => "ago",
// "Need to validate email" => "Need to validate email",
// "Assign to group" => "Assign to group",
// "Edit Included Group" => "Edit Included Group",
// "Edit Group" => "Edit Group",
// "Validate user" => "Validate user",
// "Send a wiki page by Email" => "Send a wiki page by Email",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Template wiki page" => "Template wiki page",
// "Assign user to Groups" => "Assign user to Groups",
// "Use the email as username" => "Use the email as username",
// "Lowercase only" => "Lowercase only",
// "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)" => "Warning: changing the username could require the user to change his password (for user registered with an old tikiwiki&lt;=1.8)",
// "Warning: it will mess with slave intertiki sites that use this one as master" => "Warning: it will mess with slave intertiki sites that use this one as master",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth" => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth",
// "Repeat Password" => "Repeat Password",
// "User must change password at first login" => "User must change password at first login",
// "Send an email to the user in order to allow him to validate his account" => "Send an email to the user in order to allow him to validate his account",
// "Last Login" => "Last Login",
// "You do not have permission to edit this user" => "You do not have permission to edit this user",
// "Overwrite but keep the previous login if the login exists in another case" => "Overwrite but keep the previous login if the login exists in another case",
// "Don't overwrite" => "Don't overwrite",
// "Overwrite groups" => "Overwrite groups",
// "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>" => "You can export users of a group in <a href=\"tiki-admingroups.php\">admin->groups->a_group</a>",
// "Loading.." => "Loading..",
// "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences" => "More languages are available. To view them, update languages you can read from <a href=\"tiki-user_preferences.php\">user preferences</a> or your browser's preferences",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Show Help" => "Show Help",
// "Article type" => "Article type",
// "Actions on this article type" => "Actions on this article type",
// "inherited from" => "inherited from",
// "inherited" => "inherited",
// "Level configuration" => "Level configuration",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "Convert the last sub directory to a sub gallery" => "Convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "Browse File Gallery" => "Browse File Gallery",
// "Please do not use this feature to upload data into the database" => "Please do not use this feature to upload data into the database",
// "available files" => "available files",
// "Select a File Gallery" => "Select a File Gallery",
// "Process files" => "Process files",
// "Use Wysiwyg Editor" => "Use Wysiwyg Editor",
// "Use Normal Editor" => "Use Normal Editor",
// "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. ",
// "Report to Webmaster" => "Report to Webmaster",
// "The TikiWiki Community" => "The TikiWiki Community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "database queries used in " => "database queries used in ",
// "Last update from SVN" => "Last update from SVN",
// "Watch Only This Category" => "Watch Only This Category",
// "Watch This Category and Their Descendants" => "Watch This Category and Their Descendants",
// "Stop Watching Only This Category" => "Stop Watching Only This Category",
// "Stop Watching This Category and Their Descendants" => "Stop Watching This Category and Their Descendants",
// "in the current category - and its subcategories: " => "in the current category - and its subcategories: ",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "\$feature_label" => "\$feature_label",
// "results found" => "results found",
// "All Images" => "All Images",
// "You can view this gallery's configured image (first, random, etc.) in your browser using" => "You can view this gallery's configured image (first, random, etc.) in your browser using",
// "You can include the gallery's image in an HTML page using one of these lines" => "You can include the gallery's image in an HTML page using one of these lines",
// "Cyclic" => "Cyclic",
// "Admin Calendar" => "Admin Calendar",
// "Export Calendars" => "Export Calendars",
// "Click to export calendars" => "Click to export calendars",
// "Visible Calendars" => "Visible Calendars",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Export calendars" => "Export calendars",
// "advanced parameters" => "advanced parameters",
// "Edit event" => "Edit event",
// "Delete event" => "Delete event",
// "View event" => "View event",
// "All-Day" => "All-Day",
// "Website" => "Website",
// "View this Week" => "View this Week",
// "View this Day" => "View this Day",
// "o" => "o",
// "Calendar Item" => "Calendar Item",
// "New event" => "New event",
// "Recurrence" => "Recurrence",
// "This event depends on a recurrence rule" => "This event depends on a recurrence rule",
// "This event is not recurrent" => "This event is not recurrent",
// "On a weekly basis" => "On a weekly basis",
// "Each" => "Each",
// "of the week" => "of the week",
// "On a monthly basis" => "On a monthly basis",
// "of the month" => "of the month",
// "On a yearly basis" => "On a yearly basis",
// "There's no such date as" => "There's no such date as",
// "Starting on" => "Starting on",
// "ending by" => "ending by",
// "ending after" => "ending after",
// "events" => "events",
// "Start period" => "Start period",
// "End after" => "End after",
// "occurrences" => "occurrences",
// "End before" => "End before",
// "Event is repeated" => "Event is repeated",
// "every" => "every",
// "of every month" => "of every month",
// "on each" => "on each",
// "Date and time of end" => "Date and time of end",
// "Events cannot end before they start" => "Events cannot end before they start",
// "or new" => "or new",
// "Choose users to alert" => "Choose users to alert",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"" => "If no role is provided, default role will be \"Chair participant\"",
// "Update this event only" => "Update this event only",
// "Update every unchanged events of this recurrence rule" => "Update every unchanged events of this recurrence rule",
// "Update every events of this recurrence rule" => "Update every events of this recurrence rule",
// "Delete Recurrent events" => "Delete Recurrent events",
// "Avanced parameters for iCal export" => "Avanced parameters for iCal export",
// "Calendars to be exported" => "Calendars to be exported",
// "Categories checking is not done in the database search" => "Categories checking is not done in the database search",
// "Perform action with checked" => "Perform action with checked",
// "Your account has been validated" => "Your account has been validated",
// "You have to choose a password to use this account" => "You have to choose a password to use this account",
// "Change your password" => "Change your password",
// "Send another message" => "Send another message",
// "Publish this contact to groups" => "Publish this contact to groups",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>" => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>",
// "The following site was added, but may require validation by the admin before appearing on the lists" => "The following site was added, but may require validation by the admin before appearing on the lists",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "Directory Categories" => "Directory Categories",
// "Use Ctrl+Click to select multiple directory categories" => "Use Ctrl+Click to select multiple directory categories",
// "Parent directory category" => "Parent directory category",
// "Allow sites in this directory category" => "Allow sites in this directory category",
// "Show number of sites in this directory category" => "Show number of sites in this directory category",
// "Directory Subcategories" => "Directory Subcategories",
// "Admin related directory categories" => "Admin related directory categories",
// "Directory Category" => "Directory Category",
// "Use Ctrl+Click to select multiple categories" => "Use Ctrl+Click to select multiple categories",
// "Perform action with selected" => "Perform action with selected",
// "Add a Directory Category" => "Add a Directory Category",
// "in current directory category" => "in current directory category",
// "Related directory categories" => "Related directory categories",
// "Total directory categories" => "Total directory categories",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Max clicks" => "Max clicks",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie Size" => "Movie Size",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "A category is mandatory" => "A category is mandatory",
// "The file will be saved in" => "The file will be saved in",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki+Page+Editor\" target=\"tikihelp\" class=\"tikihelp\" title=\"{tr}Wiki Page Editor",
// "More help on editing wiki pages" => "More help on editing wiki pages",
// "Wiki Syntax" => "Wiki Syntax",
// "The syntax system used for creating pages in TikiWiki" => "The syntax system used for creating pages in TikiWiki",
// "Bold text" => "Bold text",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Underlined text" => "Underlined text",
// "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background" => "Will display using the indicated HTML color or color name. Color name can contain two colors separated by a comma. In this case, the first color would be the foreground and the second one the background",
// "Deleted text" => "Deleted text",
// "2 dashes" => "2 dashes",
// "Autonumbered Headings" => "Autonumbered Headings",
// "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "{literal}{toc}{/literal}, {literal}{maketoc}{/literal} prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Horizontal rule" => "Horizontal rule",
// "Text box" => "Text box",
// "Centered text" => "Centered text",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)" => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus (useful in list to continue at the same level)" => "Creates an indentation for each plus (useful in list to continue at the same level)",
// "row" => "row",
// "col" => "col",
// "Monospace font" => "Monospace font",
// "Code sample" => "Code sample",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text" => "~pp~ data ~/pp~ Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  ~pre~ data ~/pre~ also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text",
// "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar" => "~tc~ Tiki Comment ~/tc~ makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  ~hc~ HTML Comment ~/hc~ makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew" => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew",
// "Special characters" => "Special characters",
// "hard space" => "hard space",
// "numeric between ~ for html numeric characters entity" => "numeric between ~ for html numeric characters entity",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines" => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line" => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line",
// "Wiki plugins extend the function of wiki syntax with more specialized commands" => "Wiki plugins extend the function of wiki syntax with more specialized commands",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt",
// "text, bold" => "text, bold",
// "text, italic" => "text, italic",
// "text, underline" => "text, underline",
// "horizontal rule" => "horizontal rule",
// "Add image from File Gallery" => "Add image from File Gallery",
// "quote" => "quote",
// "flash" => "flash",
// "{\$label}" => "{\$label}",
// "Add Image from File Gallery" => "Add Image from File Gallery",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Upload from disk to change the image" => "Upload from disk to change the image",
// "Save and Go Next" => "Save and Go Next",
// "Im-Export Languages" => "Im-Export Languages",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Edit quiz results" => "Edit quiz results",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one" => "The page already exists. The page that has been added to the structure is the existing one",
// "The following pages added have automatically been categorized with the same categories as the structure" => "The following pages added have automatically been categorized with the same categories as the structure",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering" => "If you go to edit this (or any other TPL file) file via the Tiki built-in TPL editor below, all the javascript can be sanitized or completely stripped out by Tiki security filtering",
// "This would cause you problems (e.g. menus can stop collapsing/expanding)" => "This would cause you problems (e.g. menus can stop collapsing/expanding)",
// "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)" => "You should only modify default header.tpl and other important files via text code editor, through console, or SSH, or FTP edit commands. And only if you know what you are doing ! ;-)",
// "Maybe You just want to modify the top of your Tiki site" => "Maybe You just want to modify the top of your Tiki site",
// "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface" => "Please consider using the Look &amp; Feel preferences custom code areas or modify tiki-top_bar.tpl which you can do safely via the web-based interface",
// "Save Only in the Theme" => "Save Only in the Theme",
// "Delete the copy in the theme" => "Delete the copy in the theme",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "View Page" => "View Page",
// "View Article" => "View Article",
// "Language of newly translated page" => "Language of newly translated page",
// "Unspecified" => "Unspecified",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"" => "\"You forgot to specify the language of the translation. Please choose a language in the picklist.\"",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "Change language for this page" => "Change language for this page",
// "Select from available options.." => "Select from available options..",
// "Change Language" => "Change Language",
// "No language is assigned to this page" => "No language is assigned to this page",
// "Please select a language before performing translation" => "Please select a language before performing translation",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits" => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits",
// "Update '{\$page}'" => "Update '{\$page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval" => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval",
// "This is a new staging page that has not been approved before" => "This is a new staging page that has not been approved before",
// "The current staging copy may contain changes that have yet to be approved" => "The current staging copy may contain changes that have yet to be approved",
// "View changes since last approval" => "View changes since last approval",
// "You are editing the approved copy of this page" => "You are editing the approved copy of this page",
// "There are currently changes in the staging copy that have yet to be approved" => "There are currently changes in the staging copy that have yet to be approved",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead" => "instead",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for" => "Perhaps you are looking for",
// "Change the style used to display differences to be translated" => "Change the style used to display differences to be translated",
// "Change diff styles" => "Change diff styles",
// "This edit session will expire in {\$edittimeout} minutes" => "This edit session will expire in {\$edittimeout} minutes",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer" => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer",
// "Switch to WYSIWYG editor" => "Switch to WYSIWYG editor",
// "Switch to normal (wiki) editor" => "Switch to normal (wiki) editor",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "Disable" => "Disable",
// "or use" => "or use",
// "AutoSave" => "AutoSave",
// "If you want the saved version instead of the autosaved one" => "If you want the saved version instead of the autosaved one",
// "Regex search " => "Regex search ",
// "Replace to" => "Replace to",
// "Case Insensitivity" => "Case Insensitivity",
// "My Footnotes" => "My Footnotes",
// "Translation request" => "Translation request",
// "Send urgent translation request" => "Send urgent translation request",
// "Edit Comment" => "Edit Comment",
// "Monitor this page" => "Monitor this page",
// "Add another image" => "Add another image",
// "Lock this page" => "Lock this page",
// "List Sheets" => "List Sheets",
// "Export to file" => "Export to file",
// "Format" => "Format",
// "Autodetect" => "Autodetect",
// "Export Tracker Items" => "Export Tracker Items",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse as Wiki Text" => "Parse as Wiki Text",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "These fields" => "These fields",
// "Use Ctrl+Click to select multiple fields" => "Use Ctrl+Click to select multiple fields",
// "Dump All Tracker Items" => "Dump All Tracker Items",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "Be careful to set the right permissions on the files you link to" => "Be careful to set the right permissions on the files you link to",
// "Create New File Gallery" => "Create New File Gallery",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>" => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred" => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into" => "Which Forum Do You Wish to Import this Into",
// "Message queue for forum" => "Message queue for forum",
// "Back to forum" => "Back to forum",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Reported messages for forum" => "Reported messages for forum",
// "No records to display" => "No records to display",
// "Perfom action with checked" => "Perfom action with checked",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag" => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag",
// "Until then, they cannot be translated" => "Until then, they cannot be translated",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "Cancel friendship request" => "Cancel friendship request",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Global default" => "Global default",
// "Google Map Locator" => "Google Map Locator",
// "Save clicked point" => "Save clicked point",
// "Reset view to default" => "Reset view to default",
// "Save current view as default" => "Save current view as default",
// "Center map to saved point" => "Center map to saved point",
// "Reset view to site default" => "Reset view to site default",
// "Users Map" => "Users Map",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "XML Zip" => "XML Zip",
// "Tiki installer" => "Tiki installer",
// "Welcome" => "Welcome",
// "Welcome to the Tiki installation and upgrade script" => "Welcome to the Tiki installation and upgrade script",
// "Use this script to install a new Tiki database or upgrade your existing database to release" => "Use this script to install a new Tiki database or upgrade your existing database to release",
// "For the latest information about this release, please read the" => "For the latest information about this release, please read the",
// "Release Notes" => "Release Notes",
// "For complete documentation, please visit" => "For complete documentation, please visit",
// "For more information about Tiki, please visit" => "For more information about Tiki, please visit",
// "Select your language" => "Select your language",
// "Read the License" => "Read the License",
// "Tiki is software distributed under the LGPL license" => "Tiki is software distributed under the LGPL license",
// " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>" => " <a href=\"http://creativecommons.org/licenses/LGPL/2.1/\" target=\"_blank\">Here is a human-readable summary of the license below, including many translations.</a>",
// "Review the System Requirements" => "Review the System Requirements",
// "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements" => "Before installing Tiki, <a href=\"http://doc.tikiwiki.org/tiki-index.php?page=Requirements+and+Setup&bl=y\" target=\"_blank\">review the documentation</a> and confirm that your system meets the minimum requirements",
// "This installer will perform some basic checks automatically" => "This installer will perform some basic checks automatically",
// "Memory" => "Memory",
// "Success" => "Success",
// "Tiki has not detected your PHP memory_limit" => "Tiki has not detected your PHP memory_limit",
// "This probably means you have no set limit (all is well)" => "This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution" => "Tiki requires <strong>at least</strong> 32MB of PHP memory for script execution",
// "Allocating too little memory will cause Tiki to display blank pages" => "Allocating too little memory will cause Tiki to display blank pages",
// "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver" => "To change the memory limit, use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 32M) and restart your webserver",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "Mail" => "Mail",
// "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages" => "Tiki uses the PHP <strong>mail</strong> function to send email notifications and messages",
// "To test your system configuration, Tiki will attempt to send a test message to you" => "To test your system configuration, Tiki will attempt to send a test message to you",
// "Test email" => "Test email",
// "Email address to send test to" => "Email address to send test to",
// "Copy test mail to " => "Copy test mail to ",
// "Send Test Message" => "Send Test Message",
// "Tiki was able to send a test message to" => "Tiki was able to send a test message to",
// "Tiki was not able to send a test message" => "Tiki was not able to send a test message",
// "Review your mail log for details" => "Review your mail log for details",
// "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)" => "Review the mail settings in your <strong>php.ini</strong> file (for example: confirm that the <strong>sendmail_path</strong> is correct)",
// "If your host requires SMTP authentication, additional configuration may be necessary" => "If your host requires SMTP authentication, additional configuration may be necessary",
// "Image Processing" => "Image Processing",
// "Tiki detected" => "Tiki detected",
// "Tiki was not able to detect the GD library" => "Tiki was not able to detect the GD library",
// "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support" => "Tiki uses the GD library to process images for the Image Gallery and CAPTCHA support",
// "Set the Database Connection" => "Set the Database Connection",
// "Tiki requires an active database connection" => "Tiki requires an active database connection",
// "You must create the database and user <em>before</em> completing this page" => "You must create the database and user <em>before</em> completing this page",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "This is normal for a new installation" => "This is normal for a new installation",
// "Tiki found an existing database connection in your local.php file" => "Tiki found an existing database connection in your local.php file",
// "Use Existing Connection" => "Use Existing Connection",
// "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>" => "Use this page to create a new database connection, or use the <a href=\"http://doc.tikiwiki.org/Manual+Installation\" target=\"_blank\" title=\"manual installation\">manual installation process</a>",
// "Database information" => "Database information",
// "Enter your database connection information" => "Enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki" => "Select the type of database to use with Tiki",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension" => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension",
// "Host name" => "Host name",
// "Enter the host name or IP for your database" => "Enter the host name or IP for your database",
// "Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use" => "Enter the name of the database that Tiki will use",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your hosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database user" => "Database user",
// "Enter a database user with administrator permission for the Database" => "Enter a database user with administrator permission for the Database",
// "User name" => "User name",
// "Install &amp; Update Profile" => "Install &amp; Update Profile",
// "Install Profile" => "Install Profile",
// "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page" => "Failed to set max_execution_time to 0 for PHP. You may experience problems when creating/upgrading the database on a slow system. This will manitest itself by a blank page",
// "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database" => "Select the installation (or upgrade) profile to use. This profile will populate (or upgrade) the database",
// "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>" => "If you want to upgrade from a previous Tiki release, ensure that you have read and understood the <a href=\"http://doc.tikiwiki.org/Upgrade\" target=\"_blank\">Upgrade instructions</a>",
// "Select the installation profile to use. This profile will populate the database" => "Select the installation profile to use. This profile will populate the database",
// "Profiles can be used to pre-configure your site with specific features and settings" => "Profiles can be used to pre-configure your site with specific features and settings",
// "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information" => "Visit <a href=\"http://profiles.tikiwiki.org\" target=\"_blank\">http://profiles.tikiwiki.org</a> for more information",
// "Reinstall the database" => "Reinstall the database",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "Bare-bones default install" => "Bare-bones default install",
// "Personal Blog and Profile" => "Personal Blog and Profile",
// "Small Organization Web Presence" => "Small Organization Web Presence",
// "Company Intranet" => "Company Intranet",
// "Collaborative community" => "Collaborative community",
// "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles" => "See the documentation for <a target=\"_blank\" href=\"http://profiles.tikiwiki.org/Profiles_in_30_installer\" class=\"link\" title=\"Description of available profiles.\">descriptions of the available profiles",
// "The installer could not connect to the Profiles repository" => "The installer could not connect to the Profiles repository",
// "The default installation profile will be used" => "The default installation profile will be used",
// "Upgrade" => "Upgrade",
// "Automatically upgrade your existing database to v" => "Automatically upgrade your existing database to v",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Review the Upgrade" => "Review the Upgrade",
// "Review the Installation" => "Review the Installation",
// "Upgrade complete" => "Upgrade complete",
// "Installation complete" => "Installation complete",
// "Your database has been configured and Tiki is ready to run" => "Your database has been configured and Tiki is ready to run",
// "If this is your first install, your admin password is <strong>admin</strong>" => "If this is your first install, your admin password is <strong>admin</strong>",
// "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application" => "You can now log in into Tiki as user <strong>admin</strong> and start configuring the application",
// "Upgrade operations executed successfully" => "Upgrade operations executed successfully",
// "Installation operations executed successfully" => "Installation operations executed successfully",
// "SQL queries" => "SQL queries",
// "Database was left unchanged" => "Database was left unchanged",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages" => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages",
// ".htaccess File" => ".htaccess File",
// "We recommend enabling the <strong>.htaccess</strong> file for your Tiki" => "We recommend enabling the <strong>.htaccess</strong> file for your Tiki",
// "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security" => "This will enable you to use SEFURLs (search engine friendly URLs) and help improve site security",
// "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>" => "To enable this file, simply rename the <strong>_htaccess</strong> file (located in the main directory of your Tiki installation) to <strong>.htaccess</strong>",
// "Complete these fields to configure common, general settings for your site" => "Complete these fields to configure common, general settings for your site",
// "The information you enter here can be changed later" => "The information you enter here can be changed later",
// "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings" => "Refer to the <a href=\"http://doc.tikiwiki.org/Admin+Panels\" target=\"_blank\">documentation</a> for complete information on these, and other, settings",
// "This will appear in the browser title bar" => "This will appear in the browser title bar",
// "Email sent by your site will use this address" => "Email sent by your site will use this address",
// "Secure Login" => "Secure Login",
// "HTTPS login" => "HTTPS login",
// "Administrator" => "Administrator",
// "Admin email" => "Admin email",
// "This is the email address for your administrator account" => "This is the email address for your administrator account",
// "Enter Your Tiki" => "Enter Your Tiki",
// "The installation is complete" => "The installation is complete",
// "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>" => "Tiki is an opensource project, <em>you</em> can <a href='http://info.tikiwiki.org/Join+the+Community' target='_blank'>join the community</a> and help <a href='http://info.tikiwiki.org/tiki-index.php?page=Develop+Tiki' target='_blank'>develop Tiki</a>",
// "Installation" => "Installation",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu" => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu",
// "Enter Tiki and Lock Installer" => "Enter Tiki and Lock Installer",
// "Recommended" => "Recommended",
// "Enter Tiki Without Locking Installer" => "Enter Tiki Without Locking Installer",
// "MultiTiki Setup" => "MultiTiki Setup",
// "Default Installation" => "Default Installation",
// "DB OK" => "DB OK",
// "No DB" => "No DB",
// "Adding a new host" => "Adding a new host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Are you upgrading an existing Tiki site" => "Are you upgrading an existing Tiki site",
// "Go directly to the <strong>Install/Upgrade</strong> step" => "Go directly to the <strong>Install/Upgrade</strong> step",
// "Install/Upgrade" => "Install/Upgrade",
// "Restart the installer" => "Restart the installer",
// "Database Connection" => "Database Connection",
// "Reset the Database Connection" => "Reset the Database Connection",
// "Configure the General Settings" => "Configure the General Settings",
// "Tiki Icon" => "Tiki Icon",
// "TikiWiki Project Web Site" => "TikiWiki Project Web Site",
// "Support Forums" => "Support Forums",
// "TikiWiki CMS/Groupware Project" => "TikiWiki CMS/Groupware Project",
// "Powered by TikiWiki" => "Powered by TikiWiki",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "Last 2 days" => "Last 2 days",
// "Last 3 days" => "Last 3 days",
// "Last 5 days" => "Last 5 days",
// "Last week" => "Last week",
// "Last 2 weeks" => "Last 2 weeks",
// "Last month" => "Last month",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone" => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone",
// "Max Clicks" => "Max Clicks",
// "The cache is used by" => "The cache is used by",
// "Approval" => "Approval",
// "Rejected" => "Rejected",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block" => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block" => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "SlideShow" => "SlideShow",
// "Keep gallery window open" => "Keep gallery window open",
// "Your comment" => "Your comment",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "users registered" => "users registered",
// "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on" => "Those movies are very good tutorials of tikiwiki use. They have been generated by siridhar with camtasia studio for public use ! Thanks to him. The up-to-date list of movies is on",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Status of the page" => "Status of the page",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl" => "Backl",
// "Page size" => "Page size",
// " {if \$find ne ''}and {/if}starting with" => " {if \$find ne ''}and {/if}starting with",
// "offline" => "offline",
// "Back to admin" => "Back to admin",
// "For security purposes we must periodically validate your email address to allow continued access to this site" => "For security purposes we must periodically validate your email address to allow continued access to this site",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site" => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site",
// "Thank you" => "Thank you",
// "This is an experimental feature" => "This is an experimental feature",
// "Requires" => "Requires",
// "Not Enabled" => "Not Enabled",
// "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/" => "Missing dependency. Obtain <a href=\"http://tikiwiki.org/tiki-download_file.php?fileId=50\">visorFreemind.swf</a> and upload it in files/",
// "Mods Configuration" => "Mods Configuration",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>" => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>",
// "Tiki \"mods\" are undergoing refurbishment" => "Tiki \"mods\" are undergoing refurbishment",
// "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification" => "You will probably some find mods shown as being compatible with older versions of Tiki will work with later versions with little or no modification",
// "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more" => "Your help is needed! Please visit <a href=\"http://dev.tikiwiki.org/tiki-index.php?page=Mods\">dev.tikiwiki.org</a> to find out more",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)" => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"sh setup.sh\" for example)",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")" => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"sh setup.sh open\" to set it up). After installation you need to remove that permission (using \"sh setup.sh\")",
// "for version" => "for version",
// "all versions" => "all versions",
// "or later" => "or later",
// "No mods found" => "No mods found",
// "licence" => "licence",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "y" => "y",
// "My Articles" => "My Articles",
// "User Articles" => "User Articles",
// "My User Items" => "My User Items",
// "User Items" => "User Items",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "My Infos" => "My Infos",
// "Contacts Preferences" => "Contacts Preferences",
// "My Contacts" => "My Contacts",
// "My Wiki Pages" => "My Wiki Pages",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "Removal of your email address failed" => "Removal of your email address failed",
// "Subscription failed" => "Subscription failed",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "Object Watches" => "Object Watches",
// "Watching Groups" => "Watching Groups",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object" => "These permissions override any global permissions or category permissions affecting this object",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>" => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply" => "These permissions do not apply. Special permissions apply",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure" => "and also to all pages of the sub-structure",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier" => "However, no account is associated to the OpenID identifier",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts" => "Your identity gives you access to multiple user accounts",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "File (only .gif, .jpg and .png images approximately 45px × 45px)" => "File (only .gif, .jpg and .png images approximately 45px × 45px)",
// "Plugin execution was denied" => "Plugin execution was denied",
// "Plugin execution pending approval" => "Plugin execution pending approval",
// "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected" => "After argument validation by an editor, the execution of this plugin was denied. This plugin will eventually be removed or corrected",
// "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible" => "This plugin was recently added or modified. Until an editor of the site validates the parameters, execution will not be possible",
// "You are allowed to" => "You are allowed to",
// "View arguments" => "View arguments",
// "Execute the plugin in preview mode (may be dangerous)" => "Execute the plugin in preview mode (may be dangerous)",
// "Approve the plugin for public execution" => "Approve the plugin for public execution",
// "View Details" => "View Details",
// "This plugin does not contain any arguments" => "This plugin does not contain any arguments",
// "This plugin's body is empty" => "This plugin's body is empty",
// "Any" => "Any",
// "Items found" => "Items found",
// "Sum" => "Sum",
// "Plugin Approval" => "Plugin Approval",
// "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups" => "For security, grant the <strong>tiki_p_plugin_approve</strong> permission only to trusted user groups",
// "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins" => "Use the <a href=\"tiki-admin.php?page=textarea\">Admin: Text Area page</a> to deactivate potentially risky plugins",
// "This page lists the plugins that require validation, the first time they are encountered" => "This page lists the plugins that require validation, the first time they are encountered",
// "Each plugin contains a unique <em>signature</em> that is preserved" => "Each plugin contains a unique <em>signature</em> that is preserved",
// "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list" => "If a plugin is no longer in use (for example, it has been removed from the wiki page), use <strong>Clear</strong> to remove it from this list",
// "The plugin will automatically be added if it is encountered" => "The plugin will automatically be added if it is encountered",
// "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin" => "Plugins can be individually previewed, approved, or rejected from the particular location that contains the plugin",
// "For security, you should review each plugin to ensure it is safe to approve" => "For security, you should review each plugin to ensure it is safe to approve",
// "Plugin" => "Plugin",
// "Added By" => "Added By",
// "Signature" => "Signature",
// "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "Wiki page: <a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page" => "<a href=\"%0#{\$plugin.fingerprint}\" title=\"{tr}View this page",
// "Approve all pending plugins" => "Approve all pending plugins",
// "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins" => "Using <strong>Approve</strong> or <strong>Approve All</strong> will approve and activate the pending plugins",
// "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe" => "Use this feature <strong>only</strong> if you have verified that all the pending plugins are safe",
// "No plugins pending approval" => "No plugins pending approval",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Edit Poll" => "Edit Poll",
// "Find the poll" => "Find the poll",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Vote range displayed" => "Vote range displayed",
// "All votes with no span consideration" => "All votes with no span consideration",
// "All votes with span consideration" => "All votes with span consideration",
// "All votes" => "All votes",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles" => "Permission denied. You do not have permission to read complete articles",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected" => "No pages selected",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Rank" => "Rank",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "List all articles of this same topic" => "List all articles of this same topic",
// "Received Pages" => "Received Pages",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist" => "The highlight pages already exist",
// "Please, change the name if you want the page to be uploaded" => "Please, change the name if you want the page to be uploaded",
// "Received Structures" => "Received Structures",
// "Prefix the checked" => "Prefix the checked",
// "Postfix the checked" => "Postfix the checked",
// "Use your email as login" => "Use your email as login",
// "Minimum {\$prefs.min_username_length} characters long" => "Minimum {\$prefs.min_username_length} characters long",
// "Passcode to register" => "Passcode to register",
// "Not your password" => "Not your password",
// "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}" => "To request a passcode, {if \$prefs.feature_contact eq 'y'}<a href=\"tiki-contact.php\">{/if}\n\tcontact the sytem administrator{if \$prefs.feature_contact eq 'y'}</a>{/if}",
// "Generate a\tpassword" => "Generate a\tpassword",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter",
// "Enter your username or email" => "Enter your username or email",
// "Enter your email" => "Enter your email",
// "Request Password Reset" => "Request Password Reset",
// "Back to page" => "Back to page",
// "to version" => "to version",
// "\$name" => "\$name",
// "Faqs" => "Faqs",
// "Blogs Post" => "Blogs Post",
// "Date Search" => "Date Search",
// "All dates" => "All dates",
// "Calendar Items" => "Calendar Items",
// "Please Confirm" => "Please Confirm",
// "octets" => "octets",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Attached Files" => "Attached Files",
// "To add a file, click here" => "To add a file, click here",
// "Save as Draft" => "Save as Draft",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page" => "the approved version of this page",
// "Viewing of changes since last approval is possible only after first approval" => "Viewing of changes since last approval is possible only after first approval",
// "Approve changes" => "Approve changes",
// "Latest changes will be synchronized after approval" => "Latest changes will be synchronized after approval",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time" => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time",
// "Content may be out of date" => "Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages",
// "TOC" => "TOC",
// "page: %0/%1" => "page: %0/%1",
// "Page last modified on %0 by %1" => "Page last modified on %0 by %1",
// "Created by %0" => "Created by %0",
// "Last Modification: %0 by %1" => "Last Modification: %0 by %1",
// "You will not see the latest queries" => "You will not see the latest queries",
// "Clean" => "Clean",
// "Params" => "Params",
// "Most viewed objects" => "Most viewed objects",
// "Most viewed objects in the last 7 days" => "Most viewed objects in the last 7 days",
// "Date of first pageview" => "Date of first pageview",
// "Days since first pageview" => "Days since first pageview",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "Usage chart" => "Usage chart",
// "Usage chart image" => "Usage chart image",
// "Daily Usage" => "Daily Usage",
// "Tiki Logs" => "Tiki Logs",
// "Clean logs older than" => "Clean logs older than",
// "months" => "months",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses" => "The link was sent to the following addresses",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma" => "Separate multiple email addresses with a comma",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like" => "I found an interesting page that I thought you would like",
// "TikiTests Edit" => "TikiTests Edit",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request" => "Request",
// "Element to compare (Xpath expression)" => "Element to compare (Xpath expression)",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "TikiTests List" => "TikiTests List",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "PECL HTTP extension present" => "PECL HTTP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible" => "PECL HTTP and cURL extension not present. Replay of the TikiTest will not be possible",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "TikiTests Record Configuration" => "TikiTests Record Configuration",
// "Start Recording Test" => "Start Recording Test",
// "TikiTests Replay Configuration" => "TikiTests Replay Configuration",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "Theme Control Center: Categories" => "Theme Control Center: Categories",
// "Theme Control Center: Sections" => "Theme Control Center: Sections",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Unzip zip files" => "Unzip zip files",
// "Author if not the file creator" => "Author if not the file creator",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "Add File" => "Add File",
// "Maximum file size is limited to" => "Maximum file size is limited to",
// "No gallery available" => "No gallery available",
// "Uploading file.." => "Uploading file..",
// "No File to Upload.." => "No File to Upload..",
// "The column is disabled" => "The column is disabled",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "(non public)" => "(non public)",
// "System" => "System",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Forum comments" => "Forum comments",
// "Toggle" => "Toggle",
// "Male" => "Male",
// "Female" => "Female",
// "Use Google Map locator" => "Use Google Map locator",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages" => "Can you read more languages",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language.." => "Select language..",
// "Displays users' info tooltip on mouseover for every user who allows his information to be public" => "Displays users' info tooltip on mouseover for every user who allows his information to be public",
// "My user items" => "My user items",
// "My level" => "My level",
// "You are not allowed to remove this notification " => "You are not allowed to remove this notification ",
// "Use \"watches\" to monitor wiki pages or other objects" => "Use \"watches\" to monitor wiki pages or other objects",
// "Watch new items by clicking the {icon _id=eye} button on specific pages" => "Watch new items by clicking the {icon _id=eye} button on specific pages",
// "Select event type" => "Select event type",
// "All watched events" => "All watched events",
// "A user edited an article" => "A user edited an article",
// "A user deleted an article" => "A user deleted an article",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Used space" => "Used space",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "No articles yet" => "No articles yet",
// "Add an article" => "Add an article",
// "There are no questions in this FAQ" => "There are no questions in this FAQ",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "Group Monitor Topics of this Forum" => "Group Monitor Topics of this Forum",
// "Group Monitor Topics and Threads of this Forum" => "Group Monitor Topics and Threads of this Forum",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Forum Lock" => "Forum Lock",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Filter Posts" => "Filter Posts",
// "Posts Filtering" => "Posts Filtering",
// "Last post date" => "Last post date",
// "Show archived posts" => "Show archived posts",
// "Containing posts by" => "Containing posts by",
// "Me" => "Me",
// "Posts with no replies" => "Posts with no replies",
// "Archived" => "Archived",
// "Topic List" => "Topic List",
// "The post has been reported and will be reviewed by a moderator" => "The post has been reported and will be reviewed by a moderator",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Stop Monitor" => "Stop Monitor",
// "Tracker Items" => "Tracker Items",
// "Pending" => "Pending",
// "Edit/Delete" => "Edit/Delete",
// "There was an error connecting to your e-mail account" => "There was an error connecting to your e-mail account",
// "Add a new" => "Add a new",
// "Edit this" => "Edit this",
// " mail account" => " mail account",
// "Group (shared mail inbox) or private" => "Group (shared mail inbox) or private",
// "This will be a group mail account" => "This will be a group mail account",
// "This will be a personal mail account" => "This will be a personal mail account",
// "Auto-refresh page time" => "Auto-refresh page time",
// "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission" => "You do not have the correct permissions to Add or Edit a webmail account. <BR />Please contact your administrator and ask for \"admin_personal_webmail\" or \"admin_group_webmail\" permission",
// "Personal e-mail accounts" => "Personal e-mail accounts",
// "Click to activate" => "Click to activate",
// "This is the active account" => "This is the active account",
// "Group e-mail accounts" => "Group e-mail accounts",
// "Show Unread" => "Show Unread",
// "Show Flagged" => "Show Flagged",
// "Refresh now" => "Refresh now",
// "Group messages" => "Group messages",
// "unFlagged" => "unFlagged",
// "Group Monitor on Structure" => "Group Monitor on Structure",
// "Jump to Content" => "Jump to Content",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Latitude" => "Latitude",
// "Longitude" => "Longitude",
// "Remove Image" => "Remove Image",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count" => "Word Count",
// "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator" => "Format: x,y,zoom where x is the longitude, and y is the latitude. Zoom is between 0(view Earth) and 19. You can use <a href=\"tiki-gmap_locator.php?for=item&amp;itemId={\$item.itemId}&amp;trackerId={\$item.trackerId}&amp;fieldId={\$field_value.fieldId}\">{tr}Google Map Locator",
// "Your vote" => "Your vote",
// "Click to vote for this value" => "Click to vote for this value",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled" => "Google Maps is not enabled",
// "The main text of this page is available in the following languages" => "The main text of this page is available in the following languages",
// "Use this thread to discuss the page" => "Use this thread to discuss the page",
// "Missing or incorrect trackerId parameter for the plugin" => "Missing or incorrect trackerId parameter for the plugin",
// "list" => "list",
// "Reinstall" => "Reinstall",
// "Undecided" => "Undecided",
// "Subscribe to a group" => "Subscribe to a group",
// "Toggle display" => "Toggle display",
// "Preview your changes" => "Preview your changes",
// "Save the page as a partial translation" => "Save the page as a partial translation",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation" => "Save the page as a completed translation",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated" => "Save the page, but do not send notifications and do not count it as new content to be translated",
// "Save the page" => "Save the page",
// "Save the page as a draft" => "Save the page as a draft",
// "Save Draft" => "Save Draft",
// "Cancel the edit, you will lose your changes" => "Cancel the edit, you will lose your changes",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)" => "Separate multiple usernames with a comma (&nbsp;,&nbsp;)",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "%s set" => "%s set",
// "%s unset" => "%s unset",
// "Administration" => "Administration",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Look & Feel" => "Look & Feel",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available" => "A new %s  major release branch is available",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category" => "Click here to delete the category",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header" => "The file does not have the required header",
// "moved %d images, %d errors occured" => "moved %d images, %d errors occured",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "Test Image" => "Test Image",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "If you use apache, you need a .htaccess file to have this feature working" => "If you use apache, you need a .htaccess file to have this feature working",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "risky" => "risky",
// "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off" => "allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off",
// "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code" => "The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code",
// "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html" => "The \"Snarf Wikiplugin\" is activated. It can be used by wiki editors to include pages from the local network and via regex replacement create any html",
// "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement" => "The \"Regex Wikiplugin\" is activated. It can be used by wiki editors to create any html via regex replacement",
// "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory" => "The \"Lsdir Wikiplugin\" is activated. It can be used by wiki editors to view the contents of any directory",
// "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts" => "The \"Bloglist Wikiplugin\" is activated. It can be used by wiki editors to disclose private blog posts",
// "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"iframe Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"js Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc" => "The \"JQ Wikiplugin\" is activated. It can be used by wiki editors to use Javascript, which can be used to do all kind of nasty things like cross site scripting attacks, etc",
// "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks" => "The \"Redirect Wikiplugin\" is activated. It can be used by wiki editors for cross site scripting attacks",
// "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)" => "The \"Module Wikiplugin\" is activated. It can be used by wiki editors to add modules which permit to access information (see module list)",
// "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users" => "The \"Userlist Wikiplugin\" is activated. It can be used by wiki editors to display the list of users",
// "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users" => "The \"Usercount Wikiplugin\" is activated. It can be used by wiki editors to display a count of the number of users",
// "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands" => "The \"SQL Wikiplugin\" is activated. It can be used by wiki editors to execute SQL commands",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "Are you sure you want to remove this topic" => "Are you sure you want to remove this topic",
// "Are you sure you want to remove this topic AND all the articles related" => "Are you sure you want to remove this topic AND all the articles related",
// "Tracker does not allow attachments" => "Tracker does not allow attachments",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "The description is mandatory as it is used as mail subject" => "The description is mandatory as it is used as mail subject",
// "Invalid or unknown email" => "Invalid or unknown email",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "User login contains invalid characters" => "User login contains invalid characters",
// "Deleted account %s" => "Deleted account %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "File Galleries Admin Panel" => "File Galleries Admin Panel",
// "Could not read file %s" => "Could not read file %s",
// "Could not write to file %s" => "Could not write to file %s",
// "File %s upload failed" => "File %s upload failed",
// "Upload was successful" => "Upload was successful",
// "File %s removed from Batch directory" => "File %s removed from Batch directory",
// "Impossible to remove file %s from Batch directory" => "Impossible to remove file %s from Batch directory",
// "Incorrect directory chosen for batch upload of files" => "Incorrect directory chosen for batch upload of files",
// "Last modifications to the blog" => "Last modifications to the blog",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache" => "You must clear your browser cache",
// "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>" => "You need to <a href=\"tiki-admin_calendars.php\">create a calendar</a>",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "Mo" => "Mo",
// "Tu" => "Tu",
// "We" => "We",
// "Th" => "Th",
// "Fr" => "Fr",
// "Sa" => "Sa",
// "Su" => "Su",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Invalid username or activation code. Maybe this code has already been used" => "Invalid username or activation code. Maybe this code has already been used",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Invalid request. Expecting channels array" => "Invalid request. Expecting channels array",
// "Missing channel name" => "Missing channel name",
// "Authentication required" => "Authentication required",
// "One of the requested channels cannot be requested. It does not exist or permission is denied" => "One of the requested channels cannot be requested. It does not exist or permission is denied",
// "One of the install profiles could not be obtained" => "One of the install profiles could not be obtained",
// "Problem. Try to log in again to receive new confirmation instructions" => "Problem. Try to log in again to receive new confirmation instructions",
// "You cannot download this file right now. Your score is low or file limit was reached" => "You cannot download this file right now. Your score is low or file limit was reached",
// "Error : The file %s doesn't exist" => "Error : The file %s doesn't exist",
// "Translation in progress" => "Translation in progress",
// "Page is a staging copy. Translation must begin from the approved copy" => "Page is a staging copy. Translation must begin from the approved copy",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Can't parse HTML data - no grammar file" => "Can't parse HTML data - no grammar file",
// "Page already exists. Go back and choose a different name" => "Page already exists. Go back and choose a different name",
// "The translation set already contains a page in this language" => "The translation set already contains a page in this language",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Form error - no import method selected for some reason" => "Form error - no import method selected for some reason",
// "Form error - no server-side filename entered for selected import method" => "Form error - no server-side filename entered for selected import method",
// "Last replied forum topics" => "Last replied forum topics",
// "Not supported yet" => "Not supported yet",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "I have refused your friendship request" => "I have refused your friendship request",
// "I have canceled my friendship request" => "I have canceled my friendship request",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No sheet specified" => "No sheet specified",
// "Only the administrator can upload language files" => "Only the administrator can upload language files",
// "Operations executed successfully" => "Operations executed successfully",
// "Page saved (version %d)" => "Page saved (version %d)",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "Delete comments" => "Delete comments",
// "Approved Status" => "Approved Status",
// "Queued" => "Queued",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file" => "Warning: Empty file",
// "Please re-upload your file" => "Please re-upload your file",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read the file" => "Cannot read the file",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "This gallery does not exist" => "This gallery does not exist",
// "Unable to contact remote server" => "Unable to contact remote server",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made" => "More than %d unsuccessful login attempts have been made",
// "An email has been sent to you with the instructions to follow" => "An email has been sent to you with the instructions to follow",
// "Your default nickname is already in use. A new one has to be selected" => "Your default nickname is already in use. A new one has to be selected",
// "The selected account is not associated with your identity" => "The selected account is not associated with your identity",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile" => "An error as occured with the mapfile",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files" => "Please create a directory named '.\$prefs['map_path'].' to hold your map files",
// "map edit" => "map edit",
// "No page provided" => "No page provided",
// "Page \"%0\" does not exist" => "Page \"%0\" does not exist",
// "Are you sure you want to delete this note" => "Are you sure you want to delete this note",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Missing object list type argument" => "Missing object list type argument",
// "Index" => "Index",
// "Index (' . \$code . " => "Index (' . \$code . ",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "empty" => "empty",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password" => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email" => "to the email",
// "You cannot rename staging pages. Please rename the approved page instead" => "You cannot rename staging pages. Please rename the approved page instead",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "invalid email" => "invalid email",
// "Error: " => "Error: ",
// "Notice: this variable may not be empty" => "Notice: this variable may not be empty",
// "Notice: invalid variable value" => "Notice: invalid variable value",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Clean the sql logs" => "Clean the sql logs",
// "Report to the webmaster" => "Report to the webmaster",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Batch file processed" => "Batch file processed",
// "Password has been changed" => "Password has been changed",
// "Invalid password. Your current password is required to change administrative information" => "Invalid password. Your current password is required to change administrative information",
// "A new page is created in a language" => "A new page is created in a language",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again" => "You must suggest a question; please try again",
// "Incorrect thread" => "Incorrect thread",
// " The connection failed, so check the server names" => " The connection failed, so check the server names",
// "The connection was OK" => "The connection was OK",
// " But the login failed, so check the Username and Password" => " But the login failed, so check the Username and Password",
// "Plugin modified by editor" => "Plugin modified by editor",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "The TikiTests Replay File has an error" => "The TikiTests Replay File has an error",
// "You are about to delete a TikiTest file, do you want to continue " => "You are about to delete a TikiTest file, do you want to continue ",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Re:" => "Re:",
"ID" => "ID",
"Type" => "Type",
"Angola" => "Angola",
"Antigua" => "Antigua",
"Bahamas" => "Bahamas",
"Bangladesh" => "Bangladesh",
"Barbados" => "Barbados",
"Belarus" => "Belarus",
"Bermuda" => "Bermuda",
"Brunei" => "Brunei",
"Canada" => "Canada",
"China" => "China",
"Cuba" => "Cuba",
"Cyprus" => "Cyprus",
"Ecuador" => "Ecuador",
"Fiji" => "Fiji",
"Finland" => "Finland",
"Guam" => "Guam",
"Guatemala" => "Guatemala",
"Honduras" => "Honduras",
"India" => "India",
"Iran" => "Iran",
"Jamaica" => "Jamaica",
"Japan" => "Japan",
"Kiribati" => "Kiribati",
"Luxemburg" => "Luxemburg",
"Malawi" => "Malawi",
"Malta" => "Malta",
"Mauritius" => "Mauritius",
"Mexico" => "Mexico",
"Mozambique" => "Mozambique",
"Nauru" => "Nauru",
"Nepal" => "Nepal",
"Nicaragua" => "Nicaragua",
"Nigeria" => "Nigeria",
"Niue" => "Niue",
"Pakistan" => "Pakistan",
"Panama" => "Panama",
"Paraguay" => "Paraguay",
"Peru" => "Peru",
"Portugal" => "Portugal",
"Samoa" => "Samoa",
"Singapore" => "Singapore",
"Taiwan" => "Taiwan",
"Thailand" => "Thailand",
"Tonga" => "Tonga",
"Tuvalu" => "Tuvalu",
"Uruguay" => "Uruguay",
"Vanuatu" => "Vanuatu",
"Venezuela" => "Venezuela",
"Wales" => "Wales",
"Zambia" => "Zambia",
"Zimbabwe" => "Zimbabwe",
"Pijin Solomon" => "Pijin Solomon",
"1 week" => "1 week",
"Web Server" => "Web Server",
"Tiki and PEAR::Auth" => "Tiki and PEAR::Auth",
"in" => "in",
"tracker" => "tracker",
"Wiki" => "Wiki",
"Blogs" => "Blogs",
"Forums" => "Forums",
"FAQs" => "FAQs",
"Trackers" => "Trackers",
"blog" => "blog",
"faq" => "faq",
"forum" => "forum",
"quiz" => "quiz",
"Blog" => "Blog",
"Score" => "Score",
"Tracker" => "Tracker",
"Trackeritem" => "Trackeritem",
"FAQ" => "FAQ",
"Forum" => "Forum",
"help" => "help",
"mins" => "mins",
"min" => "min",
"km" => "km",
"pvs" => "pvs",
"Help" => "Help",
"wiki" => "wiki",
"faqs" => "faqs",
"blogs" => "blogs",
"forums" => "forums",
"Item" => "Item",
"max" => "max",
"jscalendar" => "jscalendar",
"open" => "open",
"(AT)" => "(AT)",
"(DOT)" => "(DOT)",
"Info" => "Info",
"Zone" => "Zone",
"Items" => "Items",
"Code" => "Code",
"code" => "code",
"Cookie" => "Cookie",
"term" => "term",
"Label" => "Label",
"type" => "type",
"URL" => "URL",
"Start" => "Start",
"Stop" => "Stop",
"Filter" => "Filter",
"Object" => "Object",
"Pop-up" => "Pop-up",
"Id" => "Id",
"Status" => "Status",
"Mode" => "Mode",
"Top" => "Top",
"id" => "id",
"debug" => "debug",
"Threaded" => "Threaded",
"Smileys" => "Smileys",
"in:" => "in:",
"RSS Wiki" => "RSS Wiki",
"RSS Blogs" => "RSS Blogs",
"RSS Forums" => "RSS Forums",
"RSS Directories" => "RSS Directories",
"Zoom in x2" => "Zoom in x2",
"CC" => "CC",
"BCC" => "BCC",
"1" => "1",
"2" => "2",
"3" => "3",
"4" => "4",
"5" => "5",
"Cc" => "Cc",
"Live Support" => "Live Support",
"Modules" => "Modules",
"Cookies" => "Cookies",
"Mail-in" => "Mail-in",
"phpinfo" => "phpinfo",
"April" => "April",
"September" => "September",
"November" => "November",
"December" => "December",
"Sites" => "Sites",
"Top \$module_rows Sites" => "Top \$module_rows Sites",
"Top Sites" => "Top Sites",
"Open operator console" => "Open operator console",
"week" => "week",
"Tiki Logo" => "Tiki Logo",
"Menu" => "Menu",
"Wiki RSS" => "Wiki RSS",
"Blogs RSS" => "Blogs RSS",
"Forums RSS" => "Forums RSS",
"Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
"Top Forum Posters" => "Top Forum Posters",
"[-]" => "[-]",
"Permalink" => "Permalink",
"Trackback pings" => "Trackback pings",
"URI" => "URI",
"Tip" => "Tip",
"Module" => "Module",
"RSS" => "RSS",
"Webmail" => "Webmail",
"Wysiwyg editor" => "Wysiwyg editor",
"E-mail" => "E-mail",
"JsCalendar" => "JsCalendar",
"PHPLayers" => "PHPLayers",
"Integrator" => "Integrator",
"MIME Type" => "MIME Type",
"pixels" => "pixels",
"Exterminator" => "Exterminator",
"Unix" => "Unix",
"Windows" => "Windows",
"Tikiwiki.org help" => "Tikiwiki.org help",
"Help URL" => "Help URL",
"IP" => "IP",
"PEAR::Auth" => "PEAR::Auth",
"PAM" => "PAM",
"Tiki and HTTP Auth" => "Tiki and HTTP Auth",
"LDAP" => "LDAP",
"PAM service" => "PAM service",
"image/png" => "image/png",
"image/bmp" => "image/bmp",
"image/x-icon" => "image/x-icon",
"Robots" => "Robots",
"Editor" => "Editor",
"Webmaster" => "Webmaster",
"Parameters" => "Parameters",
"Quota (Mb)" => "Quota (Mb)",
"Dumps" => "Dumps",
"MultiPrint" => "MultiPrint",
"DSN" => "DSN",
"bytes" => "bytes",
"x" => "x",
"Loc" => "Loc",
"Cat" => "Cat",
"Prio" => "Prio",
"Perso" => "Perso",
"Top 10 items" => "Top 10 items",
"Top 20 items" => "Top 20 items",
"Top 40 items" => "Top 40 items",
"Top 50 items" => "Top 50 items",
"Top 100 items" => "Top 100 items",
"Top 250 items" => "Top 250 items",
"CMS" => "CMS",
"cookie" => "cookie",
"Ver" => "Ver",
"POP3 server" => "POP3 server",
"Online" => "Online",
"zone" => "zone",
"Regex" => "Regex",
"Mail-in accounts" => "Mail-in accounts",
"Account" => "Account",
"wiki-get" => "wiki-get",
"wiki-put" => "wiki-put",
"wiki-append" => "wiki-append",
"phpLayersMenus" => "phpLayersMenus",
"object" => "object",
"Alias" => "Alias",
"Open" => "Open",
"isMain" => "isMain",
"Tbl vis" => "Tbl vis",
"bcc" => "bcc",
"Trackers Items" => "Trackers Items",
"Hit" => "Hit",
"Details" => "Details",
"popup" => "popup",
"+" => "+",
"%m/%d" => "%m/%d",
"exec" => "exec",
"URL:" => "URL:",
"cType" => "cType",
"editor" => "editor",
"tagline" => "tagline",
"%" => "%",
"Quiz" => "Quiz",
"maxScore" => "maxScore",
"status" => "status",
"Dump" => "Dump",
"Int" => "Int",
"Routing" => "Routing",
"#" => "#",
"inter" => "inter",
"act" => "act",
"Act status" => "Act status",
"ver:" => "ver:",
"map" => "map",
"Proc" => "Proc",
"auto" => "auto",
"int" => "int",
"routing" => "routing",
"Monitor" => "Monitor",
"Inst Status" => "Inst Status",
"Select Graphic Type" => "Select Graphic Type",
"v" => "v",
"/" => "/",
"Operator" => "Operator",
"Operator:" => "Operator:",
"operator" => "operator",
"Tikiwiki Mods" => "Tikiwiki Mods",
"server" => "server",
"quota" => "quota",
"Top 10" => "Top 10",
"Top 20" => "Top 20",
"Top 50" => "Top 50",
"Top 100" => "Top 100",
"Site" => "Site",
"tikiwiki.org" => "tikiwiki.org",
"eek" => "eek",
"lol" => "lol",
"razz" => "razz",
"santa" => "santa",
"Mb" => "Mb",
"Folders" => "Folders",
"Folder in" => "Folder in",
"%m/%d/%Y [%H:%M]" => "%m/%d/%Y [%H:%M]",
"Pos" => "Pos",
"Pre" => "Pre",
"A" => "A",
"Emot" => "Emot",
"pts" => "pts",
"Filter Tracker Items" => "Filter Tracker Items",
"3d browser" => "3d browser",
"TOP" => "TOP",
"%H:%M %Z" => "%H:%M %Z",
"tiki-mobile.php" => "tiki-mobile.php",
"Tracker item:" => "Tracker item:",
"unicode" => "unicode",
"Percentage" => "Percentage",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Dit onderdeel is niet actief",
"Permission denied you cannot view pages" => "Geen toestemming om pagina's te bekijken",
"This script cannot be called directly" => "Dit script kan niet rechtstreeks worden gestart",
"The copyright management feature is not enabled." => "Het onderdeel ivm het beheer van de auteursrechten is niet aangezet",
"No page indicated" => "Geen pagina opgegeven",
"You must supply all the information, including title and year." => "U moet alle informatie aanleveren, incluis titel en jaar.",
"You do not have permission to use this feature" => "U heeft geen permissie om dit onderdeel te gebruiken",
"This feature is for admins only" => "Dit onderdeel is enkel voor beheerders",
"Name" => "Naam",
"Description" => "Omschrijving",
"Size" => "Grootte",
"Created" => "Gemaakt",
"Last Modified" => "Laatst Gewijzigd",
"Creator" => "Auteur",
"Author" => "Auteur",
"Comment" => "Opmerking",
"Files" => "Bestanden",
"Hits" => "Kliks",
"Locked by" => "Vergrendeld door",
"Path" => "Pad",
"Algeria" => "Algerije",
"American Samoa" => "Amerikaans_Samoa",
"Argentina" => "Argentine&euml;",
"Armenia" => "Armeni&euml;",
"Australia" => "Australi&euml;",
"Austria" => "Oostenrijk",
"Bahrain" => "Bahrein",
"Belgium" => "Belgi&euml;",
"Bolivia" => "Bolivi&euml;",
"Brazil" => "Brazile&euml;",
"Bulgaria" => "Bulgarije",
"Cayman Islands" => "Kaaiman_Eilanden",
"Chile" => "Chili",
"Colombia" => "Colombi&euml;",
"Cook Islands" => "Cook_Eilanden",
"Costa Rica" => "Costa_Rica",
"Croatia" => "Kroati&euml;",
"Czech Republic" => "Tsjechi&euml;",
"Denmark" => "Denemarken",
"Dominican Republic" => "Dominikaanse_Republiek",
"Egypt" => "Egypte",
"El Salvador" => "El_Salvador",
"Estonia" => "Estland",
"Federated States of Micronesia" => "Verenigde_Staten_van_Micronesi&uml;",
"France" => "Frankrijk",
"French Polynesia" => "Frans_Polynesi&euml;",
"Germany" => "Duitsland",
"Greece" => "Griekenland",
"Haiti" => "Ha&iuml;ti",
"Hungary" => "Hungarije",
"Iceland" => "Ijsland",
"Indonesia" => "Indonesi&euml;",
"Iraq" => "Irak",
"Ireland" => "Ierland",
"Israel" => "Isra&euml;l",
"Italy" => "Itali&euml;",
"Ivory Coast" => "Ivoorkust",
"Jordan" => "Jordani&euml;",
"Kazakstan" => "Kazachstan",
"Kenya" => "Kenia",
"Kuwait" => "Koeweit",
"Latvia" => "Letland",
"Lebanon" => "Libanon",
"Lithuania" => "Litouwen",
"Malaysia" => "Maleisi&euml;",
"Marshall Islands" => "Marshall_Eilanden",
"Morocco" => "Marokko",
"Netherlands" => "Nederland",
"New Caledonia" => "Nieuw_Caledoni&euml;",
"New Zealand" => "Nieuw_Zeeland",
"None" => "Geen",
"Norway" => "Noorwegen",
"Other" => "Andere",
"Papua New Guinea" => "Papoea_Nieuw_Guinea",
"Poland" => "Polen",
"Puerto Rico" => "Puerto_Rico",
"Quatar" => "Qatar",
"Romania" => "Roemeni&euml;",
"Russia" => "Rusland",
"Russian Federation" => "Rusland",
"Saudi Arabia" => "Saoedi_Arabi&euml;",
"Slovakia" => "Slovakije",
"Slovenia" => "Sloveni&euml;",
"Solomon Islands" => "Solomon_Eilanden",
"Somalia" => "Somali&euml;",
"South Africa" => "Zuid_Afrika",
"South Korea" => "Zuid_Korea",
"Spain" => "Spanje",
"Sri Lanka" => "Sri_Lanka",
"St Vincent Grenadines" => "St_Vincent_Grenadines",
"Surinam" => "Suriname",
"Sweden" => "Zweden",
"Switzerland" => "Zwitzerland",
"Trinidad Tobago" => "Trinidad_Tobago",
"Turkey" => "Turkije",
"Ukraine" => "Oekraine",
"United Arab Emirates" => "Verenigde_Arabische_Emiraten",
"United Kingdom" => "Vereinigd_Koningrijk",
"United States" => "Verenigde_Staten",
"Yugoslavia" => "Joegoslavi&uml;",
"Arabic" => "Arabisch",
"Catalan" => "Catalaans",
"Simplified Chinese" => "Simpel Chinees",
"Chinese" => "Chinees",
"Czech" => "Czechisch",
"Danish" => "Deens",
"German" => "Duits",
"English" => "Engels",
"English British" => "Brits Engels",
"Spanish" => "Spaans",
"Greek" => "Grieks",
"French" => "Frans",
"Hebrew" => "Hebreeuws",
"Croatian" => "Kroatisch",
"Italian" => "Italiaans",
"Japanese" => "Japans",
"Korean" => "Koreaans",
"Hungarian" => "Hongaars",
"Dutch" => "Nederlands",
"Norwegian" => "Noors",
"Polish" => "Pools",
"Português" => "Portugees",
"Brazilian Portuguese" => "Braziliaans Portugees",
"Russian" => "Russisch",
"Slovak" => "Slovaaks",
"Serbian" => "Servisch",
"Serbian Latin" => "Servisch",
"Swedish" => "Zweeds",
"Tuvaluan" => "Tuvalees",
"Traditional Chinese" => "Traditioneel Chinees",
"Ukrainian" => "Oekraiens",
"This instance of activity is already complete" => "Deze incarnatie van de activiteit is reeds beeindigd",
"Fatal error: cannot execute automatic activity \$activityId" => "Fatale fout: kan automatische activiteit \$activityId niet uitvoeren",
"Fatal error: setting next activity to an unexisting activity" => "Fatale fout: markeer volgende activiteit als niet-bestaande activiteit",
"Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatale fout: volgende activiteit komt niet overeen met enige kandidaat in de autorouting switch activiteit",
"Fatal error: non-deterministic decision for autorouting activity" => "Fatale fout: niet-deterministische beslissing voor autorouting activiteit",
"Fatal error: trying to send an instance to an activity but no transition found" => "Fatale fout: poging om een incarnatie naar een activiteit te zenden maar geen overgang gevonden",
"Cannot add transition only split activities can have more than one outbound transition" => "Kan geen overgang toevoegen, enkel gesplitste activiteiten kunnen meer dan &eacute;&eacute; uitgaande overgang hebben",
"Circular reference found some activity has a transition leading to itself" => "Circulaire verwijziging gevonden, er is een activiteit met een overgang naar zichzelf",
"Process does not have a start activity" => "Proces heeft geen start activiteit",
"Process does not have exactly one end activity" => "Proces heeft niet precies &eacute;&eacute; eind activiteit",
"End activity is not reachable from start activity" => "Eind activiteit is niet bereikbaar vanuit start activiteit",
"Activity" => "Activiteit",
"is interactive but has no role assigned" => "is interactief maar heeft geen rol toegewezen",
"is non-interactive and non-autorouted but has no role assigned" => "is niet-interactief en niet-autorouted maar heeft geen rol toegewezen",
"is standalone but has transitions" => "is op zichzelf staand maar heeft overgangen",
"Role" => "Functie",
"is not mapped" => "is niet gemapped",
"Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activiteit '.\$res['name'].' is op zichzelf staand en gebruikt het \$instance object",
"Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activiteit '.\$res['name'].' is interactief en moet de \$instance->complete() methode gebruiken",
"Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activiteit '.\$res['name'].' is niet-interactief en kan de \$instance->complete() methode niet gebruiken",
"Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activiteit '.\$res['name'].' is switch en moet de \$instance->setNextActivity(\$actname) methode gebruiken",
"Process %d has been activated" => "Proces %d is geactivateerd",
"Process %d has been deactivated" => "Proces %d is gedeactivateerd",
"Process %s %s imported" => "Proces %s %s geimporteerd",
"Process %s removed" => "Proces %s verwijderd",
"Process %s has been updated" => "Proces %s bijgewerkt",
"Process %s has been created" => "Proces %s aangemaakt",
"points" => "punten",
"Disabled" => "Uitgeschakeld",
"Plain text" => "Platte tekst",
"Link to user information" => "Koppeling met gebruikerinformatie",
"User avatar" => "Gebruikerpictogram",
"Creation date (desc)" => "Aanmaakdatum (dalend)",
"Last modification date (desc)" => "Datum laatste wijziging (dalend)",
"Blog title (asc)" => "Blogtitel (stijgend)",
"Number of posts (desc)" => "Aantal bijdragen (dalend)",
"Visits (desc)" => "Aantal bezoekers (dalend)",
"Activity (desc)" => "Activiteit (dalend)",
"Top bar" => "Bovenbalk",
"Bottom bar" => "Onderbalk",
"no cache" => "Geen buffer",
"minute" => "minuut",
"minutes" => "minuten",
"hour" => "uur",
"hours" => "uren",
"as Creator &amp; Last Editor" => "als Auteur &amp; Laatste Bewerker",
"Business style" => "Zakelijke stijl",
"Collaborative style" => "Collaboratieve stijl",
"Page last modified on" => "Pagina laatst bijgewerkt op",
"no (disabled)" => "neen (uitgeschakeld)",
"|| for rows" => "|| voor rijen",
"<return> for rows" => "\\n voor rijen",
"Only with last version" => "Enkel met de laatste versie",
"Any 2 versions" => "Eender welke 2 versies",
"complete" => "volledig",
"latin" => "latijn",
"english" => "engels",
"Day" => "Dag",
"Month" => "Maand",
"Year" => "Jaar",
"Saturday" => "zaterdag",
"Sunday" => "zondag",
"Monday" => "maandag",
"No error reporting" => "Geen fouten rapportage",
"Report all PHP errors" => "Rapporteer alle PHP fouten",
"Report all errors except notices" => "Rapporteer alle fouten behalve berichten",
"Creation Date (desc)" => "Aanmaakdatum (dalend)",
"Topics (desc)" => "Onderwerpen (dalend)",
"Threads (desc)" => "Threads (dalend)",
"Last post (desc)" => "Laatst aangeleverd (dalend.)",
"Name (desc)" => "Naam (dalend)",
"Name (asc)" => "Naam (stijgend)",
"replace current window" => "huidig venster vervangen",
"new window" => "niew venster",
"inline frame" => "inline-kader",
"5 minutes" => "5 minuten",
"1 day" => "1 dag",
"1 month" => "1 maand",
"Allow secure (https) login" => "Veilige (https) aanmelding toestaan",
"Require secure (https) login" => "Veilige (https) aanmelding eisen",
"Just Tiki" => "Alleen Tiki",
"Tiki and PAM" => "Tiki en PAM",
"CAS (Central Authentication Service)" => "CAS (Centrale Authenticatie Service)",
"choose a group ..." => "kies een groep ...",
"Registered" => "Geregistreerd",
"Anonymous" => "Anoniem",
"Use database to store files" => "Databank gebruiken om bestanden op te slaan",
"Use a directory to store files" => "Een folder gebruiken om bestanden op te slaan",
"%s enabled" => "%s aangeschakeld",
"%s disabled" => "%s uitgeschakeld",
"Permission denied" => "Geen permissie",
"The file is not a CSV file or has not a correct syntax" => "Het bestand is geen CVS bestand of het heeft een fout formaat",
"locked" => "vergrendeld",
"locked by" => "vergrendeld door",
"Administration:" => "Beheer:",
"continued" => "vervolgt",
"New Image Uploaded by" => "Nieuwe afbeeldingen aangeleverd door",
"New Subscriptions" => "Nieuwe abonnementen",
"New Item in Tracker" => "Nieuw item in tracker",
"by" => "door",
"Image Gallery" => "Beeldgalerij",
"Articles" => "Artikelen",
"Directory" => "Koppelingenlijst",
"File Gallery" => "Bestandgalerij",
"Quizzes" => "Quizzen",
"Survey" => "Opinieonderzoek",
"Newsletter" => "Nieuwsbrieven",
"Charts" => "Rangschikkingen",
"article" => "artikel",
"directory" => "koppelingenlijst",
"file gallery" => "bestandgalerij",
"image gallery" => "afbeeldinggalerij",
"newsletter" => "nieuwsbrief",
"poll" => "opiniepeiling",
"survey" => "opinieonderzoek",
"wiki page" => "wiki pagina",
"image" => "afbeelding",
"calendar" => "kalender",
"Invalid filename (using filters for filenames)" => "Ongeldige bestandnaam (gebruikt filters voor bestandnaam)",
"Cannot upload this file maximum upload size exceeded" => "Kan dit bestand niet aanleveren, maximum grootte van aanlevering overschreden",
"You have mistyped the anti-bot verification code; please try again." => "U heeft de anti-bot verificatie code verkeerd ingevoerd; probeer aub opnieuw.",
"Wrong password. Cannot post comment" => "Verkeerd wachtwoord. Kan commentaar niet toevoegen",
"You have to enter a title and text" => "U moet een titel en tekst invoeren",
"text" => "tekst",
"WikiDiff::apply: line count mismatch: %s != %s" => "WikiVerschil::toepassen: verschil in lijnnummers: %s != %s",
"WikiDiff::_check: failed" => "WikiVerschil::_controle: mislukt",
"WikiDiff::_check: edit sequence is non-optimal" => "WikiVerschil::_controle: bewerkingsvolgorde is sub-optimaal",
"WikiDiff Okay: LCS = %s" => "WikiVerschil Ok: LCS = %s",
"Line:" => "Lijn:",
"Lines:" => "Lijnen:",
"Find" => "Zoeken",
"find" => "zoeken",
"prev" => "vor.",
"Page" => "Pagina",
"next" => "volg.",
"Link" => "Koppeling",
"Page name" => "Paginanaam",
"Wiki Home" => "Wiki-startpagina",
"Home" => "Startpagina",
"previous page" => "vorige pagina",
"next page" => "volgende pagina",
"posted on" => "toegevoegd op",
"Continue" => "Ga verder",
"By:" => "Door:",
"Read" => "Lezen",
"List articles" => "Artikelen opsommen",
"Last post" => "Laatste bijdrage",
"Invalid imagename (using filters for filenames)" => "Ongeldige naam afbeelding (gebruik filters voor bestandnamen)",
"Errors detected" => "Fouten opgetreden",
"Upload was not successful" => "Aanlevering was niet succesvol",
"No image yet, sorry." => "Nog geen afbeelding, sorry.",
"No valid ogr2ogr executable" => "Geen geschikt ogr2ogr programma beschikbaar",
"Could not create \$tdo.mif in data directory" => "Kon \$tdo.mif niet aanmaken in de gegevensfolder",
"Could not create \$tdo.mid in data directory" => "Kon \$tdo.mid niet aanmaken in de gegevensfolder",
"unknown" => "onbekend",
"User Map Generated in:" => "Gebruikskaart aangemaakt in:",
"Image Map Generated in:" => "Afbeeldingen aangemaakt in:",
"NONE" => "GEEN",
"File %s not found" => "Bestand %s niet gevonden",
"File %s is not a valid archive" => "Bestand %s is geen geldig archiefbestand",
"Impossible to open %s : %s" => "Kan %s : %s niet openen",
"Wiki top pages" => "Wiki top pagina's",
"Most relevant pages" => "Meest relevante pagina's",
"Relevance" => "Relevantie",
"Wiki last pages" => "Wiki laatste pagina's",
"Modified" => "Gewijzigd",
"Forums last topics" => "Forums' laatste onderwerpen",
"Topic date" => "Datum onderwerp",
"Forums last posts" => "Forums' laatste berichten",
"Forums most read topics" => "Forums' meest gelezen onderwerpen",
"Reads" => "Gelezen",
"Forums best topics" => "Forums' beste onderwerpen",
"Forums most visited forums" => "Forums' meest bezochte forums",
"Visits" => "Aantal bezoekers",
"Forums with most posts" => "Forums' met meeste berichten",
"Posts" => "Bijdragen",
"Wiki top galleries" => "Wiki top galerijen",
"Wiki top file galleries" => "Wiki top bestandgalerijen",
"Wiki top images" => "Wiki top afbeeldingen",
"Wiki top files" => "Wiki top bestanden",
"Downloads" => "Afhalingen",
"Wiki last images" => "Wiki laatste afbeeldingen",
"Upload date" => "Datum aanlevering",
"Wiki last files" => "Wiki laatste bestanden",
"Wiki top articles" => "Wiki top artikelen",
"Most visited blogs" => "Meest bezochte blogs",
"Most active blogs" => "Meest actieve blogs",
"Blogs last posts" => "Blogs laatste bijdragen",
"Post date" => "Datum toevoeging",
"Wiki top authors" => "Wiki top auteurs",
"Pages" => "Pagina's",
"Top article authors" => "Top artikelauteurs",
"User already exists" => "Gebruiker bestaat reeds",
"Wrong registration code" => "Verkeerde registratiecode",
"Invalid username" => "Ongeldige gebruikernaam",
"Username is too long" => "Gebruikernaam is te lang",
"Username cannot contain whitespace" => "Gebruikernaam kan geen spatie bevatten",
"Wrong passcode you need to know the passcode to register in this site" => "Verkeerde pascode, u heeft de pascode nodig om voor deze site te registreren",
"Invalid email address. You must enter a valid email address" => "Ongeldig e-mail adres. U moet een geldig e-mail adres invoeren",
"The registration mail can't be sent. Contact the administrator" => "De registration e-mail kan niet worden verstuurd. Gelieve de beheerder te contacteren",
"Login" => "Aanmelden",
"See other user's profile" => "Zie ander gebruikersprofiel",
"Have your profile seen" => "Heb jouw profiel gezien",
"Make friends" => "Maak vrienden",
"Receive message" => "Ontvang bericht",
"Send message" => "Stuur bericht",
"Read an article" => "Lees een artikel",
"Publish an article" => "Publiceer een artikel",
"Have your article read" => "Laat uw artikel lezen door",
"Create new file gallery" => "Maak nieuwe bestandgalerij aan",
"Upload new file to gallery" => "Lever nieuw bestaand in de galerij aan",
"Download other user's file" => "Haal bestand van andere gebruikers af",
"Have your file downloaded" => "Laat uw bestand afhalen",
"Create a new image gallery" => "Maak een nieuwe beeldgalerij aan",
"Upload new image to gallery" => "Lever nieuw beeld in galerij aan",
"See other user's gallery" => "Bekijk galerij van andere gebuiker",
"See other user's image" => "Bekijk beeld van andere gebruiker",
"Have your gallery seen by other user" => "Laat uw galerij door anderen gebruiker bekijken",
"Have your image seen" => "Laat uw beeld bekijken",
"Create new blog" => "Maak nieuw blog aan",
"Post in a blog" => "Maak bericht in blog",
"Read other user's blog" => "Lees journal van andere gebruiker",
"Have your blog read" => "Laat uw blog lezen",
"Create a new wiki page" => "Maak nieuwe wikipagina aan",
"Edit an existing page" => "Werk een bestaande pagina bij",
"Attach file" => "Attach bestand",
"Unknown" => "Ongekend",
"Image" => "Afbeelding",
"Article" => "Artikel",
"Directory category" => "Koppelingenlijst categorie",
"Gallery" => "Galerij",
"Blog post" => "Blogbijdrage",
"Prev" => "Vor.",
"Next" => "Volgende",
"Edit Template" => "Bewerk sjabloon",
"Admin Feature" => "Beheermodule",
"Hide" => "Verberg",
"All" => "Alle",
"The text is" => "De tekst is",
"character(s) too long - please edit it." => "karakter(s) te lang - aub verander het.",
"Date Selector" => "Datumkiezer",
"Select All" => "Selecteer alles",
"days" => "dagen",
"day" => "dag",
"secs" => "sec",
"done" => "gedaan",
"Text cut here" => "Knip tekst hier",
"Task" => "Taak",
"from" => "van",
"for" => "voor",
"Priority" => "Prioriteit",
"Start date:" => "Startdatum:",
"End date:" => "Einddatum:",
"User information - Click for more info" => "Gebruikersinformatie - Klik voor meer info",
"Friend" => "Vriend",
"Last seen on" => "Laast gezien op",
"(idle for %s seconds)" => "(niet actief gedurende %s seconden)",
"More info about \$other_user" => "Meer info over \$other_user",
"(idle for \$idletime seconds)" => "(niet actief gedurende \$idletime seconden)",
"Yes" => "Ja",
"No" => "Neen",
"Use this tree to copy the structure" => "Gebruik deze indeling om de structuur te kopieren",
"created from structure" => "aangemaakt vanuit structuur",
"Table of contents" => "Inhoudstabel",
"unknown error" => "onbekende fout",
"You are not logged in" => "U bent niet aangemeld",
"Page cannot be found" => "Pagina kan niet gevonden worden",
"Permission denied you cannot view this section" => "Geen toestemming om deze sectie te bekijken",
"An error occured in a database query!" => "Een fout is opgetreden in een databankvraag!",
"You are banned from" => "U bent verbannen van",
"img-g" => "afbd-g",
"file-g" => "bestand-g",
"quizzes" => "quizzen",
"arts" => "kunsten",
"games" => "spelletjes",
"Click to edit dynamic variable" => "Klik om dynamische variable te wijzigen",
"Update variables" => "Update variabelen",
"Show" => "Toon",
"Altering database table failed" => "Aanpassing databank tabel gefaald",
"%d points" => "%d punten",
"Removed" => "Verwijderd",
"__WARNING__: No such module \$plugin!" => "__WAARSCHUWING__: Module \$plugin niet beschikbaar!",
"at" => "aan",
"new" => "nieuw",
"Create page:" => "Pagina aanmaken:",
"Unknown language" => "Ongekende taal",
"Click here to confirm your action" => "Klik hier om uw actie te bestigen",
"Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) ontdekt. Handeling stopgezet.",
"Rating" => "Beoordeling",
"Item Modification" => "Wijziging item",
"Item creation" => "Aanmaak item",
"Subject" => "Betreft",
"Tracker was modified at " => "Tracker was gewijzigd op ",
"View the tracker item at:" => "Bekijk het tracker item op:",
"text field" => "tekstveld",
"half column" => "halve kolom",
"size" => "grootte",
"prepend" => "voeg vooraan toe",
"append" => "voeg achteraan toe",
"textarea" => "tekstvak",
"checkbox" => "selectieveld",
"numeric field" => "numeriek veld",
"drop down" => "neerklap",
"user selector" => "gebruikerkizer",
"group selector" => "groepkiezer",
"date and time" => "datum en tijd",
"action" => "actie",
"header" => "hoofding",
"category" => "categorie",
"item link" => "item koppeling",
"items list" => "items lijst",
"email" => "e-mail",
"system" => "systeem",
"attachment" => "bijlage",
"pending" => "openstaande",
"closed" => "gesloten",
"Message" => "Bericht",
"No extra information for that attached file. " => "Geen extra information voor deze bijlage. ",
"child categories" => "kindcategorie&euml;n",
"objects in category" => "objecten in categorie",
"Password should be at least" => "Wachtwoord moet ten minste",
"characters long" => "aantal karakters lang zijn",
"Password must contain both letters and numbers" => "Wachtwoord moet zowel letters als cijfers bevatten",
"Personal Phone" => "Persoonlijk Telefoonnummer",
"Personal Mobile" => "Persoonlijk GSM-nummer",
"Personal Fax" => "Persoonlijk Fax-nummer",
"Work Phone" => "Zakelijk Telefoonnummer",
"Work Mobile" => "Zakelijk GSM-nummer",
"Work Fax" => "Zakelijk Fax-nummer",
"Company" => "Bedrijf",
"Organization" => "Organisatie",
"Department" => "Afdeling",
"Division" => "Divisie",
"Job Title" => "Aanspreking",
"Street Address" => "Straat",
"City" => "Stad",
"State" => "Status",
"Zip Code" => "Postcode",
"Country" => "Land",
"Displays browser client info" => "Toon browser client info",
"Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Plaats een koppeling naar een anker in een wiki pagina. Gebruik in combinatie met de ANAME plugin die de locatie en naam van het anker bepaald",
"linktext" => "tekst van koppeling",
"Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Plaats een anker in een wiki pagina. Gebruik in combinatie met de ALINK plugin die de koppeling naar het anker voorziet",
"Location" => "Locatie",
"Field" => "Veld",
"Language" => "Taal",
"Attachment" => "Bijlage",
"File" => "Bestand",
"Show description" => "Toon beschrijving",
"No such attachment on this page" => "Bijlage niet aanwezig op deze pagina",
"Displays an attachment or a list of them" => "Toont een bijlage of een bijlagelijst",
"Avatar" => "Pictogram",
"Displays the user Avatar" => "Toon het gebruikerpictogram",
"username" => "gebruikernaam",
"Back" => "Terug",
"Backlinks" => "Terugkoppelingen",
"List all pages which link to specific pages" => "Toon alle pagina's die naar specifieke pagina's verwijzen",
"No pages links to" => "Geen pagina's verwijzen naar",
"One page links to" => "E&eacute; pagina verwijst naar",
"pages link to" => "pagina's verwijzen naar",
"Insert theme styled box on wiki page" => "Voeg een thema-geformatteerd tekstkader toe aan de wiki pagina",
"Category" => "Categorie",
"Insert list of items for the current/given category into wiki page" => "Voeg lijst van items voor de huidige categorie toe aan de wiki pagina",
"Categories are disabled" => "Categorie&euml;n zijn uitgeschakeld",
"Display Tiki objects that have not been categorized" => "Toon niet-gecategorizeerde Tik objecten",
"Objects" => "Objecten",
"Insert the full category path for each category that this wiki page belongs to" => "Voeg het volledige categoriepad toe voor elke categorie waartoe deze wiki pagina behoort",
"Center" => "Centreren",
"Centers the plugin content in the wiki page" => "Centreer de plugin inhoud in de wiki pagina",
"Chart" => "Rangschikking",
"title" => "titel",
"Displays a snippet of code" => "Toont een stukje code",
"note: colors and ln are exclusive" => "opmerking: kleuren en ln zijn exclusief",
"Dynamic Content" => "Dynamische inhoud",
"Copyright" => "Auteursrechten",
"Insert copyright notices" => "Voeg bericht over auteursrechten toe",
"Example" => "Voorbeeld",
"and" => "en",
"seconds" => "seconden",
"Insert a division block on wiki page" => "Onderdeelblok invoegen in een wiki pagina",
"Creates a definition list" => "Maak definitielijst aan",
"definition" => "definitie",
"one definition per line" => "&eacute;&eacute; definitie per lijn",
"drawing not found" => "tekening niet gevonden",
"Events" => "Gebeurtenissen",
"Desc" => "Omschr.",
"Upcoming events" => "Aankomende evenementen",
"Displays the data using the Tikiwiki odd/even table style" => "Toont de gegevens in alternerende Tikiwiki tabelstijl",
"cells" => "cellen",
"heads and cells separated by ~|~" => "hoofdingen en cellen zijn gescheiden door ~|~",
"Title" => "Titel",
"sort" => "sorteer",
"Displays a SWF on the wiki page" => "Toont een SWF in de wiki pagina",
"failed" => "mislukt",
"description" => "omschrijving",
"Value" => "Waarde",
"Displays a graphical GAUGE" => "Toont een grafische VOLUMEMETER",
"Group" => "Groep",
"HTML code" => "HTML-code",
"name" => "naam",
"Image ID" => "Afbeelding ID",
"Image size" => "Afbeeldinggrootte",
"Img" => "Afb.",
"Include" => "Omvatten",
"Include a page" => "Sluit een pagina in",
"Displays the text only if the language matchs" => "Toont enkel de tekst indien de taal overeenkomt",
"Last Modification" => "Laatste wijziging",
"List Pages" => "Pagina's opsommen",
"Sort" => "Sorteren",
"or" => "of",
"Lists files in a directory" => "Lijst bestanden in een folder",
"could not be opened because it doesn't exist or permission was denied" => "kan niet worden geopend omdat het niet bestaat of wegens onvoldoende permissies",
"Map" => "Landkaart",
"Feature disabled" => "Onderdeel niet actief",
"Style" => "Stijl",
"Module Name" => "Modulenaam",
"Please choose a module" => "Kies aub een module",
"to be used as argument" => "moet als argument gebruikt worden",
"Displays a module inlined in page" => "Toon de module in de pagina",
"Sorry no such module" => "Geen zulks module",
"Font" => "Lettertype",
"Displays the data using a monospace font" => "Toont de gegevens in een monospace lettertype",
"Text" => "Tekst",
"Sticky" => "Plakkend",
"data" => "gegevens",
"Days" => "Dagen",
"Picture" => "Foto",
"picture not found" => "afbeelding niet gevonden",
"Information" => "Informatie",
"Provides a list of plugins on this wiki." => "Geeft een lijst van plugins voor dit wiki.",
"No version indicated" => "Geen versie opgegeven",
"No arguments indicated" => "Geen argumenten aangeduid",
"Poll" => "Opiniepeiling",
"Displays the output of a poll, fields are indicated with numeric ids." => "Toont het resultaat van een opiniepeiling, velden zijn aangeduid met numerieke ids.",
"missing poll ID for plugin POLL" => "ontbrekend ID voor opiniepeiling in de plugin OPINIEPEILING",
"wrote:" => "schreef:",
"Quote:" => "Aanhaling:",
"Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Haal tekst aan door deze in een tekstkader te plaatsen, zoals de [QUOTE] BBCode",
"one data per line" => "een gegeven per lijn",
"Search" => "Zoeken",
"Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Neemt de regex expressies en berekent de inhoud tussen de REGEX labels en vervangt deze door de tekst.",
"Icon" => "Ikoon",
"Date" => "Datum",
"Automatically creates a link to the appropriate SourceForge object" => "Maak automatisch een koppeling aan naar het bijbehorende SourceForge object",
"Sheet Heading" => "Rekenblad Hoofding",
"TikiSheet" => "TikiRekenblad",
"Edit Sheet" => "Bewerk Rekenblad",
"List wiki pages" => "Lijst van wiki pagina's",
"Display" => "Toon",
"Last modified by" => "Laatst bijgewerkt door",
"Action" => "Actie",
"The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "De SNARF plugin vervangt zichzelf met het HTML-gedeelte van een URL. Willekeurig vervangingen op deze inhoud zijn mogelijk door gebruik te maken van regex of regexres waarbij de laatste als tweede argument dienst voor de preg_replace functie.",
"This data is put in a CODE caption." => "Deze gegevens worden in een CODE tekstkader geplaatst.",
"Missing url parameter for SNARF plugin." => "Ontbrekende url parameter voor de SNARF plugin.",
"Sorts the plugin content in the wiki page" => "Sorteer de inhoud van de plugin in de wiki pagina",
"Order" => "Volgorde",
"Split a page into rows and columns" => "Split een pagina in rijen en kolommen",
"First" => "Eerste",
"Edit" => "Bewerken",
"row1col1" => "rij1kol1",
"row1col2" => "rij1kol2",
"row2col1" => "rij2kol1",
"row2col2" => "rij2kol2",
"Run a sql query" => "Draai een sql commando",
"sql query" => "sql commando",
"Missing db param" => "Ontbrekende db param",
"Displays text in subscript." => "Toon tekst in kleinschrift.",
"Subscribe" => "Abonneren",
"Groups" => "Groepen",
"Thumbnail" => "Voorbeeldplaatje",
"Displays the thumbnail for an image" => "Voorbeeldplaatje van een afbeelding tonen",
"Original" => "Originele",
"Search the titles of all pages in this wiki" => "Zoek door de titles van alle pagina's in dit wiki",
"No pages found for title search" => "Geen pagina's gevonden voor titel zoekopdracht",
"One page found for title search" => "E&eacute;n pagina gevonden voor titel zoekopdracht",
"pages found for title search" => "pagina's gevonden voor titel zoekopdracht",
"Structure ID" => "Structuur ID",
"Public" => "Publiek",
"Translate" => "Vertaal",
"Fields" => "Velden",
"Preview" => "Voorbeeld tonen",
"preview" => "voorbeeld tonen",
"View" => "Bekijk",
"Error" => "Foutmelding",
"Displays an input form for tracker submit" => "Toon een invoerformulier voor trackeringave",
"Fields marked with a * are mandatory." => "Velden aangeduid met een * zijn verplicht.",
"Displays the output of a tracker content, fields are indicated with numeric ids." => "Uitvoer van tracker inhoud tonen, velden zijn aangegeven met numerieke ids.",
"Template" => "Sjabloon",
"Error in tracker ID" => "Fout in tracker ID",
"No field indicated" => "Geen veld opgegeven",
"Links to a translated content" => "Koppelingen naar vertaalde inhoud",
"Flag" => "Vlag",
"Displays the number of registered users" => "Toont het aantal geregistreerde gebruikers",
"User List" => "Gebruikerlijst",
"users" => "gebruikers",
"Preferences" => "Instellingen",
"User Information" => "Gebruikergegevens",
"Versions" => "Versies",
"Split the text in parts visible only under some conditions" => "Splits de tekst in delen die enkel onder bepaalde omstandigheden zichtbaar zijn",
"Vote" => "Stem",
"Table" => "Tabel",
"External Wiki" => "Extern Wiki",
"valid" => "geldig",
"width" => "breedte",
"height" => "hoogte",
"ERROR: Either the subject or body must be non-empty" => "FOUT: Onderwerp of tekstlichaam mag niet blanco zijn",
"ERROR: No valid users to send the message" => "FOUT: Geen geldige gebruikers om het bericht naar te zenden",
"Invalid user" => "Ongeldige gebruiker",
"Message sent to" => "Bericht verzonden naar",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Verzend postbus is vol. Verwijder of archiveer sommige berichten eerst vooraleer nieuwe te versturen.",
"User %s can not receive messages, mailbox is full" => "Gebruiker %s kan geen berichten ontvangen, haar/zijn postbus is vol",
"User %s can not receive messages" => "Gebruiker %s kan geen berichten ontvangen",
"Invalid user: %s" => "Ongeldige gebruiker: %s",
"Message will be sent to: " => "Bericht zal verstuurd worden naar: ",
"Archive is full. Delete some messages from archive first." => "Archief is vol. Verwijder eerst een aantal berichten uit het archief.",
"No more messages" => "Einde berichten",
"Tiki Calendar" => "Tiki Kalender",
"Calendar" => "Kalender",
"Please provide an Id" => "Geef aub een Id op",
"no object here yet" => "nog geen object hier",
"Create/Edit" => "Maken/bewerken",
"Quick Edit a Wiki Page" => "Een wikipagina snel bewerken",
"Post" => "Bijdrage",
"Changes since" => "Wijzigingen sinds",
"new comments" => "nieuwe opmerkingen",
"wiki pages changed" => "wikipagina's gewijzigd",
"new articles" => "nieuwe artikelen",
"new FAQs" => "nieuwe FAQs",
"new blogs" => "nieuwe blogs",
"new blog posts" => "nieuwe blogberichten",
"new image galleries" => "nieuwe beeldgalerijen",
"new images" => "nieuwe afbeeldingen",
"new file galleries" => "nieuwe bestandgalerijen",
"new files" => "nieuwe bestanden",
"new polls" => "nieuwe opiniepeilingen",
"new users" => "nieuwe gebruikers",
"The task title must have at least 3 characters" => "De takenlijst moet minimum 3 karakters bevatten",
"Invalid username or password" => "Ongeldige gebruikernaam of wachtwoord",
"country" => "land",
"Anti-Bot verification code" => "Anti-Bot verificatie code",
"Random Image" => "Willekeurige afbeelding",
"Enter the code you see above" => "Voer bovenstaande code in",
"List of attached files" => "Lijst van bijlagen",
"desc" => "omschr.",
"uploaded" => "aangeleverd",
"Download" => "Afhaling",
"Delete" => "Verwijder",
"Remove" => "Verwijderen",
"Upload file" => "Bestand aanleveren",
"Attach" => "Bijlage toevoegen",
"Attach a file to this item" => "Bestand als bijlage bij dit item voegen",
"Version" => "Versie",
"Attachments" => "Bijlagen",
"more info" => "meer informatie",
"No attachments for this item" => "Geen bijlagen voor dit item",
"Fatal error" => "Fatale fout",
"Created by" => "Gemaakt door",
"on" => "op",
"RSS feed" => "RSS-invoer",
"Edit blog" => "Werk blog bij",
"Monitor this Blog" => "Monitor dit blog",
"Stop Monitoring this Blog" => "Stop monitoring van dit blog",
"Activity=" => "Activiteit=",
"Actions" => "Acties",
"Properties" => "Eigenschappen",
"No records found" => "Geen records gevonden",
"Categorize" => "Categorizeer",
"Admin Categories" => "Categorie&euml;n beheren",
"No categories defined" => "Geen categorie&eacute; gedefinieerd",
"Browse Category" => "Bekijk categorie",
"posts:" => "berichten:",
"stars" => "sterren",
"User Level" => "Gebruikerniveau",
"private message" => "priv�-bericht",
"Send eMail to User" => "Verstuur e-mail naar gebruiker",
"user online" => "gebruiker online",
"user offline" => "gebruiker offline",
"Reply" => "Beantwoorden",
"Approve" => "Goedkeuren",
"Reject" => "Verwerp",
"Save to notepad" => "Naar kladblok opslaan",
"Monitor this Topic" => "Monitor dit onderwerp",
"Stop Monitoring this Topic" => "Stop monitoring van dit onderwerp",
"Moderator actions" => "Moderator acties",
"reported:" => "gemelde:",
"queued:" => "in wachtrij geplaatste:",
"Move to topic:" => "Verplaats naar onderwerp:",
"Move" => "Verplaats",
"Delete Selected" => "Verwijder geselecteerde",
"Unlock" => "Ontgrendelen",
"Lock" => "Vergrendelen",
"Messages" => "Berichten",
"Plain" => "Gewone",
"Headers Only" => "Enkel Hoofding",
"Newest first" => "Nieuwste eerst",
"Oldest first" => "Oudste eerst",
"Title (desc)" => "Titel (dalend)",
"Title (asc)" => "Titel (stijgend)",
"Threshold" => "Drempelwaarde",
"Replies" => "Antwoorden",
"below your current threshold" => "beneden de huidige limiet",
"New Reply" => "Nieuw antwoord",
"Editing reply" => "Bewerk aantwoord",
"Reply to the selected post" => "Beantwoord het aangeduide bericht",
"Editing comment" => "Bewerking van opmerking",
"Comment on the selected post" => "Lever commentaar op het aangeduide bericht",
"Post new comment" => "Nieuwe opmerking toevoegen",
"Quicktags" => "SnelLabels",
"Reply to parent post" => "Beantwoord bovenliggend bericht",
"Post new reply" => "Lever nieuw antwoord aan",
"Cancel" => "Annuleer",
"Posting replies" => "Beantwoorden",
"Posting comments" => "Opmerkingen toevoegen",
"Use" => "Gebruik",
"for links" => "voor koppelingen",
"HTML tags are not allowed inside posts" => "HTML-labels zijn niet toegestaan in berichten",
"Add Comment" => "Commentaar",
"1 comment" => "1 commentaar",
"Comments" => "Opmerkingen",
"Go back" => "Ga terug",
"Return to home page" => "Terug naar startpagina",
"Copyrights" => "Auteursrechten",
"Authors" => "Auteurs",
"Add" => "Toevoegen",
"Syntax" => "Schrijfwijze",
"Page generation debugging log" => "Paginageneratie debugging log",
"Features state" => "Status onderdelen",
"Total" => "Totaal",
"features matched" => "overeenkomende onderdelen",
"Watchlist" => "Monitorlijst",
"duplicate" => "duplicaat",
"There are individual permissions set for this file gallery" => "Er bestaan individuele permissies voor deze bestandgalerij",
"Save" => "Bewaren",
"Gallery is visible to non-admin users?" => "Is galerij is zichtbaar voor niet-beheerders?",
"unlimited" => "onbeperkt",
"none" => "geen",
"Parent gallery" => "Oudergalerij",
"Default sort order" => "Standaard sorteervolgorde",
"descending" => "dalend",
"ascending" => "stijgend",
"Max description display size" => "Max schermgrootte beschrijving",
"Max Rows per page" => "Max. aantal rijen per pagina",
"Listing configuration" => "Lijst configuratie",
"Please login" => "Meldt u aan aub",
"There are no wiki pages similar to '{\$page}'" => "Er zijn geen gelijkwaardige wiki pagina's aan '{\$page}'",
"Create this page" => "Maak deze pagina aan",
"(page will be orphaned)" => "(pagina zal verweesd worden)",
"Close Window" => "Sluit venster",
"Active Perms" => "Actieve perms",
"Perms" => "Perm.",
"Replace" => "Vervang",
"List" => "Lijst",
"Browse" => "Bladeren",
"Name-filename" => "Naam-bestandnaam",
"Filename only" => "Enkel bestandnaam",
"Close" => "Sluit",
"Exact&nbsp;match" => "Exact&nbsp;overeenkomen",
"Number of displayed rows" => "Aantal getoonde rijen",
"Go" => "Tonen",
"RSS Articles" => "RSS Artikelen",
"RSS Image Galleries" => "RSS Afbeeldinggalerijen",
"RSS File Galleries" => "RSS Bestandgalerijen",
"RSS Maps" => "RSS Kaarten",
"Perform action with checked:" => "Voer actie uit met geselecteerde:",
"Move Selected Files" => "Verplaats geselecteerde bestanden",
"Assign Permissions" => "Wijs Permissies toe",
"Move to" => "Verplaats naar",
"Assign" => "Toekennen",
"Filename" => "Bestandnaam",
"Hi {\$mail_user} has sent you this link:" => "Hallo {\$mail_user} stuurt u deze koppeling:",
"Blog post:" => "Blogbericht:",
"at:" => "op:",
"Somebody or you tried to subscribe this email address at our site:" => "Iemand of uzelf heeft zich onder dit e-mail addressen proberen te abonneren op onze site:",
"To the newsletter:" => "Op deze nieuwsbrief:",
"Description:" => "Omschrijving:",
"In order to confirm your subscription you must access the following URL:" => "Om uw abonnement te bevestigen gelieve naar volgende URL te gaan:",
"A new message was posted to forum" => "Een nieuwe bijdrage is aanwezig op het forum",
"New topic:" => "Nieuw onderwerp:",
"Topic:" => "Onderwerp:",
"You sent a request with the subject:" => "U stuurde een verzoek met als titel:",
"Use the subject to indicate the operation to apply:" => "Gebruik het onderwerp om aangeven welke actie te ondernemen:",
"GET:WikiName to get a wiki page" => "GET:WikiName om een wiki pagina af te halen",
"PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName om een wiki pagina aan te maken of te plaatsen (gebruik het tetstlichaam voor de tekstgegevens)",
"APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName om gegevens aan een Wiki pagina toe te voegen (gebruik het tetstlichaam voor de tekstgegevens)",
"PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName om gegevens aan het begin toe te voegen",
"Tiki mail-in instructions" => "Tiki mail-in instructies",
"Tiki mail-in auto-reply." => "Tiki mail-in auto-antwoord.",
"Page not found:" => "Pagina niet gevonden:",
"Hi," => "Hallo,",
"A new message was posted to you at {\$mail_machine}" => "Er is een nieuw bericht voor u aangekomen op {\$mail_machine}",
"From" => "Van",
"New message arrived from %s" => "Nieuw bericht binnengekomen van %s",
"Hi" => "Hallo",
"Enjoy the site!" => "Veel plezier met de site!",
"has requested an account on" => "heeft een account aangevraagd op",
"To validate that account, please follow the link:" => "Om dit account te bevestigen gelieve deze koppeling te volgen:",
"best regards" => "met vriendelijke groeten",
"your Tikiwiki" => "uw Tikiwiki",
"User Registration Request" => "Tiki Gebruikersregistratie Verzoek",
"You're invited to join my network of friends!" => "U bent uitgenodigd om u bij mijn netwerk van vrienden aan te sluiten!",
"The user" => "De gebruiker",
"registered at your site" => "heeft zich geregistreerd op uw site",
"New user registration" => "Nieuwe gebruikerregistratie",
"Bye bye!" => "Tot ziens!",
"This email address has been removed to the list of subscriptors of:" => "Dit e-mail adres is verwijderd van de abonneelijst van:",
"Newsletter:" => "Nieuwsbrief:",
"Bye bye from %s at %s" => "Tot ziens van %s aan %s",
"You can unsubscribe from this newsletter following this link" => "U kan zich van deze nieuwsbrief afmelden via volgende koppeling",
"Welcome to our newsletter!" => "Welkom bij onze nieuwsbrief!",
"This email address has been added to the list of subscriptors of:" => "Dit e-mail adress is toegevoegd aan de abonneelijst van:",
"You can always cancel your subscription using:" => "U kan ten alle tijde uw abonnement stopzetten via:",
"Welcome to %s at %s" => "Welkom aan %s van %s",
"Email notification" => "Tiki e-mail melding",
"Since this is your registered email address we inform that the password for this account is" => "Sinds dit uw geregistreerd e-mail adres is, informeren we u dat het wachtwoord voor dit account het volgende is",
"Your account information for %s" => "Uw Tiki account informatie voor %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Een nieuw artikel werd aangemeld door {\$mail_user} via {\$mail_site} op {\$mail_date|tiki_short_datetime}",
"You can edit the submission following this link:" => "U kan de bijdrage via deze koppeling bewerken:",
"Title:" => "Titel:",
"Heading:" => "Hoofding:",
"Body:" => "Tekstlichaam:",
"New article submitted at %s" => "Nieuw artikel aangeleverd bij %s",
"User:" => "Gebruiker:",
"You or someone registered this email address at" => "uzelf of iemand anders registreerde dit e-mail adres bij",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Indien u zich als geregistreerde bezoeker op deze site wilt kenbaar maken, gelieve dan volgende koppeling te volgen om u zich voor de eerste maal aan te melden:",
"Your registration confirmation" => "Uw Tiki informatie registratie",
"You will receive an email with information to login for the first time into this site" => "U zal een e-mail ontvangen met informatie over hoe u zich voor de eerste maal op deze site kan aanmelden",
"Your account request has been stored and will be activated by the admin as soon as possible." => "Uw account verzoek werd opgeslagen en zal zo snel mogelijk door een beheerder behandelde worden.",
"View the article at:" => "Bekijk het artikel op:",
"If you don't want to receive these notifications follow this link:" => "Volg deze koppeling indien u deze melding niet wenst te ontvagen:",
"View the blog at:" => "Bekijk het blog op:",
"New blog post at %s" => "Nieuw blogbericht bij %s",
"changed" => "gewijzigd",
"created" => "gemaakt",
"Removed by" => "Verwijderd door",
"File Gallery %s changed" => "Verandering in bestandgalerij %s",
"A file was removed from the file gallery" => "Een bestand werd verwijderd uit de bestandgalerij",
"File Name" => "Bestandsnaam",
"A new file was posted to file gallery" => "Een nieuw bestand werd aangeleverd in de bestandgalerij",
"Posted by" => "Aangeleverd door",
"File Description" => "Bestandomschrijving",
"The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "De landkaart {\$mail_page} werd bijgewerkt door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"You can view the updated map following this link:" => "U kan de bijgewerkte landkaart via deze koppeling bekijken:",
"You can edit the map following this link:" => "U kan de landkaart bijwerken via volgende koppeling:",
"The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "De pagina {\$mail_page} werd aangemaakt door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "De pagina {\$mail_page} werd bijgewerkt door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"Comment:" => "Commentaar:",
"You can view the page by following this link:" => "U kan de pagina bekijken via volgende koppeling:",
"You can view a diff back to the previous version by following this link:" => "U kan een verschil met de vorige versie beijken via volgende koppeling:",
"The changes in this version follow below, followed after by the current full page text." => "Zie beneden voor de veranderingen in deze versie, gevolgd door de volledige versie van de huidige tekst.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Lijnen: {\$oldd} aangepast tot +Lijnen: {\$newd}",
"The new page content follows below." => "De nieuwe pagina inhoud volgt beneden.",
"The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "De pagina {\$mail_page} werd becommentarieerd door {\$mail_user} op {\$mail_date|tiki_short_datetime}",
"New name" => "Nieuwe naam",
"click on the map to zoom or pan, do not drag" => "klik op de landkaart om te zoomen or te verschuiven",
"Scale" => "Schaal",
"Query" => "Vraag",
"Pan" => "Schuif",
"Redraw" => "Herteken",
"select zoom/pan/query and image size" => "selecteer zoom/verschuif/vraag en grootte afbeelding",
"View the Map Only" => "Bekijk enkel de Kaart",
"Reset Map" => "Reset Kaart",
"Click on the map or click redraw" => "Klik op de landkaart of klik herteken",
"Last modification date" => "Datum laatste wijziging",
"Overview" => "Overzicht",
"Legend" => "Legende",
"Layer Manager" => "Lagen beheren",
"Layer" => "Laag",
"On" => "Aan",
"Download Layer" => "Haal Laag af",
"This layer has been set by the maps administrator to not be downloadable" => "Deze laag is door de kaartenbeheerder als niet afhaalbaar gevlagd",
"you have requested to download the layer:" => "u heeft gevraagd om de volgende laag af te halen:",
"Here are the files to download, do not forget to rename them:" => "Hier zijn de bestanden om af te halen, vergeet niet om ze te hernoemen:",
"Mapfiles" => "Landkaartbestanden",
"Mapfile" => "Landkaartbestand",
"Available mapfiles" => "Beschikbare landkaartbestanden",
"monitor this map" => "monitor deze landkaart",
"Stop Monitoring this Map" => "Stop de monitoring van deze landkaart",
"Create a new mapfile" => "Maak een nieuw landkaartbestand aan",
"Create" => "Maak aan",
"Mapfile listing" => "Opsommen landkaartbestanden",
"Reload" => "Herlaad",
"History" => "Geschiedenis",
"You can view this map in your browser using" => "Je kan deze landkaart in je browser bekijken via",
"Zoom out x2" => "Zoom uit x2",
"Mapfile History" => "Kaartenbestand Historiek",
"of" => "van",
"Compare" => "Vergelijken",
"Comparing version {\$old.version} with version {\$new.version}" => "Vergelijk versie {\$old.version} met versie {\$new.version}",
"Version:" => "Versie:",
"Current" => "Huidig",
"Versions are identical" => "Versies zijn identiek",
"Legend:" => "Legende:",
"v=view" => "v=bekijk (view)",
"c=compare" => "c=vergelijk (compare)",
"d=diff" => "d=verschillen (diff)",
"Full side-by-side diff" => "Volledige zij-langs-zij verschillen",
"Unified diff" => "Uniforme verschillen",
"Side-by-side view" => "Bekijk zij-langs-zij",
"User" => "Gebruiker",
"Ip" => "IP",
"Diff" => "Verschillen",
"Older Version" => "Oudere versie",
"Directories" => "Folders",
"back to" => "terug naar",
"Upload From Disk:" => "Lever aan van Schijf:",
"Upload Files" => "Lever Bestanden aan",
"Bytes maximum" => "maximum Bytes",
"Create Directory:" => "Maak Folder aan:",
"index file (.shp):" => "index bestand (.shp):",
"files to index (regexp):" => "bestanden om te indexeren (regexp):",
"Message Archive" => "Brichtenarchief",
"messages" => "berichten",
"Archive is full!" => "Archief is vol!",
"Unread" => "Ongelezen",
"Flagged" => "Gevlagd",
"Unflagged" => "Niet-gevinkt",
"Containing" => "Bevat",
"Sender" => "afzender",
"No messages to display" => "Geen berichten te tonen",
"Broadcast message" => "Stuur oproep",
"OK" => "Ok",
"All users" => "Alle gebruikers",
"Lowest" => "Laagste",
"Low" => "Laag",
"Normal" => "Normaal",
"High" => "Hoog",
"Very High" => "Zeer Hoog",
"Send" => "Zenden",
"Compose message" => "Bericht opstellen",
"Invalid" => "Ongeldig",
"To" => "Naar",
"No messages to download" => "Geen berichten om af te halen",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Postbus is vol! Verwijder of archiveer berichten als je nog nieuwe boodschappen wil ontvangen.",
"Find replied message" => "vind beantwoord bericht",
"Archive" => "Archief",
"Mark as read" => "Als gelezen markeren",
"Mark as unread" => "Als ongelezen markeren",
"Mark as flagged" => "Selecteer als gevinkt",
"Mark as unflagged" => "Als niet flagged markeren",
"Mark" => "markeer",
"Mailbox" => "Postbus",
"Compose" => "Opstellen",
"Broadcast" => "Oproep",
"Sent" => "Verzonden",
"Auto-archive age for read messages:" => "Auto-archiveer ouderdom voor gelezen berichten:",
"Read message" => "Lees bericht",
"Return to mailbox" => "Ga terug naar postbus",
"replyall" => "antwoordallen",
"Unflag" => "Verwijder vink",
"Flag this message" => "Bericht aanvinken",
"Return to archive" => "Keer terug naar archief",
"Return to outbox" => "Keer terug naar UIT postbus",
"Sent Messages" => "Verzonden berichten",
"Replied" => "Beantwoord",
"Not replied" => "Niet beantwoord",
"move to archive" => "verplaats naar archief",
"receiver" => "ontvanger",
"'name' parameter for tikimodule missed" => "'naam' parameter voor tikimodule ontbreekt",
"Move module up" => "Schuif module naar boven",
"Up" => "Omhoog",
"Move module down" => "Schuif module naar beneden",
"Down" => "Omlaag",
"Move module to opposite side" => "Schuif module naar de andere kant",
"opp side" => "tegengestelde kant",
"Unassign this module" => "Toekenning van module ongedaan maken",
"Are you sure you want to unassign this module?" => "Bent u zeker dat u de toekenning van deze module wilt ongedaan maken?",
"Admin Menu" => "Menu Beheren",
"Banning" => "Verbanning",
"Users" => "Gebruikers",
"Cache" => "Buffer",
"Links" => "Koppelingen",
"Hotwords" => "Trefwoorden",
"RSS Modules" => "RSS-modules",
"Menus" => "Menu's",
"Polls" => "Opiniepeilingen",
"Mail Notifications" => "E-mail meldingen",
"Search Stats" => "Zoek Stats",
"QuickTags" => "SnelLabels",
"Chat" => "Praatkamer",
"Categories" => "Categorie&euml;n",
"Banners" => "Advertenties",
"Edit Templates" => "Sjablonen bewerken",
"HTML Pages" => "HTML Pagina's",
"Shoutbox" => "Spreekbuis",
"Shoutbox Words" => "Spreekbuis woorden",
"Referer Stats" => "Verwijzerstatistieken",
"Import PHPWiki Dump" => "Importeer PHPWiki Dump",
"Admin dsn" => "Beheer dsn",
"Security Admin" => "Veiligheidsbeheer",
"Tikiwiki Assistant" => "Tikiwiki Assistent",
"Thank you for installing Tikiwiki" => "Dank u voor het installeren van Tikiwiki",
"Select" => "Selecteer",
"Admin" => "Beheer",
"Admin Modules" => "Modules beheren",
"Admin Menus" => "Menu's beheren",
"login" => "aanmelden",
"Recently visited pages" => "Onlangs bezochte pagina's",
"January" => "Januari",
"February" => "Februari",
"March" => "Maart",
"May" => "Mei",
"June" => "Juni",
"July" => "Juli",
"August" => "Augustus",
"October" => "Oktober",
"Tuesday" => "dinsdag",
"Wednesday" => "woensdag",
"Thursday" => "donderdag",
"Friday" => "vrijdag",
"Today" => "Vandaag",
"Received objects" => "Ontvangen objecten",
"Pages:" => "Pagina's:",
"Last `\$module_rows` Sites" => "Laatste `\$module_rows` Sites",
"Last Sites" => "Laatste Sites",
"Directory Stats" => "Koppelingenlijst Statistieken",
"Sites to validate" => "Sites te valideren",
"Searches" => "Zoekopdrachten",
"Visited links" => "Bezochte koppelingen",
"Featured links" => "Aanbevolen koppelingen",
"Top `\$module_rows` topics" => "Top `\$module_rows` onderwerpen",
"Top topics" => "Toponderwerpen",
"Last `\$module_rows` forum posts" => "Laatste `\$module_rows` forum berichten",
"Last forum posts" => "Laatste forumberichten",
"Last `\$module_rows` forum topics" => "Laatste `\$module_rows` forum onderwerpen",
"Last forum topics" => "Laatste forumonderwerpen",
"Most commented forums" => "Forums met meest opmerkingen",
"Most read topics" => "Meest gelezen onderwerpen",
"Most visited forums" => "Meest bezochte forums",
"Google Search" => "Google Zoeken",
"Last `\$module_rows` actions" => "Laaste `\$module_rows` acties",
"Last actions" => "Laaste acties",
"Last `\$module_rows` articles" => "Laatste `\$module_rows` artikelen",
"Last articles" => "Laatste artikelen",
"Last `\$module_rows` blog posts" => "Laatste `\$module_rows` blogberichten",
"Last blog posts" => "Laatste blogbijdragen",
"Last" => "Laatste",
"Last `\$module_rows` Created blogs" => "Laatste `\$module_rows` aangemaakte blogs",
"Last Created blogs" => "Laatst gemaakte blogs",
"Last `\$module_rows` Created FAQs" => "Laatste `\$module_rows` aangemaakte FAQs",
"Last Created FAQs" => "Laatst Gemaakte FAQs",
"Last `\$module_rows` Created Quizzes" => "Laatste `\$module_rows` aangemaakte Quizzen",
"Last Created Quizzes" => "Laatst Gemaakte Quizzen",
"Last `\$module_rows` modified file galleries" => "Laatste `\$module_rows` bijgewerkte bestandgalerijen",
"Last modified file galleries" => "Laatst gewijzigde bestandgalerijen",
"Last `\$module_rows` Files" => "Laatste `\$module_rows` Bestanden",
"Last Files" => "Laatste Bestanden",
"Last `\$module_rows` galleries" => "Laatste `\$module_rows` galerijen",
"Last galleries" => "Laatste galerijen",
"Last `\$module_rows` Images" => "Laatste `\$module_rows` Afbeeldingen",
"Last Images" => "Laatste Afbeeldingen",
"Last `\$module_rows` modified events" => "Laatste `\$module_rows` bijgewerkte gebeurtenissen",
"Last modifed events" => "Laatste bijgewerkte gebeurtenissen",
"Last `\$module_rows` changes" => "Laatste `\$module_rows` veranderingen",
"Last changes" => "Laatste wijzigingen",
"Last `\$module_rows` Modified Items" => "Laatste `\$module_rows` bijgewerkte Items",
"Last Modified Items" => "Laatst Gewijzigde Items",
"Last `\$module_rows` Modified blogs" => "Laatste `\$module_rows` bijgewerkte blogs",
"Last Modified blogs" => "Laatst gewijzigde blogs",
"Last `\$module_rows` submissions" => "Laatste `\$module_rows` Bijdragen",
"Last submissions" => "Laatste bijdragen",
"Last `\$module_rows` Items" => "Laatste `\$module_rows` Items",
"Last Items" => "Laatste Items",
"Last `\$module_rows` visitors" => "Laatste `\$module_rows` bezoekers",
"Last Visitors" => "Laaste bezoekers",
"Register" => "Registreren",
"Live support" => "Live-ondersteuning",
"Online users" => "Gebruikers on-line",
"We have" => "We hebben",
"online users" => "online gebruikers",
"Logged in as" => "Ingelogd als",
"Logout" => "Afmelden",
"Switch User" => "Wissel van Gebruiker",
"Switch" => "Draai om",
"Login through CAS" => "Aanmelding via CAS",
"Login as admin" => "Aanmelding als beheerder",
"Email" => "E-mail",
"eMail" => "E-mail",
"Password" => "Wachtwoord",
"Remember me" => "Onthouden login",
"month" => "maand",
"year" => "jaar",
"Click here to register" => "Klik hier om te registeren",
"Click here if you've forgotten your password" => "Klik hier indien u uw wachtwoord bent vergeten",
"I forgot my password" => "Ik ben mijn wachtwoord vergeten",
"Click here to login using the default security protocol" => "Klik hier om met het standaard veiligheidsprotocol aan te melden",
"Standard" => "Standaard",
"Click here to login using a secure protocol" => "Klik hier om met het beveiligde protocol aan te melden",
"Secure" => "Veilig",
"Stay in ssl Mode" => "In ssl-modus blijven",
"You have" => "U heeft",
"New Messages" => "Nieuwe berichten",
"New Message" => "Nieuw bericht",
"You have 0 new messages" => "U heeft geen nieuwe berichten",
"Waiting Submissions" => "Wachtende Bijdragen",
"submissions waiting to be examined" => "bijdragen die nog moeten bekeken worden",
"Old articles" => "Oude artikelen",
"Send a message to" => "Stuur een bericht naar",
"Random Pages" => "Toevallige Pagina's",
"Register as a new user" => "Als nieuwe gebruiker registreren",
"Your email could not be validated; make sure you email is correct and click register below." => "Uw e-mail adres kan niet worden gevalidderd; zorg er aub voor dat uw e-mail adres correct is en klik op onderstaande koppeling om u te registreren.",
"Your registration code:" => "Uw registratie code:",
"Username" => "Gebruikernaam",
"Passcode to register (not your user password)" => "Pascode om te registreren (niet uw gebruikerwachtwoord)",
"Registration code" => "Registratie code",
"Repeat password" => "Opnieuw",
"Generate a password" => "Maak een wachtwoord aan",
"Articles RSS" => "Artikelen RSS",
"Image Galleries RSS" => "Beeldgalerijnen RSS",
"Image Galleries" => "Beeldgalerijen",
"File Galleries RSS" => "Bestandgalerijen RSS",
"File Galleries" => "Bestandgalerijen",
"Maps RSS" => "Landkaarten RSS",
"Maps" => "Landkaarten",
"Entire Site" => "Volledige Site",
"Wiki Pages" => "Wikipagina's",
"Image Gals" => "Beeldgalerijen",
"Images" => "Afbeeldingen",
"Blog Posts" => "Blogbijdragen",
"Search Wiki PageName" => "Zoek Wiki PaginaNaam",
"Read More" => "Verderlezen",
"Since your last visit" => "Sinds uw laatste bezoek",
"Since your last visit on" => "Sinds uw laatste bezoek op",
"New Images" => "Nieuwe afbeeldingen",
"Wiki Pages Changed" => "Wikipagina's gewijzigd",
"New Files" => "Nieuwe bestanden",
"New Comments" => "Nieuwe opmerkingen",
"New Users" => "Nieuwe gebruikers",
"click to edit" => "klik om te bewerken",
"Nothing has changed" => "Er zijn geen wijzigingen",
"Theme" => "Thema",
"Most Active blogs" => "Actiefste blogs",
"Top `\$module_rows` articles" => "Top `\$module_rows` artikelen",
"Top articles" => "Topartikelen",
"Top `\$module_rows` File Galleries" => "Top `\$module_rows` Bestandgalerijen",
"Top File Galleries" => "Topbestandgalerijen",
"Top `\$module_rows` files" => "Top `\$module_rows` bestanden",
"Top files" => "Top bestanden",
"Top `\$module_rows` games" => "Top `\$module_rows` spellen",
"Top games" => "Topspelletjes",
"Top `\$module_rows` galleries" => "Top `\$module_rows` galerijen",
"Top galleries" => "Topgalerijen",
"Top `\$module_rows` Images" => "Top `\$module_rows` Afbeeldingen",
"Top Images" => "Topafbeeldingen",
"Top `\$module_rows` Pages" => "Top `\$module_rows` Pagina's",
"Top Pages" => "Toppagina's",
"Top `\$module_rows` Quizzes" => "Top `\$module_rows` Quizzen",
"Top Quizzes" => "Topquizzen",
"Most `\$module_rows` visited blogs" => "`\$module_rows` meest bezochte blogs",
"Top `\$module_rows` Visited FAQs" => "Top `\$module_rows` bezochte FAQs",
"Top Visited FAQs" => "Meest Bezochte FAQs",
"view" => "bekijken",
"click to view" => "Klik om te bekijken",
"My blogs" => "Mijn blogs",
"Bookmarks" => "Favorieten",
"My galleries" => "Mijn galerijen",
"My Pages" => "Mijn pagina's",
"User tasks" => "Gebruikertaken",
"Done" => "gedaan",
"Del" => "Verw",
"Public tasks" => "Publieke taken",
"select" => "selecteer",
"User informations" => "Gebruikerinformatie",
"Group informations" => "Groepinformatie",
"Top users" => "Top gebruikers",
"Whats related" => "Wat is gerelateerd",
"online user" => "online gebruikers",
"Last `\$module_rows` wiki comments" => "Laatste `\$module_rows` wiki commentaren",
"Last wiki comments" => "Laatste wiki commentaren",
"on page" => "op pagina",
"Real Name" => "Echte Naam",
"vote" => "stemmen",
"Send Newsletter" => "Stuur nieuwsbrief",
"Structures:" => "Strukturen:",
"show structures" => "toon structuren",
"hide structures" => "verberg strukturern",
"Manage structures" => "Beheer structuren",
"Location : " => "Locatie : ",
"Find:" => "Zoek:",
"pages" => "pagina's",
"To edit the copyright notices" => "Om de berichten mbt auteursrechten te wijzigen",
"Click Here" => "Klik hier",
"The content on this page is licensed under the terms of the" => "De inhoud van deze pagina is gelicensieerd onder de voorwaarden van",
"Print" => "Afdrukken",
"Email This Post" => "e-mail deze bijdrage",
"comment" => "opmerking",
"comments" => "opmerkingen",
"First page" => "Startpagina",
"Previous page" => "Vorige pagina",
"page" => "pagina",
"Next page" => "Volgende pagina",
"Last page" => "Laatste pagina",
"referenced by" => "gerefereerd door",
"references" => "referenties",
"View Comments" => "Opmerkingen bekijken",
"Blog name" => "Blognaam",
"Enlarge area height" => "Vergroot hoogte vak",
"Reduce area height" => "Verklein hoogte vak",
"Calendar View" => "Bekijk kalender",
"List View" => "Bekijk lijst",
"Tiki Action Calendar" => "Tiki Actie Kalender",
"Tools Calendars" => "Hulpmiddelen Kalenders",
"Check / Uncheck All" => "Vink aan/ vink uit allen",
"Refresh" => "Ververs",
"Cancel Edit" => "Bewerking annuleren",
"Change preferences" => "Instellingen wijzigen",
"Site Ads and Banners" => "Site Advertenties en Banners",
"Content" => "Inhoud",
"Activate" => "Activeren",
"Publish" => "Publiceren",
"General" => "Algemeen",
"Features" => "Onderdelen",
"Meta Tags" => "Meta-labels",
"Community" => "Gemeenschap",
"User files" => "Gebruikerbestanden",
"To add/remove blogs, go to \"Create/Edit Blog\" under \"Blogs\" on the application menu, or" => "Om blogs toe te voegen of te verwijderen, ga naar \"Maak aan/Bewerk Blog\" onder \"Blogs\" in het applicatiemenu, of",
"General Settings" => "Algemene Instellingen",
"Home Blog (main blog)" => "Startblog (hoofdblog)",
"Rankings" => "Rangordes",
"Not Installed" => "Niet Geinstalleerd",
"Points" => "Punten",
"Creation date" => "Aanmaakdatum",
"Last modified" => "Laatst gewijzigd",
"Change settings" => "Wijzig instellingen",
"Permissions" => "Permissies",
"Ignore category viewing restrictions" => "Negeer restrictries op bezichtiging van categorie&euml;n",
"Look under \"Articles\" on the application menu for links to" => "Zoek onder \"Artikelen\" in het applicatie menu voor koppelingen naar",
"Topic" => "Thema",
"Submissions" => "Bijdragen",
"Import CSV file" => "Importeer CSV bestand",
"Import" => "Importeren",
"Visible" => "zichtbaar",
"avatar" => "pictogram",
"Number of friends" => "Aantal vrienden",
"Last login" => "Laatste aanmelding",
"Distance" => "Afstand",
"default" => "standaard",
"Number of visited pages to remember" => "Aantal bezochte pagina's die moeten herinnerd worden",
"Displayed time zone" => "Getoonde tijdzone",
"User information" => "Gebruikerinformatie",
"Private" => "Privaat",
"public" => "publiek",
"Use double-click to edit pages" => "Gebruik dubbelklik om pagina's te bewerken",
"Show user's info on mouseover" => "Toon gebruikersinformatie bij muisover",
"Tasks per page" => "Taken per pagina",
"Messages per page" => "Berichten per pagina",
"Allow messages from other users" => "Berichten toestaan van andere gebruikers",
"Send me an email for messages with priority equal or greater than" => "Mij een e-mail versturen voor berichten met prioriteit groter dan of gelijk aan",
"Auto-archive read messages after x days" => "Auto-archiveer gelezen berichten na x dagen",
"never" => "nooit",
"My Tiki" => "Mijn Tiki",
"My pages" => "Mijn pagina's",
"My messages" => "Mijn berichten",
"My tasks" => "Mijn taken",
"My items" => "Mijn items",
"My workflow" => "Mijn workflow",
"Feature" => "Kenmerk",
"To configure your directory, find \"Admin Directory\" under \"Directory\" on the application menu, or" => "Om uw directory in te stellen, ga naar \"Beheer directory\" onder \"Directory\" in het applicatiemenu, of",
"Number of columns per page when listing categories" => "Aantal kolommen per pagina wanneer categorie&euml;n opgesomd worden",
"Links per page" => "Links per pagina",
"Validate URLs" => "URLs valideren",
"enable cool sites" => "schakel leuke sites in",
"Method to open directory links" => "Methode om koppelingen uit koppelingenlijst te openen",
"New Window" => "Niew venster",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "Om FAQs toe te voegen of te verwijderen, ga naar \"Beheer FAQs\" onder \"FAQs\" in het applicatiemenu, of",
"Default number of comments per page" => "Standaard aantal opmerkingen per pagina",
"Comments default ordering" => "Standaardvolgorde opmerkingen",
"Newsletters" => "Nieuwsbrieven",
"Multilingual" => "Meertalig",
"Surveys" => "Opinieonderzoeken",
"Featured Help" => "Aanbevolen Help",
"Copyright System" => "Copyright Systeem",
"Copyright system" => "Copyright systeem",
"Live support system" => "Live-ondersteuningssysteem",
"Tell a Friend" => "Zeg het aan een vriend",
"Contact Us" => "Contacteer Ons",
"PhpLayers Dynamic menus" => "PhpLayers Dynamische menus",
"Mobile" => "Mobiel",
"Tiki Sheet" => "Tiki Rekenblad",
"Drawings" => "Tekeningen",
"Friendship Network" => "Vriendschapsnetwerk",
"Games" => "Spelletjes",
"Administration Features" => "Beheermodule",
"Banning System" => "Banning Systeem",
"Banning system" => "Verbanningsssysteem",
"Stats" => "Statistieken",
"Communications (send/receive objects)" => "Communicatie (objecten zenden/ontvangen)",
"Custom Home" => "Eigen Thuis",
"User Features" => "Gebruiker Onderdelen",
"Display 'MyTiki' in the application menu" => "Toon 'MyTiki' in het applicatiemenu",
"Mini Calendar" => "Mini-Kalender",
"User Preferences Screen" => "Gebruikervoorkeuren Scherm",
"User Notepad" => "Gebruikerkladblok",
"User Bookmarks" => "Gebruikerfavorieten",
"User Contacts" => "Contacten gebruiker",
"User Watches" => "Gebruikermonitors",
"User Watches Translations" => "Gebruikers Monitoren Vertalingen",
"User Menu" => "Gebruikermenu",
"User Tasks" => "Gebruikertaken",
"User Messages" => "Gebruikerboodschappen",
"User Files" => "Gebruikerbestanden",
"Newsreader" => "Nieuwslezer",
"User Levels" => "Gebruikersniveau",
"XMLRPC API" => "XMLRPC-API",
"Debugger Console" => "Foutcontrole",
"Workflow" => "Werkschema",
"Workflow engine" => "Werkschema engine",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Indien u besluit om bestanden in een folder op te slaan, dient u ervoor te zorgen dat de gebruiker geen rechtstreekse toegang heeft tot deze folder.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "U heeft twee manieren om dit te bewerkstelligen:<br /><ul><li>Gebruik een folder die buiten uw \\'document root\\' ligt, zorg er dan wel voor dat het Tiki in deze folder kan lezen en schrijven</li><li>Gebruik een folder die binnen uw \\'document root\\' ligt in combinatie met een .htaccess bestand om er voor te zorgen dat gebruikers de inhoud van de folder niet kunnen lijsten</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Om het folderpad the configureren, gebruik UNIX-achtige paden bijv. bestanden/ of c:/foo/bestanden of /www/bestanden/",
"Home Gallery (main gallery)" => "Startgalerij (hoofdgalerij)",
"Allow same file to be uploaded more than once" => "Laat toe om hetzelfde bestand meermaals aan te leveren",
"Never" => "Nooit",
"Reindex all files for search" => "Herindexeer alle bestanden voor de zoekfunctie",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Om forums toe te voegen of te verwijderen, ga naar \"Beheer forums\" onder \"Forums\" in het applicatiemenu, of",
"Home Forum (main forum)" => "Startforum (hoofdforum)",
"Accept wiki syntax" => "Aanvaardt wiki schrijfwijze",
"Topics" => "Onderwerpen",
"Posts per day" => "Bijdragen per dag",
"Browser width" => "Browser breedte",
"Browser height" => "Browser hoogte",
"Navigation depth" => "Navigatiediepte",
"Feed animation interval (milisecs)" => "Animatiestroom interval (milliseconden)",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Om afbeeldinggalerijen toe te voegen of te verwijderen, ga naar \"Afbeeldinggalerijen\" in het applicatiemenu, of",
"You can upload images of a size of " => "U kan afbeeldingen aanleveren tot een grootte van ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "Pas de php.ini file_uploads, upload_max_filesize, post_max_size en database variables aan (max_allowed_packet voor mysql) om deze waarde te veranderen",
"Home Gallery" => "Thuisgalerij",
"Galleries features" => "Galerij-onderdelen",
"Uses Slideshow" => "Gebruik Slideshow",
"Use database to store images" => "Databank gebruiken om afbeeldingen op te slaan",
"Use a directory to store images" => "Een folder gebruiken om afbeeldingen op te slaan",
"Directory path" => "Folderpad",
"Library to use for processing images" => "Bibliotheek om afbeeldingen te verwerken",
"Uploaded image names must match regex" => "Namen van aangeleverde afbeeldingen moeten overeenkomen met reguliere uitdrukking",
"Uploaded image names cannot match regex" => "Namen van aangeleverde afbeeldingen mogen niet overeenkomen met reguliere uitdrukking",
"Directory Batch Loading" => "Folder Bulk Aanlevering",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Indien u Folder Bulk Aanlevering inschakelt, dient u een leesbare folder aan te maken (buiten uw webruimte is beter). Voorzie dan een manier om afbeeldingen aan te leveren, bijv. via scp, ftp, of een ander protokol",
"Enable directory batch loading" => "Schakel folder bulk aanlevering in",
"Batch loading directory" => "Folder bulk aanlevering",
"Images per row" => "Afbeeldingen per rij",
"Thumbnails size X" => "Voorbeeldplaatjes X afmeting",
"Thumbnails size Y" => "Voorbeeldplaatjes Y afmeting",
"Set features" => "Onderdelen instellen",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Afbeeldingen in de systeemgalerij die niet gebruikt worden in wikipagina's, artikelen en blogbijdragen verwijderen",
"All galleries" => "Alle gallerijen",
"System Gallery" => "Systeemgalerij",
"Gallery listing configuration" => "Galerijlijst configuratie",
"Parent" => "Ouder",
"Change configuration" => "Verander configuratie",
"Image galleries comments settings" => "Instellingen voor opmerkingen bij beeldgalerijen",
"General Preferences" => "Algemene Voorkeuren",
"Date and Time Formats" => "Datum en Tijd Formaten",
"Site Identity" => "Site Identeit",
"Browser title" => "Browsertitel",
"Home Page" => "Startpagina",
"Use group homepages" => "Gebruik groep thuispagina's",
"Go to group homepage only if login from default homepage" => "Ga naar de groep thuispagina enkel en alleen als de aanmelding gebeurt via de standaard thuispagina",
"Custom home" => "Aangepaste startpagina",
"Unknown/Other" => "Niet gekend/Andere",
"(standard)" => "(standaard)",
"(some Unix MTA)" => "(eenderwelke Unix MTA)",
"PHP error reporting level:" => "Niveau melding PHP-fouten:",
"Protect against CSRF with a ticket" => "Bescherm tegen CSRF met een ticket",
"Use proxy" => "Gebruik proxy",
"Port" => "Poort",
"Store session data in database" => "Bewaar sessiegegevens in databank",
"Contact user" => "Gebruiker contacteren",
"Count admin pageviews" => "Paginabezichtigingen beheerder meetellen",
"Temporary directory" => "Voorlopige folder",
"Help System" => "Help Systeem",
"Examples" => "Voorbeelden",
"Default timezone" => "Standaard tijdzone",
"Long date format" => "Lang datumformaat",
"Short date format" => "Kort datumformaat",
"Long time format" => "Lang tijdformaat",
"Short time format" => "Kort tijdformaat",
"Fields display order" => "Volgorde getoonde velden",
"Date and Time Format Help" => "Datum en Tijd Formaat Help",
"Change admin password" => "Wachtwoord beheerder wijzigen",
"New password" => "Nieuw wachtwoord",
"Change password" => "Verander wachtwoord",
"Detect browser language" => "Detecteer browser taal",
"Use database for translation" => "Gebruik databank voor vertaling",
"Edit or ex/import Languages" => "Bewerken of im-/export Talen",
"Record untranslated" => "Record onvertaald",
"Syntax error" => "Schrijffout",
"port" => "poort",
"Enable/disable Tiki features in " => "Schakel in/uit Tiki kenmerk ",
", but configure them elsewhere" => ", maar configureer deze elders",
"Admin Groups" => "Groepen beheren",
"Admin Users" => "Gebruikers beheren",
"Authentication method" => "Authenticatie methode",
"Registration" => "Registratie",
"Users can register" => "Gebruikers kunnen zich registreren",
"Use challenge/response authentication" => "Challenge/response authentication gebruiken",
"HTTP port" => "HTTP-poort",
"HTTPS port" => "HTTPS-poort",
"Duration" => "Duur",
"Currently unused" => "Momenteel niet in gebruik",
"CAS server version" => "CAS server versie",
"Version 1.0" => "Versie 1.0",
"Version 2.0" => "Versie 2.0",
"Users can change theme" => "Gereg. gebruikers kunnen thema wijzigen",
"Restrict available themes" => "Beperk beschikbare thema's",
"Available styles:" => "Beschikbare stijlen:",
"Slideshows theme" => "Thema voor diavoorstellingen",
"Edit CSS" => "Werk CSS bij",
"Theme Control" => "Themacontrole",
"Template Viewing" => "Sjabloon Bezichtiging",
"Tiki Template Viewing" => "Tiki Sjabloon Bezichtiging",
"General Layout options" => "Algemene lay-outopties",
"logged as" => "aangemeld als",
"Site logo background color" => "Site logo achtergrondkleur",
"Site logo title (on mouse over)" => "Site logo titel (bij muisaanwijzing)",
"Alt. description (e.g. for text browsers)" => "Alt. beschrijving (e.g. voor tekst browsers)",
"Site menu bar" => "Site menubalk",
"Current Version" => "Huidige versie",
"Custom code" => "Aangepaste code",
"Users can Flip Columns" => "Gebruikers kunnen Kolommen Verwisselen",
"Left column" => "Kolom links",
"always" => "altijd",
"user decides" => "gebruiker beslist",
"Site Breadcrumbs" => "Site Broodkruimels",
"Site location bar" => "Site locatiebalk",
"at top of page" => "aan de bovenkant van de pagina",
"at top of center column" => "aan de bovenkant van de middenkolom",
"Larger font for" => "Groter lettertype voor",
"entire location" => "volledige locatie",
"page name" => "paginanaam",
"Use page description:" => "Gebruik paginabeschrijving:",
"Right column" => "Kolom rechts",
"Maximum number of records in listings" => "Maximaal aantal records in opsommingen",
"Use direct pagination links" => "Directe pagineringskoppelingen gebruiken",
"Warning" => "Waarschuwing",
"Vertical" => "Verticaal",
"Horizontal" => "Horizontaal",
"Left" => "Links",
"Right" => "Rechts",
"Use Tabs" => "Gebruik Tabs",
"Display menus as folders" => "Toon menu's als folders",
"Layout per section" => "Lay-out per sectie",
"Admin layout per section" => "Lay-out per sectie beheren",
"Favicon icon file name:" => "Favicon ikoon bestandsnaam:",
"Favicon icon MIME type:" => "Favicon ikoon MIME type:",
"full path to mapfiles" => "volledig pad naar de landkaartbestanden",
"default mapfile" => "standaard landkaartbestand",
"Wiki Page for Help" => "Wiki Pagina voor Help",
"Wiki Page for Comments" => "Wiki Pagina voor Commentaar",
"Full path to gdaltindex" => "Volledig pad naar gdaltindex",
"Full path to ogr2ogr" => "Volledig pad naar ogr2ogr",
"Map Zone" => "Kaart Zone",
"Generate User Map" => "Maak Gebruikerskaart aan",
"Maximum mailbox size (messages, 0=unlimited)" => "Maximum grootte postbus (berichten, 0=onbeperkt)",
"Maximum mail archive size (messages, 0=unlimited)" => "Maximum grootte berichtenarchief (berichten, 0=onbeperkt)",
"Maximum sent box size (messages, 0=unlimited)" => "Maximum grootte verzend postbus (berichten, 0=onbeperkt)",
"geo.position" => "geo.positie",
"geo.region" => "geo.regio",
"geo.placename" => "geo.plaatsnaam",
"Display modules to all groups always" => "Modules altijd aan alle groepen tonen",
"Hide anonymous-only modules from registered users" => "Verberg anonieme modules voor niet-geregistreerde gebruikers",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Om opiniepeilingen toe te voegen of te verwijderen, ga naar \"Opiniepeiligen\" onder \"Beheer\" in het applicatiemenu, of",
"Last update" => "Laatste bijwerking",
"Image galleries" => "Beeldgalerijen",
"Feed for forums" => "Invoer voor forums",
"Default RDF version" => "Standaard RDF versie",
"Specification" => "Specificatie",
"Documentation" => "Documentatie",
"You can see users rank by score in the module users_rank, for that go to" => "U kan de gebruikersrankschikking bekijken in de module users_rank, ga hiervoor naar",
"Admin modules" => "Beheer modules",
"Expiration" => "Verloopdatum",
"Search stats" => "Zoekstatistieken",
"random" => "willekeurig",
"Refresh rate" => "Verversingsfrequentie",
"Minimum length of search word" => "Minimum lengte van zoekterm",
"Max. number of words containing a syllable" => "Max. aantal woorden met een lettergreep",
"Max. age in hours of syllable search cache" => "Max. leeftijd in uren van de lettergrepen zoekbuffer",
"LRU list purging rate" => "LRU lijst zuiveringstempo",
"LRU list length" => "LRU lijst lengte",
"Referer Search Highlighting" => "Breng Zoekverwijzer naar voeren (Referer Search)",
"Ignore individual object permissions" => "Negeer individuele objectpermissies",
"hits" => "keren bezocht",
"Open external links in new window" => "Externe koppelingen in een nieuw venster openen",
"Dynamic Content System" => "Dynamisch Inhoud Systeem",
"Automonospaced text" => "Auto-vastespatie tekst",
"Tables syntax" => "Tabellen schrijfwijze",
"AutoLinks" => "AutoKoppelingen",
"rows" => "rijen",
"Required" => "Verplicht",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Om de trackers te configureren, ga naar \"Admin trackers\" onder \"Trackers\" in het applicatiemenu, of",
"dls" => "afhlgn",
"Storage" => "Opslag",
"Change" => "Wijzig",
"Change all to db" => "Verplaats alles naar db",
"Change all to file" => "Verplaats alles naar bestanden",
"Use database to store userfiles" => "Gebruik databank om gebruikerbestanden op te slaan",
"Use a directory to store userfiles" => "Gebruik een folder om gebruikerbestanden op te slaan",
"Allow viewing HTML mails?" => "Laat bezichtiging HTML e-mails toe?",
"Maximum size for each attachment" => "Maximale grootte per bijlage",
"Unlimited" => "Onbeperkt",
"Create New" => "Maak nieuwe aan",
"Home page" => "Startpagina",
"Complete" => "Voltooid",
"Individual cache" => "Individuele buffer",
"Content templates" => "Inhoudssjablonen",
"Warn on edit conflict" => "Waarschuw bij conflict ivm bijwerken",
"Undo" => "Ongedaan maken",
"Footnotes" => "Voetnoten",
"Permission" => "Permissie",
"Allow HTML" => "HTML toestaan",
"Sandbox" => "Zandbak",
"Generate dump" => "Dump aanmaken",
"Download last dump" => "Laatste dump afhalen",
"Pictures" => "Afbeeldingen",
"Remove unused pictures" => "Ongebruikte afbeeldingen verwijderen",
"Export" => "Exporteren",
"Export Wiki Pages" => "Exporteer wikipagina's",
"Accept dashes and underscores in WikiWords" => "Accepteer liggend streepje en onderlijn streepje in WikiWorden",
"Link plural WikiWords to their singular forms" => "Koppel meervouds-WikiWoorden aan hun enkelvoudige varianten",
"Side-by-side diff" => "Zij-langs-zij verschillen",
"Discuss pages on forums" => "Discussieer over pagina's in forums",
"Structures" => "Strukturen",
"Open page as structure" => "Open pagina als structuur",
"Import HTML" => "Importeer HTML",
"Page creators are admin of their pages" => "Pagina auteurs zijn beheerder van hun eigen pagina's",
"Create watch for author on page creation" => "Zet een waker voor auteur tijdens pagina-aanmaak",
"Enable watch events when I am the editor" => "Activeer waker wanneer ik de editor ben",
"Enable watches on comments" => "Activeer wakers voor commentaren",
"List pages" => "Pagina's opsommen",
"Wiki attachments" => "Wikibijlagen",
"Restore defaults" => "Standaardinstellingen herstellen",
"Contact us" => "Contacteer ons",
"Look &amp; feel" => "Vormgeving",
"Setting" => "Instelling",
"Statistics" => "Statistieken",
"Weeks" => "Weken",
"viewed" => "bekeken",
"Add or edit a rule" => "Maak aan/wijzig een regel",
"Rule title" => "Regel titel",
"Username regex matching" => "Gebruikernaam regex paren",
"IP regex matching" => "IP regex paren",
"Banned from sections" => "Verbannen van de secties",
"Rule activated by dates" => "Regel geactiveerd door datums",
"Rule active from" => "Regel actief sinds",
"Rule active until" => "Regel actief tot",
"Custom message to the user" => "Aangepast bericht aan de user",
"Rules" => "Regels",
"User/IP" => "Gebruiker/IP",
"Sections" => "Secties",
"Admin Calendars" => "Kalenders beheren",
"List of Calendars" => "Kalenderlijst",
"Participants" => "Deelnemers",
"Lang" => "Taal",
"Url" => "URL",
"Subscription" => "Abonnement",
"Custom Locations" => "Aangepaste Locaties",
"Custom Participants" => "Manuele Deelnemers",
"Custom Categories" => "Aangepaste Categorie&euml;n",
"Custom Languages" => "Aangepaste Talen",
"Custom Subscription List" => "Manuele Deelnemerslijst",
"Custom Priorities" => "Aangepaste Prioriteiten",
"Personal Calendar" => "Persoonlijke Kalender",
"h" => "u",
"Red" => "Rood",
"Current category" => "Huidige categorie",
"Child categories" => "Ondergeschikte categorie&euml;n",
"Edit permissions for this category" => "Bewerk permissions voor deze categorie",
"Edit this category:" => "Bewerk deze categorie:",
"Add new category" => "Voeg nieuwe categorie toe",
"Perms inherited from closest parent if possible or from global perms" => "Permissies ge-erfd van de kortste bijliggende ouder indien aanwezig of van globale permissies",
"Assign permissions automatically" => "Wijs permissies automatisch toe",
"recommended for best performance" => "aangewezen voor de beste performantie",
"Objects in category" => "Objecten in categorie",
"No records found." => "Geen records gevonden.",
"Add objects to category" => "Objecten aan een categorie toevoegen",
"image gal" => "beeldgal.",
"file gal" => "bestandgal.",
"Admin chart items" => "Rangschikking items beheren",
"Edit Chart" => "Bewerk rangschikking",
"Add or edit an item" => "Toevoegen/bewerken item",
"Update" => "Bijwerken",
"Chart items" => "Rangschikking items",
"No items defined yet" => "Nog geen items gedefinieerd",
"Add or edit a chart" => "Aanmaken/bewerken rangschikking",
"Active" => "Actief",
"Users can vote for only one item from this chart per period" => "Gebruikers kunnen slechts voor &eacute;&eacute; item van deze rangschikking stemmen per periode",
"Prevent users from voting for the same item more than once" => "Voorkom dat gebruikers meer dan eens voor hetzelfde item stemmen",
"Users can suggest new items" => "Gebruikers kunnen nieuwe items aanbrengen",
"Auto validate user suggestions" => "Auto-valideer gebruikersuggesties",
"Ranking shows" => "Rankschikking toont",
"All items" => "Alle items",
"Voting system" => "Stem-systeem",
"Vote items" => "Stem items",
"Rank 1..5" => "Rang 1..5",
"Rank 1..10" => "Rang 1..10",
"Ranking frequency" => "Rangschikking-frequentie",
"Realtime" => "Echte-tijd",
"Each 5 minutes" => "Elke 5 minuten",
"Daily" => "Dagelijks",
"Weekly" => "Wekelijks",
"Monthly" => "Maandelijks",
"Show Average" => "Gemiddelde Tonen",
"Show Votes" => "Stemmen Tonen",
"Use Cookies for unregistered users" => "Gebruik Cookies voor niet-geregistreerde gebruikers",
"Users can vote again after" => "Gebruikers kunnen opnieuw stemmen na",
"Anytime" => "Altijd",
"Ranks" => "Rangen",
"No charts defined yet" => "Nog geen rangschikkingen gedefinieerd",
"Admin templates" => "Sjablonen beheren",
"Edit this template:" => "Bewerk dit sjabloon:",
"Create new template" => "Maak nieuw sjabloon aan",
"Use wysiwyg editor" => "Gebruik wysiwyg editor",
"Use normal editor" => "Gebruik normale editor",
"Templates" => "Sjablonen",
"Settings" => "Instellingen",
"Admin cookies" => "Cookies beheren",
"To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "Om een cookie in een tekstvak te gebruiken (Wiki-pagina, ...),een <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> of een sjabloon, gebruik {literal}{cookie}{/literal}.",
"Create/edit cookies" => "Koekjes maken/bewerken",
"Upload Cookies from textfile" => "Cookies uit tekstbestanden aanleveren",
"Upload from disk:" => "Van harde schijf aanleveren:",
"Upload" => "Aanlevering",
"Remove all cookies" => "Alle cookies verwijderen",
"Admin drawings" => "Tekeningen beheren",
"Available drawings" => "Beschikbare tekeningen",
"Create/edit dsn" => "Aanmaken/bewerken dsn",
"Admin external wikis" => "Externe wiki's beheren",
"View template" => "Bekijk sjabloon",
"tiki admin external wikis template" => "tiki externe wiki's sjabloon beheren",
"Edit template" => "Bewerk sjabloon",
"Create/Edit External Wiki" => "Maak aan/Bewerk Extern Wiki",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (gebruik \$pagina om deze te laten vervangen door de pagina in de URL, bijv http://www.example.com/tiki-index.php?page=\$pagina)",
"ExtWiki" => "Extwiki",
"Admin Forums" => "Forums Beheren",
"Create new forum" => "Maak nieuw forum aan",
"List forums" => "Opsommen forums",
"Edit this Forum:" => "Bewerk dit Forum:",
"Create New Forum" => "Maak Nieuw Forum aan",
"There are individual permissions set for this forum" => "Er zijn individuele permissies gezet voor dit forum",
"Prevent flooding" => "Flooding voorkomen",
"Minimum time between posts" => "Minimale tijdsspanne tussen bijdragen",
"Section" => "Sectie",
"Create new" => "Maak nieuw",
"Moderator user" => "Moderator gebruiker",
"Moderator group" => "Moderator groep",
"Password protected" => "Beveiligd door wachtwoord",
"Topics only" => "Alleen onderwerpen",
"All posts" => "Alle bijdragen",
"Forum password" => "Forum wachtwoord",
"Send this forums posts to this email" => "Deze forumbijdragen naar het volgende e-mail adres zenden",
"Prune unreplied messages after" => "Niet beantwoorde berichten verwijderen na",
"Prune old messages after" => "Oude berichten verwijderen na",
"Topic list configuration" => "Onderwerplijst configuratie",
"Posts can be rated" => "Berichten kunnen gewaardeerd worden",
"Display last post titles" => "Toon titles van laatste berichten",
"no display" => "geen vertoning",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Stuur berichten bestemd voor dit form door naar dit e-mail adres in een formaat dat kan gebruikt worden om het bericht terug te sturen naar het inkomende forum email adres",
"Send mails even when the post is generated by inbound mail" => "Stuur berichten zelfs indien de post werd aangemaakt voor intern gebruik",
"Append a reply link to outbound mails" => "Voeg een antwoordkoppeling toe aan uitgaande berichten",
"Originating e-mail address for mails from this forum" => "E-mail adres van oorsprong voor e-mails vertrekkende van dit forum",
"Add messages from this email to the forum" => "Voeg berichten via dit e-mail adres toe aan dit forum",
"Use topic smileys" => "Gebruik smilies voor onderwerpen",
"Show topic summary" => "Toon samenvatting onderwerp",
"User information display" => "Gebruikerinformatie",
"Approval type" => "Aanvaardingstype",
"All posted" => "Alle bijdragen toegevoegd",
"Queue anonymous posts" => "Plaats anonieme bijdragen in de wachtrij",
"Queue all posts" => "Plaats alle bijdragen in de wachtrij",
"No attachments" => "Geen bijlagen",
"Everybody can attach" => "Iedereen mag bijlagen toevoegen",
"Only users with attach permission" => "Alleen gebruikers met toestemming om bijlagen toe te voegen",
"Moderators and admin can attach" => "Moderatoren en beheerder kunnen bijlagen toevoegen",
"Store attachments in:" => "Bewaar bijlagen in:",
"Database" => "Databank",
"Max attachment size (bytes)" => "Max grootte bijlagen (bytes)",
"Default ordering for topics" => "Standaardsortering voor onderwerpen",
"Date (desc)" => "Datum (dalend)",
"Date (asc)" => "Datum (opl)",
"Score (desc)" => "Score (dalend)",
"Replies (desc)" => "Antwoorden (dalend)",
"Reads (desc)" => "Aantal gelezen (dalend)",
"Topics per page" => "Onderwerpen per pagina",
"Default ordering for threads" => "Standaardsortering voor threads",
"Coms" => "Opm.",
"Age" => "Ouderdom",
"PPD" => "Ppd",
"Admin Hotwords" => "Hotwords Beheren",
"Add Hotword" => "Hotword Toevoegen",
"Word" => "Woord",
"Admin HTML pages" => "HTML pagina's beheren",
"Edit this page" => "Deze pagina bewerken",
"View page" => "Pagina bekijken",
"Edit zone" => "Zone bewerken",
"Dynamic zones" => "Dynamische zones",
"content" => "inhoud",
"Mass update" => "Massabijwerking",
"Create new HTML page" => "Maak nieuwe HTML pagina aan",
"Edit this HTML page:" => "Bewerk deze HTML pagina:",
"Apply template" => "Sjabloon toepassen",
"Dynamic" => "Dynamisch",
"Static" => "Statisch",
"Last Modif" => "Laatst gewijzigd",
"Edit Repository:" => "Bewerk de bewaarplaats:",
"Create New Repository" => "Maak nieuwe bewaarplaats aan",
"List Repositories" => "Opsommen bewaarplaatsen",
"New Repository" => "Nieuwe bewaarplaats",
"View Repository" => "Bekijk bewaarplaats",
"Human readable repository name" => "Leesbare naam van bewaarplaats",
"Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Pad naar de bewaarplaats (lokaal bestandsysteem: relatief/absoluut pad web folder, ver: voorafgegaan door'http://')",
"File name of start page" => "Bestandnaam van de startpagina",
"Start page" => "Startpagina",
"CSS file to load when browse this repository" => "CSS bestand dat moet worden ingeladen tijdens het bekijken van deze bewaarplaats",
"CSS file" => "CSS bestand",
"Is repository visible to users" => "Is bewaarplaats zichtbaat voor gebruikers",
"Can files from repository be cached" => "Kunnen bestanden van bewaarplaats gebufferd worden",
"Cacheable" => "Mogelijkheid tot buffering",
"Are files from repository can be cached" => "Kunnen alle bestanden van bewaarplaats gebufferd worden",
"Clear all cached pages of this repository" => "Verwijder all gebufferde pagina's van deze bewaarplaats",
"Clear cache" => "Maak buffer leeg",
"Seconds count 'till cached page will be expired" => "Aantal seconden voordat gebufferde versie van de pagina verloopt",
"Cache expiration" => "Verlooptijd van de buffer",
"Human readable text description of repository" => "Leesbare beschrijving van de bewaarplaats",
"Available Repositories" => "Beschikbar Bewaarplaatsen",
"CSS File" => "CSS bestand",
"Edit rules" => "Werk regels bij",
"Edit Rules for Repository:" => "Bewerk regels voor bewaarplaats:",
"Configure Repositories" => "Configureer bewaarplaatsen",
"Configure this Repository" => "Configureer deze bewaarplaats",
"View this Repository" => "Bekijk deze bewaarplaats",
"New Rule" => "Nieuwe regel",
"Copy Rules" => "Kopieer regels",
"view/hide copy rules dialog" => "Toon/verberg regels kopie dialoog",
"Source repository" => "Bronbewaarplaats",
"Copy" => "Kopieer",
"According this order rules will be applied ('0' or empty = auto)" => "Regels worden toegepast volgens deze rangorde ('0' or leeg = auto)",
"Rule order" => "Regel volgorde",
"Text to search for" => "Zoektekst",
"Text to replace" => "Vervangtekst",
"Is this regular expression or simple search/replacer" => "Is dit reguliere expressie of simpele zoek/vervang opdracht",
"Is case sensitive (for simple replacer)" => "Is hoofdlettergevoelig (voor simpele vervanger)",
"Case sensitive" => "Hoofdlettergevoelig",
"subset of chars: imsxeADSXUu, which is regex modifiers" => "subset van chars: imsxeADSXUu, welke zijn regex-bepalingen",
"Regex modifiers" => "Regex-bepalingen",
"Human readable text description of rule" => "Leesbare beschrijving van regel",
"Check to enable this rule" => "Vlag aan om deze regle in te schakelen",
"Enabled" => "Ingeschakeld",
"Preview options" => "Voorbeeldopties",
"Apply all rules or just this to generate preview" => "Pas alle regels toe of genereer enkel voorbeeld",
"Apply all rules" => "Pas alle regels toe",
"View source code after rules applied" => "Bekijk broncode nadat all regels zijn toegepast",
"Code preview" => "Code voorbeeld",
"Generate HTML preview" => "Genereer HTML voorbeeld",
"HTML preview" => "HTML voorbeeld",
"Test file from repository to generate preview for (empty = configured start page)" => "Test bestand van bewaarplaats om voorbeeld te genereren voor (leeg = ingestelde start pagina)",
"Preview Results" => "Voorbeeld Resultaten",
"Rules List" => "Regellijst",
"Case" => "Hoofdlettertype",
"Configure/Options" => "Instellingen/Opties",
"Admin layout" => "Layout beheren",
"Theme control" => "Themacontrole",
"layout options" => "lay-outopties",
"Generate positions by hits" => "Posities aanmaken volgens hits",
"List of featured links" => "Lijst met aanbevolen koppelingen",
"Position" => "Positie",
"Add Featured Link" => "Aanbevolen koppeling toevoegen",
"Edit this Featured Link:" => "Werk deze Aanbevolen Koppeling bij:",
"Create new Featured Link" => "Maak nieuwe Aanbevolen Koppeling aan",
"disables the link" => "maakt de koppeling inactief",
"Link type" => "Koppelingtype",
"replace current page" => "huidige pagina vervangen",
"framed" => "omkaderd",
"open new window" => "nieuw venster openen",
"Add new Mail-in account" => "Nieuw e-mail account toevoegen",
"Edit Mail-in account" => "Wijzig e-mail account",
"Account name" => "Accountnaam",
"POP server" => "POP-server",
"SMTP server" => "SMTP-server",
"SMTP requires authentication" => "SMTP vereist authentication",
"article-put" => "artikel-put",
"Article Topic" => "Artikelonderwerp",
"Admin Topics" => "Onderwerpen Beheren",
"Article Type" => "Artikeltype",
"Admin Types" => "Types beheren",
"Allow anonymous acces" => "Laat anonieme toegang toe",
"Allow attachments" => "Laat blijlagen toe",
"Discard to the end from" => "Negeer tot het einde vanaf",
"Check Mail-in accounts" => "Controleer Mail-in accounts",
"Check automatically" => "Controleer automatisch",
"Frequency" => "Frekwentie",
"List menus" => "Menu's opsommen",
"Edit this menu" => "Dit menu bewerken",
"Edit menu options" => "Menu-opties bewerken",
"Show Quick Urls" => "Toon Snel Urls",
"Some useful URLs" => "Enkele nuttige URLs",
"Hide Quick Urls" => "Verberg Snel Urls",
"option" => "optie",
"separator" => "scheidingslijn",
"Choose" => "Kies",
"Home Blog" => "Startblog",
"Home Image Gal" => "Startbeeldgal.",
"Home Image Gallery" => "Startbeeldgalerij",
"Home File Gal" => "Startbestandgal.",
"Home File Gallery" => "Startbestandgalerij",
"User preferences" => "Gebruikerinstellingen",
"User prefs" => "Gebruikerinst.",
"List galleries" => "Galerijen opsommen",
"List image galleries" => "Beeldgalerijen opsommen",
"Upload image" => "Afbeelding aanleveren",
"Gallery Rankings" => "Rangorde Galerijen",
"Browse a gallery" => "Een galerij bekijken",
"Articles home" => "Artikelen startpagina",
"All articles" => "Alle artikelen",
"Submit" => "Inleveren",
"List Blogs" => "Blogs Oplijsten",
"Create blog" => "Blog maken",
"File galleries" => "Bestandgalerijen",
"View a forum" => "Een forum bekijken",
"View a thread" => "Een thread bekijken",
"View a FAQ" => "Een FAQ bekijken",
"Take a quiz" => "Deelnemen aan een quiz",
"Quiz stats" => "Statistieken voor quiz",
"Stats for a Quiz" => "Statistieken voor een quiz",
"Preview menu" => "Menuvoorbeeld",
"Menu options" => "Menu-opties",
"Edit this Menu:" => "Bewerk dit Menu:",
"Create new Menu" => "Maak nieuw Menu aan",
"dynamic collapsed" => "dynamisch opgevouwen",
"dynamic extended" => "dynamisch uitgevouwen",
"fixed" => "vast",
"Options" => "Opties",
"Active Permissions" => "Actieve permissies",
"Clear Cache" => "Buffer leegmaken",
"User Modules" => "Gebruikermodules",
"Assigned Modules" => "Toegekende modules",
"Left Modules" => "Linkse Modules",
"Rows" => "Rijen",
"Move to Right Column" => "Verplaats naar rechterkolom",
"Unassign" => "Toekenning ongedaan maken",
"Right Modules" => "Rechtse Modules",
"Move to Left Column" => "Verplaats naar linkerkolom",
"Assign new module" => "Wijs nieuwe module toe",
"Edit this assigned module:" => "Wijzig deze toegewezen module:",
"Cache Time" => "Buffertijd",
"Visibility" => "Zichtbaarheid",
"Displayed now for all eligible users even with personal assigned modules" => "Getoond voor gebruikers die in aanmerking komen zelfs als deze persoonlijke toegewezen modules beztten",
"Displayed for the eligible users with no personal assigned modules" => "Getoond voor gebruikers die in aanmerking komen en die geen persoonlijk toegewezen modules bezitten",
"Displayed now, can't be unassigned" => "Nu getoond, toewijzing kan niet worden ongedaan gemaakt",
"Not displayed until a user chooses it" => "Niet getoond totdat een gebruiker het selecteert",
"Create new user module" => "Maak een nieuwe gebruikermodule aan",
"Edit this user module:" => "Werk deze gebruikermodule bij:",
"Must be wiki parsed" => "Moet Wiki vertaald zijn",
"Objects that can be included" => "Objecten die ingevoegd kunnen worden",
"Available polls" => "Beschikbare opiniepeilingen",
"Random active poll" => "Willekeurige active opiniepeiling",
"Random current poll" => "Willekeurige huidige opiniepeiling",
"Use Poll" => "Opiniepeiling gebruiken",
"Random image from" => "Toevallige afbeelding uit",
"Use Gallery" => "Galerij gebruiken",
"Dynamic content blocks" => "Dynamische inhoudsblokken",
"Use Dynamic Content" => "Dynamische inhoud gebruiken",
"Use RSS Module" => "RSS-module gebruiken",
"Use Menu" => "Menu gebruiken",
"Use phplayermenu" => "Gebruik phplayermenu",
"Banner zones" => "Advertentiezones",
"Use Banner Zone" => "Advertentiezone gebruiken",
"Data" => "Gegevens",
"Admin newsletter subscriptions" => "Nieuwsbrief-abonnementen beheren",
"List Newsletters" => "Nieuwsbrieven opsommen",
"Admin Newsletters" => "Nieuwsbrieven beheren",
"Send Newsletters" => "Nieuwsbrieven Verzenden",
"Add a subscription newsletters" => "Abonnement voor nieuwsbrieven toevoegen",
"Add email:" => "Voeg e-mail toe:",
"Add user:" => "Voeg gebruiker toe:",
"Group users" => "Groepeer gebruikers",
"Group subscription also subscribes included groups" => "Groepabonnement tekent ook de ingesloten groepen in",
"Don't send confirmation mail" => "Stuur geen confirmatiebericht",
"The user email will be refreshed at each newsletter sending" => "De gebruikers e-mail zal worden ververst bij elke uitgave van een nieuwsbrief",
"Subscribe group" => "Abonneer groep",
"Included group, group users and emails will be refreshed at each newsletter sending" => "Inclusief groep, groepgebruikers en e-mails zullen worden ververst bij elke uitgave van een nieuwsbrief",
"Subscriptions" => "Abonnementen",
"Valid" => "Geldig",
"Subscribed" => "geabonneerd",
"Admin newsletters" => "Nieuwsbrieven beheren",
"There are individual permissions set for this newsletter" => "Er bestaan individuele permissies voor deze nieuwsbrief",
"Users can subscribe/unsubscribe to this list" => "Gebruikers kunnen zich aan-/afmelden van deze lijst",
"Users can subscribe any email address" => "Gebruikers kunnen zich met elk e-mail adres aanmelden",
"Add unsubscribe instructions to each newsletter" => "Voeg instructies om af te melden toe aan elke nieuwsbrief",
"Validate email addresses" => "Valideer e-mail adressen",
"Editions" => "Uitgaven",
"Last Sent" => "Laatst verzonden",
"Add notification" => "Melding toevoegen",
"Event" => "Gebeurtenis",
"A user registers" => "Een gebruiker registreert zich",
"A user submits an article" => "Een gebruiker levert een artikel in",
"Any wiki page is changed" => "Eender welke wiki pagina werd bijgewerkt",
"Any wiki page is changed, even minor changes" => "Eender welke wiki pagina werd aangepast, zelfs kleine veranderingen",
"A comment in a wiki page is posted or edited" => "Een commentaar op een wiki-pagina is gepost of aangepast",
"PHP error" => "PHP-fout",
"Email:" => "E-mail:",
"List polls" => "Opiniepeilingen opsommen",
"Edit this poll" => "Deze opiniepeiling bewerken",
"Preview poll" => "Voorbeeld opiniepeiling",
"Option" => "Opties",
"Poll options" => "Opties voor opiniepeilingen",
"Votes" => "Stemmen",
"Admin Polls" => "Opiniepeilingen beheren",
"Set last poll as current" => "Maak laatste opniniepeiling huidig",
"Close all polls but last" => "Sluit alle opiniepeilingen behalve de laatste",
"Activate all polls" => "Activeer alle opiniepeilingen",
"active" => "actief",
"current" => "huidig",
"template" => "sjabloon",
"PublishDate" => "PublicatieDatum",
"Results" => "Resultaten",
"Wiki pages" => "Wiki pagina\\'s",
"Admin Quicktags" => "Snellabels beheren",
"Create/Edit QuickTags" => "maak aan/Bewerk SnelLabels",
"Insert (use 'text' for figuring the selection)" => "Voeg in (gebruik 'text' om de selectie te beschrijven)",
"Path to the tag icon" => "Pad naar het labelikoon",
"Admin RSS Modules" => "RSS-modules beheren",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Deze pagina dient om de instellingen van de RSS-invoerstromen (door Tiki gelezen of aangemaakt) te definieren. Om RSS-invoerstromen aan te maken, ga naar \"RSS-invoerstromen\" in het beheerpanel, of",
"Content for the feed" => "Inhoud voor de invoer",
"show feed title" => "toon invoertitel",
"show publish date" => "toom publicatiedatum",
"PHP settings" => "PHP-instelligen",
"PHP variable" => "PHP-variabele",
"Risk Factor" => "Risicofactor",
"Explanation" => "Uitleg",
"Tiki variable" => "Tiki variabele",
"Check all tiki files" => "Controleer alle tiki-bestanden",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Merk op dat dit een lange tijd kan duren. Controleer eventueel uw \\'max_execution_time\\' instelling in php.ini.",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Opmerking: U dient de veiligheidsdatabank te importeren via de installatieprocedure (<a href=\"tiki-install.php\">tiki-install.php</a>). Importeer de *secdb* bestanden in uw databank.",
"File checks" => "Controles bestanden",
"user" => "gebruiker",
"group" => "groep",
"sticky" => "plakkend",
"Admin Shoutbox Words" => "Spreekbuiswoorden beheren",
"Add Banned Word" => "Voeg verbannen woord toe",
"Are you sure you want to delete this word?" => "Bent u zeker dat u dit woord wenst te verwijderen?",
"Destroy the structure leaving the wiki pages" => "Verwijder de structuur maar behoudt de wiki pagina",
"Destroy the structure and remove the pages" => "Verwijder de structuur en pagina's",
"Export Pages" => "Export pagina's",
"Dump Tree" => "Dump boomstructuur",
"Create WebHelp" => "Maak WebHelp Aan",
"View WebHelp" => "Bekijk webhelp",
"Create new structure" => "Nieuwe structuur aanmaken",
"Tree" => "Boom",
"Use single spaces to indent structure levels" => "Gebruik enkele aanhalingstekens om de structuurniveau's in te springen",
"Create New Structure" => "Maak nieuwe structuur aan",
"List surveys" => "Opinieonderzoeken opsommen",
"Survey Stats" => "Statistieken voor opinieonderzoek",
"Edit this Survey" => "Dit opinieonderzoek bewerken",
"Admin Surveys" => "Opinieonderzoeken beheren",
"Question" => "Vraag",
"One choice" => "Een keuze",
"Multiple choices" => "Meerdere keuzes",
"Short text" => "Korte tekst",
"Rate (1..5)" => "Beoordeling (1..5)",
"Rate (1..10)" => "Beoordeling (1..10)",
"Rate" => "Scoor",
"Options (if apply)" => "Opties (indien van toepassing)",
"Questions" => "Vragen",
"Admin surveys" => "Opinieonderzoeken beheren",
"List Surveys" => "Opinieonderzoeken Opsommen",
"Edit this Survey:" => "Bewerk dit Opinieonderzoek:",
"Create New Survey" => "Maak Nieuw Opinieonderzoek aan",
"There are individual permissions set for this survey" => "Voor dit opinieonderzoek bestaan er individuele permissies",
"If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "Als je Tiki-installatie zie vreemd gedraagt, probeer dan eerst je tijdelijke bestanden hieronder te wissen. Het is ook zeer belangrijk je tijdelijke bestanden te wissen na een upgrade (eventueel via FTP/SSH indien nodig).",
"Empty" => "Leeg",
"Templates compiler" => "Sjablooncompiler",
"Compile" => "Compileer",
"Fix UTF-8 Errors in Tables" => "Los UTF-8 Fouten op in Tabellen",
"Warning: Make a backup of your Database before using this function!" => "Waarschuwing: Maak een reservekopie van uw databank vooraleer deze functie te gebruiken!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Waarschuwing: Indien uw grote tabellen wenst te converten, zorg er dan voor dat de \\'maximum execution time\\' in uw php.ini voldoende hoog staat!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Deze functie converteert ISO-8859-1 ge-encodeerde strings in uw tabellen naar UTF-8 formaat",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Dit is mogelijks noodzakelijks indien uw inhoud heeft aangemaakt met tiki &lt; 1.8.4 en met de \\'Default Charset\\' instelling in apache gezet op ISO-8859-1",
"UTF-8 Errors fixed" => "UTF-8 Fouten opgelost",
"Investigate" => "Onderzoek",
"Fix it" => "Los op",
"Create a new topic" => "Een nieuw onderwerp aanmaken",
"Topic Name" => "Onderwerpnaam",
"Upload Image" => "Afbeelding Aanleveren",
"List of topics" => "Lijst van onderwerpen",
"Articles (subs)" => "Artikelen (subs)",
"topic image" => "afbeelding onderwerp",
"Deactivate" => "Uitschakelen",
"Remove with articles" => "Verwijder met artikelen",
"List Trackers" => "Trackers Opsommen",
"Admin Trackers" => "Trackers beheren",
"Edit This Tracker" => "Deze tracker bewerken",
"View This Tracker's Items" => "Items in deze tracker bekijken",
"Edit tracker field" => "Trackervelden bewerken",
"Is column visible when listing tracker items?" => "Is kolom zichtbaar wanneer trackeritems opgesomd worden?",
"Column links to edit/view item?" => "Kolomkoppelingen om items te bewerken/bekijken?",
"Column is searchable?" => "Kolom kan doorzocht worden?",
"Field is mandatory?" => "Veld is verplicht?",
"Tracker fields" => "Trackervelden",
"Searchable" => "Kan doorzoeken",
"Hidden" => "Verborgen",
"Mandatory" => "Verplicht",
"Import/Export Trackers Fields" => "Importeer/exporteer trackerveld",
"Edit Tracker" => "Werk tracker bij",
"Import/Export" => "Importeer/exporteer",
"Found" => "Gevonden",
"There are individual permissions set for this tracker" => "Er bestaan individuele permissies voor deze tracker",
"No individual permissions. Global permissions apply." => "Er zijn geen individuele permissies gezet, globale permissies gelden",
"Show status" => "Toon status",
"Default status displayed in list mode" => "Toon standaardstatus in lijstmode",
"Show status to tracker admin only" => "Toon trackerstatus enkel aan beheerders",
"Send copies of all activity in this tracker to this e-mail address" => "Stuur kopie&euml;n van alle activiteit in deze tracker naar dit e-mail adres",
"Use simplified e-mail format" => "Gebruik vereenvoudigd e-mail formaat",
"New items are created with status" => "Maak nieuwe items aan met status",
"Authoritative status for modified items" => "Beheerderstatus voor bijgewerkte items",
"No change" => "Geen wijziging",
"Item creator can modify his items?" => "Aanmaker item mag haar/zijn items wijzigen?",
"The tracker needs a user field with the option 1" => "De tracker vereist een gebruikersveld met de optie 1",
"Member of the default group of creator can modify items?" => "Lid van de standaard groep van aanmakers mag items wijzigen?",
"The tracker needs a group field with the option 1" => "De tracker vereist een groepveld met de optie 1",
"Show creation date when listing tracker items?" => "Aanmaakdatum tonen wanneer trackeritems opgesomd worden?",
"Show lastModif date when listing tracker items?" => "lastModif-datum tonen wanneer trackeritems opgesomd worden?",
"What field is used for default sort?" => "Welk veld gebruiken voor de standaard sorteervolgorde?",
"What is default sort order in list?" => "Wat is de standaard sorteervolgorde in lijst?",
"Tracker items allow ratings?" => "Tracker items laat beoordelingen toe?",
"with values" => "met waarden",
"and display rating results in listing?" => "en toon de beoordelingen in de lijst?",
"Tracker items allow comments?" => "Zijn opmerkingen toegestaan bij trackeritems?",
"and display comments in listing?" => "en toon commentaren in lijst?",
"Tracker items allow attachments?" => "Zijn bijlagen toegelaten bij trackeritems?",
"and display attachments in listing?" => "en toon bijlagen in lijst?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Toon bijlagen opties (Gebruik nummers om items in volgorde te plaatsen, 0 wordt niet getoond, en negatieve waarden worden in een popup venster getoond)",
"Filesize" => "Bestandgrootte",
"Filetype" => "Bestandstype",
"LongDesc" => "Langbeschr",
"Import/export trackers" => "Importeer/exporteer trackers",
"Admin groups" => "Groepen beheren",
"Admin users" => "Gebruikers beheren",
"Add new group" => "Voeg nieuwe groep toe",
"Edit group" => "Wijzig groep",
"Members" => "Leden",
"Add a New Group" => "Voeg nieuwe groep toe",
"List of existing groups" => "Lijst van bestaande groepen",
"Includes" => "Omvat",
"Group Homepage" => "Groep Start pagina",
"Use wiki page name or full URL" => "Gebruik wiki paginanaam of gebruik volledige URL",
"Group Information Tracker" => "Groepinformatie Tracker",
"choose a group tracker ..." => "kies een groep tracker ...",
"choose a field ..." => "kies een veld ...",
"Users Information Tracker" => "Gebruikers Informatie Tracker",
"choose a users tracker ..." => "kies een gebruikers tracker ...",
"Group tracker item : {\$groupitemid}" => "Groep tracker item : {\$groupitemid}",
"Edit Item" => "Item bewerken",
"Group tracker item not found" => "Groep tracker item niet gevonden",
"Members List" => "Ledenlijst",
"users in group" => "gebruikers in groep",
"CSV File" => "CSV-bestand",
"Add a New User" => "Nieuwe gebruiker toevoegen",
"Rejected users" => "Geweigerde gebruikers",
"Reason" => "Reden",
"Edit user" => "Wijzig gebruiker",
"More Criteria" => "Meer Criteria",
"Edit Account Settings" => "Bewerk account instellingen",
"to groups" => "aan groepen",
"Change user preferences" => "Verander gebruikersvoorkeuren",
"Remove Users and their Userpages" => "Verwijder Gebruikers en hun Gebruikerspagina",
"Manage Group Assignments" => "Beheer groeptoewijzigingen",
"Set Default Groups" => "Zet standaardgroepen",
"Assign selected to" => "Wijs geselecteerde toe aan",
"Remove selected from" => "Maak toewijzing geselecteerde aan ongedaan",
"the following groups:" => "de volgende groepen:",
"Set the default group of the selected users to" => "Zet de standaardgroep van de geselecteerde gebruikers naar",
"User tracker item : {\$usersitemid}" => "Gebruiker tracker item : {\$usersitemid}",
"Overwrite" => "Overschrijf",
"Source" => "Brontekst",
"Admin Article Types" => "Artikeltypes beheren",
"List of types" => "Lijst van types",
"Shows up in the drop down list of article types" => "Wordt in de neerklap lijst van artikeltypes getoond",
"Allow ratings by the author" => "Laat beoordelingen door auteur toe",
"Show before publish date" => "Toon voor publicatiedaturm",
"non-admins can view before the publish date" => "niet-beheerders kunnen bekijken voor de publicatiedatum",
"Show after expire date" => "Toon na verloopdatum",
"non-admins can view after the expire date" => "niet-beheerders kunnen bekijken na de publicatiedatum",
"Heading only" => "Enkel hoofding",
"No article body, heading only" => "Geen artikellichaam, enkel hoofding",
"Allow comments for this type" => "Laat commentaar toe voor dit type",
"Comment Can Rate Article" => "Commentaar mag artikel scoren",
"Allow comments to include a rating value" => "Laat toe om een waardeoordeel in commentaren in te sluiten",
"Show image" => "Toon afbeelding",
"Show topic or own image" => "Toon onderwerp of eigen afbeelding",
"Show avatar" => "Toon pictogram",
"Show author's avatar" => "Toon auteur's gebruikerpictogram",
"Show author" => "Toon auteur",
"Show author name" => "Toon auteurnaam",
"Show publish date" => "Toon publicatiedatum",
"Show expire date" => "Toon verloopdatum",
"Show reads" => "Toon lezingen",
"Show the number of times the article was read" => "Toon het aantal lezingen van het artikel",
"Show size" => "Toon grootte",
"Show the size of the article" => "Toon de grootte van het artikel",
"Show topline" => "Toon kopregel",
"Show a small title over the title" => "Toon een kleine titel boven de hoofdtitel",
"Show subtitle" => "Toon subtitel",
"Show the subtitle" => "Toon de subtitel",
"Show source" => "Toon brontekst",
"Show link to source after article body" => "Toon koppeling naar brontekst na het artikellichaam",
"Show Image Caption" => "Toon afbeeldingtitel",
"Show a legend under the image" => "Toon een legende onder de afbeelding",
"Show Language" => "Toon Taal",
"Show the language" => "Toon de taal",
"Creator can edit" => "Auteur mag bewerken",
"The person who submits an article of this type can edit it" => "De person die een artikel van dit type aanlevert, mag het ook bijwerken",
"Show lang" => "Toon taal",
"Review" => "Recensie",
"Classified" => "Advertentie",
"Create a new type" => "Maak een nieuw type aan",
"Group Information" => "Groepinformatie",
"level" => "niveau",
"Create level" => "Niveau aanmaken",
"all permissions in level" => "alle permissies op niveau",
"Default Group" => "Standaard Groep",
"Assign Perms to this Group" => "Wijs permissies toe aan deze groep",
"backlinks to" => "terugkoppeling naar",
"No backlinks to this page" => "Geen terugkoppelingen naar deze pagina",
"Directory batch upload" => "Directory bulk aanlevering",
"Browse Gallery" => "Galerij bekijken",
"Upload From Disk" => "Aanleveren van harde schijf",
"available images" => "beschikbare afbeeldingen",
"Remove File Extension from Image Name" => "Verwijder bestandsextensie van naam van afbeelding",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "eg. van \"digicam0001.jpg\" naar de naam digicam0001 zal worden gebruikt voor het naamveld",
"Select a Gallery" => "Selecteer een Galerij",
"Process" => "Proces",
"Edit Post" => "Bijdrage Bewerken",
"View Blog" => "Toon blog",
"Use ...page... to separate pages in a multi-page post" => "Gebruik ...page... om te pagineren in een multi-pagina bijdrage",
"Upload image for this post" => "Lever afbeelding aan voor dit bijdrage",
"Trash" => "Prullenmand",
"Mark entry as private:" => "Markeer invoer als priv&eacute;:",
"Spellcheck" => "Spellingcontrole",
"Save and Exit" => "Bewaar en verlaat",
"Powered by" => "Aangedreven door",
"Made with" => "Gemaakt met",
"powered by" => "aangedreven door",
"Execution time" => "Uitvoertijd",
"Memory usage" => "Geheugengebruik",
"Server load" => "Serverbelasting",
"Admin Category" => "Categorie&euml;n beheren",
"Admin the Category System" => "Beheer het categoriesysteem",
"Browse in" => "Blader in",
"Sheets" => "Rekenbladen",
"Hide subcategories objects" => "Verberg subcategorie objecten",
"Show subcategories objects" => "Toon subcategorie objecten",
"Upper level" => "Hoger niveau",
"Clear" => "Opruimen",
"List Galleries" => "Lijst galerijen",
"Edit Gallery" => "Galerij bewerken",
"Rebuild Thumbnails" => "Voorbeeldplaatjes vernieuwen",
"Directory Batch" => "Directory batch",
"List Gallery" => "Galerij opsommen",
"Monitor this Gallery" => "Monitor deze galerij",
"Stop Monitoring this Gallery" => "Stop monitoring van deze galerij",
"Sort Images by" => "Afbeeldingen sorteren volgens",
"subgallery" => "subgalerij",
"Subgallery" => "Subgalerij",
"Original Size" => "Oorspronkelijk formaat",
"rotate right" => "naar rechts draaien",
"rotate" => "verdraai",
"You can include the image in a tiki page using one of these lines" => "U kan de afbeelding in een tiki-pagina insluiten via &eacute;&eacute;n van volgende lijnen",
"Return to Gallery" => "Terug naar galerij",
"Edit Image" => "Afbeelding Bewerken",
"First Image" => "Eerste afbeelding",
"Prev Image" => "Vor. afbeelding",
"Smaller" => "Kleiner",
"Bigger" => "Groter",
"Popup window" => "Popup venster",
"Next Image" => "Volg. afbeelding",
"Slideshow Forward" => "Slideshow voorwaarts",
"Last Image" => "Laatste afbeelding",
"Direction" => "Richting",
"Click to zoom" => "Klik om te zoomen",
"Image Name" => "Naam Afbeelding",
"Image Scale" => "Schaal afbeelding",
"Latitude (WGS84/decimal degrees)" => "Breedtegraad (WGS84/decimale graden)",
"Longitude (WGS84/decimal degrees)" => "Lengtegraad (WGS84/decimale graden)",
"Move image" => "Afbeelding verplaatsten",
"You can view this image in your browser using" => "U kan deze afbeelding in uw browser bekijken met",
"You can include the image in an HTML page using one of these lines" => "U kan de afbeelding in een HTML-pagina insluiten via &eacute;&eacute;n van volgende lijnen",
"Stop Monitoring this Page" => "Stop deze pagina te monitoren",
"Monitor this Page" => "Monitor deze pagina",
"Group Calendars" => "Groep Kalenders",
"Organized by" => "Georganizeerd volgens",
"Tentative" => "Voorlopig",
"Confirmed" => "Bevestigd",
"Cancelled" => "Geannuleerd",
"Change Focus" => "Verander focus",
"Edit Calendar Item" => "Bewerk Kalender Item",
"New Calendar Item" => "Nieuw Kalendar Item",
"times" => "keer",
"End" => "Einde",
"Roles" => "Functies",
"Calendar import" => "Importeer Kalender",
"Calendar has been updated" => "Kalender werd bijgewerkt",
"import" => "importeren",
"Previous" => "Vorige",
"Assign permissions to category" => "Permissies toekennen aan categorie",
"Current permissions for this category" => "Huidige permissies voor deze categorie",
"Remove from this Category Only" => "Verwijder enkel van deze categorie",
"Remove from this Category &amp; all its Children" => "Verwijder alle kinderen voor deze categorie",
"Assign permissions" => "Wijs permissies toe",
"to group" => "aan groep",
"this category &amp; all its children" => "deze categorie en haar kinderen",
"this category only" => "enkel deze categorie",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "Toewijzen van permissies voor<b>alle kinderen</b>is aanbevolen voor de beste performantie.",
"Change password enforced" => "Wachtwoordwijziging verplicht",
"Old password" => "Oud wachtwoord",
"Send a message to us" => "Stuur ons een bericht",
"Contact us by email" => "Contacteer ons via e-mail",
"Click here to send us an email" => "Klik hier om ons een e-mail te sturen",
"Contacts" => "Contacten",
"Group View" => "Gegroepeerd beeld",
"Create/edit contacts" => "Contacten maken/bewerken",
"First Name" => "Voornaam",
"Last Name" => "Achternaam",
"Nickname" => "Bijnaam",
"You can browse the generated WebHelp here" => "U kan de aangemaakte WebHelp hier bekijken",
"Structure" => "structuur",
"Top page" => "Boven pagina",
"Tiki Debugger Console" => "Tiki Foutcontrole",
"Current URL" => "Huidig URL",
"Command" => "Commando",
"Type <code>help</code> to get list of available commands" => "Type <code>help</code> om een lijst te bekomen van beschikbare commando's",
"Add a new site" => "Site toevoegen",
"You cannot add sites until Directory Categories are setup." => "U kan geen sites toevoegen zolang de Koppelingenlijst Categorie&euml;n niet zijn opgezet.",
"Please contact the Site Administrator" => "Gelieve de sitebeheerder te contacteren",
"Site added" => "Site toegevoegd",
"Directory Administration" => "Koppelingenlijst beheren",
"There are" => "Er zijn",
"invalid sites" => "ongeldige sites",
"valid sites" => "geldige sites",
"Users have visited" => "Gebruikers hebben bezocht:",
"sites from the directory" => "sites van de koppelingenlijst",
"Users have searched" => "Gebruikers hebben gezocht:",
"times from the directory" => "keer van de koppelingenlijst",
"Related" => "Verwante",
"Validate" => "Valideren",
"Admin directory categories" => "Koppelingenlijst categorie&euml;n beheren",
"Add a directory category" => "Voeg een koppelingenlijst categorie toe",
"Edit this directory category" => "Bewerk deze koppelingenlijst categorie",
"Children type" => "Type van kinderen",
"Most visited sub-categories" => "Meest bezochte sub-categorie&euml;n",
"Category description" => "Categoriebeschrijving",
"Random sub-categories" => "Toevallige sub-categorie&eumln",
"Maximum number of children to show" => "Maximaal aantal kinderen om te tonen",
"Editor group" => "Groep-editor",
"allow" => "toestaan",
"count" => "tellen",
"relate" => "verwantschap maken",
"Parent category" => "Bovenliggende categorie",
"Add a related category" => "Voeg een gerelateerde categorie toe",
"Mutual" => "Wederzijds",
"Related categories" => "Verwante categorie&euml;n",
"Admin sites" => "Sites beheren",
"Is valid" => "Is geldig",
"New Sites" => "Nieuwe sites",
"Cool Sites" => "Leuke sites",
"Add a Site" => "Voeg een site toe",
"any" => "elke",
"in entire directory" => "in volledige koppelingenlijst",
"Sort by" => "Sorteer op",
"name (desc)" => "naam (dalend)",
"name (asc)" => "naam (strijgend)",
"hits (desc)" => "hits (dalend)",
"hits (asc)" => "hits (stijgend)",
"creation date (desc)" => "aanmaakdatum (dalend)",
"creation date (asc)" => "aanmaakdatum (stijgend)",
"last updated (desc)" => "laatst bijgewerkt (dalend)",
"last updated (asc)" => "laatst bijgewerkt (stijgend)",
"Added" => "Toegevoegd",
"Last updated" => "Laatst bijgewerkt",
"Total links" => "Totaal koppelingen",
"Links to validate" => "Koppelingen te valideren",
"Searches performed" => "Gemaakte zoekopdrachten",
"Total links visited" => "Totale sites bezocht",
"Directory ranking" => "Koppelingenlijst rankschikking",
"Search results" => "Zoekresultaten",
"Validate sites" => "Sites valideren",
"Edit article" => "Artikel bewerken",
"List Articles" => "Opsommen Artikelen",
"View Articles" => "Artikelen tonen",
"Topline" => "Kopregel",
"Subtitle" => "Subtitel",
"Author Name" => "Auteursnaam",
"Own Image" => "Eigen afbeelding",
"Article image" => "Artikelafbeelding",
"Use own image" => "Eigen afbeelding gebruiken",
"Float text around image" => "plaats tekst rond afbeelding",
"Own image size x" => "Eigen afbeeldinglengte x",
"Own image size y" => "Eigen afbeeldinglengte y",
"Image caption" => "Afbeeldingtitel",
"Heading" => "Hoofding",
"Body" => "Lichaam",
"Publish Date" => "Publicatiedatum",
"Expiration Date" => "Verloopdatum",
"From:" => "Van:",
"Edit or create banners" => "Bewerk of maak advertenties aan",
"List banners" => "Opsommen advertenties",
"URL to link the banner" => "URL waarmee de advertentie gekoppeld is",
"Client" => "Klant",
"Max impressions" => "Max klikken",
"Show the banner only between these dates" => "Advertenties enkel tonen tussen deze data",
"From date" => "Van datum",
"To date" => "Tot datum",
"Use dates" => "Gebruiksdata",
"Show the banner only in this hours" => "Advertenties enkel tonen in deze tijdsspanne",
"to" => "tot",
"Show the banner only on" => "Toon de advertentie enkel op",
"Mon" => "Ma",
"Tue" => "Di",
"Wed" => "Wo",
"Thu" => "Do",
"Fri" => "Vr",
"Sat" => "Za",
"Sun" => "Zo",
"Select ONE method for the banner" => "EEN methode voor de advertentie kiezen",
"Use HTML" => "HTML gebruiken",
"Use image" => "Afbeelding gebruiken",
"Image:" => "Afbeelding:",
"Current Image" => "Huidige afbeelding",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Afbeelding gebruiken die door URL aangemaakt is (de afbeelding wordt bij elke oproep bij de URL opgehaald)",
"Use text" => "Tekst gebruiken",
"Save the Banner" => "De advertentie opslaan",
"Remove Zones (you lose entered info for the banner)" => "Verwijder Zones (u zal de reeds ingevoerde gegevens voor de advertentie verliezen)",
"Create Blog" => "Blog aanmaken",
"Current heading" => "Huidige hoofding",
"There are individual permissions set for this blog" => "Er bestaan individuele permissies voor dit blog",
"Number of posts to show" => "Aantal bijdragen die moeten getoond worden",
"Allow other user to post in this blog" => "Andere gebruikers mogen bijdragen leveren aan dit blog",
"Use titles in blog posts" => "Gebruik titels in blogbijdragen",
"Allow search" => "Laat zoekopdrachten toe",
"Allow comments" => "Laat opmerkingen toe",
"Show user avatar" => "Toon gebruikerpictogram",
"Blog heading" => "Blog hoofding",
"Edit Style Sheet" => "Bewerk Style Sheet",
"Style Sheet" => "Stijlblad",
"choose a stylesheet" => "Kies een stylesheet",
"Try" => "Probeer",
"Wiki Help" => "Wiki help",
"Colored text" => "Gekleurde tekst",
"Headings" => "Hoofdingen",
"Show/Hide" => "Toon/Verberg",
"show/hide heading section. + (shown) or - (hidden) by default" => "toon/verberg hoofdingsectie. + (toon) or - (verberg) standaard",
"Box content" => "Boxinhoud",
"Dynamic variables" => "Dynamische variabelen",
"Inserts an editable variable" => "Voeg een bewerkbare variabele in",
"External links" => "Externe koppelingen",
"For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "Voor een externe Wiki, gebruik ExternalWikiName:PageName of ((External Wiki Name: Page Name))",
"Square Brackets" => "Verkante Haken",
"Use [[foo] to show [foo]." => "Gebruik [[foo] om [foo] te tonen.",
"Wiki References" => "Wikireferenties",
"JoinCapitalizedWords or use" => "SchrijfWoordenMetHoofdlettersAaneen of gebruik",
"page|description" => "pagina|omschr.",
"for wiki references" => "voor wikireferenties",
"SomeName" => "EenNaam",
"prevents referencing" => "vermijd referenties",
"Lists" => "Lijsten",
"for bullet lists" => "voor ongenummerde lijsten",
"for numbered lists" => "voor genummerde lijsten",
"for definiton lists" => "voor definitielijsten",
"Tables" => "Tabellen",
"Title bar" => "Titelbalk",
"creates the editable drawing foo" => "maakt de bewerkbare tekening foo aan",
"Multi-page pages" => "Multi-pagina pagina's",
"Non parsed sections" => "Niet geparste secties",
"Prevents wiki parsing of the enclosed data." => "Voorkomt wiki vertaling van de ingesloten gegevens",
"Preformated sections" => "Voorgeformatteerde secties",
"Block Preformatting" => "Voorgeformatteerd blok",
"Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Spring tekst in met een aantal spaties om het in een mono-gespatieerd blok om te zetten dat nog steeds de andere wiki opmaakregels volgt. Het zal worden getoond met hetzelfde aantal ingesprongen spaties als ingevoerd. Hou er rekening mee dat deze optie spati&euml;ring en afbrekekingregels niet respecteert; gebruik hiervoor ~pp~...~/pp~.",
"No description available" => "Geen beschrijving beschikbaar",
"table" => "tabel",
"table new" => "nieuwe tabel",
"external link" => "externe koppeling",
"wiki link'" => "wiki koppeling",
"heading1" => "hoofding1",
"title bar" => "titelbalk",
"box" => "tekstkader",
"rss feed" => "rss-invoerstroom",
"dynamic content" => "dynamische inhoud",
"center text" => "centreer tekst",
"colored text" => "gekleurde tekst",
"dynamic variable" => "dynamische variabele",
"New wms Metadata" => "Nieuwe wms Metadata",
"New Class" => "Nieuws Klasse",
"New Projection" => "Nieuwe Projectie",
"New Query" => "Nieuwe Vraag",
"New Scalebar" => "Nieuwe Schaalbalk",
"New Layer" => "Nieuwe Laag",
"New Label" => "Nieuwe Label",
"New Reference" => "Nieuwe Referentie",
"New Legend" => "Nieuwe Legende",
"New Web" => "Nieuw Web",
"New Outputformat" => "Nieuw Uitvoerformaat",
"New Mapfile" => "Nieuw Kaartbestand",
"special chars" => "speciale karakters",
"special characters" => "speciale tekens",
"Browse Images" => "Bekijk afbeelding image",
"Edit successful!" => "Bewerking geslaagd!",
"The following image was successfully edited" => "De volgende afbeelding werd met success bewerkt",
"Image Description" => "Omschrijving Afbeelding",
"Edit and create Languages" => "Aanmaken/bewerken Talen",
"Edit and create languages" => "Aanmaken/bewerken talen",
"Create Language" => "Aanmaken Taal",
"Shortname" => "Korte naam",
"like" => "zoals",
"Longname" => "Lange naam",
"Select the language to edit" => "Taal selecteren voor bewerking",
"Add a translation" => "Toevoegen vertaling",
"Edit translations" => "Bewerk vertalingen",
"Translate recorded" => "Vertaling opgenomen",
"Translation" => "Vertaling",
"reset table" => "maak tabel leeg",
"Create New Block" => "Nieuw blok maken",
"Return to block listing" => "Terug naar opsomming blokken",
"Block description: " => "Blokomschrijving: ",
"You are editing block:" => "U bewerkt nu blok:",
"Publishing date" => "Publicatiedatum",
"Publishing Date" => "Publicatiedatum",
"Edit question options" => "Bewerk vraag optiens",
"List Quizzes" => "Quizzen Opsommen",
"Quiz Stats" => "Statistieken voor quiz",
"This Quiz Stats" => "Statistieken voor deze quiz",
"Edit this Quiz" => "Deze quiz bewerken",
"Admin Quizzes" => "Quizzen beheren",
"Create/edit options for question" => "Opties voor deze vraag aanmaken/bewerken",
"Create/edit quizzes" => "Quizzen maken/bewerken",
"There are individual permissions set for this quiz" => "Voor deze quiz bestaan er individuele permissies",
"Quiz can be repeated" => "Quiz kan herhaald worden",
"Store quiz results" => "Quizresultaten opslaan",
"Immediate feedback" => "Onmiddellijke terugkoppeling",
"Show correct answers" => "Toon juiste antwoorden",
"Shuffle questions" => "Gooi vragen door mekaar",
"Shuffle answers" => "Gooi antwoorden door mekaar",
"Questions per page" => "Vragen per pagina",
"Quiz is time limited" => "Quiz is beperkt in de tijd",
"Maximum time" => "Maximale tijd",
"Passing Percentage" => "Slaagpercentage",
"canRepeat" => "kanHerhalen",
"timeLimit" => "tijdLimiet",
"Edit quiz questions" => "Bewerk quiz vragen",
"Create/edit questions for quiz" => "Vragen voor quiz aanmaken/bewerken",
"Question Type" => "Vraag Type",
"Import questions from text" => "Importeer vragen van tekst",
"Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructies: Type of plak oonderstaand uw meerkeuze vragen. De eerste regel is voor de vraag, volgende regels dienen voor de antwoorden.  Scheidt opeenvolgende vragen met een blanco regel.  Geef de juiste antwoorden aan met het beginteken \"*\" (zonder de aanhalingstekens).",
"Input" => "Invoer",
"From Points" => "Van Punten",
"To Points" => "Naar Punten",
"Answer" => "Antwoord",
"Modify Structure" => "Bewerk structuur",
"You will remove" => "U zal verwijderen:",
"and its subpages from the structure, now you have two options:" => "en zijn subpagina's uit de structuur, nu heeft u twee mogelijkheden:",
"Remove only from structure" => "Enkel uit structuur verwijderen",
"Remove from structure and remove page too" => "Uit structuur verwijderen en bovendien pagina verwijderen",
"Structure Layout" => "structuurlayout",
"Promote" => "Promoveer",
"Demote" => "Degradeer",
"Current Node" => "Huidige node",
"Page alias" => "Pagina alias",
"Add pages to current node" => "Voeg pagina's toe aan huidige node",
"After page" => "Na pagina",
"Create Page" => "Pagina aanmaken",
"Use pre-existing page" => "Gebruik reeds bestaande pagina",
"Submit article" => "Artikel inleveren",
"List Submissions" => "Bijdragen opsommen",
"<b>*</b>=optional" => "<b>*</b>=facultatief",
"<b>Topline</b>=small line above Title" => "<b>Topline</b>=smalle lijn boven de Titel",
"<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=smalle lijn beneden de Titel",
"<b>Source</b>=URL to article source" => "<b>Source</b>=URL naar de bron van het artikel",
"Edit templates" => "Sjablonen bewerken",
"Template listing" => "Sjabloonlijst",
"Available templates" => "Beschikbare sjablonen",
"Edit a topic" => "Bewerk een onderwerp",
"You must specify the object language" => "U dient de taal van het object op te geven",
"The object doesn't exist" => "Het object bestaat niet",
"The object doesn't have a language" => "Het object heeft geen taal",
"The object has already a translation for this language" => "Het object is reeds vertaald in deze taal",
"The object is already in the set of translations" => "Het object is reeds aanwezig in de vertalingen",
"detach" => "loskoppelen",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "De zandbak is een pagina waar u kan u leren hoe u pagina's kan bewerken, gebruik het voorbeeld om het uitzicht van de pagina te bekijken, er worden geen versies van deze pagina opgeslagen.",
"Admin Content Templates" => "Inhoudsjablonen beheren",
"Use rating" => "Gebruik beoordelingen",
"There is no available poll template." => "Er is geen beschikbaar opiniepeilingensjabloon.",
"You should ask an admin to create them." => "U dient een beheerder te vragen deze aan te maken.",
"an existing poll" => "een bestaande opiniepeiling",
"votes" => "stemmen",
"Year:" => "Jaar:",
"Authors:" => "Auteurs:",
"Try to convert HTML to wiki" => "Probeer conversie van HTML naar wiki",
"Import page" => "Pagina importeren",
"export all versions" => "alle versies exporteren",
"Upload picture" => "Afbeelding aanleveren",
"License" => "Licentie",
"Important" => "Belangrijk",
"Graph" => "Grafiek",
"lastModif" => "laatsteWijz",
"Admin FAQ" => "FAQ beheren",
"List FAQs" => "FAQs opsommen",
"View FAQ" => "FAQ bekijken",
"Edit this FAQ" => "Deze FAQ bewerken",
"New Question" => "Nieuwe vraag",
"Use a question from another FAQ" => "Een vraag van een andere FAQ gebruiken",
"FAQ questions" => "FAQ vragen",
"Suggested questions" => "Voorgestelde vragen",
"No suggested questions" => "Geen vraag suggesties",
"Upload File" => "Bestand Aanleveren",
"View tpl" => "Bekijk sjabloon",
"File Galleries tpl" => "Bestandgalerijen sjabloon",
"You can access the file gallery using the following URL" => "U kan de bestandgalerij bereiken met de volgende URL",
"Admin forums" => "Forums beheren",
"Edit queued message" => "Bewerk bericht in de wachtrij",
"make this a thread of" => "maak dit een thread van",
"None, this is a thread message" => "Geen, dit is een thread bericht",
"summary" => "samenvatting",
"normal" => "normaal",
"announce" => "aankondigen",
"hot" => "belangrijk",
"no feeling" => "geen gevoel",
"frown" => "fronsen",
"exclaim" => "uitdrukking",
"idea" => "idee",
"mad" => "kwaad",
"neutral" => "neutraal",
"question" => "vraag",
"sad" => "droevig",
"happy" => "gelukkig",
"wink" => "knipoog",
"Save and Approve" => "Bewaar en goedgekeurd",
"convert to topic" => "converteer naar onderwerp",
"List of messages" => "Berichtenlijst",
"New Topic" => "Nieuw bericht",
"no summary" => "geen samenvatting",
"No messages queued yet" => "Nog geen berichten in de wachtrij gezet",
"Last Post" => "Laatste bijdrage",
"Configure Forum" => "Instellen forum",
"Reported by" => "Gemeld door",
"Pending requests" => "Openstaande verzoeken",
"Request Time" => "Verzoek tijdstip",
"Accept" => "Aanvaardt",
"Refuse" => "Weiger",
"Waiting requests" => "Verzoeken in wachtrij",
"Your friends" => "Uw vrienden",
"break friendship" => "verbreek vriendschap",
"Activity completed" => "Activiteit be-eindigd",
"Admin process activities" => "Proces-activiteiten beheren",
"Add or edit an activity" => "Maak aan of bewerk een activiteit",
"activity" => "activiteit",
"split" => "splits",
"join" => "voeg samen",
"standalone" => "alleenstaand",
"interactive" => "interactief",
"auto routed" => "auto-sturing",
"Expiration Time" => "Verlooptijd",
"Years" => "Jaren",
"Months" => "Maanden",
"Hours" => "Uren",
"Minutes" => "Minuten",
"Add transitions" => "Voeg vertaling toe",
"Add transition from:" => "Voeg vertaling toe van:",
"Add transition to:" => "Voeg vertaling toe aan:",
"No roles associated to this activity" => "No functies geassocieerd met deze activiteit",
"Add Role" => "Voeg functie toe",
"Add New" => "Voeg nieuwe toe",
"Process activities" => "Proces activiteiten",
"Interactive" => "Interactief",
"Automatic" => "Automatisch",
"Auto routed" => "Auto-sturing",
"Manual" => "Manueel",
"route" => "sturing",
"(no roles)" => "(geen functies)",
"No activities defined yet" => "Nog geen activiteiten gedefinieerd",
"Process Transitions" => "Proces Transities",
"List of transitions" => "Lijst van transities",
"Origin" => "Oorsprong",
"No transitions defined yet" => "Nog geen transities gedefinieerd",
"Add a transition" => "Voeg een transitie toe",
"Process Graph" => "Proces Grafiek",
"Galaxia Admin Graph" => "Galaxia Grafiek beheren",
"Galaxia Admin Graph tpl" => "Galaxia Grafiek beheren sjabloon",
"Edit Tpl" => "Bewerk sjabloon",
"This process is invalid" => "Dit proces is ongeldig",
"Process Graph for" => "Proces Grafiek voor",
"No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "Geen proces grafiek aanwezig. Ofwel bevat het proces nog fouten, ofwel is de grafiek nog niet aangemaakt, ofwel is <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> niet correct geinstalleerd.",
"List of processes" => "Processenlijst",
"Inactive" => "Inactief",
"val" => "waarde",
"Active Process" => "Actieve processen",
"Invalid Process" => "Ongeldige processen",
"Valid Process" => "Geldige processen",
"Activities" => "Activiteiten",
"New Minor" => "Nieuwe sub",
"New Major" => "Nieuwe hoofd",
"No processes defined yet" => "Nog geen processe gedefinieerd",
"Admin instance" => "Incarnatie beheren",
"Process:" => "Proces:",
"Instance" => "Incarnatie",
"Workitems" => "Werkitems",
"exception" => "uitzondering",
"completed" => "afgerond",
"Aborted" => "Afgebroken",
"Owner" => "Eigenaar",
"Send all to" => "Verzend alles naar",
"Don't move" => "Verplaats niet",
"Started" => "Gestart",
"Ended" => "Be&euml;indigd",
"Not Defined" => "Niet Gedefinieerd",
"Not Interactive" => "Niet Interactief",
"Not Ended" => "Niet Be&euml;indigd",
"Property" => "Eigenschap",
"Add property" => "Voeg eigenschap toe",
"run instance" => "activeer incarnatie",
"Executed" => "Uitgevoerd",
"erase" => "verwijder",
"Admin processes" => "Processen beheren",
"Galaxia Admin Processes" => "Galaxia Processen beheren",
"Galaxia Admin Processes tpl" => "Galaxia Processen beheren sjabloon",
"Add or edit a process" => "Voeg toe of bewerk een proces",
"Process Name" => "Procesnaam",
"is active?" => "is actief?",
"Or upload a process using this form" => "Of lever een proces aan via dit formulier",
"Admin process roles" => "Procesfuncties beheren",
"Add or edit a role" => "Voeg toe of bewerk een functie",
"Process roles" => "Processfuncties",
"No roles defined yet" => "Nog geen functies gedefinieerd",
"Map users to roles" => "Map gebruikers naar functies",
"Map groups to roles" => "Map groepen naar functies",
"Operation" => "Operatie",
"No roles are defined yet so no roles can be mapped" => "Nog geen functies gedefinieerd dus kunnen er ook geen functies gemapd worden",
"List of mappings" => "Lijst van mappings",
"No mappings defined yet" => "Nop geen mappings gedefinieerd",
"Admin process sources" => "Procesbronnen beheren",
"select source" => "kies bron",
"Shared code" => "Gedeelde code",
"Set next user" => "Plaats volgende gebruiker",
"Get property" => "Haal eigenschap op",
"Set property" => "Definieer eigenschap",
"Process form" => "Procesformulier",
"Set Next act" => "Bepaal Volgende act",
"If:SetNextact" => "Indien:DefVolgendeeact",
"Switch construct" => "Draai constructie om",
"Map process roles" => "Map procesfuncties",
"Admin Processes" => "Processen beheren",
"Admin Activities" => "Activiteiten beheren",
"Admin Roles" => "Functies beheren",
"Edit this Process" => "Bewerk dit proces",
"Monitor Activities" => "Monitor activiteiten",
"Galaxia Monitor Activities" => "Galaxia Monitor Activiteiten",
"Galaxia Monitor Activities tpl" => "Galaxia Monitor Activiteiten sjabloon",
"List of activities" => "Activiteitenlijst",
"Instances" => "Incarnaties",
"run" => "activeer",
"run activity" => "activeer activiteit",
"Enter the name of this instance" => "Voer de naam in van deze incarnatie",
"The name is not valid. Please, enter the name again" => "De naam is ongeldig. Probeer nogmaals",
"monitor processes" => "monitor processen",
"monitor activities" => "monitor activiteiten",
"monitor instances" => "monitor incarnaties",
"monitor workitems" => "monitor werkitems",
"Monitor Instances" => "Monitor incarnaties",
"Galaxia Monitor Instances" => "Galaxia Monitor Incarnaties",
"Galaxia Monitor Instances tpl" => "Galaxia Monitor Incarnaties sjabloon",
"List of instances" => "Lijst van incarnaties",
"Not ended" => "Niet be&euml;indigd",
"No instances created yet" => "Nog geen incarnaties aangemaakt",
"Monitor Processes" => "Monitor processen",
"Galaxia Monitor Processes" => "Galaxia Monitor Processen",
"Galaxia Monitor Processes tpl" => "Galaxia Monitor Processen sjabloon",
"processes" => "processen",
"being run" => "lopende",
"Completed" => "Afgerond",
"Exceptions" => "Uitzondering",
"Monitor workitems" => "Monitor werkitems",
"List of workitems" => "Lijst van werkitems",
"instance" => "incarnatie",
"My activities" => "Mijn activiteiten",
"Current Activity" => "Huidige Activiteit",
"Assigned To" => "TOegewezen Aan",
"exception instance" => "uitzonderingsincarnatie",
"exceptions instance" => "uitzonderingenincarnatie",
"Send Instance" => "Verstuur incarnatie",
"abort instance" => "breek incarnatie af",
"grab instance" => "grijp incarnatie",
"release instance" => "laat incarnatie vrij",
"No activities found" => "Geen activiteiten gevonden",
"My instances" => "Mijn incarnaties",
"No instances found" => "Geen incarnaties gevonden",
"User Activities" => "Gebruikeractiviteiten",
"Galaxia User Activities" => "Galaxia Gebruiker Activiteiten",
"Galaxia User Activities tpl" => "Galaxia Gebruiker Activiteiten sjabloon",
"process" => "proces",
"user processes" => "gebruikerprocessen",
"user activities" => "gebruikeractiviteiten",
"user instances" => "gebruikerincarnaties",
"User Instances" => "Gebruikerincarnaties",
"Galaxia User Instances" => "Galaxia Gebruiker Incarnaties",
"Galaxia User Instances tpl" => "Galaxia Gebruiker Incarnaties sjabloon",
"Not defined" => "Niet gedefinieerd",
"No instances defined yet" => "Nog geen incarnaties gedefinieerd",
"User Processes" => "Gebruikerprocessen",
"Galaxia User Processes" => "Galaxia Gebruikerprocessen",
"Galaxia User Processes tpl" => "Galaxia Gebruikerprocessen sjabloon",
"Browsing Workitem" => "Bekijken Werkitem",
"Workitem information" => "Informatie Werkitem",
"Galleries" => "Galerijen",
"Create New Gallery" => "Maak een nieuwe galerij aan",
"Create a gallery" => "Maak een galerij aan",
"Edit this gallery:" => "Bewerk deze galerij:",
"There are individual permissions set for this gallery" => "Er bestaan individuele permissies voor deze galerij",
"Geographic" => "Geografisch",
"Fields to show during browsing the gallery" => "Velden die getoond moeten worden tijdens het bladeren door de galerij",
"Creation Date" => "Aanmaakdatum",
"XY-Size" => "XY-Grootte",
"Gallery Image" => "Galerijafbeelding",
"Available scales" => "Beschikbare schalen",
"Bounding box" => "Vormkader",
"default scale" => "standaard schaal",
"No scales available" => "Geen schalen beschikbaar",
"Original image is default scale" => "Originele afbeelding is standaard schaal",
"Add scaled images with bounding box of square size" => "Voeg geschaalde afbeeldingen toe met een vierkant vormkader",
"Other users can upload images to this gallery" => "Andere gebruikers kunnen afbeeldingen aanleveren aan deze galerij",
"You can access the gallery using the following URL" => "U kan de galerij via volgende URL bereiken",
"Available Galleries" => "Beschikbare galerijen",
"Choose a filter" => "Kies een filter",
"Imgs" => "Afb.",
"Make Map" => "Maak Kaart aan",
"Pie Chart" => "Taartgrafiek",
"Multiline" => "Multilijns",
"Multibar" => "Multibalken",
"Bar Stack" => "Gestapelde balken",
"Landscape" => "Liggend",
"Portrait" => "Staand",
"Independant Scale" => "Onafhankelijke Schaal",
"Horizontal Scale" => "Horizontale Schaal",
"Bottom" => "Laagste",
"Vertical Scale" => "Verticale Schaal",
"Series" => "Reeks",
"Im- Export languages" => "Im-/Export talen",
"Select the language to Import" => "Selecteer taal voor Import",
"Select the language to Export" => "Selecteer taal voor Export",
"Import From File" => "Importeer van Bestand",
"Grab Wiki Tables" => "Pak Wiki Tabellen",
"Import pages from a Structured Text Dump" => "Importeer pagina\\'s van een Gestrucutureerde Tekst Dump",
"Name of the dump file (it has to be in dump/)" => "Naam van het dump-bestand (moet in dump/ staan)",
"Overwrite existing pages if the name is the same" => "Bestaande pagina's overschrijven als de naam identiek is",
"Previously remove existing page versions" => "Vooraf bestaande paginaversies verwijderen",
"excerpt" => "uittreksel",
"Result" => "Resultaat",
"body" => "tekstlichaam",
"Locked" => "Vergrendeld",
"Install" => "Installeer",
"Configure General Settings" => "Algemene Instellingen",
"Clear cached version and refresh cache" => "Leef buffer versie en ververs buffer",
"configure rules" => "Configureer regels",
"Edit Repository" => "Bewerk bewaarplaats",
"Last Changes" => "Laatste Wijzigingen",
"Search by Date" => "Zoeken volgens datum",
"LastChanges" => "LaatsteWijzigingen",
"Rollback" => "Terugplaatsen",
"Pages like" => "Gelijkaardige pagina's",
"No pages found" => "Geen pagina's gevonden",
"Edit New Article" => "Nieuw artikel bewerken",
"View Submissions" => "Bijdragen bekijken",
"ExpireDate" => "Verloopdatum",
"AuthorName" => "AuteursNaam",
"Create banner" => "Advertentie aanmaken",
"Method" => "Methode",
"Use Dates?" => "Data gebruiken?",
"Max Impressions" => "Max klikken",
"Impressions" => "Klikken",
"Clicks" => "Klikken",
"Create New Blog" => "Maak nieuwe blog aan",
"Use cache for external pages" => "Buffer gebruiken voor externe pagina's",
"Dynamic content system" => "Systeem met dynamische inhoud",
"Available content blocks" => "Beschikbare inhoudsblokken",
"Current ver" => "Huidige versie",
"Next ver" => "Volgende versie",
"Future vers" => "Toekomstige vers",
"Program" => "Programma",
"Edit this FAQ:" => "Bewerk deze FAQ:",
"Create new FAQ" => "Maak nieuwe FAQ aan",
"Create New FAQ:" => "Maak Nieuwe FAQ aan:",
"Users can suggest questions" => "Gebruikers kunnen vragen voorstellen",
"Available FAQs" => "Beschikbare FAQs",
"Create a File Gallery" => "Maak een bestandgalerij aan",
"optional" => "facultatief",
"Gallery Images" => "Galerijafbeeldingen",
"All games are from" => "Alle spelletjes zijn van",
"visit the site for more games and fun" => "bezoek de site voor meer spelletjes en plezier",
"Upload a game" => "Een spelletje aanleveren",
"Upload a new game" => "Een nieuw spelletje aanleveren",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Voorbeeldplaatje (als het spelletje iets.swf is moet de thumbnail iets.swf.gif of iets.swf.png of iets.swf.jpg genoemd worden)",
"Edit game" => "Spel bewerken",
"Played" => "Gespeeld",
"If you can't see the game then you need a flash plugin for your browser" => "Als u het spelletje niet kan zien dan heeft u een flash plugin nodig voor uw browser",
"Edit Blog" => "Blog Bewerken",
"Blog Title" => "Blogtitel",
"Edit New Submission" => "Nieuwe bijdrage bewerken",
"Survey stats" => "Statistieken voor opinieonderzoek",
"Take Survey" => "Neem deel aan opinieonderzoek",
"Distance (km)" => "Afstand (km)",
"List Movies" => "Opsommen Filmen",
"Choose a movie" => "Kies een film",
"Last mod" => "Laatste wijz.",
"Last author" => "Laatste auteur",
"Last version" => "Laatste versie",
"unlocked" => "ontsloten",
"Open client window" => "Open client venster",
"Generate HTML" => "Maak HTML aan",
"Transcripts" => "Afschriften",
"Online operators" => "Online operatoren",
"Accepted requests" => "Aanvaarde aanvragen",
"since" => "sinds",
"transcripts" => "afschriften",
"Offline operators" => "Offline operatoren",
"Add an operator to the system" => "Voeg een operator toe aan het systeem",
"Operators must be tiki users" => "Operatoren moeten tiki gebruikers zijn",
"Set as Operator" => "Definieer als operator",
"Chat started" => "Praatkamer gestart",
"Live support:User window" => "Live ondersteuning:gebruikervenster",
"Request live support" => "Vraag live-ondersteuning aan",
"Request support" => "Vraag ondersteuning aan",
"Open a support ticket instead" => "Open een ondersteuningsticket ipv",
"Your request is being processed" => "Uw aanvraag wordt behandeld",
"cancel request and exit" => "annuleer aanvraag en verlaat",
"cancel request and leave a message" => "annuleer aanvraag en laat een bericht achter",
"Live support:Console" => "Live-ondersteuning:Console",
"be online" => "ga online",
"be offline" => "ga offline",
"Support requests" => "Ondersteuningsaanvragen",
"Requested" => "Aangevraagd",
"Join" => "Neem deel",
"Support chat transcripts" => "Afschriften Ondersteuningskanaal",
"started" => "gestart",
"reason" => "reden",
"msgs" => "brchtn",
"Transcript" => "Afschrift",
"Mail-in feature" => "Mail-in onderdeel",
"Prefs" => "Voorkeuren",
"Remove old events" => "Verwijderen oude evenementen",
"duration" => "duur",
"Mini Calendar: Preferences" => "Mini-Kalender: Voorkeuren",
"Calendar Interval in daily view" => "Kalendarinterval in dagzicht",
"Start hour for days" => "Startuur voor dagen",
"End hour for days" => "Einduur voor dagen",
"Reminders" => "Herinneringen",
"no reminders" => "geen herinneringen",
"Or enter path or URL" => "Of voer pad of URL in",
"Add Topic" => "Onderwerp toevoegen",
"Update remote index" => "Werk verre index bij",
"Rebuild local list" => "Hermaal lokale lijst",
"Republish all" => "Publiceer alles opnieuw",
"Publish all" => "Publiceer alles",
"Unpublish all" => "Maak publicatie van alles ongedaan",
"Attention" => "Attentie",
"all types" => "alle types",
"Display only this type" => "Toon enkel dit type",
"Unpublish" => "Maak publicatie ongedaan",
"Republish" => "Publiceer opnieuw",
"Tikiwiki Mods Configuration" => "Tikiwiki Mods Configuratie",
"Enable Mods providing" => "Schakel Mods in die voorzien in",
"Mods local directory" => "Mods lokale folder",
"Mods remote server" => "Mods verre server",
"Package Config" => "Pakket Config",
"User Pages" => "Gebruikerpagina's",
"User Galleries" => "Gebruikergalerijen",
"Unread Messages" => "Niet-gelezen berichten",
"Tasks" => "Taken",
"User Blogs" => "Gebruikerblogs",
"To display the objects you participate:" => "Om de objecten te tonen waar je aan meewerkt:",
"MyTiki" => "MijnTiki",
"Notepad" => "Kladblok",
"MyFiles" => "MijnBestanden",
"My Watches" => "Mijn wakers",
"Assigned items" => "Toegewezen items",
"Sent editions" => "Verzonden uitgaven",
"The newsletter was sent to {\$sent} email addresses" => "De nieuwsbrief is naar {\$sent} e-mail addressen verstuurd",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Bedankt voor uw inschrijving. U zal binnenkort een e-mailbericht ontvangen om uw inschrijving te bevestigen. U zal geen nieuwsbrieven ontvangen tot uw inschrijving bevestigd is.",
"Your email address was removed from the list of subscriptors." => "Uw e-mail adres is verwijderd van de abonneelijst.",
"Subscription confirmed!" => "Inschrijving bevestigd!",
"Subscribe to Newsletter" => "Zich op nieuwsbrief abonneren",
"Subscribe to this Newsletter" => "Abonneren",
"Available Newsletters" => "Beschikbare nieuwsbrieven",
"Select news group" => "Selecteren nieuwsgroep",
"Back to servers" => "Terug naar de servers",
"Msgs" => "Brchtn",
"News from" => "Nieuws",
"Back to groups" => "Terug naar de groepen",
"Save position" => "Positie bewaren",
"Reading article from" => "Artikel lezen van",
"Back to list of articles" => "Teurg naar de lijst van artikelen",
"Newsgroup" => "Nieuwsgroep",
"Configure news servers" => "Stel nieuwsservers in",
"Configure Newsreader" => "Configureer Nieuwslezer",
"configure newsreader server tpl" => "configureer nieuwslezer server sjabloon",
"Select a news server to browse" => "Selecteer een nieuwsserver om door te bladeren",
"Read the news" => "Lees het nieuws",
"News server" => "Nieuwsserver",
"Notes" => "Notities",
"Write a note" => "Notitie schrijven",
"No notes yet" => "Nog geen notities",
"Merge selected notes into" => "voeg geselecteerde notities in",
"Reading note:" => "Notitie lezen",
"List notes" => "Notities tonen",
"Write note" => "Notitie schrijven",
"Wiki Create" => "Wiki aanmaak",
"Wiki Overwrite" => "Wiki overschrijf",
"Assign permissions to " => "Permissies toekennen aan ",
"Current permissions for this object" => "Huidige permissies voor dit object",
"No category permissions; global permissions apply" => "Geen categorie permissies; globale permissies zijn van kracht",
"Assign permissions to this object" => "Permissies toekennen aan dit object",
"Published" => "Gepubliceerd",
"Orphan Pages" => "Verweesde Pagina's",
"Browser not supported" => "Browser niet ondersteund",
"Rename" => "Hernoemen",
"Slides" => "Dia's",
"Discuss" => "Discussieer",
"Attach File" => "Voeg bijlage toe",
"1 File Attached" => "1 bestand aangehangen",
"Preview of version" => "Voorbeeld van versie",
"(current)" => "(huidige)",
"Rollback to this version" => "Draai terug naar deze versie",
"Source of version" => "Bron van de versie",
"s=source" => "s=bron (source)",
"b=rollback" => "b=draai terug (rollback)",
"Pick your avatar" => "Kies uw pictogram",
"User Preferences" => "Gebruikerinstellingen",
"Your current avatar" => "Uw huidige pictogram",
"no avatar" => "geen pictogram",
"reset" => "herzet",
"Pick avatar from the library" => "Pictogram uit de bibliotheek kiezen",
"Pick user Avatar" => "Kies gebruikerpictogram",
"Hide all" => "Verberg alles",
"icons" => "ikonen",
"Show all" => "Toon alles",
"Avatar Image" => "Pictogramafbeelding",
"Upload your own avatar" => "Uw eigen pictogram aanleveren",
"Insert" => "Voeg in",
"atts" => "attn",
"List Attachments" => "Bijlagenlijst",
"Average" => "Gemiddelde",
"View Results" => "Bekijk Resultaten",
"Vote poll" => "Stem opiniepeiling",
"Other Polls" => "Andere Opiniepeilingen",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Opmerking: Deze voorbeeldversie werd nog niet opgeslagen!",
"on:" => "op:",
"Topic image" => "Afbeelding onderwerp",
"Viewing blog post" => "Blog-bijdrage bekijken",
"Return to blog" => "Terug naar blog",
"The original document is available at" => "Het originele document is beschikbaar op",
"Print multiple pages" => "Meerdere pagina's afdrukken",
"Add Page" => "Voeg Pagina toe",
"Edit quiz" => "Bewerk quiz",
"General Options" => "Algemene opties",
"Name:" => "Naam:",
"Publication Date" => "Publicatiedatum",
"at " => "aan ",
"Use " => "gebruik ",
"randomly selected questions." => "willekeurig gekozen vragen.",
"Test-time Options" => "Test-tijd Opties",
"Limit questions displayed per page to " => "Beperk aantal getoonde vragen per pagina tot ",
"&nbsp question(s)." => "&nbsp vra(a)g(en).",
"Impose a time limit of " => "Zet een tijdslimiet van ",
"Allow students to store partial results and return to quiz." => "Laat studenten toe om tussentijdse resultaten op te slaan en naar quiz terug te keren.",
"Allow students to retake this quiz " => "Laat studenten toe om deze quiz te herdoen ",
"Grading and Feedback" => "Beoordeling en terugkoppeling",
"Grading method " => "Beoordelingsmethode ",
"Show students their score " => "Toon score aan studenten ",
"Show students the correct answers " => "Toon juiste antwoorden aan studenten ",
"Publish statistics " => "Publiceer statistieken ",
"Extra Options" => "Extra Opties",
"Solicit additional questions from students" => "Verzoek om bijkomende vragen aan studenten",
"Link quiz to forum named: " => "Koppel quiz aan genaamd forum: ",
"Prologue:" => "Proloog:",
"Epilogue:" => "Epiloog:",
"Quiz result stats" => "Statistieken voor quizresultaat",
"Time" => "Tijd",
"User answers" => "Gebruikerantwoorden",
"Stats for quizzes" => "Statistieken voor quizzen",
"taken" => "uitgevoerd",
"Av score" => "Gem. score",
"Av time" => "Gem. tijd",
"Clear Stats" => "Statistieken verwijderen",
"time taken" => "verstreken tijd",
"Stats for this quiz Questions " => "Statistieken voor de vragen in deze quiz ",
"Received articles" => "Ontvangen artikelen",
"Edit received article" => "Ontvangen artikelen bewerken",
"Use Image" => "Afbeelding Gebruiken",
"Image x size" => "Afbeelding x-afmeting",
"Image y size" => "Afbeelding y-afmeting",
"Image name" => "Afbeeldingnaam",
"Accept Article" => "Artikel Aanvaarden",
"Referer stats" => "Verwijzerstatistieken",
"A valid email is mandatory to register" => "Een geldig e-mail adres is vereist voor registratie",
"Tiki site registered" => "Tiki site geregistreerd",
"The following site was added and validation by admin may be needed before appearing on the lists" => "De volgende site is toegevoegd maar mogelijkerwijze moet deze eerst door een beheerder gevalideerd worden vooraleer deze op de lijst verschijnt",
"You don't have permission to use this feature." => "U heeft geen toestemming om dit onderdeel te gebruiken.",
"Please register." => "Meldt u zich aub aan.",
"Register this site at tikiwiki.org" => "Registreer deze site op tikiwiki.org",
"Read this first!" => "Lees dit eerst!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Op deze pagina kan u uw Tiki site kenbaar maken op tikiwiki.org. Uw site zal opgenomen worden in een lijst van gekende tiki sites.",
"Registering is voluntary." => "Registratie is vrijwillig.",
"Registering does not give you any benefits except one more link to your site." => "Registratie geeft u enkel het voordeel van een extra koppeling naar uw eigen site.",
"You don't get any emails, we don't sell the data about your site." => "U zal geen e-mails ontvangen en uw gegevens worden niet aan derden verkocht.",
"Registering is just for us to get an overview of Tiki's usage." => "De registratie dient er enkel toe een overzicht te krijgen van het Tiki-gebruik.",
"If your site is private or inside your intranet, you should not register!" => "Indien uw site priv is of zich op een intranet bevindt, registreer u dan niet!",
"Information about your site" => "Informatie omtrent uw site",
"Send me my Password" => "Gelieve mijn wachtwoord op te sturen",
"Remove page" => "Pagina verwijderen",
"Last Version" => "Laatste versie",
"You are about to remove the page" => "Pas op, u zal een pagina verwijderen",
"permanently" => "permanent",
"Remove all versions of this page" => "Alle versies van deze pagina verwijderen",
"Replicate" => "Repliceer",
"Slave" => "Slaaf",
"Master" => "Meester",
"Operations" => "Handelingen",
"Operations Log" => "Handelingen Log",
"Rollback page" => "Pagina terugplaatsen",
"Searched" => "Gezocht",
"Search in" => "Zoeken in",
"Simple search" => "E&eacute; zoekopdracht",
"No pages matched the search criteria" => "Geen pagina's gevonden met deze zoekcriteria",
"Send blog post" => "Verstuur blogbijdrage",
"A link to this post was sent to the following addresses:" => "Een koppeling naar deze bijdrage is naar volgende adressen verzonden:",
"Send post to this addresses" => "Verzend bijdrage naar deze adressen",
"List of email addresses separated by commas" => "Lijst van e-mail adressen gescheiden door komma's",
"This newsletter will be sent to {\$subscribers} email addresses." => "Deze nieuwsbrief zal naar {\$subscribers} e-mail addressen verstuurd worden.",
"Prepare a newsletter to be sent" => "Een nieuwsbrief voorbereiden voor verzending",
"Apply content template" => "Pas Inhoudssjabloon toe",
"remove" => "verwijderen",
"Send objects" => "Objecten zenden",
"Transmission results" => "Overdrachtresultaten",
"Send Wiki Pages" => "Wikipagina's zenden",
"Send Articles" => "Artikel Zenden",
"Add Article" => "Artikel toevoegen",
"Send objects to this site" => "Objecten naar deze pagina zenden",
"Create a sheet" => "Maak een rekenblad aan",
"Edit this sheet:" => "Bewerk dit rekenblad:",
"Create New Sheet" => "Aanmaken rekenblad",
"There are individual permissions set for this sheet" => "Er zijn individuele permissies actief voor dit rekenblad",
"Class Name" => "Klasnaam",
"Header Rows" => "Hoofding Rijen",
"Footer Rows" => "Voettekst Rijen",
"Create new Sheet" => "Maak nieuw Rekenblad aan",
"You can access the sheet using the following URL" => "U kan het rekenblad bereiken via volgend URL",
"Available Sheets" => "Beschikbare rekenbladen",
"Change shoutbox general settings" => "Verander algemene instellingen spreekbuis",
"auto-link urls" => "auto-koppel urls",
"Post or edit a message" => "Een bijdragen toevoegen of bewerken",
"Parent page" => "Ouderpagina",
"Child" => "Kind",
"Last edited by" => "Laatst bijgewerkt door",
"based on work by" => "gebaseerd op het werk van",
"Contributors to this page" => "Leverde bijdrages tot deze pagina",
"big grin" => "grote grijns",
"confused" => "verward",
"cool" => "interessante",
"cry" => "huilt",
"evil" => "kwaadaardig",
"mr green" => "mr groen",
"redface" => "aangelopen",
"rolleyes" => "roltogen",
"smile" => "lacht",
"surprised" => "verrast",
"twisted" => "ziekelijk",
"arrow" => "pijl",
"Site Stats" => "Statistieken voor de site",
"Total pageviews" => "Totaal aantal keer bekeken",
"Average pageviews per day" => "Gemiddeld aantal keer bekeken per dag",
"Best day" => "Beste dag",
"Worst day" => "Slechtste dag",
"Wiki Stats" => "Statistieken voor wiki",
"Size of Wiki Pages" => "Grootte van wikipagina's",
"Average page length" => "Gemiddelde paginalengte",
"Average versions per page" => "Gemiddeld aantal versies per pagina",
"Visits to wiki pages" => "Aantal bezoeken aan wikipagina's",
"Orphan pages" => "Verweesde pagina's",
"Average links per page" => "Gemiddeld aantal koppelingen per pagina",
"Image galleries Stats" => "Statistieken voor beeldgalerijen",
"Average images per gallery" => "Gemiddeld aantal afbeeldingen per galerij",
"Total size of images" => "Grootte van alle afbeeldingen samen",
"Average image size" => "Gemiddelde grootte van afbeeldingen",
"Visits to image galleries" => "Aantal bezoeken aan beeldgalerijen",
"File galleries Stats" => "Statistieken voor bestandgalerijen",
"Average files per gallery" => "Gemiddeld aantal bestanden per galerij",
"Total size of files" => "Grootte van alle bestanden samen",
"Average file size" => "Gemiddelde bestandgrootte",
"Visits to file galleries" => "Aantal bezoeken aan bestandgalerijen",
"CMS Stats" => "Statistieken voor CMS",
"Total reads" => "Totaal aantal keer gelezen",
"Average reads per article" => "Gemiddeld aantal keer gelezen per artikel",
"Total articles size" => "Grootte van alle artikelen samen",
"Average article size" => "Gemiddelde grootte van een artikel",
"Forum Stats" => "Statistieken voor forum",
"Total topics" => "Onderwerpen samen",
"Average topics per forums" => "Gemiddeld aantal onderwerpen per forum",
"Visits to forums" => "Aantal bezoeken aan forums",
"Blog Stats" => "Statistieken voor blogs",
"Weblogs" => "Blogs",
"Total posts" => "Totaal aantal bijdragen",
"Average posts per weblog" => "Gemiddeld aantal berichten per blog",
"Total size of blog posts" => "Totale grootte van de blogbijdragen",
"Average posts size" => "Gemiddelde grootte van de bijdragen",
"Visits to weblogs" => "Aantal bezoeken aan blogs",
"Poll Stats" => "Statistieken voor opiniepeilingen",
"Total votes" => "Totaal aantal stemmen",
"Average votes per poll" => "Gemiddeld aantal stemmen per opiniepeiling",
"Total questions" => "Totaal aantal vragen",
"Average questions per FAQ" => "Gemiddeld aantal vragen per FAQ",
"User Stats" => "Statistieken voor gebruiker",
"User bookmarks" => "Gebruikerfavorieten",
"Average bookmarks per user" => "Gemiddeld aantal favorieten per gebruiker",
"Average questions per quiz" => "Gemiddeld aantal vragen per quiz",
"Quizzes taken" => "Uitgevoerde quizzen",
"Average quiz score" => "Gemiddelde quizscore",
"Average time per quiz" => "Gemiddelde tijd per quiz",
"Stats for surveys" => "Statistieken voor opinieonderzoeken",
"Last taken" => "Laatst uitgevoerd",
"Time Left" => "Tijd Over",
"Send Answers" => "Antwoorden verzenden",
"Thank you for your submission" => "Bedankt voor uw bijdrage",
"Your email was sent" => "Uw e-mail is verzonden",
"Theme is selected as follows" => "Thema is geselecteerd as volgens",
"If a theme is assigned to the individual object that theme is used." => "Een thema wordt gebruikt indien het thema is toegewezen aan een individueel object",
"If not then if a theme is assigned to the object's category that theme is used" => "Indien dit niet het geval is, wordt het thema gebruikt dat toegewezen is aan de objectcategorie",
"If not then a theme for the section is used" => "Indien dit niet het geval is, wordt het thema van de sectie gebruikt",
"If none of the above was selected the user theme is used" => "Indien geen enkele van bovenstaande mogelijkheden valabel is, wordt het gebruikerthema toegepast",
"Finally if the user didn't select a theme the default theme is used" => "Wanneer de gebruiker geen thema heeft geselecteerd, dan wordt het standaardthema gebruikt",
"Control by Objects" => "Controle per Objecten",
"Control by Sections" => "Controle per Sectie",
"Assign themes to categories" => "Thema's toewijzen aan categorie&euml;n",
"Assigned categories" => "Toegewezen categorie&euml;n",
"Theme Control Center: Objects" => "Thema Controlepaneel: Objecten",
"Control by Categories" => "Controle per Categorie",
"Assign themes to objects" => "Thema's toewijzen aan objecten",
"Assigned objects" => "Toegewezen objecten",
"Assign themes to sections" => "Thema's toewijzen aan secties",
"Assigned sections" => "Toegewezen secties",
"Edit File:" => "Bewerk Bestand:",
"The following file was successfully uploaded" => "Het volgende bestand is met success aangeleverd",
"You can download this file using" => "U kan dit bestand afhalen met",
"You have to create a gallery first!" => "U moet eerst een galerij aanmaken!",
"Batch Upload Results" => "Massa-aanlevering Resultaten",
"Upload successful!" => "Aanleveren gelukt!",
"The following image was successfully uploaded" => "De volgende afbeelding is met success aangeleverd",
"Image ID thumb" => "Afbeelding ID voorbeeld",
"You can include the image in an Wiki page using" => "U kan de afbeelding in een Wiki pagina insluiten door gebruik te maken van",
"or use filename" => "of gebruik bestandnaam",
"Now enter the image URL" => "Geef nu de URL van de afbeelding",
"or upload a local image from your disk" => "of lever een afbeelding aan van uw harde schijf",
"Batch Upload" => "Massa-aanlevering",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Voorbeeldplaatje (optioneel, overschrijft automatisch aangemaakte voorbeeldplaatjes)",
"Note: Maximum image size is limited to" => "Opmerking: Grootte van de afbeelding is beperkt tot",
"User assigned modules" => "Door de gebruiker toegekende modules",
"Assign module" => "Module toekennen",
"Column" => "Kolom",
"top" => "boven",
"Current folder" => "Huidige folder",
"Remove Folder" => "Verwijder folder",
"Refresh Cache" => "Ververs buffer",
"Admin folders and bookmarks" => "Folders en favorieten beheren",
"Manage Fields" => "Velden Beheren",
"Default view" => "Standaard beeld",
"Send me a message" => "Stuur me een bericht",
"Assign Group" => "Wijs Groep toe",
"Homepage" => "Thuispagina",
"Users HomePage" => "Gebruikersthuispagina",
"Personal Wiki Page" => "Persoonlijke Wiki Pagina",
"Create page" => "Maak pagina aan",
"This user is your friend" => "Deze gebruiker is uw vriend",
"Request friendship from this user" => "Verzoek vriendschap van deze gebruiker",
"Toggle options" => "Toggle opties",
"Personal Information" => "Persoonlijke Informatie",
"Your personal Wiki Page" => "Uw persoonlijke wikipagina",
"Your personal tracker information" => "Uw persoonlijke tracker informatie",
"View extra information" => "Bekijk extra informatie",
"Is email public? (uses scrambling to prevent spam)" => "Is e-mail publiek? (gebruik vervorming om spam te voorkomen)",
"Unavailable - please set your e-mail below" => "Niet beschikbaar - stel uw e-mail adres onderstaand in",
"Does your mail reader need a special charset" => "Vereist uw e-mail programma een speciale karakterset?",
"Note author when reading his mail" => "Informeer auteur wanneer hij/zij het bericht leest",
"Account Information" => "Account Informatie",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Laat \"Nieuw wachtwoord\" en \"Bevestig nieuw wachtwoord\" velden open om uw huidig wachtwoord te behouden",
"Email address" => "E-mail adres",
"Confirm new password" => "Bevestig nieuw wachtwoord",
"Current password (required)" => "Huidig wachtwoord (vereist)",
"Change administrative info" => "Wijzig administratieve informatie",
"New task" => "Nieuwe taak",
"Task list" => "Takenlijst",
"Admin mode off" => "Beheermodus uit",
"Admin mode on" => "Beheermodus aan",
"Task help" => "Taakhulp",
"Empty Trash" => "Maak prullendmand leeg",
"Received task" => "Ontvangen taak",
"You received this task, please read and execute it" => "U heeft deze taak ontvangen, gelieve aandachtig te lezen en de taak op te lossen",
"Send task" => "Verzend taak",
"You send this task to a other user" => "U heeft deze taak naar een andere gebruiker verzonden",
"Shared task" => "Gedeelde taak",
"This task is public to a special group" => "Deze taak is publiek voor eens speciale groep",
"Accepted by Task User and Creator" => "Aanvaard door de taakgebruiker en auteur",
"Accepted User and Creator" => "Aanvaard door de gebruiker en auteur",
"Task is accepted by user and creator" => "Taak is aanvaard door de gebruiker en auteur",
"Not Accepted by One User" => "Niet aanvaard door 1 gebruiker",
"Not Accepted User" => "Niet-aanvaarde gebruiker",
"Task is rejected by one user" => "Taak werd niet aanvaard door 1 gebruiker",
"Waiting for Me" => "Wachtend voor mij",
"Task is not accepted by you, read the task and accept or reject it" => "Taak werd niet door u geaccepteerd, lees aub de taak en accepteer of verwerp dan de taak",
"Waiting for Other User" => "Wachtend op een andere gebruikers",
"Task is not accepted/rejected by other user" => "Taak werd niet aanvaard/verworpen door een andere gebruiker",
"Admin Mode" => "Beheermodus",
"Edit task" => "Werk taak bij",
"NOT accept" => "NIET aanvaard",
"Remove from Trash" => "Verwijder uit prullenmand",
"Move into Trash" => "Verplaats naar prullenmand",
"Task saved" => "Taak opgeslagen",
"Edit Task" => "Bewerk Taak",
"View Task" => "Bekijk Taak",
"Open a new task" => "Open een nieuwe taak",
"taskId" => "taakId",
"Task user" => "Taakgebruikers",
"Only the creator can delete this task" => "Enkel de auteur kan deze taak verwijderen",
"Use start date and time" => "Gebruik startdatum en -tijd",
"Use end date and time" => "Gebruik einddatum en -tijd",
"Open / In Process" => "Open / in uitvoering",
"Waiting / Not Started" => "In wachtrij / niet gestart",
"Percentage completed" => "Percentage afgerond",
"Waiting" => "In wachtrij",
"Shared for Group" => "Gedeeld voor groep",
"Accepted by User" => "Aanvaard door gebruiker",
"No / Rejected" => "Neen / verworpen",
"Accepted by Creator" => "Aanvaard door auteur",
"This message will be send to users if you are makeing changes of assigned tasks" => "Dit bericht zal worden verstuurd naar de gebruikers indien u veranderingen aan de toegewezen taken aanbrengt",
"Send message with changes" => "Stuur bericht met veranderingen",
"Modified by" => "Bijgewerkt door",
"Marked as deleted" => "Gemarkeerd als verwijderd",
"Inform task user by email" => "Informeer taakgebruiker via e-mail",
"You can only view this task" => "U kan deze taak enkel bekijken",
"No tasks entered" => "Geen taken ingevoerd",
"Select One" => "Selecteer 1",
"Undo Trash" => "Haal terug uit prullenmand",
"Show:" => "Toon:",
"Received" => "Ontvangen",
"Submitted" => "Ingeleverd",
"Shared" => "Gedeeld",
"All Shared Tasks" => "Alle gedeelde taken",
"completed (100%)" => "voltooid (100%)",
"Public for group" => "Publiek voor groep",
"Add Watch" => "Voeg waak toe",
"Watches" => "Monitors",
"A user submits a blog post" => "Een gebruiker levert een blogbericht aan",
"A user posts a forum thread" => "Een gebruiker levert een forumonderwerp aan",
"A user posts a forum topic" => "Een gebruiker levert een forumbericht aan",
"A user edited a wiki page" => "Een gebruiker werkt een wiki pagina bij",
"May need to refresh twice to see changes" => "Moet mogelijks tweemaal ververst worden om de veranderingen te zien",
"Add top level bookmarks to menu" => "Voeg hoofdniveau favorieten toe aan het menu",
"replace window" => "Vervangen venster",
"User_versions_for" => "Gebruiker_versies_voor",
"This page is being edited by" => "Deze pagina wordt momenteel bewerkt door",
"Proceed at your own peril" => "Ga verder op eigen risico",
"Insert Row" => "Voeg Rijd in",
"Insert Column" => "Voeg Kolom in",
"Remove Row" => "Verwijder Rij",
"Remove Column" => "Verwijder Kolom",
"Merge Cells" => "Smelt Cellen samen",
"Restore Cells" => "Herstel Cellen",
"Copy Calculation" => "Kopieer Berekening",
"Format Cell" => "Formatteer Cel",
"Before" => "Voor",
"After" => "Na",
"expires:" => "verloopt:",
"Banner stats" => "Advertentie stats",
"Create new banner" => "Nieuwe advertentie aanmaken",
"Banner Information" => "Advertentie Informatie",
"Click ratio" => "Klikfrequentie",
"Weekdays" => "Weekdagen",
"mon" => "ma",
"tue" => "di",
"wed" => "wo",
"thu" => "do",
"fri" => "vr",
"sat" => "za",
"sun" => "zo",
"Banner raw data" => "Advertentie ruwe gegevens",
"Cached" => "In buffer gebracht",
"This is a cached version of the page." => "Deze paginaversie komt uit de buffer.",
"Click here to view the Google cache of the page instead." => "klik hier om de Google buffer van deze pagina te zien.",
"Edit Items" => "Werk items bij",
"List Charts" => "Opsommen rangschikkingen",
"Last Chart" => "Laatste rangschikking",
"Previous Chart" => "Vorige rangschikking",
"Chart created" => "Rangschikking aangemaakt",
"Next Chart" => "Volgende rangschikking",
"Permanency" => "Permanentie",
"chg" => "wijz",
"Avg" => "Gem",
"info/vote" => "info/stem",
"Next chart will be generated on" => "Volgende rangschikking wordt aangemaakt op",
"View or vote items not listed in the chart" => "Bekijk of stem op items die in de rangschikking opgesomd staan",
"Select something to vote on" => "Selecteer iets om op te stemmen",
"Item information" => "Item informatie",
"Dif" => "Versch",
"Best Position" => "Beste Positie",
"Vote this item" => "Stem voor dit item",
"Highest" => "Hoogste",
"Answers" => "Antwoorden",
"Q" => "V",
"Add Suggestion" => "Voeg suggestie toe",
"Forum List" => "Forumlijst",
"Edit Forum" => "Forum bewerken",
"Summary" => "Samenvatting",
"Moderator Actions" => "Moderator acties",
"Move Selected Topics" => "Verplaats geselecteerde onderwerpen",
"Unlock Selected Topics" => "Ontgrendel geselecteerde onderwerpen",
"Lock Selected Topics" => "Vergrendel geselecteerde onderwerpen",
"Delete Selected Topics" => "Verwijder geselecteerde onderwerpen",
"Merge" => "Voeg samen",
"Merge Selected Topics" => "Voeg geselecteerde onderwerpen samen",
"Reported Messages:" => "Gemelde berichten:",
"Queued Messages:" => "Berichten in de wachtrij geplaatst:",
"Merge into topic" => "Voeg samen in het onderwerp",
"Announce" => "Aankondigen",
"Hot" => "Belangrijk",
"No topics yet" => "Nog geen onderwerpen",
"Jump to forum" => "Spring naar forum",
"Last hour" => "Laatste uur",
"Last 24 hours" => "Laatste 24 uren",
"Last 48 hours" => "Laatste 48 uren",
"prev topic" => "vorig onderwerp",
"next topic" => "volgend onderwerp",
"Show posts" => "Toon bijdragen",
"Insert New Item" => "Nieuwe items toevoegen",
"Edit Fields" => "Bewerk velden",
"View inserted item" => "Bekijk ingevoerd item",
"Insert new item" => "Nieuwe items toevoegen",
"Tracker Item:" => "Tracker item:",
"View Item" => "Item bekijken",
"Add a Comment" => "Een opmerking toevoegen",
"Items list" => "Items lijst",
"Special Operations" => "Speciale Handelingen",
"close" => "sluit",
"Show All" => "Toon Alles",
"Clip" => "clip",
"Back To Mailbox" => "terug naar postvak",
"Full Headers" => "volledige hoofdingen",
"Normal Headers" => "normale hoofdingen",
"Reply To All" => "allen beantwoorden",
"Forward" => "doorsturen",
"Select from address book" => "uit adresboek selecteren",
"Use HTML mail" => "HTML-mail gebruiken",
"The following addresses are not in your address book" => "De volgende adressen bevinden zich niet in uw adresboek",
"Add Contacts" => "Contacten toevoegen",
"Attachment 1" => "Bijlage 1",
"Attachment 2" => "Bijlage 2",
"Attachment 3" => "Bijlage 3",
"Address book" => "Adresboek",
"page id" => "pagina id",
"Show/Hide Left Menus" => "Toon/Verberg Linkse Menu\\'s",
"Show/Hide Right Menus" => "Toon/Verberg Rechtse Menu\\'s",
"Number of voices" => "Aantal stemmen",
"Categories:" => "Categorie&eacute;:",
"Save Minor Edit" => "minder belangrijk",
"Compose Message" => "Stel Bericht Op",
"Enable/disable Tiki features here, but configure them elsewhere" => "Schakel Tiki kenmerken hier in/uit, maar configureer deze elders",
"General preferences and settings" => "Algemene instellingen",
"User registration, login and authentication" => "Gebruikersregistratie, -aanmelding en -authenticatie",
"Wiki settings" => "Wiki-instellingen",
"Wiki Attachments" => "Wiki Bijlagen",
"Article/CMS settings" => "Artikel/CMS instellingen",
"Poll comments settings" => "Instellingen voor opmerkingen bij opiniepeilingen",
"Configuration options for all blogs on your site" => "Configuratie opties voor alle blogs van uw site",
"Forums settings" => "Foruminstellingen",
"FAQ comments settings" => "Instellingen FAQ commentaar",
"Trackers settings" => "Instellingen Trackers",
"RSS feeds" => "RSS-invoer",
"RSS settings" => "Instellingen RSS-invoerstromen",
"Directory settings" => "Instellingen Directory",
"Maps configuration" => "Kaarten configuratie",
"Meta Tags settings" => "Instellingen Meta Tags",
"Search settings" => "Zoek-instellingen",
"Score settings" => "Score instellingen",
"Community settings" => "Gemeenschap instellingen",
"Calendar settings" => "Kalender instellingen",
"Help on \$admintitle Config" => "Hulp voor \$admintitle Config",
"Category can`t be parent of itself" => "Categorie kan geen ouder zijn van zichzelf",
"No chart indicated" => "Geen rangschikking opgegeven",
"Upload failed" => "Aanlevering mislukt",
"You have to provide a hotword and a URL" => "U moet een hotword en een URL aanleveren",
"Detected, Version:" => "Gevonden, Versie:",
"Not detected." => "Niet vastgesteld.",
"Your admin password has been changed" => "Uw beheerder wachtwoord is gewijzigd",
"All Fields except gdaltindex must be filled" => "Alle velden behalve gdaltindex moeten worden ingevuld",
"No valid gdaltindex executable" => "Geen geldig gdaltindex programma",
"Tag already exists" => "Label bestaat reeds",
"Tag not found" => "Label niet gevonden",
"Repository name can't be an empty" => "Naam Bewaarplaats kan niet leeg zijn",
"Requested action is not supported on repository" => "De gevraagde actie is niet geldig voor de bewaarplaats",
"No repository" => "Geen bewaarplaats",
"Search is mandatory field" => "Zoek is een verplicht veld",
"File not found " => "Bestand niet gevonden ",
"Requested action in not supported on repository" => "Gevraagde actie wordt niet ondersteund foor bewaarplaats",
"Non-existent link" => "Niet-bestaande koppeling",
"Mail-in account %s incorrect" => "Mail-in account %s niet correct",
"Mail-in account %s saved" => "Mail-in account %s opgeslagen",
"Frequency should be a positive integer!" => "Frekwentie moet een positief geheel getal zijn!",
"Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts worden elke %s minuten gecontroleerd",
"Automatic Mail-in accounts checking disabled" => "Automatische Mail-in accounts controle uitgeschakeld",
"No menu indicated" => "Geen menu opgegeven",
"No newsletter indicated" => "Geen nieuwsbrief opgegeven",
"No poll indicated" => "Geen opiniepeiling opgegeven",
"unsafe" => "onveildig",
"register_globals should be off by default. See the php manual for details." => "register_globals zou standaard uit moeten staan. Zie de php-handleiding voor meer details.",
"safe" => "veilig",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid zou standaard uit moeten staan. Zie de php-handleiding voor meer details.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir ligth waarschijnlijk binnen uw Tikiwiki folder. Er bestaat de kans dat iemand een bestand naar deze folder kan aanleveren en via een web browser het bestand kan bekijken",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "kan niet controleren of upload_tmp_dir bereikbaar is via uw web browser. Om zeker te zijn dient u uw web server configuratie na te kijken.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "de xbithack optie aanschakelen is niet veilig. Afhankelijk van uw web server en tiki instellingen zou het kunnen dat een aanvaller bestanden naar een bestandgalerij kan aanleveren en deze kan uitvoeren",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Het pad om bestanden in de bestandgalerij in op te slaan zou buiten de tiki root folder moeten liggen",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Het pad om bestanden in de afbeeldinggalerij in op te slaan zou buiten de tiki root folder moeten liggen",
"File is not readable. Unable to check." => "Bestand is niet leesbaar. Kan niet controleren.",
"This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "Dit is geen Tikiwiki-bestand. Controleer of dit bestand buiten uw weten werd aangeleverd en/of het gevaarlijk is.",
"This is a modified File. Cannot check version. Check if it is dangerous." => "Dit bestand werd aangepast. Kan de versie niet bepalen. Controleer of het bestand gevaarlijk is.",
"This file is from another Tikiwiki version: " => "Dit bestand is van een andere Tikiwiki versie: ",
"You have to provide a word" => "U hoeft geen woord in te vullen",
"Permission denied you cannot view this page" => "Geen toestemming om deze pagina te bekijken.",
"Permission denied you cannot edit this page" => "Geen toestemming om deze pagina te bewerken",
"You must specify a page name, it will be created if it doesn't exist." => "U dient een paginanaam te vermelden, indien deze nog niet bestaat zal ze aangemaakt worden",
"page not added (Exists)" => "pagina niet toegevoegd (bestaat reeds)",
"No survey indicated" => "Geen opinieonderzoek opgegeven",
"You don't have permission to use this feature" => "U heeft geen toestemming om dit onderdeel te gebruiken",
"No Errors detected" => "Geen Fouten gevonden",
"No tracker indicated" => "Geen tracker opgegeven",
"Group already exists" => "Groep bestaat reeds",
"User doesn't exist" => "Gebruiker bestaat niet",
"No records were found. Check the file please!" => "Geen records gevonden. Controleer het bestand aub!",
"User login is required" => "Gebruikernaam is verplicht",
"Password is required" => "Wachtwoord is verplicht",
"Email is required" => "E-mail is verplicht",
"User is duplicated" => "Gebruiker is gekopieerd",
"Created account %s <%s>" => "Account %s <%s> aangemaakt",
"Assigned %s in group %s" => "%s toegewezen aan group %s",
"User %s already exists" => "Gebruiker %s bestaat reeds",
"New %s created with %s %s." => "Nieuwe %s aangemaakt met %s %s.",
"Impossible to create new %s with %s %s." => "Niet mogelijk om nieuwe %s met %s %s aan te maken.",
"%s %s successfully deleted." => "%s %s succesvol verwijderd.",
"%s %s removed from %s %s." => "%s %s verwijderd van %s %s.",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> verwijderd met succes.",
"%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> toegewezen aan %s <b>%s</b>.",
"%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> verwijderd van %s <b>%s</b>.",
"group <b>%s</b> set as the default group of user <b>%s</b>." => "groep <b>%s</b> als standaard groep gezet voor gebruiker <b>%s</b>.",
"%s changed from %s to %s" => "%s gewijzigd van %s naar %s",
"Impossible to change %s from %s to %s" => "Niet mogelijk om %s te wijzigen van %s naar %s",
"%s modified successfully." => "%s succesvol gewijzigd.",
"password" => "wachtwoord",
"%s modification failed." => "%s wijziging gefaald.",
"rss feed disabled" => "rss invoer uitgeschakeld",
"Tiki RSS feed for articles" => "Tiki RSS-invoer voor artikelen",
"Last articles." => "Laatste artikelen.",
"Unknown group" => "Onbekende groep",
"Group doesn't exist" => "Groep bestaat niet",
"You have to indicate a group" => "U moet een groep aanduiden",
"This group is invalid" => "Deze groep is ongeldig",
"Permission denied you cannot view backlinks for this page" => "Geen toestemming om terugkoppelingen te bekijken voor deze pagina",
"The page cannot be found" => "De pagina kan niet gevonden worden",
"Image Galleries Admin Panel" => "Afbeeldinggalerijen Admin Panel",
"Could not read image %s." => "Kan afbeelding %s niet lezen.",
"Image %s upload failed." => "Aanlevering van afbeelding %s mislukt.",
"Image %s uploaded successfully." => "Afbeelding %s met success aangeleverd.",
"Image %s removed from Batch directory." => "Afbeelding %s verwijderd uit Batch folder.",
"Impossible to remove image %s from Batch directory." => "Onmogelijk om afbeelding %s te verwijderen uit Batch folder.",
"Permission denied you cannot use the batch directory loading" => "Toegang geweigerd, u kan de batch folder aanlevering functie niet gebruiken",
"Incorrect directory chosen for batch upload of images." => "Incorrectie folder voor batch aanlevering van afbeeldingen gekozen.",
"Please setup that dir on " => "Gelieve deze folder te configureren op ",
"Please contact the website administrator." => "Gelieve de site beheerder te contacteren.",
"Invalid directory name" => "Ongeldige foldernaam",
"You can't post in any blog maybe you have to create a blog first" => "U kan aan geen enkel blog bijdragen leveren, misschien moet u eerst een blog aanmaken",
"Permission denied you cannot post" => "Geen toestemming om bijdragen toe te voegen",
"Permission denied you cannot edit this post" => "Geen toestemming om deze bijdrage te bewerken",
"Top visited blogs" => "Meest bezochte blogs",
"Last posts" => "Laatste bijdragenn",
"Top active blogs" => "Meest actieve blogs",
"Tiki RSS feed for blog: " => "Tiki RSS-invoer voor blog: ",
"No blogId specified" => "Geen blogId opgegeven",
"Tiki RSS feed for weblogs" => "Tiki RSS-invoer voor blogs",
"Last posts to weblogs." => "Laatste bijdrage tot  blogs.",
"Permission denied you cannot access this gallery" => "Geen toestemming om deze galerij te bekijken",
"No gallery indicated" => "Geen galerij aangegeven",
"Permission denied you can not view this section" => "Geen permissie om deze sectie te bekijken",
"Permission denied you cannot remove images from this gallery" => "Geen toestemming om afbeeldingen te verwijderen uit deze galerij",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Geen permissie om de voorbeeldplaatjes in deze galerij te hercre&euml;n",
"Permission denied you cannot rotate images in this gallery" => "Geen permissien om afbeeldigen in deze galerij te verdraaien",
"No image indicated" => "Geen afbeelding opgegeven",
"Permission denied you cannot move images from this gallery" => "Geen toestemming om afbeeldingen uit deze galerij te verplaatsen",
"Permission denied you cannot view the calendar" => "Toegang tot de kalender geweigerd",
"event without name" => "gebeurtenis zonder naam",
"Access Denied" => "Toegang geweigerd",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "Eerste day van de week: Zondag (haar ID is 0)!",
"No category indicated" => "Geen categorie aangegeven",
"Permission denied; you cannot assign permissions for this category" => "Toestemming geweigerd; u kan geen permissies toekennen voor deze categorie",
"You can not use the same password again" => "U kan hetzelfde wachtwoord niet opnieuw gebruiken",
"Top authors" => "Top auteurs",
"Account validated successfully." => "Account met success gevalideerd.",
"ERROR: you must include a subject or a message at least" => "FOUT: u moet op zijn minst een onderwerp of bericht insluiten",
"You need to change chmod 'whelp' manually to 777" => "U moet handmatig een chmod 'whelp' 777 doen",
"This feature has been disabled" => "Dit onderdeel is niet actief",
"Tiki RSS feed for directory sites" => "Tiki RSS-invoer voor koppelingenlijst sites",
"Last sites." => "Laatste sites.",
"Must enter a name to add a site. " => "Geef een naam op om een site toe te voegen. ",
"Must enter a url to add a site. " => "Geef een URL op om een site toe te voegen. ",
"URL already added to the directory. Duplicate site? " => "URL bestaat reeds in de koppelingenlijst. Gaat het om een duplicaat? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Kan URL niet benaderen: ofwel gaat het om een verkeerde URL ofwel is de site off-line and kan deze niet aan de koppelingenlijst worden toegevoegd. ",
"Must select a category. " => "Geef een categorie op. ",
"Must enter a name to add a site" => "U moet een naam invoeren om een site toe te voegen",
"Must enter a url to add a site" => "U moet een URL invoeren om eeen site toe te voegen",
"URL already added to the directory. Duplicate site?" => "URL reeds in koppelingenlijst aanwezig. Identieke site?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Kan URL niet benaderen: ofwel gaat het om een verkeerde URL ofwel is de site off-line and kan deze niet aan de koppelingenlijst worden toegevoegd. ",
"Must select a category" => "U moet een categorie selecteren",
"No site indicated" => "Geen site opgegeven",
"No parent specified" => "Geen ouder opgegeven",
"Last sites of directory \".\$rc[\"name\"].\" ." => "Laatste sites van koppelingenlijst \".\$rc[\"name\"].\" .",
"Article not found" => "Artikel niet gevonden",
"Permission denied you cannot edit this article" => "Geen toestemming om deze pagina te bewerken",
"The language can't be changed as its set of translations has already this language" => "De taal kan niet worden aangepast omdat er reeds bestaande vertalingen aanwezig zijn voor deze taal",
"You do not have permissions to edit banners" => "U heeft geen toestemming om advertenties te bewerken",
"Banner not found" => "Advertentie niet gevonden",
"You do not have permission to edit this banner" => "U heeft geen toestemming om deze advertentie te bewerken",
"Permission denied you cannot create or edit blogs" => "Geen toestemming om blogs aan te maken of te bewerken",
"Permission denied you cannot edit this blog" => "Geen toestemming om dit blog te bewerken",
"You do not have permission to write the style sheet" => "U heeft geen permissie om naar de style sheet te schrijven",
"Invalid request to edit an image" => "Ongeldig verzoek om een afbeelding te bewerken",
"Permission denied you cannot edit images" => "Geen toestemming om afbeeldingen te bewerken",
"Permission denied you can edit images but not in this gallery" => "Geen toestemming, u kan afbeeldingen bewerken maar niet in deze galerij",
"Failed to edit the image" => "Afbeelding kon niet bewerkt worden",
"Permission denied to use this feature" => "Geen toestemming om dit onderdeel te gebruiken",
"Shortname must be 2 Characters" => "Korte naam moet 2 karakters zijn",
"You must provide a longname" => "U moet een lange naam invoeren",
"Language created" => "Taal aangemaakt",
"No content id indicated" => "Geen inhoud-id opgegeven",
"No question indicated" => "Geen vraag opgegeven",
"No quiz indicated" => "Geen quiz opgegeven",
"No structure indicated" => "Geen structuur opgegeven",
"Invalid structure_id or page_ref_id" => "Ongeldig structuur_id of pagina_ref_id",
"Permission denied you cannot send submissions" => "Geen toestemming om bijdragen te verzenden",
"Permission denied you cannot edit submissions" => "Geen toestemming om bijdragen te bewerken",
"You have to create a topic first" => "U moet eerst een onderwerp aanmaken",
"You do not have permission to do that" => "U heeft geen permissie om dat te doen",
"You do not have permission to read the template" => "U heeft geen toestemming om de sjabloon te lezen",
"No topic id specified" => "Geen onderwerp id opgegeven",
"Invalid topic id specified" => "Ongeldig onderwerp id opgegeven",
"No object indicated" => "Geen object aangegeven",
"No type indicated" => "Geen type aangegeven",
"page imported" => "pagina geimporteerd",
"created from import" => "aangemaakt via import",
"Can't import remote HTML page" => "Kan verre HTML pagina niet importeren",
"The SandBox is disabled" => "De zandbak is niet actief",
"Cannot edit page because it is locked" => "Pagina is vergrendeld en kan niet bewerkt worden",
"No questions group indicated" => "Geen vraaggroup aangeduid",
"Permission denied you cannot edit this file" => "Geen permissie om dit bestand te bewerken",
"Permission denied you cannot remove files from this gallery" => "Geen toestemming om bestanden te verwijderen uit deze galerij",
"Top visited file galleries" => "Meest bezochte bestandgalerijen",
"Most downloaded files" => "Meest afgehaalde bestanden",
"Last files" => "Laatste bestanden",
"Tiki RSS feed for file galleries" => "Tiki RSS-invoer voor bestandgalerijen",
"Last files uploaded to the file galleries." => "Laatste bestanden aangeleverd aan de bestandgalerijen.",
"No galleryId specified" => "Geen galerijId opgegeven",
"Tiki RSS feed for the file gallery: " => "Tiki RSS-invoer voor de bestandgalerij: ",
"No forum indicated" => "Geen forum opgegeven",
"Forum posts" => "Forumbijdragen",
"No forumId specified" => "Geen forumId opgegeven",
"Tiki RSS feed for forum: " => "Tiki RSS-invoer voor forum: ",
"Tiki RSS feed for forums" => "Tiki RSS-invoer voor forums",
"Last topics in forums." => "Laatste onderwerpen in forums.",
"Accepted friendship request from %s" => "Verzoek tot vriendschap aanvaard van %s",
"Refused friendship request from %s" => "Verzoek tot vriendschap geweigerd van %s",
"Broke friendship with %s" => "Vriendschap met %s verbroken",
"I have broken our friendship!" => "Ik heb onze vriendschap verbroken!",
"You must be logged in to use this feature" => "U moet zich eerst aanmelden om dit onderdeel te kunnen gebruiken",
"Friendship request sent to %s" => "Vriendschapsaanvraag verzonden naar %s",
"You're already friend of %s" => "U bent reeds een vriend van %s",
"I have accepted your friendship request!" => "Ik heb uw verzoek tot vriendschap aanvaard!",
"No process indicated" => "Geen process opgegeven",
"Activity name already exists" => "Naam activiteit bestaat reeds",
"indicates if the process is active. Invalid processes cant be active" => "geeft aan of het proces actief is. Ongeldige processen kunnen niet actief zijn",
"No instance indicated" => "Geen incarnatie opgegeven",
"No activity indicated" => "Geen activiteit opgegeven",
"The process name already exists" => "De procesnaam bestaat reeds",
"Process already exists" => "Proces bestaat reeds",
"You cant execute this activity" => "U mag deze activiteit niet uitvoeren",
"You couldn't abort a instance" => "U was niet in staat om een incarnatie af te breken",
"You couldn't exception a instance" => "U was niet in staat om een incarnatie uit te zonderen",
"No user indicated" => "Geen gebruiker opgegeven",
"No title indicated" => "Geen titel aangegeven",
"No comment indicated" => "Geen commentaar aangegeven",
"No date indicated" => "Geen datum aangegeven",
"No item indicated" => "Geen item opgegeven",
"first uploaded image" => "eerste aangeleverde afbeelding",
"last uploaded image" => "laatst aangeleverde afbeelding",
"first image" => "eerste afbeelding",
"last image" => "laatste afbeelding",
"random image" => "willekeurige afbeelding",
"Permission denied you cannot create galleries and so you cant edit them" => "Geen toestemming om galerijen te maken of te bewerken",
"Permission denied you cannot edit this gallery" => "Geen toestemming om deze galerij te bewerken",
"Permission denied you cannot remove this gallery" => "Geen toestemming om deze galerij te verwijderen",
"Permission denied you cannot make the map of this gallery" => "Toegang geweigerd, u kan geen kaart maken van deze gallerij",
"Top images" => "Top afbeeldingen",
"Last images" => "Laatste afbeeldingen",
"No valid renderer found. GD or PDFLib required." => "Geen geldig opmaakprogramme gevonden. GD of PDFLib zijn vereist.",
"You must select a renderer." => "U dient een opmaakprogramma te selecteren.",
"Invalid Series for current graphic." => "Ongeldige Reeksen voor huidige grafiek.",
"Tiki RSS feed for image galleries" => "Tiki RSS-invoer voor beeldgalerijen",
"Last images uploaded to the image galleries." => "Laatste afbeeldingen aangeleverd aan de beeldgalerijen.",
"Tiki RSS feed for the image gallery: " => "Tiki RSS-invoer voor de beeldgalerij: ",
"overwriting old page" => "overschrijft oude pagina",
"updated from structured text import" => "bijgewerkt via gestructureerde tekstimport",
"page created" => "pagina aangemaakt",
"created from structured text import" => "aangemaakt via gestructureerde tekstimport",
"No name indicated for wiki page" => "Geen naam opgegeven voor wiki pagina",
"No repository given" => "Geen bewaarplaats opgegeven",
"Permission denied you cannot view pages like this page" => "Geen toestemming om pagina's zoals deze te bekijken",
"Permission denied you cannot remove articles" => "Geen toestemming om artikelen te verwijderen",
"Permission denied you cannot remove banners" => "Geen toestemming om advertenties te verwijderen",
"Permission denied you cannot remove this blog" => "Geen toestemming om dit blog te verwijderen",
"Non-existent gallery" => "Non-bestaande galerij",
"Permission denied you can upload files but not to this file gallery" => "Toestemming geweigerd, u kan bestanden aanleveren maar niet naar deze galerij",
"Could not upload the file" => "Kan bestand niet aanleveren",
"Could not find the file requested" => "Kan gevraagd bestand niet vinden",
"File update was successful" => "Bestand met succes bijgewerkt",
"Permission denied you can't upload files so you can't edit them" => "Geen permissie om bestanden aan te leveren of te bewerken",
"The game file must have .swf or .dcr extension" => "Het spelbestand moet de extensie .swf of .dcr hebben",
"The thumbnail name must be" => "De naam van het voorbeeldplaatje moet zijn",
"Please supply both files" => "Lever beide bestanden aan aub",
"You cannot admin blogs" => "U kan geen blogs beheren",
"Permission denied you cannot remove submissions" => "Geen toestemming om bijdragen te verwijderen",
"Permission denied you cannot approve submissions" => "Geen toestemming om bijdragen goed te keuren",
"You have to enable cookies to be able to login to this site" => "U moet cookies inschakelen om zich te kunnen aanmelden op deze site",
"Tiki mail-in auto-reply" => "Tiki mail-in auto-antwoord",
"Sorry, you can't use this feature." => "Sorry, u kan dit kenmerk niet gebruiken.",
"edit" => "bewerken",
"You do not have permissions to view the maps" => "U heeft geen permissie om de landkaarten te bekijken",
"Maps feature is not correctly setup : Maps path is missing." => "Landkaarten onderdeel is niet correct opgezet : Landkaarten pad ontbreekt.",
"mapfile name incorrect" => "landkaartbestandnaam is niet correct",
"This mapfile already exists" => "Dit landkaartbestand bestaat reeds",
"You do not have permission to write to the mapfile" => "U heeft geen permissie om naar het landkaartbestand te schrijven",
"You do not have permission to delete the mapfile" => "U heeft geen permissie om het landkaartbestand te verwijderen",
"I could not make a copy" => "Ik kon geen kopie maken",
"You do not have permission to read the mapfile" => "U heeft geen permissie om het landkaartbestand te lezen",
"You dont have permission to do that" => "U heeft geen permissie om dat te doen",
"Tiki RSS feed for maps" => "Tiki RSS-invoer voor landkaarten",
"List of maps available." => "Liijst van beschikbare landkaarten.",
"You do not have permissions to view the layers" => "U heeft geen permissie om de lagen te bekijken",
"You do not have permissions to delete a file" => "U heeft geen permissie om het bestand te verwijderen",
"File not found" => "Bestand niet gevonden",
"You do not have permissions to create a directory" => "U heeft geen permissie om een folder aan te maken",
"The Directory is not empty" => "De folder is niet leeg",
"You do not have permissions to delete a directory" => "U heeft geen permissie om een folder te verwijderen",
"You do not have permissions to create an index file" => "U heeft geen permissie om een indexbestand aan te maken",
"Invalid file name" => "Ongeldige bestandnaam",
"Invalid files to index" => "Ongeldige bestanden om te indexeren",
"I do not know where is gdaltindex. Set correctly the Map feature" => "Ik weet niet waar gdaltindex is. Stel het landkaarten onderdeel juist in",
"I could not create the index file" => "Ik heb geen indexbestand kunnen aanmaken",
"Must be logged to use this feature" => "U moet aangemeld zijn om dit onderdeel te kunnnen gebruiken",
"Welcome at Hawiki" => "Welkom op Hawiki",
"This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "Deze Tikiwiki site kan via een hele rits mobiele toestellen benaderd worden, e.g. WAP telefoons, PDA's, i-mode toestellen en vele andere.",
"You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "U kan deze site via uw mobiel toestel benaderen door uw mobiele browser te richten naar de volgende URL op deze site:",
"About" => "Over",
"You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "U dient setup.sh uit te voeren :<br />./setup.sh \$APACHEUSER all<br />Meest voorkomende Apache gebruikers zijn www-data, apache of nobody",
"Your PHP installation does not have zlib enabled." => "Uw PHP installatie heeft zlib niet geactiveerd.",
"You must log in to use this feature" => "U moet zich aanmelden om dit onderdeel te gebruiken",
"You do not have permission to view other users data" => "U heeft geen toestemming om permissies van andere gebruikers te bekijken",
"You must be logged in to subscribe to newsletters" => "U moet aangemeld zijn om u op nieuwsbrieven te kunnen abonneren",
"No server indicated" => "Geen server opgegeven",
"Cannot connect to" => "Kan niet connecteren aan",
"Missing information to read news (server,port,username,password,group) required" => "Informatie ontbreekt om nieuws te kunnen lezen (server, poort, gebruikernaam, wachtwoord, groep)",
"Cannot get messages" => "Kan berichten niet ontvangen",
"No note indicated" => "Geen notitie opgegeven",
"merged note:" => "samengevoegde notitie:",
"File is too big" => "Bestand is te groot",
"created from notepad" => "aangemaakt door het kladblok",
"Page already exists" => "Pagina bestaat reeds",
"Not enough information to display this page" => "Niet genoeg informatie om deze pagina te tonen",
"Permission denied you cannot browse this page history" => "Geen toestemming om in de geschiedenis van deze pagina te bladeren",
"No article indicated" => "Geen artikel opgegeven",
"Article is not published yet" => "Artikel is nog niet gepubliceerd",
"No post indicated" => "Geen bijdrage opgegeven",
"Blog not found" => "Blog niet gevonden",
"No pages indicated" => "Geen pagina's opgegeven",
"Pageviews" => "Paginabezichtigingen",
"You don't have permission to edit quizzes." => "U heeft geen toestemming om quizzes bij te werken.",
"No result indicated" => "Geen resultaat opgegeven",
"The passwords don't match" => "De wachtwoorden komen niet overeen",
"Invalid or unknown username" => "Onjuiste on onbekende gebruikernaam",
"Unable to send mail. User has not configured email" => "Niet in staat om bericht te versturen. Gebruiker heeft email niet geconfigureerd",
"A password and your IP address reminder email has been sent " => "Een wachtwoord en IP adres herinnering werden verstuurd",
"to the registered email address for" => "naar het geregistreerde e-mail adres voor",
"last version" => "laatste versie",
"Permission denied you cannot remove versions from this page" => "Geen toestemming om versies van deze pagina te verwijderen",
"Permission denied you cannot rename this page" => "Toegang geweigerd, u kan deze pagina niet hernoemen",
"Cannot rename page because the new name begins with reserved prefix" => "Kan pagina niet hernoemen omdat de nieuwe naam met een verboden prefix start",
"Cannot rename page maybe new page already exists" => "Kan pagina niet hernoemen, nieuwe pagina bestaat misschien reeds",
"changed '%s' from '%s' to '%s'" => "wijzigde '%s' van '%s' naar '%s'",
"Non-existent version" => "Niet-bestaande versie",
"Permission denied you cannot rollback this page" => "Geen toestemming om deze pagina terug te plaatsen",
"Error Message" => "Fout Bericht",
"Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS-invoerstroom Foutbericht: \$errmsg",
"Post recommendation at" => "Voeg aanbeveling toe op",
"No newsletters available." => "Geen nieuwsbrieven beschikbaar.",
"successfully sent" => "met success verzonden",
"not sent" => "niet verzonden",
"Page must be defined inside a structure to use this feature" => "Pagina moet in een structuur gedefinieerd zijn om dit onderdeel te kunnen gebruiken",
"You cannot take this quiz twice" => "U kan deze quiz geen twee keer uitvoeren",
"Quiz time limit exceeded quiz cannot be computed" => "Quiz tijdslimiet overschreden, quiz kan niet worden berekend",
"You cannot take this survey twice" => "U kan geen twee keer aan dit opinieonderzoek deelnemen",
"Please create a category first" => "Maak eerst een categorie aan aub",
"No trackerId specified" => "Geen trackerId opgegeven",
"Tiki RSS feed for individual trackers: " => "Tiki RSS-invoerstroom voor individuele trackers: ",
"No permission to upload zipped file packages" => "Geen permissie op zip bestanden aan te leveren",
"Error processing zipped image package" => "Fout in de verwerking van de afbeeldingen in het zip bestand",
"No permission to upload zipped image packages" => "Geen permissie om zip verpakte afbeeldingen aan te leveren",
"The uploaded file ist not recognized as a image" => "Het aangeleverde bestand werd niet als afbeelding herkend",
"Permission denied you cannot upload images" => "Geen toestemming om afbeeldingen aan te leveren",
"Permission denied you can upload images but not to this gallery" => "Toestemming geweigerd, u kan afbeeldingen aanleveren maar niet naar deze galerij",
"Cannot get image from URL" => "Kan afbeelding niet ophalen van URL",
"That is not an image (or you have php < 4.0.5)" => "Dit is geen afbeelding (of u beschikt over php < 4.0.5)",
"Usage" => "Gebruik",
"No url indicated" => "Geen URL opgegeven",
"Unknown user" => "Onbekende gebruiker",
"You are not logged in and no user indicated" => "U bent niet aangemeld en er is geen gebruiker opgegeven",
"The user has chosen to make his information private" => "De gebruiker heeft ervoor gekozen om haar/zijn informatie priv&eacute; te houden",
"Email is set to %s" => "Email is gezet op %s",
"The passwords did not match" => "De wachtwoorden komen niet overeen",
"no" => "neen",
"was moved into trash" => "werd in de prullenmand geplaatst",
"trashed by" => "naar de prullenmand verwezen door",
"open / in process" => "open / in uitvoering",
"Rights by creator" => "Auteursrechten",
"END" => "EINDE",
"Task accepted by creator" => "Taak geaccepteerd door auteur",
"Task accepted by task user" => "Taak geaccepteerd door taakgebruiker",
"Task NOT accepted by creator" => "Taak NIET geaccepteerd door auteur",
"Task NOT accepted by task user" => "Taak NIET geaccepteerd door taakgebruiker",
"Sorry this task does not exist or you have no rights to view this task" => "Sorry deze taak bestaat niet of u heeft geen toegang om deze taak te bekijken",
"Task entries:" => "Taakopgaves:",
"Changes:" => "Veranderingen:",
"Info message" => "Infobericht",
"NEW Task" => "NIEUWE Taak",
"Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry u heeft geen permissie om taken naar andere gebruikers te sturen, of de gebruiker heeft geen permissie om taken te ontvangen!",
"Changes on Task" => "Veranderingen aan Taak",
"You received a new task" => "U heeft een nieuwe taak ontvangen",
"The priority is" => "De prioriteit is",
"very low" => "zeer laag",
"low" => "laag",
"high" => "hoog",
"very high" => "zeer hoog",
"You've to start your work at least on" => "U moet uw taak beginnen ten minste voor",
"You've to finish your work on" => "U moet uw taak beeindigen ten laatste op",
"Login and click the link below" => "Gelieve u aan te melden en op onderstaande koppeling te klikken",
"Please read the task and work on it!" => "Gelieve de taak te lezen en aan de taak te werken!",
"Sorry, there was an error while trying to write data into the database" => "Sorry, er is een fout opgetreden tijdens het schrijven van de gegevens naar de databank",
"Cannot upload this file not enough quota" => "Kan dit bestand niet aanleveren, ontoereikend quota",
"Non-existent user" => "Niet-bestaande gebruiker",
"No banner indicated" => "Geen advertentie opgegeven",
"No blog indicated" => "Geen blog opgegeven",
"Permission denied you cannot remove the post" => "Geen toestemming om de bijdrage te verwijderen",
"No cache information available" => "Geen bufferinformatie beschikbaar",
"No faq indicated" => "Geen FAQ opgegeven",
"You are not permitted to remove someone else\\'s post!" => "U heeft geen permissie om iemand anders bericht te verwijderen!",
"No thread indicated" => "Geen thread opgegeven",
"A SheetId is required." => "Een RekenbladId is vereist.",
"That tracker don't use extras." => "Deze tracker gebruikt geen extras.",
"No subject" => "Geen onderwerp",
"Top pages" => "Top pagina's",
"Last pages" => "Laatste pagina's",
"Tiki RSS feed for the wiki pages" => "Tiki RSS-invoer voor de wiki pagina\\'s",
"Last modifications to the Wiki." => "Laatste wijzigingen aan het Wiki.",
"###end###"=>"###end###");
?>
