/*
 throttled.h
 Copyright (C) 2006 quest and lws

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef THROTTLED_H
#define THROTTLED_H

#define THROTTLED_VERSION "0.4.6"

// Global includes
#include <stdio.h>
#ifdef __FreeBSD__
#include <sys/types.h>
#endif
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/resource.h>
#include <err.h>
#include <errno.h>
#include <sysexits.h>
#include <syslog.h>
#include <stdarg.h>
#include <list>
#include <string>

// Local includes
#include "packetqueue.h"

// Definitions for compiler variables
#define BUFSIZE 65535

// Define your application priority (-20 through 20)
// FreeBSD crashes hard at -20... make sure to watch out!
#if defined(__FreeBSD__)
#define NICEVALUE 0
#else
#define NICEVALUE -20
#endif

// Network masks to not throttle
//192.168.x.x)
#define LOCALNET	0xc0a80000
#define LOCALNETMASK	0xffff0000
//10.x.x.x
#define LOCALNET2	0x0a000000
#define LOCALNETMASK2	0xff000000

//Max transfer unit for network interface.
#define MTU 1500

// I don't know where to find this otherwise... the all packet header info
struct allheaders {
	struct ip	ipheader;
	struct tcphdr	tcpheader;
	struct udphdr	udpheader;
};


// Putting all our data in a struct so it can be easily located
typedef struct threadData threadData;
struct threadData
{
	int sockid, bindid;
	struct sockaddr_in sockport;
	struct in_addr addr;
	int bindport;
	int priority;
        	
	pthread_t receiveid;
        pthread_attr_t pattr;
        size_t ssize;
 
};

// Global variables
char keeplooping = true;
bool ackon = true, localignore = true, itunesfix = false; 
long maxrate = 0, rulenum = 0, speedchange = 1024;
long sentinstant = 0, maxsendratio = 0;

list<threadData*> threads;

pthread_t sendid;
pthread_attr_t sendpattr;
size_t sendssize;
pthread_mutex_t *sendMut;
pthread_mutex_t *queueMut;
pthread_cond_t *aQueueNotEmpty;

//For matching packets.

#define islocal( a )  (		(LOCALNETMASK & ((struct allheaders *)a)->ipheader.ip_dst.s_addr) == LOCALNET || \
							(LOCALNETMASK2 & ((struct allheaders *)a)->ipheader.ip_dst.s_addr) == LOCALNET2	)
#define isack( a, b )					(	( ((struct allheaders *)a)->ipheader.ip_p == IPPROTO_TCP )  && \
										( ((struct allheaders *)a)->tcpheader.th_flags & TH_ACK )	&&\
										( b <= 70 )	 )

// Defining our functions
void checkccargs(int argc, char** argv);
void makesocket(threadData *ourdata);
void makerecievethread(threadData *ourdata);
void jointhreads();
void deleterules();
void sigquitproc(int signal);
void sigspeedchangeproc(int signal);
void usage(char *appname);

// Functions for pthreads
void* receivepackets(void *dataarg);
void* sendpackets(void *dataarg);

#endif

