<!-- -->

    Source:  etoc.dtx (v1.09e)
    Author:  Jean-Francois Burnol
    Author:  Christine Roemer et al. (German tranlation)
    Info:    Completely customisable TOCs
    License: LPPL 1.3c
    Copyright (C) 2012-2021 Jean-Francois Burnol.
    Copyright (C) 2014-2015 Christine Roemer and collaborators
                  (translation into German of the documentation)
    <jfbu at free dot fr>    <Christine_Roemer at t-online dot de>

ABSTRACT
========

The etoc package gives to the user complete control on how the entries
of the table of contents should be constituted from the *name*,
*number*, and *page number* of each sectioning unit. This goes via the
definition of *line styles* for each sectioning level used in the
document. The package provides its own custom line styles. Simpler
ones are given as examples in the documentation. The simplest usage
will be to take advantage of the layout facilities of packages dealing
with list environments.

Regarding the *global toc display*, etoc provides pre-defined styles
based on a multi-column format, with, optionally, a ruled title or
framed contents.

The `\tableofcontents` command may be used arbitrarily many times and
it has a variant `\localtableofcontents` which prints tables of
contents 'local' to the current surrounding document unit. An
extension of the `\label/\ref` syntax allows to reproduce (with
another layout) a local table of contents defined somewhere else in
the document.

Via *depth tags*, one gets an even finer control for each table of
contents of which sectioning units it should, or not, display.

The formatting inherited (and possibly customized by other packages)
from the document class will be used when in compatibility mode.

The assignment of levels to the sectioning units can be changed at any
time, and etoc can thus be used in a quite general manner to create
custom ''lists of'', additionally to the tables of contents related to
the document sectioning units. No auxiliary file is used additionally
to the standard `.toc` file.

INSTALLATION
============

To extract the package (.sty) and driver (.tex) files from etoc.dtx,
execute `etex etoc.dtx`.

It is also possible to execute latex or pdflatex directly on etoc.dtx.

To produce etoc.pdf one can run pdflatex (thrice) directly on etoc.dtx or on
the file etoc.tex which was extracted from `etex etoc.dtx` step.

Options can be set in etoc.tex:

- scrdoc class options (paper size, font size, ...)
- with or without source code,
- with dvipdfmx or with latex+dvips or pdflatex.

Since release 1.08h pdflatex is the default in etoc.tex (prior it
was latex+dvipdfmx as it produces smaller PDFs) in order to allow
inclusion via the use of package `attachfile` of about 25 code
samples as file attachment annotations.

Installation:

    etoc.sty    -> TDS:tex/latex/etoc/etoc.sty
    etoc.dtx    -> TDS:source/latex/etoc/etoc.dtx
    etoc.pdf    -> TDS:doc/latex/etoc/etoc.pdf
    etoc-DE.pdf -> TDS:doc/latex/etoc/etoc-DE.pdf
    README.md   -> TDS:doc/latex/etoc/README.md

The other files may be discarded.

LICENSE
=======

This Work may be distributed and/or modified under the
conditions of the LaTeX Project Public License, in its
version 1.3c. This version of this license is in

> <http://www.latex-project.org/lppl/lppl-1-3c.txt>

and the latest version of this license is in

> <http://www.latex-project.org/lppl.txt>

and version 1.3 or later is part of all distributions of
LaTeX version 2005/12/01 or later.

The Authors of this Work are:

- Jean-Francois Burnol `<jfbu at free dot fr>` for the source code
  and English documentation, and
- Christine Roemer `<Christine_Roemer at t-online dot de>` and
  collaborators for the translation into German of the documentation.

This Work consists of the main source file etoc.dtx and the
derived files etoc.sty, etoc.tex, etoc-DE.tex,
etoc.pdf, etoc-DE.pdf, etoc.dvi, etoc-DE.dvi.

RECENT CHANGES
==============

v1.09e \[2021/09/23\]
---------------------

Needed (if etoc is used without hyperref) updates to
internal macros to prepare for the upcoming LaTeX November
2021 change to `\contentsline`.

Related updates to the user macro `\etoctoccontentsline`.

v1.09d \[2021/07/13\]
---------------------

Some minor synching with tableof 1.4c.

Add `\etockeeporiginaltableofcontents` to provide a work-around to a
compatibility issue with listings's `\lstlistoflistings`, which abuses
`\tableofcontents` for doing something unrelated to the actual contents.
Thanks to Denis Bitouzé for report.

Usage: `\usepackage{etoc}\etockeeporiginaltableofcontents`, then
however you must employ `\etoctableofcontents`, not `\tableofcontents`.

v1.09c \[2020/05/15\]
---------------------

Syncs with KOMA-script deprecation of `\iftocfeature`.

v1.09a, v1.09b \[2019/11/17\]
-----------------------------

Sync with `memoir v3.7i` which has a better location of the TOC
hyperref anchor. The `\etocaftertitlehook` can now freely be
used also with memoir class (formerly its usage in case of
memoir class was preempted by etoc itself). For more details
refer to the section "Compatibility with the memoir class".

v1.09 \[2019/03/09\]
--------------------

New features: `\etoclocaltop`, `\localtableofcontentswithrelativedepth`.
Thanks to Tony Roberts for feature request.

Note to hackers: internal control sequence `\Etoc@localtop` is gone.

etoc now requires e-TeX (`\numexpr`, `\unless`).

Note: the German version of the documentation was last updated
at the time of the v1.08d \[2015/04/09\] release.  Since then
all additions to it have been left in English language.
