The amsmath bundle for LaTeX
============================

Release 2022-06-01 pre-release 2

Overview
--------

The `amsmath` package is an extension package for LaTeX that provides
additional features to facilitate mathematical typesetting. It has been
developed by the American Mathematical Society (AMS) and released for general
use as a service to the mathematical community. A number of smaller
auxiliary packages are also distributed with the `amsmath` package.

Effective in 2016, maintenance of `amsmath` was transferred from AMS to
the LaTeX Project; as `amsmath` is considered a "required" package, this
centralizes control over the core LaTeX components.

Installation
------------

We no longer distribute installation instructions for the various TeX
implementations. All modern TeX systems include `amsmath` as-standard, and end
users should in general use the release versions supplied in this way.

Release distribution is carried out only through the CTAN archives.

Documentation
-------------

The primary documentation for `amsmath` is provided as `amsldoc.pdf`.

Additional documentation files include:

 - `diffs-m.txt`
 - `subeqn.pdf`
 - `technote.pdf`
 - `testmath.pdf`

which are included in the collection.  All of these can be accessed
easily with most distributions by entering `texdoc` *filename* at the
command line, or via [TeXdoc Online](https://texdoc.org).

Change logs
-----------

The file `changes.txt` lists recent changes in reverse chronological order.

The file `diffs-m.txt` contains information on development and changes
prior to 2000.

Reporting Bugs
--------------

If you wish to report a problem or bug in the `amsmath` bundle
please use the [Issue Tracker for LaTeX2e on
GitHub](https://github.com/latex3/latex2e/issues)
and follow the guidelines that pop up if you press the "New issue" button.

In particular, to check that you are really seeing a bug, please write
a short, self-contained document that shows the problem. This should
include the `latexbug` package, which will warn if your test file is
not suitable for one or the other reason. See the [CONTRIBUTING
guide](https://github.com/latex3/latex2e/blob/main/CONTRIBUTING.md)
for further details, or if you need to obtain the `latexbug` package.

If the bug turns out to be with third-party software then please
contact the developer, and not us!

License
-------

The contents of this bundle are distributed under the [LaTeX Project
Public License](https://www.latex-project.org/lppl/lppl-1-3c/),
version 1.3c or later.

-----

<p>Copyright (C) 2001-2004, 2007, 2008, 2010, 2011, 2013 American Mathematical Society. <br />
<p>Copyright (C) 2016-2022 The LaTeX Project and American Mathematical Society. <br />

