/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.mordant.internal.AnsiCodes;
import com.github.ajalt.mordant.internal.Chunk;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.TxtStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\b\u001a,\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0002\u001a\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0000\u001a&\u0010\u0017\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00180\rj\u0002`\u00190\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002\u001a\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002\u001a \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0011H\u0000\u001a \u0010!\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a \u0010\"\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"ANSI_RE", "Lkotlin/text/Regex;", "getANSI_RE", "()Lkotlin/text/Regex;", "LS", "", "NEL", "getAnsiColor", "Lkotlin/Pair;", "Lcom/github/ajalt/colormath/Color;", "", "i", "codes", "", "parseAnsi", "Lcom/github/ajalt/mordant/internal/Chunk;", "text", "", "defaultStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "parseText", "Lcom/github/ajalt/mordant/rendering/Lines;", "style", "splitLines", "Lcom/github/ajalt/mordant/rendering/Span;", "Lcom/github/ajalt/mordant/rendering/Line;", "words", "", "splitWords", "chunk", "updateStyle", "existingStyle", "ansi", "updateStyleWithCsi", "updateStyleWithOsc", "mordant"})
public final class ParsingKt {
    @NotNull
    private static final Regex ANSI_RE = new Regex("\u001b][^\u001b]*\u001b\\\\|\u001b(?:[@-Z\\\\-_]|\\[[0-?]*[ -/]*[@-~])");
    private static final char NEL = '\u0085';
    private static final char LS = '\u2028';

    @NotNull
    public static final Regex getANSI_RE() {
        return ANSI_RE;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Lines parseText(@NotNull String text, @NotNull TextStyle style) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(style, "style");
        List<Chunk> parseAnsi = ParsingKt.parseAnsi(text, style);
        Iterable $this$flatMap$iv = parseAnsi;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ParsingKt.splitWords(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List words2 = CollectionsKt.toList((List)destination$iv$iv);
        List<List<Span>> splitLines = ParsingKt.splitLines(words2);
        return new Lines(splitLines);
    }

    private static final List<Chunk> parseAnsi(String text, TextStyle defaultStyle) {
        List<MatchResult> commands = SequencesKt.toList(Regex.findAll$default(ANSI_RE, text, 0, 2, null));
        if (commands.isEmpty()) {
            return CollectionsKt.listOf(new Chunk(text, defaultStyle));
        }
        boolean bl = false;
        List parts = new ArrayList();
        int idxAfterLastCmd = 0;
        TextStyle style = defaultStyle;
        for (MatchResult command : commands) {
            if (command.getRange().getFirst() > idxAfterLastCmd) {
                Collection collection = parts;
                Object object = text;
                int n = command.getRange().getFirst();
                boolean bl2 = false;
                String string = object;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring(idxAfterLastCmd, n);
                Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = new Chunk(string2, style);
                n = 0;
                collection.add(object);
            }
            idxAfterLastCmd = command.getRange().getLast() + 1;
            style = ParsingKt.updateStyle(style, defaultStyle, command.getValue());
        }
        if (idxAfterLastCmd < text.length()) {
            Collection collection = parts;
            Object object = text;
            boolean bl3 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object2).substring(idxAfterLastCmd);
            Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.String).substring(startIndex)");
            object = new Chunk(string, style);
            bl3 = false;
            collection.add(object);
        }
        return parts;
    }

    private static final List<Chunk> splitWords(Chunk chunk) {
        int i;
        boolean bl = false;
        List chunks = new ArrayList();
        int start = 0;
        int chunkType = -1;
        String t = chunk.getText();
        for (i = 0; i < t.length(); ++i) {
            int type;
            char c = t.charAt(i);
            int n = c == '\r' ? 0 : (c == '\n' || c == '\t' || c == '\u0085' || c == '\u2028' ? 1 : (type = CharsKt.isWhitespace(c) ? 2 : 3));
            if (i == 0) {
                chunkType = type;
                continue;
            }
            if (type != 1 && chunkType == type) continue;
            Collection collection = chunks;
            Object object = t;
            boolean bl2 = false;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring(start, i);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = Chunk.copy$default(chunk, string2, null, 2, null);
            bl2 = false;
            collection.add(object);
            start = i;
            chunkType = type;
        }
        if (start != i) {
            Collection collection = chunks;
            Object object = t;
            boolean bl3 = false;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string.substring(start, i);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = Chunk.copy$default(chunk, string3, null, 2, null);
            bl3 = false;
            collection.add(object);
        }
        return chunks;
    }

    private static final List<List<Span>> splitLines(Iterable<Chunk> words2) {
        boolean bl = false;
        List lines = new ArrayList();
        boolean bl2 = false;
        List line = new ArrayList();
        for (Chunk word : words2) {
            if (StringsKt.endsWith$default(word.getText(), "\n", false, 2, null)) {
                Collection collection = lines;
                boolean bl3 = false;
                collection.add(line);
                boolean bl4 = false;
                line = new ArrayList();
                continue;
            }
            line.add(Span.Companion.word(word.getText(), word.getStyle()));
        }
        Collection collection = line;
        boolean bl5 = false;
        if (!collection.isEmpty()) {
            collection = lines;
            bl5 = false;
            collection.add(line);
        }
        return lines;
    }

    @NotNull
    public static final TextStyle updateStyle(@NotNull TextStyle existingStyle, @NotNull TextStyle defaultStyle, @NotNull String ansi) {
        Intrinsics.checkNotNullParameter(existingStyle, "existingStyle");
        Intrinsics.checkNotNullParameter(defaultStyle, "defaultStyle");
        Intrinsics.checkNotNullParameter(ansi, "ansi");
        if (StringsKt.startsWith$default(ansi, "\u001b]", false, 2, null)) {
            return ParsingKt.updateStyleWithOsc(ansi, existingStyle, defaultStyle);
        }
        if (StringsKt.startsWith$default(ansi, "\u001b[", false, 2, null)) {
            return ParsingKt.updateStyleWithCsi(ansi, existingStyle, defaultStyle);
        }
        return existingStyle;
    }

    private static final TextStyle updateStyleWithOsc(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        String string;
        String id;
        String string2;
        if (!StringsKt.startsWith$default(ansi, "\u001b]8", false, 2, null)) {
            return existingStyle;
        }
        String string3 = ansi;
        int n = 3;
        int n2 = ansi.length() - 2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        List params = StringsKt.split$default((CharSequence)string5, new String[]{";"}, false, 0, 6, null);
        if (params.isEmpty()) {
            return existingStyle;
        }
        Object t = CollectionsKt.last(params);
        n2 = 0;
        bl = false;
        String it = (String)t;
        boolean bl2 = false;
        String hyperlink = (String)(!StringsKt.isBlank(it) ? t : null);
        if (hyperlink == null) {
            string2 = defaultStyle.getHyperlinkId();
        } else {
            Object v3;
            block7: {
                Iterable iterable = params;
                bl = false;
                Iterable iterable2 = iterable;
                boolean bl3 = false;
                for (Object t2 : iterable2) {
                    String it2 = (String)t2;
                    boolean bl4 = false;
                    if (!StringsKt.startsWith$default(it2, "id=", false, 2, null)) continue;
                    v3 = t2;
                    break block7;
                }
                v3 = null;
            }
            String string6 = v3;
            string2 = id = string6 != null ? StringsKt.drop(string6, 3) : null;
        }
        if ((string = hyperlink) == null) {
            string = defaultStyle.getHyperlink();
        }
        return TextStyleKt.copy$default(existingStyle, null, null, string, id, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextStyle updateStyleWithCsi(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        void $this$mapNotNullTo$iv$iv;
        if (!StringsKt.endsWith$default(ansi, "m", false, 2, null)) {
            return existingStyle;
        }
        Iterable $this$mapNotNull$iv = StringsKt.split$default(ansi.subSequence(2, ansi.length() - 1), new String[]{";"}, false, 0, 6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer n;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            CharSequence charSequence = it;
            boolean bl3 = false;
            if ((charSequence.length() == 0 ? Integer.valueOf(0) : StringsKt.toIntOrNull(it)) == null) continue;
            n = n;
            boolean bl4 = false;
            boolean bl5 = false;
            Integer it$iv$iv = n;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List codes = (List)destination$iv$iv;
        if (codes.isEmpty()) {
            return defaultStyle;
        }
        Color color = existingStyle.getColor();
        Color bgColor = existingStyle.getBgColor();
        boolean bold = existingStyle.getBold();
        boolean italic = existingStyle.getItalic();
        boolean underline = existingStyle.getUnderline();
        boolean dim = existingStyle.getDim();
        boolean inverse = existingStyle.getInverse();
        boolean strikethrough = existingStyle.getStrikethrough();
        for (int i = 0; i <= CollectionsKt.getLastIndex(codes); ++i) {
            int n;
            int consumed;
            Pair<Color, Integer> pair2;
            int code = ((Number)codes.get(i)).intValue();
            if (code == 0) {
                color = existingStyle.getColor();
                bgColor = existingStyle.getBgColor();
                bold = existingStyle.getBold();
                italic = existingStyle.getItalic();
                underline = existingStyle.getUnderline();
                dim = existingStyle.getDim();
                inverse = existingStyle.getInverse();
                strikethrough = existingStyle.getStrikethrough();
                continue;
            }
            if (code == 22) {
                bold = defaultStyle.getBold();
                dim = defaultStyle.getDim();
                continue;
            }
            if (code == 23) {
                italic = defaultStyle.getItalic();
                continue;
            }
            if (code == 24) {
                underline = defaultStyle.getUnderline();
                continue;
            }
            if (code == 27) {
                inverse = defaultStyle.getInverse();
                continue;
            }
            if (code == 29) {
                strikethrough = defaultStyle.getStrikethrough();
                continue;
            }
            if (code == 39) {
                color = defaultStyle.getColor();
                continue;
            }
            if (code == 49) {
                bgColor = defaultStyle.getBgColor();
                continue;
            }
            if (AnsiCodes.INSTANCE.getFg16Range().contains(code) || AnsiCodes.INSTANCE.getFg16BrightRange().contains(code)) {
                color = new Ansi16(code);
                continue;
            }
            if (AnsiCodes.INSTANCE.getBg16Range().contains(code) || AnsiCodes.INSTANCE.getBg16BrightRange().contains(code)) {
                bgColor = new Ansi16(code - 10);
                continue;
            }
            if (code == 38) {
                void c;
                pair2 = ParsingKt.getAnsiColor(i + 1, codes);
                Color bl = pair2.component1();
                consumed = ((Number)pair2.component2()).intValue();
                if (c == null) break;
                color = c;
                i += consumed;
                continue;
            }
            if (code == 48) {
                pair2 = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = pair2.component1();
                consumed = ((Number)pair2.component2()).intValue();
                if (c == null) break;
                bgColor = c;
                i += consumed;
                continue;
            }
            if (code == 1) {
                bold = true;
                continue;
            }
            if (code == 3) {
                italic = true;
                continue;
            }
            if (code == 4) {
                underline = true;
                continue;
            }
            if (code == 2) {
                dim = true;
                continue;
            }
            if (code == 7) {
                inverse = true;
                continue;
            }
            if (code == 9) {
                strikethrough = true;
                continue;
            }
            if (code != 58) continue;
            if (i == CollectionsKt.getLastIndex(codes)) {
                n = 0;
            } else {
                Integer n2 = (Integer)CollectionsKt.getOrNull(codes, i + 1);
                int n3 = 5;
                if (n2 != null && n2 == n3) {
                    n = 1;
                } else {
                    Integer n4 = (Integer)CollectionsKt.getOrNull(codes, i + 1);
                    n3 = 2;
                    if (n4 == null || n4 != n3) break;
                    n = 3;
                }
            }
            i = i + n;
        }
        return new TxtStyle(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, existingStyle.getHyperlink(), existingStyle.getHyperlinkId());
    }

    private static final Pair<Color, Integer> getAnsiColor(int i, List<Integer> codes) {
        Pair<Object, Integer> pair2;
        switch (((Number)codes.get(i)).intValue()) {
            case 5: {
                int n;
                if (i + 1 > CollectionsKt.getLastIndex(codes) || 0 > (n = ((Number)codes.get(i + 1)).intValue()) || 255 < n) {
                    pair2 = TuplesKt.to(null, 0);
                    break;
                }
                pair2 = TuplesKt.to(new Ansi256(((Number)codes.get(i + 1)).intValue()), 2);
                break;
            }
            case 2: {
                int n;
                if (i + 3 > CollectionsKt.getLastIndex(codes) || 0 > (n = ((Number)codes.get(i + 1)).intValue()) || 255 < n || 0 > (n = ((Number)codes.get(i + 2)).intValue()) || 255 < n || 0 > (n = ((Number)codes.get(i + 3)).intValue()) || 255 < n) {
                    pair2 = TuplesKt.to(null, 0);
                    break;
                }
                pair2 = TuplesKt.to(new RGB(((Number)codes.get(i + 1)).intValue(), ((Number)codes.get(i + 2)).intValue(), ((Number)codes.get(i + 3)).intValue(), 0.0f, 8, null), 4);
                break;
            }
            default: {
                pair2 = TuplesKt.to(null, 0);
            }
        }
        return pair2;
    }
}

