#
# This is file `Makefile.make',
# generated with the docstrip utility.
#
# The original source files were:
#
# berenisadf.dtx  (with options: `make')
# -------------------------------------------------
# Copyright (C) 2010-2024 Clea F. Rees.
# 
# This work may be distributed and/or modified under the
# conditions of the LaTeX Project Public License, either version 1.3c
# of this license or (at your option) any later version.
# The latest version of this license is in
#   https://www.latex-project.org/lppl.txt
# and version 1.3c or later is part of all distributions of LaTeX
# version 2008-05-04 or later.
# 
# This work has the LPPL maintenance status `maintained'.
# 
# The Current Maintainer of this work is Clea F. Rees.
# 
# This file may only be distributed together with a copy of the package
# berenisadf. You may however distribute the package berenisadf without
# such generated files.
# 
# This work consists of all files listed in manifest.txt.
# -------------------------------------------------
SHELL=/bin/sh
PATH=/usr/local/bin:/usr/local/texlive/bin:/usr/bin

pls8yybd = ybdb8y.pl ybdbc8y.pl ybdbci8y.pl ybdbi8y.pl ybdr8y.pl ybdrc8y.pl ybdrci8y.pl ybdri8y.pl
pls8y0 = ybdb08y.pl ybdb0c8y.pl ybdb0ci8y.pl ybdb0i8y.pl ybdr08y.pl ybdr0c8y.pl ybdr0ci8y.pl ybdr0i8y.pl
pls8y1 = ybdb18y.pl ybdb1c8y.pl ybdb1ci8y.pl ybdb1i8y.pl ybdr18y.pl ybdr1c8y.pl ybdr1ci8y.pl ybdr1i8y.pl
pls8y2 = ybdb28y.pl ybdb2c8y.pl ybdb2ci8y.pl ybdb2i8y.pl ybdr28y.pl ybdr2c8y.pl ybdr2ci8y.pl ybdr2i8y.pl
pls8y2j = ybdb2cij8y.pl ybdb2cj8y.pl ybdb2ij8y.pl ybdb2j8y.pl ybdr2cij8y.pl ybdr2cj8y.pl ybdr2ij8y.pl ybdr2j8y.pl
pls8y2jw = ybdb2cijw8y.pl ybdb2cjw8y.pl ybdb2ijw8y.pl ybdb2jw8y.pl ybdr2cijw8y.pl ybdr2cjw8y.pl ybdr2ijw8y.pl ybdr2jw8y.pl
pls8y2w = ybdb2ciw8y.pl ybdb2cw8y.pl ybdb2iw8y.pl ybdb2w8y.pl ybdr2ciw8y.pl ybdr2cw8y.pl ybdr2iw8y.pl ybdr2w8y.pl
pls8yj = ybdbcij8y.pl ybdbcj8y.pl ybdbij8y.pl ybdbj8y.pl ybdrcij8y.pl ybdrcj8y.pl ybdrij8y.pl ybdrj8y.pl
pls8yjw = ybdbcijw8y.pl ybdbcjw8y.pl ybdbijw8y.pl ybdbjw8y.pl ybdrcijw8y.pl ybdrcjw8y.pl ybdrijw8y.pl ybdrjw8y.pl
pls8yw = ybdbciw8y.pl ybdbcw8y.pl ybdbiw8y.pl ybdbw8y.pl ybdrciw8y.pl ybdrcw8y.pl ybdriw8y.pl ybdrw8y.pl
pls8y := $(pls8y0) $(pls8y1) $(pls8y2) $(pls8y2j) $(pls8y2jw) $(pls8y2w) $(pls8yybd) $(pls8yw) $(pls8yj) $(pls8yjw)
pls8yr = ybdr08y.pl ybdr18y.pl ybdr28y.pl ybdr2j8y.pl ybdr2jw8y.pl ybdr2w8y.pl ybdr8y.pl ybdrj8y.pl ybdrjw8y.pl ybdrw8y.pl
pls8yri = ybdr0i8y.pl ybdr1i8y.pl ybdr2i8y.pl ybdr2ij8y.pl ybdr2ijw8y.pl ybdr2iw8y.pl ybdri8y.pl ybdrij8y.pl ybdrijw8y.pl ybdriw8y.pl
pls8yrc = ybdr0c8y.pl ybdr1c8y.pl ybdr2c8y.pl ybdr2cj8y.pl ybdr2cjw8y.pl ybdr2cw8y.pl ybdrc8y.pl ybdrcj8y.pl ybdrcjw8y.pl ybdrcw8y.pl
pls8yrci = ybdr0ci8y.pl ybdr1ci8y.pl ybdr2ci8y.pl ybdr2cij8y.pl ybdr2cijw8y.pl ybdr2ciw8y.pl ybdrci8y.pl ybdrcij8y.pl ybdrcijw8y.pl ybdrciw8y.pl
pls8yb = ybdb08y.pl ybdb18y.pl ybdb28y.pl ybdb2j8y.pl ybdb2jw8y.pl ybdb2w8y.pl ybdb8y.pl ybdbj8y.pl ybdbjw8y.pl ybdbw8y.pl
pls8ybi = ybdb0i8y.pl ybdb1i8y.pl ybdb2i8y.pl ybdb2ij8y.pl ybdb2ijw8y.pl ybdb2iw8y.pl ybdbi8y.pl ybdbij8y.pl ybdbijw8y.pl ybdbiw8y.pl
pls8ybc = ybdb0c8y.pl ybdb1c8y.pl ybdb2c8y.pl ybdb2cj8y.pl ybdb2cjw8y.pl ybdb2cw8y.pl ybdbc8y.pl ybdbcj8y.pl ybdbcjw8y.pl ybdbcw8y.pl
pls8ybci = ybdb0ci8y.pl ybdb1ci8y.pl ybdb2ci8y.pl ybdb2cij8y.pl ybdb2cijw8y.pl ybdb2ciw8y.pl ybdbci8y.pl ybdbcij8y.pl ybdbcijw8y.pl ybdbciw8y.pl
pls8tybd = ybdb8t.pl ybdbc8t.pl ybdbci8t.pl ybdbi8t.pl ybdr8t.pl ybdrc8t.pl ybdrci8t.pl ybdri8t.pl
pls8t0 = ybdb08t.pl ybdb0c8t.pl ybdb0ci8t.pl ybdb0i8t.pl ybdr08t.pl ybdr0c8t.pl ybdr0ci8t.pl ybdr0i8t.pl
pls8t1 = ybdb18t.pl ybdb1c8t.pl ybdb1ci8t.pl ybdb1i8t.pl ybdr18t.pl ybdr1c8t.pl ybdr1ci8t.pl ybdr1i8t.pl
pls8t2 = ybdb28t.pl ybdb2c8t.pl ybdb2ci8t.pl ybdb2i8t.pl ybdr28t.pl ybdr2c8t.pl ybdr2ci8t.pl ybdr2i8t.pl
pls8t2j = ybdb2cij8t.pl ybdb2cj8t.pl ybdb2ij8t.pl ybdb2j8t.pl ybdr2cij8t.pl ybdr2cj8t.pl ybdr2ij8t.pl ybdr2j8t.pl
pls8tj = ybdbcij8t.pl ybdbcj8t.pl ybdbij8t.pl ybdbj8t.pl ybdrcij8t.pl ybdrcj8t.pl ybdrij8t.pl ybdrj8t.pl
pls8t := $(pls8t0) $(pls8t1) $(pls8t2) $(pls8t2j) $(pls8tybd) $(pls8tj)
pls8tr = ybdr08t.pl ybdr18t.pl ybdr28t.pl ybdr2j8t.pl ybdr8t.pl ybdrj8t.pl
pls8tri = ybdr0i8t.pl ybdr1i8t.pl ybdr2i8t.pl ybdr2ij8t.pl ybdri8t.pl ybdrij8t.pl
pls8trc = ybdr0c8t.pl ybdr1c8t.pl ybdr2c8t.pl ybdr2cj8t.pl ybdrc8t.pl ybdrcj8t.pl
pls8trci = ybdr0ci8t.pl ybdr1ci8t.pl ybdr2ci8t.pl ybdr2cij8t.pl ybdrci8t.pl ybdrcij8t.pl
pls8tb = ybdb08t.pl ybdb18t.pl ybdb28t.pl ybdb2j8t.pl ybdb8t.pl ybdbj8t.pl
pls8tbi = ybdb0i8t.pl ybdb1i8t.pl ybdb2i8t.pl ybdb2ij8t.pl ybdbi8t.pl ybdbij8t.pl
pls8tbc = ybdb0c8t.pl ybdb1c8t.pl ybdb2c8t.pl ybdb2cj8t.pl ybdbc8t.pl ybdbcj8t.pl
pls8tbci = ybdb0ci8t.pl ybdb1ci8t.pl ybdb2ci8t.pl ybdb2cij8t.pl ybdbci8t.pl ybdbcij8t.pl
pls8cybd = ybdb8c.pl ybdbc8c.pl ybdbci8c.pl ybdbi8c.pl ybdr8c.pl ybdrc8c.pl ybdrci8c.pl ybdri8c.pl
pls8c0 = ybdb08c.pl ybdb0c8c.pl ybdb0ci8c.pl ybdb0i8c.pl ybdr08c.pl ybdr0c8c.pl ybdr0ci8c.pl ybdr0i8c.pl
pls8c1 = ybdb18c.pl ybdb1c8c.pl ybdb1ci8c.pl ybdb1i8c.pl ybdr18c.pl ybdr1c8c.pl ybdr1ci8c.pl ybdr1i8c.pl
pls8c2 = ybdb28c.pl ybdb2c8c.pl ybdb2ci8c.pl ybdb2i8c.pl ybdr28c.pl ybdr2c8c.pl ybdr2ci8c.pl ybdr2i8c.pl
pls8c2j = ybdb2cij8c.pl ybdb2cj8c.pl ybdb2ij8c.pl ybdb2j8c.pl ybdr2cij8c.pl ybdr2cj8c.pl ybdr2ij8c.pl ybdr2j8c.pl
pls8cj = ybdbcij8c.pl ybdbcj8c.pl ybdbij8c.pl ybdbj8c.pl ybdrcij8c.pl ybdrcj8c.pl ybdrij8c.pl ybdrj8c.pl
pls8c := $(pls8c0) $(pls8c1) $(pls8c2) $(pls8c2j) $(pls8cybd) $(pls8cj)
pls8cr = ybdr08c.pl ybdr18c.pl ybdr28c.pl ybdr2j8c.pl ybdr8c.pl ybdrj8c.pl
pls8cri = ybdr0i8c.pl ybdr1i8c.pl ybdr2i8c.pl ybdr2ij8c.pl ybdri8c.pl ybdrij8c.pl
pls8crc = ybdr0c8c.pl ybdr1c8c.pl ybdr2c8c.pl ybdr2cj8c.pl ybdrc8c.pl ybdrcj8c.pl
pls8crci = ybdr0ci8c.pl ybdr1ci8c.pl ybdr2ci8c.pl ybdr2cij8c.pl ybdrci8c.pl ybdrcij8c.pl
pls8cb = ybdb08c.pl ybdb18c.pl ybdb28c.pl ybdb2j8c.pl ybdb8c.pl ybdbj8c.pl
pls8cbi = ybdb0i8c.pl ybdb1i8c.pl ybdb2i8c.pl ybdb2ij8c.pl ybdbi8c.pl ybdbij8c.pl
pls8cbc = ybdb0c8c.pl ybdb1c8c.pl ybdb2c8c.pl ybdb2cj8c.pl ybdbc8c.pl ybdbcj8c.pl
pls8cbci = ybdb0ci8c.pl ybdb1ci8c.pl ybdb2ci8c.pl ybdb2cij8c.pl ybdbci8c.pl ybdbcij8c.pl
pls := $(pls8y) $(pls8t) $(pls8c)
maps8yybd = ybdb8y.map ybdbc8y.map ybdbci8y.map ybdbi8y.map ybdr8y.map ybdrc8y.map ybdrci8y.map ybdri8y.map
maps8y0 = ybdb08y.map ybdb0c8y.map ybdb0ci8y.map ybdb0i8y.map ybdr08y.map ybdr0c8y.map ybdr0ci8y.map ybdr0i8y.map
maps8y1 = ybdb18y.map ybdb1c8y.map ybdb1ci8y.map ybdb1i8y.map ybdr18y.map ybdr1c8y.map ybdr1ci8y.map ybdr1i8y.map
maps8y2 = ybdb28y.map ybdb2c8y.map ybdb2ci8y.map ybdb2i8y.map ybdr28y.map ybdr2c8y.map ybdr2ci8y.map ybdr2i8y.map
maps8y2j = ybdb2cij8y.map ybdb2cj8y.map ybdb2ij8y.map ybdb2j8y.map ybdr2cij8y.map ybdr2cj8y.map ybdr2ij8y.map ybdr2j8y.map
maps8y2jw = ybdb2cijw8y.map ybdb2cjw8y.map ybdb2ijw8y.map ybdb2jw8y.map ybdr2cijw8y.map ybdr2cjw8y.map ybdr2ijw8y.map ybdr2jw8y.map
maps8y2w = ybdb2ciw8y.map ybdb2cw8y.map ybdb2iw8y.map ybdb2w8y.map ybdr2ciw8y.map ybdr2cw8y.map ybdr2iw8y.map ybdr2w8y.map
maps8yj = ybdbcij8y.map ybdbcj8y.map ybdbij8y.map ybdbj8y.map ybdrcij8y.map ybdrcj8y.map ybdrij8y.map ybdrj8y.map
maps8yjw = ybdbcijw8y.map ybdbcjw8y.map ybdbijw8y.map ybdbjw8y.map ybdrcijw8y.map ybdrcjw8y.map ybdrijw8y.map ybdrjw8y.map
maps8yw = ybdbciw8y.map ybdbcw8y.map ybdbiw8y.map ybdbw8y.map ybdrciw8y.map ybdrcw8y.map ybdriw8y.map ybdrw8y.map
maps8y := $(maps8y0) $(maps8y1) $(maps8y2) $(maps8y2j) $(maps8y2jw) $(maps8y2w) $(maps8yybd) $(maps8yw) $(maps8yj) $(maps8yjw)
maps8tybd = ybdb8t.map ybdbc8t.map ybdbci8t.map ybdbi8t.map ybdr8t.map ybdrc8t.map ybdrci8t.map ybdri8t.map
maps8t0 = ybdb08t.map ybdb0c8t.map ybdb0ci8t.map ybdb0i8t.map ybdr08t.map ybdr0c8t.map ybdr0ci8t.map ybdr0i8t.map
maps8t1 = ybdb18t.map ybdb1c8t.map ybdb1ci8t.map ybdb1i8t.map ybdr18t.map ybdr1c8t.map ybdr1ci8t.map ybdr1i8t.map
maps8t2 = ybdb28t.map ybdb2c8t.map ybdb2ci8t.map ybdb2i8t.map ybdr28t.map ybdr2c8t.map ybdr2ci8t.map ybdr2i8t.map
maps8t2j = ybdb2cij8t.map ybdb2cj8t.map ybdb2ij8t.map ybdb2j8t.map ybdr2cij8t.map ybdr2cj8t.map ybdr2ij8t.map ybdr2j8t.map
maps8tj = ybdbcij8t.map ybdbcj8t.map ybdbij8t.map ybdbj8t.map ybdrcij8t.map ybdrcj8t.map ybdrij8t.map ybdrj8t.map
maps8t := $(maps8t0) $(maps8t1) $(maps8t2) $(maps8t2j) $(maps8t2jw) $(maps8t2w) $(maps8tybd) $(maps8tw) $(maps8tj) $(maps8tjw)
maps8cybd = ybdb8c.map ybdbc8c.map ybdbci8c.map ybdbi8c.map ybdr8c.map ybdrc8c.map ybdrci8c.map ybdri8c.map
maps8c0 = ybdb08c.map ybdb0c8c.map ybdb0ci8c.map ybdb0i8c.map ybdr08c.map ybdr0c8c.map ybdr0ci8c.map ybdr0i8c.map
maps8c1 = ybdb18c.map ybdb1c8c.map ybdb1ci8c.map ybdb1i8c.map ybdr18c.map ybdr1c8c.map ybdr1ci8c.map ybdr1i8c.map
maps8c2 = ybdb28c.map ybdb2c8c.map ybdb2ci8c.map ybdb2i8c.map ybdr28c.map ybdr2c8c.map ybdr2ci8c.map ybdr2i8c.map
maps8c2j = ybdb2cij8c.map ybdb2cj8c.map ybdb2ij8c.map ybdb2j8c.map ybdr2cij8c.map ybdr2cj8c.map ybdr2ij8c.map ybdr2j8c.map
maps8cj = ybdbcij8c.map ybdbcj8c.map ybdbij8c.map ybdbj8c.map ybdrcij8c.map ybdrcj8c.map ybdrij8c.map ybdrj8c.map
maps8c := $(maps8c0) $(maps8c1) $(maps8c2) $(maps8c2j) $(maps8c2jw) $(maps8c2w) $(maps8cybd) $(maps8cw) $(maps8cj) $(maps8cjw)
maps := $(maps8y) $(maps8t) $(maps8c)
tfms = ybdb08y.tfm ybdb0c8y.tfm ybdb0ci8y.tfm ybdb0i8y.tfm ybdb18y.tfm ybdb1c8y.tfm ybdb1ci8y.tfm ybdb1i8y.tfm ybdb28y.tfm ybdb2c8y.tfm ybdb2ci8y.tfm ybdb2cij8y.tfm ybdb2cijw8y.tfm ybdb2ciw8y.tfm ybdb2cj8y.tfm ybdb2cjw8y.tfm ybdb2cw8y.tfm ybdb2i8y.tfm ybdb2ij8y.tfm ybdb2ijw8y.tfm ybdb2iw8y.tfm ybdb2j8y.tfm ybdb2jw8y.tfm ybdb2w8y.tfm ybdb8y.tfm ybdbc8y.tfm ybdbci8y.tfm ybdbcij8y.tfm ybdbcijw8y.tfm ybdbciw8y.tfm ybdbcj8y.tfm ybdbcjw8y.tfm ybdbcw8y.tfm ybdbi8y.tfm ybdbij8y.tfm ybdbijw8y.tfm ybdbiw8y.tfm ybdbj8y.tfm ybdbjw8y.tfm ybdbw8y.tfm ybdr08y.tfm ybdr0c8y.tfm ybdr0ci8y.tfm ybdr0i8y.tfm ybdr18y.tfm ybdr1c8y.tfm ybdr1ci8y.tfm ybdr1i8y.tfm ybdr28y.tfm ybdr2c8y.tfm ybdr2ci8y.tfm ybdr2cij8y.tfm ybdr2cijw8y.tfm ybdr2ciw8y.tfm ybdr2cj8y.tfm ybdr2cjw8y.tfm ybdr2cw8y.tfm ybdr2i8y.tfm ybdr2ij8y.tfm ybdr2ijw8y.tfm ybdr2iw8y.tfm ybdr2j8y.tfm ybdr2jw8y.tfm ybdr2w8y.tfm ybdr8y.tfm ybdrc8y.tfm ybdrci8y.tfm ybdrcij8y.tfm ybdrcijw8y.tfm ybdrciw8y.tfm ybdrcj8y.tfm ybdrcjw8y.tfm ybdrcw8y.tfm ybdri8y.tfm ybdrij8y.tfm ybdrijw8y.tfm ybdriw8y.tfm ybdrj8y.tfm ybdrjw8y.tfm ybdrw8y.tfm ybdb08t.tfm ybdb0c8t.tfm ybdb0ci8t.tfm ybdb0i8t.tfm ybdb18t.tfm ybdb1c8t.tfm ybdb1ci8t.tfm ybdb1i8t.tfm ybdb28t.tfm ybdb2c8t.tfm ybdb2ci8t.tfm ybdb2cij8t.tfm  ybdb2cj8t.tfm  ybdb2i8t.tfm ybdb2ij8t.tfm  ybdb2j8t.tfm  ybdb8t.tfm ybdbc8t.tfm ybdbci8t.tfm ybdbcij8t.tfm  ybdbcj8t.tfm  ybdbi8t.tfm ybdbij8t.tfm  ybdbj8t.tfm  ybdr08t.tfm ybdr0c8t.tfm ybdr0ci8t.tfm ybdr0i8t.tfm ybdr18t.tfm ybdr1c8t.tfm ybdr1ci8t.tfm ybdr1i8t.tfm ybdr28t.tfm ybdr2c8t.tfm ybdr2ci8t.tfm ybdr2cij8t.tfm  ybdr2cj8t.tfm  ybdr2i8t.tfm ybdr2ij8t.tfm  ybdr2j8t.tfm  ybdr8t.tfm ybdrc8t.tfm ybdrci8t.tfm ybdrcij8t.tfm  ybdrcj8t.tfm  ybdri8t.tfm ybdrij8t.tfm  ybdrj8t.tfm ybdb08c.tfm ybdb0c8c.tfm ybdb0ci8c.tfm ybdb0i8c.tfm ybdb18c.tfm ybdb1c8c.tfm ybdb1ci8c.tfm ybdb1i8c.tfm ybdb28c.tfm ybdb2c8c.tfm ybdb2ci8c.tfm ybdb2cij8c.tfm  ybdb2cj8c.tfm  ybdb2i8c.tfm ybdb2ij8c.tfm  ybdb2j8c.tfm  ybdb8c.tfm ybdbc8c.tfm ybdbci8c.tfm ybdbcij8c.tfm  ybdbcj8c.tfm  ybdbi8c.tfm ybdbij8c.tfm  ybdbj8c.tfm  ybdr08c.tfm ybdr0c8c.tfm ybdr0ci8c.tfm ybdr0i8c.tfm ybdr18c.tfm ybdr1c8c.tfm ybdr1ci8c.tfm ybdr1i8c.tfm ybdr28c.tfm ybdr2c8c.tfm ybdr2ci8c.tfm ybdr2cij8c.tfm  ybdr2cj8c.tfm  ybdr2i8c.tfm ybdr2ij8c.tfm  ybdr2j8c.tfm  ybdr8c.tfm ybdrc8c.tfm ybdrci8c.tfm ybdrcij8c.tfm  ybdrcj8c.tfm  ybdri8c.tfm ybdrij8c.tfm  ybdrj8c.tfm
pfbs = ybdb.pfb ybdbc.pfb ybdbci.pfb ybdbi.pfb ybdr.pfb ybdrc.pfb ybdrci.pfb ybdri.pfb
afms = ybdb.afm ybdbc.afm ybdbci.afm ybdbi.afm ybdr.afm ybdrc.afm ybdrci.afm ybdri.afm
encs = texnansi-ybd.enc texnansi-ybd0.enc texnansi-ybd1.enc texnansi-ybd2.enc texnansi-ybd2j.enc texnansi-ybdj.enc texnansx-ybd2jw.enc texnansx-ybd2w.enc texnansx-ybdjw.enc texnansx-ybdw.enc t1-ybd.enc t1-ybd0.enc t1-ybd1.enc t1-ybd2.enc t1-ybd2j.enc t1-ybdj.enc    ts1-ybd.enc ts1-ybd0.enc ts1-ybd1.enc ts1-ybd2.enc ts1-ybd2j.enc ts1-ybdj.enc
otfs = BerenisADFPro-Bold.otf BerenisADFPro-BoldItalic.otf BerenisADFPro-Italic.otf BerenisADFPro-Regular.otf BerenisADFProSC-Bold.otf BerenisADFProSC-BoldItalic.otf BerenisADFProSC-Italic.otf BerenisADFProSC-Regular.otf
fds = ly1ybd.fd ly1ybd0.fd ly1ybd1.fd ly1ybd2.fd ly1ybd2j.fd ly1ybd2jw.fd ly1ybd2w.fd ly1ybdj.fd ly1ybdjw.fd ly1ybdw.fd t1ybd.fd t1ybd0.fd t1ybd1.fd t1ybd2.fd t1ybd2j.fd  t1ybdj.fd ts1ybd.fd ts1ybd0.fd ts1ybd1.fd ts1ybd2.fd ts1ybd2j.fd  ts1ybdj.fd

srcdir = .
enw = berenisadf
version = 1.004
release = 6

temp := $(pls) $(maps)
lpplder := $(tfms) ybd.map berenisadf.pdf
gplder := $(pfbs) $(afms) COPYING.unix
derived := $(temp) $(lpplder) $(gplder)
lpplnonder := $(encs) ybd.nam ff-ybd.pe ybd-8y.lig ybd-8t.lig $(fds) berenis.sty berenisadf.tex README Makefile cfr.gwneud.cyhoeddus
gplnonder := $(otfs) COPYING NOTICE.txt
nonderived := $(lpplnonder) $(gplder)
gpl := $(gplder) $(gplnonder)
lppl := $(lpplder) $(lpplnonder)

all : $(tfms) $(pfbs) ybd.map

doc : berenisadf.pdf COPYING COPYING.unix NOTICE.txt README manifest.txt

ctanlists : der nonder adf

ctandirs : ctanlists cfr.gwneud.cyhoeddus
	./cfr.gwneud.cyhoeddus -a ./adf -d ./der -n ./nonder -f berenisadf -m berenisadf -t afm2pl -v arkandis

ctanarc : ctandirs
	mkdir $(enw)
	mv doc fonts source tex README $(enw)/
	chmod 755 $(enw)
	tar -czf $(enw)-$(version)-$(release).tar.gz $(enw)

clean :
	-rm $(derived) der nonder adf

tidy :
	-rm $(temp)

tidier :
	-rm $(temp) der nonder adf
	
tidytex :
	latexmk -c
	-rm *.log *.aux *~.tex *.synctex.gz *.toc *.out

.PHONY : ctanlists ctandirs ctanarc clean doc tidy tidier tidytex all
# use intermediate if temporary files should be deleted by make
#.INTERMEDIATE : $(maps)
# use secondary if they should be kept
.SECONDARY : $(maps) $(pls)

der : Makefile $(lpplder)
	ls $(lpplder) > der
nonder : $(lpplnonder)
	ls $(lpplnonder) > nonder
adf : Makefile $(gpl)
	ls $(gpl) > adf
manifest.txt : ctandirs

berenisadf.pdf : berenisadf.tex berenis.sty $(tfms) $(pfbs) ybd.map
	latexmk -pdf -pv- -pvc- berenisadf.tex

$(afms) : %.afm : %.pfb
$(pfbs) : ff-ybd.pe ybd.nam $(otfs)
	@printf %b "Generating type 1 from $(subst .pfb,.otf,$(subst ybd,BerenisADFPro,$(subst -r,-Regular,$(subst -b,-Bold,$(subst -rI,-I,$(subst ybdb,ybd-b,$(subst ybdr,ybd-r,$(subst bc,SC-b,$(subst rc,SC-r,$(subst i,Italic,$@))))))))))\n"
	$(srcdir)/ff-ybd.pe $(subst .pfb,.otf,$(subst ybd,BerenisADFPro,$(subst -r,-Regular,$(subst -b,-Bold,$(subst -rI,-I,$(subst ybdb,ybd-b,$(subst ybdr,ybd-r,$(subst bc,SC-b,$(subst rc,SC-r,$(subst i,Italic,$@))))))))))
	@printf %b "Moving $(subst .pfb,.afm,$(subst ybd,BerenisADFPro,$(subst -r,-Regular,$(subst -b,-Bold,$(subst -rI,-I,$(subst ybdb,ybd-b,$(subst ybdr,ybd-r,$(subst bc,SC-b,$(subst rc,SC-r,$(subst i,Italic,$@)))))))))) to $(subst .pfb,.afm,$@)\n"
	mv $(subst .pfb,.afm,$(subst ybd,BerenisADFPro,$(subst -r,-Regular,$(subst -b,-Bold,$(subst -rI,-I,$(subst ybdb,ybd-b,$(subst ybdr,ybd-r,$(subst bc,SC-b,$(subst rc,SC-r,$(subst i,Italic,$@)))))))))) $(subst .pfb,.afm,$@)
	@printf %b "Moving $(subst ybd,BerenisADFPro,$(subst -r,-Regular,$(subst -b,-Bold,$(subst -rI,-I,$(subst ybdb,ybd-b,$(subst ybdr,ybd-r,$(subst bc,SC-b,$(subst rc,SC-r,$(subst i,Italic,$@))))))))) to $@\n"
	mv $(subst ybd,BerenisADFPro,$(subst -r,-Regular,$(subst -b,-Bold,$(subst -rI,-I,$(subst ybdb,ybd-b,$(subst ybdr,ybd-r,$(subst bc,SC-b,$(subst rc,SC-r,$(subst i,Italic,$@))))))))) $@

$(maps) : %.map : %.pl
$(pls8yybd) : %8y.pl : %.afm ybd-8y.lig texnansi-ybd.enc
	@echo $< \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansi-ybd.enc $< $@
$(pls8y0) : ybd-8y.lig texnansi-ybd0.enc
	@echo $(subst 8y.pl,.afm,$(subst 0,,$@)) \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansi-ybd0.enc $(subst 8y.pl,.afm,$(subst 0,,$@)) $@
$(pls8y1) : ybd-8y.lig texnansi-ybd1.enc
	@echo $(subst 8y.pl,.afm,$(subst 1,,$@)) \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansi-ybd1.enc $(subst 8y.pl,.afm,$(subst 1,,$@)) $@
$(pls8y2) : ybd-8y.lig texnansi-ybd2.enc
	@echo $(subst 8y.pl,.afm,$(subst 2,,$@)) \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansi-ybd2.enc $(subst 8y.pl,.afm,$(subst 2,,$@)) $@
$(pls8y2j) : ybd-8y.lig texnansi-ybd2j.enc
	@echo $(subst 8y.pl,.afm,$(subst j,,$(subst 2,,$@))) \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansi-ybd2j.enc $(subst 8y.pl,.afm,$(subst j,,$(subst 2,,$@))) $@
$(pls8y2jw) : ybd-8y.lig texnansx-ybd2jw.enc
	@echo $(subst 8y.pl,.afm,$(subst j,,$(subst w,,$(subst 2,,$@)))) \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansx-ybd2jw.enc $(subst 8y.pl,.afm,$(subst j,,$(subst w,,$(subst 2,,$@)))) $@
$(pls8y2w) : ybd-8y.lig texnansx-ybd2w.enc
	@echo $(subst 8y.pl,.afm,$(subst w,,$(subst 2,,$@))) \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansx-ybd2w.enc $(subst 8y.pl,.afm,$(subst w,,$(subst 2,,$@))) $@
$(pls8yj) : %j8y.pl : %.afm  ybd-8y.lig texnansi-ybdj.enc
	@echo $< \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansi-ybdj.enc $< $@
$(pls8yjw) : %jw8y.pl : %.afm  ybd-8y.lig texnansx-ybdjw.enc
	@echo $< \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansx-ybdjw.enc $< $@
$(pls8yw) : %w8y.pl : %.afm ybd-8y.lig texnansx-ybdw.enc
	@echo $< \=\> $@
	-afm2pl -l ybd-8y.lig -n -p texnansx-ybdw.enc $< $@
$(pls8tybd) : %8t.pl : %.afm ybd-8t.lig t1-ybd.enc
	@echo $< \=\> $@
	-afm2pl -l ybd-8t.lig -n -p t1-ybd.enc $< $@
$(pls8t0) : ybd-8t.lig t1-ybd0.enc
	@echo $(subst 8t.pl,.afm,$(subst 0,,$@)) \=\> $@
	-afm2pl -l ybd-8t.lig -n -p t1-ybd0.enc $(subst 8t.pl,.afm,$(subst 0,,$@)) $@
$(pls8t1) : ybd-8t.lig t1-ybd1.enc
	@echo $(subst 8t.pl,.afm,$(subst 1,,$@)) \=\> $@
	-afm2pl -l ybd-8t.lig -n -p t1-ybd1.enc $(subst 8t.pl,.afm,$(subst 1,,$@)) $@
$(pls8t2) : ybd-8t.lig t1-ybd2.enc
	@echo $(subst 8t.pl,.afm,$(subst 2,,$@)) \=\> $@
	-afm2pl -l ybd-8t.lig -n -p t1-ybd2.enc $(subst 8t.pl,.afm,$(subst 2,,$@)) $@
$(pls8t2j) : ybd-8t.lig t1-ybd2j.enc
	@echo $(subst 8t.pl,.afm,$(subst j,,$(subst 2,,$@))) \=\> $@
	-afm2pl -l ybd-8t.lig -n -p t1-ybd2j.enc $(subst 8t.pl,.afm,$(subst j,,$(subst 2,,$@))) $@
$(pls8tj) : %j8t.pl : %.afm  ybd-8t.lig t1-ybdj.enc
	@echo $< \=\> $@
	-afm2pl -l ybd-8t.lig -n -p t1-ybdj.enc $< $@
$(pls8cybd) : %8c.pl : %.afm ybd-8t.lig ts1-ybd.enc
	@echo $< \=\> $@
	-afm2pl -l ybd-8t.lig -n -p ts1-ybd.enc $< $@
$(pls8c0) : ybd-8t.lig ts1-ybd0.enc
	@echo $(subst 8c.pl,.afm,$(subst 0,,$@)) \=\> $@
	-afm2pl -l ybd-8t.lig -n -p ts1-ybd0.enc $(subst 8c.pl,.afm,$(subst 0,,$@)) $@
$(pls8c1) : ybd-8t.lig ts1-ybd1.enc
	@echo $(subst 8c.pl,.afm,$(subst 1,,$@)) \=\> $@
	-afm2pl -l ybd-8t.lig -n -p ts1-ybd1.enc $(subst 8c.pl,.afm,$(subst 1,,$@)) $@
$(pls8c2) : ybd-8t.lig ts1-ybd2.enc
	@echo $(subst 8c.pl,.afm,$(subst 2,,$@)) \=\> $@
	-afm2pl -l ybd-8t.lig -n -p ts1-ybd2.enc $(subst 8c.pl,.afm,$(subst 2,,$@)) $@
$(pls8c2j) : ybd-8t.lig ts1-ybd2j.enc
	@echo $(subst 8c.pl,.afm,$(subst j,,$(subst 2,,$@))) \=\> $@
	-afm2pl -l ybd-8t.lig -n -p ts1-ybd2j.enc $(subst 8c.pl,.afm,$(subst j,,$(subst 2,,$@))) $@
$(pls8cj) : %j8c.pl : %.afm  ybd-8t.lig ts1-ybdj.enc
	@echo $< \=\> $@
	-afm2pl -l ybd-8t.lig -n -p ts1-ybdj.enc $< $@

$(plsr) : ybdr.afm
$(plsri) : ybdri.afm
$(plsrc) : ybdrc.afm
$(plsrci) : ybdrci.afm
$(plsb) : ybdb.afm
$(plsbi) : ybdbi.afm
$(plsbc) : ybdbc.afm
$(plsbci) : ybdbci.afm

ybd.map : $(maps)
	@printf %b "Creating ybd.map...\n"
	cat $(maps) > ybd.map

$(tfms) : %.tfm : %.pl
	@echo $< \=\> $@
	pltotf $< $@

