#!/bin/bash
#
# This file is a part of the CM-LGC font package
# version 0.5 (May 07, 2005)
#
# Copyright (c) 2003--2005 Alexej Kryukov <basileia@yandex.ru>.
# 
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# As a special exception, permission is granted to include these font
# programs in a Postscript or PDF file that consists of a document that
# contains text to be displayed or printed using these fonts, regardless
# of the conditions or license applying to the document itself.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function getfontafm () {
    FONT_NAME=$1
    
    echo "Processing $FONT_NAME..."
    perl $TFM2KPX $FONT_NAME > $KPX_DIR/$FONT_NAME.kpx
    $T12AFM $PFB_DIR/$FONT_NAME.pfb $KPX_DIR/$FONT_NAME.kpx > $PFB_DIR/$FONT_NAME.afm
}

function getfamilyafm () {
    LANG_SUF=$1

    getfontafm fcmr$LANG_SUF
    getfontafm fcmri$LANG_SUF
    getfontafm fcmrc$LANG_SUF
    getfontafm fcmrij$LANG_SUF
    getfontafm fcmb$LANG_SUF
    getfontafm fcmbi$LANG_SUF
    getfontafm fcmbc$LANG_SUF
    getfontafm fcmbij$LANG_SUF

    getfontafm fcsr$LANG_SUF
    getfontafm fcsro$LANG_SUF
    getfontafm fcsb$LANG_SUF
    getfontafm fcsbo$LANG_SUF

    getfontafm fctr$LANG_SUF
    getfontafm fctri$LANG_SUF
    getfontafm fctrc$LANG_SUF
    getfontafm fctrij$LANG_SUF
}

CUR_DIR=$PWD
TEXTRACE_DIR=$CUR_DIR/textrace-0.49
SCRIPTS_DIR=$CUR_DIR/bin

TRACEALL=./traceall.sh
TFM2KPX=$TEXTRACE_DIR/contrib/tfm2kpx.pl
T12AFM=$SCRIPTS_DIR/t12afm-simple.sh

KPX_DIR=$CUR_DIR/kpx
PFB_DIR=$CUR_DIR/converted

if !([ -d $KPX_DIR ]); then
    mkdir $KPX_DIR
fi

if !([ -d $PFB_DIR ]); then
    mkdir $PFB_DIR
#else
#    rm -rf $PFB_DIR/*.pfb $PFB_DIR/*.afm
fi

cd $TEXTRACE_DIR
$TRACEALL --map $CUR_DIR/cm-lgc.map $PFB_DIR

getfamilyafm lat
getfamilyafm ceu
getfamilyafm cyr
getfamilyafm asi
getfamilyafm grk
