/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.special.Erf;

public class NormalDistributionImpl
extends AbstractContinuousDistribution
implements NormalDistribution,
Serializable {
    static final long serialVersionUID = 8589540077390120676L;
    private double mean = 0.0;
    private double standardDeviation = 1.0;

    public NormalDistributionImpl(double mean, double sd) {
        this.setMean(mean);
        this.setStandardDeviation(sd);
    }

    public NormalDistributionImpl() {
        this(0.0, 1.0);
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public void setStandardDeviation(double sd) {
        if (sd <= 0.0) {
            throw new IllegalArgumentException("Standard deviation must be positive.");
        }
        this.standardDeviation = sd;
    }

    public double cumulativeProbability(double x) throws MathException {
        return 0.5 * (1.0 + Erf.erf((x - this.mean) / (this.standardDeviation * Math.sqrt(2.0))));
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p);
    }

    protected double getDomainLowerBound(double p) {
        double ret = p < 0.5 ? -1.7976931348623157E308 : this.getMean();
        return ret;
    }

    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.getMean() : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.getMean() - this.getStandardDeviation() : (p > 0.5 ? this.getMean() + this.getStandardDeviation() : this.getMean());
        return ret;
    }
}

