/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.rendering.BorderType;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.table.Table;
import com.github.ajalt.mordant.table.TableKt;
import com.github.ajalt.mordant.table.TableRenderer;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B[\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0002J$\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00032\u0006\u0010-\u001a\u00020\u000bH\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\u00042\u0006\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000bH\u0002J\u0018\u00101\u001a\u0002022\u0006\u0010'\u001a\u00020(2\u0006\u00103\u001a\u00020\u000bH\u0016J \u00104\u001a\u0002022\u0006\u0010/\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(2\u0006\u00103\u001a\u00020\u000bH\u0002J\u0018\u00105\u001a\u0002062\u0006\u0010'\u001a\u00020(2\u0006\u00103\u001a\u00020\u000bH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00190\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00067"}, d2={"Lcom/github/ajalt/mordant/table/TableImpl;", "Lcom/github/ajalt/mordant/table/Table;", "rows", "", "Lcom/github/ajalt/mordant/table/Cell;", "Lcom/github/ajalt/mordant/table/ImmutableRow;", "borderType", "Lcom/github/ajalt/mordant/rendering/BorderType;", "borderStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "headerRowCount", "", "footerRowCount", "columnStyles", "", "Lcom/github/ajalt/mordant/table/ColumnWidth;", "tableBorders", "Lcom/github/ajalt/mordant/table/Borders;", "(Ljava/util/List;Lcom/github/ajalt/mordant/rendering/BorderType;Lcom/github/ajalt/mordant/rendering/TextStyle;IILjava/util/Map;Lcom/github/ajalt/mordant/table/Borders;)V", "getBorderStyle", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "getBorderType", "()Lcom/github/ajalt/mordant/rendering/BorderType;", "borderWidth", "columnBorders", "", "columnCount", "getColumnStyles", "()Ljava/util/Map;", "expand", "getFooterRowCount", "()I", "getHeaderRowCount", "rowBorders", "getRows", "()Ljava/util/List;", "getTableBorders", "()Lcom/github/ajalt/mordant/table/Borders;", "calculateColumnWidths", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "terminalWidth", "distributeWidths", "weights", "", "totalWidth", "getCell", "x", "y", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "width", "measureColumn", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "mordant"})
@SourceDebugExtension(value={"SMAP\nTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Table.kt\ncom/github/ajalt/mordant/table/TableImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 WidthRange.kt\ncom/github/ajalt/mordant/rendering/WidthRangeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,432:1\n1#2:433\n1#2:472\n1#2:485\n1#2:498\n1747#3,3:434\n1747#3,3:437\n1747#3,3:440\n1774#3,4:443\n1620#3,3:459\n1603#3,9:488\n1855#3:497\n1856#3:499\n1612#3:500\n1549#3:501\n1620#3,3:502\n1549#3:505\n1620#3,3:506\n1549#3:509\n1620#3,3:510\n1855#3,2:513\n1549#3:515\n1620#3,3:516\n1549#3:519\n1620#3,3:520\n1620#3,3:523\n27#4,12:447\n135#5,9:462\n215#5:471\n216#5:473\n144#5:474\n135#5,9:475\n215#5:484\n216#5:486\n144#5:487\n*S KotlinDebug\n*F\n+ 1 Table.kt\ncom/github/ajalt/mordant/table/TableImpl\n*L\n159#1:472\n160#1:485\n161#1:498\n83#1:434,3\n91#1:437,3\n102#1:440,3\n107#1:443,4\n157#1:459,3\n161#1:488,9\n161#1:497\n161#1:499\n161#1:500\n188#1:501\n188#1:502,3\n189#1:505\n189#1:506,3\n194#1:509\n194#1:510,3\n196#1:513,2\n200#1:515\n200#1:516,3\n207#1:519\n207#1:520,3\n210#1:523,3\n142#1:447,12\n159#1:462,9\n159#1:471\n159#1:473\n159#1:474\n160#1:475,9\n160#1:484\n160#1:486\n160#1:487\n*E\n"})
public final class TableImpl
extends Table {
    @NotNull
    private final List<List<Cell>> rows;
    @NotNull
    private final BorderType borderType;
    @NotNull
    private final TextStyle borderStyle;
    private final int headerRowCount;
    private final int footerRowCount;
    @NotNull
    private final Map<Integer, ColumnWidth> columnStyles;
    @Nullable
    private final Borders tableBorders;
    private final boolean expand;
    private final int columnCount;
    @NotNull
    private final List<Boolean> rowBorders;
    @NotNull
    private final List<Boolean> columnBorders;
    private final int borderWidth;

    /*
     * WARNING - void declaration
     */
    public TableImpl(@NotNull List<? extends List<? extends Cell>> rows, @NotNull BorderType borderType, @NotNull TextStyle borderStyle, int headerRowCount, int footerRowCount, @NotNull Map<Integer, ? extends ColumnWidth> columnStyles, @Nullable Borders tableBorders) {
        int n;
        void $this$count$iv;
        int element$iv;
        Iterator iterator2;
        boolean $i$f$any;
        Iterable $this$any$iv;
        int n2;
        int n3;
        int n4;
        Iterable $this$any$iv322;
        TableImpl tableImpl;
        block25: {
            Intrinsics.checkNotNullParameter(rows, "rows");
            Intrinsics.checkNotNullParameter(borderType, "borderType");
            Intrinsics.checkNotNullParameter(borderStyle, "borderStyle");
            Intrinsics.checkNotNullParameter(columnStyles, "columnStyles");
            super(null);
            this.rows = rows;
            this.borderType = borderType;
            this.borderStyle = borderStyle;
            this.headerRowCount = headerRowCount;
            this.footerRowCount = footerRowCount;
            this.columnStyles = columnStyles;
            this.tableBorders = tableBorders;
            if (!(!((Collection)this.rows).isEmpty())) {
                boolean $i$a$-require-TableImpl$22 = false;
                String $i$a$-require-TableImpl$22 = "Table cannot be empty";
                throw new IllegalArgumentException($i$a$-require-TableImpl$22.toString());
            }
            Iterable iterable = this.columnStyles.values();
            tableImpl = this;
            boolean $i$f$any2 = false;
            if ($this$any$iv322 instanceof Collection && ((Collection)$this$any$iv322).isEmpty()) {
                n4 = 0;
            } else {
                for (Object element$iv2 : $this$any$iv322) {
                    ColumnWidth it = (ColumnWidth)element$iv2;
                    boolean bl = false;
                    if (!(it instanceof ColumnWidth.Expand)) continue;
                    n4 = 1;
                    break block25;
                }
                n4 = 0;
            }
        }
        tableImpl.expand = n3 = n4;
        $this$any$iv322 = this.rows;
        tableImpl = this;
        ArrayList<Boolean> $i$f$any2 = $this$any$iv322.iterator();
        if (!$i$f$any2.hasNext()) {
            throw new NoSuchElementException();
        }
        List it22 = (List)$i$f$any2.next();
        boolean bl = false;
        int it22 = it22.size();
        while ($i$f$any2.hasNext()) {
            List it = (List)$i$f$any2.next();
            n5 = false;
            n2 = it.size();
            if (it22 >= n2) continue;
            it22 = n2;
        }
        tableImpl.columnCount = n3 = it22;
        int $this$any$iv322 = this.rows.size() + 1;
        tableImpl = this;
        $i$f$any2 = new ArrayList($this$any$iv322);
        for (it22 = 0; it22 < $this$any$iv322; ++it22) {
            boolean bl2;
            ArrayList<Boolean> arrayList;
            block26: {
                void y;
                int n5 = n2 = it22;
                arrayList = $i$f$any2;
                boolean bl3 = false;
                if (y == false && this.tableBorders != null) {
                    bl2 = this.tableBorders.getTop();
                } else if (y == this.rows.size() && this.tableBorders != null) {
                    bl2 = this.tableBorders.getBottom();
                } else {
                    $this$any$iv = RangesKt.until(0, this.columnCount);
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            int x = element$iv = ((IntIterator)iterator2).nextInt();
                            boolean bl4 = false;
                            if (!(TableKt.access$getT(this.getCell(x, (int)y)) || TableKt.access$getB(this.getCell(x, (int)(y - true))))) continue;
                            bl2 = true;
                            break block26;
                        }
                        bl2 = false;
                    }
                }
            }
            arrayList.add(bl2);
        }
        tableImpl.rowBorders = $i$f$any2;
        $this$any$iv322 = this.columnCount + 1;
        tableImpl = this;
        $i$f$any2 = new ArrayList<Boolean>($this$any$iv322);
        for (it22 = 0; it22 < $this$any$iv322; ++it22) {
            boolean bl5;
            ArrayList<Boolean> arrayList;
            block27: {
                void x;
                int y = n2 = it22;
                arrayList = $i$f$any2;
                boolean bl6 = false;
                if (x == false && this.tableBorders != null) {
                    bl5 = this.tableBorders.getLeft();
                } else if (x == this.columnCount && this.tableBorders != null) {
                    bl5 = this.tableBorders.getRight();
                } else {
                    $this$any$iv = CollectionsKt.getIndices((Collection)this.rows);
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            int y2 = element$iv = ((IntIterator)iterator2).nextInt();
                            boolean bl7 = false;
                            if (!(TableKt.access$getL(this.getCell((int)x, y2)) || TableKt.access$getR(this.getCell((int)(x - true), y2)))) continue;
                            bl5 = true;
                            break block27;
                        }
                        bl5 = false;
                    }
                }
            }
            arrayList.add(bl5);
        }
        tableImpl.columnBorders = $i$f$any2;
        Iterable $this$any$iv322 = this.columnBorders;
        tableImpl = this;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv3 : $this$count$iv) {
                boolean it = (Boolean)element$iv3;
                boolean bl8 = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        tableImpl.borderWidth = n3 = n;
    }

    @NotNull
    public final List<List<Cell>> getRows() {
        return this.rows;
    }

    @NotNull
    public final BorderType getBorderType() {
        return this.borderType;
    }

    @NotNull
    public final TextStyle getBorderStyle() {
        return this.borderStyle;
    }

    public final int getHeaderRowCount() {
        return this.headerRowCount;
    }

    public final int getFooterRowCount() {
        return this.footerRowCount;
    }

    @NotNull
    public final Map<Integer, ColumnWidth> getColumnStyles() {
        return this.columnStyles;
    }

    @Nullable
    public final Borders getTableBorders() {
        return this.tableBorders;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(t, "t");
        if (this.expand) {
            return new WidthRange(width, width);
        }
        int remainingWidth = width - this.borderWidth;
        int n3 = this.columnCount;
        ArrayList<WidthRange> arrayList = new ArrayList<WidthRange>(n3);
        int n4 = 0;
        while (n4 < n3) {
            void it;
            int n5;
            int n6 = n5 = n4++;
            ArrayList<WidthRange> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(this.measureColumn((int)it, t, remainingWidth));
        }
        List ranges = arrayList;
        Iterable iterable = ranges;
        int n7 = 0;
        for (Object t2 : iterable) {
            WidthRange it = (WidthRange)t2;
            n2 = n7;
            boolean bl = false;
            n = it.getMin();
            n7 = n2 + n;
        }
        iterable = ranges;
        n2 = n7 + this.borderWidth;
        n7 = 0;
        for (Object t3 : iterable) {
            WidthRange it = (WidthRange)t3;
            n = n7;
            boolean bl = false;
            int n8 = it.getMax();
            n7 = n + n8;
        }
        n = n7;
        int n9 = n + this.borderWidth;
        int n10 = n2;
        return new WidthRange(n10, n9);
    }

    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        return new TableRenderer(this.rows, this.borderType, this.borderStyle, this.headerRowCount, this.footerRowCount, this.columnCount, this.calculateColumnWidths(t, width), this.columnBorders, this.rowBorders, this.tableBorders, t).render();
    }

    private final WidthRange measureColumn(int x, Terminal t, int width) {
        ColumnWidth columnWidth = this.columnStyles.get(x);
        if (columnWidth instanceof ColumnWidth.Fixed) {
            return new WidthRange(((ColumnWidth.Fixed)columnWidth).getWidth(), ((ColumnWidth.Fixed)columnWidth).getWidth());
        }
        Iterable $this$maxWidthRange_u24default$iv = this.rows;
        int paddingWidth$iv = 0;
        boolean $i$f$maxWidthRange = false;
        int max$iv = 0;
        int min$iv = 0;
        for (Object it$iv : $this$maxWidthRange_u24default$iv) {
            WidthRange widthRange;
            List row2 = (List)it$iv;
            boolean bl = false;
            Cell cell2 = (Cell)CollectionsKt.getOrNull(row2, x);
            if (cell2 == null) {
                widthRange = null;
            } else if (cell2 instanceof Cell.Empty) {
                widthRange = new WidthRange(0, 0);
            } else if (cell2 instanceof Cell.Content) {
                widthRange = ((Cell.Content)cell2).getContent().measure(t, width).div(((Cell.Content)cell2).getColumnSpan());
            } else if (cell2 instanceof Cell.SpanRef) {
                widthRange = ((Cell.SpanRef)cell2).getCell().getContent().measure(t, width).div(((Cell.SpanRef)cell2).getColumnSpan());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (widthRange == null) continue;
            WidthRange range$iv = widthRange;
            max$iv = Math.max(max$iv, range$iv.getMax());
            min$iv = Math.max(min$iv, range$iv.getMin());
        }
        return new WidthRange(min$iv + paddingWidth$iv, max$iv + paddingWidth$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> calculateColumnWidths(Terminal t, int terminalWidth) {
        int it;
        Collection<Float> collection;
        Iterable $this$mapTo$iv$iv;
        int n;
        int n3;
        void $this$mapNotNullTo$iv$iv32422;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void destination$iv;
        void $this$mapTo$iv;
        ArrayList<Object> arrayList;
        int availableWidth = terminalWidth - this.borderWidth;
        if (availableWidth <= 0) {
            int n4 = this.columnCount;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n4);
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                int n7 = n6 = n5++;
                ArrayList<Integer> arrayList3 = arrayList2;
                boolean bl = false;
                arrayList3.add(0);
            }
            return arrayList2;
        }
        int n8 = this.columnCount;
        Iterable<Object> iterable = new ArrayList<Object>(n8);
        int n9 = 0;
        while (n9 < n8) {
            void it2;
            int it3;
            int bl = it3 = n9++;
            arrayList = iterable;
            boolean bl2 = false;
            arrayList.add(this.measureColumn((int)it2, t, availableWidth));
        }
        List measurements = iterable;
        iterable = measurements;
        Collection collection2 = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it4;
            WidthRange widthRange = (WidthRange)item$iv;
            arrayList = destination$iv;
            boolean bl = false;
            arrayList.add(it4.getMax());
        }
        List widths = (List)destination$iv;
        Map<Integer, ColumnWidth> $this$mapNotNull$iv = this.columnStyles;
        boolean $i$f$mapNotNull = false;
        Map<Integer, ColumnWidth> it2 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl = false;
            Map.Entry it5 = entry2;
            boolean bl3 = false;
            if ((it5.getValue() instanceof ColumnWidth.Fixed ? (Integer)it5.getKey() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List fixedIdxs = (List)destination$iv$iv;
        Map<Integer, ColumnWidth> $this$mapNotNull$iv2 = this.columnStyles;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Iterable<Integer> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv2.entrySet().iterator();
        while (iterator3.hasNext()) {
            Integer it$iv$iv;
            Map.Entry entry;
            Map.Entry element$iv$iv = entry = iterator3.next();
            boolean bl = false;
            Map.Entry it6 = element$iv$iv;
            boolean bl5 = false;
            if ((it6.getValue() instanceof ColumnWidth.Expand ? (Integer)it6.getKey() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List expandIdxs = (List)destination$iv$iv2;
        Iterable $this$mapNotNull$iv3 = RangesKt.until(0, this.columnCount);
        boolean $i$f$mapNotNull2232 = false;
        destination$iv$iv2 = $this$mapNotNull$iv3;
        Collection destination$iv$iv32422 = new ArrayList();
        boolean $i$f$mapNotNullTo222322 = false;
        void $this$forEach$iv$iv$iv322 = $this$mapNotNullTo$iv$iv32422;
        boolean bl = false;
        Iterator iterator4 = $this$forEach$iv$iv$iv322.iterator();
        while (iterator4.hasNext()) {
            Integer it$iv$iv;
            boolean bl2;
            int element$iv$iv$iv4;
            int element$iv$iv = element$iv$iv$iv4 = ((IntIterator)iterator4).nextInt();
            boolean bl7 = false;
            int i = element$iv$iv;
            boolean bl8 = false;
            if (this.columnStyles.get(i) != null) {
                ColumnWidth it7;
                n3 = 0;
                bl2 = !(it7 instanceof ColumnWidth.Auto);
            } else {
                bl2 = false;
            }
            if ((bl2 ? null : Integer.valueOf(i)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl9 = false;
            destination$iv$iv32422.add(it$iv$iv);
        }
        List autoIdxs = (List)destination$iv$iv32422;
        Iterable $i$f$mapNotNull2232 = autoIdxs;
        int $this$mapNotNullTo$iv$iv32422 = 0;
        for (Object $i$f$mapNotNullTo222322 : $i$f$mapNotNull2232) {
            void it8;
            int $this$forEach$iv$iv$iv322 = ((Number)$i$f$mapNotNullTo222322).intValue();
            int n10 = $this$mapNotNullTo$iv$iv32422;
            boolean bl3 = false;
            n = ((WidthRange)measurements.get((int)it8)).getMax();
            $this$mapNotNullTo$iv$iv32422 = n10 + n;
        }
        int maxAutoWidth = $this$mapNotNullTo$iv$iv32422;
        Iterable $this$mapNotNullTo$iv$iv32422 = autoIdxs;
        int destination$iv$iv32422 = 0;
        for (Object it8 : $this$mapNotNullTo$iv$iv32422) {
            int n2 = ((Number)it8).intValue();
            int n11 = destination$iv$iv32422;
            boolean bl4 = false;
            n = ((WidthRange)measurements.get(n2)).getMin();
            destination$iv$iv32422 = n11 + n;
        }
        int minAutoWidth = destination$iv$iv32422;
        Iterable destination$iv$iv32422 = fixedIdxs;
        int $i$f$mapNotNullTo222322 = 0;
        for (Object t2 : destination$iv$iv32422) {
            int n4 = ((Number)t2).intValue();
            int n12 = $i$f$mapNotNullTo222322;
            boolean bl10 = false;
            n = ((WidthRange)measurements.get(n4)).getMax();
            $i$f$mapNotNullTo222322 = n12 + n;
        }
        int maxFixedWidth = $i$f$mapNotNullTo222322;
        Iterable $i$f$mapNotNullTo222322 = expandIdxs;
        int it8 = 0;
        for (Object t3 : $i$f$mapNotNullTo222322) {
            void it11;
            int bl10 = ((Number)t3).intValue();
            int n13 = it8;
            boolean bl5 = false;
            n = ((WidthRange)measurements.get((int)it11)).getMin();
            it8 = n13 + n;
        }
        int minExpandWidth = it8;
        int allocatedFixedWidth = Math.min(maxFixedWidth, availableWidth);
        int allocatedAutoWidth = RangesKt.coerceAtMost(RangesKt.coerceIn(availableWidth - allocatedFixedWidth - minExpandWidth, minAutoWidth, maxAutoWidth), availableWidth - allocatedFixedWidth);
        int n5 = availableWidth - allocatedFixedWidth - allocatedAutoWidth;
        Iterable iterable2 = fixedIdxs;
        List list = fixedIdxs;
        List list2 = widths;
        Object object = this;
        boolean $i$f$map = false;
        Iterable bl5 = iterable2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            n3 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv4;
            boolean bl11 = false;
            collection.add(Float.valueOf(1.0f));
        }
        collection = (List)destination$iv$iv4;
        TableImpl.calculateColumnWidths$setWeights((TableImpl)object, list2, list, (List<Float>)collection, allocatedFixedWidth, maxFixedWidth);
        Iterable iterable3 = expandIdxs;
        list = expandIdxs;
        list2 = widths;
        object = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = iterable3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable3, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv3;
            boolean bl12 = false;
            ColumnWidth columnWidth = this.columnStyles.get(it);
            Intrinsics.checkNotNull(columnWidth, "null cannot be cast to non-null type com.github.ajalt.mordant.table.ColumnWidth.Expand");
            collection.add(Float.valueOf(((ColumnWidth.Expand)columnWidth).getWeight()));
        }
        collection = (List)destination$iv$iv3;
        TableImpl.calculateColumnWidths$setWeights$default((TableImpl)object, list2, list, collection, n5, 0, 32, null);
        if (allocatedAutoWidth > minAutoWidth) {
            Iterator $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = autoIdxs;
            boolean $i$f$map2 = false;
            destination$iv$iv3 = $this$map$iv2;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo32 = false;
            Iterator item$iv$iv = $this$mapTo$iv$iv2.iterator();
            while (item$iv$iv.hasNext()) {
                void it12;
                Object item$iv$iv2 = item$iv$iv.next();
                int bl12 = ((Number)item$iv$iv2).intValue();
                object = destination$iv$iv5;
                boolean bl13 = false;
                object.add(Float.valueOf(((WidthRange)measurements.get((int)it12)).getMax() - ((WidthRange)measurements.get((int)it12)).getMin()));
            }
            List list3 = (List)destination$iv$iv5;
            TableImpl.calculateColumnWidths$setWeights(this, widths, autoIdxs, list3, allocatedAutoWidth - minAutoWidth, maxAutoWidth);
            Iterable $this$forEach$iv = autoIdxs;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv) {
                int it13 = ((Number)element$iv).intValue();
                boolean bl14 = false;
                widths.set(it13, ((Number)widths.get(it13)).intValue() + ((WidthRange)measurements.get(it13)).getMin());
            }
        } else {
            Iterable iterable4 = autoIdxs;
            list = autoIdxs;
            list2 = widths;
            object = this;
            $i$f$map = false;
            Iterable $i$f$forEach4 = iterable4;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable4, 10));
            $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                int item$iv$iv2 = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv3;
                boolean bl15 = false;
                collection.add(Float.valueOf(((Number)widths.get(it)).intValue()));
            }
            collection = (List)destination$iv$iv3;
            TableImpl.calculateColumnWidths$setWeights((TableImpl)object, list2, list, collection, allocatedAutoWidth, maxAutoWidth);
        }
        return widths;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> distributeWidths(List<Float> weights, int totalWidth) {
        void destination$iv;
        void $this$mapTo$iv;
        if (totalWidth == 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = weights;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                float f = ((Number)item$iv$iv).floatValue();
                Collection collection = destination$iv$iv22;
                boolean bl = false;
                collection.add(0);
            }
            return (List)destination$iv$iv22;
        }
        Iterable $this$mapTo$iv$iv = weights;
        double destination$iv$iv22 = 0.0;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            float it = ((Number)item$iv$iv).floatValue();
            double d = destination$iv$iv22;
            boolean bl = false;
            double d2 = it;
            destination$iv$iv22 = d + d2;
        }
        double totalWeight = destination$iv$iv22;
        Iterable destination$iv$iv22 = weights;
        Collection $i$f$mapTo = new ArrayList();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void weight;
            float bl = ((Number)item$iv).floatValue();
            void var13_29 = destination$iv;
            boolean bl2 = false;
            var13_29.add((int)((double)weight / totalWeight * (double)totalWidth));
        }
        List widths = (List)destination$iv;
        int n = totalWidth - CollectionsKt.sumOfInt(widths);
        int n2 = 0;
        while (n2 < n) {
            int i = n2++;
            boolean bl = false;
            widths.set(i, ((Number)widths.get(i)).intValue() + 1);
        }
        return widths;
    }

    private final Cell getCell(int x, int y) {
        List<Cell> list = CollectionsKt.getOrNull(this.rows, y);
        return list != null ? CollectionsKt.getOrNull(list, x) : null;
    }

    private static final void calculateColumnWidths$setWeights(TableImpl this$0, List<Integer> widths, List<Integer> idxs, List<Float> weights, int allocatedWidth, int maxWidth) {
        if (weights.isEmpty() || allocatedWidth == maxWidth) {
            return;
        }
        List<Integer> distributedWidths = this$0.distributeWidths(weights, allocatedWidth);
        for (Pair pair2 : CollectionsKt.zip((Iterable)idxs, (Iterable)distributedWidths)) {
            int i = ((Number)pair2.component1()).intValue();
            int w = ((Number)pair2.component2()).intValue();
            widths.set(i, w);
        }
    }

    static /* synthetic */ void calculateColumnWidths$setWeights$default(TableImpl tableImpl, List list, List list2, List list3, int n, int n2, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            n2 = -1;
        }
        TableImpl.calculateColumnWidths$setWeights(tableImpl, list, list2, list3, n, n2);
    }
}

