/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.files;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/islandoftex/arara/core/files/FileType;", "Lorg/islandoftex/arara/api/files/FileType;", "extension", "", "pattern", "(Ljava/lang/String;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "getPattern", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "core"})
public final class FileType
implements org.islandoftex.arara.api.files.FileType {
    @NotNull
    private final String extension;
    @NotNull
    private final String pattern;

    public FileType(@NotNull String extension, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter(extension, "extension");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this.extension = extension;
        this.pattern = pattern;
        try {
            String string = this.getPattern();
            int n = 0;
            Pattern pattern2 = Pattern.compile(string, n);
            Intrinsics.checkNotNullExpressionValue(pattern2, "compile(this, flags)");
        }
        catch (PatternSyntaxException e) {
            throw new AraraException("The pattern you wanted to choose for this file type is invalid.", e);
        }
    }

    public /* synthetic */ FileType(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "/\\";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        this(string, string2);
    }

    @Override
    @NotNull
    public String getExtension() {
        return this.extension;
    }

    @Override
    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    @NotNull
    public String toString() {
        return Intrinsics.stringPlus(".", this.getExtension());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object == null ? null : object.getClass())) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.islandoftex.arara.api.files.FileType");
        }
        org.islandoftex.arara.api.files.FileType cfr_ignored_0 = (org.islandoftex.arara.api.files.FileType)object2;
        return Intrinsics.areEqual(this.getExtension(), ((org.islandoftex.arara.api.files.FileType)other).getExtension());
    }

    public int hashCode() {
        return this.getExtension().hashCode();
    }

    @Override
    public boolean isUnknown() {
        return FileType.DefaultImpls.isUnknown(this);
    }

    @NotNull
    public final String component1() {
        return this.getExtension();
    }

    @NotNull
    public final String component2() {
        return this.getPattern();
    }

    @NotNull
    public final FileType copy(@NotNull String extension, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter(extension, "extension");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        return new FileType(extension, pattern);
    }

    public static /* synthetic */ FileType copy$default(FileType fileType, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = fileType.getExtension();
        }
        if ((n & 2) != 0) {
            string2 = fileType.getPattern();
        }
        return fileType.copy(string, string2);
    }

    public FileType() {
        this(null, null, 3, null);
    }
}

