/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.configuration;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.Project;
import org.islandoftex.arara.cli.utils.LoggingUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.mvel.configuration.LocalConfiguration;
import org.islandoftex.arara.mvel.utils.MvelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"Lorg/islandoftex/arara/cli/configuration/ConfigurationUtils;", "", "()V", "configFileForProject", "Ljava/nio/file/Path;", "project", "Lorg/islandoftex/arara/api/files/Project;", "load", "", "file", "currentProject", "loadLocalConfiguration", "Lorg/islandoftex/arara/mvel/configuration/LocalConfiguration;", "cli"})
public final class ConfigurationUtils {
    @NotNull
    public static final ConfigurationUtils INSTANCE = new ConfigurationUtils();

    private ConfigurationUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Path configFileForProject(@NotNull Project project) {
        Object object;
        Object v1;
        Path path2;
        Object object2;
        List<String> names2;
        Object object3;
        block8: {
            void $this$firstOrNull$iv;
            Iterator $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(project, "project");
            object3 = new String[]{".araraconfig.yaml", "araraconfig.yaml", ".arararc.yaml", "arararc.yaml"};
            names2 = CollectionsKt.listOf(object3);
            Path workingDir = project.getWorkingDirectory();
            boolean bl = false;
            Iterable $this$map$iv = names2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                String string = (String)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl2 = false;
                path2 = workingDir.resolve((String)it);
                Intrinsics.checkNotNullExpressionValue(path2, "this.resolve(other)");
                object2.add(path2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl3 = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        if ((object3 = (Path)v1) == null) {
            String string = Environment.getSystemPropertyOrNull("user.home");
            if (string == null) {
                object = null;
            } else {
                Object v4;
                block9: {
                    void $this$firstOrNull$iv;
                    void $this$mapTo$iv$iv;
                    Object element$iv;
                    String userHome = string;
                    boolean bl = false;
                    Iterable $this$map$iv = names2;
                    boolean $i$f$map = false;
                    element$iv = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        object2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl4 = false;
                        path2 = Paths.get(userHome, new String[0]);
                        Intrinsics.checkNotNullExpressionValue(path2, "get(userHome)");
                        Path path3 = path2.resolve((String)it);
                        Intrinsics.checkNotNullExpressionValue(path3, "this.resolve(other)");
                        collection.add(path3);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Path it = (Path)element$iv2;
                        boolean bl5 = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                        v4 = element$iv2;
                        break block9;
                    }
                    v4 = null;
                }
                object = v4;
            }
        } else {
            object = object3;
        }
        return object;
    }

    private final LocalConfiguration loadLocalConfiguration(Path file2) throws AraraException {
        if (!StringsKt.endsWith$default(((Object)file2.getFileName()).toString(), ".yaml", false, 2, null)) {
            throw new NotImplementedError(Intrinsics.stringPlus("An operation is not implemented: ", "Kotlin DSL not implemented yet"));
        }
        return LocalConfiguration.Companion.load(file2);
    }

    public final void load(@NotNull Path file2, @NotNull Project currentProject) throws AraraException {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(currentProject, "currentProject");
        LocalConfiguration resource = this.loadLocalConfiguration(file2);
        LinearExecutor.INSTANCE.setExecutionOptions(resource.toExecutionOptions(currentProject, LinearExecutor.INSTANCE.getExecutionOptions()));
        Session.setLoggingOptions(resource.toLoggingOptions(Session.getLoggingOptions()));
        Session.setUserInterfaceOptions(resource.toUserInterfaceOptions(Session.getUserInterfaceOptions()));
        MvelState.INSTANCE.getPreambles().putAll(resource.getPreambles());
        MvelState.INSTANCE.setDefaultPreamble(resource.getDefaultPreamble());
        MvelState.INSTANCE.setPrependPreambleIfDirectivesGiven(resource.getPrependPreambleIfDirectivesGiven());
        LanguageController.setLocale(Session.getUserInterfaceOptions().getLocale());
        LoggingUtils.INSTANCE.setupLogging(Session.getLoggingOptions());
    }
}

