/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.files;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.configuration.ExecutionMode;
import org.islandoftex.arara.api.configuration.ExecutionOptions;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.core.files.FileHandling;
import org.islandoftex.arara.core.files.FileSearching;
import org.islandoftex.arara.core.files.FileTypeKt;
import org.islandoftex.arara.core.files.ProjectFile;
import org.islandoftex.arara.core.localization.LanguageController;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J,\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J'\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/islandoftex/arara/core/files/FileSearching;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "listFilesByExtensions", "", "Ljava/io/File;", "directory", "extensions", "", "recursive", "", "listFilesByPatterns", "patterns", "lookupFile", "Lorg/islandoftex/arara/api/files/ProjectFile;", "reference", "workingDirectory", "Ljava/nio/file/Path;", "executionOptions", "Lorg/islandoftex/arara/api/configuration/ExecutionOptions;", "lookupFile$core", "resolveFile", "core"})
public final class FileSearching {
    private static final Logger logger;
    @NotNull
    public static final FileSearching INSTANCE;

    @JvmStatic
    @NotNull
    public static final List<File> listFilesByExtensions(@NotNull File directory, @NotNull List<String> extensions, boolean recursive) {
        List<File> list;
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        try {
            List<File> list2;
            if (recursive) {
                list = FilesKt.walkTopDown(directory);
                boolean bl = false;
                list2 = SequencesKt.toList(SequencesKt.filter(SequencesKt.filter(list, listFilesByExtensions.1.INSTANCE), (Function1)new Function1<File, Boolean>(extensions){
                    final /* synthetic */ List $extensions;

                    public final boolean invoke(@NotNull File it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$extensions.contains(FilesKt.getExtension(it));
                    }
                    {
                        this.$extensions = list;
                        super(1);
                    }
                }));
            } else {
                File[] fileArray = directory.listFiles(new FileFilter(extensions){
                    final /* synthetic */ List $extensions;

                    public final boolean accept(File it) {
                        File file2 = it;
                        Intrinsics.checkNotNullExpressionValue(file2, "it");
                        return this.$extensions.contains(FilesKt.getExtension(file2));
                    }
                    {
                        this.$extensions = list;
                    }
                });
                Intrinsics.checkNotNull(fileArray);
                list2 = ArraysKt.toList(fileArray);
            }
            list = list2;
        }
        catch (Exception _) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<File> listFilesByPatterns(@NotNull File directory, @NotNull List<String> patterns, boolean recursive) {
        List<File> list;
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(patterns, "patterns");
        try {
            List<File> list2;
            void $this$mapTo$iv$iv;
            Object $this$map$iv = patterns;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + (String)it);
                collection.add(pathMatcher);
            }
            List pathMatcher = (List)destination$iv$iv;
            if (recursive) {
                $this$map$iv = FilesKt.walkTopDown(directory);
                boolean bl = false;
                list2 = SequencesKt.toList(SequencesKt.filter(SequencesKt.filter($this$map$iv, listFilesByPatterns.1.INSTANCE), (Function1)new Function1<File, Boolean>(pathMatcher){
                    final /* synthetic */ List $pathMatcher;

                    public final boolean invoke(@NotNull File file2) {
                        boolean bl;
                        block3: {
                            Intrinsics.checkNotNullParameter(file2, "file");
                            Iterable $this$any$iv = this.$pathMatcher;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    PathMatcher it = (PathMatcher)element$iv;
                                    boolean bl2 = false;
                                    Path path2 = file2.toPath();
                                    Intrinsics.checkNotNullExpressionValue(path2, "file.toPath()");
                                    if (!it.matches(path2.getFileName())) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }
                    {
                        this.$pathMatcher = list;
                        super(1);
                    }
                }));
            } else {
                File[] fileArray = directory.listFiles(new FileFilter(pathMatcher){
                    final /* synthetic */ List $pathMatcher;

                    public final boolean accept(@NotNull File file2) {
                        boolean bl;
                        block3: {
                            Intrinsics.checkNotNullParameter(file2, "file");
                            Iterable $this$any$iv = this.$pathMatcher;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    PathMatcher it = (PathMatcher)element$iv;
                                    boolean bl2 = false;
                                    Path path2 = file2.toPath();
                                    Intrinsics.checkNotNullExpressionValue(path2, "file.toPath()");
                                    if (!it.matches(path2.getFileName())) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }
                    {
                        this.$pathMatcher = list;
                    }
                });
                Intrinsics.checkNotNull(fileArray);
                list2 = ArraysKt.toList(fileArray);
            }
            list = list2;
        }
        catch (Exception _) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final org.islandoftex.arara.api.files.ProjectFile resolveFile(@NotNull String reference, @NotNull Path workingDirectory, @NotNull ExecutionOptions executionOptions) throws AraraException {
        Intrinsics.checkNotNullParameter(reference, "reference");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(executionOptions, "executionOptions");
        org.islandoftex.arara.api.files.ProjectFile projectFile = INSTANCE.lookupFile$core(reference, workingDirectory, executionOptions);
        if (projectFile == null) {
            String string = LanguageController.getMessages().getERROR_DISCOVERFILE_FILE_NOT_FOUND();
            Object[] objectArray = new Object[]{reference, CollectionsKt.joinToString$default(executionOptions.getFileTypes(), " | ", "[ ", " ]", 0, null, null, 56, null)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(this, *args)");
            throw (Throwable)new AraraException(string2);
        }
        return projectFile;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final org.islandoftex.arara.api.files.ProjectFile lookupFile$core(@NotNull String reference, @NotNull Path workingDirectory, @NotNull ExecutionOptions executionOptions) throws AraraException {
        block20: {
            block17: {
                block21: {
                    block19: {
                        block15: {
                            Intrinsics.checkNotNullParameter(reference, "reference");
                            Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
                            Intrinsics.checkNotNullParameter(executionOptions, "executionOptions");
                            types = executionOptions.getFileTypes();
                            var6_5 = workingDirectory;
                            var7_6 = false;
                            v0 = var6_5.resolve(reference);
                            Intrinsics.checkNotNullExpressionValue(v0, "this.resolve(other)");
                            testFile = FileHandling.normalize(v0);
                            var6_5 = testFile;
                            var7_7 = new LinkOption[]{};
                            var8_10 = false;
                            if (!Files.exists(var6_5, Arrays.copyOf(var7_7, ((LinkOption[])var7_7).length))) break block19;
                            var6_5 = testFile;
                            var7_7 = new LinkOption[]{};
                            var8_10 = false;
                            if (!Files.isRegularFile(var6_5, Arrays.copyOf(var7_7, ((LinkOption[])var7_7).length))) break block19;
                            $this$firstOrNull$iv = types;
                            $i$f$firstOrNull = false;
                            var8_11 = $this$firstOrNull$iv.iterator();
                            while (var8_11.hasNext()) {
                                element$iv = var8_11.next();
                                it = (FileType)element$iv;
                                $i$a$-firstOrNull-FileSearching$lookupFile$1 = false;
                                if (!StringsKt.endsWith$default(reference, "." + it.getExtension(), false, 2, null)) continue;
                                v1 = element$iv;
                                break block15;
                            }
                            v1 = null;
                        }
                        v2 = v1;
                        if (v2 != null) {
                            block16: {
                                $this$firstOrNull$iv = v2;
                                $i$f$firstOrNull = false;
                                var8_12 = false;
                                it = $this$firstOrNull$iv;
                                $i$a$-let-FileSearching$lookupFile$2 = false;
                                extension = StringsKt.substringAfterLast$default(reference, '.', null, 2, null);
                                var12_24 = types;
                                var13_28 = testFile;
                                $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    it = (FileType)element$iv;
                                    $i$a$-firstOrNull-FileSearching$lookupFile$2$1 = false;
                                    if (!Intrinsics.areEqual(extension, it.getExtension())) continue;
                                    v3 = element$iv;
                                    break block16;
                                }
                                v3 = var21_42 = null;
                            }
                            if ((v4 = (FileType)var21_42) == null) {
                                v4 = FileTypeKt.getUNKNOWN_TYPE(FileType.Companion);
                            }
                            var26_44 = null;
                            var27_45 = 4;
                            var28_46 = 0;
                            var29_47 = v4;
                            var30_48 = var13_28;
                            v5 = new ProjectFile(var30_48, var29_47, var28_46, var27_45, var26_44);
                        } else {
                            v5 = null;
                        }
                        v6 = v5;
                        break block20;
                    }
                    if (executionOptions.getExecutionMode() != ExecutionMode.SAFE_RUN) break block21;
                    FileSearching.logger.info("Skipping indirect file search with extension completion due to safe mode restrictions.");
                    v6 = null;
                    break block20;
                }
                name = testFile.getFileName().toString();
                $this$map$iv = types;
                $i$f$map = false;
                it = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var14_49 /* !! */  = (LinkOption[])item$iv$iv /* !! */ ;
                    var23_51 = destination$iv$iv;
                    $i$a$-map-FileSearching$lookupFile$3 = false;
                    Intrinsics.checkNotNullExpressionValue(testFile.getParent(), "testFile.parent");
                    var17_33 = name + '.' + it.getExtension();
                    var18_36 = false;
                    Intrinsics.checkNotNullExpressionValue(var16_31.resolve(var17_33), "this.resolve(other)");
                    var23_51.add(var24_52);
                }
                $this$map$iv = types;
                var23_51 = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (FileType)item$iv$iv /* !! */ ;
                    var24_52 = destination$iv$iv;
                    $i$a$-map-FileSearching$lookupFile$4 = false;
                    Intrinsics.checkNotNullExpressionValue(testFile.getParent(), "testFile.parent");
                    var17_33 = StringsKt.removeSuffix(name, (CharSequence)".");
                    var18_36 = false;
                    v7 = var17_33;
                    if (v7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    var17_33 = StringsKt.trim((CharSequence)v7).toString() + '.' + it.getExtension();
                    var18_36 = false;
                    Intrinsics.checkNotNullExpressionValue(var16_31.resolve(var17_33), "this.resolve(other)");
                    var24_52.add(var25_53);
                }
                var24_52 = (List)destination$iv$iv;
                $this$map$iv = CollectionsKt.union(var23_51, (Iterable)var24_52);
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Path)element$iv;
                    $i$a$-firstOrNull-FileSearching$lookupFile$5 = false;
                    item$iv$iv /* !! */  = it;
                    var14_49 /* !! */  = new LinkOption[]{};
                    var15_50 = false;
                    if (!Files.exists(item$iv$iv /* !! */ , Arrays.copyOf(var14_49 /* !! */ , var14_49 /* !! */ .length))) ** GOTO lbl-1000
                    item$iv$iv /* !! */  = it;
                    var14_49 /* !! */  = new LinkOption[]{};
                    var15_50 = false;
                    if (Files.isRegularFile(item$iv$iv /* !! */ , Arrays.copyOf(var14_49 /* !! */ , var14_49 /* !! */ .length))) {
                        v8 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = false;
                    }
                    if (!v8) continue;
                    v9 = element$iv;
                    break block17;
                }
                v9 = null;
            }
            v10 = v9;
            if (v10 != null) {
                block18: {
                    var7_7 = v10;
                    var8_10 = false;
                    var9_15 = false;
                    found = var7_7;
                    $i$a$-let-FileSearching$lookupFile$6 = false;
                    extension = StringsKt.substringAfterLast$default(found.toString(), '.', null, 2, null);
                    item$iv$iv /* !! */  = types;
                    var14_49 /* !! */  = found;
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (FileType)element$iv;
                        $i$a$-firstOrNull-FileSearching$lookupFile$6$1 = false;
                        if (!Intrinsics.areEqual(extension, it.getExtension())) continue;
                        v11 = element$iv;
                        break block18;
                    }
                    v11 = var22_54 = null;
                }
                if ((v12 = (FileType)var22_54) == null) {
                    v12 = FileTypeKt.getUNKNOWN_TYPE(FileType.Companion);
                }
                var31_55 = null;
                var32_56 = 4;
                var33_57 = 0;
                var34_58 = v12;
                var35_59 /* !! */  = var14_49 /* !! */ ;
                v13 = new ProjectFile((Path)var35_59 /* !! */ , var34_58, var33_57, var32_56, var31_55);
            } else {
                v13 = null;
            }
            v6 = v13;
        }
        return v6;
    }

    private FileSearching() {
    }

    static {
        FileSearching fileSearching;
        INSTANCE = fileSearching = new FileSearching();
        logger = LoggerFactory.getLogger(FileSearching.class);
    }
}

