/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.ruleset;

import com.charleskorn.kaml.Yaml;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.ruleset.Argument;
import org.islandoftex.arara.ruleset.Rule;
import org.islandoftex.arara.ruleset.RuleCommand;
import org.islandoftex.arara.utils.CommonUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/islandoftex/arara/ruleset/RuleUtils;", "", "()V", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "parseRule", "Lorg/islandoftex/arara/ruleset/Rule;", "file", "Ljava/io/File;", "identifier", "", "validateBody", "", "rule", "validateHeader", "application"})
public final class RuleUtils {
    private static final LanguageController messages;
    public static final RuleUtils INSTANCE;

    @NotNull
    public final Rule parseRule(@NotNull File file2, @NotNull String identifier) throws AraraException {
        Object object;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(identifier, "identifier");
        Object object2 = file2;
        boolean bl = false;
        try {
            object = Result.Companion;
            Object $this$runCatching = object2;
            boolean bl2 = false;
            String text2 = FilesKt.readText$default((File)$this$runCatching, null, 1, null);
            if (!StringsKt.startsWith$default(text2, "!config", false, 2, null)) {
                throw (Throwable)new Exception("Rule should start with !config");
            }
            $this$runCatching = (Rule)Yaml.Companion.getDefault().parse(Rule.Companion.serializer(), text2);
            bl2 = false;
            object = Result.constructor-impl($this$runCatching);
        }
        catch (Throwable $this$runCatching) {
            Result.Companion bl2 = Result.Companion;
            boolean bl3 = false;
            object = Result.constructor-impl(ResultKt.createFailure($this$runCatching));
        }
        object2 = object;
        bl = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl5 = false;
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_PARSERULE_GENERIC_ERROR), it);
        }
        Rule rule = (Rule)object2;
        this.validateHeader(rule, identifier);
        this.validateBody(rule);
        return rule;
    }

    private final void validateHeader(Rule rule, String identifier) throws AraraException {
        if (Intrinsics.areEqual(rule.getIdentifier(), "INVALID_RULE") ^ true) {
            if (Intrinsics.areEqual(rule.getIdentifier(), identifier) ^ true) {
                throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_VALIDATEHEADER_WRONG_IDENTIFIER, rule.getIdentifier(), identifier));
            }
        } else {
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_VALIDATEHEADER_NULL_ID));
        }
        if (Intrinsics.areEqual(rule.getName(), "INVALID_RULE")) {
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_VALIDATEHEADER_NULL_NAME));
        }
    }

    private final void validateBody(Rule rule) throws AraraException {
        int found;
        boolean bl;
        boolean $i$f$any;
        block10: {
            Iterable $this$any$iv = rule.getCommands();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RuleCommand it = (RuleCommand)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCommand() == null)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_VALIDATEBODY_NULL_COMMAND));
        }
        $i$f$any = false;
        List arguments2 = new ArrayList();
        for (Argument argument2 : rule.getArguments()) {
            if (argument2.getIdentifier() != null) {
                if (argument2.getFlag() != null || argument2.getDefault() != null) {
                    String string = argument2.getIdentifier();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    arguments2.add(string);
                    continue;
                }
                throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_VALIDATEBODY_MISSING_KEYS));
            }
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_VALIDATEBODY_NULL_ARGUMENT_ID));
        }
        Iterable $this$forEach$iv = CollectionsKt.intersect(arguments2, (Iterable)CollectionsKt.listOf("files", "reference"));
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        if (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String it = (String)element$iv;
            boolean bl3 = false;
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_VALIDATEBODY_ARGUMENT_ID_IS_RESERVED, it));
        }
        int expected = arguments2.size();
        if (expected != (found = CollectionsKt.toSet(arguments2).size())) {
            throw (Throwable)new AraraException(CommonUtils.INSTANCE.getRuleErrorHeader() + messages.getMessage((Enum)Messages.ERROR_VALIDATEBODY_DUPLICATE_ARGUMENT_IDENTIFIERS));
        }
    }

    private RuleUtils() {
    }

    static {
        RuleUtils ruleUtils;
        INSTANCE = ruleUtils = new RuleUtils();
        messages = LanguageController.INSTANCE;
    }
}

