/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.SerialKind;
import kotlinx.serialization.StructureKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\f\u0082\u0001\u0003\u001d\u001e\u001f\u00a8\u0006 "}, d2={"Lkotlinx/serialization/internal/MapLikeDescriptor;", "Lkotlinx/serialization/SerialDescriptor;", "name", "", "keyDescriptor", "valueDescriptor", "(Ljava/lang/String;Lkotlinx/serialization/SerialDescriptor;Lkotlinx/serialization/SerialDescriptor;)V", "elementsCount", "", "getElementsCount", "()I", "getKeyDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "kind", "Lkotlinx/serialization/SerialKind;", "getKind", "()Lkotlinx/serialization/SerialKind;", "getName", "()Ljava/lang/String;", "getValueDescriptor", "equals", "", "other", "", "getElementDescriptor", "index", "getElementIndex", "getElementName", "hashCode", "Lkotlinx/serialization/internal/NamedMapClassDescriptor;", "Lkotlinx/serialization/internal/LinkedHashMapClassDesc;", "Lkotlinx/serialization/internal/HashMapClassDesc;", "kotlinx-serialization-runtime"})
public abstract class MapLikeDescriptor
implements SerialDescriptor {
    private final int elementsCount;
    @NotNull
    private final String name;
    @NotNull
    private final SerialDescriptor keyDescriptor;
    @NotNull
    private final SerialDescriptor valueDescriptor;

    @Override
    @NotNull
    public SerialKind getKind() {
        return StructureKind.MAP.INSTANCE;
    }

    @Override
    public int getElementsCount() {
        return this.elementsCount;
    }

    @Override
    @NotNull
    public String getElementName(int index) {
        return String.valueOf(index);
    }

    @Override
    public int getElementIndex(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Integer n = StringsKt.toIntOrNull(name);
        if (n == null) {
            throw (Throwable)new IllegalArgumentException(name + " is not a valid map index");
        }
        return n;
    }

    @Override
    @NotNull
    public SerialDescriptor getElementDescriptor(int index) {
        return index % 2 == 0 ? this.keyDescriptor : this.valueDescriptor;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MapLikeDescriptor)) {
            return false;
        }
        if (Intrinsics.areEqual(this.getName(), ((MapLikeDescriptor)other).getName()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual(this.keyDescriptor, ((MapLikeDescriptor)other).keyDescriptor) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.valueDescriptor, ((MapLikeDescriptor)other).valueDescriptor) ^ true);
    }

    public int hashCode() {
        int result2 = this.getName().hashCode();
        result2 = 31 * result2 + this.keyDescriptor.hashCode();
        result2 = 31 * result2 + this.valueDescriptor.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final SerialDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    @NotNull
    public final SerialDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    private MapLikeDescriptor(String name, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor) {
        this.name = name;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.elementsCount = 2;
    }

    @Override
    @NotNull
    public List<Annotation> getEntityAnnotations() {
        return SerialDescriptor.DefaultImpls.getEntityAnnotations(this);
    }

    @Override
    @NotNull
    public List<Annotation> getElementAnnotations(int index) {
        return SerialDescriptor.DefaultImpls.getElementAnnotations(this, index);
    }

    @Override
    public boolean isNullable() {
        return SerialDescriptor.DefaultImpls.isNullable(this);
    }

    @Override
    public boolean isElementOptional(int index) {
        return SerialDescriptor.DefaultImpls.isElementOptional(this, index);
    }

    public /* synthetic */ MapLikeDescriptor(String name, SerialDescriptor keyDescriptor, SerialDescriptor valueDescriptor, DefaultConstructorMarker $constructor_marker) {
        this(name, keyDescriptor, valueDescriptor);
    }
}

