/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Decoder;
import kotlinx.serialization.Encoder;
import kotlinx.serialization.InternalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.internal.EnumDescriptor;
import org.jetbrains.annotations.NotNull;

@InternalSerializationApi
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lkotlinx/serialization/internal/CommonEnumSerializer;", "T", "Lkotlinx/serialization/KSerializer;", "serialName", "", "values", "", "valuesNames", "(Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/String;)V", "descriptor", "Lkotlinx/serialization/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/SerialDescriptor;", "getValues", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "deserialize", "decoder", "Lkotlinx/serialization/Decoder;", "(Lkotlinx/serialization/Decoder;)Ljava/lang/Object;", "serialize", "", "encoder", "Lkotlinx/serialization/Encoder;", "obj", "(Lkotlinx/serialization/Encoder;Ljava/lang/Object;)V", "kotlinx-serialization-runtime"})
public class CommonEnumSerializer<T>
implements KSerializer<T> {
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final T[] values;

    @Override
    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final void serialize(@NotNull Encoder encoder2, T obj) {
        Intrinsics.checkParameterIsNotNull(encoder2, "encoder");
        int index = ArraysKt.indexOf(this.values, obj);
        boolean bl = index != -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            Object[] objectArray = this.values;
            StringBuilder stringBuilder = new StringBuilder().append(obj).append(" is not a valid enum ").append(this.getDescriptor().getName()).append(", must be one of ");
            boolean bl5 = false;
            String string = Arrays.toString(objectArray);
            Intrinsics.checkExpressionValueIsNotNull(string, "java.util.Arrays.toString(this)");
            String string2 = string;
            String string3 = stringBuilder.append(string2).toString();
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        encoder2.encodeEnum(this.getDescriptor(), index);
    }

    @Override
    public final T deserialize(@NotNull Decoder decoder2) {
        Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
        int index = decoder2.decodeEnum(this.getDescriptor());
        int n = index;
        n = 0 <= n && this.values.length > n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = index + " is not among valid $" + this.getDescriptor().getName() + " enum values, values size is " + this.values.length;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.values[index];
    }

    @NotNull
    public final T[] getValues() {
        return this.values;
    }

    public CommonEnumSerializer(@NotNull String serialName, @NotNull T[] values2, @NotNull String[] valuesNames) {
        Intrinsics.checkParameterIsNotNull(serialName, "serialName");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        Intrinsics.checkParameterIsNotNull(valuesNames, "valuesNames");
        this.values = values2;
        this.descriptor = new EnumDescriptor(serialName, valuesNames);
    }

    @Override
    public T patch(@NotNull Decoder decoder2, T old) {
        Intrinsics.checkParameterIsNotNull(decoder2, "decoder");
        return KSerializer.DefaultImpls.patch(this, decoder2, old);
    }
}

