/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.InternalQuantity;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.MidControlSequence;
import com.dickimawbooks.texparserlib.NumericExpansion;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.SkippedEols;
import com.dickimawbooks.texparserlib.SkippedSpaces;
import com.dickimawbooks.texparserlib.StackMarker;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXGlue;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.primitives.EndCs;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import com.dickimawbooks.texparserlib.primitives.Unexpanded;
import java.io.IOException;
import java.util.Vector;

public class TeXObjectList
extends Vector<TeXObject>
implements TeXObject,
Expandable,
CaseChangeable {
    private Vector<Declaration> declarations = new Vector();
    private long stackID = -1L;
    private static long currentStackID = 0L;
    public static byte POP_SHORT = 1;
    public static byte POP_RETAIN_IGNOREABLES = (byte)2;
    public static byte POP_IGNORE_LEADING_SPACE = (byte)4;

    public TeXObjectList() {
        this.assignStackID();
    }

    public TeXObjectList(int n) {
        super(n);
        this.assignStackID();
    }

    private void assignStackID() {
        if (this.isStack()) {
            this.stackID = currentStackID++;
        }
    }

    public TeXObjectList(TeXParserListener teXParserListener, String string) {
        this(string != null && string.length() > 0 ? string.length() : 10);
        if (string != null) {
            int n;
            int n2 = string.length();
            for (int i = 0; i < n2; i += Character.charCount(n)) {
                n = string.codePointAt(i);
                this.add(teXParserListener.getOther(n));
            }
        }
    }

    public TeXObject expandedPopStack(TeXParser teXParser) throws IOException {
        return this.expandedPopStack(teXParser, (byte)0);
    }

    public TeXObject expandedPopStack(TeXParser teXParser, byte by) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject;
        if (this.size() == 0) {
            return null;
        }
        this.flatten();
        TeXObject teXObject2 = this.popStack(teXParser, by);
        if (teXObject2 == null) {
            return null;
        }
        if (TeXObjectList.isIgnoreLeadingSpace(by)) {
            by = (byte)(by ^ POP_IGNORE_LEADING_SPACE);
        }
        if ((teXObject2 = TeXParserUtils.resolve(teXObject2, teXParser)) instanceof EndCs || teXObject2 instanceof InternalQuantity || !teXObject2.canExpand()) {
            return teXObject2;
        }
        if (teXObject2 instanceof Group) {
            teXObject = (Group)teXObject2;
            teXObjectList = ((Group)teXObject).expandfully(teXParser, this);
            BgChar bgChar = teXParser.isBeginGroup((TeXObject)teXObjectList.get(0));
            if (bgChar != null) {
                teXObjectList.pop();
                teXObject = bgChar.createGroup(teXParser);
                teXObjectList.popRemainingGroup(teXParser, (Group)teXObject, by, bgChar);
                if (!teXObjectList.isEmpty()) {
                    this.push(teXObjectList, true);
                }
                return teXObject;
            }
            this.push(teXObjectList, true);
            teXObject2 = this.popStack(teXParser, by);
        }
        if ((teXObject = teXParser.isBeginGroup(teXObject2)) != null) {
            teXObjectList = ((BgChar)teXObject).createGroup(teXParser);
            this.popRemainingGroup(teXParser, (Group)teXObjectList, by, (BgChar)teXObject);
            return teXObjectList;
        }
        if (teXObject2 instanceof NumericExpansion) {
            return ((NumericExpansion)teXObject2).expandToNumber(teXParser, this);
        }
        if (!(teXObject2 instanceof Expandable)) {
            return teXObject2;
        }
        teXObjectList = ((Expandable)((Object)teXObject2)).expandfully(teXParser, this);
        if (teXObjectList == null) {
            return teXObject2;
        }
        this.push(teXObjectList, true);
        teXObject2 = this.popStack(teXParser, by);
        teXObject2 = TeXParserUtils.resolve(teXObject2, teXParser);
        return teXObject2;
    }

    public TeXObject popStack(TeXParser teXParser) throws IOException {
        return this.popStack(teXParser, (byte)0);
    }

    public TeXObject popStack(TeXParser teXParser, byte by) throws IOException {
        TeXObject teXObject;
        boolean bl = !TeXObjectList.isRetainIgnoreables(by);
        boolean bl2 = TeXObjectList.isIgnoreLeadingSpace(by);
        if (bl && bl2) {
            while (this.size() > 0 && ((teXObject = (TeXObject)this.get(0)) instanceof Ignoreable || teXObject instanceof WhiteSpace)) {
                this.pop();
            }
        } else if (bl) {
            while (this.size() > 0 && this.get(0) instanceof Ignoreable) {
                this.pop();
            }
        } else if (bl2) {
            while (this.size() > 0 && this.get(0) instanceof WhiteSpace) {
                this.pop();
            }
        }
        if (this.size() == 0) {
            return null;
        }
        if (TeXObjectList.isIgnoreLeadingSpace(by)) {
            by = (byte)(by ^ POP_IGNORE_LEADING_SPACE);
        }
        teXObject = this.pop();
        if (TeXObjectList.isShort(by) && teXObject.isPar()) {
            throw new TeXSyntaxException(teXParser, "tex.error.par_before_eg", new Object[0]);
        }
        BgChar bgChar = null;
        if (teXParser != null) {
            bgChar = teXParser.isBeginGroup(teXObject);
        }
        if (bgChar != null) {
            Group group = bgChar.createGroup(teXParser);
            this.popRemainingGroup(teXParser, group, by, bgChar);
            return group;
        }
        return teXObject;
    }

    public TeXObject popToken() throws IOException {
        return this.popToken((byte)0);
    }

    public TeXObject popToken(byte by) throws IOException {
        boolean bl = TeXObjectList.isRetainIgnoreables(by);
        boolean bl2 = TeXObjectList.isIgnoreLeadingSpace(by);
        if (!bl && bl2) {
            TeXObject teXObject;
            while (this.size() > 0 && ((teXObject = (TeXObject)this.get(0)) instanceof Ignoreable || teXObject instanceof WhiteSpace)) {
                this.pop();
            }
        } else if (bl2) {
            TeXObject teXObject;
            while (this.size() > 0 && ((teXObject = (TeXObject)this.get(0)) instanceof WhiteSpace || teXObject instanceof SkippedSpaces || teXObject instanceof SkippedEols)) {
                this.pop();
            }
        } else if (!bl) {
            while (this.size() > 0 && this.get(0) instanceof Ignoreable) {
                this.pop();
            }
        }
        if (this.size() == 0) {
            return null;
        }
        return this.pop();
    }

    public TeXObject pop() throws IOException {
        if (this.isEmpty()) {
            return null;
        }
        return (TeXObject)this.remove(0);
    }

    public void popLeadingWhiteSpace() {
        if (this.isEmpty()) {
            return;
        }
        TeXObject teXObject = (TeXObject)this.get(0);
        if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) {
            this.remove(0);
            this.popLeadingWhiteSpace();
        }
    }

    public TeXObjectList popToGroup(TeXParser teXParser, byte by) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        while (true) {
            if (this.size() == 0) {
                throw new TeXSyntaxException(teXParser, "tex.error.syntax", this.toString(teXParser));
            }
            TeXObject teXObject = (TeXObject)this.firstElement();
            BgChar bgChar = teXParser.isBeginGroup(teXObject);
            if (teXObject instanceof Group || bgChar != null) break;
            teXObject = this.pop();
            if (!TeXObjectList.isRetainIgnoreables(by) && teXObject instanceof Ignoreable) {
                teXParser.getListener().skipping((Ignoreable)teXObject);
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public boolean popCsMarker(TeXParser teXParser, String string) throws IOException {
        return this.popCsMarker(teXParser, string, (byte)0);
    }

    public boolean popCsMarker(TeXParser teXParser, String string, byte by) throws IOException {
        TeXObject teXObject = this.popToken(by);
        if (teXObject == null) {
            return false;
        }
        if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).getName().equals(string)) {
            throw new TeXSyntaxException(teXParser, "tex.error.not_found", String.format("%s%s", new String(Character.toChars(teXParser.getEscChar())), string));
        }
        return true;
    }

    public TeXObjectList popToCsMarker(TeXParser teXParser, String string) throws IOException {
        return this.popToCsMarker(teXParser, string, (byte)0);
    }

    public TeXObjectList popToCsMarker(TeXParser teXParser, String string, byte by) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        TeXObject teXObject = this.popToken(by);
        if (TeXObjectList.isIgnoreLeadingSpace(by)) {
            by = (byte)(by ^ POP_IGNORE_LEADING_SPACE);
        }
        while (teXObject != null) {
            if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals(string)) {
                return teXObjectList;
            }
            teXObjectList.add(teXObject);
            teXObject = this.popToken(by);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.not_found", String.format("%s%s", new String(Character.toChars(teXParser.getEscChar())), string));
    }

    public String popWord(TeXParser teXParser) throws IOException {
        int n;
        TeXObject teXObject;
        StringBuilder stringBuilder = new StringBuilder();
        byte by = (byte)(POP_SHORT | POP_IGNORE_LEADING_SPACE);
        while (!this.isEmpty() && (teXObject = this.peekStack(by)) instanceof CharObject && Character.isAlphabetic(n = ((CharObject)teXObject).getCharCode())) {
            stringBuilder.appendCodePoint(n);
            this.popStack(teXParser, by);
            by = POP_SHORT;
        }
        return stringBuilder.toString();
    }

    public TeXUnit popUnit(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, (byte)(POP_SHORT | POP_IGNORE_LEADING_SPACE));
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.missing_unit", new Object[0]);
        }
        if (teXObject instanceof CharObject) {
            int n = ((CharObject)teXObject).getCharCode();
            TeXObject teXObject2 = this.expandedPopStack(teXParser);
            if (teXObject2 == null || !(teXObject2 instanceof CharObject)) {
                this.push(teXObject);
                throw new TeXSyntaxException(teXParser, "tex.error.missing_unit", new Object[0]);
            }
            int n2 = ((CharObject)teXObject2).getCharCode();
            try {
                return teXParser.getListener().createUnit(String.format("%s%s", new String(Character.toChars(n)), new String(Character.toChars(n2))));
            }
            catch (TeXSyntaxException teXSyntaxException) {
                if (n == 102 && n2 == 105) {
                    TeXObject teXObject3 = this.expandedPopStack(teXParser);
                    if (teXObject3 == null || !(teXObject3 instanceof CharObject) || ((CharObject)teXObject3).getCharCode() != 108) {
                        this.push(teXObject3);
                    } else {
                        TeXObject teXObject4 = this.expandedPopStack(teXParser);
                        if (teXObject4 == null || !(teXObject4 instanceof CharObject) || ((CharObject)teXObject4).getCharCode() != 108) {
                            this.push(teXObject4);
                            return TeXUnit.FIL;
                        }
                        TeXObject teXObject5 = this.expandedPopStack(teXParser);
                        if (teXObject5 == null || teXObject5 instanceof CharObject || ((CharObject)teXObject5).getCharCode() != 108) {
                            this.push(teXObject5);
                            return TeXUnit.FILL;
                        }
                        return TeXUnit.FILLL;
                    }
                }
                this.push(teXObject2);
                this.push(teXObject);
                throw new TeXSyntaxException(teXParser, "tex.error.missing_unit", new Object[0]);
            }
        }
        this.push(teXObject);
        throw new TeXSyntaxException(teXParser, "tex.error.missing_unit", new Object[0]);
    }

    public InternalQuantity popInternalQuantity(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popToken(POP_IGNORE_LEADING_SPACE);
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.internal_quantity_expected", new Object[0]);
        }
        if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof InternalQuantity) {
            return (InternalQuantity)teXObject;
        }
        if (teXObject instanceof Expandable && teXObject.canExpand() && (teXObjectList = this == teXParser ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, this)) != null) {
            this.addAll(0, teXObjectList);
            teXObject = this.popToken(POP_IGNORE_LEADING_SPACE);
            if (teXObject instanceof InternalQuantity) {
                return (InternalQuantity)teXObject;
            }
        }
        throw new TeXSyntaxException(teXParser, "tex.error.internal_quantity_expected_but_found", teXObject.toString(teXParser));
    }

    public Register popRegister(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popToken(POP_IGNORE_LEADING_SPACE);
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.register_expected", new Object[0]);
        }
        if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof Register) {
            return (Register)teXObject;
        }
        if (teXObject instanceof Expandable && (teXObjectList = this == teXParser ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, this)) != null) {
            this.addAll(0, teXObjectList);
            teXObject = this.popToken(POP_IGNORE_LEADING_SPACE);
            if (teXObject instanceof Register) {
                return (Register)teXObject;
            }
        }
        throw new TeXSyntaxException(teXParser, "tex.error.register_expected_but_found", teXObject.toString(teXParser));
    }

    public Numerical popNumerical(TeXParser teXParser) throws IOException {
        int n;
        TeXObject teXObject = this.peekStack(POP_IGNORE_LEADING_SPACE);
        if (teXObject instanceof CharObject && ((n = ((CharObject)teXObject).getCharCode()) == 34 || n == 39 || n == 96 || Character.isDigit(n) || n == 45 || n == 43)) {
            return this.popNumber(teXParser, teXObject);
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
        }
        teXObject = this.expandedPopStack(teXParser, POP_SHORT);
        if (teXObject instanceof NumericRegister) {
            return (NumericRegister)teXObject;
        }
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        this.push(teXObject);
        return this.popNumber(teXParser);
    }

    public TeXDimension popDimension(TeXParser teXParser) throws IOException {
        return this.popDimension(teXParser, true);
    }

    public TeXDimension popDimension(TeXParser teXParser, boolean bl) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser, (byte)(POP_SHORT | POP_IGNORE_LEADING_SPACE));
        if (teXObject instanceof TeXDimension) {
            return (TeXDimension)teXObject;
        }
        this.push(teXObject);
        Float f = this.popFloat(teXParser);
        teXObject = this.expandedPopStack(teXParser);
        if (teXObject instanceof DimenRegister) {
            TeXGlue teXGlue = new TeXGlue(teXParser, (DimenRegister)teXObject);
            teXGlue.multiply(f.floatValue());
            return teXGlue;
        }
        this.push(teXObject);
        TeXUnit teXUnit = this.popUnit(teXParser);
        UserDimension userDimension = new UserDimension(f, teXUnit);
        if (!bl) {
            return userDimension;
        }
        TeXDimension teXDimension = null;
        TeXDimension teXDimension2 = null;
        String string = this.popWord(teXParser);
        if (string.equals("plus")) {
            teXDimension = this.popDimension(teXParser, false);
            string = this.popWord(teXParser);
            if (string.equals("minus")) {
                teXDimension2 = this.popDimension(teXParser, false);
            } else {
                this.addAll(0, teXParser.getListener().createString(string));
            }
        } else if (string.equals("minus")) {
            teXDimension2 = this.popDimension(teXParser, false);
            string = this.popWord(teXParser);
            if (string.equals("plus")) {
                teXDimension = this.popDimension(teXParser, false);
            } else {
                this.addAll(0, teXParser.getListener().createString(string));
            }
        } else {
            this.addAll(0, teXParser.getListener().createString(string));
        }
        if (teXDimension2 == null && teXDimension == null) {
            return userDimension;
        }
        return new TeXGlue(teXParser, userDimension, teXDimension, teXDimension2);
    }

    public Float popFloat(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.expandedPopStack(teXParser);
        StringBuilder stringBuilder = new StringBuilder();
        this.popFloat(teXParser, teXObject, stringBuilder);
        String string = stringBuilder.toString();
        try {
            return Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", string);
        }
    }

    protected void popFloat(TeXParser teXParser, TeXObject teXObject, StringBuilder stringBuilder) throws IOException {
        if (teXObject == null) {
            return;
        }
        String string = teXObject.toString(teXParser);
        try {
            Float.parseFloat(stringBuilder.toString() + string + "0");
        }
        catch (NumberFormatException numberFormatException) {
            this.push(teXObject);
            return;
        }
        stringBuilder.append(string);
        this.popFloat(teXParser, this.expandedPopStack(teXParser), stringBuilder);
    }

    public TeXNumber popNumber(TeXParser teXParser) throws IOException {
        TeXObject teXObject = this.peekStack(POP_IGNORE_LEADING_SPACE);
        return this.popNumber(teXParser, teXObject);
    }

    private TeXNumber popNumber(TeXParser teXParser, TeXObject teXObject) throws IOException {
        int n = 10;
        if (teXObject instanceof CharObject) {
            int n2 = ((CharObject)teXObject).getCharCode();
            if (n2 == 34) {
                this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
                n = 16;
            } else if (n2 == 39) {
                this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
                n = 8;
            } else if (n2 == 96) {
                this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
                TeXObject teXObject2 = this.peekStack();
                if (teXObject2 instanceof Macro) {
                    int n3;
                    this.popStack(teXParser);
                    String string = teXObject2.toString(teXParser);
                    n2 = string.codePointAt(0);
                    int n4 = Character.charCount(n2);
                    if (n2 == teXParser.getEscChar()) {
                        string = string.substring(n4);
                        n2 = string.codePointAt(0);
                        n4 = Character.charCount(n2);
                    }
                    if (n4 < (n3 = string.length())) {
                        int n5;
                        TeXObjectList teXObjectList = new TeXObjectList(n3 - 1);
                        for (int i = n4; i < n3; i += Character.charCount(n5)) {
                            n5 = string.codePointAt(i);
                            teXObjectList.add(teXParser.getListener().getLetter(n5));
                        }
                        this.addAll(0, teXObjectList);
                    } else {
                        this.popLeadingWhiteSpace();
                    }
                    return new UserNumber(n2);
                }
                if (teXObject2 instanceof CharObject) {
                    n2 = ((CharObject)teXObject2).getCharCode();
                    this.popStack(teXParser, POP_IGNORE_LEADING_SPACE);
                    this.popLeadingWhiteSpace();
                    return new UserNumber(n2);
                }
                String string = teXObject2.toString(teXParser);
                n2 = string.codePointAt(0);
                if (Character.charCount(n2) != string.length()) {
                    throw new TeXSyntaxException(teXParser, "tex.error.improper_alphabetic_constant", string);
                }
                return new UserNumber(n2);
            }
        }
        return this.popNumber(teXParser, n);
    }

    public TeXNumber popNumber(TeXParser teXParser, int n) throws IOException {
        this.popLeadingWhiteSpace();
        TeXObject teXObject = this.expandedPopStack(teXParser);
        if (teXObject instanceof TeXNumber) {
            return (TeXNumber)teXObject;
        }
        if (teXObject instanceof Group) {
            return ((Group)teXObject).toList().popNumber(teXParser);
        }
        if (teXObject instanceof ControlSequence) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", teXObject.toString(teXParser));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (teXObject instanceof CharObject && (((CharObject)teXObject).getCharCode() == 43 || ((CharObject)teXObject).getCharCode() == 45)) {
            stringBuilder.appendCodePoint(((CharObject)teXObject).getCharCode());
            teXObject = this.expandedPopStack(teXParser);
        }
        this.popNumber(teXParser, teXObject, stringBuilder, n);
        this.popLeadingWhiteSpace();
        if (stringBuilder.length() == 0) {
            throw new TeXSyntaxException(teXParser, "tex.error.number_expected", teXObject.toString(teXParser));
        }
        return new UserNumber(teXParser, stringBuilder.toString(), n);
    }

    protected void popNumber(TeXParser teXParser, TeXObject teXObject, StringBuilder stringBuilder, int n) throws IOException {
        if (teXObject == null) {
            return;
        }
        String string = teXObject instanceof CharObject ? new String(Character.toChars(((CharObject)teXObject).getCharCode())) : teXObject.toString(teXParser);
        try {
            Integer.parseInt(stringBuilder.toString() + string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.push(teXObject);
            return;
        }
        stringBuilder.append(string);
        this.popNumber(teXParser, this.expandedPopStack(teXParser), stringBuilder, n);
    }

    public ControlSequence popControlSequence(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popArg(teXParser);
        if (teXObject instanceof TeXObjectList && ((teXObject = (teXObjectList = (TeXObjectList)teXObject).popToken()) == null || teXObjectList.peekStack() != null)) {
            throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject == null ? teXObjectList.toString(teXParser) : String.format("%s%s", teXObject.toString(teXParser), teXObjectList.toString(teXParser)), teXObject.getClass().getSimpleName());
        }
        if (!(teXObject instanceof ControlSequence)) {
            throw new TeXSyntaxException(teXParser, "tex.error.cs_expected", teXObject.toString(teXParser), teXObject.getClass().getSimpleName());
        }
        return (ControlSequence)teXObject;
    }

    public boolean isStack() {
        return true;
    }

    public boolean equals(String string) {
        if (!(this instanceof Group)) {
            int n = string.length();
            int n2 = 0;
            for (int i = 0; i < this.size(); ++i) {
                TeXObject teXObject = (TeXObject)this.get(i);
                if (teXObject instanceof Ignoreable) continue;
                if (!(teXObject instanceof CharObject)) {
                    return false;
                }
                if (n2 >= n) {
                    return false;
                }
                int n3 = ((CharObject)teXObject).getCharCode();
                if (n3 != string.codePointAt(n2)) {
                    return false;
                }
                n2 += Character.charCount(n3);
            }
            if (n2 == n) {
                return true;
            }
        }
        return false;
    }

    public void push(TeXObject teXObject) {
        this.push(teXObject, false);
    }

    public void push(TeXObject teXObject, boolean bl) {
        if (teXObject == this) {
            throw new IllegalArgumentException("Can't add list to itself");
        }
        if (teXObject != null) {
            if (bl && teXObject instanceof TeXObjectList && ((TeXObjectList)teXObject).isStack()) {
                TeXObjectList teXObjectList = (TeXObjectList)teXObject;
                for (int i = teXObjectList.size() - 1; i >= 0; --i) {
                    this.push((TeXObject)teXObjectList.get(i), bl);
                }
            } else {
                this.add(0, teXObject);
            }
        }
    }

    @Override
    public void add(int n, TeXObject teXObject) {
        if (teXObject == null) {
            throw new NullPointerException();
        }
        super.add(n, teXObject);
    }

    @Override
    public boolean add(TeXObject teXObject) {
        return this.add(teXObject, false);
    }

    public boolean add(TeXObject teXObject, boolean bl) {
        if (teXObject == null) {
            throw new NullPointerException();
        }
        if (teXObject == this) {
            throw new IllegalArgumentException("Can't add a list to itself");
        }
        if (bl && teXObject instanceof TeXObjectList && ((TeXObjectList)teXObject).isStack()) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            boolean bl2 = false;
            for (int i = 0; i < teXObjectList.size(); ++i) {
                bl2 = this.add((TeXObject)teXObjectList.get(i), bl) || bl2;
            }
            return bl2;
        }
        return super.add(teXObject);
    }

    public TeXObject peek() {
        return this.size() == 0 ? null : (TeXObject)this.firstElement();
    }

    public TeXObject peekLast() {
        return this.size() == 0 ? null : (TeXObject)this.lastElement();
    }

    public TeXObject peekStack() throws IOException {
        return this.peekStack((byte)0);
    }

    public TeXObject peekStack(byte by) throws IOException {
        if (this.size() == 0) {
            return null;
        }
        if (TeXObjectList.isIgnoreLeadingSpace(by)) {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                TeXObject teXObject = (TeXObject)this.get(i);
                if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) continue;
                return teXObject;
            }
        } else {
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                TeXObject teXObject = (TeXObject)this.get(i);
                if (teXObject instanceof Ignoreable) continue;
                return teXObject;
            }
        }
        return null;
    }

    public static boolean isShort(byte by) {
        return (by & POP_SHORT) == POP_SHORT;
    }

    public static boolean isRetainIgnoreables(byte by) {
        return (by & POP_RETAIN_IGNOREABLES) == POP_RETAIN_IGNOREABLES;
    }

    public static boolean isIgnoreLeadingSpace(byte by) {
        return (by & POP_IGNORE_LEADING_SPACE) == POP_IGNORE_LEADING_SPACE;
    }

    public static byte getArgPopStyle(boolean bl) {
        byte by = POP_IGNORE_LEADING_SPACE;
        if (bl) {
            by = (byte)(POP_SHORT | by);
        }
        return by;
    }

    public TeXObject popArg(TeXParser teXParser) throws IOException {
        return this.popArg(teXParser, POP_IGNORE_LEADING_SPACE);
    }

    public TeXObject popArg(TeXParser teXParser, byte by) throws IOException {
        TeXObject teXObject = this.popStack(teXParser, by);
        if (teXObject == null && !(this instanceof TeXParser)) {
            teXObject = teXParser.popNextArg(by);
        }
        if (teXObject instanceof Group && !(teXObject instanceof MathGroup)) {
            return ((Group)teXObject).toList();
        }
        return teXObject;
    }

    public TeXObject popArg(TeXParser teXParser, int n, int n2) throws IOException {
        return this.popArg(teXParser, POP_IGNORE_LEADING_SPACE, n, n2);
    }

    public TeXObject popArg(TeXParser teXParser, byte by, int n, int n2) throws IOException {
        TeXObject teXObject;
        TeXObject teXObject2 = null;
        if (!this.isEmpty() && TeXObjectList.isIgnoreLeadingSpace(by) && this.firstElement() instanceof WhiteSpace) {
            teXObject2 = (TeXObject)this.remove(0);
        }
        if ((teXObject = this.popStack(teXParser, by)) == null && !(this instanceof TeXParser)) {
            teXObject = teXParser.popStack(by);
        }
        if (!(teXObject instanceof CharObject)) {
            this.push(teXObject);
            if (teXObject2 != null) {
                this.push(teXObject2);
            }
            return null;
        }
        CharObject charObject = (CharObject)teXObject;
        if (charObject.getCharCode() != n) {
            this.push(teXObject);
            if (teXObject2 != null) {
                this.push(teXObject2);
            }
            return null;
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        boolean bl = TeXObjectList.isShort(by);
        while ((teXObject = this.pop()) != null) {
            BgChar bgChar = teXParser.isBeginGroup(teXObject);
            if (teXObject instanceof CharObject) {
                charObject = (CharObject)teXObject;
                if (charObject.getCharCode() == n2) {
                    return teXObjectList;
                }
            } else if (bgChar != null) {
                Group group = teXParser.getListener().createGroup();
                this.popRemainingGroup(teXParser, group, by, bgChar);
                teXObject = group;
            } else if (bl && teXObject.isPar()) break;
            teXObjectList.add(teXObject);
        }
        throw new TeXSyntaxException(teXParser, "tex.error.missing_closing", "" + n2);
    }

    public Numerical popNumericalArg(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popArg(teXParser, POP_SHORT);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser, this)) != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popNumerical(teXParser);
        }
        return new UserNumber(teXParser, teXObject.toString(teXParser));
    }

    public Numerical popNumericalArg(TeXParser teXParser, int n, int n2) throws IOException {
        TeXObjectList teXObjectList;
        TeXObject teXObject = this.popArg(teXParser, POP_SHORT, n, n2);
        if (teXObject == null) {
            return null;
        }
        if (teXObject instanceof Numerical) {
            return (Numerical)teXObject;
        }
        if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(teXParser, this)) != null) {
            teXObject = teXObjectList;
        }
        if (teXObject instanceof TeXObjectList) {
            return ((TeXObjectList)teXObject).popNumerical(teXParser);
        }
        return new UserNumber(teXParser, teXObject.toString(teXParser));
    }

    @Override
    public TeXObjectList toLowerCase(TeXParser teXParser) {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof CaseChangeable) {
                teXObjectList.add(((CaseChangeable)((Object)teXObject)).toLowerCase(teXParser));
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                if (teXObject instanceof Primitive || teXObject instanceof MathSymbol) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                ControlSequence controlSequence = teXParser.getControlSequence(((ControlSequence)teXObject).getName().toLowerCase());
                if (controlSequence == null) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                teXObjectList.add(controlSequence);
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList toUpperCase(TeXParser teXParser) {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof CaseChangeable) {
                teXObjectList.add(((CaseChangeable)((Object)teXObject)).toUpperCase(teXParser));
                continue;
            }
            if (teXObject instanceof ControlSequence) {
                if (teXObject instanceof Primitive || teXObject instanceof MathSymbol) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                ControlSequence controlSequence = teXParser.getControlSequence(((ControlSequence)teXObject).getName().toUpperCase());
                if (controlSequence == null) {
                    teXObjectList.add(teXObject);
                    continue;
                }
                teXObjectList.add(controlSequence);
                continue;
            }
            teXObjectList.add(teXObject);
        }
        return teXObjectList;
    }

    public TeXObjectList createList() {
        return new TeXObjectList(this.capacity());
    }

    @Override
    public Object clone() {
        TeXObjectList teXObjectList = this.createList();
        for (TeXObject teXObject : this) {
            teXObjectList.add((TeXObject)teXObject.clone());
        }
        for (Declaration declaration : this.declarations) {
            teXObjectList.declarations.add((Declaration)declaration.clone());
        }
        return teXObjectList;
    }

    protected void flatten() {
        for (int i = this.size() - 1; i >= 0; --i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (!(teXObject instanceof TeXObjectList)) continue;
            ((TeXObjectList)teXObject).flatten();
            if (!((TeXObjectList)teXObject).isStack()) continue;
            this.remove(i);
            this.addAll(i, (TeXObjectList)teXObject);
        }
    }

    public void stripIgnoreables() {
        for (int i = this.size() - 1; i >= 0; --i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (teXObject instanceof Ignoreable) {
                this.remove(i);
                continue;
            }
            if (!(teXObject instanceof TeXObjectList)) continue;
            ((TeXObjectList)teXObject).stripIgnoreables();
            if (!((TeXObjectList)teXObject).isStack()) continue;
            this.remove(i);
            if (teXObject.isEmpty()) continue;
            this.addAll(i, (TeXObjectList)teXObject);
        }
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        if (this.isEmpty()) {
            return this;
        }
        this.flatten();
        TeXObjectList teXObjectList = new TeXObjectList(this.size());
        TeXObjectList teXObjectList2 = (TeXObjectList)this.clone();
        boolean bl = false;
        block0: while (!teXObjectList2.isEmpty()) {
            TeXObject teXObject = teXObjectList2.pop();
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)).isExpansionBlocker()) {
                bl = true;
            }
            Vector vector = null;
            if (teXObject instanceof Unexpanded) {
                teXObject = teXObjectList2.popArg(teXParser);
            } else if (!bl && teXObject.canExpand() && teXObject instanceof Expandable) {
                vector = ((Expandable)((Object)teXObject)).expandonce(teXParser, teXObjectList2);
            }
            if (vector == null) {
                teXObjectList.add(teXObject);
                continue;
            }
            for (int i = 0; i < vector.size(); ++i) {
                teXObject = (TeXObject)vector.get(i);
                if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)).isExpansionBlocker()) {
                    teXObjectList.add(teXObject);
                    for (int j = i + 1; j < vector.size(); ++j) {
                        teXObjectList.add((TeXObject)vector.get(j));
                    }
                    bl = true;
                    continue block0;
                }
                teXObjectList.add(teXObject);
            }
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.isEmpty()) {
            return this;
        }
        this.flatten();
        TeXObjectList teXObjectList2 = new TeXObjectList(this.size());
        TeXObjectList teXObjectList3 = (TeXObjectList)this.clone();
        boolean bl = false;
        StackMarker stackMarker = null;
        boolean bl2 = false;
        if (teXObjectList != null && teXObjectList != teXParser) {
            stackMarker = new StackMarker();
            teXObjectList3.add(stackMarker);
            teXObjectList3.addAll(teXObjectList);
            teXObjectList.clear();
        }
        block0: while (!teXObjectList3.isEmpty()) {
            TeXObject teXObject = teXObjectList3.pop();
            if (teXObject.equals(stackMarker)) {
                bl2 = true;
                break;
            }
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)).isExpansionBlocker()) {
                bl = true;
            }
            Vector vector = null;
            if (teXObject instanceof Unexpanded) {
                teXObject = teXObjectList3.popArg(teXParser);
            } else if (!bl && teXObject.canExpand() && teXObject instanceof Expandable) {
                vector = ((Expandable)((Object)teXObject)).expandonce(teXParser, teXObjectList3);
            }
            if (vector == null) {
                teXObjectList2.add(teXObject);
                continue;
            }
            for (int i = 0; i < vector.size(); ++i) {
                int n;
                teXObject = (TeXObject)vector.get(i);
                if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)).equals(stackMarker)) {
                    for (n = i + 1; n < vector.size(); ++n) {
                        teXObjectList.add((TeXObject)vector.get(n));
                    }
                    bl2 = true;
                    continue block0;
                }
                if (teXObject.isExpansionBlocker()) {
                    teXObjectList2.add(teXObject);
                    for (n = i + 1; n < vector.size(); ++n) {
                        teXObjectList2.add((TeXObject)vector.get(n));
                    }
                    bl = true;
                    continue block0;
                }
                teXObjectList2.add(teXObject);
            }
        }
        if (!teXObjectList3.isEmpty()) {
            if (stackMarker != null && !bl2) {
                int n;
                int n2 = teXObjectList3.indexOf(stackMarker);
                for (n = 0; n < n2; ++n) {
                    teXObjectList2.add((TeXObject)teXObjectList3.get(n));
                }
                for (n = n2 + 1; n < teXObjectList3.size(); ++n) {
                    teXObjectList.add((TeXObject)teXObjectList3.get(n));
                }
            } else {
                teXObjectList.addAll(teXObjectList3);
            }
        }
        return teXObjectList2;
    }

    @Override
    public boolean isDataObject() {
        return false;
    }

    @Override
    public boolean isExpansionBlocker() {
        return false;
    }

    @Override
    public boolean canExpand() {
        return !this.isExpanded();
    }

    public boolean isExpanded() {
        for (int i = 0; i < this.size(); ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (!teXObject.canExpand()) continue;
            return false;
        }
        return true;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList(this.size());
        if (this.isExpanded()) {
            teXObjectList.add(this, true);
            this.clear();
            return teXObjectList;
        }
        boolean bl = false;
        TeXObject teXObject = null;
        while (!this.isEmpty()) {
            TeXObject teXObject2 = this.pop();
            if (teXObject2 == teXObject) {
                teXObjectList.add(teXObject2);
                continue;
            }
            teXObject = teXObject2;
            if ((teXObject2 = TeXParserUtils.resolve(teXObject2, teXParser)).isExpansionBlocker()) {
                bl = true;
            }
            if (teXObject2 instanceof StackMarker || bl) {
                teXObjectList.add(teXObject2);
                continue;
            }
            if (teXObject2 instanceof Ignoreable) continue;
            if (teXObject2 instanceof Unexpanded) {
                teXObjectList.add(this.popArg(teXParser));
                continue;
            }
            if (teXParser.isStack(teXObject2)) {
                this.push(teXObject2, true);
                continue;
            }
            if (teXObject2 instanceof Expandable) {
                TeXObjectList teXObjectList2 = ((Expandable)((Object)teXObject2)).expandfully(teXParser, this);
                if (teXObjectList2 == null) {
                    teXObjectList.add(teXObject2);
                    continue;
                }
                if (teXObjectList2.isEmpty()) continue;
                teXObjectList.add(teXObjectList2, true);
                continue;
            }
            teXObjectList.add(teXObject2);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        TeXObjectList teXObjectList2 = new TeXObjectList(this.size());
        if (this.isExpanded()) {
            teXObjectList2.add(this, true);
            this.clear();
            return teXObjectList2;
        }
        boolean bl = false;
        this.flatten();
        TeXObjectList teXObjectList3 = (TeXObjectList)this.clone();
        StackMarker stackMarker = null;
        if (teXObjectList != null && teXObjectList != teXParser) {
            stackMarker = new StackMarker();
            teXObjectList3.add(stackMarker);
            teXObjectList3.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (!teXObjectList3.isEmpty() && !(teXObject = teXObjectList3.pop()).equals(stackMarker)) {
            if (teXObject instanceof Ignoreable) continue;
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)).isExpansionBlocker()) {
                bl = true;
            }
            TeXObjectList teXObjectList4 = null;
            if (teXObject instanceof Unexpanded) {
                teXObject = teXObjectList3.popArg(teXParser);
            } else if (!bl && teXObject.canExpand() && teXObject instanceof Expandable) {
                teXObjectList4 = ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList3);
            }
            if (teXObjectList4 == null) {
                teXObjectList2.add(teXObject);
                continue;
            }
            teXObjectList2.add(teXObjectList4, true);
        }
        if (!teXObjectList3.isEmpty()) {
            teXObjectList.addAll(teXObjectList3);
        }
        return teXObjectList2;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.flatten();
        if (teXParser.isDebugMode(128)) {
            teXParser.logMessage("PROCESSING STACK: " + this.toString(teXParser));
        }
        if (teXParser.isDebugMode(256)) {
            teXParser.logMessage("PROCESSING STACK: " + this.toString());
        }
        while (this.size() > 0) {
            TeXObject teXObject = (TeXObject)this.remove(0);
            if (teXParser.isDebugMode(2)) {
                teXParser.logMessage("POPPED " + teXObject);
            }
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof Declaration) {
                if (teXParser.isDebugMode(4)) {
                    teXParser.logMessage("PUSHING DECLARATION " + teXObject);
                }
                this.pushDeclaration((Declaration)teXObject);
            } else if (teXObject instanceof EndDeclaration) {
                Declaration declaration = ((EndDeclaration)teXObject).getDeclaration(teXParser);
                if (teXParser.isDebugMode(4)) {
                    teXParser.logMessage("POPPING DECLARATION " + declaration);
                }
                this.popDeclaration(declaration);
            }
            if (teXObject instanceof Ignoreable) continue;
            if (teXParser.isDebugMode(64)) {
                teXParser.logMessage("PROCESSING " + teXObject);
            }
            teXObject.process(teXParser, this);
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.flatten();
        if (teXParser.isDebugMode(128)) {
            teXParser.logMessage("PROCESSING STACK: " + this.toString(teXParser) + " SUBSTACK: " + teXObjectList.toString(teXParser));
            if (teXParser.isDebugMode(256)) {
                teXParser.logMessage("PROCESSING STACK: " + this.toString() + " SUBSTACK: " + teXObjectList);
            }
        }
        StackMarker stackMarker = null;
        if (teXObjectList != teXParser && teXObjectList != null) {
            stackMarker = new StackMarker();
            this.add(stackMarker);
            this.addAll(teXObjectList);
            teXObjectList.clear();
        }
        while (this.size() > 0) {
            TeXObject teXObject = (TeXObject)this.remove(0);
            if (teXParser.isDebugMode(2)) {
                teXParser.logMessage("POPPED " + teXObject);
            }
            if (teXObject.equals(stackMarker)) break;
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof Declaration) {
                if (teXParser.isDebugMode(4)) {
                    teXParser.logMessage("PUSHING DECLARATION " + teXObject);
                }
                this.pushDeclaration((Declaration)teXObject);
            } else if (teXObject instanceof EndDeclaration) {
                Declaration declaration = ((EndDeclaration)teXObject).getDeclaration(teXParser);
                if (teXParser.isDebugMode(4)) {
                    teXParser.logMessage("POPPING DECLARATION " + declaration);
                }
                this.popDeclaration(declaration);
            }
            if (teXObject instanceof Ignoreable) continue;
            if (teXParser.isDebugMode(64)) {
                teXParser.logMessage("PROCESSING " + teXObject);
            }
            teXObject.process(teXParser, this);
        }
        if (!this.isEmpty()) {
            teXObjectList.addAll(0, this);
            this.clear();
        }
    }

    protected void processList(TeXParser teXParser, StackMarker stackMarker) throws IOException {
        TeXObject teXObject;
        TeXObjectList teXObjectList = new TeXObjectList();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        MidControlSequence midControlSequence = null;
        for (int i = 0; i < this.size() && !(teXObject = (TeXObject)this.get(i)).equals(stackMarker) && (teXObject = TeXParserUtils.resolve(teXObject, teXParser)) != null; ++i) {
            if (teXObject instanceof MidControlSequence) {
                midControlSequence = (MidControlSequence)teXObject;
                continue;
            }
            if (midControlSequence == null) {
                teXObjectList.add(teXObject);
                continue;
            }
            teXObjectList2.add(teXObject);
        }
        if (midControlSequence == null) {
            teXObjectList = null;
            teXObjectList2 = null;
            while (this.size() != 0) {
                TeXObject teXObject2 = (TeXObject)this.remove(0);
                if (teXParser.isDebugMode(64)) {
                    teXParser.logMessage("PROCESS LIST OBJ: " + teXObject2);
                }
                if (!teXObject2.equals(stackMarker) && teXObject2 != null) {
                    if ((teXObject2 = TeXParserUtils.resolve(teXObject2, teXParser)) instanceof Declaration) {
                        if (teXParser.isDebugMode(4)) {
                            teXParser.logMessage("PUSHING DECLARATION " + teXObject2);
                        }
                        this.pushDeclaration((Declaration)teXObject2);
                    } else if (teXObject2 instanceof EndDeclaration) {
                        teXObject = ((EndDeclaration)teXObject2).getDeclaration(teXParser);
                        if (teXParser.isDebugMode(4)) {
                            teXParser.logMessage("POPPING DECLARATION " + teXObject);
                        }
                        this.popDeclaration((Declaration)teXObject);
                    }
                    teXObject2.process(teXParser, this);
                    continue;
                }
                break;
            }
        } else {
            this.clear();
            midControlSequence.process(teXParser, teXObjectList, teXObjectList2);
        }
        this.processEndDeclarations(teXParser);
    }

    protected String toStringExtraIdentifier() {
        return "";
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        if (this.stackID >= 0L) {
            stringBuilder.append("#" + this.stackID);
        }
        stringBuilder.append(this.toStringExtraIdentifier());
        stringBuilder.append('[');
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if (teXObject instanceof CharObject) {
                stringBuilder.append('\'');
                stringBuilder.append(teXObject.toString());
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(teXObject.toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            stringBuilder.append(teXObject.format());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            stringBuilder.append(teXObject.toString(teXParser));
            if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).isControlWord(teXParser) || i >= n - 1) continue;
            teXObject = (TeXObject)this.get(i + 1);
            if (teXObject instanceof Letter) {
                stringBuilder.append(" ");
                continue;
            }
            if (!(teXObject instanceof TeXObjectList) || teXObject instanceof Group) continue;
            ++i;
            String string = ((TeXObjectList)teXObject).toString(teXParser);
            if (string.isEmpty()) continue;
            if (teXParser.isLetter(string.charAt(0))) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String substring(TeXParser teXParser, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            TeXObject teXObject = (TeXObject)this.get(i);
            stringBuilder.append(teXObject.toString(teXParser));
            if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).isControlWord(teXParser) || i >= n2 - 1) continue;
            teXObject = (TeXObject)this.get(i + 1);
            if (teXObject instanceof Letter) {
                stringBuilder.append(" ");
                continue;
            }
            if (!(teXObject instanceof TeXObjectList) || teXObject instanceof Group) continue;
            ++i;
            String string = ((TeXObjectList)teXObject).toString(teXParser);
            if (string.isEmpty()) continue;
            if (teXParser.isLetter(string.charAt(0))) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        if (this.size() == 0) {
            return this;
        }
        TeXObjectList teXObjectList = this.pop().string(teXParser);
        this.addAll(0, teXObjectList);
        return this;
    }

    public void pushDeclaration(Declaration declaration) {
        this.declarations.add(declaration);
    }

    public Declaration popDeclaration(Declaration declaration) {
        for (int i = this.declarations.size() - 1; i >= 0; --i) {
            if (!this.declarations.get(i).equals(declaration)) continue;
            return this.declarations.remove(i);
        }
        return null;
    }

    public void processEndDeclarations(TeXParser teXParser) throws IOException {
        while (this.declarations.size() > 0) {
            this.declarations.remove(this.declarations.size() - 1).end(teXParser, this);
        }
    }

    @Override
    public boolean isPar() {
        return this.size() == 1 && ((TeXObject)this.firstElement()).isPar();
    }

    public boolean popRemainingGroup(TeXParser teXParser, Group group, byte by, BgChar bgChar) throws IOException {
        while (this.size() > 0) {
            TeXObject teXObject = this.pop();
            EgChar egChar = teXParser.isEndGroup(teXObject);
            if (egChar != null) {
                if (!egChar.matches(bgChar)) {
                    throw new TeXSyntaxException(teXParser, "tex.error.extra_or_forgotten", egChar.toString(teXParser), bgChar.toString(teXParser));
                }
                return true;
            }
            BgChar bgChar2 = teXParser.isBeginGroup(teXObject);
            if (TeXObjectList.isShort(by) && teXObject.isPar()) {
                throw new TeXSyntaxException(teXParser, "tex.error.par_before_eg", new Object[0]);
            }
            if (bgChar2 != null) {
                Group group2 = bgChar2.createGroup(teXParser);
                if (!this.popRemainingGroup(teXParser, group2, by, bgChar2)) {
                    group.add(group2);
                    return false;
                }
                group.add(group2);
                continue;
            }
            group.add(teXObject);
        }
        return false;
    }

    public boolean containsVerbatimCommand(TeXParser teXParser) {
        for (int i = 0; i < this.size(); ++i) {
            ControlSequence controlSequence;
            TeXObject teXObject = (TeXObject)this.get(i);
            if (!(teXObject instanceof ControlSequence ? teXParser.isVerbCommand((controlSequence = (ControlSequence)teXObject).getName()) : teXObject instanceof TeXObjectList && ((TeXObjectList)teXObject).containsVerbatimCommand(teXParser))) continue;
            return true;
        }
        return false;
    }

    public TeXObjectList trim() {
        while (this.size() > 0 && (this.firstElement() instanceof WhiteSpace || this.firstElement() instanceof Ignoreable)) {
            this.remove(0);
        }
        while (this.size() > 0 && (this.lastElement() instanceof WhiteSpace || this.lastElement() instanceof Ignoreable)) {
            this.remove(this.size() - 1);
        }
        if (this.size() == 1 && this.get(0) instanceof Group) {
            return ((Group)this.get(0)).toList();
        }
        return this;
    }

    @Override
    public String purified() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(((TeXObject)this.get(i)).purified());
        }
        return stringBuilder.toString();
    }
}

