#!/usr/bin/env bash
# This shell script does two things. First, it generates eps and pdf versions of
# all the faces in /svg. Second, it also echoes a good approximation of what
# should be in f7u12.sty. There are a few snafus it doesn't protect against. In
# particular, \smile is already a LaTeX command (It's for math stuff), so I just
# did a newcommand -> renewcommand by-hand. If you need the original \smile, you
# can always \newcommand it yourself, I guess.


echo "\ProvidesPackage{f7u12}"
echo "\usepackage{graphicx}"

for f in svg/*.svg; do
    #I'm sure there's a better way to do this
    g=`echo $f | sed 's/svg/faces/;s/.svg/.eps/'`
    h=`echo $f | sed 's/svg/faces/;s/.svg/.pdf/'`
    i=`echo $f | sed 's#svg/##;s#.svg##;s/-//g;'`
    #inkscape -Dz --file=$f --export-eps=$g
    #inkscape -Dz --file=$f --export-pdf=$h
    echo "\newcommand{\\$i}[1][1.2 em]{\includegraphics[width=#1]{faces/$i}}"
done
