/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef vector_h
#define vector_h

#include <math.h>
#include <string.h>

/* Indices for vector components. */
enum {
	X, Y, Z
};

/* Vector data type. */
typedef float   Vector[3];

/* Copy vector v1 to vector v0. */
#define vector_copy(v0, v1) (memcpy(v0, v1, sizeof(Vector)))

/* Calculate norm of vector v. */
#define vector_norm(v) ((float) sqrt(v[X] * v[X] + v[Y] * v[Y] + v[Z] * v[Z]))

/* Subtract vector v1 from vector v0. */
#define vector_sub(v0, v1) { v0[X] -= v1[X]; v0[Y] -= v1[Y]; v0[Z] -= v1[Z]; }

#endif
