/*
 * TEMPO - Topographic Eeg Mapping PrOgram.
 * 
 * Copyright (C) 1995, 1996, 2003, 2004 Aleksandar B. Samardzic
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef scene_h
#define scene_h

#include "object.h"

/* Scene object data type. */
typedef struct {
	Object         *mapped, *copy;	/* Part of scene that score values
					 * are mapped across and its copy. */
	Object         *not_mapped;	/* Part of scene that is not mapped. */
	Vector          axis;	/* Cumulative rotation axis. */
	float           angle;	/* Cumulative rotation angle. */
}               Scene;

/*
 * Create scene object.  Arguments are filenames to read mapped and not
 * mapped parts of scene from.
 */
Scene          *scene_create(char *mapped, char *not_mapped);

/* Destroy scene object. */
void            scene_destroy(Scene * scene);

/* Render scene to window of dimension given as second and third argument. */
void            scene_render(Scene * scene, int width, int height);

#endif
